package jnormaliz;

/**
 * File name utility methods to deal with Normaliz input files, given
 * that the extension .in is required
 */
public class FileUtils {

    /**
     * Returns the supplied filename without the extension ".in"
     * @param filename
     * @return filename without ".in"
     */
    static public String stripInExtension(String filename) {
        String splitted[] = filename.split(".in\\z");

        if(splitted == null)
            throw new RuntimeException("Input file name without .in extension");

        return splitted[0];
    }

    /**
     * Given a filename with ".in" extension, returns a new filename with
     * the extension changed to ".out"
     * @param inFileName filename with ".in" extension
     * @return the same filename but with extension ".out"
     */
    public static String makeOutFileName(String inFileName) {
        return stripInExtension(inFileName) + ".out";
    }
    /**
     * Given a filename with ".in" extension, returns a new filename with
     * the extension changed to ".intOut"
     * @param inFileName filename with ".in" extension
     * @return the same filename but with extension ".intOut"
     */
    public static String makeOutFileNameNmzIntegrate(String inFileName) {
        return stripInExtension(inFileName) + ".intOut";
    }
}
