/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <libgnomeui/gnome-ui-init.h>
#include <stdlib.h>
#include <libintl.h>
#include <locale.h>

#include "ui/interface.h"
#include "nb_global.h"

#define _(text) gettext(text)

GladeXML * xml;
GladeXML * xmlexport;
global * g;

int
main (int argc, gchar * argv[])
{
	GnomeProgram * program;

	#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	#endif

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	gconf_init(argc, argv, NULL);

	program = gnome_program_init (PACKAGE, VERSION,
				      LIBGNOMEUI_MODULE, argc, argv,
				      GNOME_PARAM_HUMAN_READABLE_NAME, _("Notebook"),
				      NULL);

	g = nb_global_new ();

	create_mainwindow ();

	if ( nb_notelist_load_from_file (g->nl) )
	{
		update_tree_with_result ("");
		push_statusbar ( g_strdup_printf ( _("Successfully loaded %d notes."), g->nl->notes->len));
	}

	gtk_main ();

	free (g);
	return 0;
}

