/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __NB_GLOBAL_H__
#define __NB_GLOBAL_H__

#define DEFAULT_CONFIG_DIR ".notebook"
#define DEFAULT_CONFIG_FILE "config"
#define DEFAULT_NOTES_FILE "notes.xml"

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#include "nb_note.h"
#include "nb_noteList.h"

enum {
	NEW,
	INSERTED
};

enum {
	CLEAN,
	EDITED,
};

typedef struct _global	global;

struct _global
{
	note * current_note;
	short int inserted_note;
	short int modified_note;
	notelist * nl;
	GtkListStore * store;
	gchar * default_browser;
};

global	*nb_global_new			(void);

void	nb_global_new_note		(global * g);

void 	nb_global_delete_note		(global * g);

gboolean nb_global_delete_note_from_file (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, GList **rowref_list);

void	nb_global_update_note		(global * g);

/* return 0 if ok, or -1 if the note isn't well formed (i.e: the title is missing) */
gboolean	nb_global_save_note		(global * g);

void	nb_global_add_note_to_tree	(global * g);

void	nb_global_update_tree_with_current	(global * g);

gchar * nb_global_parse_config 	(global * g);

void	nb_global_browser_changed_callback 	(GConfClient *client, guint cnxn_id, GConfEntry *entry, gpointer user_data);

void	nb_global_import_notelist (global * g, const gchar * filename);

void	nb_global_export_notelist (global * g, exporttype * etype, const gchar * filename);

gboolean 	nb_global_quit (global * g);

#endif
