/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#include <gtk/gtk.h>

#include "../nb_note.h"
#include "../nb_noteList.h"

enum
{
	TITLE_COLUMN,
	TYPE_COLUMN,
	STATUS_COLUMN,
	DATE_COLUMN,
	LAST_UPDATE_COLUMN,
	NOTE_POINTER_COLUMN,
	N_COLUMNS
};

enum
{
	TARGET_STRING,
	TARGET_URL
};

static GtkTargetEntry dragdroptarget[] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
};

typedef struct _format_textview format_textview;

struct _format_textview
{
	GdkCursorType current_cursor;
	GdkCursor * hand_cursor;
	GdkCursor * text_cursor;
};

void 	create_mainwindow	(void);

void 	create_tree	(void);

void 	create_textview	(void);

void 	blank_fields	(void);

void 	clear_tree_view (void);

gboolean is_empty_note	(void);

void 	set_sort_func	(GtkListStore * store);

void 	add_note_to_tree	(gchar * title, gchar * type, gchar * status, gchar * date, gchar * last_update, note * n, gboolean scroll);

void 	update_tree_with_current	(gchar * title, gchar * type, gchar * status, gchar * last_update);

void 	set_fields_value	(gchar * title, gchar * text, int type, int status, gchar * date);

void 	reset_option_menu	(void);

void 	update_tree_with_result	(gchar * query);

void 	import_notes_from_file	(void);

void 	export_notes_to_file	(void);

gchar 	* get_current_date	(void);

void	push_statusbar	(gchar * text);

void 	set_cursor_if_appropriate	(GtkTextView * text_view, int x, int y);

void 	store_interface_positions	(void);

void 	load_interface_positions	(void);

void 	create_about_dialog 	(void);
