# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2012-2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

from ubuntuuitoolkit import emulators as uitk


class NotesApp(uitk.MainView):

    """An emulator class that makes it easy to interact with the notes app."""

    def get_notes(self):
        return self.select_many("NoteItem")

    def get_header(self):
        return self.select_single("Header")

    def wait_collapsed_note_filled(self, note_item):
        if (note_item.noteText):
            collapsed_note = note_item.select_single("CollapsedNote")
            collapsed_note.filled.wait_for(True)

    def get_note_content(self, note_item):
        return note_item.select_single("MixedEdit")

    def get_note_parts(self, note_item):
        edit = note_item.select_single("MixedEdit")
        parts = edit.select_single(
            "QQuickColumn").get_children_by_type("QQuickLoader")
        return parts

    def get_keyboard_rectangle(self):
        return self.select_single("KeyboardRectangle")
