/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef FREE_REPLACEABLE_H

#define  FREE_REPLACEABLE_H
#include "config.h"
#include <gtk/gtk.h>
#include <cairo.h>

#define FREE_PLACEABLE_VOLSIGN 1
#define FREE_PLACEABLE_TEMPO 2
#define FREE_PLACEABLE_SLUR_POINT 3
#define FREE_PLACEABLE_LINE_POINT 4
#define FREE_PLACEABLE_TEXT 5

class NedChordOrRest;

class NedFreeReplaceable {
	public:
		NedFreeReplaceable();
		NedFreeReplaceable(NedChordOrRest *element);
		NedFreeReplaceable(NedChordOrRest *element, double x, double y, bool relative);
		virtual NedFreeReplaceable *clone(NedChordOrRest *newelement) = 0;
		void setXY(double x, double y, bool relative);
		void setElement(NedChordOrRest *element);
		void freeFromElement();
		virtual ~NedFreeReplaceable() {}
		virtual void draw(cairo_t *cr, double leftx, double topy, double zoom_factor, int zoom_level) = 0;
		bool trySelect(double xl, double yl, double zoom_factor, double leftx, double topy);
		virtual void shift(double x, double y, double zoom_factor, double leftx, double topy);
		virtual void shiftOnlyX(double x, double y, double zoom_factor, double leftx, double topy);
		virtual void shiftOnlyY(int staff_nr, double y, double zoom_factor, double leftx, double topy);
		virtual void toRel();
		void drawConnection(cairo_t *cr, double xpos, double ypos, double leftx, double topy, double zoom_factor);
		double getX() {return m_x;}
		double getY() {return m_y;}
		double getAbsoluteX();
		double getAbsoluteY();
		virtual bool isActive();
		virtual void startContextDialog(GtkWindow *ref) = 0;
		virtual int getType() = 0;
		void virtual recompute() {};
		double getYposRelative() {return m_yrel;}
		NedChordOrRest *getElement() {return m_element;}
		virtual bool less_than(NedFreeReplaceable *other);
	protected:
		double m_x, m_y;
		bool m_abs;
		NedChordOrRest *m_element;

		void setThis();
		void getXYPos(double *xpos, double *ypos);
		void toAbs();
		bool m_is_abs;
	private:
		NedChordOrRest *m_element_at_move_start;
		double m_x_at_start, m_y_at_start;
		double m_last_ref_x, m_last_ref_y, m_last_elements_y;
		double m_yrel;

	friend class NedFixMovedFreePlaceableCommand;
	friend class NedRemoveFreePlaceableCommand;
	friend class NedOctavation;
	friend class NedAcceleration;


};

#endif /* FREE_REPLACEABLE_H */
