/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include <math.h>
#include "freetext.h"
#include "chordorrest.h"
#include "textdialog.h"
#include "staff.h"
#include "system.h"
#include "page.h"

#define X_POS_PAGE_REL(p) ((m_element->getPage()->getContetXpos() + (p)) * zoom_factor - leftx)
#define Y_POS_PAGE_REL(p) ((p) * zoom_factor - topy)

NedFreeText::NedFreeText(char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume,
		char *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight) : NedFreeReplaceable(),
		m_midi_volume(volume), m_enable_volume_change(enable_volume), m_enable_tempo_change(enable_tempo), m_font_family(font_family),
		m_font_size(font_size), m_font_slant(font_slant), m_font_weight(font_weight), m_tempo(tempo) {
		m_text = strdup(text);
}

NedFreeText::NedFreeText(char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume,
		char *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight, NedChordOrRest *element) : NedFreeReplaceable(element), 
			m_midi_volume(volume), m_enable_volume_change(enable_volume), m_enable_tempo_change(enable_tempo), m_font_family(font_family),
			m_font_size(font_size), m_font_slant(font_slant), m_font_weight(font_weight), m_tempo(tempo) {
			m_text = strdup(text);
}

NedFreeText::NedFreeText(char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume,
		char *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight, NedChordOrRest *element, double x, double y, bool relative) :
	NedFreeReplaceable(element, x, y, relative), 
		m_midi_volume(volume), m_enable_volume_change(enable_volume), m_enable_tempo_change(enable_tempo), m_font_family(font_family),
		m_font_size(font_size), m_font_slant(font_slant), m_font_weight(font_weight), m_tempo(tempo)  {
		m_text = strdup(text);
}


NedFreeReplaceable *NedFreeText::clone(NedChordOrRest *newelement) {
	char *nfamily;

	if ((nfamily = (char *) g_malloc(strlen(m_font_family) + 1)) == NULL) {
		NedResource::Abort("NedFreeText::clone");
	}
	strcpy(nfamily, m_font_family);
	NedFreeText *freetext = new NedFreeText(m_text, m_tempo, m_enable_tempo_change, m_midi_volume, m_enable_volume_change,
		nfamily, m_font_size, m_font_slant, m_font_weight, newelement, m_x, m_y, true);
	return freetext;
}

void NedFreeText::startContextDialog(GtkWindow *ref) {
	bool state;
	char *newtext;
	gchar *newfont_family;
	cairo_font_slant_t newfont_slant;
	cairo_font_weight_t newfont_weight;
	bool newenable_volume;
	bool newenable_tempo;
	unsigned int newvolume;
	unsigned int newtempo;
	double newfont_size;

	NedTextDialog *dialog = new NedTextDialog (GTK_WINDOW(ref), m_text, m_tempo, m_enable_tempo_change, m_midi_volume, m_enable_volume_change,
		m_font_family, m_font_size, m_font_slant, m_font_weight);
	dialog->getValues(&state, &newtext, &newtempo, &newenable_tempo, &newvolume, &newenable_volume, &newfont_family, &newfont_size, &newfont_slant, &newfont_weight);
	if (state) {
		if (newtext != NULL) {
			if (strlen(newtext) > 0) {
			/*
				if (m_text != NULL) {
					free(m_text);
				}
				*/
				m_text = strdup(newtext);
				m_tempo = newtempo;
				m_enable_tempo_change = newenable_tempo;
				m_midi_volume = newvolume;
				m_enable_volume_change = newenable_volume;
				m_font_family = newfont_family;
				m_font_size = newfont_size;
				m_font_slant = newfont_slant;
				m_font_weight =newfont_weight;
			}
		}
	}
}

void NedFreeText::draw(cairo_t *cr, double leftx, double topy, double zoom_factor, int zoom_level) {
	if (m_element == NULL) return;

	double xpos, ypos;

	getXYPos(&xpos, &ypos);

	cairo_new_path(cr);
	if (isActive()) {
		cairo_set_source_rgb (cr, 1.0, 0.0, 0.0);
	}
	cairo_select_font_face(cr, m_font_family, m_font_slant, m_font_weight);
	cairo_set_font_size(cr, m_font_size * zoom_factor);
	cairo_move_to(cr, X_POS_PAGE_REL(xpos), Y_POS_PAGE_REL(ypos));
	cairo_show_text(cr, m_text);

	cairo_set_font_face(cr, NedResource::getFontFace());
	cairo_set_font_matrix(cr, NedResource::getFontMatrix(zoom_level));
	cairo_stroke(cr);
	if (isActive()) {
		cairo_set_source_rgb (cr, 0.0, 0.0, 0.0);
	}
	if (m_is_abs) {
		drawConnection(cr, xpos, ypos, leftx, topy, zoom_factor);
	}
}

double NedFreeText::getTempoInverse() {
	return 60000.0 / (double) m_tempo;
}

void NedFreeText::setText(char *text) {
	if (m_text != NULL) {
		free(m_text);
	}
	m_text = strdup(text);
}
