--
-- (C) 2013 - ntop.org
--

dirs = ntop.getDirs()
package.path = dirs.installdir .. "/scripts/lua/modules/?.lua;" .. package.path

require "persistence"

function getTopTalkers(ifname, mode, epoch)
   -- if(ifname == nil) then ifname = "any" end

   if(epoch ~= nil) then
      rsp = getHistoricalTopTalkers(ifname, mode, epoch)
   else
      rsp = getActualTopTalkers(ifname, mode)
   end

   return(rsp)
end


-- #################################################

function getHistoricalTopTalkers(ifname, mode, epoch)
   epoch = epoch - (epoch % 60)
   dirs = ntop.getDirs()
   filename = fixPath(dirs.workingdir .. "/".. purifyInterfaceName(ifname) .. "/top_talkers/" .. os.date("%Y/%m/%d/%H", epoch) .. os.date("/%M.json", epoch))

   if(ntop.exists(filename)) then
      f = io.open(filename, "r")
      if(f) then
	 rsp = ""
	 while(true) do
	    line = f:read()

	    if(line == nil) then break end
	    rsp = rsp .. line.."\n"
	 end
	 f:close()
      end

      return(rsp)
   else
      return("[ ]\n")
   end
end
-- #################################################

function getActualTopTalkers(ifname, mode, epoch)
   max_num_entries = 10
   rsp = ""

   interface.find(ifname)
   hosts_stats = interface.getFlowsInfo()

   sent = {}
   _sent = {}
   rcvd = {}
   _rcvd = {}

   for _key, value in pairs(hosts_stats) do
      key = hosts_stats[_key]["cli.ip"]
      if(key ~= nil) then
	 old = _sent[key]
	 if(old == nil) then old = 0 end
	 _sent[key] = old + hosts_stats[_key]["cli2srv.bytes"]
      end

      key = hosts_stats[_key]["srv.ip"]
      if(key ~= nil) then
	 old = _rcvd[key]
	 if(old == nil) then old = 0 end
	 _rcvd[key] = old + hosts_stats[_key]["cli2srv.bytes"]
      end

      -- ###########################

      key = hosts_stats[_key]["srv.ip"]
      if(key ~= nil) then
	 old = _sent[key]
	 if(old == nil) then old = 0 end
	 _sent[key] = old + hosts_stats[_key]["srv2cli.bytes"]

	 key = hosts_stats[_key]["cli.ip"]
	 if(key ~= nil) then
	    old = _rcvd[key]
	    if(old == nil) then old = 0 end
	    _rcvd[key] = old + hosts_stats[_key]["srv2cli.bytes"]
	 end
      end
   end

   if(mode == nil) then
      rsp = rsp .. "{\n"
      rsp = rsp .. '\t"senders": ['
   else
      rsp = rsp .. "[\n"
   end

   -- io.write("Hello\n")
   if((mode == nil) or (mode == "senders")) then
      talkers_dir = fixPath(dirs.workingdir .. "/" .. ifname .. "/top_talkers")
      if(not(ntop.exists(talkers_dir))) then
	 ntop.mkdir(talkers_dir)
      end

      -- Read the lastdump
      lastdump = talkers_dir .. "/.sent_lastdump"
      last = nil
      if(ntop.exists(lastdump)) then
	 last = persistence.load(lastdump)
      end
      if(last == nil) then last = {} end

      persistence.store(lastdump, _sent);

      for key, value in pairs(_sent) do
	 if(last[key] ~= nil) then
	    v = _sent[key]-last[key]

	    if(v < 0) then v = 0 end
	    _sent[key] = v
	 end
      end

      add = 0
      for key, value in pairs(_sent) do
	 sent[value+add] = key
	 add = add + 0.0001 -- trick to avoid deleting duplicates
      end

      -- Compute traffic
      total = 0
      num = 0
      for _key, _value in pairsByKeys(sent, rev) do
	 total = total + round(_key)
      end

      -- 10 %
      threshold = total / 10

      num = 0
      for _key, _value in pairsByKeys(sent, rev) do
	 key   = sent[_key]
	 value = round(_key)

	 if((value == 0) or ((value < threshold) and (num > 2))) then break end
	 if(num > 0) then rsp = rsp .. " }," end
	 rsp = rsp .. '\n\t\t { "label": "'..key..'", "value": '..value
	 num = num + 1

	 if(num == max_num_entries) then
	    break
	 end
      end
   end

   if(mode == nil) then
      if(num > 0) then rsp = rsp .. " }" end
      rsp = rsp .. "\n\t],\n"
      rsp = rsp .. '\t"receivers": ['
   end

   if((mode == nil) or (mode == "receivers")) then
      -- Read the lastdump
      lastdump = fixPath(dirs.workingdir .. "/" .. ifname .. "/top_talkers/.rcvd_lastdump")
      last = nil
      if(ntop.exists(lastdump)) then
	 last = persistence.load(lastdump)
      end
      if(last == nil) then last = {} end

      persistence.store(lastdump, _rcvd);

      for key, value in pairs(_rcvd) do
	 -- io.write(key.."\n")

	 if(last[key] ~= nil) then
	    v = _rcvd[key]-last[key]

	    if(v < 0) then v = 0 end
	    _rcvd[key] = v
	 end
      end

      add = 0
      for key, value in pairs(_rcvd) do
	 rcvd[value+add] = key
	 add = add + 0.0001 -- trick to avoid deleting duplicates
      end

      -- Compute traffic
      total = 0
      num = 0
      for _key, _value in pairsByKeys(rcvd, rev) do
	 total = total + round(_key)
      end

      -- 10 %
      threshold = total / 10

      num = 0
      for _key, _value in pairsByKeys(rcvd, rev) do
	 key   = rcvd[_key]
	 value = round(_key)

	 if((value == 0) or ((value < threshold) and (num > 2))) then break end
	 if(num > 0) then rsp = rsp .. " }," end
	 rsp = rsp .. '\n\t\t { "label": "'..key..'", "value": '..value
	 num = num + 1

	 if(num == max_num_entries) then
	    break
	 end
      end
   end

   if(mode == nil) then
      if(num > 0) then rsp = rsp .. " }" end
      rsp = rsp .. "\n\t]\n"
      rsp = rsp .. "\n}\n"
   else
      rsp = rsp .. " }\n"
      rsp = rsp .. "\n]\n"
   end

   --print(rsp.."\n")
   return(rsp)
end

-- #####################################################

function getTopASs(ifname)
   max_num_entries = 10
   rsp = ""

   --if(ifname == nil) then ifname = "any" end

   interface.find(ifname)
   hosts_stats = interface.getHostsInfo()

   _asn = {}
   total = 0

   for _key, value in pairs(hosts_stats) do
      key = hosts_stats[_key]["asn"]

      if(key == 0) then
	 key = key .." [Local/Unknown]"
      else
	 if(hosts_stats[_key]["asname"] ~= nil) then key = key .." ["..abbreviateString(hosts_stats[_key]["asname"], 10).."]" end
      end
      old = _asn[key]
      if(old == nil) then old = 0 end
      val = hosts_stats[_key]["bytes.sent"] + hosts_stats[_key]["bytes.rcvd"]
      total = total + val
      _asn[key] = old + val
   end


   asn = {}
   for _key, value in pairs(_asn) do
      asn[value] = _key
   end

   rsp = rsp .. "[\n"

   -- 10 %
   threshold = total / 10

   num = 0
   for _key, _value in pairsByKeys(asn, rev) do
      key   = asn[_key]
      value = _key

      if((value == 0) or ((value < threshold) and (num > 2))) then break end
      if(num > 0) then rsp = rsp .. " }," end
      rsp = rsp .. '\n\t\t { "label": "'..key..'", "value": '..value
      num = num + 1

      if(num == max_num_entries) then
	 break
      end
   end

   rsp = rsp .. " }\n"
   rsp = rsp .. "\n]\n"

   return(rsp)
end

-- #################################################

function getActualTopAggregations(ifname)
   max_num_entries = 10
   peers_rsp = ""
   rsp = ""

   interface.find(ifname)
   families = interface.getAggregationFamilies()
   num_protos = 0
   num_peers  = 0
   for proto_name,proto_id in pairs(families) do
      hosts_stats = interface.getAggregatedHostsInfo(tonumber(proto_id))

      aggregations = {}
      traffic      = {}
      peers        = {}

      for key, value in pairs(hosts_stats) do
	 for k1,v1 in pairs(value['contacts']) do
	    for k2,v2 in pairs(v1) do
	       if(peers[k2] == nil) then
		  peers[k2] = v2
	       else
		  peers[k2] = peers[k2] + v2
	       end
	       -- print("\t"..k2.."="..v2.."\n")
	    end
	 end

	 aggregations[key] = value['pkts.rcvd'] + value['pkts.sent']
      end

      talkers_dir = fixPath(dirs.workingdir .. "/" .. ifname .. "/top_talkers")
      if(not(ntop.exists(talkers_dir))) then
	 ntop.mkdir(talkers_dir)
      end

      -- Read the lastdump
      lastdump = talkers_dir .. "/."..proto_name.."_lastdump"
      last = nil
      if(ntop.exists(lastdump)) then
	 last = persistence.load(lastdump)
      end
      if(last == nil) then last = {} end

      -- Save the current dump
      persistence.store(lastdump, aggregations);

      names = {}
      add = 0
      for key, value in pairs(aggregations) do
	 v = value

	 if(last[key] ~= nil) then
	    v = v - last[key]
	 end

	 if(v > 0) then
	    v = v + add
	    names[v] = key
	    add = add + 0.0001
	 end
      end

      if(add > 0) then
	 if(num_protos > 0) then
	    rsp = rsp .. ',\n'
	 end
	 rsp = rsp .. '\t"' .. proto_name .. '": ['

	 num_label = 0
	 for key, value in pairsByKeys(names, rev) do
	    --print(proto_name.." ----------\n")
	    if(num_label > 0) then
	       rsp = rsp .. ","
	    end
	    rsp = rsp .. '\n\t\t{ "label": "' .. value.. '", "value": ' .. round(key).. ' }'
	    num_label = num_label + 1

	    if(num_label > max_num_entries) then
	       break
	    end
	 end

	 rsp = rsp .. '\n\t]'
	 num_protos = num_protos + 1

	 -- Print peers
	 -- Read the lastdump
	 lastdump = talkers_dir .. "/."..proto_name.."_peers_lastdump"
	 last = nil
	 if(ntop.exists(lastdump)) then
	    last = persistence.load(lastdump)
	 end
	 if(last == nil) then last = {} end

	 -- Save the current dump
	 persistence.store(lastdump, aggregations);

	 names = {}
	 add = 0
	 for key, value in pairs(peers) do
	    v = value

	    if(last[key] ~= nil) then
	       v = v - last[key]
	    end

	    if(v > 0) then
	       v = v + add
	       names[v] = key
	       add = add + 0.0001
	    end
	 end

	 -- Print peers
	 if(num_peers > 0) then
	    peers_rsp = peers_rsp .. ',\n'
	 end
	 peers_rsp = peers_rsp .. '\t"' .. proto_name .. '": ['

	 num_label = 0
	 for key, value in pairsByKeys(names, rev) do
	    --print(proto_name.." ----------\n")
	    if(num_label > 0) then
	       peers_rsp = peers_rsp .. ","
	    end
	    peers_rsp = peers_rsp .. '\n\t\t{ "label": "' .. value.. '", "value": ' .. round(key).. ' }'
	    num_label = num_label + 1

	    if(num_label > max_num_entries) then
	       break
	    end
	 end

	 peers_rsp = peers_rsp .. '\n\t]'
	 num_peers = num_peers + 1
      end
   end

   rsp = "[\n { \"protos\": {\n" .. rsp .. "\n } },\n { \"peers\": {\n" .. peers_rsp .. "\n } }\n]\n"
   return(rsp)
end
