#!/bin/bash

source activate $CONDA_ENV

# Make sure any error below is reported as such
set -v -e

# Build numba extensions without silencing compile errors
python setup.py build_ext -q --inplace
# (note we don't install to avoid problems with extra long Windows paths
#  during distutils-dependent tests -- e.g. test_pycc)

# Install numba locally for use in `numba -s` sys info tool at test time
# `-iNOWHERE` make a fake index to avoid auto downloading dependency
python -m pip install -iNOWHERE -e .
