program simple;
(* file exemples/pascal/simple.p: simple demo of Numerix
/*-----------------------------------------------------------------------+
 |  Copyright 2005, Michel Quercia (michel.quercia@prepas.org)           |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                    Exemple d'utilisation de Numerix                   |
 |                                                                       |
 +-----------------------------------------------------------------------*)

(* compute  (sqrt(3) + sqrt(2))/(sqrt(3)-sqrt(2)) with n digits *)

uses _name_;


(*
  compute into res the quotient with n digits
  res must be initialized by the caller
*)
procedure compute(var res:xint; n:longint);
var a,b,d,d2,x,y:xint;
begin

   (* d <- 10^n, d2 <- 10^(2n) *)
   d  := f_pow_1(5,n); shiftl(d,d,n);
   d2 := f_sqr(d);

   (* a <- round(sqrt(2*10^(2n+2))), b <- round(sqrt(3*10^(2n+2)))  *)
   a := f_mul_1(d2,200); gsqrt(a,a,1);
   b := f_mul_1(d2,300); gsqrt(b,b,1);

   (* res <- round(10^n*(b+a)/(b-a)) *)
   x := f_add(b,a); mul(x,x,d);
   y := f_sub(b,a);
   gquo(res,x,y,1);

   (* free temporary memory *)
   xfree(d); xfree(d2);
   xfree(a); xfree(b);
   xfree(x); xfree(y);

end;

(* user interface *)
const test_n = 30;
const test_r = '9898979485566356196394568149411';
var i,n   : longint;
    r     : xint;
    s,cmd : ansistring;
    test  : boolean;
    c     : word;

begin

   n   := test_n;
   r   := xnew();
   cmd := paramstr(0);
   test:= false;

   i := 1;
   while i <= paramcount do begin
      if paramstr(i) = '-test' then begin
         test := true;
         n := test_n;
         i := paramcount+1;
      end
      else if (paramstr(i) = '-n') and (i < paramcount) then begin
         val(paramstr(i+1),n,c);
         i := i+2;
      end
      else begin
         writeln('usage: ',cmd,' [-test] [-n <digits>]');
         exit;
      end
   end;

  compute(r,n);
  s := string_of(r);
  if test then begin
      if s <> test_r then writeln('error in the ',cmd,' test')
      else                writeln(cmd,#9'test ok');
  end
  else writeln('r=',s);
  
  (* done *)
  xfree(r);
end.

               
