// file kernel/n/x86/cmp.S: comparison of natural integers
/*-----------------------------------------------------------------------+
 |  Copyright 2005, Michel Quercia (michel.quercia@prepas.org)           |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                              Comparaison                              |
 |                                                                       |
 +-----------------------------------------------------------------------*/


# long xn(cmp)(chiffre *a, long la, chiffre *b, long lb)
#
# entre :
# a = naturel de longueur la
# b = naturel de longueur lb
#
# sortie :
## 1 si a > b, 0 si a = b, -1 si a < b

#ifdef assembly_sn_cmp
#undef L
#define L(x) .Lsn_cmp_##x

ENTER(sn_cmp)
        
        movl   arg1,    %esi            # esi <- &a
        movl   arg2,    %edx            # edx <- la
        movl   arg3,    %edi            # edi <- &b
        movl   arg4,    %ecx            # ecx <- lb

        # supprime les zros de tte du plus long argument
1:
        cmpl   %edx,    %ecx
        je     3f
        ja     2f

        testl  $-1,   -4(%esi,%edx,4)
        jne    L(big)
        decl   %edx
        jmp    1b

2:
        testl  $-1,   -4(%edi,%ecx,4)
        jne    L(small)
        decl   %ecx
        jmp    1b

3:
        # ici, la == lb, compare les chiffres
        jecxz  L(equal)
4:
        movl -4(%esi,%ecx,4), %eax
        cmpl -4(%edi,%ecx,4), %eax
        ja     L(big)
        jb     L(small)
        loop   4b

L(equal):
        movl   $0,      %eax
        RETURN_WITH_SP
        
L(small):
        movl   $-1,     %eax
        RETURN_WITH_SP
        
L(big):
        movl   $1,      %eax
        RETURN_WITH_SP
        
                
#endif /* assembly_sn_cmp */
