// file kernel/x/h/string.h: conversion from and to strings
/*-----------------------------------------------------------------------+
 |  Copyright 2005, Michel Quercia (michel.quercia@prepas.org)           |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                      Conversion entier <-> chane                     |
 |                                                                       |
 +-----------------------------------------------------------------------*/

                         /* +--------------------+
                            |  chane -> entier  |
                            +--------------------+ */


/*
  entre :
  _a = NULL ou pointeur sur entier extensible
  s   = chane de caractres

  sortie :
  a <- valeur de s
  si _a != NULL, *_a <- a
  retourne a

  erreur :
  INVALID_STRING si s contient un caractre non reconnu ou s est vide
  ou rduite au signe et au prfixe

  remarques :
  les signes + et - en dbut de chane sont accepts
  les prfixes 0x, 0X, 0o, 0O, 0b, 0B aprs le signe sont reconnus
  pour une chane hexadcimale, les lettres a..f et A..F sont acceptes
*/
xint xx(copy_string)(xint *_a, char *s);

extern inline xint xx(of_string)(char *s) {return xx(copy_string)(NULL,s);}

                     /* +-----------------------------+
                        |  entier -> chane dcimale  |
                        +-----------------------------+ */

/* 
   entre :
   a = entier extensible

   sortie :
   retourne la reprsentation dcimale de a

   remarques :
   la chane doit tre libre par appel  free (c_api)
   la chane cre ne contient pas de zro non significatif
   le signe n'est indiqu que si a < 0
*/
char *xx(string_of)(xint a);


                       /* +-------------------------+
                          |  entier -> chane hexa  |
                          +-------------------------+ */

/* 
   entre :
   a = entier extensible

   sortie :
   retourne la reprsentation hexadcimale de a

   remarques :
   la chane doit tre libre par appel  free (c_api)
   les chiffres >= 10 sont cods A..F
   la chane cre ne contient pas de zro non significatif
   le signe n'est indiqu que si a < 0
*/
char *xx(hstring_of)(xint a);

                      /* +---------------------------+
                         |  entier -> chane octale  |
                         +---------------------------+ */

/* 
   entre :
   a = entier extensible

   sortie :
   retourne la reprsentation octale de a

   remarques :
   la chane doit tre libre par appel  free (c_api)
   la chane cre ne contient pas de zro non significatif
   le signe n'est indiqu que si a < 0
*/
char *xx(ostring_of)(xint a);

                     /* +----------------------------+
                        |  entier -> chane binaire  |
                        +----------------------------+ */

/* 
   entre :
   a = entier extensible

   sortie :
   retourne la reprsentation binaire de a

   remarques :
   la chane doit tre libre par appel  free (c_api)
   la chane cre ne contient pas de zro non significatif
   le signe n'est indiqu que si a < 0
*/
char *xx(bstring_of)(xint a);

