/* upscommon.h - prototypes for upscommon.c

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "config.h"

#if defined(HAVE_SYS_TERMIOS_H)
#  include <sys/termios.h>	/* for speed_t */
#else
#  error "No <sys/termios.h> available.  Unable to continue."
#endif /* HAVE_SYS_TERMIOS_H */

#include "shared.h"
#include "upshandler.h"

/* useful values for new set/instcmd handlers */

#define STAT_INSTCMD_HANDLED	0x0001		/* all we do for now */
#define STAT_INSTCMD_UNKNOWN	0x0002
/* FUTURE: add details: pass/fail, etc */

#define STAT_SET_HANDLED	0x0010
#define STAT_SET_UNKNOWN	0x0011
/* FUTURE: same */

/* called by alarm signal when the port open fails */
void openfail(int sig);

/* lock the serial port using flock or uu_lock */
void lockport(int upsfd, const char *port);

/* try to open the port at a given speed */
void open_serial_simple(const char *port, speed_t speed, int flags);
void open_serial(const char *port, speed_t speed);

/* function for erasing "timeout"-conditions */
void nolongertimeout(void);

/* alarm signal handler for when serial reads time out */
void timeout(int sig);

/* receive up to buflen bytes from the ups into buf until endchar is read */
/* any characters received that match members of ignchars are discarded */
int upsrecv(char *buf, int buflen, char endchar, const char *ignchars);

/* read buflen chars and store in buf */
int upsrecvchars(char *buf, int buflen);

/* send a byte to the ups */
int upssendchar(char data);
/* send a string to the ups */
int upssend(const char *fmt, ...);

/* flush any pending input from the ups, with reporting */
void upsflushin(int expected, int debugit, const char *ignchars);

/* --- old stuff starts here --- */

/* store data into the array */
void setinfo(int infotype, const char *fmt, ...);

/* set the flags on an existing member of the array */
void setflag(int infotype, int newflags);

/* return the data in the info array with type infotype */
const char *getdata(int infotype);

/* add another type to the info array */
void addinfo(int type, const char *value, int flags, int auxdata);

/* add a new ENUM info entry and do other related housekeeping */
void addenum(int basetype, const char *value);

/* --- old stuff ends here --- */

/* clean out the temp space for a new pass */
void status_init(void);

/* add a status element */
void status_set(char *buf);

/* write the temporary status_buf into ups.status */
void status_commit(void);

extern struct ups_handler upsh;
extern int upsfd;
extern int flag_timeoutfailure;
extern unsigned int upssend_delay;

extern int experimental_driver;

void rtrim(char *in, char sep);
void unlockport(int upsfd, const char *port);
void exit_cleanup(void);

/* install handlers for TERM/QUIT/INT and HUP/PIPE */
void setup_signals(void);
