/* var-map-init.h - translate between old INFO #defines and new names */

struct var_map_t var_map[] =
{
	{ INFO_STATUS,	"STATUS",	"ups.status"			},
	{ INFO_MFR, 	"MFR",		"ups.mfr"			},
	{ INFO_MFRDATE,	"MFRDATE",	"ups.mfr.date"			},
	{ INFO_FIRMREV,	"FIRMREV",	"ups.firmware"			},
	{ INFO_FIRMREV2,"FIRMREV2",	"ups.firmware.aux"		},
	{ INFO_MODEL,	"MODEL",	"ups.model"			},
	{ INFO_SERIAL,	"SERIAL",	"ups.serial"			},
	{ INFO_LOADPCT,	"LOADPCT",	"ups.load"			},
	{ INFO_UPSTEMP,	"UPSTEMP",	"ups.temperature"		},
	{ INFO_UPSIDENT,"UPSIDENT",	"ups.id"			},
	{ INFO_WAKEDELAY,"WAKEDELAY",	"ups.delay.start"		},
	{ INFO_PDNGRACE,"PDNGRACE",	"ups.delay.shutdown"		},
	{ INFO_GRACEDELAY,"GRACEDELAY",	"ups.delay.shutdown"		},
	{ INFO_SLFTSTINT,"SLFTSTINT",	"ups.test.interval"		},
	{ INFO_SLFTSTRES,"SLFTSTRES",	"ups.test.result"		},
	{ INFO_LANGUAGE,"LANGUAGE",	"ups.display.language"		},
	{ INFO_CONTACTS,"CONTACTS",	"ups.contacts"			},

	{ INFO_UTILITY,	"UTILITY",	"input.voltage"			},
	{ INFO_MINUTIL,	"MINUTIL",	"input.voltage.minimum"		},
	{ INFO_MAXUTIL,	"MAXUTIL",	"input.voltage.maximum"		},
	{ INFO_ACFREQ,	"ACFREQ",	"input.frequency"		},
	{ INFO_LINEQUAL, "LINEQUAL",	"input.quality"			},
	{ INFO_LINESENS, "LINESENS",	"input.sensitivity"		},

	{ INFO_XFERWHY,	"XFERWHY",	"input.transfer.reason"		},
	{ INFO_LOWXFER,	"LOWXFER",	"input.transfer.low"		},
	{ INFO_HIGHXFER, "HIGHXFER",	"input.transfer.high"		},
	{ INFO_LOBOOSTXFER, "LOBOOSTXFER", "input.transfer.boost.low" 	},
	{ INFO_HIBOOSTXFER, "HIBOOSTXFER", "input.transfer.boost.high"	},
	{ INFO_LOTRIMXFER, "LOTRIMXFER", "input.transfer.trim.low"	},
	{ INFO_HITRIMXFER, "HITRIMXFER", "input.transfer.trim.high"	},

	{ INFO_OUTVOLT,	"OUTVOLT",	"output.voltage"		},
	{ INFO_OUTVLTSEL, "OUTVLTSEL",	"output.voltage.target.line"	},
	{ INFO_REQVOLT,	"REQVOLT",	"output.voltage.target.battery" },
	{ INFO_CURRENT,	"CURRENT",	"output.current"		},

	{ INFO_BATTPCT,	"BATTPCT",	"battery.charge"		},
	{ INFO_LOBATTPCT, "LOBATTPCT",	"battery.charge.low"		},
	{ INFO_WAKETHRSH, "WAKETHRSH",	"battery.charge.restart"	},
	{ INFO_RTHRESH,	"RTHRESH",	"battery.charge.restart"	},
	{ INFO_BATTVOLT,"BATTVOLT",	"battery.voltage"		},
	{ INFO_BATTDATE,"BATTDATE",	"battery.date"			},
	{ INFO_BATT_CURRENT, "BATT_CURRENT", "battery.current"		},
	{ INFO_BATT_TEMP, "BATT_TEMP",	"battery.temperature"		},

	/* these actually mean slightly different things */
	{ INFO_BATT_RUNTIME,"BATT_RUNTIME","battery.runtime",		},
	{ INFO_RUNTIME,	"RUNTIME",	"battery.runtime"		},

	{ INFO_LOBATTIME, "LOBATTIME",	"battery.runtime.low"		},
	{ INFO_NOMBATVLT, "NOMBATVLT",	"battery.voltage.nominal"	},
	{ INFO_ALRMDELAY, "ALRMDELAY",	"battery.alarm.threshold"	},
	{ INFO_ALRMDEL,	"ALRMDEL",	"battery.alarm.threshold"	},
	{ INFO_BATTPACKS, "BATTPACKS",	"battery.packs"			},
	{ INFO_BADPACKS, "BADPACKS",	"battery.packs.bad"		},
	
	{ INFO_AMBTEMP,	"AMBTEMP",	"ambient.temperature"		},
	{ INFO_TEMPMAX,	"TEMPMAX",	"ambient.temperature.alarm.maximum" },
	{ INFO_TEMPMIN,	"TEMPMIN",	"ambient.temperature.alarm.minimum" },

	{ INFO_AMBHUMID,"AMBHUMID",	"ambient.humidity"		},
	{ INFO_HUMDMAX,	"HUMDMAX",	"ambient.humidity.alarm.maximum" },
	{ INFO_HUMDMIN,	"HUMDMIN",	"ambient.humidity.alarm.minimum" },

	{ 0,		NULL,		NULL			}
};
