#if defined(PVM)
#   include <pvm3.h>
#   ifdef CRAY
#     define MPGROUP         (char *)NULL
#     define MP_INIT(arc,argv)
#   else
#     define MPGROUP           "mp_working_group"
#     define MP_INIT(arc,argv) pvm_init(arc, argv)
#   endif
#   define MP_FINALIZE()     pvm_exit()
#   define MP_BARRIER()      pvm_barrier(MPGROUP,-1)
#   define MP_MYID(pid)      *(pid)   = pvm_getinst(MPGROUP,pvm_mytid())
#   define MP_PROCS(pproc)   *(pproc) = (int)pvm_gsize(MPGROUP)
    extern void pvm_init(int argc, char *argv[]);
    extern double armci_timer();
#   define MP_TIMER          armci_timer
#elif defined(TCGMSG)
#   include <sndrcv.h>
    long tcg_tag =30000;
#   define MP_BARRIER()      SYNCH_(&tcg_tag)
#   define MP_INIT(arc,argv) PBEGIN_((argc),(argv))
#   define MP_FINALIZE()     PEND_()
#   define MP_MYID(pid)      *(pid)   = (int)NODEID_()
#   define MP_PROCS(pproc)   *(pproc) = (int)NNODES_()
#   define MP_TIMER          TCGTIME_
#else
#if defined(BGML)
#   define MP_BARRIER()      armci_msg_barrier()
       #   define MP_FINALIZE()     
       #   define MP_INIT(arc,argv) 
       #   define MP_MYID(pid)      *(pid)=armci_msg_me()
       #   define MP_PROCS(pproc)   *(pproc)=armci_msg_nproc()
       #   define MP_TIMER armci_timer
#else
#   include <mpi.h>
#   define MP_BARRIER()      MPI_Barrier(MPI_COMM_WORLD)
#   define MP_FINALIZE()     MPI_Finalize()
#ifdef DCMF
#   define MP_INIT(arc,argv) \
    int desired = MPI_THREAD_MULTIPLE; \
    int provided; \
    printf("using MPI_Init_thread\n"); \
    MPI_Init_thread(&argc, &argv, desired, &provided); \
    if ( provided != MPI_THREAD_MULTIPLE ) printf("provided != MPI_THREAD_MULTIPLE\n");
#else
#   define MP_INIT(arc,argv) MPI_Init(&(argc),&(argv))
#endif
#   define MP_MYID(pid)      MPI_Comm_rank(MPI_COMM_WORLD, (pid))
#   define MP_PROCS(pproc)   MPI_Comm_size(MPI_COMM_WORLD, (pproc))
#   define MP_TIMER          MPI_Wtime
#endif
#endif

