C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_x_m08.F 
C> The nwxcm_x_m08 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_x_m08 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_4} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_5} &=& 9.115599744691192\,\rho_\alpha^{{{5}\over{3}}}\\\\ 
C>   {\it t_6} &=& {\it t_5}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_7} &=& {\it t_6}^{11}\\\\ 
C>   {\it t_8} &=& 2.0\,\tau_\alpha+{\it t_5}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_8}^{11}}}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{11}} &=& {\it t_6}^{10}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_8}^{10}}}\\\\ 
C>   {\it t_{13}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{14}} &=& {\it t_6}^9\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_8}^9}}\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{17}} &=& {\it t_6}^8\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_8}^8}}\\\\ 
C>   {\it t_{19}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{20}} &=& {\it t_6}^7\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_8}^7}}\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{23}} &=& {\it t_6}^6\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_8}^6}}\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{26}} &=& {\it t_6}^5\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_8}^5}}\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{29}} &=& {\it t_6}^4\\\\ 
C>   {\it t_{30}} &=& {{1}\over{{\it t_8}^4}}\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{32}} &=& {\it t_6}^3\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_8}^3}}\\\\ 
C>   {\it t_{34}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{35}} &=& {\it t_6}^2\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_8}^2}}\\\\ 
C>   {\it t_{37}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_8}}}\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{44}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{49}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{50}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{51}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{52}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{53}} &=& 9.115599744691192\,\rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{54}} &=& {\it t_{53}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{55}} &=& {\it t_{54}}^{11}\\\\ 
C>   {\it t_{56}} &=& 2.0\,\tau_\beta+{\it t_{53}}\\\\ 
C>   {\it t_{57}} &=& {{1}\over{{\it t_{56}}^{11}}}\\\\ 
C>   {\it t_{58}} &=& {\it t_{54}}^{10}\\\\ 
C>   {\it t_{59}} &=& {{1}\over{{\it t_{56}}^{10}}}\\\\ 
C>   {\it t_{60}} &=& {\it t_{54}}^9\\\\ 
C>   {\it t_{61}} &=& {{1}\over{{\it t_{56}}^9}}\\\\ 
C>   {\it t_{62}} &=& {\it t_{54}}^8\\\\ 
C>   {\it t_{63}} &=& {{1}\over{{\it t_{56}}^8}}\\\\ 
C>   {\it t_{64}} &=& {\it t_{54}}^7\\\\ 
C>   {\it t_{65}} &=& {{1}\over{{\it t_{56}}^7}}\\\\ 
C>   {\it t_{66}} &=& {\it t_{54}}^6\\\\ 
C>   {\it t_{67}} &=& {{1}\over{{\it t_{56}}^6}}\\\\ 
C>   {\it t_{68}} &=& {\it t_{54}}^5\\\\ 
C>   {\it t_{69}} &=& {{1}\over{{\it t_{56}}^5}}\\\\ 
C>   {\it t_{70}} &=& {\it t_{54}}^4\\\\ 
C>   {\it t_{71}} &=& {{1}\over{{\it t_{56}}^4}}\\\\ 
C>   {\it t_{72}} &=& {\it t_{54}}^3\\\\ 
C>   {\it t_{73}} &=& {{1}\over{{\it t_{56}}^3}}\\\\ 
C>   {\it t_{74}} &=& {\it t_{54}}^2\\\\ 
C>   {\it t_{75}} &=& {{1}\over{{\it t_{56}}^2}}\\\\ 
C>   {\it t_{76}} &=& {{1}\over{{\it t_{56}}}}\\\\ 
C>   {\it t_{77}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{78}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{79}} &=& 9.115599744691192\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{80}} &=& {\it t_{79}}-2.0\,\tau_s\\\\ 
C>   {\it t_{81}} &=& {\it t_{80}}^{11}\\\\ 
C>   {\it t_{82}} &=& 2.0\,\tau_s+{\it t_{79}}\\\\ 
C>   {\it t_{83}} &=& {{1}\over{{\it t_{82}}^{11}}}\\\\ 
C>   {\it t_{84}} &=& {\it t_{80}}^{10}\\\\ 
C>   {\it t_{85}} &=& {{1}\over{{\it t_{82}}^{10}}}\\\\ 
C>   {\it t_{86}} &=& {\it t_{80}}^9\\\\ 
C>   {\it t_{87}} &=& {{1}\over{{\it t_{82}}^9}}\\\\ 
C>   {\it t_{88}} &=& {\it t_{80}}^8\\\\ 
C>   {\it t_{89}} &=& {{1}\over{{\it t_{82}}^8}}\\\\ 
C>   {\it t_{90}} &=& {\it t_{80}}^7\\\\ 
C>   {\it t_{91}} &=& {{1}\over{{\it t_{82}}^7}}\\\\ 
C>   {\it t_{92}} &=& {\it t_{80}}^6\\\\ 
C>   {\it t_{93}} &=& {{1}\over{{\it t_{82}}^6}}\\\\ 
C>   {\it t_{94}} &=& {\it t_{80}}^5\\\\ 
C>   {\it t_{95}} &=& {{1}\over{{\it t_{82}}^5}}\\\\ 
C>   {\it t_{96}} &=& {\it t_{80}}^4\\\\ 
C>   {\it t_{97}} &=& {{1}\over{{\it t_{82}}^4}}\\\\ 
C>   {\it t_{98}} &=& {\it t_{80}}^3\\\\ 
C>   {\it t_{99}} &=& {{1}\over{{\it t_{82}}^3}}\\\\ 
C>   {\it t_{100}} &=& {\it t_{80}}^2\\\\ 
C>   {\it t_{101}} &=& {{1}\over{{\it t_{82}}^2}}\\\\ 
C>   {\it t_{102}} &=& {{1}\over{{\it t_{82}}}}\\\\ 
C>   f &=& 1.0\,\left(-0.9305257363491002\,{\it t_{51}}\,\left(0.552
C>    \,\left(1.0-{{1}\over{e^{0.003680288926019986\,{\it t_{52}}
C>    \,\sigma_{\beta\beta}}}}\right)+1.0\right)\,\left({\it t_{50}}
C>    \,{\it t_{54}}\,{\it t_{76}}+{\it t_{49}}\,{\it t_{74}}\,{
C>    \it t_{75}}+{\it t_{48}}\,{\it t_{72}}\,{\it t_{73}}+{
C>    \it t_{47}}\,{\it t_{70}}\,{\it t_{71}}+{\it t_{46}}\,{
C>    \it t_{68}}\,{\it t_{69}}+{\it t_{45}}\,{\it t_{66}}\,{
C>    \it t_{67}}+{\it t_{44}}\,{\it t_{64}}\,{\it t_{65}}+{
C>    \it t_{43}}\,{\it t_{62}}\,{\it t_{63}}+{\it t_{42}}\,{
C>    \it t_{60}}\,{\it t_{61}}+{\it t_{41}}\,{\it t_{58}}\,{
C>    \it t_{59}}+{\it t_{40}}\,{\it t_{55}}\,{\it t_{57}}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_{51}}\,
C>    \left(0.804\,\left(1.0-{{1.0}\over{0.004492667444378077\,{
C>    \it t_{52}}\,\sigma_{\beta\beta}+1.0}}\right)+1.0\right)
C>    \,\left({\it t_{37}}\,{\it t_{54}}\,{\it t_{76}}+{\it t_{34}}
C>    \,{\it t_{74}}\,{\it t_{75}}+{\it t_{31}}\,{\it t_{72}}\,{
C>    \it t_{73}}+{\it t_{28}}\,{\it t_{70}}\,{\it t_{71}}+{
C>    \it t_{25}}\,{\it t_{68}}\,{\it t_{69}}+{\it t_{22}}\,{
C>    \it t_{66}}\,{\it t_{67}}+{\it t_{19}}\,{\it t_{64}}\,{
C>    \it t_{65}}+{\it t_{16}}\,{\it t_{62}}\,{\it t_{63}}+{
C>    \it t_{13}}\,{\it t_{60}}\,{\it t_{61}}+{\it t_{10}}\,{
C>    \it t_{58}}\,{\it t_{59}}+{\it t_4}\,{\it t_{55}}\,{\it t_{57}}
C>    +{\it t_3}\right)\right)+1.0\,\left(-0.9305257363491002\,{
C>    \it t_1}\,\left(0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}}}}\right)+1.0\right)\,\left({\it t_{50}}
C>    \,{\it t_6}\,{\it t_{38}}+{\it t_{49}}\,{\it t_{35}}\,{
C>    \it t_{36}}+{\it t_{48}}\,{\it t_{32}}\,{\it t_{33}}+{
C>    \it t_{47}}\,{\it t_{29}}\,{\it t_{30}}+{\it t_{46}}\,{
C>    \it t_{26}}\,{\it t_{27}}+{\it t_{45}}\,{\it t_{23}}\,{
C>    \it t_{24}}+{\it t_{44}}\,{\it t_{20}}\,{\it t_{21}}+{
C>    \it t_{43}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{42}}\,{
C>    \it t_{14}}\,{\it t_{15}}+{\it t_{41}}\,{\it t_{11}}\,{
C>    \it t_{12}}+{\it t_{40}}\,{\it t_7}\,{\it t_9}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_1}\,\left(0.804
C>    \,\left(1.0-{{1.0}\over{0.004492667444378077\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0}}\right)+1.0\right)\,\left({
C>    \it t_{37}}\,{\it t_6}\,{\it t_{38}}+{\it t_{34}}\,{
C>    \it t_{35}}\,{\it t_{36}}+{\it t_{31}}\,{\it t_{32}}\,{
C>    \it t_{33}}+{\it t_{28}}\,{\it t_{29}}\,{\it t_{30}}+{
C>    \it t_{25}}\,{\it t_{26}}\,{\it t_{27}}+{\it t_{22}}\,{
C>    \it t_{23}}\,{\it t_{24}}+{\it t_{19}}\,{\it t_{20}}\,{
C>    \it t_{21}}+{\it t_{16}}\,{\it t_{17}}\,{\it t_{18}}+{
C>    \it t_{13}}\,{\it t_{14}}\,{\it t_{15}}+{\it t_{10}}\,{
C>    \it t_{11}}\,{\it t_{12}}+{\it t_4}\,{\it t_7}\,{\it t_9}+{
C>    \it t_3}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-0.9305257363491002\,{\it t_{77}}\,\left(0.552
C>    \,\left(1.0-{{1}\over{e^{0.003680288926019986\,{\it t_{78}}
C>    \,\sigma_{ss}}}}\right)+1.0\right)\,\left({\it t_{50}}\,{
C>    \it t_{80}}\,{\it t_{102}}+{\it t_{49}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{48}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{47}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{46}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{45}}\,{\it t_{92}}\,{
C>    \it t_{93}}+{\it t_{44}}\,{\it t_{90}}\,{\it t_{91}}+{
C>    \it t_{43}}\,{\it t_{88}}\,{\it t_{89}}+{\it t_{42}}\,{
C>    \it t_{86}}\,{\it t_{87}}+{\it t_{41}}\,{\it t_{84}}\,{
C>    \it t_{85}}+{\it t_{40}}\,{\it t_{81}}\,{\it t_{83}}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_{77}}\,
C>    \left(0.804\,\left(1.0-{{1.0}\over{0.004492667444378077\,{
C>    \it t_{78}}\,\sigma_{ss}+1.0}}\right)+1.0\right)\,\left({
C>    \it t_{37}}\,{\it t_{80}}\,{\it t_{102}}+{\it t_{34}}\,{
C>    \it t_{100}}\,{\it t_{101}}+{\it t_{31}}\,{\it t_{98}}\,{
C>    \it t_{99}}+{\it t_{28}}\,{\it t_{96}}\,{\it t_{97}}+{
C>    \it t_{25}}\,{\it t_{94}}\,{\it t_{95}}+{\it t_{22}}\,{
C>    \it t_{92}}\,{\it t_{93}}+{\it t_{19}}\,{\it t_{90}}\,{
C>    \it t_{91}}+{\it t_{16}}\,{\it t_{88}}\,{\it t_{89}}+{
C>    \it t_{13}}\,{\it t_{86}}\,{\it t_{87}}+{\it t_{10}}\,{
C>    \it t_{84}}\,{\it t_{85}}+{\it t_4}\,{\it t_{81}}\,{\it t_{83}}
C>    +{\it t_3}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.TheoryComput. 4, 1849 (2008)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/ct800246v "> 
C> 10.1021/ct800246v </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m08(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(12)
            t6 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t7 = t6-2.0d+0*taua
            t8 = t7**11
            t9 = 2.0d+0*taua+t6
            t10 = 1/t9**11
            t11 = param(11)
            t12 = t7**10
            t13 = 1/t9**10
            t14 = param(10)
            t15 = t7**9
            t16 = 1/t9**9
            t17 = param(9)
            t18 = t7**8
            t19 = 1/t9**8
            t20 = param(8)
            t21 = t7**7
            t22 = 1/t9**7
            t23 = param(7)
            t24 = t7**6
            t25 = 1/t9**6
            t26 = param(6)
            t27 = t7**5
            t28 = 1/t9**5
            t29 = param(5)
            t30 = t7**4
            t31 = 1/t9**4
            t32 = param(4)
            t33 = t7**3
            t34 = 1/t9**3
            t35 = param(3)
            t36 = t7**2
            t37 = 1/t9**2
            t38 = param(2)
            t39 = 1/t9
            t40 = t10*t5*t8+t38*t39*t7+t35*t36*t37+t32*t33*t34+t29*t30*t
     1         31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t17*t18*t19+t14*t1
     2         5*t16+t11*t12*t13+param(1)
            t41 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t42 = 5.52d-1*(1.0d+0-t41)+1.0d+0
            t43 = param(24)
            t44 = param(23)
            t45 = param(22)
            t46 = param(21)
            t47 = param(20)
            t48 = param(19)
            t49 = param(18)
            t50 = param(17)
            t51 = param(16)
            t52 = param(15)
            t53 = param(14)
            t54 = t10*t43*t8+t39*t53*t7+t36*t37*t52+t33*t34*t51+t30*t31*
     1         t50+t27*t28*t49+t24*t25*t48+t21*t22*t47+t18*t19*t46+t15*t
     2         16*t45+t12*t13*t44+param(13)
            t55 = rhoa**6.666666666666666d-1
            t56 = 1/t9**12
            t57 = 1/t2**2
            t58 = 1/rhoa**2.3333333333333334d+0
            t59 = rhoa**3.333333333333333d-1
            t60 = 1/t4
            fnc(iq) = 2.0d+0*(-9.305257363491002d-1*t4*t42*t54-9.3052573
     1         63491002d-1*t3*t4*t40)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-1.671
     1         1932865267184d+2*t5*t55*t56*t8-1.5192666241151986d+1*t37*
     2         t38*t55*t7+3.038533248230397d+1*t35*t37*t55*t7+1.67119328
     3         65267184d+2*t10*t12*t5*t55+1.5192666241151986d+1*t38*t39*
     4         t55-3.038533248230397d+1*t34*t35*t36*t55+4.55779987234559
     5         65d+1*t32*t34*t36*t55-4.5577998723455965d+1*t31*t32*t33*t
     6         55+6.077066496460795d+1*t29*t31*t33*t55-6.077066496460795
     7         d+1*t28*t29*t30*t55+7.596333120575993d+1*t26*t28*t30*t55-
     8         7.596333120575993d+1*t25*t26*t27*t55+9.115599744691193d+1
     9         *t23*t25*t27*t55-9.115599744691193d+1*t22*t23*t24*t55+1.0
     :         634866368806391d+2*t20*t22*t24*t55-1.0634866368806391d+2*
     ;         t19*t20*t21*t55+1.2154132992921589d+2*t17*t19*t21*t55-1.2
     <         154132992921589d+2*t16*t17*t18*t55+1.3673399617036788d+2*
     =         t14*t16*t18*t55-1.3673399617036788d+2*t13*t14*t15*t55+1.5
     >         192666241151986d+2*t11*t13*t15*t55-1.5192666241151986d+2*
     ?         t10*t11*t12*t55)-9.305257363491002d-1*t4*t42*(-1.67119328
     @         65267184d+2*t43*t55*t56*t8-1.5192666241151986d+1*t37*t53*
     1         t55*t7+3.038533248230397d+1*t37*t52*t55*t7+1.519266624115
     2         1986d+1*t39*t53*t55-3.038533248230397d+1*t34*t36*t52*t55+
     3         4.5577998723455965d+1*t34*t36*t51*t55-4.5577998723455965d
     4         +1*t31*t33*t51*t55+6.077066496460795d+1*t31*t33*t50*t55-6
     5         .077066496460795d+1*t28*t30*t50*t55+7.596333120575993d+1*
     6         t28*t30*t49*t55-7.596333120575993d+1*t25*t27*t49*t55+9.11
     7         5599744691193d+1*t25*t27*t48*t55-9.115599744691193d+1*t22
     8         *t24*t48*t55+1.0634866368806391d+2*t22*t24*t47*t55-1.0634
     9         866368806391d+2*t19*t21*t47*t55+1.2154132992921589d+2*t19
     :         *t21*t46*t55-1.2154132992921589d+2*t16*t18*t46*t55+1.3673
     ;         399617036788d+2*t16*t18*t45*t55-1.3673399617036788d+2*t13
     <         *t15*t45*t55+1.5192666241151986d+2*t13*t15*t44*t55-1.5192
     =         666241151986d+2*t10*t12*t44*t55+1.6711932865267184d+2*t10
     >         *t12*t43*t55)-1.2407009817988002d+0*t42*t54*t59-1.2407009
     ?         817988002d+0*t3*t40*t59+8.963083509889702d-3*gammaaa*t40*
     @         t57*t58+5.041016444533138d-3*gammaaa*t41*t54*t58)*wght+Am
     1         at(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t40*t57*t60-
     1         1.890381166699927d-3*t41*t54*t60)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-2.2d+
     1         1*t5*t56*t8-2.0d+0*t37*t38*t7-4.0d+0*t35*t37*t7-2.2d+1*t1
     2         0*t12*t5-2.0d+0*t38*t39-4.0d+0*t34*t35*t36-6.0d+0*t32*t34
     3         *t36-6.0d+0*t31*t32*t33-8.0d+0*t29*t31*t33-8.0d+0*t28*t29
     4         *t30-1.0d+1*t26*t28*t30-1.0d+1*t25*t26*t27-1.2d+1*t23*t25
     5         *t27-1.2d+1*t22*t23*t24-1.4d+1*t20*t22*t24-1.4d+1*t19*t20
     6         *t21-1.6d+1*t17*t19*t21-1.6d+1*t16*t17*t18-1.8d+1*t14*t16
     7         *t18-1.8d+1*t13*t14*t15-2.0d+1*t11*t13*t15-2.0d+1*t10*t11
     8         *t12)-9.305257363491002d-1*t4*t42*(-2.2d+1*t43*t56*t8-2.0
     9         d+0*t37*t53*t7-4.0d+0*t37*t52*t7-2.0d+0*t39*t53-4.0d+0*t3
     :         4*t36*t52-6.0d+0*t34*t36*t51-6.0d+0*t31*t33*t51-8.0d+0*t3
     ;         1*t33*t50-8.0d+0*t28*t30*t50-1.0d+1*t28*t30*t49-1.0d+1*t2
     <         5*t27*t49-1.2d+1*t25*t27*t48-1.2d+1*t22*t24*t48-1.4d+1*t2
     =         2*t24*t47-1.4d+1*t19*t21*t47-1.6d+1*t19*t21*t46-1.6d+1*t1
     >         6*t18*t46-1.8d+1*t16*t18*t45-1.8d+1*t13*t15*t45-2.0d+1*t1
     ?         3*t15*t44-2.0d+1*t10*t12*t44-2.2d+1*t10*t12*t43))*wght+Mm
     @         at(iq,D1_TA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(1)
            t6 = param(12)
            t7 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t8 = t7-2.0d+0*taua
            t9 = t8**11
            t10 = 2.0d+0*taua+t7
            t11 = 1/t10**11
            t12 = param(11)
            t13 = t8**10
            t14 = 1/t10**10
            t15 = param(10)
            t16 = t8**9
            t17 = 1/t10**9
            t18 = param(9)
            t19 = t8**8
            t20 = 1/t10**8
            t21 = param(8)
            t22 = t8**7
            t23 = 1/t10**7
            t24 = param(7)
            t25 = t8**6
            t26 = 1/t10**6
            t27 = param(6)
            t28 = t8**5
            t29 = 1/t10**5
            t30 = param(5)
            t31 = t8**4
            t32 = 1/t10**4
            t33 = param(4)
            t34 = t8**3
            t35 = 1/t10**3
            t36 = param(3)
            t37 = t8**2
            t38 = 1/t10**2
            t39 = param(2)
            t40 = 1/t10
            t41 = t11*t6*t9+t39*t40*t8+t5+t36*t37*t38+t33*t34*t35+t30*t3
     1         1*t32+t27*t28*t29+t24*t25*t26+t21*t22*t23+t18*t19*t20+t15
     2         *t16*t17+t12*t13*t14
            t42 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t43 = 5.52d-1*(1.0d+0-t42)+1.0d+0
            t44 = param(13)
            t45 = param(24)
            t46 = param(23)
            t47 = param(22)
            t48 = param(21)
            t49 = param(20)
            t50 = param(19)
            t51 = param(18)
            t52 = param(17)
            t53 = param(16)
            t54 = param(15)
            t55 = param(14)
            t56 = t11*t45*t9+t40*t55*t8+t37*t38*t54+t34*t35*t53+t31*t32*
     1         t52+t28*t29*t51+t25*t26*t50+t22*t23*t49+t19*t20*t48+t16*t
     2         17*t47+t13*t14*t46+t44
            t57 = 1/rhob**2.6666666666666666d+0
            t58 = 4.492667444378077d-3*gammabb*t57+1.0d+0
            t59 = 8.04d-1*(1.0d+0-1.0d+0/t58)+1.0d+0
            t60 = rhob**1.3333333333333333d+0
            t61 = 9.115599744691192d+0*rhob**1.6666666666666669d+0
            t62 = t61-2.0d+0*taub
            t63 = t62**11
            t64 = 2.0d+0*taub+t61
            t65 = 1/t64**11
            t66 = t62**10
            t67 = 1/t64**10
            t68 = t62**9
            t69 = 1/t64**9
            t70 = t62**8
            t71 = 1/t64**8
            t72 = t62**7
            t73 = 1/t64**7
            t74 = t62**6
            t75 = 1/t64**6
            t76 = t62**5
            t77 = 1/t64**5
            t78 = t62**4
            t79 = 1/t64**4
            t80 = t62**3
            t81 = 1/t64**3
            t82 = t62**2
            t83 = 1/t64**2
            t84 = 1/t64
            t85 = t39*t62*t84+t36*t82*t83+t33*t80*t81+t30*t78*t79+t27*t7
     1         6*t77+t24*t74*t75+t21*t72*t73+t18*t70*t71+t15*t68*t69+t12
     2         *t66*t67+t6*t63*t65+t5
            t86 = exp(-3.6802889260199856d-3*gammabb*t57)
            t87 = 5.52d-1*(1.0d+0-t86)+1.0d+0
            t88 = t55*t62*t84+t54*t82*t83+t53*t80*t81+t52*t78*t79+t51*t7
     1         6*t77+t50*t74*t75+t49*t72*t73+t48*t70*t71+t47*t68*t69+t46
     2         *t66*t67+t45*t63*t65+t44
            t89 = rhoa**6.666666666666666d-1
            t90 = 1/t10**12
            t91 = 1/t2**2
            t92 = 1/rhoa**2.3333333333333334d+0
            t93 = rhoa**3.333333333333333d-1
            t94 = rhob**6.666666666666666d-1
            t95 = 1/t64**12
            t96 = 1/t58**2
            t97 = 1/rhob**2.3333333333333334d+0
            t98 = rhob**3.333333333333333d-1
            t99 = 1/t4
            t100 = 1/t60
            fnc(iq) = (1.0d+0*(-9.305257363491002d-1*t60*t87*t88-9.30525
     1         7363491002d-1*t59*t60*t85)+1.0d+0*(-9.305257363491002d-1*
     2         t4*t43*t56-9.305257363491002d-1*t3*t4*t41))*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t43*t56*t93-
     1         1.2407009817988002d+0*t3*t41*t93+8.963083509889702d-3*gam
     2         maaa*t41*t91*t92+5.041016444533138d-3*gammaaa*t42*t56*t92
     3         -9.305257363491002d-1*t3*t4*(-1.6711932865267184d+2*t6*t8
     4         9*t9*t90-1.5192666241151986d+1*t38*t39*t8*t89+3.038533248
     5         230397d+1*t36*t38*t8*t89+1.6711932865267184d+2*t11*t13*t6
     6         *t89+1.5192666241151986d+1*t39*t40*t89-3.038533248230397d
     7         +1*t35*t36*t37*t89+4.5577998723455965d+1*t33*t35*t37*t89-
     8         4.5577998723455965d+1*t32*t33*t34*t89+6.077066496460795d+
     9         1*t30*t32*t34*t89-6.077066496460795d+1*t29*t30*t31*t89+7.
     :         596333120575993d+1*t27*t29*t31*t89-7.596333120575993d+1*t
     ;         26*t27*t28*t89+9.115599744691193d+1*t24*t26*t28*t89-9.115
     <         599744691193d+1*t23*t24*t25*t89+1.0634866368806391d+2*t21
     =         *t23*t25*t89-1.0634866368806391d+2*t20*t21*t22*t89+1.2154
     >         132992921589d+2*t18*t20*t22*t89-1.2154132992921589d+2*t17
     ?         *t18*t19*t89+1.3673399617036788d+2*t15*t17*t19*t89-1.3673
     @         399617036788d+2*t14*t15*t16*t89+1.5192666241151986d+2*t12
     1         *t14*t16*t89-1.5192666241151986d+2*t11*t12*t13*t89)-9.305
     2         257363491002d-1*t4*t43*(-1.6711932865267184d+2*t45*t89*t9
     3         *t90-1.5192666241151986d+1*t38*t55*t8*t89+3.0385332482303
     4         97d+1*t38*t54*t8*t89+1.5192666241151986d+1*t40*t55*t89-3.
     5         038533248230397d+1*t35*t37*t54*t89+4.5577998723455965d+1*
     6         t35*t37*t53*t89-4.5577998723455965d+1*t32*t34*t53*t89+6.0
     7         77066496460795d+1*t32*t34*t52*t89-6.077066496460795d+1*t2
     8         9*t31*t52*t89+7.596333120575993d+1*t29*t31*t51*t89-7.5963
     9         33120575993d+1*t26*t28*t51*t89+9.115599744691193d+1*t26*t
     :         28*t50*t89-9.115599744691193d+1*t23*t25*t50*t89+1.0634866
     ;         368806391d+2*t23*t25*t49*t89-1.0634866368806391d+2*t20*t2
     <         2*t49*t89+1.2154132992921589d+2*t20*t22*t48*t89-1.2154132
     =         992921589d+2*t17*t19*t48*t89+1.3673399617036788d+2*t17*t1
     >         9*t47*t89-1.3673399617036788d+2*t14*t16*t47*t89+1.5192666
     ?         241151986d+2*t14*t16*t46*t89-1.5192666241151986d+2*t11*t1
     @         3*t46*t89+1.6711932865267184d+2*t11*t13*t45*t89))*wght+Am
     1         at(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t87*t88*t98-
     1         1.2407009817988002d+0*t59*t85*t98+8.963083509889702d-3*ga
     2         mmabb*t85*t96*t97+5.041016444533138d-3*gammabb*t86*t88*t9
     3         7-9.305257363491002d-1*t59*t60*(-1.6711932865267184d+2*t6
     4         *t63*t94*t95+1.5192666241151986d+1*t39*t84*t94-1.51926662
     5         41151986d+1*t39*t62*t83*t94+3.038533248230397d+1*t36*t62*
     6         t83*t94-3.038533248230397d+1*t36*t81*t82*t94+4.5577998723
     7         455965d+1*t33*t81*t82*t94-4.5577998723455965d+1*t33*t79*t
     8         80*t94+6.077066496460795d+1*t30*t79*t80*t94-6.07706649646
     9         0795d+1*t30*t77*t78*t94+7.596333120575993d+1*t27*t77*t78*
     :         t94-7.596333120575993d+1*t27*t75*t76*t94+9.11559974469119
     ;         3d+1*t24*t75*t76*t94-9.115599744691193d+1*t24*t73*t74*t94
     <         +1.0634866368806391d+2*t21*t73*t74*t94-1.0634866368806391
     =         d+2*t21*t71*t72*t94+1.2154132992921589d+2*t18*t71*t72*t94
     >         -1.2154132992921589d+2*t18*t69*t70*t94+1.3673399617036788
     ?         d+2*t15*t69*t70*t94-1.3673399617036788d+2*t15*t67*t68*t94
     @         +1.5192666241151986d+2*t12*t67*t68*t94+1.6711932865267184
     1         d+2*t6*t65*t66*t94-1.5192666241151986d+2*t12*t65*t66*t94)
     2         -9.305257363491002d-1*t60*t87*(-1.6711932865267184d+2*t45
     3         *t63*t94*t95+1.5192666241151986d+1*t55*t84*t94-1.51926662
     4         41151986d+1*t55*t62*t83*t94+3.038533248230397d+1*t54*t62*
     5         t83*t94-3.038533248230397d+1*t54*t81*t82*t94+4.5577998723
     6         455965d+1*t53*t81*t82*t94-4.5577998723455965d+1*t53*t79*t
     7         80*t94+6.077066496460795d+1*t52*t79*t80*t94-6.07706649646
     8         0795d+1*t52*t77*t78*t94+7.596333120575993d+1*t51*t77*t78*
     9         t94-7.596333120575993d+1*t51*t75*t76*t94+9.11559974469119
     :         3d+1*t50*t75*t76*t94-9.115599744691193d+1*t50*t73*t74*t94
     ;         +1.0634866368806391d+2*t49*t73*t74*t94-1.0634866368806391
     <         d+2*t49*t71*t72*t94+1.2154132992921589d+2*t48*t71*t72*t94
     =         -1.2154132992921589d+2*t48*t69*t70*t94+1.3673399617036788
     >         d+2*t47*t69*t70*t94-1.3673399617036788d+2*t47*t67*t68*t94
     ?         +1.5192666241151986d+2*t46*t67*t68*t94-1.5192666241151986
     @         d+2*t46*t65*t66*t94+1.6711932865267184d+2*t45*t65*t66*t94
     1         ))*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t41*t91*t99-
     1         1.890381166699927d-3*t42*t56*t99)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t100*t85*t96
     1         -1.890381166699927d-3*t100*t86*t88)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-2.2d+
     1         1*t6*t9*t90-2.0d+0*t38*t39*t8-4.0d+0*t36*t38*t8-2.2d+1*t1
     2         1*t13*t6-2.0d+0*t39*t40-4.0d+0*t35*t36*t37-6.0d+0*t33*t35
     3         *t37-6.0d+0*t32*t33*t34-8.0d+0*t30*t32*t34-8.0d+0*t29*t30
     4         *t31-1.0d+1*t27*t29*t31-1.0d+1*t26*t27*t28-1.2d+1*t24*t26
     5         *t28-1.2d+1*t23*t24*t25-1.4d+1*t21*t23*t25-1.4d+1*t20*t21
     6         *t22-1.6d+1*t18*t20*t22-1.6d+1*t17*t18*t19-1.8d+1*t15*t17
     7         *t19-1.8d+1*t14*t15*t16-2.0d+1*t12*t14*t16-2.0d+1*t11*t12
     8         *t13)-9.305257363491002d-1*t4*t43*(-2.2d+1*t45*t9*t90-2.0
     9         d+0*t38*t55*t8-4.0d+0*t38*t54*t8-2.0d+0*t40*t55-4.0d+0*t3
     :         5*t37*t54-6.0d+0*t35*t37*t53-6.0d+0*t32*t34*t53-8.0d+0*t3
     ;         2*t34*t52-8.0d+0*t29*t31*t52-1.0d+1*t29*t31*t51-1.0d+1*t2
     <         6*t28*t51-1.2d+1*t26*t28*t50-1.2d+1*t23*t25*t50-1.4d+1*t2
     =         3*t25*t49-1.4d+1*t20*t22*t49-1.6d+1*t20*t22*t48-1.6d+1*t1
     >         7*t19*t48-1.8d+1*t17*t19*t47-1.8d+1*t14*t16*t47-2.0d+1*t1
     ?         4*t16*t46-2.0d+1*t11*t13*t46-2.2d+1*t11*t13*t45))*wght+Mm
     @         at(iq,D1_TA)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t59*t60*(-2.2
     1         d+1*t6*t63*t95-2.0d+0*t39*t84-2.0d+0*t39*t62*t83-4.0d+0*t
     2         36*t62*t83-4.0d+0*t36*t81*t82-6.0d+0*t33*t81*t82-6.0d+0*t
     3         33*t79*t80-8.0d+0*t30*t79*t80-8.0d+0*t30*t77*t78-1.0d+1*t
     4         27*t77*t78-1.0d+1*t27*t75*t76-1.2d+1*t24*t75*t76-1.2d+1*t
     5         24*t73*t74-1.4d+1*t21*t73*t74-1.4d+1*t21*t71*t72-1.6d+1*t
     6         18*t71*t72-1.6d+1*t18*t69*t70-1.8d+1*t15*t69*t70-1.8d+1*t
     7         15*t67*t68-2.0d+1*t12*t67*t68-2.2d+1*t6*t65*t66-2.0d+1*t1
     8         2*t65*t66)-9.305257363491002d-1*t60*t87*(-2.2d+1*t45*t63*
     9         t95-2.0d+0*t55*t84-2.0d+0*t55*t62*t83-4.0d+0*t54*t62*t83-
     :         4.0d+0*t54*t81*t82-6.0d+0*t53*t81*t82-6.0d+0*t53*t79*t80-
     ;         8.0d+0*t52*t79*t80-8.0d+0*t52*t77*t78-1.0d+1*t51*t77*t78-
     <         1.0d+1*t51*t75*t76-1.2d+1*t50*t75*t76-1.2d+1*t50*t73*t74-
     =         1.4d+1*t49*t73*t74-1.4d+1*t49*t71*t72-1.6d+1*t48*t71*t72-
     >         1.6d+1*t48*t69*t70-1.8d+1*t47*t69*t70-1.8d+1*t47*t67*t68-
     ?         2.0d+1*t46*t67*t68-2.0d+1*t46*t65*t66-2.2d+1*t45*t65*t66)
     @         )*wght+Mmat(iq,D1_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(12)
            t6 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t7 = t6-2.0d+0*taua
            t8 = t7**11
            t9 = 2.0d+0*taua+t6
            t10 = 1/t9**11
            t11 = param(11)
            t12 = t7**10
            t13 = 1/t9**10
            t14 = param(10)
            t15 = t7**9
            t16 = 1/t9**9
            t17 = param(9)
            t18 = t7**8
            t19 = 1/t9**8
            t20 = param(8)
            t21 = t7**7
            t22 = 1/t9**7
            t23 = param(7)
            t24 = t7**6
            t25 = 1/t9**6
            t26 = param(6)
            t27 = t7**5
            t28 = 1/t9**5
            t29 = param(5)
            t30 = t7**4
            t31 = 1/t9**4
            t32 = param(4)
            t33 = t7**3
            t34 = 1/t9**3
            t35 = param(3)
            t36 = t7**2
            t37 = 1/t9**2
            t38 = param(2)
            t39 = 1/t9
            t40 = t10*t5*t8+t38*t39*t7+t35*t36*t37+t32*t33*t34+t29*t30*t
     1         31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t17*t18*t19+t14*t1
     2         5*t16+t11*t12*t13+param(1)
            t41 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t42 = 5.52d-1*(1.0d+0-t41)+1.0d+0
            t43 = param(24)
            t44 = param(23)
            t45 = param(22)
            t46 = param(21)
            t47 = param(20)
            t48 = param(19)
            t49 = param(18)
            t50 = param(17)
            t51 = param(16)
            t52 = param(15)
            t53 = param(14)
            t54 = t10*t43*t8+t39*t53*t7+t36*t37*t52+t33*t34*t51+t30*t31*
     1         t50+t27*t28*t49+t24*t25*t48+t21*t22*t47+t18*t19*t46+t15*t
     2         16*t45+t12*t13*t44+param(13)
            t55 = rhoa**6.666666666666666d-1
            t56 = 1/t9**12
            t57 = 1/t2**2
            t58 = 1/rhoa**2.3333333333333334d+0
            t59 = rhoa**3.333333333333333d-1
            t60 = 1/t4
            fnc(iq) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t54-9.3052573
     1         63491002d-1*t3*t4*t40)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-1.671
     1         1932865267184d+2*t5*t55*t56*t8-1.5192666241151986d+1*t37*
     2         t38*t55*t7+3.038533248230397d+1*t35*t37*t55*t7+1.67119328
     3         65267184d+2*t10*t12*t5*t55+1.5192666241151986d+1*t38*t39*
     4         t55-3.038533248230397d+1*t34*t35*t36*t55+4.55779987234559
     5         65d+1*t32*t34*t36*t55-4.5577998723455965d+1*t31*t32*t33*t
     6         55+6.077066496460795d+1*t29*t31*t33*t55-6.077066496460795
     7         d+1*t28*t29*t30*t55+7.596333120575993d+1*t26*t28*t30*t55-
     8         7.596333120575993d+1*t25*t26*t27*t55+9.115599744691193d+1
     9         *t23*t25*t27*t55-9.115599744691193d+1*t22*t23*t24*t55+1.0
     :         634866368806391d+2*t20*t22*t24*t55-1.0634866368806391d+2*
     ;         t19*t20*t21*t55+1.2154132992921589d+2*t17*t19*t21*t55-1.2
     <         154132992921589d+2*t16*t17*t18*t55+1.3673399617036788d+2*
     =         t14*t16*t18*t55-1.3673399617036788d+2*t13*t14*t15*t55+1.5
     >         192666241151986d+2*t11*t13*t15*t55-1.5192666241151986d+2*
     ?         t10*t11*t12*t55)-9.305257363491002d-1*t4*t42*(-1.67119328
     @         65267184d+2*t43*t55*t56*t8-1.5192666241151986d+1*t37*t53*
     1         t55*t7+3.038533248230397d+1*t37*t52*t55*t7+1.519266624115
     2         1986d+1*t39*t53*t55-3.038533248230397d+1*t34*t36*t52*t55+
     3         4.5577998723455965d+1*t34*t36*t51*t55-4.5577998723455965d
     4         +1*t31*t33*t51*t55+6.077066496460795d+1*t31*t33*t50*t55-6
     5         .077066496460795d+1*t28*t30*t50*t55+7.596333120575993d+1*
     6         t28*t30*t49*t55-7.596333120575993d+1*t25*t27*t49*t55+9.11
     7         5599744691193d+1*t25*t27*t48*t55-9.115599744691193d+1*t22
     8         *t24*t48*t55+1.0634866368806391d+2*t22*t24*t47*t55-1.0634
     9         866368806391d+2*t19*t21*t47*t55+1.2154132992921589d+2*t19
     :         *t21*t46*t55-1.2154132992921589d+2*t16*t18*t46*t55+1.3673
     ;         399617036788d+2*t16*t18*t45*t55-1.3673399617036788d+2*t13
     <         *t15*t45*t55+1.5192666241151986d+2*t13*t15*t44*t55-1.5192
     =         666241151986d+2*t10*t12*t44*t55+1.6711932865267184d+2*t10
     >         *t12*t43*t55)-1.2407009817988002d+0*t42*t54*t59-1.2407009
     ?         817988002d+0*t3*t40*t59+8.963083509889702d-3*gammaaa*t40*
     @         t57*t58+5.041016444533138d-3*gammaaa*t41*t54*t58)*wght+Am
     1         at(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t40*t57*t60-
     1         1.890381166699927d-3*t41*t54*t60)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-2.2d+
     1         1*t5*t56*t8-2.0d+0*t37*t38*t7-4.0d+0*t35*t37*t7-2.2d+1*t1
     2         0*t12*t5-2.0d+0*t38*t39-4.0d+0*t34*t35*t36-6.0d+0*t32*t34
     3         *t36-6.0d+0*t31*t32*t33-8.0d+0*t29*t31*t33-8.0d+0*t28*t29
     4         *t30-1.0d+1*t26*t28*t30-1.0d+1*t25*t26*t27-1.2d+1*t23*t25
     5         *t27-1.2d+1*t22*t23*t24-1.4d+1*t20*t22*t24-1.4d+1*t19*t20
     6         *t21-1.6d+1*t17*t19*t21-1.6d+1*t16*t17*t18-1.8d+1*t14*t16
     7         *t18-1.8d+1*t13*t14*t15-2.0d+1*t11*t13*t15-2.0d+1*t10*t11
     8         *t12)-9.305257363491002d-1*t4*t42*(-2.2d+1*t43*t56*t8-2.0
     9         d+0*t37*t53*t7-4.0d+0*t37*t52*t7-2.0d+0*t39*t53-4.0d+0*t3
     :         4*t36*t52-6.0d+0*t34*t36*t51-6.0d+0*t31*t33*t51-8.0d+0*t3
     ;         1*t33*t50-8.0d+0*t28*t30*t50-1.0d+1*t28*t30*t49-1.0d+1*t2
     <         5*t27*t49-1.2d+1*t25*t27*t48-1.2d+1*t22*t24*t48-1.4d+1*t2
     =         2*t24*t47-1.4d+1*t19*t21*t47-1.6d+1*t19*t21*t46-1.6d+1*t1
     >         6*t18*t46-1.8d+1*t16*t18*t45-1.8d+1*t13*t15*t45-2.0d+1*t1
     ?         3*t15*t44-2.0d+1*t10*t12*t44-2.2d+1*t10*t12*t43))*wght+Mm
     @         at(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammabb*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhob**1.3333333333333333d+0
            t5 = param(12)
            t6 = 9.115599744691192d+0*rhob**1.6666666666666669d+0
            t7 = t6-2.0d+0*taub
            t8 = t7**11
            t9 = 2.0d+0*taub+t6
            t10 = 1/t9**11
            t11 = param(11)
            t12 = t7**10
            t13 = 1/t9**10
            t14 = param(10)
            t15 = t7**9
            t16 = 1/t9**9
            t17 = param(9)
            t18 = t7**8
            t19 = 1/t9**8
            t20 = param(8)
            t21 = t7**7
            t22 = 1/t9**7
            t23 = param(7)
            t24 = t7**6
            t25 = 1/t9**6
            t26 = param(6)
            t27 = t7**5
            t28 = 1/t9**5
            t29 = param(5)
            t30 = t7**4
            t31 = 1/t9**4
            t32 = param(4)
            t33 = t7**3
            t34 = 1/t9**3
            t35 = param(3)
            t36 = t7**2
            t37 = 1/t9**2
            t38 = param(2)
            t39 = 1/t9
            t40 = t10*t5*t8+t38*t39*t7+t35*t36*t37+t32*t33*t34+t29*t30*t
     1         31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t17*t18*t19+t14*t1
     2         5*t16+t11*t12*t13+param(1)
            t41 = exp(-3.6802889260199856d-3*gammabb*t1)
            t42 = 5.52d-1*(1.0d+0-t41)+1.0d+0
            t43 = param(24)
            t44 = param(23)
            t45 = param(22)
            t46 = param(21)
            t47 = param(20)
            t48 = param(19)
            t49 = param(18)
            t50 = param(17)
            t51 = param(16)
            t52 = param(15)
            t53 = param(14)
            t54 = t10*t43*t8+t39*t53*t7+t36*t37*t52+t33*t34*t51+t30*t31*
     1         t50+t27*t28*t49+t24*t25*t48+t21*t22*t47+t18*t19*t46+t15*t
     2         16*t45+t12*t13*t44+param(13)
            t55 = rhob**6.666666666666666d-1
            t56 = 1/t9**12
            t57 = 1/t2**2
            t58 = 1/rhob**2.3333333333333334d+0
            t59 = rhob**3.333333333333333d-1
            t60 = 1/t4
            fnc(iq) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t54-9.3052573
     1         63491002d-1*t3*t4*t40)*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-1.671
     1         1932865267184d+2*t5*t55*t56*t8-1.5192666241151986d+1*t37*
     2         t38*t55*t7+3.038533248230397d+1*t35*t37*t55*t7+1.67119328
     3         65267184d+2*t10*t12*t5*t55+1.5192666241151986d+1*t38*t39*
     4         t55-3.038533248230397d+1*t34*t35*t36*t55+4.55779987234559
     5         65d+1*t32*t34*t36*t55-4.5577998723455965d+1*t31*t32*t33*t
     6         55+6.077066496460795d+1*t29*t31*t33*t55-6.077066496460795
     7         d+1*t28*t29*t30*t55+7.596333120575993d+1*t26*t28*t30*t55-
     8         7.596333120575993d+1*t25*t26*t27*t55+9.115599744691193d+1
     9         *t23*t25*t27*t55-9.115599744691193d+1*t22*t23*t24*t55+1.0
     :         634866368806391d+2*t20*t22*t24*t55-1.0634866368806391d+2*
     ;         t19*t20*t21*t55+1.2154132992921589d+2*t17*t19*t21*t55-1.2
     <         154132992921589d+2*t16*t17*t18*t55+1.3673399617036788d+2*
     =         t14*t16*t18*t55-1.3673399617036788d+2*t13*t14*t15*t55+1.5
     >         192666241151986d+2*t11*t13*t15*t55-1.5192666241151986d+2*
     ?         t10*t11*t12*t55)-9.305257363491002d-1*t4*t42*(-1.67119328
     @         65267184d+2*t43*t55*t56*t8-1.5192666241151986d+1*t37*t53*
     1         t55*t7+3.038533248230397d+1*t37*t52*t55*t7+1.519266624115
     2         1986d+1*t39*t53*t55-3.038533248230397d+1*t34*t36*t52*t55+
     3         4.5577998723455965d+1*t34*t36*t51*t55-4.5577998723455965d
     4         +1*t31*t33*t51*t55+6.077066496460795d+1*t31*t33*t50*t55-6
     5         .077066496460795d+1*t28*t30*t50*t55+7.596333120575993d+1*
     6         t28*t30*t49*t55-7.596333120575993d+1*t25*t27*t49*t55+9.11
     7         5599744691193d+1*t25*t27*t48*t55-9.115599744691193d+1*t22
     8         *t24*t48*t55+1.0634866368806391d+2*t22*t24*t47*t55-1.0634
     9         866368806391d+2*t19*t21*t47*t55+1.2154132992921589d+2*t19
     :         *t21*t46*t55-1.2154132992921589d+2*t16*t18*t46*t55+1.3673
     ;         399617036788d+2*t16*t18*t45*t55-1.3673399617036788d+2*t13
     <         *t15*t45*t55+1.5192666241151986d+2*t13*t15*t44*t55-1.5192
     =         666241151986d+2*t10*t12*t44*t55+1.6711932865267184d+2*t10
     >         *t12*t43*t55)-1.2407009817988002d+0*t42*t54*t59-1.2407009
     ?         817988002d+0*t3*t40*t59+8.963083509889702d-3*gammabb*t40*
     @         t57*t58+5.041016444533138d-3*gammabb*t41*t54*t58)*wght+Am
     1         at(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t40*t57*t60-
     1         1.890381166699927d-3*t41*t54*t60)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-2.2d+
     1         1*t5*t56*t8-2.0d+0*t37*t38*t7-4.0d+0*t35*t37*t7-2.2d+1*t1
     2         0*t12*t5-2.0d+0*t38*t39-4.0d+0*t34*t35*t36-6.0d+0*t32*t34
     3         *t36-6.0d+0*t31*t32*t33-8.0d+0*t29*t31*t33-8.0d+0*t28*t29
     4         *t30-1.0d+1*t26*t28*t30-1.0d+1*t25*t26*t27-1.2d+1*t23*t25
     5         *t27-1.2d+1*t22*t23*t24-1.4d+1*t20*t22*t24-1.4d+1*t19*t20
     6         *t21-1.6d+1*t17*t19*t21-1.6d+1*t16*t17*t18-1.8d+1*t14*t16
     7         *t18-1.8d+1*t13*t14*t15-2.0d+1*t11*t13*t15-2.0d+1*t10*t11
     8         *t12)-9.305257363491002d-1*t4*t42*(-2.2d+1*t43*t56*t8-2.0
     9         d+0*t37*t53*t7-4.0d+0*t37*t52*t7-2.0d+0*t39*t53-4.0d+0*t3
     :         4*t36*t52-6.0d+0*t34*t36*t51-6.0d+0*t31*t33*t51-8.0d+0*t3
     ;         1*t33*t50-8.0d+0*t28*t30*t50-1.0d+1*t28*t30*t49-1.0d+1*t2
     <         5*t27*t49-1.2d+1*t25*t27*t48-1.2d+1*t22*t24*t48-1.4d+1*t2
     =         2*t24*t47-1.4d+1*t19*t21*t47-1.6d+1*t19*t21*t46-1.6d+1*t1
     >         6*t18*t46-1.8d+1*t16*t18*t45-1.8d+1*t13*t15*t45-2.0d+1*t1
     ?         3*t15*t44-2.0d+1*t10*t12*t44-2.2d+1*t10*t12*t43))*wght+Mm
     @         at(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_m08 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_4} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_5} &=& 9.115599744691192\,\rho_\alpha^{{{5}\over{3}}}\\\\ 
C>   {\it t_6} &=& {\it t_5}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_7} &=& {\it t_6}^{11}\\\\ 
C>   {\it t_8} &=& 2.0\,\tau_\alpha+{\it t_5}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_8}^{11}}}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{11}} &=& {\it t_6}^{10}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_8}^{10}}}\\\\ 
C>   {\it t_{13}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{14}} &=& {\it t_6}^9\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_8}^9}}\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{17}} &=& {\it t_6}^8\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_8}^8}}\\\\ 
C>   {\it t_{19}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{20}} &=& {\it t_6}^7\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_8}^7}}\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{23}} &=& {\it t_6}^6\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_8}^6}}\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{26}} &=& {\it t_6}^5\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_8}^5}}\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{29}} &=& {\it t_6}^4\\\\ 
C>   {\it t_{30}} &=& {{1}\over{{\it t_8}^4}}\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{32}} &=& {\it t_6}^3\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_8}^3}}\\\\ 
C>   {\it t_{34}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{35}} &=& {\it t_6}^2\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_8}^2}}\\\\ 
C>   {\it t_{37}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_8}}}\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{44}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{49}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{50}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{51}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{52}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{53}} &=& 9.115599744691192\,\rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{54}} &=& {\it t_{53}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{55}} &=& {\it t_{54}}^{11}\\\\ 
C>   {\it t_{56}} &=& 2.0\,\tau_\beta+{\it t_{53}}\\\\ 
C>   {\it t_{57}} &=& {{1}\over{{\it t_{56}}^{11}}}\\\\ 
C>   {\it t_{58}} &=& {\it t_{54}}^{10}\\\\ 
C>   {\it t_{59}} &=& {{1}\over{{\it t_{56}}^{10}}}\\\\ 
C>   {\it t_{60}} &=& {\it t_{54}}^9\\\\ 
C>   {\it t_{61}} &=& {{1}\over{{\it t_{56}}^9}}\\\\ 
C>   {\it t_{62}} &=& {\it t_{54}}^8\\\\ 
C>   {\it t_{63}} &=& {{1}\over{{\it t_{56}}^8}}\\\\ 
C>   {\it t_{64}} &=& {\it t_{54}}^7\\\\ 
C>   {\it t_{65}} &=& {{1}\over{{\it t_{56}}^7}}\\\\ 
C>   {\it t_{66}} &=& {\it t_{54}}^6\\\\ 
C>   {\it t_{67}} &=& {{1}\over{{\it t_{56}}^6}}\\\\ 
C>   {\it t_{68}} &=& {\it t_{54}}^5\\\\ 
C>   {\it t_{69}} &=& {{1}\over{{\it t_{56}}^5}}\\\\ 
C>   {\it t_{70}} &=& {\it t_{54}}^4\\\\ 
C>   {\it t_{71}} &=& {{1}\over{{\it t_{56}}^4}}\\\\ 
C>   {\it t_{72}} &=& {\it t_{54}}^3\\\\ 
C>   {\it t_{73}} &=& {{1}\over{{\it t_{56}}^3}}\\\\ 
C>   {\it t_{74}} &=& {\it t_{54}}^2\\\\ 
C>   {\it t_{75}} &=& {{1}\over{{\it t_{56}}^2}}\\\\ 
C>   {\it t_{76}} &=& {{1}\over{{\it t_{56}}}}\\\\ 
C>   {\it t_{77}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{78}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{79}} &=& 9.115599744691192\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{80}} &=& {\it t_{79}}-2.0\,\tau_s\\\\ 
C>   {\it t_{81}} &=& {\it t_{80}}^{11}\\\\ 
C>   {\it t_{82}} &=& 2.0\,\tau_s+{\it t_{79}}\\\\ 
C>   {\it t_{83}} &=& {{1}\over{{\it t_{82}}^{11}}}\\\\ 
C>   {\it t_{84}} &=& {\it t_{80}}^{10}\\\\ 
C>   {\it t_{85}} &=& {{1}\over{{\it t_{82}}^{10}}}\\\\ 
C>   {\it t_{86}} &=& {\it t_{80}}^9\\\\ 
C>   {\it t_{87}} &=& {{1}\over{{\it t_{82}}^9}}\\\\ 
C>   {\it t_{88}} &=& {\it t_{80}}^8\\\\ 
C>   {\it t_{89}} &=& {{1}\over{{\it t_{82}}^8}}\\\\ 
C>   {\it t_{90}} &=& {\it t_{80}}^7\\\\ 
C>   {\it t_{91}} &=& {{1}\over{{\it t_{82}}^7}}\\\\ 
C>   {\it t_{92}} &=& {\it t_{80}}^6\\\\ 
C>   {\it t_{93}} &=& {{1}\over{{\it t_{82}}^6}}\\\\ 
C>   {\it t_{94}} &=& {\it t_{80}}^5\\\\ 
C>   {\it t_{95}} &=& {{1}\over{{\it t_{82}}^5}}\\\\ 
C>   {\it t_{96}} &=& {\it t_{80}}^4\\\\ 
C>   {\it t_{97}} &=& {{1}\over{{\it t_{82}}^4}}\\\\ 
C>   {\it t_{98}} &=& {\it t_{80}}^3\\\\ 
C>   {\it t_{99}} &=& {{1}\over{{\it t_{82}}^3}}\\\\ 
C>   {\it t_{100}} &=& {\it t_{80}}^2\\\\ 
C>   {\it t_{101}} &=& {{1}\over{{\it t_{82}}^2}}\\\\ 
C>   {\it t_{102}} &=& {{1}\over{{\it t_{82}}}}\\\\ 
C>   f &=& 1.0\,\left(-0.9305257363491002\,{\it t_{51}}\,\left(0.552
C>    \,\left(1.0-{{1}\over{e^{0.003680288926019986\,{\it t_{52}}
C>    \,\sigma_{\beta\beta}}}}\right)+1.0\right)\,\left({\it t_{50}}
C>    \,{\it t_{54}}\,{\it t_{76}}+{\it t_{49}}\,{\it t_{74}}\,{
C>    \it t_{75}}+{\it t_{48}}\,{\it t_{72}}\,{\it t_{73}}+{
C>    \it t_{47}}\,{\it t_{70}}\,{\it t_{71}}+{\it t_{46}}\,{
C>    \it t_{68}}\,{\it t_{69}}+{\it t_{45}}\,{\it t_{66}}\,{
C>    \it t_{67}}+{\it t_{44}}\,{\it t_{64}}\,{\it t_{65}}+{
C>    \it t_{43}}\,{\it t_{62}}\,{\it t_{63}}+{\it t_{42}}\,{
C>    \it t_{60}}\,{\it t_{61}}+{\it t_{41}}\,{\it t_{58}}\,{
C>    \it t_{59}}+{\it t_{40}}\,{\it t_{55}}\,{\it t_{57}}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_{51}}\,
C>    \left(0.804\,\left(1.0-{{1.0}\over{0.004492667444378077\,{
C>    \it t_{52}}\,\sigma_{\beta\beta}+1.0}}\right)+1.0\right)
C>    \,\left({\it t_{37}}\,{\it t_{54}}\,{\it t_{76}}+{\it t_{34}}
C>    \,{\it t_{74}}\,{\it t_{75}}+{\it t_{31}}\,{\it t_{72}}\,{
C>    \it t_{73}}+{\it t_{28}}\,{\it t_{70}}\,{\it t_{71}}+{
C>    \it t_{25}}\,{\it t_{68}}\,{\it t_{69}}+{\it t_{22}}\,{
C>    \it t_{66}}\,{\it t_{67}}+{\it t_{19}}\,{\it t_{64}}\,{
C>    \it t_{65}}+{\it t_{16}}\,{\it t_{62}}\,{\it t_{63}}+{
C>    \it t_{13}}\,{\it t_{60}}\,{\it t_{61}}+{\it t_{10}}\,{
C>    \it t_{58}}\,{\it t_{59}}+{\it t_4}\,{\it t_{55}}\,{\it t_{57}}
C>    +{\it t_3}\right)\right)+1.0\,\left(-0.9305257363491002\,{
C>    \it t_1}\,\left(0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}}}}\right)+1.0\right)\,\left({\it t_{50}}
C>    \,{\it t_6}\,{\it t_{38}}+{\it t_{49}}\,{\it t_{35}}\,{
C>    \it t_{36}}+{\it t_{48}}\,{\it t_{32}}\,{\it t_{33}}+{
C>    \it t_{47}}\,{\it t_{29}}\,{\it t_{30}}+{\it t_{46}}\,{
C>    \it t_{26}}\,{\it t_{27}}+{\it t_{45}}\,{\it t_{23}}\,{
C>    \it t_{24}}+{\it t_{44}}\,{\it t_{20}}\,{\it t_{21}}+{
C>    \it t_{43}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{42}}\,{
C>    \it t_{14}}\,{\it t_{15}}+{\it t_{41}}\,{\it t_{11}}\,{
C>    \it t_{12}}+{\it t_{40}}\,{\it t_7}\,{\it t_9}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_1}\,\left(0.804
C>    \,\left(1.0-{{1.0}\over{0.004492667444378077\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0}}\right)+1.0\right)\,\left({
C>    \it t_{37}}\,{\it t_6}\,{\it t_{38}}+{\it t_{34}}\,{
C>    \it t_{35}}\,{\it t_{36}}+{\it t_{31}}\,{\it t_{32}}\,{
C>    \it t_{33}}+{\it t_{28}}\,{\it t_{29}}\,{\it t_{30}}+{
C>    \it t_{25}}\,{\it t_{26}}\,{\it t_{27}}+{\it t_{22}}\,{
C>    \it t_{23}}\,{\it t_{24}}+{\it t_{19}}\,{\it t_{20}}\,{
C>    \it t_{21}}+{\it t_{16}}\,{\it t_{17}}\,{\it t_{18}}+{
C>    \it t_{13}}\,{\it t_{14}}\,{\it t_{15}}+{\it t_{10}}\,{
C>    \it t_{11}}\,{\it t_{12}}+{\it t_4}\,{\it t_7}\,{\it t_9}+{
C>    \it t_3}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-0.9305257363491002\,{\it t_{77}}\,\left(0.552
C>    \,\left(1.0-{{1}\over{e^{0.003680288926019986\,{\it t_{78}}
C>    \,\sigma_{ss}}}}\right)+1.0\right)\,\left({\it t_{50}}\,{
C>    \it t_{80}}\,{\it t_{102}}+{\it t_{49}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{48}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{47}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{46}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{45}}\,{\it t_{92}}\,{
C>    \it t_{93}}+{\it t_{44}}\,{\it t_{90}}\,{\it t_{91}}+{
C>    \it t_{43}}\,{\it t_{88}}\,{\it t_{89}}+{\it t_{42}}\,{
C>    \it t_{86}}\,{\it t_{87}}+{\it t_{41}}\,{\it t_{84}}\,{
C>    \it t_{85}}+{\it t_{40}}\,{\it t_{81}}\,{\it t_{83}}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_{77}}\,
C>    \left(0.804\,\left(1.0-{{1.0}\over{0.004492667444378077\,{
C>    \it t_{78}}\,\sigma_{ss}+1.0}}\right)+1.0\right)\,\left({
C>    \it t_{37}}\,{\it t_{80}}\,{\it t_{102}}+{\it t_{34}}\,{
C>    \it t_{100}}\,{\it t_{101}}+{\it t_{31}}\,{\it t_{98}}\,{
C>    \it t_{99}}+{\it t_{28}}\,{\it t_{96}}\,{\it t_{97}}+{
C>    \it t_{25}}\,{\it t_{94}}\,{\it t_{95}}+{\it t_{22}}\,{
C>    \it t_{92}}\,{\it t_{93}}+{\it t_{19}}\,{\it t_{90}}\,{
C>    \it t_{91}}+{\it t_{16}}\,{\it t_{88}}\,{\it t_{89}}+{
C>    \it t_{13}}\,{\it t_{86}}\,{\it t_{87}}+{\it t_{10}}\,{
C>    \it t_{84}}\,{\it t_{85}}+{\it t_4}\,{\it t_{81}}\,{\it t_{83}}
C>    +{\it t_3}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.TheoryComput. 4, 1849 (2008)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/ct800246v "> 
C> 10.1021/ct800246v </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m08_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(12)
            t6 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t7 = t6-2.0d+0*taua
            t8 = t7**11
            t9 = 2.0d+0*taua+t6
            t10 = 1/t9**11
            t11 = param(11)
            t12 = t7**10
            t13 = 1/t9**10
            t14 = param(10)
            t15 = t7**9
            t16 = 1/t9**9
            t17 = param(9)
            t18 = t7**8
            t19 = 1/t9**8
            t20 = param(8)
            t21 = t7**7
            t22 = 1/t9**7
            t23 = param(7)
            t24 = t7**6
            t25 = 1/t9**6
            t26 = param(6)
            t27 = t7**5
            t28 = 1/t9**5
            t29 = param(5)
            t30 = t7**4
            t31 = 1/t9**4
            t32 = param(4)
            t33 = t7**3
            t34 = 1/t9**3
            t35 = param(3)
            t36 = t7**2
            t37 = 1/t9**2
            t38 = param(2)
            t39 = 1/t9
            t40 = t10*t5*t8+t38*t39*t7+t35*t36*t37+t32*t33*t34+t29*t30*t
     1         31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t17*t18*t19+t14*t1
     2         5*t16+t11*t12*t13+param(1)
            t41 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t42 = 5.52d-1*(1.0d+0-t41)+1.0d+0
            t43 = param(24)
            t44 = param(23)
            t45 = param(22)
            t46 = param(21)
            t47 = param(20)
            t48 = param(19)
            t49 = param(18)
            t50 = param(17)
            t51 = param(16)
            t52 = param(15)
            t53 = param(14)
            t54 = t10*t43*t8+t39*t53*t7+t36*t37*t52+t33*t34*t51+t30*t31*
     1         t50+t27*t28*t49+t24*t25*t48+t21*t22*t47+t18*t19*t46+t15*t
     2         16*t45+t12*t13*t44+param(13)
            t55 = rhoa**6.666666666666666d-1
            t56 = 1/t9**12
            t57 = -1.6711932865267184d+2*t5*t55*t56*t8-1.519266624115198
     1         6d+1*t37*t38*t55*t7+3.038533248230397d+1*t35*t37*t55*t7+1
     2         .6711932865267184d+2*t10*t12*t5*t55+1.5192666241151986d+1
     3         *t38*t39*t55-3.038533248230397d+1*t34*t35*t36*t55+4.55779
     4         98723455965d+1*t32*t34*t36*t55-4.5577998723455965d+1*t31*
     5         t32*t33*t55+6.077066496460795d+1*t29*t31*t33*t55-6.077066
     6         496460795d+1*t28*t29*t30*t55+7.596333120575993d+1*t26*t28
     7         *t30*t55-7.596333120575993d+1*t25*t26*t27*t55+9.115599744
     8         691193d+1*t23*t25*t27*t55-9.115599744691193d+1*t22*t23*t2
     9         4*t55+1.0634866368806391d+2*t20*t22*t24*t55-1.06348663688
     :         06391d+2*t19*t20*t21*t55+1.2154132992921589d+2*t17*t19*t2
     ;         1*t55-1.2154132992921589d+2*t16*t17*t18*t55+1.36733996170
     <         36788d+2*t14*t16*t18*t55-1.3673399617036788d+2*t13*t14*t1
     =         5*t55+1.5192666241151986d+2*t11*t13*t15*t55-1.51926662411
     >         51986d+2*t10*t11*t12*t55
            t58 = -1.6711932865267184d+2*t43*t55*t56*t8-1.51926662411519
     1         86d+1*t37*t53*t55*t7+3.038533248230397d+1*t37*t52*t55*t7+
     2         1.5192666241151986d+1*t39*t53*t55-3.038533248230397d+1*t3
     3         4*t36*t52*t55+4.5577998723455965d+1*t34*t36*t51*t55-4.557
     4         7998723455965d+1*t31*t33*t51*t55+6.077066496460795d+1*t31
     5         *t33*t50*t55-6.077066496460795d+1*t28*t30*t50*t55+7.59633
     6         3120575993d+1*t28*t30*t49*t55-7.596333120575993d+1*t25*t2
     7         7*t49*t55+9.115599744691193d+1*t25*t27*t48*t55-9.11559974
     8         4691193d+1*t22*t24*t48*t55+1.0634866368806391d+2*t22*t24*
     9         t47*t55-1.0634866368806391d+2*t19*t21*t47*t55+1.215413299
     :         2921589d+2*t19*t21*t46*t55-1.2154132992921589d+2*t16*t18*
     ;         t46*t55+1.3673399617036788d+2*t16*t18*t45*t55-1.367339961
     <         7036788d+2*t13*t15*t45*t55+1.5192666241151986d+2*t13*t15*
     =         t44*t55-1.5192666241151986d+2*t10*t12*t44*t55+1.671193286
     >         5267184d+2*t10*t12*t43*t55
            t59 = 1/t2**2
            t60 = 1/rhoa**2.3333333333333334d+0
            t61 = rhoa**3.333333333333333d-1
            t62 = 1/t4
            t63 = -2.2d+1*t5*t56*t8-2.0d+0*t37*t38*t7-4.0d+0*t35*t37*t7-
     1         2.2d+1*t10*t12*t5-2.0d+0*t38*t39-4.0d+0*t34*t35*t36-6.0d+
     2         0*t32*t34*t36-6.0d+0*t31*t32*t33-8.0d+0*t29*t31*t33-8.0d+
     3         0*t28*t29*t30-1.0d+1*t26*t28*t30-1.0d+1*t25*t26*t27-1.2d+
     4         1*t23*t25*t27-1.2d+1*t22*t23*t24-1.4d+1*t20*t22*t24-1.4d+
     5         1*t19*t20*t21-1.6d+1*t17*t19*t21-1.6d+1*t16*t17*t18-1.8d+
     6         1*t14*t16*t18-1.8d+1*t13*t14*t15-2.0d+1*t11*t13*t15-2.0d+
     7         1*t10*t11*t12
            t64 = -2.2d+1*t43*t56*t8-2.0d+0*t37*t53*t7-4.0d+0*t37*t52*t7
     1         -2.0d+0*t39*t53-4.0d+0*t34*t36*t52-6.0d+0*t34*t36*t51-6.0
     2         d+0*t31*t33*t51-8.0d+0*t31*t33*t50-8.0d+0*t28*t30*t50-1.0
     3         d+1*t28*t30*t49-1.0d+1*t25*t27*t49-1.2d+1*t25*t27*t48-1.2
     4         d+1*t22*t24*t48-1.4d+1*t22*t24*t47-1.4d+1*t19*t21*t47-1.6
     5         d+1*t19*t21*t46-1.6d+1*t16*t18*t46-1.8d+1*t16*t18*t45-1.8
     6         d+1*t13*t15*t45-2.0d+1*t13*t15*t44-2.0d+1*t10*t12*t44-2.2
     7         d+1*t10*t12*t43
            t65 = 1/t9**13
            t66 = 1/t61
            t67 = gammaaa**2
            t68 = 1/t2**3
            t69 = 1/rhoa**6
            t70 = 1/rhoa**3.3333333333333337d+0
            t71 = 1/rhoa**5
            t72 = 1/rhoa**4
            fnc(iq) = 2.0d+0*(-9.305257363491002d-1*t4*t42*t54-9.3052573
     1         63491002d-1*t3*t4*t40)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t42*t54*t61-
     1         1.2407009817988002d+0*t3*t40*t61+8.963083509889702d-3*gam
     2         maaa*t40*t59*t60+5.041016444533138d-3*gammaaa*t41*t54*t60
     3         -9.305257363491002d-1*t4*t42*t58-9.305257363491002d-1*t3*
     4         t4*t57)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t40*t59*t62-
     1         1.890381166699927d-3*t41*t54*t62)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t64-9.
     1         305257363491002d-1*t3*t4*t63)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-1
     1         .1141288576844789d+2*t5*t56*t66*t8+3.046785819198518d+4*t
     2         4*t5*t65*t8-1.0128444160767991d+1*t37*t38*t66*t7+2.025688
     3         8321535982d+1*t35*t37*t66*t7+4.6163421503007845d+2*t34*t3
     4         8*t4*t7-1.846536860120314d+3*t34*t35*t4*t7+1.384902645090
     5         2355d+3*t32*t34*t4*t7+1.1141288576844789d+2*t10*t12*t5*t6
     6         6+1.0128444160767991d+1*t38*t39*t66-2.0256888321535982d+1
     7         *t34*t35*t36*t66+3.038533248230397d+1*t32*t34*t36*t66-3.0
     8         38533248230397d+1*t31*t32*t33*t66+4.0513776643071964d+1*t
     9         29*t31*t33*t66-4.0513776643071964d+1*t28*t29*t30*t66+5.06
     :         4222080383994d+1*t26*t28*t30*t66-5.064222080383994d+1*t25
     ;         *t26*t27*t66+6.077066496460795d+1*t23*t25*t27*t66-6.07706
     <         6496460795d+1*t22*t23*t24*t66+7.089910912537593d+1*t20*t2
     =         2*t24*t66-7.089910912537593d+1*t19*t20*t21*t66+8.10275532
     >         8614393d+1*t17*t19*t21*t66-8.102755328614393d+1*t16*t17*t
     ?         18*t66+9.115599744691191d+1*t14*t16*t18*t66-9.11559974469
     @         1191d+1*t13*t14*t15*t66+1.012844416076799d+2*t11*t13*t15*
     1         t66-1.012844416076799d+2*t10*t11*t12*t66-5.58577400186394
     2         9d+4*t12*t4*t5*t56+2.5389881826654315d+4*t11*t12*t4*t56+2
     3         .5389881826654315d+4*t10*t15*t4*t5-4.6163421503007845d+2*
     4         t37*t38*t4+4.6163421503007845d+2*t35*t37*t4+1.38490264509
     5         02355d+3*t31*t35*t36*t4-4.1547079352707067d+3*t31*t32*t36
     6         *t4+2.769805290180471d+3*t29*t31*t36*t4+2.769805290180471
     7         d+3*t28*t32*t33*t4-7.386147440481255d+3*t28*t29*t33*t4+4.
     8         616342150300784d+3*t26*t28*t33*t4+4.616342150300784d+3*t2
     9         5*t29*t30*t4-1.154085537575196d+4*t25*t26*t30*t4+6.924513
     :         225451178d+3*t23*t25*t30*t4+6.924513225451178d+3*t22*t26*
     ;         t27*t4-1.661883174108283d+4*t22*t23*t27*t4+9.694318515631
     <         648d+3*t20*t22*t27*t4+9.694318515631648d+3*t19*t23*t24*t4
     =         -2.2620076536473846d+4*t19*t20*t24*t4+1.2925758020842196d
     >         +4*t17*t19*t24*t4+1.2925758020842196d+4*t16*t20*t21*t4-2.
     ?         954458976192502d+4*t16*t17*t21*t4+1.6618831741082823d+4*t
     @         14*t16*t21*t4+1.6618831741082823d+4*t13*t17*t18*t4-3.7392
     1         371417436354d+4*t13*t14*t18*t4+2.0773539676353528d+4*t11*
     2         t13*t18*t4+2.0773539676353528d+4*t10*t14*t15*t4-4.6163421
     3         50300784d+4*t10*t11*t15*t4)-9.305257363491002d-1*t4*t42*(
     4         -1.1141288576844789d+2*t43*t56*t66*t8+3.046785819198518d+
     5         4*t4*t43*t65*t8-1.0128444160767991d+1*t37*t53*t66*t7+2.02
     6         56888321535982d+1*t37*t52*t66*t7+4.6163421503007845d+2*t3
     7         4*t4*t53*t7-1.846536860120314d+3*t34*t4*t52*t7+1.38490264
     8         50902355d+3*t34*t4*t51*t7+1.0128444160767991d+1*t39*t53*t
     9         66-2.0256888321535982d+1*t34*t36*t52*t66+3.03853324823039
     :         7d+1*t34*t36*t51*t66-3.038533248230397d+1*t31*t33*t51*t66
     ;         +4.0513776643071964d+1*t31*t33*t50*t66-4.0513776643071964
     <         d+1*t28*t30*t50*t66+5.064222080383994d+1*t28*t30*t49*t66-
     =         5.064222080383994d+1*t25*t27*t49*t66+6.077066496460795d+1
     >         *t25*t27*t48*t66-6.077066496460795d+1*t22*t24*t48*t66+7.0
     ?         89910912537593d+1*t22*t24*t47*t66-7.089910912537593d+1*t1
     @         9*t21*t47*t66+8.102755328614393d+1*t19*t21*t46*t66-8.1027
     1         55328614393d+1*t16*t18*t46*t66+9.115599744691191d+1*t16*t
     2         18*t45*t66-9.115599744691191d+1*t13*t15*t45*t66+1.0128444
     3         16076799d+2*t13*t15*t44*t66-1.012844416076799d+2*t10*t12*
     4         t44*t66+1.1141288576844789d+2*t10*t12*t43*t66+2.538988182
     5         6654315d+4*t12*t4*t44*t56-5.585774001863949d+4*t12*t4*t43
     6         *t56-4.6163421503007845d+2*t37*t4*t53+4.6163421503007845d
     7         +2*t37*t4*t52+1.3849026450902355d+3*t31*t36*t4*t52-4.1547
     8         079352707067d+3*t31*t36*t4*t51+2.769805290180471d+3*t28*t
     9         33*t4*t51+2.769805290180471d+3*t31*t36*t4*t50-7.386147440
     :         481255d+3*t28*t33*t4*t50+4.616342150300784d+3*t25*t30*t4*
     ;         t50+4.616342150300784d+3*t28*t33*t4*t49-1.154085537575196
     <         d+4*t25*t30*t4*t49+6.924513225451178d+3*t22*t27*t4*t49+6.
     =         924513225451178d+3*t25*t30*t4*t48-1.661883174108283d+4*t2
     >         2*t27*t4*t48+9.694318515631648d+3*t19*t24*t4*t48+9.694318
     ?         515631648d+3*t22*t27*t4*t47-2.2620076536473846d+4*t19*t24
     @         *t4*t47+1.2925758020842196d+4*t16*t21*t4*t47+1.2925758020
     1         842196d+4*t19*t24*t4*t46-2.954458976192502d+4*t16*t21*t4*
     2         t46+1.6618831741082823d+4*t13*t18*t4*t46+1.66188317410828
     3         23d+4*t16*t21*t4*t45-3.7392371417436354d+4*t13*t18*t4*t45
     4         +2.0773539676353528d+4*t10*t15*t4*t45+2.0773539676353528d
     5         +4*t13*t18*t4*t44-4.616342150300784d+4*t10*t15*t4*t44+2.5
     6         389881826654315d+4*t10*t15*t4*t43)-8.963083509889707d-3*g
     7         ammaaa*t40*t59*t70-5.041016444533138d-3*gammaaa*t41*t54*t
     8         70+2.1476348525932504d-4*t40*t67*t68*t69+4.94730586578665
     9         3d-5*t41*t54*t67*t69-2.4814019635976003d+0*t42*t58*t61-2.
     :         4814019635976003d+0*t3*t57*t61+1.7926167019779404d-2*gamm
     ;         aaa*t57*t59*t60+1.0082032889066277d-2*gammaaa*t41*t58*t60
     <         +(-4.135669939329334d-1*t42*t54-4.135669939329334d-1*t3*t
     =         40)/t55)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(-8.05363069722469d-5*gammaaa*t
     1         40*t68*t71-1.855239699669995d-5*gammaaa*t41*t54*t71-3.361
     2         156316208638d-3*t57*t59*t62-1.890381166699927d-3*t41*t58*
     3         t62+4.481541754944851d-3*t40*t59*t60+2.520508222266569d-3
     4         *t41*t54*t60)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(3.020111511459258d-5*t40*t68*
     1         t72+6.957148873762482d-6*t41*t54*t72)*wght+Cmat2(iq,D2_GA
     2         A_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(4.
     1         0108638876641245d+3*t5*t55*t65*t8+6.077066496460795d+1*t3
     2         4*t38*t55*t7-1.8231199489382385d+2*t32*t34*t55*t7+3.34238
     3         6573053437d+3*t11*t12*t55*t56-3.342386573053437d+3*t10*t1
     4         5*t5*t55-6.077066496460795d+1*t35*t37*t55+1.8231199489382
     5         385d+2*t31*t35*t36*t55-3.646239897876477d+2*t29*t31*t36*t
     6         55+3.646239897876477d+2*t28*t32*t33*t55-6.077066496460795
     7         d+2*t26*t28*t33*t55+6.077066496460795d+2*t25*t29*t30*t55-
     8         9.115599744691192d+2*t23*t25*t30*t55+9.115599744691192d+2
     9         *t22*t26*t27*t55-1.276183964256767d+3*t20*t22*t27*t55+1.2
     :         76183964256767d+3*t19*t23*t24*t55-1.7015786190090226d+3*t
     ;         17*t19*t24*t55+1.7015786190090226d+3*t16*t20*t21*t55-2.18
     <         7743938725886d+3*t14*t16*t21*t55+2.187743938725886d+3*t13
     =         *t17*t18*t55-2.734679923407357d+3*t11*t13*t18*t55+2.73467
     >         9923407357d+3*t10*t14*t15*t55)-9.305257363491002d-1*t4*t4
     ?         2*(4.0108638876641245d+3*t43*t55*t65*t8+6.077066496460795
     @         d+1*t34*t53*t55*t7-1.8231199489382385d+2*t34*t51*t55*t7+3
     1         .342386573053437d+3*t12*t44*t55*t56-6.077066496460795d+1*
     2         t37*t52*t55+1.8231199489382385d+2*t31*t36*t52*t55+3.64623
     3         9897876477d+2*t28*t33*t51*t55-3.646239897876477d+2*t31*t3
     4         6*t50*t55+6.077066496460795d+2*t25*t30*t50*t55-6.07706649
     5         6460795d+2*t28*t33*t49*t55+9.115599744691192d+2*t22*t27*t
     6         49*t55-9.115599744691192d+2*t25*t30*t48*t55+1.27618396425
     7         6767d+3*t19*t24*t48*t55-1.276183964256767d+3*t22*t27*t47*
     8         t55+1.7015786190090226d+3*t16*t21*t47*t55-1.7015786190090
     9         226d+3*t19*t24*t46*t55+2.187743938725886d+3*t13*t18*t46*t
     :         55-2.187743938725886d+3*t16*t21*t45*t55+2.734679923407357
     ;         d+3*t10*t15*t45*t55-2.734679923407357d+3*t13*t18*t44*t55-
     <         3.342386573053437d+3*t10*t15*t43*t55)-1.2407009817988002d
     =         +0*t42*t61*t64+5.041016444533138d-3*gammaaa*t41*t60*t64-1
     >         .2407009817988002d+0*t3*t61*t63+8.963083509889702d-3*gamm
     ?         aaa*t59*t60*t63)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-1.890381166699927d-3*t41*t62*
     1         t64-3.361156316208638d-3*t59*t62*t63)*wght+Mmat2(iq,D2_GA
     2         A_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(5.
     1         28d+2*t5*t65*t8+8.0d+0*t34*t38*t7+3.2d+1*t34*t35*t7+2.4d+
     2         1*t32*t34*t7+9.68d+2*t12*t5*t56+4.4d+2*t11*t12*t56+4.4d+2
     3         *t10*t15*t5+8.0d+0*t37*t38+8.0d+0*t35*t37+2.4d+1*t31*t35*
     4         t36+7.2d+1*t31*t32*t36+4.8d+1*t29*t31*t36+4.8d+1*t28*t32*
     5         t33+1.28d+2*t28*t29*t33+8.0d+1*t26*t28*t33+8.0d+1*t25*t29
     6         *t30+2.0d+2*t25*t26*t30+1.2d+2*t23*t25*t30+1.2d+2*t22*t26
     7         *t27+2.88d+2*t22*t23*t27+1.68d+2*t20*t22*t27+1.68d+2*t19*
     8         t23*t24+3.92d+2*t19*t20*t24+2.24d+2*t17*t19*t24+2.24d+2*t
     9         16*t20*t21+5.12d+2*t16*t17*t21+2.88d+2*t14*t16*t21+2.88d+
     :         2*t13*t17*t18+6.48d+2*t13*t14*t18+3.6d+2*t11*t13*t18+3.6d
     ;         +2*t10*t14*t15+8.0d+2*t10*t11*t15)-9.305257363491002d-1*t
     <         4*t42*(5.28d+2*t43*t65*t8+8.0d+0*t34*t53*t7+3.2d+1*t34*t5
     =         2*t7+2.4d+1*t34*t51*t7+4.4d+2*t12*t44*t56+9.68d+2*t12*t43
     >         *t56+8.0d+0*t37*t53+8.0d+0*t37*t52+2.4d+1*t31*t36*t52+7.2
     ?         d+1*t31*t36*t51+4.8d+1*t28*t33*t51+4.8d+1*t31*t36*t50+1.2
     @         8d+2*t28*t33*t50+8.0d+1*t25*t30*t50+8.0d+1*t28*t33*t49+2.
     1         0d+2*t25*t30*t49+1.2d+2*t22*t27*t49+1.2d+2*t25*t30*t48+2.
     2         88d+2*t22*t27*t48+1.68d+2*t19*t24*t48+1.68d+2*t22*t27*t47
     3         +3.92d+2*t19*t24*t47+2.24d+2*t16*t21*t47+2.24d+2*t19*t24*
     4         t46+5.12d+2*t16*t21*t46+2.88d+2*t13*t18*t46+2.88d+2*t16*t
     5         21*t45+6.48d+2*t13*t18*t45+3.6d+2*t10*t15*t45+3.6d+2*t13*
     6         t18*t44+8.0d+2*t10*t15*t44+4.4d+2*t10*t15*t43))*wght+Mmat
     7         2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(1)
            t6 = param(12)
            t7 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t8 = t7-2.0d+0*taua
            t9 = t8**11
            t10 = 2.0d+0*taua+t7
            t11 = 1/t10**11
            t12 = param(11)
            t13 = t8**10
            t14 = 1/t10**10
            t15 = param(10)
            t16 = t8**9
            t17 = 1/t10**9
            t18 = param(9)
            t19 = t8**8
            t20 = 1/t10**8
            t21 = param(8)
            t22 = t8**7
            t23 = 1/t10**7
            t24 = param(7)
            t25 = t8**6
            t26 = 1/t10**6
            t27 = param(6)
            t28 = t8**5
            t29 = 1/t10**5
            t30 = param(5)
            t31 = t8**4
            t32 = 1/t10**4
            t33 = param(4)
            t34 = t8**3
            t35 = 1/t10**3
            t36 = param(3)
            t37 = t8**2
            t38 = 1/t10**2
            t39 = param(2)
            t40 = 1/t10
            t41 = t11*t6*t9+t39*t40*t8+t5+t36*t37*t38+t33*t34*t35+t30*t3
     1         1*t32+t27*t28*t29+t24*t25*t26+t21*t22*t23+t18*t19*t20+t15
     2         *t16*t17+t12*t13*t14
            t42 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t43 = 5.52d-1*(1.0d+0-t42)+1.0d+0
            t44 = param(13)
            t45 = param(24)
            t46 = param(23)
            t47 = param(22)
            t48 = param(21)
            t49 = param(20)
            t50 = param(19)
            t51 = param(18)
            t52 = param(17)
            t53 = param(16)
            t54 = param(15)
            t55 = param(14)
            t56 = t11*t45*t9+t40*t55*t8+t37*t38*t54+t34*t35*t53+t31*t32*
     1         t52+t28*t29*t51+t25*t26*t50+t22*t23*t49+t19*t20*t48+t16*t
     2         17*t47+t13*t14*t46+t44
            t57 = 1/rhob**2.6666666666666666d+0
            t58 = 4.492667444378077d-3*gammabb*t57+1.0d+0
            t59 = 8.04d-1*(1.0d+0-1.0d+0/t58)+1.0d+0
            t60 = rhob**1.3333333333333333d+0
            t61 = 9.115599744691192d+0*rhob**1.6666666666666669d+0
            t62 = t61-2.0d+0*taub
            t63 = t62**11
            t64 = 2.0d+0*taub+t61
            t65 = 1/t64**11
            t66 = t62**10
            t67 = 1/t64**10
            t68 = t62**9
            t69 = 1/t64**9
            t70 = t62**8
            t71 = 1/t64**8
            t72 = t62**7
            t73 = 1/t64**7
            t74 = t62**6
            t75 = 1/t64**6
            t76 = t62**5
            t77 = 1/t64**5
            t78 = t62**4
            t79 = 1/t64**4
            t80 = t62**3
            t81 = 1/t64**3
            t82 = t62**2
            t83 = 1/t64**2
            t84 = 1/t64
            t85 = t39*t62*t84+t36*t82*t83+t33*t80*t81+t30*t78*t79+t27*t7
     1         6*t77+t24*t74*t75+t21*t72*t73+t18*t70*t71+t15*t68*t69+t12
     2         *t66*t67+t6*t63*t65+t5
            t86 = exp(-3.6802889260199856d-3*gammabb*t57)
            t87 = 5.52d-1*(1.0d+0-t86)+1.0d+0
            t88 = t55*t62*t84+t54*t82*t83+t53*t80*t81+t52*t78*t79+t51*t7
     1         6*t77+t50*t74*t75+t49*t72*t73+t48*t70*t71+t47*t68*t69+t46
     2         *t66*t67+t45*t63*t65+t44
            t89 = rhoa**6.666666666666666d-1
            t90 = 1/t10**12
            t91 = -1.6711932865267184d+2*t6*t89*t9*t90-1.519266624115198
     1         6d+1*t38*t39*t8*t89+3.038533248230397d+1*t36*t38*t8*t89+1
     2         .6711932865267184d+2*t11*t13*t6*t89+1.5192666241151986d+1
     3         *t39*t40*t89-3.038533248230397d+1*t35*t36*t37*t89+4.55779
     4         98723455965d+1*t33*t35*t37*t89-4.5577998723455965d+1*t32*
     5         t33*t34*t89+6.077066496460795d+1*t30*t32*t34*t89-6.077066
     6         496460795d+1*t29*t30*t31*t89+7.596333120575993d+1*t27*t29
     7         *t31*t89-7.596333120575993d+1*t26*t27*t28*t89+9.115599744
     8         691193d+1*t24*t26*t28*t89-9.115599744691193d+1*t23*t24*t2
     9         5*t89+1.0634866368806391d+2*t21*t23*t25*t89-1.06348663688
     :         06391d+2*t20*t21*t22*t89+1.2154132992921589d+2*t18*t20*t2
     ;         2*t89-1.2154132992921589d+2*t17*t18*t19*t89+1.36733996170
     <         36788d+2*t15*t17*t19*t89-1.3673399617036788d+2*t14*t15*t1
     =         6*t89+1.5192666241151986d+2*t12*t14*t16*t89-1.51926662411
     >         51986d+2*t11*t12*t13*t89
            t92 = -1.6711932865267184d+2*t45*t89*t9*t90-1.51926662411519
     1         86d+1*t38*t55*t8*t89+3.038533248230397d+1*t38*t54*t8*t89+
     2         1.5192666241151986d+1*t40*t55*t89-3.038533248230397d+1*t3
     3         5*t37*t54*t89+4.5577998723455965d+1*t35*t37*t53*t89-4.557
     4         7998723455965d+1*t32*t34*t53*t89+6.077066496460795d+1*t32
     5         *t34*t52*t89-6.077066496460795d+1*t29*t31*t52*t89+7.59633
     6         3120575993d+1*t29*t31*t51*t89-7.596333120575993d+1*t26*t2
     7         8*t51*t89+9.115599744691193d+1*t26*t28*t50*t89-9.11559974
     8         4691193d+1*t23*t25*t50*t89+1.0634866368806391d+2*t23*t25*
     9         t49*t89-1.0634866368806391d+2*t20*t22*t49*t89+1.215413299
     :         2921589d+2*t20*t22*t48*t89-1.2154132992921589d+2*t17*t19*
     ;         t48*t89+1.3673399617036788d+2*t17*t19*t47*t89-1.367339961
     <         7036788d+2*t14*t16*t47*t89+1.5192666241151986d+2*t14*t16*
     =         t46*t89-1.5192666241151986d+2*t11*t13*t46*t89+1.671193286
     >         5267184d+2*t11*t13*t45*t89
            t93 = 1/t2**2
            t94 = 1/rhoa**2.3333333333333334d+0
            t95 = rhoa**3.333333333333333d-1
            t96 = rhob**6.666666666666666d-1
            t97 = 1/t64**12
            t98 = -1.6711932865267184d+2*t6*t63*t96*t97+1.51926662411519
     1         86d+1*t39*t84*t96-1.5192666241151986d+1*t39*t62*t83*t96+3
     2         .038533248230397d+1*t36*t62*t83*t96-3.038533248230397d+1*
     3         t36*t81*t82*t96+4.5577998723455965d+1*t33*t81*t82*t96-4.5
     4         577998723455965d+1*t33*t79*t80*t96+6.077066496460795d+1*t
     5         30*t79*t80*t96-6.077066496460795d+1*t30*t77*t78*t96+7.596
     6         333120575993d+1*t27*t77*t78*t96-7.596333120575993d+1*t27*
     7         t75*t76*t96+9.115599744691193d+1*t24*t75*t76*t96-9.115599
     8         744691193d+1*t24*t73*t74*t96+1.0634866368806391d+2*t21*t7
     9         3*t74*t96-1.0634866368806391d+2*t21*t71*t72*t96+1.2154132
     :         992921589d+2*t18*t71*t72*t96-1.2154132992921589d+2*t18*t6
     ;         9*t70*t96+1.3673399617036788d+2*t15*t69*t70*t96-1.3673399
     <         617036788d+2*t15*t67*t68*t96+1.5192666241151986d+2*t12*t6
     =         7*t68*t96+1.6711932865267184d+2*t6*t65*t66*t96-1.51926662
     >         41151986d+2*t12*t65*t66*t96
            t99 = -1.6711932865267184d+2*t45*t63*t96*t97+1.5192666241151
     1         986d+1*t55*t84*t96-1.5192666241151986d+1*t55*t62*t83*t96+
     2         3.038533248230397d+1*t54*t62*t83*t96-3.038533248230397d+1
     3         *t54*t81*t82*t96+4.5577998723455965d+1*t53*t81*t82*t96-4.
     4         5577998723455965d+1*t53*t79*t80*t96+6.077066496460795d+1*
     5         t52*t79*t80*t96-6.077066496460795d+1*t52*t77*t78*t96+7.59
     6         6333120575993d+1*t51*t77*t78*t96-7.596333120575993d+1*t51
     7         *t75*t76*t96+9.115599744691193d+1*t50*t75*t76*t96-9.11559
     8         9744691193d+1*t50*t73*t74*t96+1.0634866368806391d+2*t49*t
     9         73*t74*t96-1.0634866368806391d+2*t49*t71*t72*t96+1.215413
     :         2992921589d+2*t48*t71*t72*t96-1.2154132992921589d+2*t48*t
     ;         69*t70*t96+1.3673399617036788d+2*t47*t69*t70*t96-1.367339
     <         9617036788d+2*t47*t67*t68*t96+1.5192666241151986d+2*t46*t
     =         67*t68*t96-1.5192666241151986d+2*t46*t65*t66*t96+1.671193
     >         2865267184d+2*t45*t65*t66*t96
            t100 = 1/t58**2
            t101 = 1/rhob**2.3333333333333334d+0
            t102 = rhob**3.333333333333333d-1
            t103 = 1/t4
            t104 = 1/t60
            t105 = -2.2d+1*t6*t9*t90-2.0d+0*t38*t39*t8-4.0d+0*t36*t38*t8
     1         -2.2d+1*t11*t13*t6-2.0d+0*t39*t40-4.0d+0*t35*t36*t37-6.0d
     2         +0*t33*t35*t37-6.0d+0*t32*t33*t34-8.0d+0*t30*t32*t34-8.0d
     3         +0*t29*t30*t31-1.0d+1*t27*t29*t31-1.0d+1*t26*t27*t28-1.2d
     4         +1*t24*t26*t28-1.2d+1*t23*t24*t25-1.4d+1*t21*t23*t25-1.4d
     5         +1*t20*t21*t22-1.6d+1*t18*t20*t22-1.6d+1*t17*t18*t19-1.8d
     6         +1*t15*t17*t19-1.8d+1*t14*t15*t16-2.0d+1*t12*t14*t16-2.0d
     7         +1*t11*t12*t13
            t106 = -2.2d+1*t45*t9*t90-2.0d+0*t38*t55*t8-4.0d+0*t38*t54*t
     1         8-2.0d+0*t40*t55-4.0d+0*t35*t37*t54-6.0d+0*t35*t37*t53-6.
     2         0d+0*t32*t34*t53-8.0d+0*t32*t34*t52-8.0d+0*t29*t31*t52-1.
     3         0d+1*t29*t31*t51-1.0d+1*t26*t28*t51-1.2d+1*t26*t28*t50-1.
     4         2d+1*t23*t25*t50-1.4d+1*t23*t25*t49-1.4d+1*t20*t22*t49-1.
     5         6d+1*t20*t22*t48-1.6d+1*t17*t19*t48-1.8d+1*t17*t19*t47-1.
     6         8d+1*t14*t16*t47-2.0d+1*t14*t16*t46-2.0d+1*t11*t13*t46-2.
     7         2d+1*t11*t13*t45
            t107 = -2.2d+1*t6*t63*t97-2.0d+0*t39*t84-2.0d+0*t39*t62*t83-
     1         4.0d+0*t36*t62*t83-4.0d+0*t36*t81*t82-6.0d+0*t33*t81*t82-
     2         6.0d+0*t33*t79*t80-8.0d+0*t30*t79*t80-8.0d+0*t30*t77*t78-
     3         1.0d+1*t27*t77*t78-1.0d+1*t27*t75*t76-1.2d+1*t24*t75*t76-
     4         1.2d+1*t24*t73*t74-1.4d+1*t21*t73*t74-1.4d+1*t21*t71*t72-
     5         1.6d+1*t18*t71*t72-1.6d+1*t18*t69*t70-1.8d+1*t15*t69*t70-
     6         1.8d+1*t15*t67*t68-2.0d+1*t12*t67*t68-2.2d+1*t6*t65*t66-2
     7         .0d+1*t12*t65*t66
            t108 = -2.2d+1*t45*t63*t97-2.0d+0*t55*t84-2.0d+0*t55*t62*t83
     1         -4.0d+0*t54*t62*t83-4.0d+0*t54*t81*t82-6.0d+0*t53*t81*t82
     2         -6.0d+0*t53*t79*t80-8.0d+0*t52*t79*t80-8.0d+0*t52*t77*t78
     3         -1.0d+1*t51*t77*t78-1.0d+1*t51*t75*t76-1.2d+1*t50*t75*t76
     4         -1.2d+1*t50*t73*t74-1.4d+1*t49*t73*t74-1.4d+1*t49*t71*t72
     5         -1.6d+1*t48*t71*t72-1.6d+1*t48*t69*t70-1.8d+1*t47*t69*t70
     6         -1.8d+1*t47*t67*t68-2.0d+1*t46*t67*t68-2.0d+1*t46*t65*t66
     7         -2.2d+1*t45*t65*t66
            t109 = 1/t10**13
            t110 = 1/t95
            t111 = gammaaa**2
            t112 = 1/t2**3
            t113 = 1/rhoa**6
            t114 = 1/rhoa**3.3333333333333337d+0
            t115 = 1/t64**13
            t116 = 1/t102
            t117 = gammabb**2
            t118 = 1/t58**3
            t119 = 1/rhob**6
            t120 = 1/rhob**3.3333333333333337d+0
            t121 = 1/rhoa**5
            t122 = 1/rhob**5
            t123 = 1/rhoa**4
            t124 = 1/rhob**4
            fnc(iq) = (1.0d+0*(-9.305257363491002d-1*t60*t87*t88-9.30525
     1         7363491002d-1*t59*t60*t85)+1.0d+0*(-9.305257363491002d-1*
     2         t4*t43*t56-9.305257363491002d-1*t3*t4*t41))*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t43*t56*t95-
     1         1.2407009817988002d+0*t3*t41*t95+8.963083509889702d-3*gam
     2         maaa*t41*t93*t94+5.041016444533138d-3*gammaaa*t42*t56*t94
     3         -9.305257363491002d-1*t4*t43*t92-9.305257363491002d-1*t3*
     4         t4*t91)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(-9.305257363491002d-1*t60*t87*t99-9
     1         .305257363491002d-1*t59*t60*t98-1.2407009817988002d+0*t10
     2         2*t87*t88+5.041016444533138d-3*gammabb*t101*t86*t88-1.240
     3         7009817988002d+0*t102*t59*t85+8.963083509889702d-3*gammab
     4         b*t100*t101*t85)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t103*t41*t93
     1         -1.890381166699927d-3*t103*t42*t56)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-1.890381166699927d-3*t104*t86*t88
     1         -3.361156316208638d-3*t100*t104*t85)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t106*t4*t43-9
     1         .305257363491002d-1*t105*t3*t4)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t108*t60*t87-
     1         9.305257363491002d-1*t107*t59*t60)*wght+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(-2.4814019635976003d+0*t43*t92*
     1         t95-2.4814019635976003d+0*t3*t91*t95+1.7926167019779404d-
     2         2*gammaaa*t91*t93*t94+1.0082032889066277d-2*gammaaa*t42*t
     3         92*t94-8.963083509889707d-3*gammaaa*t114*t41*t93-9.305257
     4         363491002d-1*t3*t4*(-1.1141288576844789d+2*t110*t6*t9*t90
     5         -5.585774001863949d+4*t13*t4*t6*t90+2.5389881826654315d+4
     6         *t12*t13*t4*t90+3.046785819198518d+4*t109*t4*t6*t9+4.6163
     7         421503007845d+2*t35*t39*t4*t8-1.846536860120314d+3*t35*t3
     8         6*t4*t8+1.3849026450902355d+3*t33*t35*t4*t8-1.01284441607
     9         67991d+1*t110*t38*t39*t8+2.0256888321535982d+1*t110*t36*t
     :         38*t8+2.5389881826654315d+4*t11*t16*t4*t6+1.1141288576844
     ;         789d+2*t11*t110*t13*t6+1.0128444160767991d+1*t110*t39*t40
     <         -4.6163421503007845d+2*t38*t39*t4+4.6163421503007845d+2*t
     =         36*t38*t4+1.3849026450902355d+3*t32*t36*t37*t4-4.15470793
     >         52707067d+3*t32*t33*t37*t4+2.769805290180471d+3*t30*t32*t
     ?         37*t4+2.769805290180471d+3*t29*t33*t34*t4-7.3861474404812
     @         55d+3*t29*t30*t34*t4+4.616342150300784d+3*t27*t29*t34*t4+
     1         4.616342150300784d+3*t26*t30*t31*t4-1.154085537575196d+4*
     2         t26*t27*t31*t4+6.924513225451178d+3*t24*t26*t31*t4+6.9245
     3         13225451178d+3*t23*t27*t28*t4-1.661883174108283d+4*t23*t2
     4         4*t28*t4+9.694318515631648d+3*t21*t23*t28*t4+9.6943185156
     5         31648d+3*t20*t24*t25*t4-2.2620076536473846d+4*t20*t21*t25
     6         *t4+1.2925758020842196d+4*t18*t20*t25*t4+1.29257580208421
     7         96d+4*t17*t21*t22*t4-2.954458976192502d+4*t17*t18*t22*t4+
     8         1.6618831741082823d+4*t15*t17*t22*t4+1.6618831741082823d+
     9         4*t14*t18*t19*t4-3.7392371417436354d+4*t14*t15*t19*t4+2.0
     :         773539676353528d+4*t12*t14*t19*t4+2.0773539676353528d+4*t
     ;         11*t15*t16*t4-4.616342150300784d+4*t11*t12*t16*t4-2.02568
     <         88321535982d+1*t110*t35*t36*t37+3.038533248230397d+1*t110
     =         *t33*t35*t37-3.038533248230397d+1*t110*t32*t33*t34+4.0513
     >         776643071964d+1*t110*t30*t32*t34-4.0513776643071964d+1*t1
     ?         10*t29*t30*t31+5.064222080383994d+1*t110*t27*t29*t31-5.06
     @         4222080383994d+1*t110*t26*t27*t28+6.077066496460795d+1*t1
     1         10*t24*t26*t28-6.077066496460795d+1*t110*t23*t24*t25+7.08
     2         9910912537593d+1*t110*t21*t23*t25-7.089910912537593d+1*t1
     3         10*t20*t21*t22+8.102755328614393d+1*t110*t18*t20*t22-8.10
     4         2755328614393d+1*t110*t17*t18*t19+9.115599744691191d+1*t1
     5         10*t15*t17*t19-9.115599744691191d+1*t110*t14*t15*t16+1.01
     6         2844416076799d+2*t110*t12*t14*t16-1.012844416076799d+2*t1
     7         1*t110*t12*t13)-9.305257363491002d-1*t4*t43*(-1.114128857
     8         6844789d+2*t110*t45*t9*t90+2.5389881826654315d+4*t13*t4*t
     9         46*t90-5.585774001863949d+4*t13*t4*t45*t90+3.046785819198
     :         518d+4*t109*t4*t45*t9+4.6163421503007845d+2*t35*t4*t55*t8
     ;         -1.0128444160767991d+1*t110*t38*t55*t8-1.846536860120314d
     <         +3*t35*t4*t54*t8+2.0256888321535982d+1*t110*t38*t54*t8+1.
     =         3849026450902355d+3*t35*t4*t53*t8+1.0128444160767991d+1*t
     >         110*t40*t55-4.6163421503007845d+2*t38*t4*t55+4.6163421503
     ?         007845d+2*t38*t4*t54+1.3849026450902355d+3*t32*t37*t4*t54
     @         -2.0256888321535982d+1*t110*t35*t37*t54-4.154707935270706
     1         7d+3*t32*t37*t4*t53+2.769805290180471d+3*t29*t34*t4*t53+3
     2         .038533248230397d+1*t110*t35*t37*t53-3.038533248230397d+1
     3         *t110*t32*t34*t53+2.769805290180471d+3*t32*t37*t4*t52-7.3
     4         86147440481255d+3*t29*t34*t4*t52+4.616342150300784d+3*t26
     5         *t31*t4*t52+4.0513776643071964d+1*t110*t32*t34*t52-4.0513
     6         776643071964d+1*t110*t29*t31*t52+4.616342150300784d+3*t29
     7         *t34*t4*t51-1.154085537575196d+4*t26*t31*t4*t51+6.9245132
     8         25451178d+3*t23*t28*t4*t51+5.064222080383994d+1*t110*t29*
     9         t31*t51-5.064222080383994d+1*t110*t26*t28*t51+6.924513225
     :         451178d+3*t26*t31*t4*t50-1.661883174108283d+4*t23*t28*t4*
     ;         t50+9.694318515631648d+3*t20*t25*t4*t50+6.077066496460795
     <         d+1*t110*t26*t28*t50-6.077066496460795d+1*t110*t23*t25*t5
     =         0+9.694318515631648d+3*t23*t28*t4*t49-2.2620076536473846d
     >         +4*t20*t25*t4*t49+1.2925758020842196d+4*t17*t22*t4*t49+7.
     ?         089910912537593d+1*t110*t23*t25*t49-7.089910912537593d+1*
     @         t110*t20*t22*t49+1.2925758020842196d+4*t20*t25*t4*t48-2.9
     1         54458976192502d+4*t17*t22*t4*t48+1.6618831741082823d+4*t1
     2         4*t19*t4*t48+8.102755328614393d+1*t110*t20*t22*t48-8.1027
     3         55328614393d+1*t110*t17*t19*t48+1.6618831741082823d+4*t17
     4         *t22*t4*t47-3.7392371417436354d+4*t14*t19*t4*t47+2.077353
     5         9676353528d+4*t11*t16*t4*t47+9.115599744691191d+1*t110*t1
     6         7*t19*t47-9.115599744691191d+1*t110*t14*t16*t47+2.0773539
     7         676353528d+4*t14*t19*t4*t46-4.616342150300784d+4*t11*t16*
     8         t4*t46+1.012844416076799d+2*t110*t14*t16*t46-1.0128444160
     9         76799d+2*t11*t110*t13*t46+2.5389881826654315d+4*t11*t16*t
     :         4*t45+1.1141288576844789d+2*t11*t110*t13*t45)+(-4.1356699
     ;         39329334d-1*t43*t56-4.135669939329334d-1*t3*t41)/t89-5.04
     <         1016444533138d-3*gammaaa*t114*t42*t56+4.947305865786653d-
     =         5*t111*t113*t42*t56+2.1476348525932504d-4*t111*t112*t113*
     >         t41)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(-2.4814019635976003d+0*t102*t87
     1         *t99+1.0082032889066277d-2*gammabb*t101*t86*t99-2.4814019
     2         635976003d+0*t102*t59*t98+1.7926167019779404d-2*gammabb*t
     3         100*t101*t98-9.305257363491002d-1*t59*t60*(-5.58577400186
     4         3949d+4*t6*t60*t66*t97+2.5389881826654315d+4*t12*t60*t66*
     5         t97-1.1141288576844789d+2*t116*t6*t63*t97+1.0128444160767
     6         991d+1*t116*t39*t84-1.0128444160767991d+1*t116*t39*t62*t8
     7         3+2.0256888321535982d+1*t116*t36*t62*t83-4.61634215030078
     8         45d+2*t39*t60*t83+4.6163421503007845d+2*t36*t60*t83-2.025
     9         6888321535982d+1*t116*t36*t81*t82+3.038533248230397d+1*t1
     :         16*t33*t81*t82+1.3849026450902355d+3*t36*t60*t79*t82-4.15
     ;         47079352707067d+3*t33*t60*t79*t82+2.769805290180471d+3*t3
     <         0*t60*t79*t82+4.6163421503007845d+2*t39*t60*t62*t81-1.846
     =         536860120314d+3*t36*t60*t62*t81+1.3849026450902355d+3*t33
     >         *t60*t62*t81-3.038533248230397d+1*t116*t33*t79*t80+4.0513
     ?         776643071964d+1*t116*t30*t79*t80+2.769805290180471d+3*t33
     @         *t60*t77*t80-7.386147440481255d+3*t30*t60*t77*t80+4.61634
     1         2150300784d+3*t27*t60*t77*t80-4.0513776643071964d+1*t116*
     2         t30*t77*t78+5.064222080383994d+1*t116*t27*t77*t78+4.61634
     3         2150300784d+3*t30*t60*t75*t78-1.154085537575196d+4*t27*t6
     4         0*t75*t78+6.924513225451178d+3*t24*t60*t75*t78-5.06422208
     5         0383994d+1*t116*t27*t75*t76+6.077066496460795d+1*t116*t24
     6         *t75*t76+6.924513225451178d+3*t27*t60*t73*t76-1.661883174
     7         108283d+4*t24*t60*t73*t76+9.694318515631648d+3*t21*t60*t7
     8         3*t76-6.077066496460795d+1*t116*t24*t73*t74+7.08991091253
     9         7593d+1*t116*t21*t73*t74+9.694318515631648d+3*t24*t60*t71
     :         *t74-2.2620076536473846d+4*t21*t60*t71*t74+1.292575802084
     ;         2196d+4*t18*t60*t71*t74-7.089910912537593d+1*t116*t21*t71
     <         *t72+8.102755328614393d+1*t116*t18*t71*t72+1.292575802084
     =         2196d+4*t21*t60*t69*t72-2.954458976192502d+4*t18*t60*t69*
     >         t72+1.6618831741082823d+4*t15*t60*t69*t72-8.1027553286143
     ?         93d+1*t116*t18*t69*t70+9.115599744691191d+1*t116*t15*t69*
     @         t70+1.6618831741082823d+4*t18*t60*t67*t70-3.7392371417436
     1         354d+4*t15*t60*t67*t70+2.0773539676353528d+4*t12*t60*t67*
     2         t70-9.115599744691191d+1*t116*t15*t67*t68+1.0128444160767
     3         99d+2*t116*t12*t67*t68+2.5389881826654315d+4*t6*t60*t65*t
     4         68+2.0773539676353528d+4*t15*t60*t65*t68-4.61634215030078
     5         4d+4*t12*t60*t65*t68+1.1141288576844789d+2*t116*t6*t65*t6
     6         6-1.012844416076799d+2*t116*t12*t65*t66+3.046785819198518
     7         d+4*t115*t6*t60*t63)-9.305257363491002d-1*t60*t87*(2.5389
     8         881826654315d+4*t46*t60*t66*t97-5.585774001863949d+4*t45*
     9         t60*t66*t97-1.1141288576844789d+2*t116*t45*t63*t97+1.0128
     :         444160767991d+1*t116*t55*t84-1.0128444160767991d+1*t116*t
     ;         55*t62*t83+2.0256888321535982d+1*t116*t54*t62*t83-4.61634
     <         21503007845d+2*t55*t60*t83+4.6163421503007845d+2*t54*t60*
     =         t83-2.0256888321535982d+1*t116*t54*t81*t82+3.038533248230
     >         397d+1*t116*t53*t81*t82+1.3849026450902355d+3*t54*t60*t79
     ?         *t82-4.1547079352707067d+3*t53*t60*t79*t82+2.769805290180
     @         471d+3*t52*t60*t79*t82+4.6163421503007845d+2*t55*t60*t62*
     1         t81-1.846536860120314d+3*t54*t60*t62*t81+1.38490264509023
     2         55d+3*t53*t60*t62*t81-3.038533248230397d+1*t116*t53*t79*t
     3         80+4.0513776643071964d+1*t116*t52*t79*t80+2.7698052901804
     4         71d+3*t53*t60*t77*t80-7.386147440481255d+3*t52*t60*t77*t8
     5         0+4.616342150300784d+3*t51*t60*t77*t80-4.0513776643071964
     6         d+1*t116*t52*t77*t78+5.064222080383994d+1*t116*t51*t77*t7
     7         8+4.616342150300784d+3*t52*t60*t75*t78-1.154085537575196d
     8         +4*t51*t60*t75*t78+6.924513225451178d+3*t50*t60*t75*t78-5
     9         .064222080383994d+1*t116*t51*t75*t76+6.077066496460795d+1
     :         *t116*t50*t75*t76+6.924513225451178d+3*t51*t60*t73*t76-1.
     ;         661883174108283d+4*t50*t60*t73*t76+9.694318515631648d+3*t
     <         49*t60*t73*t76-6.077066496460795d+1*t116*t50*t73*t74+7.08
     =         9910912537593d+1*t116*t49*t73*t74+9.694318515631648d+3*t5
     >         0*t60*t71*t74-2.2620076536473846d+4*t49*t60*t71*t74+1.292
     ?         5758020842196d+4*t48*t60*t71*t74-7.089910912537593d+1*t11
     @         6*t49*t71*t72+8.102755328614393d+1*t116*t48*t71*t72+1.292
     1         5758020842196d+4*t49*t60*t69*t72-2.954458976192502d+4*t48
     2         *t60*t69*t72+1.6618831741082823d+4*t47*t60*t69*t72-8.1027
     3         55328614393d+1*t116*t48*t69*t70+9.115599744691191d+1*t116
     4         *t47*t69*t70+1.6618831741082823d+4*t48*t60*t67*t70-3.7392
     5         371417436354d+4*t47*t60*t67*t70+2.0773539676353528d+4*t46
     6         *t60*t67*t70-9.115599744691191d+1*t116*t47*t67*t68+1.0128
     7         44416076799d+2*t116*t46*t67*t68+2.0773539676353528d+4*t47
     8         *t60*t65*t68-4.616342150300784d+4*t46*t60*t65*t68+2.53898
     9         81826654315d+4*t45*t60*t65*t68-1.012844416076799d+2*t116*
     :         t46*t65*t66+1.1141288576844789d+2*t116*t45*t65*t66+3.0467
     ;         85819198518d+4*t115*t45*t60*t63)+(-4.135669939329334d-1*t
     <         87*t88-4.135669939329334d-1*t59*t85)/t96-5.04101644453313
     =         8d-3*gammabb*t120*t86*t88+4.947305865786653d-5*t117*t119*
     >         t86*t88-8.963083509889707d-3*gammabb*t100*t120*t85+2.1476
     ?         348525932504d-4*t117*t118*t119*t85)*wght+Amat2(iq,D2_RB_R
     @         B)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(4.481541754944851d-3*t41*t93*t
     1         94+2.520508222266569d-3*t42*t56*t94-3.361156316208638d-3*
     2         t103*t91*t93-1.890381166699927d-3*t103*t42*t92-1.85523969
     3         9669995d-5*gammaaa*t121*t42*t56-8.05363069722469d-5*gamma
     4         aa*t112*t121*t41)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(-1.890381166699927d-3*t104*t86
     1         *t99-3.361156316208638d-3*t100*t104*t98-1.855239699669995
     2         d-5*gammabb*t122*t86*t88+2.520508222266569d-3*t101*t86*t8
     3         8-8.05363069722469d-5*gammabb*t118*t122*t85+4.48154175494
     4         4851d-3*t100*t101*t85)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(6.957148873762482d-6*t123*t42
     1         *t56+3.020111511459258d-5*t112*t123*t41)*wght+Cmat2(iq,D2
     2         _GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(6.957148873762482d-6*t124*t86
     1         *t88+3.020111511459258d-5*t118*t124*t85)*wght+Cmat2(iq,D2
     2         _GBB_GBB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(-1.2407009817988002d+0*t106*t43
     1         *t95-1.2407009817988002d+0*t105*t3*t95+8.963083509889702d
     2         -3*gammaaa*t105*t93*t94+5.041016444533138d-3*gammaaa*t106
     3         *t42*t94-9.305257363491002d-1*t4*t43*(3.342386573053437d+
     4         3*t13*t46*t89*t90+4.0108638876641245d+3*t109*t45*t89*t9+6
     5         .077066496460795d+1*t35*t55*t8*t89-1.8231199489382385d+2*
     6         t35*t53*t8*t89-6.077066496460795d+1*t38*t54*t89+1.8231199
     7         489382385d+2*t32*t37*t54*t89+3.646239897876477d+2*t29*t34
     8         *t53*t89-3.646239897876477d+2*t32*t37*t52*t89+6.077066496
     9         460795d+2*t26*t31*t52*t89-6.077066496460795d+2*t29*t34*t5
     :         1*t89+9.115599744691192d+2*t23*t28*t51*t89-9.115599744691
     ;         192d+2*t26*t31*t50*t89+1.276183964256767d+3*t20*t25*t50*t
     <         89-1.276183964256767d+3*t23*t28*t49*t89+1.701578619009022
     =         6d+3*t17*t22*t49*t89-1.7015786190090226d+3*t20*t25*t48*t8
     >         9+2.187743938725886d+3*t14*t19*t48*t89-2.187743938725886d
     ?         +3*t17*t22*t47*t89+2.734679923407357d+3*t11*t16*t47*t89-2
     @         .734679923407357d+3*t14*t19*t46*t89-3.342386573053437d+3*
     1         t11*t16*t45*t89)-9.305257363491002d-1*t3*t4*(3.3423865730
     2         53437d+3*t12*t13*t89*t90+4.0108638876641245d+3*t109*t6*t8
     3         9*t9+6.077066496460795d+1*t35*t39*t8*t89-1.82311994893823
     4         85d+2*t33*t35*t8*t89-3.342386573053437d+3*t11*t16*t6*t89-
     5         6.077066496460795d+1*t36*t38*t89+1.8231199489382385d+2*t3
     6         2*t36*t37*t89-3.646239897876477d+2*t30*t32*t37*t89+3.6462
     7         39897876477d+2*t29*t33*t34*t89-6.077066496460795d+2*t27*t
     8         29*t34*t89+6.077066496460795d+2*t26*t30*t31*t89-9.1155997
     9         44691192d+2*t24*t26*t31*t89+9.115599744691192d+2*t23*t27*
     :         t28*t89-1.276183964256767d+3*t21*t23*t28*t89+1.2761839642
     ;         56767d+3*t20*t24*t25*t89-1.7015786190090226d+3*t18*t20*t2
     <         5*t89+1.7015786190090226d+3*t17*t21*t22*t89-2.18774393872
     =         5886d+3*t15*t17*t22*t89+2.187743938725886d+3*t14*t18*t19*
     >         t89-2.734679923407357d+3*t12*t14*t19*t89+2.73467992340735
     ?         7d+3*t11*t15*t16*t89))*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(-9.305257363491002d-1*t60*t87*(
     1         3.342386573053437d+3*t46*t66*t96*t97-6.077066496460795d+1
     2         *t54*t83*t96+1.8231199489382385d+2*t54*t79*t82*t96-3.6462
     3         39897876477d+2*t52*t79*t82*t96+6.077066496460795d+1*t55*t
     4         62*t81*t96-1.8231199489382385d+2*t53*t62*t81*t96+3.646239
     5         897876477d+2*t53*t77*t80*t96-6.077066496460795d+2*t51*t77
     6         *t80*t96+6.077066496460795d+2*t52*t75*t78*t96-9.115599744
     7         691192d+2*t50*t75*t78*t96+9.115599744691192d+2*t51*t73*t7
     8         6*t96-1.276183964256767d+3*t49*t73*t76*t96+1.276183964256
     9         767d+3*t50*t71*t74*t96-1.7015786190090226d+3*t48*t71*t74*
     :         t96+1.7015786190090226d+3*t49*t69*t72*t96-2.1877439387258
     ;         86d+3*t47*t69*t72*t96+2.187743938725886d+3*t48*t67*t70*t9
     <         6-2.734679923407357d+3*t46*t67*t70*t96+2.734679923407357d
     =         +3*t47*t65*t68*t96-3.342386573053437d+3*t45*t65*t68*t96+4
     >         .0108638876641245d+3*t115*t45*t63*t96)-9.305257363491002d
     ?         -1*t59*t60*(3.342386573053437d+3*t12*t66*t96*t97-6.077066
     @         496460795d+1*t36*t83*t96+1.8231199489382385d+2*t36*t79*t8
     1         2*t96-3.646239897876477d+2*t30*t79*t82*t96+6.077066496460
     2         795d+1*t39*t62*t81*t96-1.8231199489382385d+2*t33*t62*t81*
     3         t96+3.646239897876477d+2*t33*t77*t80*t96-6.07706649646079
     4         5d+2*t27*t77*t80*t96+6.077066496460795d+2*t30*t75*t78*t96
     5         -9.115599744691192d+2*t24*t75*t78*t96+9.115599744691192d+
     6         2*t27*t73*t76*t96-1.276183964256767d+3*t21*t73*t76*t96+1.
     7         276183964256767d+3*t24*t71*t74*t96-1.7015786190090226d+3*
     8         t18*t71*t74*t96+1.7015786190090226d+3*t21*t69*t72*t96-2.1
     9         87743938725886d+3*t15*t69*t72*t96+2.187743938725886d+3*t1
     :         8*t67*t70*t96-2.734679923407357d+3*t12*t67*t70*t96-3.3423
     ;         86573053437d+3*t6*t65*t68*t96+2.734679923407357d+3*t15*t6
     <         5*t68*t96+4.0108638876641245d+3*t115*t6*t63*t96)-1.240700
     =         9817988002d+0*t102*t108*t87+5.041016444533138d-3*gammabb*
     >         t101*t108*t86-1.2407009817988002d+0*t102*t107*t59+8.96308
     ?         3509889702d-3*gammabb*t100*t101*t107)*wght+Mmat2(iq,D2_RB
     @         _TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-3.361156316208638d-3*t103*t10
     1         5*t93-1.890381166699927d-3*t103*t106*t42)*wght+Mmat2(iq,D
     2         2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(-1.890381166699927d-3*t104*t10
     1         8*t86-3.361156316208638d-3*t100*t104*t107)*wght+Mmat2(iq,
     2         D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(9.
     1         68d+2*t13*t6*t90+4.4d+2*t12*t13*t90+5.28d+2*t109*t6*t9+8.
     2         0d+0*t35*t39*t8+3.2d+1*t35*t36*t8+2.4d+1*t33*t35*t8+4.4d+
     3         2*t11*t16*t6+8.0d+0*t38*t39+8.0d+0*t36*t38+2.4d+1*t32*t36
     4         *t37+7.2d+1*t32*t33*t37+4.8d+1*t30*t32*t37+4.8d+1*t29*t33
     5         *t34+1.28d+2*t29*t30*t34+8.0d+1*t27*t29*t34+8.0d+1*t26*t3
     6         0*t31+2.0d+2*t26*t27*t31+1.2d+2*t24*t26*t31+1.2d+2*t23*t2
     7         7*t28+2.88d+2*t23*t24*t28+1.68d+2*t21*t23*t28+1.68d+2*t20
     8         *t24*t25+3.92d+2*t20*t21*t25+2.24d+2*t18*t20*t25+2.24d+2*
     9         t17*t21*t22+5.12d+2*t17*t18*t22+2.88d+2*t15*t17*t22+2.88d
     :         +2*t14*t18*t19+6.48d+2*t14*t15*t19+3.6d+2*t12*t14*t19+3.6
     ;         d+2*t11*t15*t16+8.0d+2*t11*t12*t16)-9.305257363491002d-1*
     <         t4*t43*(4.4d+2*t13*t46*t90+9.68d+2*t13*t45*t90+5.28d+2*t1
     =         09*t45*t9+8.0d+0*t35*t55*t8+3.2d+1*t35*t54*t8+2.4d+1*t35*
     >         t53*t8+8.0d+0*t38*t55+8.0d+0*t38*t54+2.4d+1*t32*t37*t54+7
     ?         .2d+1*t32*t37*t53+4.8d+1*t29*t34*t53+4.8d+1*t32*t37*t52+1
     @         .28d+2*t29*t34*t52+8.0d+1*t26*t31*t52+8.0d+1*t29*t34*t51+
     1         2.0d+2*t26*t31*t51+1.2d+2*t23*t28*t51+1.2d+2*t26*t31*t50+
     2         2.88d+2*t23*t28*t50+1.68d+2*t20*t25*t50+1.68d+2*t23*t28*t
     3         49+3.92d+2*t20*t25*t49+2.24d+2*t17*t22*t49+2.24d+2*t20*t2
     4         5*t48+5.12d+2*t17*t22*t48+2.88d+2*t14*t19*t48+2.88d+2*t17
     5         *t22*t47+6.48d+2*t14*t19*t47+3.6d+2*t11*t16*t47+3.6d+2*t1
     6         4*t19*t46+8.0d+2*t11*t16*t46+4.4d+2*t11*t16*t45))*wght+Mm
     7         at2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t59*t60*(
     1         9.68d+2*t6*t66*t97+4.4d+2*t12*t66*t97+8.0d+0*t39*t83+8.0d
     2         +0*t36*t83+2.4d+1*t36*t79*t82+7.2d+1*t33*t79*t82+4.8d+1*t
     3         30*t79*t82+8.0d+0*t39*t62*t81+3.2d+1*t36*t62*t81+2.4d+1*t
     4         33*t62*t81+4.8d+1*t33*t77*t80+1.28d+2*t30*t77*t80+8.0d+1*
     5         t27*t77*t80+8.0d+1*t30*t75*t78+2.0d+2*t27*t75*t78+1.2d+2*
     6         t24*t75*t78+1.2d+2*t27*t73*t76+2.88d+2*t24*t73*t76+1.68d+
     7         2*t21*t73*t76+1.68d+2*t24*t71*t74+3.92d+2*t21*t71*t74+2.2
     8         4d+2*t18*t71*t74+2.24d+2*t21*t69*t72+5.12d+2*t18*t69*t72+
     9         2.88d+2*t15*t69*t72+2.88d+2*t18*t67*t70+6.48d+2*t15*t67*t
     :         70+3.6d+2*t12*t67*t70+4.4d+2*t6*t65*t68+3.6d+2*t15*t65*t6
     ;         8+8.0d+2*t12*t65*t68+5.28d+2*t115*t6*t63)-9.3052573634910
     <         02d-1*t60*t87*(4.4d+2*t46*t66*t97+9.68d+2*t45*t66*t97+8.0
     =         d+0*t55*t83+8.0d+0*t54*t83+2.4d+1*t54*t79*t82+7.2d+1*t53*
     >         t79*t82+4.8d+1*t52*t79*t82+8.0d+0*t55*t62*t81+3.2d+1*t54*
     ?         t62*t81+2.4d+1*t53*t62*t81+4.8d+1*t53*t77*t80+1.28d+2*t52
     @         *t77*t80+8.0d+1*t51*t77*t80+8.0d+1*t52*t75*t78+2.0d+2*t51
     1         *t75*t78+1.2d+2*t50*t75*t78+1.2d+2*t51*t73*t76+2.88d+2*t5
     2         0*t73*t76+1.68d+2*t49*t73*t76+1.68d+2*t50*t71*t74+3.92d+2
     3         *t49*t71*t74+2.24d+2*t48*t71*t74+2.24d+2*t49*t69*t72+5.12
     4         d+2*t48*t69*t72+2.88d+2*t47*t69*t72+2.88d+2*t48*t67*t70+6
     5         .48d+2*t47*t67*t70+3.6d+2*t46*t67*t70+3.6d+2*t47*t65*t68+
     6         8.0d+2*t46*t65*t68+4.4d+2*t45*t65*t68+5.28d+2*t115*t45*t6
     7         3))*wght+Mmat2(iq,D2_TB_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(12)
            t6 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t7 = t6-2.0d+0*taua
            t8 = t7**11
            t9 = 2.0d+0*taua+t6
            t10 = 1/t9**11
            t11 = param(11)
            t12 = t7**10
            t13 = 1/t9**10
            t14 = param(10)
            t15 = t7**9
            t16 = 1/t9**9
            t17 = param(9)
            t18 = t7**8
            t19 = 1/t9**8
            t20 = param(8)
            t21 = t7**7
            t22 = 1/t9**7
            t23 = param(7)
            t24 = t7**6
            t25 = 1/t9**6
            t26 = param(6)
            t27 = t7**5
            t28 = 1/t9**5
            t29 = param(5)
            t30 = t7**4
            t31 = 1/t9**4
            t32 = param(4)
            t33 = t7**3
            t34 = 1/t9**3
            t35 = param(3)
            t36 = t7**2
            t37 = 1/t9**2
            t38 = param(2)
            t39 = 1/t9
            t40 = t10*t5*t8+t38*t39*t7+t35*t36*t37+t32*t33*t34+t29*t30*t
     1         31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t17*t18*t19+t14*t1
     2         5*t16+t11*t12*t13+param(1)
            t41 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t42 = 5.52d-1*(1.0d+0-t41)+1.0d+0
            t43 = param(24)
            t44 = param(23)
            t45 = param(22)
            t46 = param(21)
            t47 = param(20)
            t48 = param(19)
            t49 = param(18)
            t50 = param(17)
            t51 = param(16)
            t52 = param(15)
            t53 = param(14)
            t54 = t10*t43*t8+t39*t53*t7+t36*t37*t52+t33*t34*t51+t30*t31*
     1         t50+t27*t28*t49+t24*t25*t48+t21*t22*t47+t18*t19*t46+t15*t
     2         16*t45+t12*t13*t44+param(13)
            t55 = rhoa**6.666666666666666d-1
            t56 = 1/t9**12
            t57 = -1.6711932865267184d+2*t5*t55*t56*t8-1.519266624115198
     1         6d+1*t37*t38*t55*t7+3.038533248230397d+1*t35*t37*t55*t7+1
     2         .6711932865267184d+2*t10*t12*t5*t55+1.5192666241151986d+1
     3         *t38*t39*t55-3.038533248230397d+1*t34*t35*t36*t55+4.55779
     4         98723455965d+1*t32*t34*t36*t55-4.5577998723455965d+1*t31*
     5         t32*t33*t55+6.077066496460795d+1*t29*t31*t33*t55-6.077066
     6         496460795d+1*t28*t29*t30*t55+7.596333120575993d+1*t26*t28
     7         *t30*t55-7.596333120575993d+1*t25*t26*t27*t55+9.115599744
     8         691193d+1*t23*t25*t27*t55-9.115599744691193d+1*t22*t23*t2
     9         4*t55+1.0634866368806391d+2*t20*t22*t24*t55-1.06348663688
     :         06391d+2*t19*t20*t21*t55+1.2154132992921589d+2*t17*t19*t2
     ;         1*t55-1.2154132992921589d+2*t16*t17*t18*t55+1.36733996170
     <         36788d+2*t14*t16*t18*t55-1.3673399617036788d+2*t13*t14*t1
     =         5*t55+1.5192666241151986d+2*t11*t13*t15*t55-1.51926662411
     >         51986d+2*t10*t11*t12*t55
            t58 = -1.6711932865267184d+2*t43*t55*t56*t8-1.51926662411519
     1         86d+1*t37*t53*t55*t7+3.038533248230397d+1*t37*t52*t55*t7+
     2         1.5192666241151986d+1*t39*t53*t55-3.038533248230397d+1*t3
     3         4*t36*t52*t55+4.5577998723455965d+1*t34*t36*t51*t55-4.557
     4         7998723455965d+1*t31*t33*t51*t55+6.077066496460795d+1*t31
     5         *t33*t50*t55-6.077066496460795d+1*t28*t30*t50*t55+7.59633
     6         3120575993d+1*t28*t30*t49*t55-7.596333120575993d+1*t25*t2
     7         7*t49*t55+9.115599744691193d+1*t25*t27*t48*t55-9.11559974
     8         4691193d+1*t22*t24*t48*t55+1.0634866368806391d+2*t22*t24*
     9         t47*t55-1.0634866368806391d+2*t19*t21*t47*t55+1.215413299
     :         2921589d+2*t19*t21*t46*t55-1.2154132992921589d+2*t16*t18*
     ;         t46*t55+1.3673399617036788d+2*t16*t18*t45*t55-1.367339961
     <         7036788d+2*t13*t15*t45*t55+1.5192666241151986d+2*t13*t15*
     =         t44*t55-1.5192666241151986d+2*t10*t12*t44*t55+1.671193286
     >         5267184d+2*t10*t12*t43*t55
            t59 = 1/t2**2
            t60 = 1/rhoa**2.3333333333333334d+0
            t61 = rhoa**3.333333333333333d-1
            t62 = 1/t4
            t63 = -2.2d+1*t5*t56*t8-2.0d+0*t37*t38*t7-4.0d+0*t35*t37*t7-
     1         2.2d+1*t10*t12*t5-2.0d+0*t38*t39-4.0d+0*t34*t35*t36-6.0d+
     2         0*t32*t34*t36-6.0d+0*t31*t32*t33-8.0d+0*t29*t31*t33-8.0d+
     3         0*t28*t29*t30-1.0d+1*t26*t28*t30-1.0d+1*t25*t26*t27-1.2d+
     4         1*t23*t25*t27-1.2d+1*t22*t23*t24-1.4d+1*t20*t22*t24-1.4d+
     5         1*t19*t20*t21-1.6d+1*t17*t19*t21-1.6d+1*t16*t17*t18-1.8d+
     6         1*t14*t16*t18-1.8d+1*t13*t14*t15-2.0d+1*t11*t13*t15-2.0d+
     7         1*t10*t11*t12
            t64 = -2.2d+1*t43*t56*t8-2.0d+0*t37*t53*t7-4.0d+0*t37*t52*t7
     1         -2.0d+0*t39*t53-4.0d+0*t34*t36*t52-6.0d+0*t34*t36*t51-6.0
     2         d+0*t31*t33*t51-8.0d+0*t31*t33*t50-8.0d+0*t28*t30*t50-1.0
     3         d+1*t28*t30*t49-1.0d+1*t25*t27*t49-1.2d+1*t25*t27*t48-1.2
     4         d+1*t22*t24*t48-1.4d+1*t22*t24*t47-1.4d+1*t19*t21*t47-1.6
     5         d+1*t19*t21*t46-1.6d+1*t16*t18*t46-1.8d+1*t16*t18*t45-1.8
     6         d+1*t13*t15*t45-2.0d+1*t13*t15*t44-2.0d+1*t10*t12*t44-2.2
     7         d+1*t10*t12*t43
            t65 = 1/t9**13
            t66 = 1/t61
            t67 = gammaaa**2
            t68 = 1/t2**3
            t69 = 1/rhoa**6
            t70 = 1/rhoa**3.3333333333333337d+0
            t71 = 1/rhoa**5
            t72 = 1/rhoa**4
            fnc(iq) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t54-9.3052573
     1         63491002d-1*t3*t4*t40)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t42*t54*t61-
     1         1.2407009817988002d+0*t3*t40*t61+8.963083509889702d-3*gam
     2         maaa*t40*t59*t60+5.041016444533138d-3*gammaaa*t41*t54*t60
     3         -9.305257363491002d-1*t4*t42*t58-9.305257363491002d-1*t3*
     4         t4*t57)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t40*t59*t62-
     1         1.890381166699927d-3*t41*t54*t62)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t64-9.
     1         305257363491002d-1*t3*t4*t63)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-1
     1         .1141288576844789d+2*t5*t56*t66*t8+3.046785819198518d+4*t
     2         4*t5*t65*t8-1.0128444160767991d+1*t37*t38*t66*t7+2.025688
     3         8321535982d+1*t35*t37*t66*t7+4.6163421503007845d+2*t34*t3
     4         8*t4*t7-1.846536860120314d+3*t34*t35*t4*t7+1.384902645090
     5         2355d+3*t32*t34*t4*t7+1.1141288576844789d+2*t10*t12*t5*t6
     6         6+1.0128444160767991d+1*t38*t39*t66-2.0256888321535982d+1
     7         *t34*t35*t36*t66+3.038533248230397d+1*t32*t34*t36*t66-3.0
     8         38533248230397d+1*t31*t32*t33*t66+4.0513776643071964d+1*t
     9         29*t31*t33*t66-4.0513776643071964d+1*t28*t29*t30*t66+5.06
     :         4222080383994d+1*t26*t28*t30*t66-5.064222080383994d+1*t25
     ;         *t26*t27*t66+6.077066496460795d+1*t23*t25*t27*t66-6.07706
     <         6496460795d+1*t22*t23*t24*t66+7.089910912537593d+1*t20*t2
     =         2*t24*t66-7.089910912537593d+1*t19*t20*t21*t66+8.10275532
     >         8614393d+1*t17*t19*t21*t66-8.102755328614393d+1*t16*t17*t
     ?         18*t66+9.115599744691191d+1*t14*t16*t18*t66-9.11559974469
     @         1191d+1*t13*t14*t15*t66+1.012844416076799d+2*t11*t13*t15*
     1         t66-1.012844416076799d+2*t10*t11*t12*t66-5.58577400186394
     2         9d+4*t12*t4*t5*t56+2.5389881826654315d+4*t11*t12*t4*t56+2
     3         .5389881826654315d+4*t10*t15*t4*t5-4.6163421503007845d+2*
     4         t37*t38*t4+4.6163421503007845d+2*t35*t37*t4+1.38490264509
     5         02355d+3*t31*t35*t36*t4-4.1547079352707067d+3*t31*t32*t36
     6         *t4+2.769805290180471d+3*t29*t31*t36*t4+2.769805290180471
     7         d+3*t28*t32*t33*t4-7.386147440481255d+3*t28*t29*t33*t4+4.
     8         616342150300784d+3*t26*t28*t33*t4+4.616342150300784d+3*t2
     9         5*t29*t30*t4-1.154085537575196d+4*t25*t26*t30*t4+6.924513
     :         225451178d+3*t23*t25*t30*t4+6.924513225451178d+3*t22*t26*
     ;         t27*t4-1.661883174108283d+4*t22*t23*t27*t4+9.694318515631
     <         648d+3*t20*t22*t27*t4+9.694318515631648d+3*t19*t23*t24*t4
     =         -2.2620076536473846d+4*t19*t20*t24*t4+1.2925758020842196d
     >         +4*t17*t19*t24*t4+1.2925758020842196d+4*t16*t20*t21*t4-2.
     ?         954458976192502d+4*t16*t17*t21*t4+1.6618831741082823d+4*t
     @         14*t16*t21*t4+1.6618831741082823d+4*t13*t17*t18*t4-3.7392
     1         371417436354d+4*t13*t14*t18*t4+2.0773539676353528d+4*t11*
     2         t13*t18*t4+2.0773539676353528d+4*t10*t14*t15*t4-4.6163421
     3         50300784d+4*t10*t11*t15*t4)-9.305257363491002d-1*t4*t42*(
     4         -1.1141288576844789d+2*t43*t56*t66*t8+3.046785819198518d+
     5         4*t4*t43*t65*t8-1.0128444160767991d+1*t37*t53*t66*t7+2.02
     6         56888321535982d+1*t37*t52*t66*t7+4.6163421503007845d+2*t3
     7         4*t4*t53*t7-1.846536860120314d+3*t34*t4*t52*t7+1.38490264
     8         50902355d+3*t34*t4*t51*t7+1.0128444160767991d+1*t39*t53*t
     9         66-2.0256888321535982d+1*t34*t36*t52*t66+3.03853324823039
     :         7d+1*t34*t36*t51*t66-3.038533248230397d+1*t31*t33*t51*t66
     ;         +4.0513776643071964d+1*t31*t33*t50*t66-4.0513776643071964
     <         d+1*t28*t30*t50*t66+5.064222080383994d+1*t28*t30*t49*t66-
     =         5.064222080383994d+1*t25*t27*t49*t66+6.077066496460795d+1
     >         *t25*t27*t48*t66-6.077066496460795d+1*t22*t24*t48*t66+7.0
     ?         89910912537593d+1*t22*t24*t47*t66-7.089910912537593d+1*t1
     @         9*t21*t47*t66+8.102755328614393d+1*t19*t21*t46*t66-8.1027
     1         55328614393d+1*t16*t18*t46*t66+9.115599744691191d+1*t16*t
     2         18*t45*t66-9.115599744691191d+1*t13*t15*t45*t66+1.0128444
     3         16076799d+2*t13*t15*t44*t66-1.012844416076799d+2*t10*t12*
     4         t44*t66+1.1141288576844789d+2*t10*t12*t43*t66+2.538988182
     5         6654315d+4*t12*t4*t44*t56-5.585774001863949d+4*t12*t4*t43
     6         *t56-4.6163421503007845d+2*t37*t4*t53+4.6163421503007845d
     7         +2*t37*t4*t52+1.3849026450902355d+3*t31*t36*t4*t52-4.1547
     8         079352707067d+3*t31*t36*t4*t51+2.769805290180471d+3*t28*t
     9         33*t4*t51+2.769805290180471d+3*t31*t36*t4*t50-7.386147440
     :         481255d+3*t28*t33*t4*t50+4.616342150300784d+3*t25*t30*t4*
     ;         t50+4.616342150300784d+3*t28*t33*t4*t49-1.154085537575196
     <         d+4*t25*t30*t4*t49+6.924513225451178d+3*t22*t27*t4*t49+6.
     =         924513225451178d+3*t25*t30*t4*t48-1.661883174108283d+4*t2
     >         2*t27*t4*t48+9.694318515631648d+3*t19*t24*t4*t48+9.694318
     ?         515631648d+3*t22*t27*t4*t47-2.2620076536473846d+4*t19*t24
     @         *t4*t47+1.2925758020842196d+4*t16*t21*t4*t47+1.2925758020
     1         842196d+4*t19*t24*t4*t46-2.954458976192502d+4*t16*t21*t4*
     2         t46+1.6618831741082823d+4*t13*t18*t4*t46+1.66188317410828
     3         23d+4*t16*t21*t4*t45-3.7392371417436354d+4*t13*t18*t4*t45
     4         +2.0773539676353528d+4*t10*t15*t4*t45+2.0773539676353528d
     5         +4*t13*t18*t4*t44-4.616342150300784d+4*t10*t15*t4*t44+2.5
     6         389881826654315d+4*t10*t15*t4*t43)-8.963083509889707d-3*g
     7         ammaaa*t40*t59*t70-5.041016444533138d-3*gammaaa*t41*t54*t
     8         70+2.1476348525932504d-4*t40*t67*t68*t69+4.94730586578665
     9         3d-5*t41*t54*t67*t69-2.4814019635976003d+0*t42*t58*t61-2.
     :         4814019635976003d+0*t3*t57*t61+1.7926167019779404d-2*gamm
     ;         aaa*t57*t59*t60+1.0082032889066277d-2*gammaaa*t41*t58*t60
     <         +(-4.135669939329334d-1*t42*t54-4.135669939329334d-1*t3*t
     =         40)/t55)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(-8.05363069722469d-5*gammaaa*t
     1         40*t68*t71-1.855239699669995d-5*gammaaa*t41*t54*t71-3.361
     2         156316208638d-3*t57*t59*t62-1.890381166699927d-3*t41*t58*
     3         t62+4.481541754944851d-3*t40*t59*t60+2.520508222266569d-3
     4         *t41*t54*t60)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(3.020111511459258d-5*t40*t68*
     1         t72+6.957148873762482d-6*t41*t54*t72)*wght+Cmat2(iq,D2_GA
     2         A_GAA)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(4.
     1         0108638876641245d+3*t5*t55*t65*t8+6.077066496460795d+1*t3
     2         4*t38*t55*t7-1.8231199489382385d+2*t32*t34*t55*t7+3.34238
     3         6573053437d+3*t11*t12*t55*t56-3.342386573053437d+3*t10*t1
     4         5*t5*t55-6.077066496460795d+1*t35*t37*t55+1.8231199489382
     5         385d+2*t31*t35*t36*t55-3.646239897876477d+2*t29*t31*t36*t
     6         55+3.646239897876477d+2*t28*t32*t33*t55-6.077066496460795
     7         d+2*t26*t28*t33*t55+6.077066496460795d+2*t25*t29*t30*t55-
     8         9.115599744691192d+2*t23*t25*t30*t55+9.115599744691192d+2
     9         *t22*t26*t27*t55-1.276183964256767d+3*t20*t22*t27*t55+1.2
     :         76183964256767d+3*t19*t23*t24*t55-1.7015786190090226d+3*t
     ;         17*t19*t24*t55+1.7015786190090226d+3*t16*t20*t21*t55-2.18
     <         7743938725886d+3*t14*t16*t21*t55+2.187743938725886d+3*t13
     =         *t17*t18*t55-2.734679923407357d+3*t11*t13*t18*t55+2.73467
     >         9923407357d+3*t10*t14*t15*t55)-9.305257363491002d-1*t4*t4
     ?         2*(4.0108638876641245d+3*t43*t55*t65*t8+6.077066496460795
     @         d+1*t34*t53*t55*t7-1.8231199489382385d+2*t34*t51*t55*t7+3
     1         .342386573053437d+3*t12*t44*t55*t56-6.077066496460795d+1*
     2         t37*t52*t55+1.8231199489382385d+2*t31*t36*t52*t55+3.64623
     3         9897876477d+2*t28*t33*t51*t55-3.646239897876477d+2*t31*t3
     4         6*t50*t55+6.077066496460795d+2*t25*t30*t50*t55-6.07706649
     5         6460795d+2*t28*t33*t49*t55+9.115599744691192d+2*t22*t27*t
     6         49*t55-9.115599744691192d+2*t25*t30*t48*t55+1.27618396425
     7         6767d+3*t19*t24*t48*t55-1.276183964256767d+3*t22*t27*t47*
     8         t55+1.7015786190090226d+3*t16*t21*t47*t55-1.7015786190090
     9         226d+3*t19*t24*t46*t55+2.187743938725886d+3*t13*t18*t46*t
     :         55-2.187743938725886d+3*t16*t21*t45*t55+2.734679923407357
     ;         d+3*t10*t15*t45*t55-2.734679923407357d+3*t13*t18*t44*t55-
     <         3.342386573053437d+3*t10*t15*t43*t55)-1.2407009817988002d
     =         +0*t42*t61*t64+5.041016444533138d-3*gammaaa*t41*t60*t64-1
     >         .2407009817988002d+0*t3*t61*t63+8.963083509889702d-3*gamm
     ?         aaa*t59*t60*t63)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-1.890381166699927d-3*t41*t62*
     1         t64-3.361156316208638d-3*t59*t62*t63)*wght+Mmat2(iq,D2_GA
     2         A_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(5.
     1         28d+2*t5*t65*t8+8.0d+0*t34*t38*t7+3.2d+1*t34*t35*t7+2.4d+
     2         1*t32*t34*t7+9.68d+2*t12*t5*t56+4.4d+2*t11*t12*t56+4.4d+2
     3         *t10*t15*t5+8.0d+0*t37*t38+8.0d+0*t35*t37+2.4d+1*t31*t35*
     4         t36+7.2d+1*t31*t32*t36+4.8d+1*t29*t31*t36+4.8d+1*t28*t32*
     5         t33+1.28d+2*t28*t29*t33+8.0d+1*t26*t28*t33+8.0d+1*t25*t29
     6         *t30+2.0d+2*t25*t26*t30+1.2d+2*t23*t25*t30+1.2d+2*t22*t26
     7         *t27+2.88d+2*t22*t23*t27+1.68d+2*t20*t22*t27+1.68d+2*t19*
     8         t23*t24+3.92d+2*t19*t20*t24+2.24d+2*t17*t19*t24+2.24d+2*t
     9         16*t20*t21+5.12d+2*t16*t17*t21+2.88d+2*t14*t16*t21+2.88d+
     :         2*t13*t17*t18+6.48d+2*t13*t14*t18+3.6d+2*t11*t13*t18+3.6d
     ;         +2*t10*t14*t15+8.0d+2*t10*t11*t15)-9.305257363491002d-1*t
     <         4*t42*(5.28d+2*t43*t65*t8+8.0d+0*t34*t53*t7+3.2d+1*t34*t5
     =         2*t7+2.4d+1*t34*t51*t7+4.4d+2*t12*t44*t56+9.68d+2*t12*t43
     >         *t56+8.0d+0*t37*t53+8.0d+0*t37*t52+2.4d+1*t31*t36*t52+7.2
     ?         d+1*t31*t36*t51+4.8d+1*t28*t33*t51+4.8d+1*t31*t36*t50+1.2
     @         8d+2*t28*t33*t50+8.0d+1*t25*t30*t50+8.0d+1*t28*t33*t49+2.
     1         0d+2*t25*t30*t49+1.2d+2*t22*t27*t49+1.2d+2*t25*t30*t48+2.
     2         88d+2*t22*t27*t48+1.68d+2*t19*t24*t48+1.68d+2*t22*t27*t47
     3         +3.92d+2*t19*t24*t47+2.24d+2*t16*t21*t47+2.24d+2*t19*t24*
     4         t46+5.12d+2*t16*t21*t46+2.88d+2*t13*t18*t46+2.88d+2*t16*t
     5         21*t45+6.48d+2*t13*t18*t45+3.6d+2*t10*t15*t45+3.6d+2*t13*
     6         t18*t44+8.0d+2*t10*t15*t44+4.4d+2*t10*t15*t43))*wght+Mmat
     7         2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammabb*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhob**1.3333333333333333d+0
            t5 = param(12)
            t6 = 9.115599744691192d+0*rhob**1.6666666666666669d+0
            t7 = t6-2.0d+0*taub
            t8 = t7**11
            t9 = 2.0d+0*taub+t6
            t10 = 1/t9**11
            t11 = param(11)
            t12 = t7**10
            t13 = 1/t9**10
            t14 = param(10)
            t15 = t7**9
            t16 = 1/t9**9
            t17 = param(9)
            t18 = t7**8
            t19 = 1/t9**8
            t20 = param(8)
            t21 = t7**7
            t22 = 1/t9**7
            t23 = param(7)
            t24 = t7**6
            t25 = 1/t9**6
            t26 = param(6)
            t27 = t7**5
            t28 = 1/t9**5
            t29 = param(5)
            t30 = t7**4
            t31 = 1/t9**4
            t32 = param(4)
            t33 = t7**3
            t34 = 1/t9**3
            t35 = param(3)
            t36 = t7**2
            t37 = 1/t9**2
            t38 = param(2)
            t39 = 1/t9
            t40 = t10*t5*t8+t38*t39*t7+t35*t36*t37+t32*t33*t34+t29*t30*t
     1         31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t17*t18*t19+t14*t1
     2         5*t16+t11*t12*t13+param(1)
            t41 = exp(-3.6802889260199856d-3*gammabb*t1)
            t42 = 5.52d-1*(1.0d+0-t41)+1.0d+0
            t43 = param(24)
            t44 = param(23)
            t45 = param(22)
            t46 = param(21)
            t47 = param(20)
            t48 = param(19)
            t49 = param(18)
            t50 = param(17)
            t51 = param(16)
            t52 = param(15)
            t53 = param(14)
            t54 = t10*t43*t8+t39*t53*t7+t36*t37*t52+t33*t34*t51+t30*t31*
     1         t50+t27*t28*t49+t24*t25*t48+t21*t22*t47+t18*t19*t46+t15*t
     2         16*t45+t12*t13*t44+param(13)
            t55 = rhob**6.666666666666666d-1
            t56 = 1/t9**12
            t57 = -1.6711932865267184d+2*t5*t55*t56*t8-1.519266624115198
     1         6d+1*t37*t38*t55*t7+3.038533248230397d+1*t35*t37*t55*t7+1
     2         .6711932865267184d+2*t10*t12*t5*t55+1.5192666241151986d+1
     3         *t38*t39*t55-3.038533248230397d+1*t34*t35*t36*t55+4.55779
     4         98723455965d+1*t32*t34*t36*t55-4.5577998723455965d+1*t31*
     5         t32*t33*t55+6.077066496460795d+1*t29*t31*t33*t55-6.077066
     6         496460795d+1*t28*t29*t30*t55+7.596333120575993d+1*t26*t28
     7         *t30*t55-7.596333120575993d+1*t25*t26*t27*t55+9.115599744
     8         691193d+1*t23*t25*t27*t55-9.115599744691193d+1*t22*t23*t2
     9         4*t55+1.0634866368806391d+2*t20*t22*t24*t55-1.06348663688
     :         06391d+2*t19*t20*t21*t55+1.2154132992921589d+2*t17*t19*t2
     ;         1*t55-1.2154132992921589d+2*t16*t17*t18*t55+1.36733996170
     <         36788d+2*t14*t16*t18*t55-1.3673399617036788d+2*t13*t14*t1
     =         5*t55+1.5192666241151986d+2*t11*t13*t15*t55-1.51926662411
     >         51986d+2*t10*t11*t12*t55
            t58 = -1.6711932865267184d+2*t43*t55*t56*t8-1.51926662411519
     1         86d+1*t37*t53*t55*t7+3.038533248230397d+1*t37*t52*t55*t7+
     2         1.5192666241151986d+1*t39*t53*t55-3.038533248230397d+1*t3
     3         4*t36*t52*t55+4.5577998723455965d+1*t34*t36*t51*t55-4.557
     4         7998723455965d+1*t31*t33*t51*t55+6.077066496460795d+1*t31
     5         *t33*t50*t55-6.077066496460795d+1*t28*t30*t50*t55+7.59633
     6         3120575993d+1*t28*t30*t49*t55-7.596333120575993d+1*t25*t2
     7         7*t49*t55+9.115599744691193d+1*t25*t27*t48*t55-9.11559974
     8         4691193d+1*t22*t24*t48*t55+1.0634866368806391d+2*t22*t24*
     9         t47*t55-1.0634866368806391d+2*t19*t21*t47*t55+1.215413299
     :         2921589d+2*t19*t21*t46*t55-1.2154132992921589d+2*t16*t18*
     ;         t46*t55+1.3673399617036788d+2*t16*t18*t45*t55-1.367339961
     <         7036788d+2*t13*t15*t45*t55+1.5192666241151986d+2*t13*t15*
     =         t44*t55-1.5192666241151986d+2*t10*t12*t44*t55+1.671193286
     >         5267184d+2*t10*t12*t43*t55
            t59 = 1/t2**2
            t60 = 1/rhob**2.3333333333333334d+0
            t61 = rhob**3.333333333333333d-1
            t62 = 1/t4
            t63 = -2.2d+1*t5*t56*t8-2.0d+0*t37*t38*t7-4.0d+0*t35*t37*t7-
     1         2.2d+1*t10*t12*t5-2.0d+0*t38*t39-4.0d+0*t34*t35*t36-6.0d+
     2         0*t32*t34*t36-6.0d+0*t31*t32*t33-8.0d+0*t29*t31*t33-8.0d+
     3         0*t28*t29*t30-1.0d+1*t26*t28*t30-1.0d+1*t25*t26*t27-1.2d+
     4         1*t23*t25*t27-1.2d+1*t22*t23*t24-1.4d+1*t20*t22*t24-1.4d+
     5         1*t19*t20*t21-1.6d+1*t17*t19*t21-1.6d+1*t16*t17*t18-1.8d+
     6         1*t14*t16*t18-1.8d+1*t13*t14*t15-2.0d+1*t11*t13*t15-2.0d+
     7         1*t10*t11*t12
            t64 = -2.2d+1*t43*t56*t8-2.0d+0*t37*t53*t7-4.0d+0*t37*t52*t7
     1         -2.0d+0*t39*t53-4.0d+0*t34*t36*t52-6.0d+0*t34*t36*t51-6.0
     2         d+0*t31*t33*t51-8.0d+0*t31*t33*t50-8.0d+0*t28*t30*t50-1.0
     3         d+1*t28*t30*t49-1.0d+1*t25*t27*t49-1.2d+1*t25*t27*t48-1.2
     4         d+1*t22*t24*t48-1.4d+1*t22*t24*t47-1.4d+1*t19*t21*t47-1.6
     5         d+1*t19*t21*t46-1.6d+1*t16*t18*t46-1.8d+1*t16*t18*t45-1.8
     6         d+1*t13*t15*t45-2.0d+1*t13*t15*t44-2.0d+1*t10*t12*t44-2.2
     7         d+1*t10*t12*t43
            t65 = 1/t9**13
            t66 = 1/t61
            t67 = gammabb**2
            t68 = 1/t2**3
            t69 = 1/rhob**6
            t70 = 1/rhob**3.3333333333333337d+0
            t71 = 1/rhob**5
            t72 = 1/rhob**4
            fnc(iq) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t54-9.3052573
     1         63491002d-1*t3*t4*t40)*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t42*t54*t61-
     1         1.2407009817988002d+0*t3*t40*t61+8.963083509889702d-3*gam
     2         mabb*t40*t59*t60+5.041016444533138d-3*gammabb*t41*t54*t60
     3         -9.305257363491002d-1*t4*t42*t58-9.305257363491002d-1*t3*
     4         t4*t57)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t40*t59*t62-
     1         1.890381166699927d-3*t41*t54*t62)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t4*t42*t64-9.
     1         305257363491002d-1*t3*t4*t63)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(-1
     1         .1141288576844789d+2*t5*t56*t66*t8+3.046785819198518d+4*t
     2         4*t5*t65*t8-1.0128444160767991d+1*t37*t38*t66*t7+2.025688
     3         8321535982d+1*t35*t37*t66*t7+4.6163421503007845d+2*t34*t3
     4         8*t4*t7-1.846536860120314d+3*t34*t35*t4*t7+1.384902645090
     5         2355d+3*t32*t34*t4*t7+1.1141288576844789d+2*t10*t12*t5*t6
     6         6+1.0128444160767991d+1*t38*t39*t66-2.0256888321535982d+1
     7         *t34*t35*t36*t66+3.038533248230397d+1*t32*t34*t36*t66-3.0
     8         38533248230397d+1*t31*t32*t33*t66+4.0513776643071964d+1*t
     9         29*t31*t33*t66-4.0513776643071964d+1*t28*t29*t30*t66+5.06
     :         4222080383994d+1*t26*t28*t30*t66-5.064222080383994d+1*t25
     ;         *t26*t27*t66+6.077066496460795d+1*t23*t25*t27*t66-6.07706
     <         6496460795d+1*t22*t23*t24*t66+7.089910912537593d+1*t20*t2
     =         2*t24*t66-7.089910912537593d+1*t19*t20*t21*t66+8.10275532
     >         8614393d+1*t17*t19*t21*t66-8.102755328614393d+1*t16*t17*t
     ?         18*t66+9.115599744691191d+1*t14*t16*t18*t66-9.11559974469
     @         1191d+1*t13*t14*t15*t66+1.012844416076799d+2*t11*t13*t15*
     1         t66-1.012844416076799d+2*t10*t11*t12*t66-5.58577400186394
     2         9d+4*t12*t4*t5*t56+2.5389881826654315d+4*t11*t12*t4*t56+2
     3         .5389881826654315d+4*t10*t15*t4*t5-4.6163421503007845d+2*
     4         t37*t38*t4+4.6163421503007845d+2*t35*t37*t4+1.38490264509
     5         02355d+3*t31*t35*t36*t4-4.1547079352707067d+3*t31*t32*t36
     6         *t4+2.769805290180471d+3*t29*t31*t36*t4+2.769805290180471
     7         d+3*t28*t32*t33*t4-7.386147440481255d+3*t28*t29*t33*t4+4.
     8         616342150300784d+3*t26*t28*t33*t4+4.616342150300784d+3*t2
     9         5*t29*t30*t4-1.154085537575196d+4*t25*t26*t30*t4+6.924513
     :         225451178d+3*t23*t25*t30*t4+6.924513225451178d+3*t22*t26*
     ;         t27*t4-1.661883174108283d+4*t22*t23*t27*t4+9.694318515631
     <         648d+3*t20*t22*t27*t4+9.694318515631648d+3*t19*t23*t24*t4
     =         -2.2620076536473846d+4*t19*t20*t24*t4+1.2925758020842196d
     >         +4*t17*t19*t24*t4+1.2925758020842196d+4*t16*t20*t21*t4-2.
     ?         954458976192502d+4*t16*t17*t21*t4+1.6618831741082823d+4*t
     @         14*t16*t21*t4+1.6618831741082823d+4*t13*t17*t18*t4-3.7392
     1         371417436354d+4*t13*t14*t18*t4+2.0773539676353528d+4*t11*
     2         t13*t18*t4+2.0773539676353528d+4*t10*t14*t15*t4-4.6163421
     3         50300784d+4*t10*t11*t15*t4)-9.305257363491002d-1*t4*t42*(
     4         -1.1141288576844789d+2*t43*t56*t66*t8+3.046785819198518d+
     5         4*t4*t43*t65*t8-1.0128444160767991d+1*t37*t53*t66*t7+2.02
     6         56888321535982d+1*t37*t52*t66*t7+4.6163421503007845d+2*t3
     7         4*t4*t53*t7-1.846536860120314d+3*t34*t4*t52*t7+1.38490264
     8         50902355d+3*t34*t4*t51*t7+1.0128444160767991d+1*t39*t53*t
     9         66-2.0256888321535982d+1*t34*t36*t52*t66+3.03853324823039
     :         7d+1*t34*t36*t51*t66-3.038533248230397d+1*t31*t33*t51*t66
     ;         +4.0513776643071964d+1*t31*t33*t50*t66-4.0513776643071964
     <         d+1*t28*t30*t50*t66+5.064222080383994d+1*t28*t30*t49*t66-
     =         5.064222080383994d+1*t25*t27*t49*t66+6.077066496460795d+1
     >         *t25*t27*t48*t66-6.077066496460795d+1*t22*t24*t48*t66+7.0
     ?         89910912537593d+1*t22*t24*t47*t66-7.089910912537593d+1*t1
     @         9*t21*t47*t66+8.102755328614393d+1*t19*t21*t46*t66-8.1027
     1         55328614393d+1*t16*t18*t46*t66+9.115599744691191d+1*t16*t
     2         18*t45*t66-9.115599744691191d+1*t13*t15*t45*t66+1.0128444
     3         16076799d+2*t13*t15*t44*t66-1.012844416076799d+2*t10*t12*
     4         t44*t66+1.1141288576844789d+2*t10*t12*t43*t66+2.538988182
     5         6654315d+4*t12*t4*t44*t56-5.585774001863949d+4*t12*t4*t43
     6         *t56-4.6163421503007845d+2*t37*t4*t53+4.6163421503007845d
     7         +2*t37*t4*t52+1.3849026450902355d+3*t31*t36*t4*t52-4.1547
     8         079352707067d+3*t31*t36*t4*t51+2.769805290180471d+3*t28*t
     9         33*t4*t51+2.769805290180471d+3*t31*t36*t4*t50-7.386147440
     :         481255d+3*t28*t33*t4*t50+4.616342150300784d+3*t25*t30*t4*
     ;         t50+4.616342150300784d+3*t28*t33*t4*t49-1.154085537575196
     <         d+4*t25*t30*t4*t49+6.924513225451178d+3*t22*t27*t4*t49+6.
     =         924513225451178d+3*t25*t30*t4*t48-1.661883174108283d+4*t2
     >         2*t27*t4*t48+9.694318515631648d+3*t19*t24*t4*t48+9.694318
     ?         515631648d+3*t22*t27*t4*t47-2.2620076536473846d+4*t19*t24
     @         *t4*t47+1.2925758020842196d+4*t16*t21*t4*t47+1.2925758020
     1         842196d+4*t19*t24*t4*t46-2.954458976192502d+4*t16*t21*t4*
     2         t46+1.6618831741082823d+4*t13*t18*t4*t46+1.66188317410828
     3         23d+4*t16*t21*t4*t45-3.7392371417436354d+4*t13*t18*t4*t45
     4         +2.0773539676353528d+4*t10*t15*t4*t45+2.0773539676353528d
     5         +4*t13*t18*t4*t44-4.616342150300784d+4*t10*t15*t4*t44+2.5
     6         389881826654315d+4*t10*t15*t4*t43)-8.963083509889707d-3*g
     7         ammabb*t40*t59*t70-5.041016444533138d-3*gammabb*t41*t54*t
     8         70+2.1476348525932504d-4*t40*t67*t68*t69+4.94730586578665
     9         3d-5*t41*t54*t67*t69-2.4814019635976003d+0*t42*t58*t61-2.
     :         4814019635976003d+0*t3*t57*t61+1.7926167019779404d-2*gamm
     ;         abb*t57*t59*t60+1.0082032889066277d-2*gammabb*t41*t58*t60
     <         +(-4.135669939329334d-1*t42*t54-4.135669939329334d-1*t3*t
     =         40)/t55)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(-8.05363069722469d-5*gammabb*t
     1         40*t68*t71-1.855239699669995d-5*gammabb*t41*t54*t71-3.361
     2         156316208638d-3*t57*t59*t62-1.890381166699927d-3*t41*t58*
     3         t62+4.481541754944851d-3*t40*t59*t60+2.520508222266569d-3
     4         *t41*t54*t60)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(3.020111511459258d-5*t40*t68*
     1         t72+6.957148873762482d-6*t41*t54*t72)*wght+Cmat2(iq,D2_GB
     2         B_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(4.
     1         0108638876641245d+3*t5*t55*t65*t8+6.077066496460795d+1*t3
     2         4*t38*t55*t7-1.8231199489382385d+2*t32*t34*t55*t7+3.34238
     3         6573053437d+3*t11*t12*t55*t56-3.342386573053437d+3*t10*t1
     4         5*t5*t55-6.077066496460795d+1*t35*t37*t55+1.8231199489382
     5         385d+2*t31*t35*t36*t55-3.646239897876477d+2*t29*t31*t36*t
     6         55+3.646239897876477d+2*t28*t32*t33*t55-6.077066496460795
     7         d+2*t26*t28*t33*t55+6.077066496460795d+2*t25*t29*t30*t55-
     8         9.115599744691192d+2*t23*t25*t30*t55+9.115599744691192d+2
     9         *t22*t26*t27*t55-1.276183964256767d+3*t20*t22*t27*t55+1.2
     :         76183964256767d+3*t19*t23*t24*t55-1.7015786190090226d+3*t
     ;         17*t19*t24*t55+1.7015786190090226d+3*t16*t20*t21*t55-2.18
     <         7743938725886d+3*t14*t16*t21*t55+2.187743938725886d+3*t13
     =         *t17*t18*t55-2.734679923407357d+3*t11*t13*t18*t55+2.73467
     >         9923407357d+3*t10*t14*t15*t55)-9.305257363491002d-1*t4*t4
     ?         2*(4.0108638876641245d+3*t43*t55*t65*t8+6.077066496460795
     @         d+1*t34*t53*t55*t7-1.8231199489382385d+2*t34*t51*t55*t7+3
     1         .342386573053437d+3*t12*t44*t55*t56-6.077066496460795d+1*
     2         t37*t52*t55+1.8231199489382385d+2*t31*t36*t52*t55+3.64623
     3         9897876477d+2*t28*t33*t51*t55-3.646239897876477d+2*t31*t3
     4         6*t50*t55+6.077066496460795d+2*t25*t30*t50*t55-6.07706649
     5         6460795d+2*t28*t33*t49*t55+9.115599744691192d+2*t22*t27*t
     6         49*t55-9.115599744691192d+2*t25*t30*t48*t55+1.27618396425
     7         6767d+3*t19*t24*t48*t55-1.276183964256767d+3*t22*t27*t47*
     8         t55+1.7015786190090226d+3*t16*t21*t47*t55-1.7015786190090
     9         226d+3*t19*t24*t46*t55+2.187743938725886d+3*t13*t18*t46*t
     :         55-2.187743938725886d+3*t16*t21*t45*t55+2.734679923407357
     ;         d+3*t10*t15*t45*t55-2.734679923407357d+3*t13*t18*t44*t55-
     <         3.342386573053437d+3*t10*t15*t43*t55)-1.2407009817988002d
     =         +0*t42*t61*t64+5.041016444533138d-3*gammabb*t41*t60*t64-1
     >         .2407009817988002d+0*t3*t61*t63+8.963083509889702d-3*gamm
     ?         abb*t59*t60*t63)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(-1.890381166699927d-3*t41*t62*
     1         t64-3.361156316208638d-3*t59*t62*t63)*wght+Mmat2(iq,D2_GB
     2         B_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(5.
     1         28d+2*t5*t65*t8+8.0d+0*t34*t38*t7+3.2d+1*t34*t35*t7+2.4d+
     2         1*t32*t34*t7+9.68d+2*t12*t5*t56+4.4d+2*t11*t12*t56+4.4d+2
     3         *t10*t15*t5+8.0d+0*t37*t38+8.0d+0*t35*t37+2.4d+1*t31*t35*
     4         t36+7.2d+1*t31*t32*t36+4.8d+1*t29*t31*t36+4.8d+1*t28*t32*
     5         t33+1.28d+2*t28*t29*t33+8.0d+1*t26*t28*t33+8.0d+1*t25*t29
     6         *t30+2.0d+2*t25*t26*t30+1.2d+2*t23*t25*t30+1.2d+2*t22*t26
     7         *t27+2.88d+2*t22*t23*t27+1.68d+2*t20*t22*t27+1.68d+2*t19*
     8         t23*t24+3.92d+2*t19*t20*t24+2.24d+2*t17*t19*t24+2.24d+2*t
     9         16*t20*t21+5.12d+2*t16*t17*t21+2.88d+2*t14*t16*t21+2.88d+
     :         2*t13*t17*t18+6.48d+2*t13*t14*t18+3.6d+2*t11*t13*t18+3.6d
     ;         +2*t10*t14*t15+8.0d+2*t10*t11*t15)-9.305257363491002d-1*t
     <         4*t42*(5.28d+2*t43*t65*t8+8.0d+0*t34*t53*t7+3.2d+1*t34*t5
     =         2*t7+2.4d+1*t34*t51*t7+4.4d+2*t12*t44*t56+9.68d+2*t12*t43
     >         *t56+8.0d+0*t37*t53+8.0d+0*t37*t52+2.4d+1*t31*t36*t52+7.2
     ?         d+1*t31*t36*t51+4.8d+1*t28*t33*t51+4.8d+1*t31*t36*t50+1.2
     @         8d+2*t28*t33*t50+8.0d+1*t25*t30*t50+8.0d+1*t28*t33*t49+2.
     1         0d+2*t25*t30*t49+1.2d+2*t22*t27*t49+1.2d+2*t25*t30*t48+2.
     2         88d+2*t22*t27*t48+1.68d+2*t19*t24*t48+1.68d+2*t22*t27*t47
     3         +3.92d+2*t19*t24*t47+2.24d+2*t16*t21*t47+2.24d+2*t19*t24*
     4         t46+5.12d+2*t16*t21*t46+2.88d+2*t13*t18*t46+2.88d+2*t16*t
     5         21*t45+6.48d+2*t13*t18*t45+3.6d+2*t10*t15*t45+3.6d+2*t13*
     6         t18*t44+8.0d+2*t10*t15*t44+4.4d+2*t10*t15*t43))*wght+Mmat
     7         2(iq,D2_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_m08 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_4} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_5} &=& 9.115599744691192\,\rho_\alpha^{{{5}\over{3}}}\\\\ 
C>   {\it t_6} &=& {\it t_5}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_7} &=& {\it t_6}^{11}\\\\ 
C>   {\it t_8} &=& 2.0\,\tau_\alpha+{\it t_5}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_8}^{11}}}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{11}} &=& {\it t_6}^{10}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_8}^{10}}}\\\\ 
C>   {\it t_{13}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{14}} &=& {\it t_6}^9\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_8}^9}}\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{17}} &=& {\it t_6}^8\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_8}^8}}\\\\ 
C>   {\it t_{19}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{20}} &=& {\it t_6}^7\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_8}^7}}\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{23}} &=& {\it t_6}^6\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_8}^6}}\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{26}} &=& {\it t_6}^5\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_8}^5}}\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{29}} &=& {\it t_6}^4\\\\ 
C>   {\it t_{30}} &=& {{1}\over{{\it t_8}^4}}\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{32}} &=& {\it t_6}^3\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_8}^3}}\\\\ 
C>   {\it t_{34}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{35}} &=& {\it t_6}^2\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_8}^2}}\\\\ 
C>   {\it t_{37}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_8}}}\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{44}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{49}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{50}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{51}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{52}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{53}} &=& 9.115599744691192\,\rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{54}} &=& {\it t_{53}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{55}} &=& {\it t_{54}}^{11}\\\\ 
C>   {\it t_{56}} &=& 2.0\,\tau_\beta+{\it t_{53}}\\\\ 
C>   {\it t_{57}} &=& {{1}\over{{\it t_{56}}^{11}}}\\\\ 
C>   {\it t_{58}} &=& {\it t_{54}}^{10}\\\\ 
C>   {\it t_{59}} &=& {{1}\over{{\it t_{56}}^{10}}}\\\\ 
C>   {\it t_{60}} &=& {\it t_{54}}^9\\\\ 
C>   {\it t_{61}} &=& {{1}\over{{\it t_{56}}^9}}\\\\ 
C>   {\it t_{62}} &=& {\it t_{54}}^8\\\\ 
C>   {\it t_{63}} &=& {{1}\over{{\it t_{56}}^8}}\\\\ 
C>   {\it t_{64}} &=& {\it t_{54}}^7\\\\ 
C>   {\it t_{65}} &=& {{1}\over{{\it t_{56}}^7}}\\\\ 
C>   {\it t_{66}} &=& {\it t_{54}}^6\\\\ 
C>   {\it t_{67}} &=& {{1}\over{{\it t_{56}}^6}}\\\\ 
C>   {\it t_{68}} &=& {\it t_{54}}^5\\\\ 
C>   {\it t_{69}} &=& {{1}\over{{\it t_{56}}^5}}\\\\ 
C>   {\it t_{70}} &=& {\it t_{54}}^4\\\\ 
C>   {\it t_{71}} &=& {{1}\over{{\it t_{56}}^4}}\\\\ 
C>   {\it t_{72}} &=& {\it t_{54}}^3\\\\ 
C>   {\it t_{73}} &=& {{1}\over{{\it t_{56}}^3}}\\\\ 
C>   {\it t_{74}} &=& {\it t_{54}}^2\\\\ 
C>   {\it t_{75}} &=& {{1}\over{{\it t_{56}}^2}}\\\\ 
C>   {\it t_{76}} &=& {{1}\over{{\it t_{56}}}}\\\\ 
C>   {\it t_{77}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{78}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{79}} &=& 9.115599744691192\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{80}} &=& {\it t_{79}}-2.0\,\tau_s\\\\ 
C>   {\it t_{81}} &=& {\it t_{80}}^{11}\\\\ 
C>   {\it t_{82}} &=& 2.0\,\tau_s+{\it t_{79}}\\\\ 
C>   {\it t_{83}} &=& {{1}\over{{\it t_{82}}^{11}}}\\\\ 
C>   {\it t_{84}} &=& {\it t_{80}}^{10}\\\\ 
C>   {\it t_{85}} &=& {{1}\over{{\it t_{82}}^{10}}}\\\\ 
C>   {\it t_{86}} &=& {\it t_{80}}^9\\\\ 
C>   {\it t_{87}} &=& {{1}\over{{\it t_{82}}^9}}\\\\ 
C>   {\it t_{88}} &=& {\it t_{80}}^8\\\\ 
C>   {\it t_{89}} &=& {{1}\over{{\it t_{82}}^8}}\\\\ 
C>   {\it t_{90}} &=& {\it t_{80}}^7\\\\ 
C>   {\it t_{91}} &=& {{1}\over{{\it t_{82}}^7}}\\\\ 
C>   {\it t_{92}} &=& {\it t_{80}}^6\\\\ 
C>   {\it t_{93}} &=& {{1}\over{{\it t_{82}}^6}}\\\\ 
C>   {\it t_{94}} &=& {\it t_{80}}^5\\\\ 
C>   {\it t_{95}} &=& {{1}\over{{\it t_{82}}^5}}\\\\ 
C>   {\it t_{96}} &=& {\it t_{80}}^4\\\\ 
C>   {\it t_{97}} &=& {{1}\over{{\it t_{82}}^4}}\\\\ 
C>   {\it t_{98}} &=& {\it t_{80}}^3\\\\ 
C>   {\it t_{99}} &=& {{1}\over{{\it t_{82}}^3}}\\\\ 
C>   {\it t_{100}} &=& {\it t_{80}}^2\\\\ 
C>   {\it t_{101}} &=& {{1}\over{{\it t_{82}}^2}}\\\\ 
C>   {\it t_{102}} &=& {{1}\over{{\it t_{82}}}}\\\\ 
C>   f &=& 1.0\,\left(-0.9305257363491002\,{\it t_{51}}\,\left(0.552
C>    \,\left(1.0-{{1}\over{e^{0.003680288926019986\,{\it t_{52}}
C>    \,\sigma_{\beta\beta}}}}\right)+1.0\right)\,\left({\it t_{50}}
C>    \,{\it t_{54}}\,{\it t_{76}}+{\it t_{49}}\,{\it t_{74}}\,{
C>    \it t_{75}}+{\it t_{48}}\,{\it t_{72}}\,{\it t_{73}}+{
C>    \it t_{47}}\,{\it t_{70}}\,{\it t_{71}}+{\it t_{46}}\,{
C>    \it t_{68}}\,{\it t_{69}}+{\it t_{45}}\,{\it t_{66}}\,{
C>    \it t_{67}}+{\it t_{44}}\,{\it t_{64}}\,{\it t_{65}}+{
C>    \it t_{43}}\,{\it t_{62}}\,{\it t_{63}}+{\it t_{42}}\,{
C>    \it t_{60}}\,{\it t_{61}}+{\it t_{41}}\,{\it t_{58}}\,{
C>    \it t_{59}}+{\it t_{40}}\,{\it t_{55}}\,{\it t_{57}}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_{51}}\,
C>    \left(0.804\,\left(1.0-{{1.0}\over{0.004492667444378077\,{
C>    \it t_{52}}\,\sigma_{\beta\beta}+1.0}}\right)+1.0\right)
C>    \,\left({\it t_{37}}\,{\it t_{54}}\,{\it t_{76}}+{\it t_{34}}
C>    \,{\it t_{74}}\,{\it t_{75}}+{\it t_{31}}\,{\it t_{72}}\,{
C>    \it t_{73}}+{\it t_{28}}\,{\it t_{70}}\,{\it t_{71}}+{
C>    \it t_{25}}\,{\it t_{68}}\,{\it t_{69}}+{\it t_{22}}\,{
C>    \it t_{66}}\,{\it t_{67}}+{\it t_{19}}\,{\it t_{64}}\,{
C>    \it t_{65}}+{\it t_{16}}\,{\it t_{62}}\,{\it t_{63}}+{
C>    \it t_{13}}\,{\it t_{60}}\,{\it t_{61}}+{\it t_{10}}\,{
C>    \it t_{58}}\,{\it t_{59}}+{\it t_4}\,{\it t_{55}}\,{\it t_{57}}
C>    +{\it t_3}\right)\right)+1.0\,\left(-0.9305257363491002\,{
C>    \it t_1}\,\left(0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}}}}\right)+1.0\right)\,\left({\it t_{50}}
C>    \,{\it t_6}\,{\it t_{38}}+{\it t_{49}}\,{\it t_{35}}\,{
C>    \it t_{36}}+{\it t_{48}}\,{\it t_{32}}\,{\it t_{33}}+{
C>    \it t_{47}}\,{\it t_{29}}\,{\it t_{30}}+{\it t_{46}}\,{
C>    \it t_{26}}\,{\it t_{27}}+{\it t_{45}}\,{\it t_{23}}\,{
C>    \it t_{24}}+{\it t_{44}}\,{\it t_{20}}\,{\it t_{21}}+{
C>    \it t_{43}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{42}}\,{
C>    \it t_{14}}\,{\it t_{15}}+{\it t_{41}}\,{\it t_{11}}\,{
C>    \it t_{12}}+{\it t_{40}}\,{\it t_7}\,{\it t_9}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_1}\,\left(0.804
C>    \,\left(1.0-{{1.0}\over{0.004492667444378077\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0}}\right)+1.0\right)\,\left({
C>    \it t_{37}}\,{\it t_6}\,{\it t_{38}}+{\it t_{34}}\,{
C>    \it t_{35}}\,{\it t_{36}}+{\it t_{31}}\,{\it t_{32}}\,{
C>    \it t_{33}}+{\it t_{28}}\,{\it t_{29}}\,{\it t_{30}}+{
C>    \it t_{25}}\,{\it t_{26}}\,{\it t_{27}}+{\it t_{22}}\,{
C>    \it t_{23}}\,{\it t_{24}}+{\it t_{19}}\,{\it t_{20}}\,{
C>    \it t_{21}}+{\it t_{16}}\,{\it t_{17}}\,{\it t_{18}}+{
C>    \it t_{13}}\,{\it t_{14}}\,{\it t_{15}}+{\it t_{10}}\,{
C>    \it t_{11}}\,{\it t_{12}}+{\it t_4}\,{\it t_7}\,{\it t_9}+{
C>    \it t_3}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-0.9305257363491002\,{\it t_{77}}\,\left(0.552
C>    \,\left(1.0-{{1}\over{e^{0.003680288926019986\,{\it t_{78}}
C>    \,\sigma_{ss}}}}\right)+1.0\right)\,\left({\it t_{50}}\,{
C>    \it t_{80}}\,{\it t_{102}}+{\it t_{49}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{48}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{47}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{46}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{45}}\,{\it t_{92}}\,{
C>    \it t_{93}}+{\it t_{44}}\,{\it t_{90}}\,{\it t_{91}}+{
C>    \it t_{43}}\,{\it t_{88}}\,{\it t_{89}}+{\it t_{42}}\,{
C>    \it t_{86}}\,{\it t_{87}}+{\it t_{41}}\,{\it t_{84}}\,{
C>    \it t_{85}}+{\it t_{40}}\,{\it t_{81}}\,{\it t_{83}}+{
C>    \it t_{39}}\right)-0.9305257363491002\,{\it t_{77}}\,
C>    \left(0.804\,\left(1.0-{{1.0}\over{0.004492667444378077\,{
C>    \it t_{78}}\,\sigma_{ss}+1.0}}\right)+1.0\right)\,\left({
C>    \it t_{37}}\,{\it t_{80}}\,{\it t_{102}}+{\it t_{34}}\,{
C>    \it t_{100}}\,{\it t_{101}}+{\it t_{31}}\,{\it t_{98}}\,{
C>    \it t_{99}}+{\it t_{28}}\,{\it t_{96}}\,{\it t_{97}}+{
C>    \it t_{25}}\,{\it t_{94}}\,{\it t_{95}}+{\it t_{22}}\,{
C>    \it t_{92}}\,{\it t_{93}}+{\it t_{19}}\,{\it t_{90}}\,{
C>    \it t_{91}}+{\it t_{16}}\,{\it t_{88}}\,{\it t_{89}}+{
C>    \it t_{13}}\,{\it t_{86}}\,{\it t_{87}}+{\it t_{10}}\,{
C>    \it t_{84}}\,{\it t_{85}}+{\it t_4}\,{\it t_{81}}\,{\it t_{83}}
C>    +{\it t_3}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.TheoryComput. 4, 1849 (2008)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/ct800246v "> 
C> 10.1021/ct800246v </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m08_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(12)
            t6 = rhoa**1.6666666666666669d+0
            t7 = 9.115599744691192d+0*t6
            t8 = t7-2.0d+0*taua
            t9 = t8**11
            t10 = 2.0d+0*taua+t7
            t11 = 1/t10**11
            t12 = param(11)
            t13 = t8**10
            t14 = 1/t10**10
            t15 = param(10)
            t16 = t8**9
            t17 = 1/t10**9
            t18 = param(9)
            t19 = t8**8
            t20 = 1/t10**8
            t21 = param(8)
            t22 = t8**7
            t23 = 1/t10**7
            t24 = param(7)
            t25 = t8**6
            t26 = 1/t10**6
            t27 = param(6)
            t28 = t8**5
            t29 = 1/t10**5
            t30 = param(5)
            t31 = t8**4
            t32 = 1/t10**4
            t33 = param(4)
            t34 = t8**3
            t35 = 1/t10**3
            t36 = param(3)
            t37 = t8**2
            t38 = 1/t10**2
            t39 = param(2)
            t40 = 1/t10
            t41 = t11*t5*t9+t39*t40*t8+t36*t37*t38+t33*t34*t35+t30*t31*t
     1         32+t27*t28*t29+t24*t25*t26+t21*t22*t23+t18*t19*t20+t15*t1
     2         6*t17+t12*t13*t14+param(1)
            t42 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t43 = 5.52d-1*(1.0d+0-t42)+1.0d+0
            t44 = param(24)
            t45 = param(23)
            t46 = param(22)
            t47 = param(21)
            t48 = param(20)
            t49 = param(19)
            t50 = param(18)
            t51 = param(17)
            t52 = param(16)
            t53 = param(15)
            t54 = param(14)
            t55 = t11*t44*t9+t40*t54*t8+t37*t38*t53+t34*t35*t52+t31*t32*
     1         t51+t28*t29*t50+t25*t26*t49+t22*t23*t48+t19*t20*t47+t16*t
     2         17*t46+t13*t14*t45+param(13)
            t56 = rhoa**6.666666666666666d-1
            t57 = 1/t10**12
            t58 = -1.6711932865267184d+2*t5*t56*t57*t9-1.519266624115198
     1         6d+1*t38*t39*t56*t8+3.038533248230397d+1*t36*t38*t56*t8+1
     2         .6711932865267184d+2*t11*t13*t5*t56+1.5192666241151986d+1
     3         *t39*t40*t56-3.038533248230397d+1*t35*t36*t37*t56+4.55779
     4         98723455965d+1*t33*t35*t37*t56-4.5577998723455965d+1*t32*
     5         t33*t34*t56+6.077066496460795d+1*t30*t32*t34*t56-6.077066
     6         496460795d+1*t29*t30*t31*t56+7.596333120575993d+1*t27*t29
     7         *t31*t56-7.596333120575993d+1*t26*t27*t28*t56+9.115599744
     8         691193d+1*t24*t26*t28*t56-9.115599744691193d+1*t23*t24*t2
     9         5*t56+1.0634866368806391d+2*t21*t23*t25*t56-1.06348663688
     :         06391d+2*t20*t21*t22*t56+1.2154132992921589d+2*t18*t20*t2
     ;         2*t56-1.2154132992921589d+2*t17*t18*t19*t56+1.36733996170
     <         36788d+2*t15*t17*t19*t56-1.3673399617036788d+2*t14*t15*t1
     =         6*t56+1.5192666241151986d+2*t12*t14*t16*t56-1.51926662411
     >         51986d+2*t11*t12*t13*t56
            t59 = -1.6711932865267184d+2*t44*t56*t57*t9-1.51926662411519
     1         86d+1*t38*t54*t56*t8+3.038533248230397d+1*t38*t53*t56*t8+
     2         1.5192666241151986d+1*t40*t54*t56-3.038533248230397d+1*t3
     3         5*t37*t53*t56+4.5577998723455965d+1*t35*t37*t52*t56-4.557
     4         7998723455965d+1*t32*t34*t52*t56+6.077066496460795d+1*t32
     5         *t34*t51*t56-6.077066496460795d+1*t29*t31*t51*t56+7.59633
     6         3120575993d+1*t29*t31*t50*t56-7.596333120575993d+1*t26*t2
     7         8*t50*t56+9.115599744691193d+1*t26*t28*t49*t56-9.11559974
     8         4691193d+1*t23*t25*t49*t56+1.0634866368806391d+2*t23*t25*
     9         t48*t56-1.0634866368806391d+2*t20*t22*t48*t56+1.215413299
     :         2921589d+2*t20*t22*t47*t56-1.2154132992921589d+2*t17*t19*
     ;         t47*t56+1.3673399617036788d+2*t17*t19*t46*t56-1.367339961
     <         7036788d+2*t14*t16*t46*t56+1.5192666241151986d+2*t14*t16*
     =         t45*t56-1.5192666241151986d+2*t11*t13*t45*t56+1.671193286
     >         5267184d+2*t11*t13*t44*t56
            t60 = 1/t2**2
            t61 = 1/rhoa**2.3333333333333334d+0
            t62 = rhoa**3.333333333333333d-1
            t63 = 1/t4
            t64 = -2.2d+1*t5*t57*t9-2.0d+0*t38*t39*t8-4.0d+0*t36*t38*t8-
     1         2.2d+1*t11*t13*t5-2.0d+0*t39*t40-4.0d+0*t35*t36*t37-6.0d+
     2         0*t33*t35*t37-6.0d+0*t32*t33*t34-8.0d+0*t30*t32*t34-8.0d+
     3         0*t29*t30*t31-1.0d+1*t27*t29*t31-1.0d+1*t26*t27*t28-1.2d+
     4         1*t24*t26*t28-1.2d+1*t23*t24*t25-1.4d+1*t21*t23*t25-1.4d+
     5         1*t20*t21*t22-1.6d+1*t18*t20*t22-1.6d+1*t17*t18*t19-1.8d+
     6         1*t15*t17*t19-1.8d+1*t14*t15*t16-2.0d+1*t12*t14*t16-2.0d+
     7         1*t11*t12*t13
            t65 = -2.2d+1*t44*t57*t9-2.0d+0*t38*t54*t8-4.0d+0*t38*t53*t8
     1         -2.0d+0*t40*t54-4.0d+0*t35*t37*t53-6.0d+0*t35*t37*t52-6.0
     2         d+0*t32*t34*t52-8.0d+0*t32*t34*t51-8.0d+0*t29*t31*t51-1.0
     3         d+1*t29*t31*t50-1.0d+1*t26*t28*t50-1.2d+1*t26*t28*t49-1.2
     4         d+1*t23*t25*t49-1.4d+1*t23*t25*t48-1.4d+1*t20*t22*t48-1.6
     5         d+1*t20*t22*t47-1.6d+1*t17*t19*t47-1.8d+1*t17*t19*t46-1.8
     6         d+1*t14*t16*t46-2.0d+1*t14*t16*t45-2.0d+1*t11*t13*t45-2.2
     7         d+1*t11*t13*t44
            t66 = 1/t10**13
            t67 = 1/t62
            t68 = -1.1141288576844789d+2*t5*t57*t67*t9+3.046785819198518
     1         d+4*t4*t5*t66*t9-1.0128444160767991d+1*t38*t39*t67*t8+2.0
     2         256888321535982d+1*t36*t38*t67*t8+4.6163421503007845d+2*t
     3         35*t39*t4*t8-1.846536860120314d+3*t35*t36*t4*t8+1.3849026
     4         450902355d+3*t33*t35*t4*t8+1.1141288576844789d+2*t11*t13*
     5         t5*t67+1.0128444160767991d+1*t39*t40*t67-2.02568883215359
     6         82d+1*t35*t36*t37*t67+3.038533248230397d+1*t33*t35*t37*t6
     7         7-3.038533248230397d+1*t32*t33*t34*t67+4.0513776643071964
     8         d+1*t30*t32*t34*t67-4.0513776643071964d+1*t29*t30*t31*t67
     9         +5.064222080383994d+1*t27*t29*t31*t67-5.064222080383994d+
     :         1*t26*t27*t28*t67+6.077066496460795d+1*t24*t26*t28*t67-6.
     ;         077066496460795d+1*t23*t24*t25*t67+7.089910912537593d+1*t
     <         21*t23*t25*t67-7.089910912537593d+1*t20*t21*t22*t67+8.102
     =         755328614393d+1*t18*t20*t22*t67-8.102755328614393d+1*t17*
     >         t18*t19*t67+9.115599744691191d+1*t15*t17*t19*t67-9.115599
     ?         744691191d+1*t14*t15*t16*t67+1.012844416076799d+2*t12*t14
     @         *t16*t67-1.012844416076799d+2*t11*t12*t13*t67-5.585774001
     1         863949d+4*t13*t4*t5*t57+2.5389881826654315d+4*t12*t13*t4*
     2         t57+2.5389881826654315d+4*t11*t16*t4*t5-4.616342150300784
     3         5d+2*t38*t39*t4+4.6163421503007845d+2*t36*t38*t4+1.384902
     4         6450902355d+3*t32*t36*t37*t4-4.1547079352707067d+3*t32*t3
     5         3*t37*t4+2.769805290180471d+3*t30*t32*t37*t4+2.7698052901
     6         80471d+3*t29*t33*t34*t4-7.386147440481255d+3*t29*t30*t34*
     7         t4+4.616342150300784d+3*t27*t29*t34*t4+4.616342150300784d
     8         +3*t26*t30*t31*t4-1.154085537575196d+4*t26*t27*t31*t4+6.9
     9         24513225451178d+3*t24*t26*t31*t4+6.924513225451178d+3*t23
     :         *t27*t28*t4-1.661883174108283d+4*t23*t24*t28*t4+9.6943185
     ;         15631648d+3*t21*t23*t28*t4+9.694318515631648d+3*t20*t24*t
     <         25*t4-2.2620076536473846d+4*t20*t21*t25*t4+1.292575802084
     =         2196d+4*t18*t20*t25*t4+1.2925758020842196d+4*t17*t21*t22*
     >         t4-2.954458976192502d+4*t17*t18*t22*t4+1.6618831741082823
     ?         d+4*t15*t17*t22*t4+1.6618831741082823d+4*t14*t18*t19*t4-3
     @         .7392371417436354d+4*t14*t15*t19*t4+2.0773539676353528d+4
     1         *t12*t14*t19*t4+2.0773539676353528d+4*t11*t15*t16*t4-4.61
     2         6342150300784d+4*t11*t12*t16*t4
            t69 = -1.1141288576844789d+2*t44*t57*t67*t9+3.04678581919851
     1         8d+4*t4*t44*t66*t9-1.0128444160767991d+1*t38*t54*t67*t8+2
     2         .0256888321535982d+1*t38*t53*t67*t8+4.6163421503007845d+2
     3         *t35*t4*t54*t8-1.846536860120314d+3*t35*t4*t53*t8+1.38490
     4         26450902355d+3*t35*t4*t52*t8+1.0128444160767991d+1*t40*t5
     5         4*t67-2.0256888321535982d+1*t35*t37*t53*t67+3.03853324823
     6         0397d+1*t35*t37*t52*t67-3.038533248230397d+1*t32*t34*t52*
     7         t67+4.0513776643071964d+1*t32*t34*t51*t67-4.0513776643071
     8         964d+1*t29*t31*t51*t67+5.064222080383994d+1*t29*t31*t50*t
     9         67-5.064222080383994d+1*t26*t28*t50*t67+6.077066496460795
     :         d+1*t26*t28*t49*t67-6.077066496460795d+1*t23*t25*t49*t67+
     ;         7.089910912537593d+1*t23*t25*t48*t67-7.089910912537593d+1
     <         *t20*t22*t48*t67+8.102755328614393d+1*t20*t22*t47*t67-8.1
     =         02755328614393d+1*t17*t19*t47*t67+9.115599744691191d+1*t1
     >         7*t19*t46*t67-9.115599744691191d+1*t14*t16*t46*t67+1.0128
     ?         44416076799d+2*t14*t16*t45*t67-1.012844416076799d+2*t11*t
     @         13*t45*t67+1.1141288576844789d+2*t11*t13*t44*t67+2.538988
     1         1826654315d+4*t13*t4*t45*t57-5.585774001863949d+4*t13*t4*
     2         t44*t57-4.6163421503007845d+2*t38*t4*t54+4.61634215030078
     3         45d+2*t38*t4*t53+1.3849026450902355d+3*t32*t37*t4*t53-4.1
     4         547079352707067d+3*t32*t37*t4*t52+2.769805290180471d+3*t2
     5         9*t34*t4*t52+2.769805290180471d+3*t32*t37*t4*t51-7.386147
     6         440481255d+3*t29*t34*t4*t51+4.616342150300784d+3*t26*t31*
     7         t4*t51+4.616342150300784d+3*t29*t34*t4*t50-1.154085537575
     8         196d+4*t26*t31*t4*t50+6.924513225451178d+3*t23*t28*t4*t50
     9         +6.924513225451178d+3*t26*t31*t4*t49-1.661883174108283d+4
     :         *t23*t28*t4*t49+9.694318515631648d+3*t20*t25*t4*t49+9.694
     ;         318515631648d+3*t23*t28*t4*t48-2.2620076536473846d+4*t20*
     <         t25*t4*t48+1.2925758020842196d+4*t17*t22*t4*t48+1.2925758
     =         020842196d+4*t20*t25*t4*t47-2.954458976192502d+4*t17*t22*
     >         t4*t47+1.6618831741082823d+4*t14*t19*t4*t47+1.66188317410
     ?         82823d+4*t17*t22*t4*t46-3.7392371417436354d+4*t14*t19*t4*
     @         t46+2.0773539676353528d+4*t11*t16*t4*t46+2.07735396763535
     1         28d+4*t14*t19*t4*t45-4.616342150300784d+4*t11*t16*t4*t45+
     2         2.5389881826654315d+4*t11*t16*t4*t44
            t70 = gammaaa**2
            t71 = 1/t2**3
            t72 = 1/rhoa**6
            t73 = 1/rhoa**3.3333333333333337d+0
            t74 = 1/t56
            t75 = -4.135669939329334d-1*t43*t55-4.135669939329334d-1*t3*
     1         t41
            t76 = 1/rhoa**5
            t77 = 1/rhoa**4
            t78 = 4.0108638876641245d+3*t5*t56*t66*t9+6.077066496460795d
     1         +1*t35*t39*t56*t8-1.8231199489382385d+2*t33*t35*t56*t8+3.
     2         342386573053437d+3*t12*t13*t56*t57-3.342386573053437d+3*t
     3         11*t16*t5*t56-6.077066496460795d+1*t36*t38*t56+1.82311994
     4         89382385d+2*t32*t36*t37*t56-3.646239897876477d+2*t30*t32*
     5         t37*t56+3.646239897876477d+2*t29*t33*t34*t56-6.0770664964
     6         60795d+2*t27*t29*t34*t56+6.077066496460795d+2*t26*t30*t31
     7         *t56-9.115599744691192d+2*t24*t26*t31*t56+9.1155997446911
     8         92d+2*t23*t27*t28*t56-1.276183964256767d+3*t21*t23*t28*t5
     9         6+1.276183964256767d+3*t20*t24*t25*t56-1.7015786190090226
     :         d+3*t18*t20*t25*t56+1.7015786190090226d+3*t17*t21*t22*t56
     ;         -2.187743938725886d+3*t15*t17*t22*t56+2.187743938725886d+
     <         3*t14*t18*t19*t56-2.734679923407357d+3*t12*t14*t19*t56+2.
     =         734679923407357d+3*t11*t15*t16*t56
            t79 = 4.0108638876641245d+3*t44*t56*t66*t9+6.077066496460795
     1         d+1*t35*t54*t56*t8-1.8231199489382385d+2*t35*t52*t56*t8+3
     2         .342386573053437d+3*t13*t45*t56*t57-6.077066496460795d+1*
     3         t38*t53*t56+1.8231199489382385d+2*t32*t37*t53*t56+3.64623
     4         9897876477d+2*t29*t34*t52*t56-3.646239897876477d+2*t32*t3
     5         7*t51*t56+6.077066496460795d+2*t26*t31*t51*t56-6.07706649
     6         6460795d+2*t29*t34*t50*t56+9.115599744691192d+2*t23*t28*t
     7         50*t56-9.115599744691192d+2*t26*t31*t49*t56+1.27618396425
     8         6767d+3*t20*t25*t49*t56-1.276183964256767d+3*t23*t28*t48*
     9         t56+1.7015786190090226d+3*t17*t22*t48*t56-1.7015786190090
     :         226d+3*t20*t25*t47*t56+2.187743938725886d+3*t14*t19*t47*t
     ;         56-2.187743938725886d+3*t17*t22*t46*t56+2.734679923407357
     <         d+3*t11*t16*t46*t56-2.734679923407357d+3*t14*t19*t45*t56-
     =         3.342386573053437d+3*t11*t16*t44*t56
            t80 = rhoa**2
            t81 = 1/t10**14
            t82 = gammaaa**3
            t83 = 1/t2**4
            t84 = 1/rhoa**9.666666666666666d+0
            t85 = 1/rhoa**7
            t86 = 1/rhoa**4.333333333333333d+0
            t87 = 1/rhoa**3.6666666666666664d+0
            t88 = 1/rhoa**8.666666666666666d+0
            t89 = 1/rhoa**7.666666666666667d+0
            t90 = 1/rhoa**6.666666666666667d+0
            fnc(iq) = 2.0d+0*(-9.305257363491002d-1*t4*t43*t55-9.3052573
     1         63491002d-1*t3*t4*t41)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t43*t55*t62-
     1         1.2407009817988002d+0*t3*t41*t62+8.963083509889702d-3*gam
     2         maaa*t41*t60*t61+5.041016444533138d-3*gammaaa*t42*t55*t61
     3         -9.305257363491002d-1*t4*t43*t59-9.305257363491002d-1*t3*
     4         t4*t58)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t41*t60*t63-
     1         1.890381166699927d-3*t42*t55*t63)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t65-9.
     1         305257363491002d-1*t3*t4*t64)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t74*t75-8.963083509889707d-3*ga
     1         mmaaa*t41*t60*t73-5.041016444533138d-3*gammaaa*t42*t55*t7
     2         3+2.1476348525932504d-4*t41*t70*t71*t72+4.947305865786653
     3         d-5*t42*t55*t70*t72-9.305257363491002d-1*t4*t43*t69-9.305
     4         257363491002d-1*t3*t4*t68-2.4814019635976003d+0*t43*t59*t
     5         62-2.4814019635976003d+0*t3*t58*t62+1.7926167019779404d-2
     6         *gammaaa*t58*t60*t61+1.0082032889066277d-2*gammaaa*t42*t5
     7         9*t61)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(-8.05363069722469d-5*gammaaa*t
     1         41*t71*t76-1.855239699669995d-5*gammaaa*t42*t55*t76-3.361
     2         156316208638d-3*t58*t60*t63-1.890381166699927d-3*t42*t59*
     3         t63+4.481541754944851d-3*t41*t60*t61+2.520508222266569d-3
     4         *t42*t55*t61)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(3.020111511459258d-5*t41*t71*
     1         t77+6.957148873762482d-6*t42*t55*t77)*wght+Cmat2(iq,D2_GA
     2         A_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t7
     1         9-9.305257363491002d-1*t3*t4*t78-1.2407009817988002d+0*t4
     2         3*t62*t65+5.041016444533138d-3*gammaaa*t42*t61*t65-1.2407
     3         009817988002d+0*t3*t62*t64+8.963083509889702d-3*gammaaa*t
     4         60*t61*t64)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-1.890381166699927d-3*t42*t63*
     1         t65-3.361156316208638d-3*t60*t63*t64)*wght+Mmat2(iq,D2_GA
     2         A_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*(5.
     1         28d+2*t5*t66*t9+8.0d+0*t35*t39*t8+3.2d+1*t35*t36*t8+2.4d+
     2         1*t33*t35*t8+9.68d+2*t13*t5*t57+4.4d+2*t12*t13*t57+4.4d+2
     3         *t11*t16*t5+8.0d+0*t38*t39+8.0d+0*t36*t38+2.4d+1*t32*t36*
     4         t37+7.2d+1*t32*t33*t37+4.8d+1*t30*t32*t37+4.8d+1*t29*t33*
     5         t34+1.28d+2*t29*t30*t34+8.0d+1*t27*t29*t34+8.0d+1*t26*t30
     6         *t31+2.0d+2*t26*t27*t31+1.2d+2*t24*t26*t31+1.2d+2*t23*t27
     7         *t28+2.88d+2*t23*t24*t28+1.68d+2*t21*t23*t28+1.68d+2*t20*
     8         t24*t25+3.92d+2*t20*t21*t25+2.24d+2*t18*t20*t25+2.24d+2*t
     9         17*t21*t22+5.12d+2*t17*t18*t22+2.88d+2*t15*t17*t22+2.88d+
     :         2*t14*t18*t19+6.48d+2*t14*t15*t19+3.6d+2*t12*t14*t19+3.6d
     ;         +2*t11*t15*t16+8.0d+2*t11*t12*t16)-9.305257363491002d-1*t
     <         4*t43*(5.28d+2*t44*t66*t9+8.0d+0*t35*t54*t8+3.2d+1*t35*t5
     =         3*t8+2.4d+1*t35*t52*t8+4.4d+2*t13*t45*t57+9.68d+2*t13*t44
     >         *t57+8.0d+0*t38*t54+8.0d+0*t38*t53+2.4d+1*t32*t37*t53+7.2
     ?         d+1*t32*t37*t52+4.8d+1*t29*t34*t52+4.8d+1*t32*t37*t51+1.2
     @         8d+2*t29*t34*t51+8.0d+1*t26*t31*t51+8.0d+1*t29*t34*t50+2.
     1         0d+2*t26*t31*t50+1.2d+2*t23*t28*t50+1.2d+2*t26*t31*t49+2.
     2         88d+2*t23*t28*t49+1.68d+2*t20*t25*t49+1.68d+2*t23*t28*t48
     3         +3.92d+2*t20*t25*t48+2.24d+2*t17*t22*t48+2.24d+2*t20*t25*
     4         t47+5.12d+2*t17*t22*t47+2.88d+2*t14*t19*t47+2.88d+2*t17*t
     5         22*t46+6.48d+2*t14*t19*t46+3.6d+2*t11*t16*t46+3.6d+2*t14*
     6         t19*t45+8.0d+2*t11*t16*t45+4.4d+2*t11*t16*t44))*wght+Mmat
     7         2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-6.01754400771653d+6*t5*t80*t81*t9+6.093571638397036d+4*
     2         t5*t62*t66*t9+3.713762858948263d+1*t5*t57*t63*t9-2.104036
     3         366334451d+4*t32*t39*t8*t80+1.2624218198006704d+5*t32*t36
     4         *t8*t80-1.8936327297010064d+5*t32*t33*t8*t80+8.4161454653
     5         37804d+4*t30*t32*t8*t80+1.5275304019588112d+7*t13*t5*t66*
     6         t80-4.628880005935792d+6*t12*t13*t66*t80-1.27294200163234
     7         26d+7*t16*t5*t57*t80-3.4716600044518436d+6*t15*t16*t57*t8
     8         0+1.1572200014839477d+7*t12*t16*t57*t80+3.471660004451843
     9         6d+6*t11*t19*t5*t80+2.104036366334451d+4*t35*t39*t80-8.41
     :         6145465337804d+4*t29*t36*t37*t80+3.787265459402013d+5*t29
     ;         *t33*t37*t80-5.049687279202681d+5*t29*t30*t37*t80+2.10403
     <         63663344508d+5*t27*t29*t37*t80-4.208072732668902d+4*t35*t
     =         36*t80+2.104036366334451d+4*t33*t35*t80-2.104036366334451
     >         d+5*t26*t33*t34*t80+8.416145465337803d+5*t26*t30*t34*t80-
     ?         1.0520181831672254d+6*t26*t27*t34*t80+4.208072732668902d+
     @         5*t24*t26*t34*t80-4.2080727326689016d+5*t23*t30*t31*t80+1
     1         .578027274750838d+6*t23*t27*t31*t80-1.893632729701006d+6*
     2         t23*t24*t31*t80+7.364127282170578d+5*t21*t23*t31*t80-7.36
     3         4127282170578d+5*t20*t27*t28*t80+2.6510858215814087d+6*t2
     4         0*t24*t28*t80-3.0929334585116436d+6*t20*t21*t28*t80+1.178
     5         2603651472927d+6*t18*t20*t28*t80-1.1782603651472927d+6*t1
     6         7*t24*t25*t80+4.123911278015524d+6*t17*t21*t25*t80-4.7130
     7         41460589171d+6*t17*t18*t25*t80+1.767390547720939d+6*t15*t
     8         17*t25*t80-1.7673905477209387d+6*t14*t21*t22*t80+6.059624
     9         735043219d+6*t14*t18*t22*t80-6.817077826923622d+6*t14*t15
     :         *t22*t80+2.524843639601341d+6*t12*t14*t22*t80-2.524843639
     ;         601341d+6*t11*t18*t19*t80+8.521347283654526d+6*t11*t15*t1
     <         9*t80-9.468163648505028d+6*t11*t12*t19*t80+3.376148053589
     =         33d+0*t38*t39*t63*t8-6.75229610717866d+0*t36*t38*t63*t8+9
     >         .232684300601568d+2*t35*t39*t62*t8-3.693073720240627d+3*t
     ?         35*t36*t62*t8+2.769805290180471d+3*t33*t35*t62*t8-3.71376
     @         2858948263d+1*t11*t13*t5*t63-3.37614805358933d+0*t39*t40*
     1         t63+6.75229610717866d+0*t35*t36*t37*t63-1.012844416076799
     2         1d+1*t33*t35*t37*t63+1.0128444160767991d+1*t32*t33*t34*t6
     3         3-1.350459221435732d+1*t30*t32*t34*t63+1.350459221435732d
     4         +1*t29*t30*t31*t63-1.6880740267946648d+1*t27*t29*t31*t63+
     5         1.6880740267946648d+1*t26*t27*t28*t63-2.0256888321535982d
     6         +1*t24*t26*t28*t63+2.0256888321535982d+1*t23*t24*t25*t63-
     7         2.3633036375125308d+1*t21*t23*t25*t63+2.3633036375125308d
     8         +1*t20*t21*t22*t63-2.700918442871464d+1*t18*t20*t22*t63+2
     9         .700918442871464d+1*t17*t18*t19*t63-3.0385332482303967d+1
     :         *t15*t17*t19*t63+3.0385332482303967d+1*t14*t15*t16*t63-3.
     ;         3761480535893296d+1*t12*t14*t16*t63+3.3761480535893296d+1
     <         *t11*t12*t13*t63-1.1171548003727898d+5*t13*t5*t57*t62+5.0
     =         77976365330862d+4*t12*t13*t57*t62+5.077976365330863d+4*t1
     >         1*t16*t5*t62-9.232684300601568d+2*t38*t39*t62+9.232684300
     ?         601568d+2*t36*t38*t62+2.769805290180471d+3*t32*t36*t37*t6
     @         2-8.309415870541413d+3*t32*t33*t37*t62+5.539610580360942d
     1         +3*t30*t32*t37*t62+5.539610580360942d+3*t29*t33*t34*t62-1
     2         .4772294880962508d+4*t29*t30*t34*t62+9.232684300601568d+3
     3         *t27*t29*t34*t62+9.232684300601568d+3*t26*t30*t31*t62-2.3
     4         08171075150392d+4*t26*t27*t31*t62+1.3849026450902355d+4*t
     5         24*t26*t31*t62+1.3849026450902355d+4*t23*t27*t28*t62-3.32
     6         3766348216566d+4*t23*t24*t28*t62+1.9388637031263292d+4*t2
     7         1*t23*t28*t62+1.9388637031263292d+4*t20*t24*t25*t62-4.524
     8         0153072947686d+4*t20*t21*t25*t62+2.585151604168439d+4*t18
     9         *t20*t25*t62+2.585151604168439d+4*t17*t21*t22*t62-5.90891
     :         7952385003d+4*t17*t18*t22*t62+3.3237663482165647d+4*t15*t
     ;         17*t22*t62+3.3237663482165647d+4*t14*t18*t19*t62-7.478474
     <         283487271d+4*t14*t15*t19*t62+4.154707935270705d+4*t12*t14
     =         *t19*t62+4.1547079352707056d+4*t11*t15*t16*t62-9.23268430
     >         0601568d+4*t11*t12*t16*t62)-9.305257363491002d-1*t4*t43*(
     ?         -6.01754400771653d+6*t44*t80*t81*t9+6.093571638397036d+4*
     @         t44*t62*t66*t9+3.713762858948263d+1*t44*t57*t63*t9-2.1040
     1         36366334451d+4*t32*t54*t8*t80+1.2624218198006704d+5*t32*t
     2         53*t8*t80-1.8936327297010064d+5*t32*t52*t8*t80+8.41614546
     3         5337804d+4*t32*t51*t8*t80-4.628880005935792d+6*t13*t45*t6
     4         6*t80+1.5275304019588112d+7*t13*t44*t66*t80-3.47166000445
     5         18436d+6*t16*t46*t57*t80+1.1572200014839477d+7*t16*t45*t5
     6         7*t80-1.2729420016323426d+7*t16*t44*t57*t80+2.10403636633
     7         4451d+4*t35*t54*t80-8.416145465337804d+4*t29*t37*t53*t80-
     8         4.208072732668902d+4*t35*t53*t80+3.787265459402013d+5*t29
     9         *t37*t52*t80+2.104036366334451d+4*t35*t52*t80-2.104036366
     :         334451d+5*t26*t34*t52*t80-5.049687279202681d+5*t29*t37*t5
     ;         1*t80+8.416145465337803d+5*t26*t34*t51*t80-4.208072732668
     <         9016d+5*t23*t31*t51*t80+2.1040363663344508d+5*t29*t37*t50
     =         *t80-1.0520181831672254d+6*t26*t34*t50*t80+1.578027274750
     >         838d+6*t23*t31*t50*t80-7.364127282170578d+5*t20*t28*t50*t
     ?         80+4.208072732668902d+5*t26*t34*t49*t80-1.893632729701006
     @         d+6*t23*t31*t49*t80+2.6510858215814087d+6*t20*t28*t49*t80
     1         -1.1782603651472927d+6*t17*t25*t49*t80+7.364127282170578d
     2         +5*t23*t31*t48*t80-3.0929334585116436d+6*t20*t28*t48*t80+
     3         4.123911278015524d+6*t17*t25*t48*t80-1.7673905477209387d+
     4         6*t14*t22*t48*t80+1.1782603651472927d+6*t20*t28*t47*t80-4
     5         .713041460589171d+6*t17*t25*t47*t80+6.059624735043219d+6*
     6         t14*t22*t47*t80-2.524843639601341d+6*t11*t19*t47*t80+1.76
     7         7390547720939d+6*t17*t25*t46*t80-6.817077826923622d+6*t14
     8         *t22*t46*t80+8.521347283654526d+6*t11*t19*t46*t80+2.52484
     9         3639601341d+6*t14*t22*t45*t80-9.468163648505028d+6*t11*t1
     :         9*t45*t80+3.4716600044518436d+6*t11*t19*t44*t80+3.3761480
     ;         5358933d+0*t38*t54*t63*t8-6.75229610717866d+0*t38*t53*t63
     <         *t8+9.232684300601568d+2*t35*t54*t62*t8-3.693073720240627
     =         d+3*t35*t53*t62*t8+2.769805290180471d+3*t35*t52*t62*t8-3.
     >         37614805358933d+0*t40*t54*t63+6.75229610717866d+0*t35*t37
     ?         *t53*t63-1.0128444160767991d+1*t35*t37*t52*t63+1.01284441
     @         60767991d+1*t32*t34*t52*t63-1.350459221435732d+1*t32*t34*
     1         t51*t63+1.350459221435732d+1*t29*t31*t51*t63-1.6880740267
     2         946648d+1*t29*t31*t50*t63+1.6880740267946648d+1*t26*t28*t
     3         50*t63-2.0256888321535982d+1*t26*t28*t49*t63+2.0256888321
     4         535982d+1*t23*t25*t49*t63-2.3633036375125308d+1*t23*t25*t
     5         48*t63+2.3633036375125308d+1*t20*t22*t48*t63-2.7009184428
     6         71464d+1*t20*t22*t47*t63+2.700918442871464d+1*t17*t19*t47
     7         *t63-3.0385332482303967d+1*t17*t19*t46*t63+3.038533248230
     8         3967d+1*t14*t16*t46*t63-3.3761480535893296d+1*t14*t16*t45
     9         *t63+3.3761480535893296d+1*t11*t13*t45*t63-3.713762858948
     :         263d+1*t11*t13*t44*t63+5.077976365330862d+4*t13*t45*t57*t
     ;         62-1.1171548003727898d+5*t13*t44*t57*t62-9.23268430060156
     <         8d+2*t38*t54*t62+9.232684300601568d+2*t38*t53*t62+2.76980
     =         5290180471d+3*t32*t37*t53*t62-8.309415870541413d+3*t32*t3
     >         7*t52*t62+5.539610580360942d+3*t29*t34*t52*t62+5.53961058
     ?         0360942d+3*t32*t37*t51*t62-1.4772294880962508d+4*t29*t34*
     @         t51*t62+9.232684300601568d+3*t26*t31*t51*t62+9.2326843006
     1         01568d+3*t29*t34*t50*t62-2.308171075150392d+4*t26*t31*t50
     2         *t62+1.3849026450902355d+4*t23*t28*t50*t62+1.384902645090
     3         2355d+4*t26*t31*t49*t62-3.323766348216566d+4*t23*t28*t49*
     4         t62+1.9388637031263292d+4*t20*t25*t49*t62+1.9388637031263
     5         292d+4*t23*t28*t48*t62-4.5240153072947686d+4*t20*t25*t48*
     6         t62+2.585151604168439d+4*t17*t22*t48*t62+2.58515160416843
     7         9d+4*t20*t25*t47*t62-5.908917952385003d+4*t17*t22*t47*t62
     8         +3.3237663482165647d+4*t14*t19*t47*t62+3.3237663482165647
     9         d+4*t17*t22*t46*t62-7.478474283487271d+4*t14*t19*t46*t62+
     :         4.1547079352707056d+4*t11*t16*t46*t62+4.154707935270705d+
     ;         4*t14*t19*t45*t62-9.232684300601568d+4*t11*t16*t45*t62+5.
     <         077976365330863d+4*t11*t16*t44*t62)+t74*(3.98359267106208
     =         9d-3*gammaaa*t41*t60*t87+2.2404517531258392d-3*gammaaa*t4
     >         2*t55*t87-1.2407009817988002d+0*t43*t59-1.240700981798800
     ?         2d+0*t3*t58)+2.987694503296569d-2*gammaaa*t41*t60*t86+1.6
     @         803388148443793d-2*gammaaa*t42*t55*t86-1.5033443968152754
     1         d-3*t41*t70*t71*t85-3.4631141060506576d-4*t42*t55*t70*t85
     2         +7.718887347725925d-6*t41*t82*t83*t84+4.855337331063556d-
     3         7*t42*t55*t82*t84-6.666666666666666d-1*t75/t6-2.688925052
     4         9669123d-2*gammaaa*t58*t60*t73-1.5123049333599414d-2*gamm
     5         aaa*t42*t59*t73+6.442904557779751d-4*t58*t70*t71*t72+1.48
     6         4191759735996d-4*t42*t59*t70*t72-3.7221029453964005d+0*t4
     7         3*t62*t69+1.5123049333599414d-2*gammaaa*t42*t61*t69-3.722
     8         1029453964005d+0*t3*t62*t68+2.6889250529669106d-2*gammaaa
     9         *t60*t61*t68)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(-2.8945827553972214d-6*t41*
     1         t70*t83*t88-1.8207514991488338d-7*t42*t55*t70*t88-1.61072
     2         6139444938d-4*gammaaa*t58*t71*t76-3.71047939933999d-5*gam
     3         maaa*t42*t59*t76+(-1.4938472516482837d-3*t1*t41*t60-8.401
     4         694074221898d-4*t1*t42*t55)*t74-8.963083509889707d-3*t41*
     5         t60*t73-5.041016444533138d-3*t42*t55*t73+5.10063277490897
     6         1d-4*gammaaa*t41*t71*t72+1.1749851431243302d-4*gammaaa*t4
     7         2*t55*t72-1.890381166699927d-3*t42*t63*t69-3.361156316208
     8         638d-3*t60*t63*t68+8.963083509889702d-3*t58*t60*t61+5.041
     9         016444533138d-3*t42*t59*t61)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(1.0854685332739583d-6*gamm
     1         aaa*t41*t83*t89+6.827818121808127d-8*gammaaa*t42*t55*t89+
     2         3.020111511459258d-5*t58*t71*t77+6.957148873762482d-6*t42
     3         *t59*t77-1.2080446045837034d-4*t41*t71*t76-2.782859549504
     4         9924d-5*t42*t55*t76)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(-4.070506999777343d-7*t41
     1         *t83*t90-2.560431795678048d-8*t42*t55*t90)*wght+Cmat3(iq,
     2         D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Mmat3(iq,D3_RA_RA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-7.921643129916147d+5*t4*t5*t81*t9+2.6739092584427493d+3
     2         *t5*t66*t67*t9+4.0513776643071964d+1*t35*t39*t67*t8-1.215
     3         4132992921589d+2*t33*t35*t67*t8-2.769805290180471d+3*t32*
     4         t39*t4*t8+5.539610580360942d+3*t32*t36*t4*t8+8.3094158705
     5         41416d+3*t32*t33*t4*t8-1.1079221160721883d+4*t30*t32*t4*t
     6         8+2.2282577153689576d+3*t12*t13*t57*t67-2.228257715368958
     7         d+3*t11*t16*t5*t67-4.0513776643071964d+1*t36*t38*t67+1.21
     8         54132992921589d+2*t32*t36*t37*t67-2.4308265985843178d+2*t
     9         30*t32*t37*t67+2.4308265985843178d+2*t29*t33*t34*t67-4.05
     :         1377664307196d+2*t27*t29*t34*t67+4.0513776643071964d+2*t2
     ;         6*t30*t31*t67-6.077066496460795d+2*t24*t26*t31*t67+6.0770
     <         66496460793d+2*t23*t27*t28*t67-8.507893095045111d+2*t21*t
     =         23*t28*t67+8.507893095045113d+2*t20*t24*t25*t67-1.1343857
     >         460060149d+3*t18*t20*t25*t67+1.1343857460060149d+3*t17*t2
     ?         1*t22*t67-1.4584959591505905d+3*t15*t17*t22*t67+1.4584959
     @         591505908d+3*t14*t18*t19*t67-1.8231199489382383d+3*t12*t1
     1         4*t19*t67+1.8231199489382383d+3*t11*t15*t16*t67+6.7029288
     2         02236738d+5*t13*t4*t5*t66-6.093571638397035d+5*t12*t13*t4
     3         *t66+5.585774001863949d+5*t16*t4*t5*t57-4.570178728797776
     4         3d+5*t15*t16*t4*t57+5.077976365330863d+5*t12*t16*t4*t57-4
     5         .5701787287977763d+5*t11*t19*t4*t5+9.232684300601569d+2*t
     6         35*t39*t4-1.1079221160721883d+4*t29*t36*t37*t4+1.66188317
     7         41082832d+4*t29*t33*t37*t4+2.2158442321443766d+4*t29*t30*
     8         t37*t4-2.7698052901804704d+4*t27*t29*t37*t4+1.84653686012
     9         0314d+3*t35*t36*t4-2.769805290180471d+3*t33*t35*t4-2.7698
     :         05290180471d+4*t26*t33*t34*t4+3.693073720240629d+4*t26*t3
     ;         0*t34*t4+4.616342150300784d+4*t26*t27*t34*t4-5.5396105803
     <         60942d+4*t24*t26*t34*t4-5.539610580360941d+4*t23*t30*t31*
     =         t4+6.924513225451174d+4*t23*t27*t31*t4+8.309415870541416d
     >         +4*t23*t24*t31*t4-9.694318515631648d+4*t21*t23*t31*t4-9.6
     ?         94318515631648d+4*t20*t27*t28*t4+1.1633182218757979d+5*t2
     @         0*t24*t28*t4+1.3572045921884307d+5*t20*t21*t28*t4-1.55109
     1         09625010635d+5*t18*t20*t28*t4-1.5510909625010638d+5*t17*t
     2         24*t25*t4+1.809606122917908d+5*t17*t21*t25*t4+2.068121283
     3         3347515d+5*t17*t18*t25*t4-2.3266364437515952d+5*t15*t17*t
     4         25*t4-2.3266364437515955d+5*t14*t21*t22*t4+2.659013078573
     5         252d+5*t14*t18*t22*t4+2.9913897133949086d+5*t14*t15*t22*t
     6         4-3.3237663482165647d+5*t12*t14*t22*t4-3.323766348216565d
     7         +5*t11*t18*t19*t4+3.7392371417436354d+5*t11*t15*t19*t4+4.
     8         1547079352707056d+5*t11*t12*t19*t4)-9.305257363491002d-1*
     9         t4*t43*(-7.921643129916147d+5*t4*t44*t81*t9+2.67390925844
     :         27493d+3*t44*t66*t67*t9+4.0513776643071964d+1*t35*t54*t67
     ;         *t8-1.2154132992921589d+2*t35*t52*t67*t8-2.76980529018047
     <         1d+3*t32*t4*t54*t8+5.539610580360942d+3*t32*t4*t53*t8+8.3
     =         09415870541416d+3*t32*t4*t52*t8-1.1079221160721883d+4*t32
     >         *t4*t51*t8+2.2282577153689576d+3*t13*t45*t57*t67-4.051377
     ?         6643071964d+1*t38*t53*t67+1.2154132992921589d+2*t32*t37*t
     @         53*t67+2.4308265985843178d+2*t29*t34*t52*t67-2.4308265985
     1         843178d+2*t32*t37*t51*t67+4.0513776643071964d+2*t26*t31*t
     2         51*t67-4.051377664307196d+2*t29*t34*t50*t67+6.07706649646
     3         0793d+2*t23*t28*t50*t67-6.077066496460795d+2*t26*t31*t49*
     4         t67+8.507893095045113d+2*t20*t25*t49*t67-8.50789309504511
     5         1d+2*t23*t28*t48*t67+1.1343857460060149d+3*t17*t22*t48*t6
     6         7-1.1343857460060149d+3*t20*t25*t47*t67+1.458495959150590
     7         8d+3*t14*t19*t47*t67-1.4584959591505905d+3*t17*t22*t46*t6
     8         7+1.8231199489382383d+3*t11*t16*t46*t67-1.823119948938238
     9         3d+3*t14*t19*t45*t67-2.228257715368958d+3*t11*t16*t44*t67
     :         -6.093571638397035d+5*t13*t4*t45*t66+6.702928802236738d+5
     ;         *t13*t4*t44*t66-4.5701787287977763d+5*t16*t4*t46*t57+5.07
     <         7976365330863d+5*t16*t4*t45*t57+5.585774001863949d+5*t16*
     =         t4*t44*t57+9.232684300601569d+2*t35*t4*t54-1.107922116072
     >         1883d+4*t29*t37*t4*t53+1.846536860120314d+3*t35*t4*t53+1.
     ?         6618831741082832d+4*t29*t37*t4*t52-2.769805290180471d+3*t
     @         35*t4*t52-2.769805290180471d+4*t26*t34*t4*t52+2.215844232
     1         1443766d+4*t29*t37*t4*t51+3.693073720240629d+4*t26*t34*t4
     2         *t51-5.539610580360941d+4*t23*t31*t4*t51-2.76980529018047
     3         04d+4*t29*t37*t4*t50+4.616342150300784d+4*t26*t34*t4*t50+
     4         6.924513225451174d+4*t23*t31*t4*t50-9.694318515631648d+4*
     5         t20*t28*t4*t50-5.539610580360942d+4*t26*t34*t4*t49+8.3094
     6         15870541416d+4*t23*t31*t4*t49+1.1633182218757979d+5*t20*t
     7         28*t4*t49-1.5510909625010638d+5*t17*t25*t4*t49-9.69431851
     8         5631648d+4*t23*t31*t4*t48+1.3572045921884307d+5*t20*t28*t
     9         4*t48+1.809606122917908d+5*t17*t25*t4*t48-2.3266364437515
     :         955d+5*t14*t22*t4*t48-1.5510909625010635d+5*t20*t28*t4*t4
     ;         7+2.0681212833347515d+5*t17*t25*t4*t47+2.659013078573252d
     <         +5*t14*t22*t4*t47-3.323766348216565d+5*t11*t19*t4*t47-2.3
     =         266364437515952d+5*t17*t25*t4*t46+2.9913897133949086d+5*t
     >         14*t22*t4*t46+3.7392371417436354d+5*t11*t19*t4*t46-3.3237
     ?         663482165647d+5*t14*t22*t4*t45+4.1547079352707056d+5*t11*
     @         t19*t4*t45-4.5701787287977763d+5*t11*t19*t4*t44)-2.481401
     1         9635976003d+0*t43*t62*t79+1.0082032889066277d-2*gammaaa*t
     2         42*t61*t79-2.4814019635976003d+0*t3*t62*t78+1.79261670197
     3         79404d-2*gammaaa*t60*t61*t78+(-4.135669939329334d-1*t43*t
     4         65-4.135669939329334d-1*t3*t64)*t74-5.041016444533138d-3*
     5         gammaaa*t42*t65*t73-8.963083509889707d-3*gammaaa*t60*t64*
     6         t73+2.1476348525932504d-4*t64*t70*t71*t72+4.9473058657866
     7         53d-5*t42*t65*t70*t72)*wght+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_GAA_TA) = 1.0d+0*(-1.890381166699927d-3*t42*t
     1         63*t79-3.361156316208638d-3*t60*t63*t78-8.05363069722469d
     2         -5*gammaaa*t64*t71*t76-1.855239699669995d-5*gammaaa*t42*t
     3         65*t76+2.520508222266569d-3*t42*t61*t65+4.481541754944851
     4         d-3*t60*t61*t64)*wght+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = 1.0d+0*(3.020111511459258d-5*t64*t
     1         71*t77+6.957148873762482d-6*t42*t65*t77)*wght+Mmat3(iq,D3
     2         _GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_TA_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-1.3728d+4*t5*t81*t9-4.8d+1*t32*t39*t8-2.88d+2*t32*t36*t
     2         8-4.32d+2*t32*t33*t8-1.92d+2*t30*t32*t8-3.4848d+4*t13*t5*
     3         t66-1.056d+4*t12*t13*t66-2.904d+4*t16*t5*t57-7.92d+3*t15*
     4         t16*t57-2.64d+4*t12*t16*t57-7.92d+3*t11*t19*t5-4.8d+1*t35
     5         *t39-1.92d+2*t29*t36*t37-8.64d+2*t29*t33*t37-1.152d+3*t29
     6         *t30*t37-4.8d+2*t27*t29*t37-9.6d+1*t35*t36-4.8d+1*t33*t35
     7         -4.8d+2*t26*t33*t34-1.92d+3*t26*t30*t34-2.4d+3*t26*t27*t3
     8         4-9.6d+2*t24*t26*t34-9.6d+2*t23*t30*t31-3.6d+3*t23*t27*t3
     9         1-4.32d+3*t23*t24*t31-1.68d+3*t21*t23*t31-1.68d+3*t20*t27
     :         *t28-6.048d+3*t20*t24*t28-7.056d+3*t20*t21*t28-2.688d+3*t
     ;         18*t20*t28-2.688d+3*t17*t24*t25-9.408d+3*t17*t21*t25-1.07
     <         52d+4*t17*t18*t25-4.032d+3*t15*t17*t25-4.032d+3*t14*t21*t
     =         22-1.3824d+4*t14*t18*t22-1.5552d+4*t14*t15*t22-5.76d+3*t1
     >         2*t14*t22-5.76d+3*t11*t18*t19-1.944d+4*t11*t15*t19-2.16d+
     ?         4*t11*t12*t19)-9.305257363491002d-1*t4*t43*(-1.3728d+4*t4
     @         4*t81*t9-4.8d+1*t32*t54*t8-2.88d+2*t32*t53*t8-4.32d+2*t32
     1         *t52*t8-1.92d+2*t32*t51*t8-1.056d+4*t13*t45*t66-3.4848d+4
     2         *t13*t44*t66-7.92d+3*t16*t46*t57-2.64d+4*t16*t45*t57-2.90
     3         4d+4*t16*t44*t57-4.8d+1*t35*t54-1.92d+2*t29*t37*t53-9.6d+
     4         1*t35*t53-8.64d+2*t29*t37*t52-4.8d+1*t35*t52-4.8d+2*t26*t
     5         34*t52-1.152d+3*t29*t37*t51-1.92d+3*t26*t34*t51-9.6d+2*t2
     6         3*t31*t51-4.8d+2*t29*t37*t50-2.4d+3*t26*t34*t50-3.6d+3*t2
     7         3*t31*t50-1.68d+3*t20*t28*t50-9.6d+2*t26*t34*t49-4.32d+3*
     8         t23*t31*t49-6.048d+3*t20*t28*t49-2.688d+3*t17*t25*t49-1.6
     9         8d+3*t23*t31*t48-7.056d+3*t20*t28*t48-9.408d+3*t17*t25*t4
     :         8-4.032d+3*t14*t22*t48-2.688d+3*t20*t28*t47-1.0752d+4*t17
     ;         *t25*t47-1.3824d+4*t14*t22*t47-5.76d+3*t11*t19*t47-4.032d
     <         +3*t17*t25*t46-1.5552d+4*t14*t22*t46-1.944d+4*t11*t19*t46
     =         -5.76d+3*t14*t22*t45-2.16d+4*t11*t19*t45-7.92d+3*t11*t19*
     >         t44))*wght+Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(1)
            t6 = param(12)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(11)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(10)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(9)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(8)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(7)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(6)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(5)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(4)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(3)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(2)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t5+t37*t38*t39+t34*t35*t36+t31*t
     1         32*t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t1
     2         6*t17*t18+t13*t14*t15
            t43 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t44 = 5.52d-1*(1.0d+0-t43)+1.0d+0
            t45 = param(13)
            t46 = param(24)
            t47 = param(23)
            t48 = param(22)
            t49 = param(21)
            t50 = param(20)
            t51 = param(19)
            t52 = param(18)
            t53 = param(17)
            t54 = param(16)
            t55 = param(15)
            t56 = param(14)
            t57 = t41*t56*t9+t38*t39*t55+t35*t36*t54+t32*t33*t53+t29*t30
     1         *t52+t26*t27*t51+t23*t24*t50+t20*t21*t49+t17*t18*t48+t14*
     2         t15*t47+t10*t12*t46+t45
            t58 = 1/rhob**2.6666666666666666d+0
            t59 = 4.492667444378077d-3*gammabb*t58+1.0d+0
            t60 = 8.04d-1*(1.0d+0-1.0d+0/t59)+1.0d+0
            t61 = rhob**1.3333333333333333d+0
            t62 = rhob**1.6666666666666669d+0
            t63 = 9.115599744691192d+0*t62
            t64 = t63-2.0d+0*taub
            t65 = t64**11
            t66 = 2.0d+0*taub+t63
            t67 = 1/t66**11
            t68 = t64**10
            t69 = 1/t66**10
            t70 = t64**9
            t71 = 1/t66**9
            t72 = t64**8
            t73 = 1/t66**8
            t74 = t64**7
            t75 = 1/t66**7
            t76 = t64**6
            t77 = 1/t66**6
            t78 = t64**5
            t79 = 1/t66**5
            t80 = t64**4
            t81 = 1/t66**4
            t82 = t64**3
            t83 = 1/t66**3
            t84 = t64**2
            t85 = 1/t66**2
            t86 = 1/t66
            t87 = t40*t64*t86+t37*t84*t85+t34*t82*t83+t31*t80*t81+t28*t7
     1         8*t79+t25*t76*t77+t22*t74*t75+t19*t72*t73+t16*t70*t71+t13
     2         *t68*t69+t6*t65*t67+t5
            t88 = exp(-3.6802889260199856d-3*gammabb*t58)
            t89 = 5.52d-1*(1.0d+0-t88)+1.0d+0
            t90 = t56*t64*t86+t55*t84*t85+t54*t82*t83+t53*t80*t81+t52*t7
     1         8*t79+t51*t76*t77+t50*t74*t75+t49*t72*t73+t48*t70*t71+t47
     2         *t68*t69+t46*t65*t67+t45
            t91 = rhoa**6.666666666666666d-1
            t92 = 1/t11**12
            t93 = -1.6711932865267184d+2*t10*t6*t91*t92-1.51926662411519
     1         86d+1*t39*t40*t9*t91+3.038533248230397d+1*t37*t39*t9*t91+
     2         1.6711932865267184d+2*t12*t14*t6*t91+1.5192666241151986d+
     3         1*t40*t41*t91-3.038533248230397d+1*t36*t37*t38*t91+4.5577
     4         998723455965d+1*t34*t36*t38*t91-4.5577998723455965d+1*t33
     5         *t34*t35*t91+6.077066496460795d+1*t31*t33*t35*t91-6.07706
     6         6496460795d+1*t30*t31*t32*t91+7.596333120575993d+1*t28*t3
     7         0*t32*t91-7.596333120575993d+1*t27*t28*t29*t91+9.11559974
     8         4691193d+1*t25*t27*t29*t91-9.115599744691193d+1*t24*t25*t
     9         26*t91+1.0634866368806391d+2*t22*t24*t26*t91-1.0634866368
     :         806391d+2*t21*t22*t23*t91+1.2154132992921589d+2*t19*t21*t
     ;         23*t91-1.2154132992921589d+2*t18*t19*t20*t91+1.3673399617
     <         036788d+2*t16*t18*t20*t91-1.3673399617036788d+2*t15*t16*t
     =         17*t91+1.5192666241151986d+2*t13*t15*t17*t91-1.5192666241
     >         151986d+2*t12*t13*t14*t91
            t94 = -1.6711932865267184d+2*t10*t46*t91*t92-1.5192666241151
     1         986d+1*t39*t56*t9*t91+3.038533248230397d+1*t39*t55*t9*t91
     2         +1.5192666241151986d+1*t41*t56*t91-3.038533248230397d+1*t
     3         36*t38*t55*t91+4.5577998723455965d+1*t36*t38*t54*t91-4.55
     4         77998723455965d+1*t33*t35*t54*t91+6.077066496460795d+1*t3
     5         3*t35*t53*t91-6.077066496460795d+1*t30*t32*t53*t91+7.5963
     6         33120575993d+1*t30*t32*t52*t91-7.596333120575993d+1*t27*t
     7         29*t52*t91+9.115599744691193d+1*t27*t29*t51*t91-9.1155997
     8         44691193d+1*t24*t26*t51*t91+1.0634866368806391d+2*t24*t26
     9         *t50*t91-1.0634866368806391d+2*t21*t23*t50*t91+1.21541329
     :         92921589d+2*t21*t23*t49*t91-1.2154132992921589d+2*t18*t20
     ;         *t49*t91+1.3673399617036788d+2*t18*t20*t48*t91-1.36733996
     <         17036788d+2*t15*t17*t48*t91+1.5192666241151986d+2*t15*t17
     =         *t47*t91-1.5192666241151986d+2*t12*t14*t47*t91+1.67119328
     >         65267184d+2*t12*t14*t46*t91
            t95 = 1/t2**2
            t96 = 1/rhoa**2.3333333333333334d+0
            t97 = rhoa**3.333333333333333d-1
            t98 = rhob**6.666666666666666d-1
            t99 = 1/t66**12
            t100 = -1.6711932865267184d+2*t6*t65*t98*t99+1.5192666241151
     1         986d+1*t40*t86*t98-1.5192666241151986d+1*t40*t64*t85*t98+
     2         3.038533248230397d+1*t37*t64*t85*t98-3.038533248230397d+1
     3         *t37*t83*t84*t98+4.5577998723455965d+1*t34*t83*t84*t98-4.
     4         5577998723455965d+1*t34*t81*t82*t98+6.077066496460795d+1*
     5         t31*t81*t82*t98-6.077066496460795d+1*t31*t79*t80*t98+7.59
     6         6333120575993d+1*t28*t79*t80*t98-7.596333120575993d+1*t28
     7         *t77*t78*t98+9.115599744691193d+1*t25*t77*t78*t98-9.11559
     8         9744691193d+1*t25*t75*t76*t98+1.0634866368806391d+2*t22*t
     9         75*t76*t98-1.0634866368806391d+2*t22*t73*t74*t98+1.215413
     :         2992921589d+2*t19*t73*t74*t98-1.2154132992921589d+2*t19*t
     ;         71*t72*t98+1.3673399617036788d+2*t16*t71*t72*t98-1.367339
     <         9617036788d+2*t16*t69*t70*t98+1.5192666241151986d+2*t13*t
     =         69*t70*t98+1.6711932865267184d+2*t6*t67*t68*t98-1.5192666
     >         241151986d+2*t13*t67*t68*t98
            t101 = -1.6711932865267184d+2*t46*t65*t98*t99+1.519266624115
     1         1986d+1*t56*t86*t98-1.5192666241151986d+1*t56*t64*t85*t98
     2         +3.038533248230397d+1*t55*t64*t85*t98-3.038533248230397d+
     3         1*t55*t83*t84*t98+4.5577998723455965d+1*t54*t83*t84*t98-4
     4         .5577998723455965d+1*t54*t81*t82*t98+6.077066496460795d+1
     5         *t53*t81*t82*t98-6.077066496460795d+1*t53*t79*t80*t98+7.5
     6         96333120575993d+1*t52*t79*t80*t98-7.596333120575993d+1*t5
     7         2*t77*t78*t98+9.115599744691193d+1*t51*t77*t78*t98-9.1155
     8         99744691193d+1*t51*t75*t76*t98+1.0634866368806391d+2*t50*
     9         t75*t76*t98-1.0634866368806391d+2*t50*t73*t74*t98+1.21541
     :         32992921589d+2*t49*t73*t74*t98-1.2154132992921589d+2*t49*
     ;         t71*t72*t98+1.3673399617036788d+2*t48*t71*t72*t98-1.36733
     <         99617036788d+2*t48*t69*t70*t98+1.5192666241151986d+2*t47*
     =         t69*t70*t98-1.5192666241151986d+2*t47*t67*t68*t98+1.67119
     >         32865267184d+2*t46*t67*t68*t98
            t102 = 1/t59**2
            t103 = 1/rhob**2.3333333333333334d+0
            t104 = rhob**3.333333333333333d-1
            t105 = 1/t4
            t106 = 1/t61
            t107 = -2.2d+1*t10*t6*t92-2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t
     1         9-2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0
     2         d+0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0
     3         d+0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2
     4         d+1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4
     5         d+1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8
     6         d+1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0
     7         d+1*t12*t13*t14
            t108 = -2.2d+1*t10*t46*t92-2.0d+0*t39*t56*t9-4.0d+0*t39*t55*
     1         t9-2.0d+0*t41*t56-4.0d+0*t36*t38*t55-6.0d+0*t36*t38*t54-6
     2         .0d+0*t33*t35*t54-8.0d+0*t33*t35*t53-8.0d+0*t30*t32*t53-1
     3         .0d+1*t30*t32*t52-1.0d+1*t27*t29*t52-1.2d+1*t27*t29*t51-1
     4         .2d+1*t24*t26*t51-1.4d+1*t24*t26*t50-1.4d+1*t21*t23*t50-1
     5         .6d+1*t21*t23*t49-1.6d+1*t18*t20*t49-1.8d+1*t18*t20*t48-1
     6         .8d+1*t15*t17*t48-2.0d+1*t15*t17*t47-2.0d+1*t12*t14*t47-2
     7         .2d+1*t12*t14*t46
            t109 = -2.2d+1*t6*t65*t99-2.0d+0*t40*t86-2.0d+0*t40*t64*t85-
     1         4.0d+0*t37*t64*t85-4.0d+0*t37*t83*t84-6.0d+0*t34*t83*t84-
     2         6.0d+0*t34*t81*t82-8.0d+0*t31*t81*t82-8.0d+0*t31*t79*t80-
     3         1.0d+1*t28*t79*t80-1.0d+1*t28*t77*t78-1.2d+1*t25*t77*t78-
     4         1.2d+1*t25*t75*t76-1.4d+1*t22*t75*t76-1.4d+1*t22*t73*t74-
     5         1.6d+1*t19*t73*t74-1.6d+1*t19*t71*t72-1.8d+1*t16*t71*t72-
     6         1.8d+1*t16*t69*t70-2.0d+1*t13*t69*t70-2.2d+1*t6*t67*t68-2
     7         .0d+1*t13*t67*t68
            t110 = -2.2d+1*t46*t65*t99-2.0d+0*t56*t86-2.0d+0*t56*t64*t85
     1         -4.0d+0*t55*t64*t85-4.0d+0*t55*t83*t84-6.0d+0*t54*t83*t84
     2         -6.0d+0*t54*t81*t82-8.0d+0*t53*t81*t82-8.0d+0*t53*t79*t80
     3         -1.0d+1*t52*t79*t80-1.0d+1*t52*t77*t78-1.2d+1*t51*t77*t78
     4         -1.2d+1*t51*t75*t76-1.4d+1*t50*t75*t76-1.4d+1*t50*t73*t74
     5         -1.6d+1*t49*t73*t74-1.6d+1*t49*t71*t72-1.8d+1*t48*t71*t72
     6         -1.8d+1*t48*t69*t70-2.0d+1*t47*t69*t70-2.0d+1*t47*t67*t68
     7         -2.2d+1*t46*t67*t68
            t111 = 1/t11**13
            t112 = 1/t97
            t113 = -5.585774001863949d+4*t14*t4*t6*t92-1.114128857684478
     1         9d+2*t10*t112*t6*t92+2.5389881826654315d+4*t13*t14*t4*t92
     2         +4.6163421503007845d+2*t36*t4*t40*t9-1.0128444160767991d+
     3         1*t112*t39*t40*t9-1.846536860120314d+3*t36*t37*t4*t9+1.38
     4         49026450902355d+3*t34*t36*t4*t9+2.0256888321535982d+1*t11
     5         2*t37*t39*t9+2.5389881826654315d+4*t12*t17*t4*t6+3.046785
     6         819198518d+4*t10*t111*t4*t6+1.1141288576844789d+2*t112*t1
     7         2*t14*t6+1.0128444160767991d+1*t112*t40*t41-4.61634215030
     8         07845d+2*t39*t4*t40+4.6163421503007845d+2*t37*t39*t4+1.38
     9         49026450902355d+3*t33*t37*t38*t4-4.1547079352707067d+3*t3
     :         3*t34*t38*t4+2.769805290180471d+3*t31*t33*t38*t4+2.769805
     ;         290180471d+3*t30*t34*t35*t4-7.386147440481255d+3*t30*t31*
     <         t35*t4+4.616342150300784d+3*t28*t30*t35*t4+4.616342150300
     =         784d+3*t27*t31*t32*t4-1.154085537575196d+4*t27*t28*t32*t4
     >         +6.924513225451178d+3*t25*t27*t32*t4+6.924513225451178d+3
     ?         *t24*t28*t29*t4-1.661883174108283d+4*t24*t25*t29*t4+9.694
     @         318515631648d+3*t22*t24*t29*t4+9.694318515631648d+3*t21*t
     1         25*t26*t4-2.2620076536473846d+4*t21*t22*t26*t4+1.29257580
     2         20842196d+4*t19*t21*t26*t4+1.2925758020842196d+4*t18*t22*
     3         t23*t4-2.954458976192502d+4*t18*t19*t23*t4+1.661883174108
     4         2823d+4*t16*t18*t23*t4+1.6618831741082823d+4*t15*t19*t20*
     5         t4-3.7392371417436354d+4*t15*t16*t20*t4+2.077353967635352
     6         8d+4*t13*t15*t20*t4+2.0773539676353528d+4*t12*t16*t17*t4-
     7         4.616342150300784d+4*t12*t13*t17*t4-2.0256888321535982d+1
     8         *t112*t36*t37*t38+3.038533248230397d+1*t112*t34*t36*t38-3
     9         .038533248230397d+1*t112*t33*t34*t35+4.0513776643071964d+
     :         1*t112*t31*t33*t35-4.0513776643071964d+1*t112*t30*t31*t32
     ;         +5.064222080383994d+1*t112*t28*t30*t32-5.064222080383994d
     <         +1*t112*t27*t28*t29+6.077066496460795d+1*t112*t25*t27*t29
     =         -6.077066496460795d+1*t112*t24*t25*t26+7.089910912537593d
     >         +1*t112*t22*t24*t26-7.089910912537593d+1*t112*t21*t22*t23
     ?         +8.102755328614393d+1*t112*t19*t21*t23-8.102755328614393d
     @         +1*t112*t18*t19*t20+9.115599744691191d+1*t112*t16*t18*t20
     1         -9.115599744691191d+1*t112*t15*t16*t17+1.012844416076799d
     2         +2*t112*t13*t15*t17-1.012844416076799d+2*t112*t12*t13*t14
            t114 = 2.5389881826654315d+4*t14*t4*t47*t92-5.58577400186394
     1         9d+4*t14*t4*t46*t92-1.1141288576844789d+2*t10*t112*t46*t9
     2         2+4.6163421503007845d+2*t36*t4*t56*t9-1.0128444160767991d
     3         +1*t112*t39*t56*t9-1.846536860120314d+3*t36*t4*t55*t9+2.0
     4         256888321535982d+1*t112*t39*t55*t9+1.3849026450902355d+3*
     5         t36*t4*t54*t9+1.0128444160767991d+1*t112*t41*t56-4.616342
     6         1503007845d+2*t39*t4*t56+4.6163421503007845d+2*t39*t4*t55
     7         +1.3849026450902355d+3*t33*t38*t4*t55-2.0256888321535982d
     8         +1*t112*t36*t38*t55-4.1547079352707067d+3*t33*t38*t4*t54+
     9         2.769805290180471d+3*t30*t35*t4*t54+3.038533248230397d+1*
     :         t112*t36*t38*t54-3.038533248230397d+1*t112*t33*t35*t54+2.
     ;         769805290180471d+3*t33*t38*t4*t53-7.386147440481255d+3*t3
     <         0*t35*t4*t53+4.616342150300784d+3*t27*t32*t4*t53+4.051377
     =         6643071964d+1*t112*t33*t35*t53-4.0513776643071964d+1*t112
     >         *t30*t32*t53+4.616342150300784d+3*t30*t35*t4*t52-1.154085
     ?         537575196d+4*t27*t32*t4*t52+6.924513225451178d+3*t24*t29*
     @         t4*t52+5.064222080383994d+1*t112*t30*t32*t52-5.0642220803
     1         83994d+1*t112*t27*t29*t52+6.924513225451178d+3*t27*t32*t4
     2         *t51-1.661883174108283d+4*t24*t29*t4*t51+9.69431851563164
     3         8d+3*t21*t26*t4*t51+6.077066496460795d+1*t112*t27*t29*t51
     4         -6.077066496460795d+1*t112*t24*t26*t51+9.694318515631648d
     5         +3*t24*t29*t4*t50-2.2620076536473846d+4*t21*t26*t4*t50+1.
     6         2925758020842196d+4*t18*t23*t4*t50+7.089910912537593d+1*t
     7         112*t24*t26*t50-7.089910912537593d+1*t112*t21*t23*t50+1.2
     8         925758020842196d+4*t21*t26*t4*t49-2.954458976192502d+4*t1
     9         8*t23*t4*t49+1.6618831741082823d+4*t15*t20*t4*t49+8.10275
     :         5328614393d+1*t112*t21*t23*t49-8.102755328614393d+1*t112*
     ;         t18*t20*t49+1.6618831741082823d+4*t18*t23*t4*t48-3.739237
     <         1417436354d+4*t15*t20*t4*t48+2.0773539676353528d+4*t12*t1
     =         7*t4*t48+9.115599744691191d+1*t112*t18*t20*t48-9.11559974
     >         4691191d+1*t112*t15*t17*t48+2.0773539676353528d+4*t15*t20
     ?         *t4*t47-4.616342150300784d+4*t12*t17*t4*t47+1.01284441607
     @         6799d+2*t112*t15*t17*t47-1.012844416076799d+2*t112*t12*t1
     1         4*t47+2.5389881826654315d+4*t12*t17*t4*t46+3.046785819198
     2         518d+4*t10*t111*t4*t46+1.1141288576844789d+2*t112*t12*t14
     3         *t46
            t115 = gammaaa**2
            t116 = 1/t2**3
            t117 = 1/rhoa**6
            t118 = 1/rhoa**3.3333333333333337d+0
            t119 = 1/t91
            t120 = -4.135669939329334d-1*t44*t57-4.135669939329334d-1*t3
     1         *t42
            t121 = 1/t66**13
            t122 = 1/t104
            t123 = -5.585774001863949d+4*t6*t61*t68*t99+2.53898818266543
     1         15d+4*t13*t61*t68*t99-1.1141288576844789d+2*t122*t6*t65*t
     2         99+1.0128444160767991d+1*t122*t40*t86-1.0128444160767991d
     3         +1*t122*t40*t64*t85+2.0256888321535982d+1*t122*t37*t64*t8
     4         5-4.6163421503007845d+2*t40*t61*t85+4.6163421503007845d+2
     5         *t37*t61*t85-2.0256888321535982d+1*t122*t37*t83*t84+3.038
     6         533248230397d+1*t122*t34*t83*t84+1.3849026450902355d+3*t3
     7         7*t61*t81*t84-4.1547079352707067d+3*t34*t61*t81*t84+2.769
     8         805290180471d+3*t31*t61*t81*t84+4.6163421503007845d+2*t40
     9         *t61*t64*t83-1.846536860120314d+3*t37*t61*t64*t83+1.38490
     :         26450902355d+3*t34*t61*t64*t83-3.038533248230397d+1*t122*
     ;         t34*t81*t82+4.0513776643071964d+1*t122*t31*t81*t82+2.7698
     <         05290180471d+3*t34*t61*t79*t82-7.386147440481255d+3*t31*t
     =         61*t79*t82+4.616342150300784d+3*t28*t61*t79*t82-4.0513776
     >         643071964d+1*t122*t31*t79*t80+5.064222080383994d+1*t122*t
     ?         28*t79*t80+4.616342150300784d+3*t31*t61*t77*t80-1.1540855
     @         37575196d+4*t28*t61*t77*t80+6.924513225451178d+3*t25*t61*
     1         t77*t80-5.064222080383994d+1*t122*t28*t77*t78+6.077066496
     2         460795d+1*t122*t25*t77*t78+6.924513225451178d+3*t28*t61*t
     3         75*t78-1.661883174108283d+4*t25*t61*t75*t78+9.69431851563
     4         1648d+3*t22*t61*t75*t78-6.077066496460795d+1*t122*t25*t75
     5         *t76+7.089910912537593d+1*t122*t22*t75*t76+9.694318515631
     6         648d+3*t25*t61*t73*t76-2.2620076536473846d+4*t22*t61*t73*
     7         t76+1.2925758020842196d+4*t19*t61*t73*t76-7.0899109125375
     8         93d+1*t122*t22*t73*t74+8.102755328614393d+1*t122*t19*t73*
     9         t74+1.2925758020842196d+4*t22*t61*t71*t74-2.9544589761925
     :         02d+4*t19*t61*t71*t74+1.6618831741082823d+4*t16*t61*t71*t
     ;         74-8.102755328614393d+1*t122*t19*t71*t72+9.11559974469119
     <         1d+1*t122*t16*t71*t72+1.6618831741082823d+4*t19*t61*t69*t
     =         72-3.7392371417436354d+4*t16*t61*t69*t72+2.07735396763535
     >         28d+4*t13*t61*t69*t72-9.115599744691191d+1*t122*t16*t69*t
     ?         70+1.012844416076799d+2*t122*t13*t69*t70+2.53898818266543
     @         15d+4*t6*t61*t67*t70+2.0773539676353528d+4*t16*t61*t67*t7
     1         0-4.616342150300784d+4*t13*t61*t67*t70+1.1141288576844789
     2         d+2*t122*t6*t67*t68-1.012844416076799d+2*t122*t13*t67*t68
     3         +3.046785819198518d+4*t121*t6*t61*t65
            t124 = 2.5389881826654315d+4*t47*t61*t68*t99-5.5857740018639
     1         49d+4*t46*t61*t68*t99-1.1141288576844789d+2*t122*t46*t65*
     2         t99+1.0128444160767991d+1*t122*t56*t86-1.0128444160767991
     3         d+1*t122*t56*t64*t85+2.0256888321535982d+1*t122*t55*t64*t
     4         85-4.6163421503007845d+2*t56*t61*t85+4.6163421503007845d+
     5         2*t55*t61*t85-2.0256888321535982d+1*t122*t55*t83*t84+3.03
     6         8533248230397d+1*t122*t54*t83*t84+1.3849026450902355d+3*t
     7         55*t61*t81*t84-4.1547079352707067d+3*t54*t61*t81*t84+2.76
     8         9805290180471d+3*t53*t61*t81*t84+4.6163421503007845d+2*t5
     9         6*t61*t64*t83-1.846536860120314d+3*t55*t61*t64*t83+1.3849
     :         026450902355d+3*t54*t61*t64*t83-3.038533248230397d+1*t122
     ;         *t54*t81*t82+4.0513776643071964d+1*t122*t53*t81*t82+2.769
     <         805290180471d+3*t54*t61*t79*t82-7.386147440481255d+3*t53*
     =         t61*t79*t82+4.616342150300784d+3*t52*t61*t79*t82-4.051377
     >         6643071964d+1*t122*t53*t79*t80+5.064222080383994d+1*t122*
     ?         t52*t79*t80+4.616342150300784d+3*t53*t61*t77*t80-1.154085
     @         537575196d+4*t52*t61*t77*t80+6.924513225451178d+3*t51*t61
     1         *t77*t80-5.064222080383994d+1*t122*t52*t77*t78+6.07706649
     2         6460795d+1*t122*t51*t77*t78+6.924513225451178d+3*t52*t61*
     3         t75*t78-1.661883174108283d+4*t51*t61*t75*t78+9.6943185156
     4         31648d+3*t50*t61*t75*t78-6.077066496460795d+1*t122*t51*t7
     5         5*t76+7.089910912537593d+1*t122*t50*t75*t76+9.69431851563
     6         1648d+3*t51*t61*t73*t76-2.2620076536473846d+4*t50*t61*t73
     7         *t76+1.2925758020842196d+4*t49*t61*t73*t76-7.089910912537
     8         593d+1*t122*t50*t73*t74+8.102755328614393d+1*t122*t49*t73
     9         *t74+1.2925758020842196d+4*t50*t61*t71*t74-2.954458976192
     :         502d+4*t49*t61*t71*t74+1.6618831741082823d+4*t48*t61*t71*
     ;         t74-8.102755328614393d+1*t122*t49*t71*t72+9.1155997446911
     <         91d+1*t122*t48*t71*t72+1.6618831741082823d+4*t49*t61*t69*
     =         t72-3.7392371417436354d+4*t48*t61*t69*t72+2.0773539676353
     >         528d+4*t47*t61*t69*t72-9.115599744691191d+1*t122*t48*t69*
     ?         t70+1.012844416076799d+2*t122*t47*t69*t70+2.0773539676353
     @         528d+4*t48*t61*t67*t70-4.616342150300784d+4*t47*t61*t67*t
     1         70+2.5389881826654315d+4*t46*t61*t67*t70-1.01284441607679
     2         9d+2*t122*t47*t67*t68+1.1141288576844789d+2*t122*t46*t67*
     3         t68+3.046785819198518d+4*t121*t46*t61*t65
            t125 = gammabb**2
            t126 = 1/t59**3
            t127 = 1/rhob**6
            t128 = 1/rhob**3.3333333333333337d+0
            t129 = 1/t98
            t130 = -4.135669939329334d-1*t89*t90-4.135669939329334d-1*t6
     1         0*t87
            t131 = 1/rhoa**5
            t132 = 1/rhob**5
            t133 = 1/rhoa**4
            t134 = 1/rhob**4
            t135 = 3.342386573053437d+3*t13*t14*t91*t92+6.07706649646079
     1         5d+1*t36*t40*t9*t91-1.8231199489382385d+2*t34*t36*t9*t91-
     2         3.342386573053437d+3*t12*t17*t6*t91+4.0108638876641245d+3
     3         *t10*t111*t6*t91-6.077066496460795d+1*t37*t39*t91+1.82311
     4         99489382385d+2*t33*t37*t38*t91-3.646239897876477d+2*t31*t
     5         33*t38*t91+3.646239897876477d+2*t30*t34*t35*t91-6.0770664
     6         96460795d+2*t28*t30*t35*t91+6.077066496460795d+2*t27*t31*
     7         t32*t91-9.115599744691192d+2*t25*t27*t32*t91+9.1155997446
     8         91192d+2*t24*t28*t29*t91-1.276183964256767d+3*t22*t24*t29
     9         *t91+1.276183964256767d+3*t21*t25*t26*t91-1.7015786190090
     :         226d+3*t19*t21*t26*t91+1.7015786190090226d+3*t18*t22*t23*
     ;         t91-2.187743938725886d+3*t16*t18*t23*t91+2.18774393872588
     <         6d+3*t15*t19*t20*t91-2.734679923407357d+3*t13*t15*t20*t91
     =         +2.734679923407357d+3*t12*t16*t17*t91
            t136 = 3.342386573053437d+3*t14*t47*t91*t92+6.07706649646079
     1         5d+1*t36*t56*t9*t91-1.8231199489382385d+2*t36*t54*t9*t91-
     2         6.077066496460795d+1*t39*t55*t91+1.8231199489382385d+2*t3
     3         3*t38*t55*t91+3.646239897876477d+2*t30*t35*t54*t91-3.6462
     4         39897876477d+2*t33*t38*t53*t91+6.077066496460795d+2*t27*t
     5         32*t53*t91-6.077066496460795d+2*t30*t35*t52*t91+9.1155997
     6         44691192d+2*t24*t29*t52*t91-9.115599744691192d+2*t27*t32*
     7         t51*t91+1.276183964256767d+3*t21*t26*t51*t91-1.2761839642
     8         56767d+3*t24*t29*t50*t91+1.7015786190090226d+3*t18*t23*t5
     9         0*t91-1.7015786190090226d+3*t21*t26*t49*t91+2.18774393872
     :         5886d+3*t15*t20*t49*t91-2.187743938725886d+3*t18*t23*t48*
     ;         t91+2.734679923407357d+3*t12*t17*t48*t91-2.73467992340735
     <         7d+3*t15*t20*t47*t91-3.342386573053437d+3*t12*t17*t46*t91
     =         +4.0108638876641245d+3*t10*t111*t46*t91
            t137 = 3.342386573053437d+3*t13*t68*t98*t99-6.07706649646079
     1         5d+1*t37*t85*t98+1.8231199489382385d+2*t37*t81*t84*t98-3.
     2         646239897876477d+2*t31*t81*t84*t98+6.077066496460795d+1*t
     3         40*t64*t83*t98-1.8231199489382385d+2*t34*t64*t83*t98+3.64
     4         6239897876477d+2*t34*t79*t82*t98-6.077066496460795d+2*t28
     5         *t79*t82*t98+6.077066496460795d+2*t31*t77*t80*t98-9.11559
     6         9744691192d+2*t25*t77*t80*t98+9.115599744691192d+2*t28*t7
     7         5*t78*t98-1.276183964256767d+3*t22*t75*t78*t98+1.27618396
     8         4256767d+3*t25*t73*t76*t98-1.7015786190090226d+3*t19*t73*
     9         t76*t98+1.7015786190090226d+3*t22*t71*t74*t98-2.187743938
     :         725886d+3*t16*t71*t74*t98+2.187743938725886d+3*t19*t69*t7
     ;         2*t98-2.734679923407357d+3*t13*t69*t72*t98-3.342386573053
     <         437d+3*t6*t67*t70*t98+2.734679923407357d+3*t16*t67*t70*t9
     =         8+4.0108638876641245d+3*t121*t6*t65*t98
            t138 = 3.342386573053437d+3*t47*t68*t98*t99-6.07706649646079
     1         5d+1*t55*t85*t98+1.8231199489382385d+2*t55*t81*t84*t98-3.
     2         646239897876477d+2*t53*t81*t84*t98+6.077066496460795d+1*t
     3         56*t64*t83*t98-1.8231199489382385d+2*t54*t64*t83*t98+3.64
     4         6239897876477d+2*t54*t79*t82*t98-6.077066496460795d+2*t52
     5         *t79*t82*t98+6.077066496460795d+2*t53*t77*t80*t98-9.11559
     6         9744691192d+2*t51*t77*t80*t98+9.115599744691192d+2*t52*t7
     7         5*t78*t98-1.276183964256767d+3*t50*t75*t78*t98+1.27618396
     8         4256767d+3*t51*t73*t76*t98-1.7015786190090226d+3*t49*t73*
     9         t76*t98+1.7015786190090226d+3*t50*t71*t74*t98-2.187743938
     :         725886d+3*t48*t71*t74*t98+2.187743938725886d+3*t49*t69*t7
     ;         2*t98-2.734679923407357d+3*t47*t69*t72*t98+2.734679923407
     <         357d+3*t48*t67*t70*t98-3.342386573053437d+3*t46*t67*t70*t
     =         98+4.0108638876641245d+3*t121*t46*t65*t98
            t139 = 9.68d+2*t14*t6*t92+4.4d+2*t13*t14*t92+8.0d+0*t36*t40*
     1         t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9+4.4d+2*t12*t17*t6+
     2         5.28d+2*t10*t111*t6+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*
     3         t33*t37*t38+7.2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*
     4         t30*t34*t35+1.28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1
     5         *t27*t31*t32+2.0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2
     6         *t24*t28*t29+2.88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68
     7         d+2*t21*t25*t26+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2
     8         .24d+2*t18*t22*t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t2
     9         3+2.88d+2*t15*t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*
     :         t20+3.6d+2*t12*t16*t17+8.0d+2*t12*t13*t17
            t140 = 4.4d+2*t14*t47*t92+9.68d+2*t14*t46*t92+8.0d+0*t36*t56
     1         *t9+3.2d+1*t36*t55*t9+2.4d+1*t36*t54*t9+8.0d+0*t39*t56+8.
     2         0d+0*t39*t55+2.4d+1*t33*t38*t55+7.2d+1*t33*t38*t54+4.8d+1
     3         *t30*t35*t54+4.8d+1*t33*t38*t53+1.28d+2*t30*t35*t53+8.0d+
     4         1*t27*t32*t53+8.0d+1*t30*t35*t52+2.0d+2*t27*t32*t52+1.2d+
     5         2*t24*t29*t52+1.2d+2*t27*t32*t51+2.88d+2*t24*t29*t51+1.68
     6         d+2*t21*t26*t51+1.68d+2*t24*t29*t50+3.92d+2*t21*t26*t50+2
     7         .24d+2*t18*t23*t50+2.24d+2*t21*t26*t49+5.12d+2*t18*t23*t4
     8         9+2.88d+2*t15*t20*t49+2.88d+2*t18*t23*t48+6.48d+2*t15*t20
     9         *t48+3.6d+2*t12*t17*t48+3.6d+2*t15*t20*t47+8.0d+2*t12*t17
     :         *t47+4.4d+2*t12*t17*t46+5.28d+2*t10*t111*t46
            t141 = 9.68d+2*t6*t68*t99+4.4d+2*t13*t68*t99+8.0d+0*t40*t85+
     1         8.0d+0*t37*t85+2.4d+1*t37*t81*t84+7.2d+1*t34*t81*t84+4.8d
     2         +1*t31*t81*t84+8.0d+0*t40*t64*t83+3.2d+1*t37*t64*t83+2.4d
     3         +1*t34*t64*t83+4.8d+1*t34*t79*t82+1.28d+2*t31*t79*t82+8.0
     4         d+1*t28*t79*t82+8.0d+1*t31*t77*t80+2.0d+2*t28*t77*t80+1.2
     5         d+2*t25*t77*t80+1.2d+2*t28*t75*t78+2.88d+2*t25*t75*t78+1.
     6         68d+2*t22*t75*t78+1.68d+2*t25*t73*t76+3.92d+2*t22*t73*t76
     7         +2.24d+2*t19*t73*t76+2.24d+2*t22*t71*t74+5.12d+2*t19*t71*
     8         t74+2.88d+2*t16*t71*t74+2.88d+2*t19*t69*t72+6.48d+2*t16*t
     9         69*t72+3.6d+2*t13*t69*t72+4.4d+2*t6*t67*t70+3.6d+2*t16*t6
     :         7*t70+8.0d+2*t13*t67*t70+5.28d+2*t121*t6*t65
            t142 = 4.4d+2*t47*t68*t99+9.68d+2*t46*t68*t99+8.0d+0*t56*t85
     1         +8.0d+0*t55*t85+2.4d+1*t55*t81*t84+7.2d+1*t54*t81*t84+4.8
     2         d+1*t53*t81*t84+8.0d+0*t56*t64*t83+3.2d+1*t55*t64*t83+2.4
     3         d+1*t54*t64*t83+4.8d+1*t54*t79*t82+1.28d+2*t53*t79*t82+8.
     4         0d+1*t52*t79*t82+8.0d+1*t53*t77*t80+2.0d+2*t52*t77*t80+1.
     5         2d+2*t51*t77*t80+1.2d+2*t52*t75*t78+2.88d+2*t51*t75*t78+1
     6         .68d+2*t50*t75*t78+1.68d+2*t51*t73*t76+3.92d+2*t50*t73*t7
     7         6+2.24d+2*t49*t73*t76+2.24d+2*t50*t71*t74+5.12d+2*t49*t71
     8         *t74+2.88d+2*t48*t71*t74+2.88d+2*t49*t69*t72+6.48d+2*t48*
     9         t69*t72+3.6d+2*t47*t69*t72+3.6d+2*t48*t67*t70+8.0d+2*t47*
     :         t67*t70+4.4d+2*t46*t67*t70+5.28d+2*t121*t46*t65
            t143 = rhoa**2
            t144 = 1/t11**14
            t145 = gammaaa**3
            t146 = 1/t2**4
            t147 = 1/rhoa**9.666666666666666d+0
            t148 = 1/rhoa**7
            t149 = 1/rhoa**4.333333333333333d+0
            t150 = 1/rhoa**3.6666666666666664d+0
            t151 = rhob**2
            t152 = 1/t66**14
            t153 = gammabb**3
            t154 = 1/t59**4
            t155 = 1/rhob**9.666666666666666d+0
            t156 = 1/rhob**7
            t157 = 1/rhob**4.333333333333333d+0
            t158 = 1/rhob**3.6666666666666664d+0
            t159 = 1/rhoa**8.666666666666666d+0
            t160 = 1/rhob**8.666666666666666d+0
            t161 = 1/rhoa**7.666666666666667d+0
            t162 = 1/rhob**7.666666666666667d+0
            t163 = 1/rhoa**6.666666666666667d+0
            t164 = 1/rhob**6.666666666666667d+0
            fnc(iq) = (1.0d+0*(-9.305257363491002d-1*t61*t89*t90-9.30525
     1         7363491002d-1*t60*t61*t87)+1.0d+0*(-9.305257363491002d-1*
     2         t4*t44*t57-9.305257363491002d-1*t3*t4*t42))*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t44*t57*t97-
     1         1.2407009817988002d+0*t3*t42*t97+8.963083509889702d-3*gam
     2         maaa*t42*t95*t96+5.041016444533138d-3*gammaaa*t43*t57*t96
     3         -9.305257363491002d-1*t4*t44*t94-9.305257363491002d-1*t3*
     4         t4*t93)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t104*t89*t90
     1         +5.041016444533138d-3*gammabb*t103*t88*t90-9.305257363491
     2         002d-1*t101*t61*t89-1.2407009817988002d+0*t104*t60*t87+8.
     3         963083509889702d-3*gammabb*t102*t103*t87-9.30525736349100
     4         2d-1*t100*t60*t61)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t105*t42*t95
     1         -1.890381166699927d-3*t105*t43*t57)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-1.890381166699927d-3*t106*t88*t90
     1         -3.361156316208638d-3*t102*t106*t87)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t108*t4*t44-9
     1         .305257363491002d-1*t107*t3*t4)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t110*t61*t89-
     1         9.305257363491002d-1*t109*t60*t61)*wght+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(-2.4814019635976003d+0*t44*t94*
     1         t97-2.4814019635976003d+0*t3*t93*t97+1.7926167019779404d-
     2         2*gammaaa*t93*t95*t96+1.0082032889066277d-2*gammaaa*t43*t
     3         94*t96-8.963083509889707d-3*gammaaa*t118*t42*t95-5.041016
     4         444533138d-3*gammaaa*t118*t43*t57+4.947305865786653d-5*t1
     5         15*t117*t43*t57-9.305257363491002d-1*t114*t4*t44+2.147634
     6         8525932504d-4*t115*t116*t117*t42-9.305257363491002d-1*t11
     7         3*t3*t4+t119*t120)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(-5.041016444533138d-3*gammabb*t
     1         128*t88*t90+4.947305865786653d-5*t125*t127*t88*t90-9.3052
     2         57363491002d-1*t124*t61*t89-2.4814019635976003d+0*t101*t1
     3         04*t89+1.0082032889066277d-2*gammabb*t101*t103*t88-8.9630
     4         83509889707d-3*gammabb*t102*t128*t87+2.1476348525932504d-
     5         4*t125*t126*t127*t87-9.305257363491002d-1*t123*t60*t61-2.
     6         4814019635976003d+0*t100*t104*t60+t129*t130+1.79261670197
     7         79404d-2*gammabb*t100*t102*t103)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(4.481541754944851d-3*t42*t95*t
     1         96+2.520508222266569d-3*t43*t57*t96-3.361156316208638d-3*
     2         t105*t93*t95-1.890381166699927d-3*t105*t43*t94-1.85523969
     3         9669995d-5*gammaaa*t131*t43*t57-8.05363069722469d-5*gamma
     4         aa*t116*t131*t42)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(-1.855239699669995d-5*gammabb*
     1         t132*t88*t90+2.520508222266569d-3*t103*t88*t90-1.89038116
     2         6699927d-3*t101*t106*t88-8.05363069722469d-5*gammabb*t126
     3         *t132*t87+4.481541754944851d-3*t102*t103*t87-3.3611563162
     4         08638d-3*t100*t102*t106)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(6.957148873762482d-6*t133*t43
     1         *t57+3.020111511459258d-5*t116*t133*t42)*wght+Cmat2(iq,D2
     2         _GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(6.957148873762482d-6*t134*t88
     1         *t90+3.020111511459258d-5*t126*t134*t87)*wght+Cmat2(iq,D2
     2         _GBB_GBB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(-1.2407009817988002d+0*t108*t44
     1         *t97-1.2407009817988002d+0*t107*t3*t97+8.963083509889702d
     2         -3*gammaaa*t107*t95*t96+5.041016444533138d-3*gammaaa*t108
     3         *t43*t96-9.305257363491002d-1*t136*t4*t44-9.3052573634910
     4         02d-1*t135*t3*t4)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(-9.305257363491002d-1*t138*t61*
     1         t89-1.2407009817988002d+0*t104*t110*t89+5.041016444533138
     2         d-3*gammabb*t103*t110*t88-9.305257363491002d-1*t137*t60*t
     3         61-1.2407009817988002d+0*t104*t109*t60+8.963083509889702d
     4         -3*gammabb*t102*t103*t109)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-3.361156316208638d-3*t105*t10
     1         7*t95-1.890381166699927d-3*t105*t108*t43)*wght+Mmat2(iq,D
     2         2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(-1.890381166699927d-3*t106*t11
     1         0*t88-3.361156316208638d-3*t102*t106*t109)*wght+Mmat2(iq,
     2         D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t140*t4*t
     1         44-9.305257363491002d-1*t139*t3*t4)*wght+Mmat2(iq,D2_TA_T
     2         A)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t142*t61*
     1         t89-9.305257363491002d-1*t141*t60*t61)*wght+Mmat2(iq,D2_T
     2         B_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-1.1171548003727898d+5*t14*t6*t92*t97+5.077976365330862d
     2         +4*t13*t14*t92*t97+9.232684300601568d+2*t36*t40*t9*t97-3.
     3         693073720240627d+3*t36*t37*t9*t97+2.769805290180471d+3*t3
     4         4*t36*t9*t97+5.077976365330863d+4*t12*t17*t6*t97+6.093571
     5         638397036d+4*t10*t111*t6*t97-9.232684300601568d+2*t39*t40
     6         *t97+9.232684300601568d+2*t37*t39*t97+2.769805290180471d+
     7         3*t33*t37*t38*t97-8.309415870541413d+3*t33*t34*t38*t97+5.
     8         539610580360942d+3*t31*t33*t38*t97+5.539610580360942d+3*t
     9         30*t34*t35*t97-1.4772294880962508d+4*t30*t31*t35*t97+9.23
     :         2684300601568d+3*t28*t30*t35*t97+9.232684300601568d+3*t27
     ;         *t31*t32*t97-2.308171075150392d+4*t27*t28*t32*t97+1.38490
     <         26450902355d+4*t25*t27*t32*t97+1.3849026450902355d+4*t24*
     =         t28*t29*t97-3.323766348216566d+4*t24*t25*t29*t97+1.938863
     >         7031263292d+4*t22*t24*t29*t97+1.9388637031263292d+4*t21*t
     ?         25*t26*t97-4.5240153072947686d+4*t21*t22*t26*t97+2.585151
     @         604168439d+4*t19*t21*t26*t97+2.585151604168439d+4*t18*t22
     1         *t23*t97-5.908917952385003d+4*t18*t19*t23*t97+3.323766348
     2         2165647d+4*t16*t18*t23*t97+3.3237663482165647d+4*t15*t19*
     3         t20*t97-7.478474283487271d+4*t15*t16*t20*t97+4.1547079352
     4         70705d+4*t13*t15*t20*t97+4.1547079352707056d+4*t12*t16*t1
     5         7*t97-9.232684300601568d+4*t12*t13*t17*t97-1.272942001632
     6         3426d+7*t143*t17*t6*t92+3.713762858948263d+1*t10*t105*t6*
     7         t92-3.4716600044518436d+6*t143*t16*t17*t92+1.157220001483
     8         9477d+7*t13*t143*t17*t92+3.37614805358933d+0*t105*t39*t40
     9         *t9-2.104036366334451d+4*t143*t33*t40*t9-6.75229610717866
     :         d+0*t105*t37*t39*t9+1.2624218198006704d+5*t143*t33*t37*t9
     ;         -1.8936327297010064d+5*t143*t33*t34*t9+8.416145465337804d
     <         +4*t143*t31*t33*t9+3.4716600044518436d+6*t12*t143*t20*t6-
     =         6.01754400771653d+6*t10*t143*t144*t6+1.5275304019588112d+
     >         7*t111*t14*t143*t6-3.713762858948263d+1*t105*t12*t14*t6-3
     ?         .37614805358933d+0*t105*t40*t41+2.104036366334451d+4*t143
     @         *t36*t40+6.75229610717866d+0*t105*t36*t37*t38-8.416145465
     1         337804d+4*t143*t30*t37*t38-1.0128444160767991d+1*t105*t34
     2         *t36*t38+3.787265459402013d+5*t143*t30*t34*t38-5.04968727
     3         9202681d+5*t143*t30*t31*t38+2.1040363663344508d+5*t143*t2
     4         8*t30*t38-4.208072732668902d+4*t143*t36*t37+2.10403636633
     5         4451d+4*t143*t34*t36+1.0128444160767991d+1*t105*t33*t34*t
     6         35-2.104036366334451d+5*t143*t27*t34*t35-1.35045922143573
     7         2d+1*t105*t31*t33*t35+8.416145465337803d+5*t143*t27*t31*t
     8         35-1.0520181831672254d+6*t143*t27*t28*t35+4.2080727326689
     9         02d+5*t143*t25*t27*t35+1.350459221435732d+1*t105*t30*t31*
     :         t32-4.2080727326689016d+5*t143*t24*t31*t32-1.688074026794
     ;         6648d+1*t105*t28*t30*t32+1.578027274750838d+6*t143*t24*t2
     <         8*t32-1.893632729701006d+6*t143*t24*t25*t32+7.36412728217
     =         0578d+5*t143*t22*t24*t32+1.6880740267946648d+1*t105*t27*t
     >         28*t29-7.364127282170578d+5*t143*t21*t28*t29-2.0256888321
     ?         535982d+1*t105*t25*t27*t29+2.6510858215814087d+6*t143*t21
     @         *t25*t29-3.0929334585116436d+6*t143*t21*t22*t29+1.1782603
     1         651472927d+6*t143*t19*t21*t29+2.0256888321535982d+1*t105*
     2         t24*t25*t26-1.1782603651472927d+6*t143*t18*t25*t26-2.3633
     3         036375125308d+1*t105*t22*t24*t26+4.123911278015524d+6*t14
     4         3*t18*t22*t26-4.713041460589171d+6*t143*t18*t19*t26+1.767
     5         390547720939d+6*t143*t16*t18*t26+2.3633036375125308d+1*t1
     6         05*t21*t22*t23-1.7673905477209387d+6*t143*t15*t22*t23-2.7
     7         00918442871464d+1*t105*t19*t21*t23+6.059624735043219d+6*t
     8         143*t15*t19*t23-6.817077826923622d+6*t143*t15*t16*t23+2.5
     9         24843639601341d+6*t13*t143*t15*t23+2.700918442871464d+1*t
     :         105*t18*t19*t20-2.524843639601341d+6*t12*t143*t19*t20-3.0
     ;         385332482303967d+1*t105*t16*t18*t20+8.521347283654526d+6*
     <         t12*t143*t16*t20-9.468163648505028d+6*t12*t13*t143*t20+3.
     =         0385332482303967d+1*t105*t15*t16*t17-3.3761480535893296d+
     >         1*t105*t13*t15*t17-4.628880005935792d+6*t111*t13*t14*t143
     ?         +3.3761480535893296d+1*t105*t12*t13*t14)-9.30525736349100
     @         2d-1*t4*t44*(5.077976365330862d+4*t14*t47*t92*t97-1.11715
     1         48003727898d+5*t14*t46*t92*t97+9.232684300601568d+2*t36*t
     2         56*t9*t97-3.693073720240627d+3*t36*t55*t9*t97+2.769805290
     3         180471d+3*t36*t54*t9*t97-9.232684300601568d+2*t39*t56*t97
     4         +9.232684300601568d+2*t39*t55*t97+2.769805290180471d+3*t3
     5         3*t38*t55*t97-8.309415870541413d+3*t33*t38*t54*t97+5.5396
     6         10580360942d+3*t30*t35*t54*t97+5.539610580360942d+3*t33*t
     7         38*t53*t97-1.4772294880962508d+4*t30*t35*t53*t97+9.232684
     8         300601568d+3*t27*t32*t53*t97+9.232684300601568d+3*t30*t35
     9         *t52*t97-2.308171075150392d+4*t27*t32*t52*t97+1.384902645
     :         0902355d+4*t24*t29*t52*t97+1.3849026450902355d+4*t27*t32*
     ;         t51*t97-3.323766348216566d+4*t24*t29*t51*t97+1.9388637031
     <         263292d+4*t21*t26*t51*t97+1.9388637031263292d+4*t24*t29*t
     =         50*t97-4.5240153072947686d+4*t21*t26*t50*t97+2.5851516041
     >         68439d+4*t18*t23*t50*t97+2.585151604168439d+4*t21*t26*t49
     ?         *t97-5.908917952385003d+4*t18*t23*t49*t97+3.3237663482165
     @         647d+4*t15*t20*t49*t97+3.3237663482165647d+4*t18*t23*t48*
     1         t97-7.478474283487271d+4*t15*t20*t48*t97+4.15470793527070
     2         56d+4*t12*t17*t48*t97+4.154707935270705d+4*t15*t20*t47*t9
     3         7-9.232684300601568d+4*t12*t17*t47*t97+5.077976365330863d
     4         +4*t12*t17*t46*t97+6.093571638397036d+4*t10*t111*t46*t97-
     5         3.4716600044518436d+6*t143*t17*t48*t92+1.1572200014839477
     6         d+7*t143*t17*t47*t92-1.2729420016323426d+7*t143*t17*t46*t
     7         92+3.713762858948263d+1*t10*t105*t46*t92+3.37614805358933
     8         d+0*t105*t39*t56*t9-2.104036366334451d+4*t143*t33*t56*t9-
     9         6.75229610717866d+0*t105*t39*t55*t9+1.2624218198006704d+5
     :         *t143*t33*t55*t9-1.8936327297010064d+5*t143*t33*t54*t9+8.
     ;         416145465337804d+4*t143*t33*t53*t9-3.37614805358933d+0*t1
     <         05*t41*t56+2.104036366334451d+4*t143*t36*t56+6.7522961071
     =         7866d+0*t105*t36*t38*t55-8.416145465337804d+4*t143*t30*t3
     >         8*t55-4.208072732668902d+4*t143*t36*t55-1.012844416076799
     ?         1d+1*t105*t36*t38*t54+3.787265459402013d+5*t143*t30*t38*t
     @         54+2.104036366334451d+4*t143*t36*t54+1.0128444160767991d+
     1         1*t105*t33*t35*t54-2.104036366334451d+5*t143*t27*t35*t54-
     2         5.049687279202681d+5*t143*t30*t38*t53-1.350459221435732d+
     3         1*t105*t33*t35*t53+8.416145465337803d+5*t143*t27*t35*t53+
     4         1.350459221435732d+1*t105*t30*t32*t53-4.2080727326689016d
     5         +5*t143*t24*t32*t53+2.1040363663344508d+5*t143*t30*t38*t5
     6         2-1.0520181831672254d+6*t143*t27*t35*t52-1.68807402679466
     7         48d+1*t105*t30*t32*t52+1.578027274750838d+6*t143*t24*t32*
     8         t52+1.6880740267946648d+1*t105*t27*t29*t52-7.364127282170
     9         578d+5*t143*t21*t29*t52+4.208072732668902d+5*t143*t27*t35
     :         *t51-1.893632729701006d+6*t143*t24*t32*t51-2.025688832153
     ;         5982d+1*t105*t27*t29*t51+2.6510858215814087d+6*t143*t21*t
     <         29*t51+2.0256888321535982d+1*t105*t24*t26*t51-1.178260365
     =         1472927d+6*t143*t18*t26*t51+7.364127282170578d+5*t143*t24
     >         *t32*t50-3.0929334585116436d+6*t143*t21*t29*t50-2.3633036
     ?         375125308d+1*t105*t24*t26*t50+4.123911278015524d+6*t143*t
     @         18*t26*t50+2.3633036375125308d+1*t105*t21*t23*t50-1.76739
     1         05477209387d+6*t143*t15*t23*t50+1.1782603651472927d+6*t14
     2         3*t21*t29*t49-4.713041460589171d+6*t143*t18*t26*t49-2.700
     3         918442871464d+1*t105*t21*t23*t49+6.059624735043219d+6*t14
     4         3*t15*t23*t49+2.700918442871464d+1*t105*t18*t20*t49-2.524
     5         843639601341d+6*t12*t143*t20*t49+1.767390547720939d+6*t14
     6         3*t18*t26*t48-6.817077826923622d+6*t143*t15*t23*t48-3.038
     7         5332482303967d+1*t105*t18*t20*t48+8.521347283654526d+6*t1
     8         2*t143*t20*t48+3.0385332482303967d+1*t105*t15*t17*t48+2.5
     9         24843639601341d+6*t143*t15*t23*t47-9.468163648505028d+6*t
     :         12*t143*t20*t47-3.3761480535893296d+1*t105*t15*t17*t47-4.
     ;         628880005935792d+6*t111*t14*t143*t47+3.3761480535893296d+
     <         1*t105*t12*t14*t47+3.4716600044518436d+6*t12*t143*t20*t46
     =         -6.01754400771653d+6*t10*t143*t144*t46+1.5275304019588112
     >         d+7*t111*t14*t143*t46-3.713762858948263d+1*t105*t12*t14*t
     ?         46)-3.7221029453964005d+0*t114*t44*t97-3.7221029453964005
     @         d+0*t113*t3*t97+2.6889250529669106d-2*gammaaa*t113*t95*t9
     1         6+1.5123049333599414d-2*gammaaa*t114*t43*t96+t119*(3.9835
     2         92671062089d-3*gammaaa*t150*t42*t95-1.2407009817988002d+0
     3         *t44*t94-1.2407009817988002d+0*t3*t93+2.2404517531258392d
     4         -3*gammaaa*t150*t43*t57)-2.6889250529669123d-2*gammaaa*t1
     5         18*t93*t95+2.987694503296569d-2*gammaaa*t149*t42*t95-1.51
     6         23049333599414d-2*gammaaa*t118*t43*t94+1.484191759735996d
     7         -4*t115*t117*t43*t94+6.442904557779751d-4*t115*t116*t117*
     8         t93-6.666666666666666d-1*t120/t7+1.6803388148443793d-2*ga
     9         mmaaa*t149*t43*t57-3.4631141060506576d-4*t115*t148*t43*t5
     :         7+4.855337331063556d-7*t145*t147*t43*t57-1.50334439681527
     ;         54d-3*t115*t116*t148*t42+7.718887347725925d-6*t145*t146*t
     <         147*t42)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(-9.305257363491002d-1*t60*t6
     1         1*(-1.2729420016323426d+7*t151*t6*t70*t99-3.4716600044518
     2         436d+6*t151*t16*t70*t99+1.1572200014839477d+7*t13*t151*t7
     3         0*t99-1.1171548003727898d+5*t104*t6*t68*t99+5.07797636533
     4         0862d+4*t104*t13*t68*t99+3.713762858948263d+1*t106*t6*t65
     5         *t99-3.37614805358933d+0*t106*t40*t86+3.37614805358933d+0
     6         *t106*t40*t64*t85-6.75229610717866d+0*t106*t37*t64*t85-9.
     7         232684300601568d+2*t104*t40*t85+9.232684300601568d+2*t104
     8         *t37*t85+6.75229610717866d+0*t106*t37*t83*t84-1.012844416
     9         0767991d+1*t106*t34*t83*t84+2.769805290180471d+3*t104*t37
     :         *t81*t84-8.309415870541413d+3*t104*t34*t81*t84+5.53961058
     ;         0360942d+3*t104*t31*t81*t84-8.416145465337804d+4*t151*t37
     <         *t79*t84+3.787265459402013d+5*t151*t34*t79*t84-5.04968727
     =         9202681d+5*t151*t31*t79*t84+2.1040363663344508d+5*t151*t2
     >         8*t79*t84+9.232684300601568d+2*t104*t40*t64*t83-3.6930737
     ?         20240627d+3*t104*t37*t64*t83+2.769805290180471d+3*t104*t3
     @         4*t64*t83+2.104036366334451d+4*t151*t40*t83-4.20807273266
     1         8902d+4*t151*t37*t83+2.104036366334451d+4*t151*t34*t83+1.
     2         0128444160767991d+1*t106*t34*t81*t82-1.350459221435732d+1
     3         *t106*t31*t81*t82+5.539610580360942d+3*t104*t34*t79*t82-1
     4         .4772294880962508d+4*t104*t31*t79*t82+9.232684300601568d+
     5         3*t104*t28*t79*t82-2.104036366334451d+5*t151*t34*t77*t82+
     6         8.416145465337803d+5*t151*t31*t77*t82-1.0520181831672254d
     7         +6*t151*t28*t77*t82+4.208072732668902d+5*t151*t25*t77*t82
     8         -2.104036366334451d+4*t151*t40*t64*t81+1.2624218198006704
     9         d+5*t151*t37*t64*t81-1.8936327297010064d+5*t151*t34*t64*t
     :         81+8.416145465337804d+4*t151*t31*t64*t81+1.35045922143573
     ;         2d+1*t106*t31*t79*t80-1.6880740267946648d+1*t106*t28*t79*
     <         t80+9.232684300601568d+3*t104*t31*t77*t80-2.3081710751503
     =         92d+4*t104*t28*t77*t80+1.3849026450902355d+4*t104*t25*t77
     >         *t80-4.2080727326689016d+5*t151*t31*t75*t80+1.57802727475
     ?         0838d+6*t151*t28*t75*t80-1.893632729701006d+6*t151*t25*t7
     @         5*t80+7.364127282170578d+5*t151*t22*t75*t80+1.68807402679
     1         46648d+1*t106*t28*t77*t78-2.0256888321535982d+1*t106*t25*
     2         t77*t78+1.3849026450902355d+4*t104*t28*t75*t78-3.32376634
     3         8216566d+4*t104*t25*t75*t78+1.9388637031263292d+4*t104*t2
     4         2*t75*t78-7.364127282170578d+5*t151*t28*t73*t78+2.6510858
     5         215814087d+6*t151*t25*t73*t78-3.0929334585116436d+6*t151*
     6         t22*t73*t78+1.1782603651472927d+6*t151*t19*t73*t78+2.0256
     7         888321535982d+1*t106*t25*t75*t76-2.3633036375125308d+1*t1
     8         06*t22*t75*t76+1.9388637031263292d+4*t104*t25*t73*t76-4.5
     9         240153072947686d+4*t104*t22*t73*t76+2.585151604168439d+4*
     :         t104*t19*t73*t76-1.1782603651472927d+6*t151*t25*t71*t76+4
     ;         .123911278015524d+6*t151*t22*t71*t76-4.713041460589171d+6
     <         *t151*t19*t71*t76+1.767390547720939d+6*t151*t16*t71*t76+2
     =         .3633036375125308d+1*t106*t22*t73*t74-2.700918442871464d+
     >         1*t106*t19*t73*t74+2.585151604168439d+4*t104*t22*t71*t74-
     ?         5.908917952385003d+4*t104*t19*t71*t74+3.3237663482165647d
     @         +4*t104*t16*t71*t74-1.7673905477209387d+6*t151*t22*t69*t7
     1         4+6.059624735043219d+6*t151*t19*t69*t74-6.817077826923622
     2         d+6*t151*t16*t69*t74+2.524843639601341d+6*t13*t151*t69*t7
     3         4+2.700918442871464d+1*t106*t19*t71*t72-3.038533248230396
     4         7d+1*t106*t16*t71*t72+3.3237663482165647d+4*t104*t19*t69*
     5         t72-7.478474283487271d+4*t104*t16*t69*t72+4.1547079352707
     6         05d+4*t104*t13*t69*t72+3.4716600044518436d+6*t151*t6*t67*
     7         t72-2.524843639601341d+6*t151*t19*t67*t72+8.5213472836545
     8         26d+6*t151*t16*t67*t72-9.468163648505028d+6*t13*t151*t67*
     9         t72+3.0385332482303967d+1*t106*t16*t69*t70-3.376148053589
     :         3296d+1*t106*t13*t69*t70+5.077976365330863d+4*t104*t6*t67
     ;         *t70+4.1547079352707056d+4*t104*t16*t67*t70-9.23268430060
     <         1568d+4*t104*t13*t67*t70-3.713762858948263d+1*t106*t6*t67
     =         *t68+3.3761480535893296d+1*t106*t13*t67*t68+1.52753040195
     >         88112d+7*t121*t151*t6*t68-4.628880005935792d+6*t121*t13*t
     ?         151*t68-6.01754400771653d+6*t151*t152*t6*t65+6.0935716383
     @         97036d+4*t104*t121*t6*t65)-9.305257363491002d-1*t61*t89*(
     1         -3.4716600044518436d+6*t151*t48*t70*t99+1.157220001483947
     2         7d+7*t151*t47*t70*t99-1.2729420016323426d+7*t151*t46*t70*
     3         t99+5.077976365330862d+4*t104*t47*t68*t99-1.1171548003727
     4         898d+5*t104*t46*t68*t99+3.713762858948263d+1*t106*t46*t65
     5         *t99-3.37614805358933d+0*t106*t56*t86+3.37614805358933d+0
     6         *t106*t56*t64*t85-6.75229610717866d+0*t106*t55*t64*t85-9.
     7         232684300601568d+2*t104*t56*t85+9.232684300601568d+2*t104
     8         *t55*t85+6.75229610717866d+0*t106*t55*t83*t84-1.012844416
     9         0767991d+1*t106*t54*t83*t84+2.769805290180471d+3*t104*t55
     :         *t81*t84-8.309415870541413d+3*t104*t54*t81*t84+5.53961058
     ;         0360942d+3*t104*t53*t81*t84-8.416145465337804d+4*t151*t55
     <         *t79*t84+3.787265459402013d+5*t151*t54*t79*t84-5.04968727
     =         9202681d+5*t151*t53*t79*t84+2.1040363663344508d+5*t151*t5
     >         2*t79*t84+9.232684300601568d+2*t104*t56*t64*t83-3.6930737
     ?         20240627d+3*t104*t55*t64*t83+2.769805290180471d+3*t104*t5
     @         4*t64*t83+2.104036366334451d+4*t151*t56*t83-4.20807273266
     1         8902d+4*t151*t55*t83+2.104036366334451d+4*t151*t54*t83+1.
     2         0128444160767991d+1*t106*t54*t81*t82-1.350459221435732d+1
     3         *t106*t53*t81*t82+5.539610580360942d+3*t104*t54*t79*t82-1
     4         .4772294880962508d+4*t104*t53*t79*t82+9.232684300601568d+
     5         3*t104*t52*t79*t82-2.104036366334451d+5*t151*t54*t77*t82+
     6         8.416145465337803d+5*t151*t53*t77*t82-1.0520181831672254d
     7         +6*t151*t52*t77*t82+4.208072732668902d+5*t151*t51*t77*t82
     8         -2.104036366334451d+4*t151*t56*t64*t81+1.2624218198006704
     9         d+5*t151*t55*t64*t81-1.8936327297010064d+5*t151*t54*t64*t
     :         81+8.416145465337804d+4*t151*t53*t64*t81+1.35045922143573
     ;         2d+1*t106*t53*t79*t80-1.6880740267946648d+1*t106*t52*t79*
     <         t80+9.232684300601568d+3*t104*t53*t77*t80-2.3081710751503
     =         92d+4*t104*t52*t77*t80+1.3849026450902355d+4*t104*t51*t77
     >         *t80-4.2080727326689016d+5*t151*t53*t75*t80+1.57802727475
     ?         0838d+6*t151*t52*t75*t80-1.893632729701006d+6*t151*t51*t7
     @         5*t80+7.364127282170578d+5*t151*t50*t75*t80+1.68807402679
     1         46648d+1*t106*t52*t77*t78-2.0256888321535982d+1*t106*t51*
     2         t77*t78+1.3849026450902355d+4*t104*t52*t75*t78-3.32376634
     3         8216566d+4*t104*t51*t75*t78+1.9388637031263292d+4*t104*t5
     4         0*t75*t78-7.364127282170578d+5*t151*t52*t73*t78+2.6510858
     5         215814087d+6*t151*t51*t73*t78-3.0929334585116436d+6*t151*
     6         t50*t73*t78+1.1782603651472927d+6*t151*t49*t73*t78+2.0256
     7         888321535982d+1*t106*t51*t75*t76-2.3633036375125308d+1*t1
     8         06*t50*t75*t76+1.9388637031263292d+4*t104*t51*t73*t76-4.5
     9         240153072947686d+4*t104*t50*t73*t76+2.585151604168439d+4*
     :         t104*t49*t73*t76-1.1782603651472927d+6*t151*t51*t71*t76+4
     ;         .123911278015524d+6*t151*t50*t71*t76-4.713041460589171d+6
     <         *t151*t49*t71*t76+1.767390547720939d+6*t151*t48*t71*t76+2
     =         .3633036375125308d+1*t106*t50*t73*t74-2.700918442871464d+
     >         1*t106*t49*t73*t74+2.585151604168439d+4*t104*t50*t71*t74-
     ?         5.908917952385003d+4*t104*t49*t71*t74+3.3237663482165647d
     @         +4*t104*t48*t71*t74-1.7673905477209387d+6*t151*t50*t69*t7
     1         4+6.059624735043219d+6*t151*t49*t69*t74-6.817077826923622
     2         d+6*t151*t48*t69*t74+2.524843639601341d+6*t151*t47*t69*t7
     3         4+2.700918442871464d+1*t106*t49*t71*t72-3.038533248230396
     4         7d+1*t106*t48*t71*t72+3.3237663482165647d+4*t104*t49*t69*
     5         t72-7.478474283487271d+4*t104*t48*t69*t72+4.1547079352707
     6         05d+4*t104*t47*t69*t72-2.524843639601341d+6*t151*t49*t67*
     7         t72+8.521347283654526d+6*t151*t48*t67*t72-9.4681636485050
     8         28d+6*t151*t47*t67*t72+3.4716600044518436d+6*t151*t46*t67
     9         *t72+3.0385332482303967d+1*t106*t48*t69*t70-3.37614805358
     :         93296d+1*t106*t47*t69*t70+4.1547079352707056d+4*t104*t48*
     ;         t67*t70-9.232684300601568d+4*t104*t47*t67*t70+5.077976365
     <         330863d+4*t104*t46*t67*t70+3.3761480535893296d+1*t106*t47
     =         *t67*t68-3.713762858948263d+1*t106*t46*t67*t68-4.62888000
     >         5935792d+6*t121*t151*t47*t68+1.5275304019588112d+7*t121*t
     ?         151*t46*t68-6.01754400771653d+6*t151*t152*t46*t65+6.09357
     @         1638397036d+4*t104*t121*t46*t65)+t129*(2.2404517531258392
     1         d-3*gammabb*t158*t88*t90-1.2407009817988002d+0*t101*t89+3
     2         .983592671062089d-3*gammabb*t102*t158*t87-1.2407009817988
     3         002d+0*t100*t60)+1.6803388148443793d-2*gammabb*t157*t88*t
     4         90-3.4631141060506576d-4*t125*t156*t88*t90+4.855337331063
     5         556d-7*t153*t155*t88*t90-3.7221029453964005d+0*t104*t124*
     6         t89-1.5123049333599414d-2*gammabb*t101*t128*t88+1.4841917
     7         59735996d-4*t101*t125*t127*t88+1.5123049333599414d-2*gamm
     8         abb*t103*t124*t88+2.987694503296569d-2*gammabb*t102*t157*
     9         t87-1.5033443968152754d-3*t125*t126*t156*t87+7.7188873477
     :         25925d-6*t153*t154*t155*t87-6.666666666666666d-1*t130/t62
     ;         -3.7221029453964005d+0*t104*t123*t60-2.6889250529669123d-
     <         2*gammabb*t100*t102*t128+6.442904557779751d-4*t100*t125*t
     =         126*t127+2.6889250529669106d-2*gammabb*t102*t103*t123)*wg
     >         ht+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(8.963083509889702d-3*t93*t9
     1         5*t96+5.041016444533138d-3*t43*t94*t96+t119*(-1.493847251
     2         6482837d-3*t1*t42*t95-8.401694074221898d-4*t1*t43*t57)-8.
     3         963083509889707d-3*t118*t42*t95-3.361156316208638d-3*t105
     4         *t113*t95-3.71047939933999d-5*gammaaa*t131*t43*t94-1.6107
     5         26139444938d-4*gammaaa*t116*t131*t93-1.8207514991488338d-
     6         7*t115*t159*t43*t57-5.041016444533138d-3*t118*t43*t57+1.1
     7         749851431243302d-4*gammaaa*t117*t43*t57-1.890381166699927
     8         d-3*t105*t114*t43-2.8945827553972214d-6*t115*t146*t159*t4
     9         2+5.100632774908971d-4*gammaaa*t116*t117*t42)*wght+Cmat3(
     :         iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*(t129*(-8.401694074221898d-4
     1         *t58*t88*t90-1.4938472516482837d-3*t102*t58*t87)-1.820751
     2         4991488338d-7*t125*t160*t88*t90-5.041016444533138d-3*t128
     3         *t88*t90+1.1749851431243302d-4*gammabb*t127*t88*t90-3.710
     4         47939933999d-5*gammabb*t101*t132*t88-1.890381166699927d-3
     5         *t106*t124*t88+5.041016444533138d-3*t101*t103*t88-2.89458
     6         27553972214d-6*t125*t154*t160*t87-8.963083509889707d-3*t1
     7         02*t128*t87+5.100632774908971d-4*gammabb*t126*t127*t87-1.
     8         610726139444938d-4*gammabb*t100*t126*t132-3.3611563162086
     9         38d-3*t102*t106*t123+8.963083509889702d-3*t100*t102*t103)
     :         *wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(6.957148873762482d-6*t133*
     1         t43*t94+3.020111511459258d-5*t116*t133*t93+6.827818121808
     2         127d-8*gammaaa*t161*t43*t57-2.7828595495049924d-5*t131*t4
     3         3*t57+1.0854685332739583d-6*gammaaa*t146*t161*t42-1.20804
     4         46045837034d-4*t116*t131*t42)*wght+Cmat3(iq,D3_RA_GAA_GAA
     5         )
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*(6.827818121808127d-8*gamma
     1         bb*t162*t88*t90-2.7828595495049924d-5*t132*t88*t90+6.9571
     2         48873762482d-6*t101*t134*t88+1.0854685332739583d-6*gammab
     3         b*t154*t162*t87-1.2080446045837034d-4*t126*t132*t87+3.020
     4         111511459258d-5*t100*t126*t134)*wght+Cmat3(iq,D3_RB_GBB_G
     5         BB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(-2.560431795678048d-8*t16
     1         3*t43*t57-4.070506999777343d-7*t146*t163*t42)*wght+Cmat3(
     2         iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*(-2.560431795678048d-8*t16
     1         4*t88*t90-4.070506999777343d-7*t154*t164*t87)*wght+Cmat3(
     2         iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RA_RA_TA) = 1.0d+0*(-2.4814019635976003d+0*t136*
     1         t44*t97-2.4814019635976003d+0*t135*t3*t97+1.7926167019779
     2         404d-2*gammaaa*t135*t95*t96+1.0082032889066277d-2*gammaaa
     3         *t136*t43*t96-8.963083509889707d-3*gammaaa*t107*t118*t95-
     4         9.305257363491002d-1*t3*t4*(5.585774001863949d+5*t17*t4*t
     5         6*t92-4.5701787287977763d+5*t16*t17*t4*t92+5.077976365330
     6         863d+5*t13*t17*t4*t92+2.2282577153689576d+3*t112*t13*t14*
     7         t92-2.769805290180471d+3*t33*t4*t40*t9+4.0513776643071964
     8         d+1*t112*t36*t40*t9+5.539610580360942d+3*t33*t37*t4*t9+8.
     9         309415870541416d+3*t33*t34*t4*t9-1.1079221160721883d+4*t3
     :         1*t33*t4*t9-1.2154132992921589d+2*t112*t34*t36*t9-4.57017
     ;         87287977763d+5*t12*t20*t4*t6-7.921643129916147d+5*t10*t14
     <         4*t4*t6+6.702928802236738d+5*t111*t14*t4*t6-2.22825771536
     =         8958d+3*t112*t12*t17*t6+2.6739092584427493d+3*t10*t111*t1
     >         12*t6+9.232684300601569d+2*t36*t4*t40-1.1079221160721883d
     ?         +4*t30*t37*t38*t4+1.6618831741082832d+4*t30*t34*t38*t4+2.
     @         2158442321443766d+4*t30*t31*t38*t4-2.7698052901804704d+4*
     1         t28*t30*t38*t4+1.846536860120314d+3*t36*t37*t4-2.76980529
     2         0180471d+3*t34*t36*t4-2.769805290180471d+4*t27*t34*t35*t4
     3         +3.693073720240629d+4*t27*t31*t35*t4+4.616342150300784d+4
     4         *t27*t28*t35*t4-5.539610580360942d+4*t25*t27*t35*t4-5.539
     5         610580360941d+4*t24*t31*t32*t4+6.924513225451174d+4*t24*t
     6         28*t32*t4+8.309415870541416d+4*t24*t25*t32*t4-9.694318515
     7         631648d+4*t22*t24*t32*t4-9.694318515631648d+4*t21*t28*t29
     8         *t4+1.1633182218757979d+5*t21*t25*t29*t4+1.35720459218843
     9         07d+5*t21*t22*t29*t4-1.5510909625010635d+5*t19*t21*t29*t4
     :         -1.5510909625010638d+5*t18*t25*t26*t4+1.809606122917908d+
     ;         5*t18*t22*t26*t4+2.0681212833347515d+5*t18*t19*t26*t4-2.3
     <         266364437515952d+5*t16*t18*t26*t4-2.3266364437515955d+5*t
     =         15*t22*t23*t4+2.659013078573252d+5*t15*t19*t23*t4+2.99138
     >         97133949086d+5*t15*t16*t23*t4-3.3237663482165647d+5*t13*t
     ?         15*t23*t4-3.323766348216565d+5*t12*t19*t20*t4+3.739237141
     @         7436354d+5*t12*t16*t20*t4+4.1547079352707056d+5*t12*t13*t
     1         20*t4-6.093571638397035d+5*t111*t13*t14*t4-4.051377664307
     2         1964d+1*t112*t37*t39+1.2154132992921589d+2*t112*t33*t37*t
     3         38-2.4308265985843178d+2*t112*t31*t33*t38+2.4308265985843
     4         178d+2*t112*t30*t34*t35-4.051377664307196d+2*t112*t28*t30
     5         *t35+4.0513776643071964d+2*t112*t27*t31*t32-6.07706649646
     6         0795d+2*t112*t25*t27*t32+6.077066496460793d+2*t112*t24*t2
     7         8*t29-8.507893095045111d+2*t112*t22*t24*t29+8.50789309504
     8         5113d+2*t112*t21*t25*t26-1.1343857460060149d+3*t112*t19*t
     9         21*t26+1.1343857460060149d+3*t112*t18*t22*t23-1.458495959
     :         1505905d+3*t112*t16*t18*t23+1.4584959591505908d+3*t112*t1
     ;         5*t19*t20-1.8231199489382383d+3*t112*t13*t15*t20+1.823119
     <         9489382383d+3*t112*t12*t16*t17)-9.305257363491002d-1*t4*t
     =         44*(-4.5701787287977763d+5*t17*t4*t48*t92+5.0779763653308
     >         63d+5*t17*t4*t47*t92+2.2282577153689576d+3*t112*t14*t47*t
     ?         92+5.585774001863949d+5*t17*t4*t46*t92-2.769805290180471d
     @         +3*t33*t4*t56*t9+4.0513776643071964d+1*t112*t36*t56*t9+5.
     1         539610580360942d+3*t33*t4*t55*t9+8.309415870541416d+3*t33
     2         *t4*t54*t9-1.2154132992921589d+2*t112*t36*t54*t9-1.107922
     3         1160721883d+4*t33*t4*t53*t9+9.232684300601569d+2*t36*t4*t
     4         56-1.1079221160721883d+4*t30*t38*t4*t55+1.846536860120314
     5         d+3*t36*t4*t55-4.0513776643071964d+1*t112*t39*t55+1.21541
     6         32992921589d+2*t112*t33*t38*t55+1.6618831741082832d+4*t30
     7         *t38*t4*t54-2.769805290180471d+3*t36*t4*t54-2.76980529018
     8         0471d+4*t27*t35*t4*t54+2.4308265985843178d+2*t112*t30*t35
     9         *t54+2.2158442321443766d+4*t30*t38*t4*t53+3.6930737202406
     :         29d+4*t27*t35*t4*t53-5.539610580360941d+4*t24*t32*t4*t53-
     ;         2.4308265985843178d+2*t112*t33*t38*t53+4.0513776643071964
     <         d+2*t112*t27*t32*t53-2.7698052901804704d+4*t30*t38*t4*t52
     =         +4.616342150300784d+4*t27*t35*t4*t52+6.924513225451174d+4
     >         *t24*t32*t4*t52-9.694318515631648d+4*t21*t29*t4*t52-4.051
     ?         377664307196d+2*t112*t30*t35*t52+6.077066496460793d+2*t11
     @         2*t24*t29*t52-5.539610580360942d+4*t27*t35*t4*t51+8.30941
     1         5870541416d+4*t24*t32*t4*t51+1.1633182218757979d+5*t21*t2
     2         9*t4*t51-1.5510909625010638d+5*t18*t26*t4*t51-6.077066496
     3         460795d+2*t112*t27*t32*t51+8.507893095045113d+2*t112*t21*
     4         t26*t51-9.694318515631648d+4*t24*t32*t4*t50+1.35720459218
     5         84307d+5*t21*t29*t4*t50+1.809606122917908d+5*t18*t26*t4*t
     6         50-2.3266364437515955d+5*t15*t23*t4*t50-8.507893095045111
     7         d+2*t112*t24*t29*t50+1.1343857460060149d+3*t112*t18*t23*t
     8         50-1.5510909625010635d+5*t21*t29*t4*t49+2.068121283334751
     9         5d+5*t18*t26*t4*t49+2.659013078573252d+5*t15*t23*t4*t49-3
     :         .323766348216565d+5*t12*t20*t4*t49-1.1343857460060149d+3*
     ;         t112*t21*t26*t49+1.4584959591505908d+3*t112*t15*t20*t49-2
     <         .3266364437515952d+5*t18*t26*t4*t48+2.9913897133949086d+5
     =         *t15*t23*t4*t48+3.7392371417436354d+5*t12*t20*t4*t48-1.45
     >         84959591505905d+3*t112*t18*t23*t48+1.8231199489382383d+3*
     ?         t112*t12*t17*t48-3.3237663482165647d+5*t15*t23*t4*t47+4.1
     @         547079352707056d+5*t12*t20*t4*t47-6.093571638397035d+5*t1
     1         11*t14*t4*t47-1.8231199489382383d+3*t112*t15*t20*t47-4.57
     2         01787287977763d+5*t12*t20*t4*t46-7.921643129916147d+5*t10
     3         *t144*t4*t46+6.702928802236738d+5*t111*t14*t4*t46-2.22825
     4         7715368958d+3*t112*t12*t17*t46+2.6739092584427493d+3*t10*
     5         t111*t112*t46)+t119*(-4.135669939329334d-1*t108*t44-4.135
     6         669939329334d-1*t107*t3)-5.041016444533138d-3*gammaaa*t10
     7         8*t118*t43+4.947305865786653d-5*t108*t115*t117*t43+2.1476
     8         348525932504d-4*t107*t115*t116*t117)*wght+Mmat3(iq,D3_RA_
     9         RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = 1.0d+0*(-9.305257363491002d-1*t60*t6
     1         1*(5.585774001863949d+5*t6*t61*t70*t99-4.5701787287977763
     2         d+5*t16*t61*t70*t99+5.077976365330863d+5*t13*t61*t70*t99+
     3         2.2282577153689576d+3*t122*t13*t68*t99-4.0513776643071964
     4         d+1*t122*t37*t85+1.2154132992921589d+2*t122*t37*t81*t84-2
     5         .4308265985843178d+2*t122*t31*t81*t84-1.1079221160721883d
     6         +4*t37*t61*t79*t84+1.6618831741082832d+4*t34*t61*t79*t84+
     7         2.2158442321443766d+4*t31*t61*t79*t84-2.7698052901804704d
     8         +4*t28*t61*t79*t84+4.0513776643071964d+1*t122*t40*t64*t83
     9         -1.2154132992921589d+2*t122*t34*t64*t83+9.232684300601569
     :         d+2*t40*t61*t83+1.846536860120314d+3*t37*t61*t83-2.769805
     ;         290180471d+3*t34*t61*t83+2.4308265985843178d+2*t122*t34*t
     <         79*t82-4.051377664307196d+2*t122*t28*t79*t82-2.7698052901
     =         80471d+4*t34*t61*t77*t82+3.693073720240629d+4*t31*t61*t77
     >         *t82+4.616342150300784d+4*t28*t61*t77*t82-5.5396105803609
     ?         42d+4*t25*t61*t77*t82-2.769805290180471d+3*t40*t61*t64*t8
     @         1+5.539610580360942d+3*t37*t61*t64*t81+8.309415870541416d
     1         +3*t34*t61*t64*t81-1.1079221160721883d+4*t31*t61*t64*t81+
     2         4.0513776643071964d+2*t122*t31*t77*t80-6.077066496460795d
     3         +2*t122*t25*t77*t80-5.539610580360941d+4*t31*t61*t75*t80+
     4         6.924513225451174d+4*t28*t61*t75*t80+8.309415870541416d+4
     5         *t25*t61*t75*t80-9.694318515631648d+4*t22*t61*t75*t80+6.0
     6         77066496460793d+2*t122*t28*t75*t78-8.507893095045111d+2*t
     7         122*t22*t75*t78-9.694318515631648d+4*t28*t61*t73*t78+1.16
     8         33182218757979d+5*t25*t61*t73*t78+1.3572045921884307d+5*t
     9         22*t61*t73*t78-1.5510909625010635d+5*t19*t61*t73*t78+8.50
     :         7893095045113d+2*t122*t25*t73*t76-1.1343857460060149d+3*t
     ;         122*t19*t73*t76-1.5510909625010638d+5*t25*t61*t71*t76+1.8
     <         09606122917908d+5*t22*t61*t71*t76+2.0681212833347515d+5*t
     =         19*t61*t71*t76-2.3266364437515952d+5*t16*t61*t71*t76+1.13
     >         43857460060149d+3*t122*t22*t71*t74-1.4584959591505905d+3*
     ?         t122*t16*t71*t74-2.3266364437515955d+5*t22*t61*t69*t74+2.
     @         659013078573252d+5*t19*t61*t69*t74+2.9913897133949086d+5*
     1         t16*t61*t69*t74-3.3237663482165647d+5*t13*t61*t69*t74+1.4
     2         584959591505908d+3*t122*t19*t69*t72-1.8231199489382383d+3
     3         *t122*t13*t69*t72-4.5701787287977763d+5*t6*t61*t67*t72-3.
     4         323766348216565d+5*t19*t61*t67*t72+3.7392371417436354d+5*
     5         t16*t61*t67*t72+4.1547079352707056d+5*t13*t61*t67*t72-2.2
     6         28257715368958d+3*t122*t6*t67*t70+1.8231199489382383d+3*t
     7         122*t16*t67*t70+6.702928802236738d+5*t121*t6*t61*t68-6.09
     8         3571638397035d+5*t121*t13*t61*t68-7.921643129916147d+5*t1
     9         52*t6*t61*t65+2.6739092584427493d+3*t121*t122*t6*t65)-9.3
     :         05257363491002d-1*t61*t89*(-4.5701787287977763d+5*t48*t61
     ;         *t70*t99+5.077976365330863d+5*t47*t61*t70*t99+5.585774001
     <         863949d+5*t46*t61*t70*t99+2.2282577153689576d+3*t122*t47*
     =         t68*t99-4.0513776643071964d+1*t122*t55*t85+1.215413299292
     >         1589d+2*t122*t55*t81*t84-2.4308265985843178d+2*t122*t53*t
     ?         81*t84-1.1079221160721883d+4*t55*t61*t79*t84+1.6618831741
     @         082832d+4*t54*t61*t79*t84+2.2158442321443766d+4*t53*t61*t
     1         79*t84-2.7698052901804704d+4*t52*t61*t79*t84+4.0513776643
     2         071964d+1*t122*t56*t64*t83-1.2154132992921589d+2*t122*t54
     3         *t64*t83+9.232684300601569d+2*t56*t61*t83+1.8465368601203
     4         14d+3*t55*t61*t83-2.769805290180471d+3*t54*t61*t83+2.4308
     5         265985843178d+2*t122*t54*t79*t82-4.051377664307196d+2*t12
     6         2*t52*t79*t82-2.769805290180471d+4*t54*t61*t77*t82+3.6930
     7         73720240629d+4*t53*t61*t77*t82+4.616342150300784d+4*t52*t
     8         61*t77*t82-5.539610580360942d+4*t51*t61*t77*t82-2.7698052
     9         90180471d+3*t56*t61*t64*t81+5.539610580360942d+3*t55*t61*
     :         t64*t81+8.309415870541416d+3*t54*t61*t64*t81-1.1079221160
     ;         721883d+4*t53*t61*t64*t81+4.0513776643071964d+2*t122*t53*
     <         t77*t80-6.077066496460795d+2*t122*t51*t77*t80-5.539610580
     =         360941d+4*t53*t61*t75*t80+6.924513225451174d+4*t52*t61*t7
     >         5*t80+8.309415870541416d+4*t51*t61*t75*t80-9.694318515631
     ?         648d+4*t50*t61*t75*t80+6.077066496460793d+2*t122*t52*t75*
     @         t78-8.507893095045111d+2*t122*t50*t75*t78-9.6943185156316
     1         48d+4*t52*t61*t73*t78+1.1633182218757979d+5*t51*t61*t73*t
     2         78+1.3572045921884307d+5*t50*t61*t73*t78-1.55109096250106
     3         35d+5*t49*t61*t73*t78+8.507893095045113d+2*t122*t51*t73*t
     4         76-1.1343857460060149d+3*t122*t49*t73*t76-1.5510909625010
     5         638d+5*t51*t61*t71*t76+1.809606122917908d+5*t50*t61*t71*t
     6         76+2.0681212833347515d+5*t49*t61*t71*t76-2.32663644375159
     7         52d+5*t48*t61*t71*t76+1.1343857460060149d+3*t122*t50*t71*
     8         t74-1.4584959591505905d+3*t122*t48*t71*t74-2.326636443751
     9         5955d+5*t50*t61*t69*t74+2.659013078573252d+5*t49*t61*t69*
     :         t74+2.9913897133949086d+5*t48*t61*t69*t74-3.3237663482165
     ;         647d+5*t47*t61*t69*t74+1.4584959591505908d+3*t122*t49*t69
     <         *t72-1.8231199489382383d+3*t122*t47*t69*t72-3.32376634821
     =         6565d+5*t49*t61*t67*t72+3.7392371417436354d+5*t48*t61*t67
     >         *t72+4.1547079352707056d+5*t47*t61*t67*t72-4.570178728797
     ?         7763d+5*t46*t61*t67*t72+1.8231199489382383d+3*t122*t48*t6
     @         7*t70-2.228257715368958d+3*t122*t46*t67*t70-6.09357163839
     1         7035d+5*t121*t47*t61*t68+6.702928802236738d+5*t121*t46*t6
     2         1*t68-7.921643129916147d+5*t152*t46*t61*t65+2.67390925844
     3         27493d+3*t121*t122*t46*t65)+t129*(-4.135669939329334d-1*t
     4         110*t89-4.135669939329334d-1*t109*t60)-2.4814019635976003
     5         d+0*t104*t138*t89+1.0082032889066277d-2*gammabb*t103*t138
     6         *t88-5.041016444533138d-3*gammabb*t110*t128*t88+4.9473058
     7         65786653d-5*t110*t125*t127*t88-2.4814019635976003d+0*t104
     8         *t137*t60+1.7926167019779404d-2*gammabb*t102*t103*t137-8.
     9         963083509889707d-3*gammabb*t102*t109*t128+2.1476348525932
     :         504d-4*t109*t125*t126*t127)*wght+Mmat3(iq,D3_RB_RB_TB)
            Mmat3(iq,D3_RA_GAA_TA) = 1.0d+0*(4.481541754944851d-3*t107*t
     1         95*t96+2.520508222266569d-3*t108*t43*t96-3.36115631620863
     2         8d-3*t105*t135*t95-1.890381166699927d-3*t105*t136*t43-1.8
     3         55239699669995d-5*gammaaa*t108*t131*t43-8.05363069722469d
     4         -5*gammaaa*t107*t116*t131)*wght+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
            Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
            Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
            Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = 1.0d+0*(-1.890381166699927d-3*t106*
     1         t138*t88-1.855239699669995d-5*gammabb*t110*t132*t88+2.520
     2         508222266569d-3*t103*t110*t88-3.361156316208638d-3*t102*t
     3         106*t137-8.05363069722469d-5*gammabb*t109*t126*t132+4.481
     4         541754944851d-3*t102*t103*t109)*wght+Mmat3(iq,D3_RB_GBB_T
     5         B)
            Mmat3(iq,D3_RA_TA_TA) = 1.0d+0*(6.957148873762482d-6*t108*t1
     1         33*t43+3.020111511459258d-5*t107*t116*t133)*wght+Mmat3(iq
     2         ,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAA_GBB_TB) = 1.0d+0*(6.957148873762482d-6*t110*
     1         t134*t88+3.020111511459258d-5*t109*t126*t134)*wght+Mmat3(
     2         iq,D3_GAA_GBB_TB)
            Mmat3(iq,D3_GAB_GAB_TA) = 1.0d+0*(-3.361156316208638d-3*t105
     1         *t139*t95-1.890381166699927d-3*t105*t140*t43)*wght+Mmat3(
     2         iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
            Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
            Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = 1.0d+0*(-1.890381166699927d-3*t106*
     1         t142*t88-3.361156316208638d-3*t102*t106*t141)*wght+Mmat3(
     2         iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_GAB_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4
     1         *(-2.904d+4*t17*t6*t92-7.92d+3*t16*t17*t92-2.64d+4*t13*t1
     2         7*t92-4.8d+1*t33*t40*t9-2.88d+2*t33*t37*t9-4.32d+2*t33*t3
     3         4*t9-1.92d+2*t31*t33*t9-7.92d+3*t12*t20*t6-1.3728d+4*t10*
     4         t144*t6-3.4848d+4*t111*t14*t6-4.8d+1*t36*t40-1.92d+2*t30*
     5         t37*t38-8.64d+2*t30*t34*t38-1.152d+3*t30*t31*t38-4.8d+2*t
     6         28*t30*t38-9.6d+1*t36*t37-4.8d+1*t34*t36-4.8d+2*t27*t34*t
     7         35-1.92d+3*t27*t31*t35-2.4d+3*t27*t28*t35-9.6d+2*t25*t27*
     8         t35-9.6d+2*t24*t31*t32-3.6d+3*t24*t28*t32-4.32d+3*t24*t25
     9         *t32-1.68d+3*t22*t24*t32-1.68d+3*t21*t28*t29-6.048d+3*t21
     :         *t25*t29-7.056d+3*t21*t22*t29-2.688d+3*t19*t21*t29-2.688d
     ;         +3*t18*t25*t26-9.408d+3*t18*t22*t26-1.0752d+4*t18*t19*t26
     <         -4.032d+3*t16*t18*t26-4.032d+3*t15*t22*t23-1.3824d+4*t15*
     =         t19*t23-1.5552d+4*t15*t16*t23-5.76d+3*t13*t15*t23-5.76d+3
     >         *t12*t19*t20-1.944d+4*t12*t16*t20-2.16d+4*t12*t13*t20-1.0
     ?         56d+4*t111*t13*t14)-9.305257363491002d-1*t4*t44*(-7.92d+3
     @         *t17*t48*t92-2.64d+4*t17*t47*t92-2.904d+4*t17*t46*t92-4.8
     1         d+1*t33*t56*t9-2.88d+2*t33*t55*t9-4.32d+2*t33*t54*t9-1.92
     2         d+2*t33*t53*t9-4.8d+1*t36*t56-1.92d+2*t30*t38*t55-9.6d+1*
     3         t36*t55-8.64d+2*t30*t38*t54-4.8d+1*t36*t54-4.8d+2*t27*t35
     4         *t54-1.152d+3*t30*t38*t53-1.92d+3*t27*t35*t53-9.6d+2*t24*
     5         t32*t53-4.8d+2*t30*t38*t52-2.4d+3*t27*t35*t52-3.6d+3*t24*
     6         t32*t52-1.68d+3*t21*t29*t52-9.6d+2*t27*t35*t51-4.32d+3*t2
     7         4*t32*t51-6.048d+3*t21*t29*t51-2.688d+3*t18*t26*t51-1.68d
     8         +3*t24*t32*t50-7.056d+3*t21*t29*t50-9.408d+3*t18*t26*t50-
     9         4.032d+3*t15*t23*t50-2.688d+3*t21*t29*t49-1.0752d+4*t18*t
     :         26*t49-1.3824d+4*t15*t23*t49-5.76d+3*t12*t20*t49-4.032d+3
     ;         *t18*t26*t48-1.5552d+4*t15*t23*t48-1.944d+4*t12*t20*t48-5
     <         .76d+3*t15*t23*t47-2.16d+4*t12*t20*t47-1.056d+4*t111*t14*
     =         t47-7.92d+3*t12*t20*t46-1.3728d+4*t10*t144*t46-3.4848d+4*
     >         t111*t14*t46))*wght+Mmat3(iq,D3_GAB_TA_TA)
            Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
            Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t60*t
     1         61*(-2.904d+4*t6*t70*t99-7.92d+3*t16*t70*t99-2.64d+4*t13*
     2         t70*t99-1.92d+2*t37*t79*t84-8.64d+2*t34*t79*t84-1.152d+3*
     3         t31*t79*t84-4.8d+2*t28*t79*t84-4.8d+1*t40*t83-9.6d+1*t37*
     4         t83-4.8d+1*t34*t83-4.8d+2*t34*t77*t82-1.92d+3*t31*t77*t82
     5         -2.4d+3*t28*t77*t82-9.6d+2*t25*t77*t82-4.8d+1*t40*t64*t81
     6         -2.88d+2*t37*t64*t81-4.32d+2*t34*t64*t81-1.92d+2*t31*t64*
     7         t81-9.6d+2*t31*t75*t80-3.6d+3*t28*t75*t80-4.32d+3*t25*t75
     8         *t80-1.68d+3*t22*t75*t80-1.68d+3*t28*t73*t78-6.048d+3*t25
     9         *t73*t78-7.056d+3*t22*t73*t78-2.688d+3*t19*t73*t78-2.688d
     :         +3*t25*t71*t76-9.408d+3*t22*t71*t76-1.0752d+4*t19*t71*t76
     ;         -4.032d+3*t16*t71*t76-4.032d+3*t22*t69*t74-1.3824d+4*t19*
     <         t69*t74-1.5552d+4*t16*t69*t74-5.76d+3*t13*t69*t74-7.92d+3
     =         *t6*t67*t72-5.76d+3*t19*t67*t72-1.944d+4*t16*t67*t72-2.16
     >         d+4*t13*t67*t72-3.4848d+4*t121*t6*t68-1.056d+4*t121*t13*t
     ?         68-1.3728d+4*t152*t6*t65)-9.305257363491002d-1*t61*t89*(-
     @         7.92d+3*t48*t70*t99-2.64d+4*t47*t70*t99-2.904d+4*t46*t70*
     1         t99-1.92d+2*t55*t79*t84-8.64d+2*t54*t79*t84-1.152d+3*t53*
     2         t79*t84-4.8d+2*t52*t79*t84-4.8d+1*t56*t83-9.6d+1*t55*t83-
     3         4.8d+1*t54*t83-4.8d+2*t54*t77*t82-1.92d+3*t53*t77*t82-2.4
     4         d+3*t52*t77*t82-9.6d+2*t51*t77*t82-4.8d+1*t56*t64*t81-2.8
     5         8d+2*t55*t64*t81-4.32d+2*t54*t64*t81-1.92d+2*t53*t64*t81-
     6         9.6d+2*t53*t75*t80-3.6d+3*t52*t75*t80-4.32d+3*t51*t75*t80
     7         -1.68d+3*t50*t75*t80-1.68d+3*t52*t73*t78-6.048d+3*t51*t73
     8         *t78-7.056d+3*t50*t73*t78-2.688d+3*t49*t73*t78-2.688d+3*t
     9         51*t71*t76-9.408d+3*t50*t71*t76-1.0752d+4*t49*t71*t76-4.0
     :         32d+3*t48*t71*t76-4.032d+3*t50*t69*t74-1.3824d+4*t49*t69*
     ;         t74-1.5552d+4*t48*t69*t74-5.76d+3*t47*t69*t74-5.76d+3*t49
     <         *t67*t72-1.944d+4*t48*t67*t72-2.16d+4*t47*t67*t72-7.92d+3
     =         *t46*t67*t72-1.056d+4*t121*t47*t68-3.4848d+4*t121*t46*t68
     >         -1.3728d+4*t152*t46*t65))*wght+Mmat3(iq,D3_GBB_TA_TA)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = param(12)
            t6 = rhoa**1.6666666666666669d+0
            t7 = 9.115599744691192d+0*t6
            t8 = t7-2.0d+0*taua
            t9 = t8**11
            t10 = 2.0d+0*taua+t7
            t11 = 1/t10**11
            t12 = param(11)
            t13 = t8**10
            t14 = 1/t10**10
            t15 = param(10)
            t16 = t8**9
            t17 = 1/t10**9
            t18 = param(9)
            t19 = t8**8
            t20 = 1/t10**8
            t21 = param(8)
            t22 = t8**7
            t23 = 1/t10**7
            t24 = param(7)
            t25 = t8**6
            t26 = 1/t10**6
            t27 = param(6)
            t28 = t8**5
            t29 = 1/t10**5
            t30 = param(5)
            t31 = t8**4
            t32 = 1/t10**4
            t33 = param(4)
            t34 = t8**3
            t35 = 1/t10**3
            t36 = param(3)
            t37 = t8**2
            t38 = 1/t10**2
            t39 = param(2)
            t40 = 1/t10
            t41 = t11*t5*t9+t39*t40*t8+t36*t37*t38+t33*t34*t35+t30*t31*t
     1         32+t27*t28*t29+t24*t25*t26+t21*t22*t23+t18*t19*t20+t15*t1
     2         6*t17+t12*t13*t14+param(1)
            t42 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t43 = 5.52d-1*(1.0d+0-t42)+1.0d+0
            t44 = param(24)
            t45 = param(23)
            t46 = param(22)
            t47 = param(21)
            t48 = param(20)
            t49 = param(19)
            t50 = param(18)
            t51 = param(17)
            t52 = param(16)
            t53 = param(15)
            t54 = param(14)
            t55 = t11*t44*t9+t40*t54*t8+t37*t38*t53+t34*t35*t52+t31*t32*
     1         t51+t28*t29*t50+t25*t26*t49+t22*t23*t48+t19*t20*t47+t16*t
     2         17*t46+t13*t14*t45+param(13)
            t56 = rhoa**6.666666666666666d-1
            t57 = 1/t10**12
            t58 = -1.6711932865267184d+2*t5*t56*t57*t9-1.519266624115198
     1         6d+1*t38*t39*t56*t8+3.038533248230397d+1*t36*t38*t56*t8+1
     2         .6711932865267184d+2*t11*t13*t5*t56+1.5192666241151986d+1
     3         *t39*t40*t56-3.038533248230397d+1*t35*t36*t37*t56+4.55779
     4         98723455965d+1*t33*t35*t37*t56-4.5577998723455965d+1*t32*
     5         t33*t34*t56+6.077066496460795d+1*t30*t32*t34*t56-6.077066
     6         496460795d+1*t29*t30*t31*t56+7.596333120575993d+1*t27*t29
     7         *t31*t56-7.596333120575993d+1*t26*t27*t28*t56+9.115599744
     8         691193d+1*t24*t26*t28*t56-9.115599744691193d+1*t23*t24*t2
     9         5*t56+1.0634866368806391d+2*t21*t23*t25*t56-1.06348663688
     :         06391d+2*t20*t21*t22*t56+1.2154132992921589d+2*t18*t20*t2
     ;         2*t56-1.2154132992921589d+2*t17*t18*t19*t56+1.36733996170
     <         36788d+2*t15*t17*t19*t56-1.3673399617036788d+2*t14*t15*t1
     =         6*t56+1.5192666241151986d+2*t12*t14*t16*t56-1.51926662411
     >         51986d+2*t11*t12*t13*t56
            t59 = -1.6711932865267184d+2*t44*t56*t57*t9-1.51926662411519
     1         86d+1*t38*t54*t56*t8+3.038533248230397d+1*t38*t53*t56*t8+
     2         1.5192666241151986d+1*t40*t54*t56-3.038533248230397d+1*t3
     3         5*t37*t53*t56+4.5577998723455965d+1*t35*t37*t52*t56-4.557
     4         7998723455965d+1*t32*t34*t52*t56+6.077066496460795d+1*t32
     5         *t34*t51*t56-6.077066496460795d+1*t29*t31*t51*t56+7.59633
     6         3120575993d+1*t29*t31*t50*t56-7.596333120575993d+1*t26*t2
     7         8*t50*t56+9.115599744691193d+1*t26*t28*t49*t56-9.11559974
     8         4691193d+1*t23*t25*t49*t56+1.0634866368806391d+2*t23*t25*
     9         t48*t56-1.0634866368806391d+2*t20*t22*t48*t56+1.215413299
     :         2921589d+2*t20*t22*t47*t56-1.2154132992921589d+2*t17*t19*
     ;         t47*t56+1.3673399617036788d+2*t17*t19*t46*t56-1.367339961
     <         7036788d+2*t14*t16*t46*t56+1.5192666241151986d+2*t14*t16*
     =         t45*t56-1.5192666241151986d+2*t11*t13*t45*t56+1.671193286
     >         5267184d+2*t11*t13*t44*t56
            t60 = 1/t2**2
            t61 = 1/rhoa**2.3333333333333334d+0
            t62 = rhoa**3.333333333333333d-1
            t63 = 1/t4
            t64 = -2.2d+1*t5*t57*t9-2.0d+0*t38*t39*t8-4.0d+0*t36*t38*t8-
     1         2.2d+1*t11*t13*t5-2.0d+0*t39*t40-4.0d+0*t35*t36*t37-6.0d+
     2         0*t33*t35*t37-6.0d+0*t32*t33*t34-8.0d+0*t30*t32*t34-8.0d+
     3         0*t29*t30*t31-1.0d+1*t27*t29*t31-1.0d+1*t26*t27*t28-1.2d+
     4         1*t24*t26*t28-1.2d+1*t23*t24*t25-1.4d+1*t21*t23*t25-1.4d+
     5         1*t20*t21*t22-1.6d+1*t18*t20*t22-1.6d+1*t17*t18*t19-1.8d+
     6         1*t15*t17*t19-1.8d+1*t14*t15*t16-2.0d+1*t12*t14*t16-2.0d+
     7         1*t11*t12*t13
            t65 = -2.2d+1*t44*t57*t9-2.0d+0*t38*t54*t8-4.0d+0*t38*t53*t8
     1         -2.0d+0*t40*t54-4.0d+0*t35*t37*t53-6.0d+0*t35*t37*t52-6.0
     2         d+0*t32*t34*t52-8.0d+0*t32*t34*t51-8.0d+0*t29*t31*t51-1.0
     3         d+1*t29*t31*t50-1.0d+1*t26*t28*t50-1.2d+1*t26*t28*t49-1.2
     4         d+1*t23*t25*t49-1.4d+1*t23*t25*t48-1.4d+1*t20*t22*t48-1.6
     5         d+1*t20*t22*t47-1.6d+1*t17*t19*t47-1.8d+1*t17*t19*t46-1.8
     6         d+1*t14*t16*t46-2.0d+1*t14*t16*t45-2.0d+1*t11*t13*t45-2.2
     7         d+1*t11*t13*t44
            t66 = 1/t10**13
            t67 = 1/t62
            t68 = -1.1141288576844789d+2*t5*t57*t67*t9+3.046785819198518
     1         d+4*t4*t5*t66*t9-1.0128444160767991d+1*t38*t39*t67*t8+2.0
     2         256888321535982d+1*t36*t38*t67*t8+4.6163421503007845d+2*t
     3         35*t39*t4*t8-1.846536860120314d+3*t35*t36*t4*t8+1.3849026
     4         450902355d+3*t33*t35*t4*t8+1.1141288576844789d+2*t11*t13*
     5         t5*t67+1.0128444160767991d+1*t39*t40*t67-2.02568883215359
     6         82d+1*t35*t36*t37*t67+3.038533248230397d+1*t33*t35*t37*t6
     7         7-3.038533248230397d+1*t32*t33*t34*t67+4.0513776643071964
     8         d+1*t30*t32*t34*t67-4.0513776643071964d+1*t29*t30*t31*t67
     9         +5.064222080383994d+1*t27*t29*t31*t67-5.064222080383994d+
     :         1*t26*t27*t28*t67+6.077066496460795d+1*t24*t26*t28*t67-6.
     ;         077066496460795d+1*t23*t24*t25*t67+7.089910912537593d+1*t
     <         21*t23*t25*t67-7.089910912537593d+1*t20*t21*t22*t67+8.102
     =         755328614393d+1*t18*t20*t22*t67-8.102755328614393d+1*t17*
     >         t18*t19*t67+9.115599744691191d+1*t15*t17*t19*t67-9.115599
     ?         744691191d+1*t14*t15*t16*t67+1.012844416076799d+2*t12*t14
     @         *t16*t67-1.012844416076799d+2*t11*t12*t13*t67-5.585774001
     1         863949d+4*t13*t4*t5*t57+2.5389881826654315d+4*t12*t13*t4*
     2         t57+2.5389881826654315d+4*t11*t16*t4*t5-4.616342150300784
     3         5d+2*t38*t39*t4+4.6163421503007845d+2*t36*t38*t4+1.384902
     4         6450902355d+3*t32*t36*t37*t4-4.1547079352707067d+3*t32*t3
     5         3*t37*t4+2.769805290180471d+3*t30*t32*t37*t4+2.7698052901
     6         80471d+3*t29*t33*t34*t4-7.386147440481255d+3*t29*t30*t34*
     7         t4+4.616342150300784d+3*t27*t29*t34*t4+4.616342150300784d
     8         +3*t26*t30*t31*t4-1.154085537575196d+4*t26*t27*t31*t4+6.9
     9         24513225451178d+3*t24*t26*t31*t4+6.924513225451178d+3*t23
     :         *t27*t28*t4-1.661883174108283d+4*t23*t24*t28*t4+9.6943185
     ;         15631648d+3*t21*t23*t28*t4+9.694318515631648d+3*t20*t24*t
     <         25*t4-2.2620076536473846d+4*t20*t21*t25*t4+1.292575802084
     =         2196d+4*t18*t20*t25*t4+1.2925758020842196d+4*t17*t21*t22*
     >         t4-2.954458976192502d+4*t17*t18*t22*t4+1.6618831741082823
     ?         d+4*t15*t17*t22*t4+1.6618831741082823d+4*t14*t18*t19*t4-3
     @         .7392371417436354d+4*t14*t15*t19*t4+2.0773539676353528d+4
     1         *t12*t14*t19*t4+2.0773539676353528d+4*t11*t15*t16*t4-4.61
     2         6342150300784d+4*t11*t12*t16*t4
            t69 = -1.1141288576844789d+2*t44*t57*t67*t9+3.04678581919851
     1         8d+4*t4*t44*t66*t9-1.0128444160767991d+1*t38*t54*t67*t8+2
     2         .0256888321535982d+1*t38*t53*t67*t8+4.6163421503007845d+2
     3         *t35*t4*t54*t8-1.846536860120314d+3*t35*t4*t53*t8+1.38490
     4         26450902355d+3*t35*t4*t52*t8+1.0128444160767991d+1*t40*t5
     5         4*t67-2.0256888321535982d+1*t35*t37*t53*t67+3.03853324823
     6         0397d+1*t35*t37*t52*t67-3.038533248230397d+1*t32*t34*t52*
     7         t67+4.0513776643071964d+1*t32*t34*t51*t67-4.0513776643071
     8         964d+1*t29*t31*t51*t67+5.064222080383994d+1*t29*t31*t50*t
     9         67-5.064222080383994d+1*t26*t28*t50*t67+6.077066496460795
     :         d+1*t26*t28*t49*t67-6.077066496460795d+1*t23*t25*t49*t67+
     ;         7.089910912537593d+1*t23*t25*t48*t67-7.089910912537593d+1
     <         *t20*t22*t48*t67+8.102755328614393d+1*t20*t22*t47*t67-8.1
     =         02755328614393d+1*t17*t19*t47*t67+9.115599744691191d+1*t1
     >         7*t19*t46*t67-9.115599744691191d+1*t14*t16*t46*t67+1.0128
     ?         44416076799d+2*t14*t16*t45*t67-1.012844416076799d+2*t11*t
     @         13*t45*t67+1.1141288576844789d+2*t11*t13*t44*t67+2.538988
     1         1826654315d+4*t13*t4*t45*t57-5.585774001863949d+4*t13*t4*
     2         t44*t57-4.6163421503007845d+2*t38*t4*t54+4.61634215030078
     3         45d+2*t38*t4*t53+1.3849026450902355d+3*t32*t37*t4*t53-4.1
     4         547079352707067d+3*t32*t37*t4*t52+2.769805290180471d+3*t2
     5         9*t34*t4*t52+2.769805290180471d+3*t32*t37*t4*t51-7.386147
     6         440481255d+3*t29*t34*t4*t51+4.616342150300784d+3*t26*t31*
     7         t4*t51+4.616342150300784d+3*t29*t34*t4*t50-1.154085537575
     8         196d+4*t26*t31*t4*t50+6.924513225451178d+3*t23*t28*t4*t50
     9         +6.924513225451178d+3*t26*t31*t4*t49-1.661883174108283d+4
     :         *t23*t28*t4*t49+9.694318515631648d+3*t20*t25*t4*t49+9.694
     ;         318515631648d+3*t23*t28*t4*t48-2.2620076536473846d+4*t20*
     <         t25*t4*t48+1.2925758020842196d+4*t17*t22*t4*t48+1.2925758
     =         020842196d+4*t20*t25*t4*t47-2.954458976192502d+4*t17*t22*
     >         t4*t47+1.6618831741082823d+4*t14*t19*t4*t47+1.66188317410
     ?         82823d+4*t17*t22*t4*t46-3.7392371417436354d+4*t14*t19*t4*
     @         t46+2.0773539676353528d+4*t11*t16*t4*t46+2.07735396763535
     1         28d+4*t14*t19*t4*t45-4.616342150300784d+4*t11*t16*t4*t45+
     2         2.5389881826654315d+4*t11*t16*t4*t44
            t70 = gammaaa**2
            t71 = 1/t2**3
            t72 = 1/rhoa**6
            t73 = 1/rhoa**3.3333333333333337d+0
            t74 = 1/t56
            t75 = -4.135669939329334d-1*t43*t55-4.135669939329334d-1*t3*
     1         t41
            t76 = 1/rhoa**5
            t77 = 1/rhoa**4
            t78 = 4.0108638876641245d+3*t5*t56*t66*t9+6.077066496460795d
     1         +1*t35*t39*t56*t8-1.8231199489382385d+2*t33*t35*t56*t8+3.
     2         342386573053437d+3*t12*t13*t56*t57-3.342386573053437d+3*t
     3         11*t16*t5*t56-6.077066496460795d+1*t36*t38*t56+1.82311994
     4         89382385d+2*t32*t36*t37*t56-3.646239897876477d+2*t30*t32*
     5         t37*t56+3.646239897876477d+2*t29*t33*t34*t56-6.0770664964
     6         60795d+2*t27*t29*t34*t56+6.077066496460795d+2*t26*t30*t31
     7         *t56-9.115599744691192d+2*t24*t26*t31*t56+9.1155997446911
     8         92d+2*t23*t27*t28*t56-1.276183964256767d+3*t21*t23*t28*t5
     9         6+1.276183964256767d+3*t20*t24*t25*t56-1.7015786190090226
     :         d+3*t18*t20*t25*t56+1.7015786190090226d+3*t17*t21*t22*t56
     ;         -2.187743938725886d+3*t15*t17*t22*t56+2.187743938725886d+
     <         3*t14*t18*t19*t56-2.734679923407357d+3*t12*t14*t19*t56+2.
     =         734679923407357d+3*t11*t15*t16*t56
            t79 = 4.0108638876641245d+3*t44*t56*t66*t9+6.077066496460795
     1         d+1*t35*t54*t56*t8-1.8231199489382385d+2*t35*t52*t56*t8+3
     2         .342386573053437d+3*t13*t45*t56*t57-6.077066496460795d+1*
     3         t38*t53*t56+1.8231199489382385d+2*t32*t37*t53*t56+3.64623
     4         9897876477d+2*t29*t34*t52*t56-3.646239897876477d+2*t32*t3
     5         7*t51*t56+6.077066496460795d+2*t26*t31*t51*t56-6.07706649
     6         6460795d+2*t29*t34*t50*t56+9.115599744691192d+2*t23*t28*t
     7         50*t56-9.115599744691192d+2*t26*t31*t49*t56+1.27618396425
     8         6767d+3*t20*t25*t49*t56-1.276183964256767d+3*t23*t28*t48*
     9         t56+1.7015786190090226d+3*t17*t22*t48*t56-1.7015786190090
     :         226d+3*t20*t25*t47*t56+2.187743938725886d+3*t14*t19*t47*t
     ;         56-2.187743938725886d+3*t17*t22*t46*t56+2.734679923407357
     <         d+3*t11*t16*t46*t56-2.734679923407357d+3*t14*t19*t45*t56-
     =         3.342386573053437d+3*t11*t16*t44*t56
            t80 = 5.28d+2*t5*t66*t9+8.0d+0*t35*t39*t8+3.2d+1*t35*t36*t8+
     1         2.4d+1*t33*t35*t8+9.68d+2*t13*t5*t57+4.4d+2*t12*t13*t57+4
     2         .4d+2*t11*t16*t5+8.0d+0*t38*t39+8.0d+0*t36*t38+2.4d+1*t32
     3         *t36*t37+7.2d+1*t32*t33*t37+4.8d+1*t30*t32*t37+4.8d+1*t29
     4         *t33*t34+1.28d+2*t29*t30*t34+8.0d+1*t27*t29*t34+8.0d+1*t2
     5         6*t30*t31+2.0d+2*t26*t27*t31+1.2d+2*t24*t26*t31+1.2d+2*t2
     6         3*t27*t28+2.88d+2*t23*t24*t28+1.68d+2*t21*t23*t28+1.68d+2
     7         *t20*t24*t25+3.92d+2*t20*t21*t25+2.24d+2*t18*t20*t25+2.24
     8         d+2*t17*t21*t22+5.12d+2*t17*t18*t22+2.88d+2*t15*t17*t22+2
     9         .88d+2*t14*t18*t19+6.48d+2*t14*t15*t19+3.6d+2*t12*t14*t19
     :         +3.6d+2*t11*t15*t16+8.0d+2*t11*t12*t16
            t81 = 5.28d+2*t44*t66*t9+8.0d+0*t35*t54*t8+3.2d+1*t35*t53*t8
     1         +2.4d+1*t35*t52*t8+4.4d+2*t13*t45*t57+9.68d+2*t13*t44*t57
     2         +8.0d+0*t38*t54+8.0d+0*t38*t53+2.4d+1*t32*t37*t53+7.2d+1*
     3         t32*t37*t52+4.8d+1*t29*t34*t52+4.8d+1*t32*t37*t51+1.28d+2
     4         *t29*t34*t51+8.0d+1*t26*t31*t51+8.0d+1*t29*t34*t50+2.0d+2
     5         *t26*t31*t50+1.2d+2*t23*t28*t50+1.2d+2*t26*t31*t49+2.88d+
     6         2*t23*t28*t49+1.68d+2*t20*t25*t49+1.68d+2*t23*t28*t48+3.9
     7         2d+2*t20*t25*t48+2.24d+2*t17*t22*t48+2.24d+2*t20*t25*t47+
     8         5.12d+2*t17*t22*t47+2.88d+2*t14*t19*t47+2.88d+2*t17*t22*t
     9         46+6.48d+2*t14*t19*t46+3.6d+2*t11*t16*t46+3.6d+2*t14*t19*
     :         t45+8.0d+2*t11*t16*t45+4.4d+2*t11*t16*t44
            t82 = rhoa**2
            t83 = 1/t10**14
            t84 = gammaaa**3
            t85 = 1/t2**4
            t86 = 1/rhoa**9.666666666666666d+0
            t87 = 1/rhoa**7
            t88 = 1/rhoa**4.333333333333333d+0
            t89 = 1/rhoa**3.6666666666666664d+0
            t90 = 1/rhoa**8.666666666666666d+0
            t91 = 1/rhoa**7.666666666666667d+0
            t92 = 1/rhoa**6.666666666666667d+0
            fnc(iq) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t55-9.3052573
     1         63491002d-1*t3*t4*t41)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-1.2407009817988002d+0*t43*t55*t62-
     1         1.2407009817988002d+0*t3*t41*t62+8.963083509889702d-3*gam
     2         maaa*t41*t60*t61+5.041016444533138d-3*gammaaa*t42*t55*t61
     3         -9.305257363491002d-1*t4*t43*t59-9.305257363491002d-1*t3*
     4         t4*t58)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t41*t60*t63-
     1         1.890381166699927d-3*t42*t55*t63)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t65-9.
     1         305257363491002d-1*t3*t4*t64)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t74*t75-8.963083509889707d-3*ga
     1         mmaaa*t41*t60*t73-5.041016444533138d-3*gammaaa*t42*t55*t7
     2         3+2.1476348525932504d-4*t41*t70*t71*t72+4.947305865786653
     3         d-5*t42*t55*t70*t72-9.305257363491002d-1*t4*t43*t69-9.305
     4         257363491002d-1*t3*t4*t68-2.4814019635976003d+0*t43*t59*t
     5         62-2.4814019635976003d+0*t3*t58*t62+1.7926167019779404d-2
     6         *gammaaa*t58*t60*t61+1.0082032889066277d-2*gammaaa*t42*t5
     7         9*t61)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(-8.05363069722469d-5*gammaaa*t
     1         41*t71*t76-1.855239699669995d-5*gammaaa*t42*t55*t76-3.361
     2         156316208638d-3*t58*t60*t63-1.890381166699927d-3*t42*t59*
     3         t63+4.481541754944851d-3*t41*t60*t61+2.520508222266569d-3
     4         *t42*t55*t61)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(3.020111511459258d-5*t41*t71*
     1         t77+6.957148873762482d-6*t42*t55*t77)*wght+Cmat2(iq,D2_GA
     2         A_GAA)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t7
     1         9-9.305257363491002d-1*t3*t4*t78-1.2407009817988002d+0*t4
     2         3*t62*t65+5.041016444533138d-3*gammaaa*t42*t61*t65-1.2407
     3         009817988002d+0*t3*t62*t64+8.963083509889702d-3*gammaaa*t
     4         60*t61*t64)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-1.890381166699927d-3*t42*t63*
     1         t65-3.361156316208638d-3*t60*t63*t64)*wght+Mmat2(iq,D2_GA
     2         A_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t8
     1         1-9.305257363491002d-1*t3*t4*t80)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-6.01754400771653d+6*t5*t82*t83*t9+6.093571638397036d+4*
     2         t5*t62*t66*t9+3.713762858948263d+1*t5*t57*t63*t9-2.104036
     3         366334451d+4*t32*t39*t8*t82+1.2624218198006704d+5*t32*t36
     4         *t8*t82-1.8936327297010064d+5*t32*t33*t8*t82+8.4161454653
     5         37804d+4*t30*t32*t8*t82+1.5275304019588112d+7*t13*t5*t66*
     6         t82-4.628880005935792d+6*t12*t13*t66*t82-1.27294200163234
     7         26d+7*t16*t5*t57*t82-3.4716600044518436d+6*t15*t16*t57*t8
     8         2+1.1572200014839477d+7*t12*t16*t57*t82+3.471660004451843
     9         6d+6*t11*t19*t5*t82+2.104036366334451d+4*t35*t39*t82-8.41
     :         6145465337804d+4*t29*t36*t37*t82+3.787265459402013d+5*t29
     ;         *t33*t37*t82-5.049687279202681d+5*t29*t30*t37*t82+2.10403
     <         63663344508d+5*t27*t29*t37*t82-4.208072732668902d+4*t35*t
     =         36*t82+2.104036366334451d+4*t33*t35*t82-2.104036366334451
     >         d+5*t26*t33*t34*t82+8.416145465337803d+5*t26*t30*t34*t82-
     ?         1.0520181831672254d+6*t26*t27*t34*t82+4.208072732668902d+
     @         5*t24*t26*t34*t82-4.2080727326689016d+5*t23*t30*t31*t82+1
     1         .578027274750838d+6*t23*t27*t31*t82-1.893632729701006d+6*
     2         t23*t24*t31*t82+7.364127282170578d+5*t21*t23*t31*t82-7.36
     3         4127282170578d+5*t20*t27*t28*t82+2.6510858215814087d+6*t2
     4         0*t24*t28*t82-3.0929334585116436d+6*t20*t21*t28*t82+1.178
     5         2603651472927d+6*t18*t20*t28*t82-1.1782603651472927d+6*t1
     6         7*t24*t25*t82+4.123911278015524d+6*t17*t21*t25*t82-4.7130
     7         41460589171d+6*t17*t18*t25*t82+1.767390547720939d+6*t15*t
     8         17*t25*t82-1.7673905477209387d+6*t14*t21*t22*t82+6.059624
     9         735043219d+6*t14*t18*t22*t82-6.817077826923622d+6*t14*t15
     :         *t22*t82+2.524843639601341d+6*t12*t14*t22*t82-2.524843639
     ;         601341d+6*t11*t18*t19*t82+8.521347283654526d+6*t11*t15*t1
     <         9*t82-9.468163648505028d+6*t11*t12*t19*t82+3.376148053589
     =         33d+0*t38*t39*t63*t8-6.75229610717866d+0*t36*t38*t63*t8+9
     >         .232684300601568d+2*t35*t39*t62*t8-3.693073720240627d+3*t
     ?         35*t36*t62*t8+2.769805290180471d+3*t33*t35*t62*t8-3.71376
     @         2858948263d+1*t11*t13*t5*t63-3.37614805358933d+0*t39*t40*
     1         t63+6.75229610717866d+0*t35*t36*t37*t63-1.012844416076799
     2         1d+1*t33*t35*t37*t63+1.0128444160767991d+1*t32*t33*t34*t6
     3         3-1.350459221435732d+1*t30*t32*t34*t63+1.350459221435732d
     4         +1*t29*t30*t31*t63-1.6880740267946648d+1*t27*t29*t31*t63+
     5         1.6880740267946648d+1*t26*t27*t28*t63-2.0256888321535982d
     6         +1*t24*t26*t28*t63+2.0256888321535982d+1*t23*t24*t25*t63-
     7         2.3633036375125308d+1*t21*t23*t25*t63+2.3633036375125308d
     8         +1*t20*t21*t22*t63-2.700918442871464d+1*t18*t20*t22*t63+2
     9         .700918442871464d+1*t17*t18*t19*t63-3.0385332482303967d+1
     :         *t15*t17*t19*t63+3.0385332482303967d+1*t14*t15*t16*t63-3.
     ;         3761480535893296d+1*t12*t14*t16*t63+3.3761480535893296d+1
     <         *t11*t12*t13*t63-1.1171548003727898d+5*t13*t5*t57*t62+5.0
     =         77976365330862d+4*t12*t13*t57*t62+5.077976365330863d+4*t1
     >         1*t16*t5*t62-9.232684300601568d+2*t38*t39*t62+9.232684300
     ?         601568d+2*t36*t38*t62+2.769805290180471d+3*t32*t36*t37*t6
     @         2-8.309415870541413d+3*t32*t33*t37*t62+5.539610580360942d
     1         +3*t30*t32*t37*t62+5.539610580360942d+3*t29*t33*t34*t62-1
     2         .4772294880962508d+4*t29*t30*t34*t62+9.232684300601568d+3
     3         *t27*t29*t34*t62+9.232684300601568d+3*t26*t30*t31*t62-2.3
     4         08171075150392d+4*t26*t27*t31*t62+1.3849026450902355d+4*t
     5         24*t26*t31*t62+1.3849026450902355d+4*t23*t27*t28*t62-3.32
     6         3766348216566d+4*t23*t24*t28*t62+1.9388637031263292d+4*t2
     7         1*t23*t28*t62+1.9388637031263292d+4*t20*t24*t25*t62-4.524
     8         0153072947686d+4*t20*t21*t25*t62+2.585151604168439d+4*t18
     9         *t20*t25*t62+2.585151604168439d+4*t17*t21*t22*t62-5.90891
     :         7952385003d+4*t17*t18*t22*t62+3.3237663482165647d+4*t15*t
     ;         17*t22*t62+3.3237663482165647d+4*t14*t18*t19*t62-7.478474
     <         283487271d+4*t14*t15*t19*t62+4.154707935270705d+4*t12*t14
     =         *t19*t62+4.1547079352707056d+4*t11*t15*t16*t62-9.23268430
     >         0601568d+4*t11*t12*t16*t62)-9.305257363491002d-1*t4*t43*(
     ?         -6.01754400771653d+6*t44*t82*t83*t9+6.093571638397036d+4*
     @         t44*t62*t66*t9+3.713762858948263d+1*t44*t57*t63*t9-2.1040
     1         36366334451d+4*t32*t54*t8*t82+1.2624218198006704d+5*t32*t
     2         53*t8*t82-1.8936327297010064d+5*t32*t52*t8*t82+8.41614546
     3         5337804d+4*t32*t51*t8*t82-4.628880005935792d+6*t13*t45*t6
     4         6*t82+1.5275304019588112d+7*t13*t44*t66*t82-3.47166000445
     5         18436d+6*t16*t46*t57*t82+1.1572200014839477d+7*t16*t45*t5
     6         7*t82-1.2729420016323426d+7*t16*t44*t57*t82+2.10403636633
     7         4451d+4*t35*t54*t82-8.416145465337804d+4*t29*t37*t53*t82-
     8         4.208072732668902d+4*t35*t53*t82+3.787265459402013d+5*t29
     9         *t37*t52*t82+2.104036366334451d+4*t35*t52*t82-2.104036366
     :         334451d+5*t26*t34*t52*t82-5.049687279202681d+5*t29*t37*t5
     ;         1*t82+8.416145465337803d+5*t26*t34*t51*t82-4.208072732668
     <         9016d+5*t23*t31*t51*t82+2.1040363663344508d+5*t29*t37*t50
     =         *t82-1.0520181831672254d+6*t26*t34*t50*t82+1.578027274750
     >         838d+6*t23*t31*t50*t82-7.364127282170578d+5*t20*t28*t50*t
     ?         82+4.208072732668902d+5*t26*t34*t49*t82-1.893632729701006
     @         d+6*t23*t31*t49*t82+2.6510858215814087d+6*t20*t28*t49*t82
     1         -1.1782603651472927d+6*t17*t25*t49*t82+7.364127282170578d
     2         +5*t23*t31*t48*t82-3.0929334585116436d+6*t20*t28*t48*t82+
     3         4.123911278015524d+6*t17*t25*t48*t82-1.7673905477209387d+
     4         6*t14*t22*t48*t82+1.1782603651472927d+6*t20*t28*t47*t82-4
     5         .713041460589171d+6*t17*t25*t47*t82+6.059624735043219d+6*
     6         t14*t22*t47*t82-2.524843639601341d+6*t11*t19*t47*t82+1.76
     7         7390547720939d+6*t17*t25*t46*t82-6.817077826923622d+6*t14
     8         *t22*t46*t82+8.521347283654526d+6*t11*t19*t46*t82+2.52484
     9         3639601341d+6*t14*t22*t45*t82-9.468163648505028d+6*t11*t1
     :         9*t45*t82+3.4716600044518436d+6*t11*t19*t44*t82+3.3761480
     ;         5358933d+0*t38*t54*t63*t8-6.75229610717866d+0*t38*t53*t63
     <         *t8+9.232684300601568d+2*t35*t54*t62*t8-3.693073720240627
     =         d+3*t35*t53*t62*t8+2.769805290180471d+3*t35*t52*t62*t8-3.
     >         37614805358933d+0*t40*t54*t63+6.75229610717866d+0*t35*t37
     ?         *t53*t63-1.0128444160767991d+1*t35*t37*t52*t63+1.01284441
     @         60767991d+1*t32*t34*t52*t63-1.350459221435732d+1*t32*t34*
     1         t51*t63+1.350459221435732d+1*t29*t31*t51*t63-1.6880740267
     2         946648d+1*t29*t31*t50*t63+1.6880740267946648d+1*t26*t28*t
     3         50*t63-2.0256888321535982d+1*t26*t28*t49*t63+2.0256888321
     4         535982d+1*t23*t25*t49*t63-2.3633036375125308d+1*t23*t25*t
     5         48*t63+2.3633036375125308d+1*t20*t22*t48*t63-2.7009184428
     6         71464d+1*t20*t22*t47*t63+2.700918442871464d+1*t17*t19*t47
     7         *t63-3.0385332482303967d+1*t17*t19*t46*t63+3.038533248230
     8         3967d+1*t14*t16*t46*t63-3.3761480535893296d+1*t14*t16*t45
     9         *t63+3.3761480535893296d+1*t11*t13*t45*t63-3.713762858948
     :         263d+1*t11*t13*t44*t63+5.077976365330862d+4*t13*t45*t57*t
     ;         62-1.1171548003727898d+5*t13*t44*t57*t62-9.23268430060156
     <         8d+2*t38*t54*t62+9.232684300601568d+2*t38*t53*t62+2.76980
     =         5290180471d+3*t32*t37*t53*t62-8.309415870541413d+3*t32*t3
     >         7*t52*t62+5.539610580360942d+3*t29*t34*t52*t62+5.53961058
     ?         0360942d+3*t32*t37*t51*t62-1.4772294880962508d+4*t29*t34*
     @         t51*t62+9.232684300601568d+3*t26*t31*t51*t62+9.2326843006
     1         01568d+3*t29*t34*t50*t62-2.308171075150392d+4*t26*t31*t50
     2         *t62+1.3849026450902355d+4*t23*t28*t50*t62+1.384902645090
     3         2355d+4*t26*t31*t49*t62-3.323766348216566d+4*t23*t28*t49*
     4         t62+1.9388637031263292d+4*t20*t25*t49*t62+1.9388637031263
     5         292d+4*t23*t28*t48*t62-4.5240153072947686d+4*t20*t25*t48*
     6         t62+2.585151604168439d+4*t17*t22*t48*t62+2.58515160416843
     7         9d+4*t20*t25*t47*t62-5.908917952385003d+4*t17*t22*t47*t62
     8         +3.3237663482165647d+4*t14*t19*t47*t62+3.3237663482165647
     9         d+4*t17*t22*t46*t62-7.478474283487271d+4*t14*t19*t46*t62+
     :         4.1547079352707056d+4*t11*t16*t46*t62+4.154707935270705d+
     ;         4*t14*t19*t45*t62-9.232684300601568d+4*t11*t16*t45*t62+5.
     <         077976365330863d+4*t11*t16*t44*t62)+t74*(3.98359267106208
     =         9d-3*gammaaa*t41*t60*t89+2.2404517531258392d-3*gammaaa*t4
     >         2*t55*t89-1.2407009817988002d+0*t43*t59-1.240700981798800
     ?         2d+0*t3*t58)+2.987694503296569d-2*gammaaa*t41*t60*t88+1.6
     @         803388148443793d-2*gammaaa*t42*t55*t88-1.5033443968152754
     1         d-3*t41*t70*t71*t87-3.4631141060506576d-4*t42*t55*t70*t87
     2         +7.718887347725925d-6*t41*t84*t85*t86+4.855337331063556d-
     3         7*t42*t55*t84*t86-6.666666666666666d-1*t75/t6-2.688925052
     4         9669123d-2*gammaaa*t58*t60*t73-1.5123049333599414d-2*gamm
     5         aaa*t42*t59*t73+6.442904557779751d-4*t58*t70*t71*t72+1.48
     6         4191759735996d-4*t42*t59*t70*t72-3.7221029453964005d+0*t4
     7         3*t62*t69+1.5123049333599414d-2*gammaaa*t42*t61*t69-3.722
     8         1029453964005d+0*t3*t62*t68+2.6889250529669106d-2*gammaaa
     9         *t60*t61*t68)*wght+Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(-2.8945827553972214d-6*t41*
     1         t70*t85*t90-1.8207514991488338d-7*t42*t55*t70*t90-1.61072
     2         6139444938d-4*gammaaa*t58*t71*t76-3.71047939933999d-5*gam
     3         maaa*t42*t59*t76+(-1.4938472516482837d-3*t1*t41*t60-8.401
     4         694074221898d-4*t1*t42*t55)*t74-8.963083509889707d-3*t41*
     5         t60*t73-5.041016444533138d-3*t42*t55*t73+5.10063277490897
     6         1d-4*gammaaa*t41*t71*t72+1.1749851431243302d-4*gammaaa*t4
     7         2*t55*t72-1.890381166699927d-3*t42*t63*t69-3.361156316208
     8         638d-3*t60*t63*t68+8.963083509889702d-3*t58*t60*t61+5.041
     9         016444533138d-3*t42*t59*t61)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(1.0854685332739583d-6*gamm
     1         aaa*t41*t85*t91+6.827818121808127d-8*gammaaa*t42*t55*t91+
     2         3.020111511459258d-5*t58*t71*t77+6.957148873762482d-6*t42
     3         *t59*t77-1.2080446045837034d-4*t41*t71*t76-2.782859549504
     4         9924d-5*t42*t55*t76)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(-4.070506999777343d-7*t41
     1         *t85*t92-2.560431795678048d-8*t42*t55*t92)*wght+Cmat3(iq,
     2         D3_GAA_GAA_GAA)
            Mmat3(iq,D3_RA_RA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-7.921643129916147d+5*t4*t5*t83*t9+2.6739092584427493d+3
     2         *t5*t66*t67*t9+4.0513776643071964d+1*t35*t39*t67*t8-1.215
     3         4132992921589d+2*t33*t35*t67*t8-2.769805290180471d+3*t32*
     4         t39*t4*t8+5.539610580360942d+3*t32*t36*t4*t8+8.3094158705
     5         41416d+3*t32*t33*t4*t8-1.1079221160721883d+4*t30*t32*t4*t
     6         8+2.2282577153689576d+3*t12*t13*t57*t67-2.228257715368958
     7         d+3*t11*t16*t5*t67-4.0513776643071964d+1*t36*t38*t67+1.21
     8         54132992921589d+2*t32*t36*t37*t67-2.4308265985843178d+2*t
     9         30*t32*t37*t67+2.4308265985843178d+2*t29*t33*t34*t67-4.05
     :         1377664307196d+2*t27*t29*t34*t67+4.0513776643071964d+2*t2
     ;         6*t30*t31*t67-6.077066496460795d+2*t24*t26*t31*t67+6.0770
     <         66496460793d+2*t23*t27*t28*t67-8.507893095045111d+2*t21*t
     =         23*t28*t67+8.507893095045113d+2*t20*t24*t25*t67-1.1343857
     >         460060149d+3*t18*t20*t25*t67+1.1343857460060149d+3*t17*t2
     ?         1*t22*t67-1.4584959591505905d+3*t15*t17*t22*t67+1.4584959
     @         591505908d+3*t14*t18*t19*t67-1.8231199489382383d+3*t12*t1
     1         4*t19*t67+1.8231199489382383d+3*t11*t15*t16*t67+6.7029288
     2         02236738d+5*t13*t4*t5*t66-6.093571638397035d+5*t12*t13*t4
     3         *t66+5.585774001863949d+5*t16*t4*t5*t57-4.570178728797776
     4         3d+5*t15*t16*t4*t57+5.077976365330863d+5*t12*t16*t4*t57-4
     5         .5701787287977763d+5*t11*t19*t4*t5+9.232684300601569d+2*t
     6         35*t39*t4-1.1079221160721883d+4*t29*t36*t37*t4+1.66188317
     7         41082832d+4*t29*t33*t37*t4+2.2158442321443766d+4*t29*t30*
     8         t37*t4-2.7698052901804704d+4*t27*t29*t37*t4+1.84653686012
     9         0314d+3*t35*t36*t4-2.769805290180471d+3*t33*t35*t4-2.7698
     :         05290180471d+4*t26*t33*t34*t4+3.693073720240629d+4*t26*t3
     ;         0*t34*t4+4.616342150300784d+4*t26*t27*t34*t4-5.5396105803
     <         60942d+4*t24*t26*t34*t4-5.539610580360941d+4*t23*t30*t31*
     =         t4+6.924513225451174d+4*t23*t27*t31*t4+8.309415870541416d
     >         +4*t23*t24*t31*t4-9.694318515631648d+4*t21*t23*t31*t4-9.6
     ?         94318515631648d+4*t20*t27*t28*t4+1.1633182218757979d+5*t2
     @         0*t24*t28*t4+1.3572045921884307d+5*t20*t21*t28*t4-1.55109
     1         09625010635d+5*t18*t20*t28*t4-1.5510909625010638d+5*t17*t
     2         24*t25*t4+1.809606122917908d+5*t17*t21*t25*t4+2.068121283
     3         3347515d+5*t17*t18*t25*t4-2.3266364437515952d+5*t15*t17*t
     4         25*t4-2.3266364437515955d+5*t14*t21*t22*t4+2.659013078573
     5         252d+5*t14*t18*t22*t4+2.9913897133949086d+5*t14*t15*t22*t
     6         4-3.3237663482165647d+5*t12*t14*t22*t4-3.323766348216565d
     7         +5*t11*t18*t19*t4+3.7392371417436354d+5*t11*t15*t19*t4+4.
     8         1547079352707056d+5*t11*t12*t19*t4)-9.305257363491002d-1*
     9         t4*t43*(-7.921643129916147d+5*t4*t44*t83*t9+2.67390925844
     :         27493d+3*t44*t66*t67*t9+4.0513776643071964d+1*t35*t54*t67
     ;         *t8-1.2154132992921589d+2*t35*t52*t67*t8-2.76980529018047
     <         1d+3*t32*t4*t54*t8+5.539610580360942d+3*t32*t4*t53*t8+8.3
     =         09415870541416d+3*t32*t4*t52*t8-1.1079221160721883d+4*t32
     >         *t4*t51*t8+2.2282577153689576d+3*t13*t45*t57*t67-4.051377
     ?         6643071964d+1*t38*t53*t67+1.2154132992921589d+2*t32*t37*t
     @         53*t67+2.4308265985843178d+2*t29*t34*t52*t67-2.4308265985
     1         843178d+2*t32*t37*t51*t67+4.0513776643071964d+2*t26*t31*t
     2         51*t67-4.051377664307196d+2*t29*t34*t50*t67+6.07706649646
     3         0793d+2*t23*t28*t50*t67-6.077066496460795d+2*t26*t31*t49*
     4         t67+8.507893095045113d+2*t20*t25*t49*t67-8.50789309504511
     5         1d+2*t23*t28*t48*t67+1.1343857460060149d+3*t17*t22*t48*t6
     6         7-1.1343857460060149d+3*t20*t25*t47*t67+1.458495959150590
     7         8d+3*t14*t19*t47*t67-1.4584959591505905d+3*t17*t22*t46*t6
     8         7+1.8231199489382383d+3*t11*t16*t46*t67-1.823119948938238
     9         3d+3*t14*t19*t45*t67-2.228257715368958d+3*t11*t16*t44*t67
     :         -6.093571638397035d+5*t13*t4*t45*t66+6.702928802236738d+5
     ;         *t13*t4*t44*t66-4.5701787287977763d+5*t16*t4*t46*t57+5.07
     <         7976365330863d+5*t16*t4*t45*t57+5.585774001863949d+5*t16*
     =         t4*t44*t57+9.232684300601569d+2*t35*t4*t54-1.107922116072
     >         1883d+4*t29*t37*t4*t53+1.846536860120314d+3*t35*t4*t53+1.
     ?         6618831741082832d+4*t29*t37*t4*t52-2.769805290180471d+3*t
     @         35*t4*t52-2.769805290180471d+4*t26*t34*t4*t52+2.215844232
     1         1443766d+4*t29*t37*t4*t51+3.693073720240629d+4*t26*t34*t4
     2         *t51-5.539610580360941d+4*t23*t31*t4*t51-2.76980529018047
     3         04d+4*t29*t37*t4*t50+4.616342150300784d+4*t26*t34*t4*t50+
     4         6.924513225451174d+4*t23*t31*t4*t50-9.694318515631648d+4*
     5         t20*t28*t4*t50-5.539610580360942d+4*t26*t34*t4*t49+8.3094
     6         15870541416d+4*t23*t31*t4*t49+1.1633182218757979d+5*t20*t
     7         28*t4*t49-1.5510909625010638d+5*t17*t25*t4*t49-9.69431851
     8         5631648d+4*t23*t31*t4*t48+1.3572045921884307d+5*t20*t28*t
     9         4*t48+1.809606122917908d+5*t17*t25*t4*t48-2.3266364437515
     :         955d+5*t14*t22*t4*t48-1.5510909625010635d+5*t20*t28*t4*t4
     ;         7+2.0681212833347515d+5*t17*t25*t4*t47+2.659013078573252d
     <         +5*t14*t22*t4*t47-3.323766348216565d+5*t11*t19*t4*t47-2.3
     =         266364437515952d+5*t17*t25*t4*t46+2.9913897133949086d+5*t
     >         14*t22*t4*t46+3.7392371417436354d+5*t11*t19*t4*t46-3.3237
     ?         663482165647d+5*t14*t22*t4*t45+4.1547079352707056d+5*t11*
     @         t19*t4*t45-4.5701787287977763d+5*t11*t19*t4*t44)-2.481401
     1         9635976003d+0*t43*t62*t79+1.0082032889066277d-2*gammaaa*t
     2         42*t61*t79-2.4814019635976003d+0*t3*t62*t78+1.79261670197
     3         79404d-2*gammaaa*t60*t61*t78+(-4.135669939329334d-1*t43*t
     4         65-4.135669939329334d-1*t3*t64)*t74-5.041016444533138d-3*
     5         gammaaa*t42*t65*t73-8.963083509889707d-3*gammaaa*t60*t64*
     6         t73+2.1476348525932504d-4*t64*t70*t71*t72+4.9473058657866
     7         53d-5*t42*t65*t70*t72)*wght+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_GAA_TA) = 1.0d+0*(-1.890381166699927d-3*t42*t
     1         63*t79-3.361156316208638d-3*t60*t63*t78-8.05363069722469d
     2         -5*gammaaa*t64*t71*t76-1.855239699669995d-5*gammaaa*t42*t
     3         65*t76+2.520508222266569d-3*t42*t61*t65+4.481541754944851
     4         d-3*t60*t61*t64)*wght+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = 1.0d+0*(3.020111511459258d-5*t64*t
     1         71*t77+6.957148873762482d-6*t42*t65*t77)*wght+Mmat3(iq,D3
     2         _GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_RA_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-1.0428246107926724d+5*t5*t56*t83*t9-3.646239897876477d+
     2         2*t32*t39*t56*t8-7.292479795752954d+2*t32*t36*t56*t8+1.09
     3         38719693629433d+3*t32*t33*t56*t8+1.4584959591505908d+3*t3
     4         0*t32*t56*t8-8.823900552861074d+4*t13*t5*t56*t66-8.021727
     5         775328248d+4*t12*t13*t56*t66+7.353250460717561d+4*t16*t5*
     6         t56*t57-6.016295831496187d+4*t15*t16*t56*t57-6.6847731461
     7         06873d+4*t12*t16*t56*t57+6.016295831496187d+4*t11*t19*t5*
     8         t56-1.2154132992921589d+2*t35*t39*t56-1.4584959591505908d
     9         +3*t29*t36*t37*t56-2.1877439387258865d+3*t29*t33*t37*t56+
     :         2.9169919183011817d+3*t29*t30*t37*t56+3.646239897876477d+
     ;         3*t27*t29*t37*t56+2.4308265985843178d+2*t35*t36*t56+3.646
     <         239897876477d+2*t33*t35*t56-3.646239897876477d+3*t26*t33*
     =         t34*t56-4.8616531971686355d+3*t26*t30*t34*t56+6.077066496
     >         460795d+3*t26*t27*t34*t56+7.292479795752954d+3*t24*t26*t3
     ?         4*t56-7.292479795752954d+3*t23*t30*t31*t56-9.115599744691
     @         192d+3*t23*t27*t31*t56+1.0938719693629431d+4*t23*t24*t31*
     1         t56+1.2761839642567668d+4*t21*t23*t31*t56-1.2761839642567
     2         668d+4*t20*t27*t28*t56-1.5314207571081204d+4*t20*t24*t28*
     3         t56+1.786657549959474d+4*t20*t21*t28*t56+2.04189434281082
     4         72d+4*t18*t20*t28*t56-2.0418943428108272d+4*t17*t24*t25*t
     5         56-2.3822100666126317d+4*t17*t21*t25*t56+2.72252579041443
     6         6d+4*t17*t18*t25*t56+3.062841514216241d+4*t15*t17*t25*t56
     7         -3.062841514216241d+4*t14*t21*t22*t56-3.5003903019614174d
     8         +4*t14*t18*t22*t56+3.9379390897065947d+4*t14*t15*t22*t56+
     9         4.375487877451772d+4*t12*t14*t22*t56-4.375487877451772d+4
     :         *t11*t18*t19*t56-4.9224238621332433d+4*t11*t15*t19*t56+5.
     ;         469359846814714d+4*t11*t12*t19*t56)-9.305257363491002d-1*
     <         t4*t43*(-1.0428246107926724d+5*t44*t56*t83*t9-3.646239897
     =         876477d+2*t32*t54*t56*t8-7.292479795752954d+2*t32*t53*t56
     >         *t8+1.0938719693629433d+3*t32*t52*t56*t8+1.45849595915059
     ?         08d+3*t32*t51*t56*t8-8.021727775328248d+4*t13*t45*t56*t66
     @         -8.823900552861074d+4*t13*t44*t56*t66-6.016295831496187d+
     1         4*t16*t46*t56*t57-6.684773146106873d+4*t16*t45*t56*t57+7.
     2         353250460717561d+4*t16*t44*t56*t57-1.2154132992921589d+2*
     3         t35*t54*t56-1.4584959591505908d+3*t29*t37*t53*t56+2.43082
     4         65985843178d+2*t35*t53*t56-2.1877439387258865d+3*t29*t37*
     5         t52*t56+3.646239897876477d+2*t35*t52*t56-3.64623989787647
     6         7d+3*t26*t34*t52*t56+2.9169919183011817d+3*t29*t37*t51*t5
     7         6-4.8616531971686355d+3*t26*t34*t51*t56-7.292479795752954
     8         d+3*t23*t31*t51*t56+3.646239897876477d+3*t29*t37*t50*t56+
     9         6.077066496460795d+3*t26*t34*t50*t56-9.115599744691192d+3
     :         *t23*t31*t50*t56-1.2761839642567668d+4*t20*t28*t50*t56+7.
     ;         292479795752954d+3*t26*t34*t49*t56+1.0938719693629431d+4*
     <         t23*t31*t49*t56-1.5314207571081204d+4*t20*t28*t49*t56-2.0
     =         418943428108272d+4*t17*t25*t49*t56+1.2761839642567668d+4*
     >         t23*t31*t48*t56+1.786657549959474d+4*t20*t28*t48*t56-2.38
     ?         22100666126317d+4*t17*t25*t48*t56-3.062841514216241d+4*t1
     @         4*t22*t48*t56+2.0418943428108272d+4*t20*t28*t47*t56+2.722
     1         525790414436d+4*t17*t25*t47*t56-3.5003903019614174d+4*t14
     2         *t22*t47*t56-4.375487877451772d+4*t11*t19*t47*t56+3.06284
     3         1514216241d+4*t17*t25*t46*t56+3.9379390897065947d+4*t14*t
     4         22*t46*t56-4.9224238621332433d+4*t11*t19*t46*t56+4.375487
     5         877451772d+4*t14*t22*t45*t56+5.469359846814714d+4*t11*t19
     6         *t45*t56+6.016295831496187d+4*t11*t19*t44*t56)-1.24070098
     7         17988002d+0*t43*t62*t81+5.041016444533138d-3*gammaaa*t42*
     8         t61*t81-1.2407009817988002d+0*t3*t62*t80+8.96308350988970
     9         2d-3*gammaaa*t60*t61*t80)*wght+Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = 1.0d+0*(-1.890381166699927d-3*t42*t
     1         63*t81-3.361156316208638d-3*t60*t63*t80)*wght+Mmat3(iq,D3
     2         _GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-1.3728d+4*t5*t83*t9-4.8d+1*t32*t39*t8-2.88d+2*t32*t36*t
     2         8-4.32d+2*t32*t33*t8-1.92d+2*t30*t32*t8-3.4848d+4*t13*t5*
     3         t66-1.056d+4*t12*t13*t66-2.904d+4*t16*t5*t57-7.92d+3*t15*
     4         t16*t57-2.64d+4*t12*t16*t57-7.92d+3*t11*t19*t5-4.8d+1*t35
     5         *t39-1.92d+2*t29*t36*t37-8.64d+2*t29*t33*t37-1.152d+3*t29
     6         *t30*t37-4.8d+2*t27*t29*t37-9.6d+1*t35*t36-4.8d+1*t33*t35
     7         -4.8d+2*t26*t33*t34-1.92d+3*t26*t30*t34-2.4d+3*t26*t27*t3
     8         4-9.6d+2*t24*t26*t34-9.6d+2*t23*t30*t31-3.6d+3*t23*t27*t3
     9         1-4.32d+3*t23*t24*t31-1.68d+3*t21*t23*t31-1.68d+3*t20*t27
     :         *t28-6.048d+3*t20*t24*t28-7.056d+3*t20*t21*t28-2.688d+3*t
     ;         18*t20*t28-2.688d+3*t17*t24*t25-9.408d+3*t17*t21*t25-1.07
     <         52d+4*t17*t18*t25-4.032d+3*t15*t17*t25-4.032d+3*t14*t21*t
     =         22-1.3824d+4*t14*t18*t22-1.5552d+4*t14*t15*t22-5.76d+3*t1
     >         2*t14*t22-5.76d+3*t11*t18*t19-1.944d+4*t11*t15*t19-2.16d+
     ?         4*t11*t12*t19)-9.305257363491002d-1*t4*t43*(-1.3728d+4*t4
     @         4*t83*t9-4.8d+1*t32*t54*t8-2.88d+2*t32*t53*t8-4.32d+2*t32
     1         *t52*t8-1.92d+2*t32*t51*t8-1.056d+4*t13*t45*t66-3.4848d+4
     2         *t13*t44*t66-7.92d+3*t16*t46*t57-2.64d+4*t16*t45*t57-2.90
     3         4d+4*t16*t44*t57-4.8d+1*t35*t54-1.92d+2*t29*t37*t53-9.6d+
     4         1*t35*t53-8.64d+2*t29*t37*t52-4.8d+1*t35*t52-4.8d+2*t26*t
     5         34*t52-1.152d+3*t29*t37*t51-1.92d+3*t26*t34*t51-9.6d+2*t2
     6         3*t31*t51-4.8d+2*t29*t37*t50-2.4d+3*t26*t34*t50-3.6d+3*t2
     7         3*t31*t50-1.68d+3*t20*t28*t50-9.6d+2*t26*t34*t49-4.32d+3*
     8         t23*t31*t49-6.048d+3*t20*t28*t49-2.688d+3*t17*t25*t49-1.6
     9         8d+3*t23*t31*t48-7.056d+3*t20*t28*t48-9.408d+3*t17*t25*t4
     :         8-4.032d+3*t14*t22*t48-2.688d+3*t20*t28*t47-1.0752d+4*t17
     ;         *t25*t47-1.3824d+4*t14*t22*t47-5.76d+3*t11*t19*t47-4.032d
     <         +3*t17*t25*t46-1.5552d+4*t14*t22*t46-1.944d+4*t11*t19*t46
     =         -5.76d+3*t14*t22*t45-2.16d+4*t11*t19*t45-7.92d+3*t11*t19*
     >         t44))*wght+Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammabb*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhob**1.3333333333333333d+0
            t5 = param(12)
            t6 = rhob**1.6666666666666669d+0
            t7 = 9.115599744691192d+0*t6
            t8 = t7-2.0d+0*taub
            t9 = t8**11
            t10 = 2.0d+0*taub+t7
            t11 = 1/t10**11
            t12 = param(11)
            t13 = t8**10
            t14 = 1/t10**10
            t15 = param(10)
            t16 = t8**9
            t17 = 1/t10**9
            t18 = param(9)
            t19 = t8**8
            t20 = 1/t10**8
            t21 = param(8)
            t22 = t8**7
            t23 = 1/t10**7
            t24 = param(7)
            t25 = t8**6
            t26 = 1/t10**6
            t27 = param(6)
            t28 = t8**5
            t29 = 1/t10**5
            t30 = param(5)
            t31 = t8**4
            t32 = 1/t10**4
            t33 = param(4)
            t34 = t8**3
            t35 = 1/t10**3
            t36 = param(3)
            t37 = t8**2
            t38 = 1/t10**2
            t39 = param(2)
            t40 = 1/t10
            t41 = t11*t5*t9+t39*t40*t8+t36*t37*t38+t33*t34*t35+t30*t31*t
     1         32+t27*t28*t29+t24*t25*t26+t21*t22*t23+t18*t19*t20+t15*t1
     2         6*t17+t12*t13*t14+param(1)
            t42 = exp(-3.6802889260199856d-3*gammabb*t1)
            t43 = 5.52d-1*(1.0d+0-t42)+1.0d+0
            t44 = param(24)
            t45 = param(23)
            t46 = param(22)
            t47 = param(21)
            t48 = param(20)
            t49 = param(19)
            t50 = param(18)
            t51 = param(17)
            t52 = param(16)
            t53 = param(15)
            t54 = param(14)
            t55 = t11*t44*t9+t40*t54*t8+t37*t38*t53+t34*t35*t52+t31*t32*
     1         t51+t28*t29*t50+t25*t26*t49+t22*t23*t48+t19*t20*t47+t16*t
     2         17*t46+t13*t14*t45+param(13)
            t56 = rhob**6.666666666666666d-1
            t57 = 1/t10**12
            t58 = -1.6711932865267184d+2*t5*t56*t57*t9-1.519266624115198
     1         6d+1*t38*t39*t56*t8+3.038533248230397d+1*t36*t38*t56*t8+1
     2         .6711932865267184d+2*t11*t13*t5*t56+1.5192666241151986d+1
     3         *t39*t40*t56-3.038533248230397d+1*t35*t36*t37*t56+4.55779
     4         98723455965d+1*t33*t35*t37*t56-4.5577998723455965d+1*t32*
     5         t33*t34*t56+6.077066496460795d+1*t30*t32*t34*t56-6.077066
     6         496460795d+1*t29*t30*t31*t56+7.596333120575993d+1*t27*t29
     7         *t31*t56-7.596333120575993d+1*t26*t27*t28*t56+9.115599744
     8         691193d+1*t24*t26*t28*t56-9.115599744691193d+1*t23*t24*t2
     9         5*t56+1.0634866368806391d+2*t21*t23*t25*t56-1.06348663688
     :         06391d+2*t20*t21*t22*t56+1.2154132992921589d+2*t18*t20*t2
     ;         2*t56-1.2154132992921589d+2*t17*t18*t19*t56+1.36733996170
     <         36788d+2*t15*t17*t19*t56-1.3673399617036788d+2*t14*t15*t1
     =         6*t56+1.5192666241151986d+2*t12*t14*t16*t56-1.51926662411
     >         51986d+2*t11*t12*t13*t56
            t59 = -1.6711932865267184d+2*t44*t56*t57*t9-1.51926662411519
     1         86d+1*t38*t54*t56*t8+3.038533248230397d+1*t38*t53*t56*t8+
     2         1.5192666241151986d+1*t40*t54*t56-3.038533248230397d+1*t3
     3         5*t37*t53*t56+4.5577998723455965d+1*t35*t37*t52*t56-4.557
     4         7998723455965d+1*t32*t34*t52*t56+6.077066496460795d+1*t32
     5         *t34*t51*t56-6.077066496460795d+1*t29*t31*t51*t56+7.59633
     6         3120575993d+1*t29*t31*t50*t56-7.596333120575993d+1*t26*t2
     7         8*t50*t56+9.115599744691193d+1*t26*t28*t49*t56-9.11559974
     8         4691193d+1*t23*t25*t49*t56+1.0634866368806391d+2*t23*t25*
     9         t48*t56-1.0634866368806391d+2*t20*t22*t48*t56+1.215413299
     :         2921589d+2*t20*t22*t47*t56-1.2154132992921589d+2*t17*t19*
     ;         t47*t56+1.3673399617036788d+2*t17*t19*t46*t56-1.367339961
     <         7036788d+2*t14*t16*t46*t56+1.5192666241151986d+2*t14*t16*
     =         t45*t56-1.5192666241151986d+2*t11*t13*t45*t56+1.671193286
     >         5267184d+2*t11*t13*t44*t56
            t60 = 1/t2**2
            t61 = 1/rhob**2.3333333333333334d+0
            t62 = rhob**3.333333333333333d-1
            t63 = 1/t4
            t64 = -2.2d+1*t5*t57*t9-2.0d+0*t38*t39*t8-4.0d+0*t36*t38*t8-
     1         2.2d+1*t11*t13*t5-2.0d+0*t39*t40-4.0d+0*t35*t36*t37-6.0d+
     2         0*t33*t35*t37-6.0d+0*t32*t33*t34-8.0d+0*t30*t32*t34-8.0d+
     3         0*t29*t30*t31-1.0d+1*t27*t29*t31-1.0d+1*t26*t27*t28-1.2d+
     4         1*t24*t26*t28-1.2d+1*t23*t24*t25-1.4d+1*t21*t23*t25-1.4d+
     5         1*t20*t21*t22-1.6d+1*t18*t20*t22-1.6d+1*t17*t18*t19-1.8d+
     6         1*t15*t17*t19-1.8d+1*t14*t15*t16-2.0d+1*t12*t14*t16-2.0d+
     7         1*t11*t12*t13
            t65 = -2.2d+1*t44*t57*t9-2.0d+0*t38*t54*t8-4.0d+0*t38*t53*t8
     1         -2.0d+0*t40*t54-4.0d+0*t35*t37*t53-6.0d+0*t35*t37*t52-6.0
     2         d+0*t32*t34*t52-8.0d+0*t32*t34*t51-8.0d+0*t29*t31*t51-1.0
     3         d+1*t29*t31*t50-1.0d+1*t26*t28*t50-1.2d+1*t26*t28*t49-1.2
     4         d+1*t23*t25*t49-1.4d+1*t23*t25*t48-1.4d+1*t20*t22*t48-1.6
     5         d+1*t20*t22*t47-1.6d+1*t17*t19*t47-1.8d+1*t17*t19*t46-1.8
     6         d+1*t14*t16*t46-2.0d+1*t14*t16*t45-2.0d+1*t11*t13*t45-2.2
     7         d+1*t11*t13*t44
            t66 = 1/t10**13
            t67 = 1/t62
            t68 = -1.1141288576844789d+2*t5*t57*t67*t9+3.046785819198518
     1         d+4*t4*t5*t66*t9-1.0128444160767991d+1*t38*t39*t67*t8+2.0
     2         256888321535982d+1*t36*t38*t67*t8+4.6163421503007845d+2*t
     3         35*t39*t4*t8-1.846536860120314d+3*t35*t36*t4*t8+1.3849026
     4         450902355d+3*t33*t35*t4*t8+1.1141288576844789d+2*t11*t13*
     5         t5*t67+1.0128444160767991d+1*t39*t40*t67-2.02568883215359
     6         82d+1*t35*t36*t37*t67+3.038533248230397d+1*t33*t35*t37*t6
     7         7-3.038533248230397d+1*t32*t33*t34*t67+4.0513776643071964
     8         d+1*t30*t32*t34*t67-4.0513776643071964d+1*t29*t30*t31*t67
     9         +5.064222080383994d+1*t27*t29*t31*t67-5.064222080383994d+
     :         1*t26*t27*t28*t67+6.077066496460795d+1*t24*t26*t28*t67-6.
     ;         077066496460795d+1*t23*t24*t25*t67+7.089910912537593d+1*t
     <         21*t23*t25*t67-7.089910912537593d+1*t20*t21*t22*t67+8.102
     =         755328614393d+1*t18*t20*t22*t67-8.102755328614393d+1*t17*
     >         t18*t19*t67+9.115599744691191d+1*t15*t17*t19*t67-9.115599
     ?         744691191d+1*t14*t15*t16*t67+1.012844416076799d+2*t12*t14
     @         *t16*t67-1.012844416076799d+2*t11*t12*t13*t67-5.585774001
     1         863949d+4*t13*t4*t5*t57+2.5389881826654315d+4*t12*t13*t4*
     2         t57+2.5389881826654315d+4*t11*t16*t4*t5-4.616342150300784
     3         5d+2*t38*t39*t4+4.6163421503007845d+2*t36*t38*t4+1.384902
     4         6450902355d+3*t32*t36*t37*t4-4.1547079352707067d+3*t32*t3
     5         3*t37*t4+2.769805290180471d+3*t30*t32*t37*t4+2.7698052901
     6         80471d+3*t29*t33*t34*t4-7.386147440481255d+3*t29*t30*t34*
     7         t4+4.616342150300784d+3*t27*t29*t34*t4+4.616342150300784d
     8         +3*t26*t30*t31*t4-1.154085537575196d+4*t26*t27*t31*t4+6.9
     9         24513225451178d+3*t24*t26*t31*t4+6.924513225451178d+3*t23
     :         *t27*t28*t4-1.661883174108283d+4*t23*t24*t28*t4+9.6943185
     ;         15631648d+3*t21*t23*t28*t4+9.694318515631648d+3*t20*t24*t
     <         25*t4-2.2620076536473846d+4*t20*t21*t25*t4+1.292575802084
     =         2196d+4*t18*t20*t25*t4+1.2925758020842196d+4*t17*t21*t22*
     >         t4-2.954458976192502d+4*t17*t18*t22*t4+1.6618831741082823
     ?         d+4*t15*t17*t22*t4+1.6618831741082823d+4*t14*t18*t19*t4-3
     @         .7392371417436354d+4*t14*t15*t19*t4+2.0773539676353528d+4
     1         *t12*t14*t19*t4+2.0773539676353528d+4*t11*t15*t16*t4-4.61
     2         6342150300784d+4*t11*t12*t16*t4
            t69 = -1.1141288576844789d+2*t44*t57*t67*t9+3.04678581919851
     1         8d+4*t4*t44*t66*t9-1.0128444160767991d+1*t38*t54*t67*t8+2
     2         .0256888321535982d+1*t38*t53*t67*t8+4.6163421503007845d+2
     3         *t35*t4*t54*t8-1.846536860120314d+3*t35*t4*t53*t8+1.38490
     4         26450902355d+3*t35*t4*t52*t8+1.0128444160767991d+1*t40*t5
     5         4*t67-2.0256888321535982d+1*t35*t37*t53*t67+3.03853324823
     6         0397d+1*t35*t37*t52*t67-3.038533248230397d+1*t32*t34*t52*
     7         t67+4.0513776643071964d+1*t32*t34*t51*t67-4.0513776643071
     8         964d+1*t29*t31*t51*t67+5.064222080383994d+1*t29*t31*t50*t
     9         67-5.064222080383994d+1*t26*t28*t50*t67+6.077066496460795
     :         d+1*t26*t28*t49*t67-6.077066496460795d+1*t23*t25*t49*t67+
     ;         7.089910912537593d+1*t23*t25*t48*t67-7.089910912537593d+1
     <         *t20*t22*t48*t67+8.102755328614393d+1*t20*t22*t47*t67-8.1
     =         02755328614393d+1*t17*t19*t47*t67+9.115599744691191d+1*t1
     >         7*t19*t46*t67-9.115599744691191d+1*t14*t16*t46*t67+1.0128
     ?         44416076799d+2*t14*t16*t45*t67-1.012844416076799d+2*t11*t
     @         13*t45*t67+1.1141288576844789d+2*t11*t13*t44*t67+2.538988
     1         1826654315d+4*t13*t4*t45*t57-5.585774001863949d+4*t13*t4*
     2         t44*t57-4.6163421503007845d+2*t38*t4*t54+4.61634215030078
     3         45d+2*t38*t4*t53+1.3849026450902355d+3*t32*t37*t4*t53-4.1
     4         547079352707067d+3*t32*t37*t4*t52+2.769805290180471d+3*t2
     5         9*t34*t4*t52+2.769805290180471d+3*t32*t37*t4*t51-7.386147
     6         440481255d+3*t29*t34*t4*t51+4.616342150300784d+3*t26*t31*
     7         t4*t51+4.616342150300784d+3*t29*t34*t4*t50-1.154085537575
     8         196d+4*t26*t31*t4*t50+6.924513225451178d+3*t23*t28*t4*t50
     9         +6.924513225451178d+3*t26*t31*t4*t49-1.661883174108283d+4
     :         *t23*t28*t4*t49+9.694318515631648d+3*t20*t25*t4*t49+9.694
     ;         318515631648d+3*t23*t28*t4*t48-2.2620076536473846d+4*t20*
     <         t25*t4*t48+1.2925758020842196d+4*t17*t22*t4*t48+1.2925758
     =         020842196d+4*t20*t25*t4*t47-2.954458976192502d+4*t17*t22*
     >         t4*t47+1.6618831741082823d+4*t14*t19*t4*t47+1.66188317410
     ?         82823d+4*t17*t22*t4*t46-3.7392371417436354d+4*t14*t19*t4*
     @         t46+2.0773539676353528d+4*t11*t16*t4*t46+2.07735396763535
     1         28d+4*t14*t19*t4*t45-4.616342150300784d+4*t11*t16*t4*t45+
     2         2.5389881826654315d+4*t11*t16*t4*t44
            t70 = gammabb**2
            t71 = 1/t2**3
            t72 = 1/rhob**6
            t73 = 1/rhob**3.3333333333333337d+0
            t74 = 1/t56
            t75 = -4.135669939329334d-1*t43*t55-4.135669939329334d-1*t3*
     1         t41
            t76 = 1/rhob**5
            t77 = 1/rhob**4
            t78 = 4.0108638876641245d+3*t5*t56*t66*t9+6.077066496460795d
     1         +1*t35*t39*t56*t8-1.8231199489382385d+2*t33*t35*t56*t8+3.
     2         342386573053437d+3*t12*t13*t56*t57-3.342386573053437d+3*t
     3         11*t16*t5*t56-6.077066496460795d+1*t36*t38*t56+1.82311994
     4         89382385d+2*t32*t36*t37*t56-3.646239897876477d+2*t30*t32*
     5         t37*t56+3.646239897876477d+2*t29*t33*t34*t56-6.0770664964
     6         60795d+2*t27*t29*t34*t56+6.077066496460795d+2*t26*t30*t31
     7         *t56-9.115599744691192d+2*t24*t26*t31*t56+9.1155997446911
     8         92d+2*t23*t27*t28*t56-1.276183964256767d+3*t21*t23*t28*t5
     9         6+1.276183964256767d+3*t20*t24*t25*t56-1.7015786190090226
     :         d+3*t18*t20*t25*t56+1.7015786190090226d+3*t17*t21*t22*t56
     ;         -2.187743938725886d+3*t15*t17*t22*t56+2.187743938725886d+
     <         3*t14*t18*t19*t56-2.734679923407357d+3*t12*t14*t19*t56+2.
     =         734679923407357d+3*t11*t15*t16*t56
            t79 = 4.0108638876641245d+3*t44*t56*t66*t9+6.077066496460795
     1         d+1*t35*t54*t56*t8-1.8231199489382385d+2*t35*t52*t56*t8+3
     2         .342386573053437d+3*t13*t45*t56*t57-6.077066496460795d+1*
     3         t38*t53*t56+1.8231199489382385d+2*t32*t37*t53*t56+3.64623
     4         9897876477d+2*t29*t34*t52*t56-3.646239897876477d+2*t32*t3
     5         7*t51*t56+6.077066496460795d+2*t26*t31*t51*t56-6.07706649
     6         6460795d+2*t29*t34*t50*t56+9.115599744691192d+2*t23*t28*t
     7         50*t56-9.115599744691192d+2*t26*t31*t49*t56+1.27618396425
     8         6767d+3*t20*t25*t49*t56-1.276183964256767d+3*t23*t28*t48*
     9         t56+1.7015786190090226d+3*t17*t22*t48*t56-1.7015786190090
     :         226d+3*t20*t25*t47*t56+2.187743938725886d+3*t14*t19*t47*t
     ;         56-2.187743938725886d+3*t17*t22*t46*t56+2.734679923407357
     <         d+3*t11*t16*t46*t56-2.734679923407357d+3*t14*t19*t45*t56-
     =         3.342386573053437d+3*t11*t16*t44*t56
            t80 = 5.28d+2*t5*t66*t9+8.0d+0*t35*t39*t8+3.2d+1*t35*t36*t8+
     1         2.4d+1*t33*t35*t8+9.68d+2*t13*t5*t57+4.4d+2*t12*t13*t57+4
     2         .4d+2*t11*t16*t5+8.0d+0*t38*t39+8.0d+0*t36*t38+2.4d+1*t32
     3         *t36*t37+7.2d+1*t32*t33*t37+4.8d+1*t30*t32*t37+4.8d+1*t29
     4         *t33*t34+1.28d+2*t29*t30*t34+8.0d+1*t27*t29*t34+8.0d+1*t2
     5         6*t30*t31+2.0d+2*t26*t27*t31+1.2d+2*t24*t26*t31+1.2d+2*t2
     6         3*t27*t28+2.88d+2*t23*t24*t28+1.68d+2*t21*t23*t28+1.68d+2
     7         *t20*t24*t25+3.92d+2*t20*t21*t25+2.24d+2*t18*t20*t25+2.24
     8         d+2*t17*t21*t22+5.12d+2*t17*t18*t22+2.88d+2*t15*t17*t22+2
     9         .88d+2*t14*t18*t19+6.48d+2*t14*t15*t19+3.6d+2*t12*t14*t19
     :         +3.6d+2*t11*t15*t16+8.0d+2*t11*t12*t16
            t81 = 5.28d+2*t44*t66*t9+8.0d+0*t35*t54*t8+3.2d+1*t35*t53*t8
     1         +2.4d+1*t35*t52*t8+4.4d+2*t13*t45*t57+9.68d+2*t13*t44*t57
     2         +8.0d+0*t38*t54+8.0d+0*t38*t53+2.4d+1*t32*t37*t53+7.2d+1*
     3         t32*t37*t52+4.8d+1*t29*t34*t52+4.8d+1*t32*t37*t51+1.28d+2
     4         *t29*t34*t51+8.0d+1*t26*t31*t51+8.0d+1*t29*t34*t50+2.0d+2
     5         *t26*t31*t50+1.2d+2*t23*t28*t50+1.2d+2*t26*t31*t49+2.88d+
     6         2*t23*t28*t49+1.68d+2*t20*t25*t49+1.68d+2*t23*t28*t48+3.9
     7         2d+2*t20*t25*t48+2.24d+2*t17*t22*t48+2.24d+2*t20*t25*t47+
     8         5.12d+2*t17*t22*t47+2.88d+2*t14*t19*t47+2.88d+2*t17*t22*t
     9         46+6.48d+2*t14*t19*t46+3.6d+2*t11*t16*t46+3.6d+2*t14*t19*
     :         t45+8.0d+2*t11*t16*t45+4.4d+2*t11*t16*t44
            t82 = rhob**2
            t83 = 1/t10**14
            t84 = gammabb**3
            t85 = 1/t2**4
            t86 = 1/rhob**9.666666666666666d+0
            t87 = 1/rhob**7
            t88 = 1/rhob**4.333333333333333d+0
            t89 = 1/rhob**3.6666666666666664d+0
            t90 = 1/rhob**8.666666666666666d+0
            t91 = 1/rhob**7.666666666666667d+0
            t92 = 1/rhob**6.666666666666667d+0
            fnc(iq) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t55-9.3052573
     1         63491002d-1*t3*t4*t41)*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t43*t55*t62-
     1         1.2407009817988002d+0*t3*t41*t62+8.963083509889702d-3*gam
     2         mabb*t41*t60*t61+5.041016444533138d-3*gammabb*t42*t55*t61
     3         -9.305257363491002d-1*t4*t43*t59-9.305257363491002d-1*t3*
     4         t4*t58)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t41*t60*t63-
     1         1.890381166699927d-3*t42*t55*t63)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t65-9.
     1         305257363491002d-1*t3*t4*t64)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t74*t75-8.963083509889707d-3*ga
     1         mmabb*t41*t60*t73-5.041016444533138d-3*gammabb*t42*t55*t7
     2         3+2.1476348525932504d-4*t41*t70*t71*t72+4.947305865786653
     3         d-5*t42*t55*t70*t72-9.305257363491002d-1*t4*t43*t69-9.305
     4         257363491002d-1*t3*t4*t68-2.4814019635976003d+0*t43*t59*t
     5         62-2.4814019635976003d+0*t3*t58*t62+1.7926167019779404d-2
     6         *gammabb*t58*t60*t61+1.0082032889066277d-2*gammabb*t42*t5
     7         9*t61)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(-8.05363069722469d-5*gammabb*t
     1         41*t71*t76-1.855239699669995d-5*gammabb*t42*t55*t76-3.361
     2         156316208638d-3*t58*t60*t63-1.890381166699927d-3*t42*t59*
     3         t63+4.481541754944851d-3*t41*t60*t61+2.520508222266569d-3
     4         *t42*t55*t61)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(3.020111511459258d-5*t41*t71*
     1         t77+6.957148873762482d-6*t42*t55*t77)*wght+Cmat2(iq,D2_GB
     2         B_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t7
     1         9-9.305257363491002d-1*t3*t4*t78-1.2407009817988002d+0*t4
     2         3*t62*t65+5.041016444533138d-3*gammabb*t42*t61*t65-1.2407
     3         009817988002d+0*t3*t62*t64+8.963083509889702d-3*gammabb*t
     4         60*t61*t64)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(-1.890381166699927d-3*t42*t63*
     1         t65-3.361156316208638d-3*t60*t63*t64)*wght+Mmat2(iq,D2_GB
     2         B_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t4*t43*t8
     1         1-9.305257363491002d-1*t3*t4*t80)*wght+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-6.01754400771653d+6*t5*t82*t83*t9+6.093571638397036d+4*
     2         t5*t62*t66*t9+3.713762858948263d+1*t5*t57*t63*t9-2.104036
     3         366334451d+4*t32*t39*t8*t82+1.2624218198006704d+5*t32*t36
     4         *t8*t82-1.8936327297010064d+5*t32*t33*t8*t82+8.4161454653
     5         37804d+4*t30*t32*t8*t82+1.5275304019588112d+7*t13*t5*t66*
     6         t82-4.628880005935792d+6*t12*t13*t66*t82-1.27294200163234
     7         26d+7*t16*t5*t57*t82-3.4716600044518436d+6*t15*t16*t57*t8
     8         2+1.1572200014839477d+7*t12*t16*t57*t82+3.471660004451843
     9         6d+6*t11*t19*t5*t82+2.104036366334451d+4*t35*t39*t82-8.41
     :         6145465337804d+4*t29*t36*t37*t82+3.787265459402013d+5*t29
     ;         *t33*t37*t82-5.049687279202681d+5*t29*t30*t37*t82+2.10403
     <         63663344508d+5*t27*t29*t37*t82-4.208072732668902d+4*t35*t
     =         36*t82+2.104036366334451d+4*t33*t35*t82-2.104036366334451
     >         d+5*t26*t33*t34*t82+8.416145465337803d+5*t26*t30*t34*t82-
     ?         1.0520181831672254d+6*t26*t27*t34*t82+4.208072732668902d+
     @         5*t24*t26*t34*t82-4.2080727326689016d+5*t23*t30*t31*t82+1
     1         .578027274750838d+6*t23*t27*t31*t82-1.893632729701006d+6*
     2         t23*t24*t31*t82+7.364127282170578d+5*t21*t23*t31*t82-7.36
     3         4127282170578d+5*t20*t27*t28*t82+2.6510858215814087d+6*t2
     4         0*t24*t28*t82-3.0929334585116436d+6*t20*t21*t28*t82+1.178
     5         2603651472927d+6*t18*t20*t28*t82-1.1782603651472927d+6*t1
     6         7*t24*t25*t82+4.123911278015524d+6*t17*t21*t25*t82-4.7130
     7         41460589171d+6*t17*t18*t25*t82+1.767390547720939d+6*t15*t
     8         17*t25*t82-1.7673905477209387d+6*t14*t21*t22*t82+6.059624
     9         735043219d+6*t14*t18*t22*t82-6.817077826923622d+6*t14*t15
     :         *t22*t82+2.524843639601341d+6*t12*t14*t22*t82-2.524843639
     ;         601341d+6*t11*t18*t19*t82+8.521347283654526d+6*t11*t15*t1
     <         9*t82-9.468163648505028d+6*t11*t12*t19*t82+3.376148053589
     =         33d+0*t38*t39*t63*t8-6.75229610717866d+0*t36*t38*t63*t8+9
     >         .232684300601568d+2*t35*t39*t62*t8-3.693073720240627d+3*t
     ?         35*t36*t62*t8+2.769805290180471d+3*t33*t35*t62*t8-3.71376
     @         2858948263d+1*t11*t13*t5*t63-3.37614805358933d+0*t39*t40*
     1         t63+6.75229610717866d+0*t35*t36*t37*t63-1.012844416076799
     2         1d+1*t33*t35*t37*t63+1.0128444160767991d+1*t32*t33*t34*t6
     3         3-1.350459221435732d+1*t30*t32*t34*t63+1.350459221435732d
     4         +1*t29*t30*t31*t63-1.6880740267946648d+1*t27*t29*t31*t63+
     5         1.6880740267946648d+1*t26*t27*t28*t63-2.0256888321535982d
     6         +1*t24*t26*t28*t63+2.0256888321535982d+1*t23*t24*t25*t63-
     7         2.3633036375125308d+1*t21*t23*t25*t63+2.3633036375125308d
     8         +1*t20*t21*t22*t63-2.700918442871464d+1*t18*t20*t22*t63+2
     9         .700918442871464d+1*t17*t18*t19*t63-3.0385332482303967d+1
     :         *t15*t17*t19*t63+3.0385332482303967d+1*t14*t15*t16*t63-3.
     ;         3761480535893296d+1*t12*t14*t16*t63+3.3761480535893296d+1
     <         *t11*t12*t13*t63-1.1171548003727898d+5*t13*t5*t57*t62+5.0
     =         77976365330862d+4*t12*t13*t57*t62+5.077976365330863d+4*t1
     >         1*t16*t5*t62-9.232684300601568d+2*t38*t39*t62+9.232684300
     ?         601568d+2*t36*t38*t62+2.769805290180471d+3*t32*t36*t37*t6
     @         2-8.309415870541413d+3*t32*t33*t37*t62+5.539610580360942d
     1         +3*t30*t32*t37*t62+5.539610580360942d+3*t29*t33*t34*t62-1
     2         .4772294880962508d+4*t29*t30*t34*t62+9.232684300601568d+3
     3         *t27*t29*t34*t62+9.232684300601568d+3*t26*t30*t31*t62-2.3
     4         08171075150392d+4*t26*t27*t31*t62+1.3849026450902355d+4*t
     5         24*t26*t31*t62+1.3849026450902355d+4*t23*t27*t28*t62-3.32
     6         3766348216566d+4*t23*t24*t28*t62+1.9388637031263292d+4*t2
     7         1*t23*t28*t62+1.9388637031263292d+4*t20*t24*t25*t62-4.524
     8         0153072947686d+4*t20*t21*t25*t62+2.585151604168439d+4*t18
     9         *t20*t25*t62+2.585151604168439d+4*t17*t21*t22*t62-5.90891
     :         7952385003d+4*t17*t18*t22*t62+3.3237663482165647d+4*t15*t
     ;         17*t22*t62+3.3237663482165647d+4*t14*t18*t19*t62-7.478474
     <         283487271d+4*t14*t15*t19*t62+4.154707935270705d+4*t12*t14
     =         *t19*t62+4.1547079352707056d+4*t11*t15*t16*t62-9.23268430
     >         0601568d+4*t11*t12*t16*t62)-9.305257363491002d-1*t4*t43*(
     ?         -6.01754400771653d+6*t44*t82*t83*t9+6.093571638397036d+4*
     @         t44*t62*t66*t9+3.713762858948263d+1*t44*t57*t63*t9-2.1040
     1         36366334451d+4*t32*t54*t8*t82+1.2624218198006704d+5*t32*t
     2         53*t8*t82-1.8936327297010064d+5*t32*t52*t8*t82+8.41614546
     3         5337804d+4*t32*t51*t8*t82-4.628880005935792d+6*t13*t45*t6
     4         6*t82+1.5275304019588112d+7*t13*t44*t66*t82-3.47166000445
     5         18436d+6*t16*t46*t57*t82+1.1572200014839477d+7*t16*t45*t5
     6         7*t82-1.2729420016323426d+7*t16*t44*t57*t82+2.10403636633
     7         4451d+4*t35*t54*t82-8.416145465337804d+4*t29*t37*t53*t82-
     8         4.208072732668902d+4*t35*t53*t82+3.787265459402013d+5*t29
     9         *t37*t52*t82+2.104036366334451d+4*t35*t52*t82-2.104036366
     :         334451d+5*t26*t34*t52*t82-5.049687279202681d+5*t29*t37*t5
     ;         1*t82+8.416145465337803d+5*t26*t34*t51*t82-4.208072732668
     <         9016d+5*t23*t31*t51*t82+2.1040363663344508d+5*t29*t37*t50
     =         *t82-1.0520181831672254d+6*t26*t34*t50*t82+1.578027274750
     >         838d+6*t23*t31*t50*t82-7.364127282170578d+5*t20*t28*t50*t
     ?         82+4.208072732668902d+5*t26*t34*t49*t82-1.893632729701006
     @         d+6*t23*t31*t49*t82+2.6510858215814087d+6*t20*t28*t49*t82
     1         -1.1782603651472927d+6*t17*t25*t49*t82+7.364127282170578d
     2         +5*t23*t31*t48*t82-3.0929334585116436d+6*t20*t28*t48*t82+
     3         4.123911278015524d+6*t17*t25*t48*t82-1.7673905477209387d+
     4         6*t14*t22*t48*t82+1.1782603651472927d+6*t20*t28*t47*t82-4
     5         .713041460589171d+6*t17*t25*t47*t82+6.059624735043219d+6*
     6         t14*t22*t47*t82-2.524843639601341d+6*t11*t19*t47*t82+1.76
     7         7390547720939d+6*t17*t25*t46*t82-6.817077826923622d+6*t14
     8         *t22*t46*t82+8.521347283654526d+6*t11*t19*t46*t82+2.52484
     9         3639601341d+6*t14*t22*t45*t82-9.468163648505028d+6*t11*t1
     :         9*t45*t82+3.4716600044518436d+6*t11*t19*t44*t82+3.3761480
     ;         5358933d+0*t38*t54*t63*t8-6.75229610717866d+0*t38*t53*t63
     <         *t8+9.232684300601568d+2*t35*t54*t62*t8-3.693073720240627
     =         d+3*t35*t53*t62*t8+2.769805290180471d+3*t35*t52*t62*t8-3.
     >         37614805358933d+0*t40*t54*t63+6.75229610717866d+0*t35*t37
     ?         *t53*t63-1.0128444160767991d+1*t35*t37*t52*t63+1.01284441
     @         60767991d+1*t32*t34*t52*t63-1.350459221435732d+1*t32*t34*
     1         t51*t63+1.350459221435732d+1*t29*t31*t51*t63-1.6880740267
     2         946648d+1*t29*t31*t50*t63+1.6880740267946648d+1*t26*t28*t
     3         50*t63-2.0256888321535982d+1*t26*t28*t49*t63+2.0256888321
     4         535982d+1*t23*t25*t49*t63-2.3633036375125308d+1*t23*t25*t
     5         48*t63+2.3633036375125308d+1*t20*t22*t48*t63-2.7009184428
     6         71464d+1*t20*t22*t47*t63+2.700918442871464d+1*t17*t19*t47
     7         *t63-3.0385332482303967d+1*t17*t19*t46*t63+3.038533248230
     8         3967d+1*t14*t16*t46*t63-3.3761480535893296d+1*t14*t16*t45
     9         *t63+3.3761480535893296d+1*t11*t13*t45*t63-3.713762858948
     :         263d+1*t11*t13*t44*t63+5.077976365330862d+4*t13*t45*t57*t
     ;         62-1.1171548003727898d+5*t13*t44*t57*t62-9.23268430060156
     <         8d+2*t38*t54*t62+9.232684300601568d+2*t38*t53*t62+2.76980
     =         5290180471d+3*t32*t37*t53*t62-8.309415870541413d+3*t32*t3
     >         7*t52*t62+5.539610580360942d+3*t29*t34*t52*t62+5.53961058
     ?         0360942d+3*t32*t37*t51*t62-1.4772294880962508d+4*t29*t34*
     @         t51*t62+9.232684300601568d+3*t26*t31*t51*t62+9.2326843006
     1         01568d+3*t29*t34*t50*t62-2.308171075150392d+4*t26*t31*t50
     2         *t62+1.3849026450902355d+4*t23*t28*t50*t62+1.384902645090
     3         2355d+4*t26*t31*t49*t62-3.323766348216566d+4*t23*t28*t49*
     4         t62+1.9388637031263292d+4*t20*t25*t49*t62+1.9388637031263
     5         292d+4*t23*t28*t48*t62-4.5240153072947686d+4*t20*t25*t48*
     6         t62+2.585151604168439d+4*t17*t22*t48*t62+2.58515160416843
     7         9d+4*t20*t25*t47*t62-5.908917952385003d+4*t17*t22*t47*t62
     8         +3.3237663482165647d+4*t14*t19*t47*t62+3.3237663482165647
     9         d+4*t17*t22*t46*t62-7.478474283487271d+4*t14*t19*t46*t62+
     :         4.1547079352707056d+4*t11*t16*t46*t62+4.154707935270705d+
     ;         4*t14*t19*t45*t62-9.232684300601568d+4*t11*t16*t45*t62+5.
     <         077976365330863d+4*t11*t16*t44*t62)+t74*(3.98359267106208
     =         9d-3*gammabb*t41*t60*t89+2.2404517531258392d-3*gammabb*t4
     >         2*t55*t89-1.2407009817988002d+0*t43*t59-1.240700981798800
     ?         2d+0*t3*t58)+2.987694503296569d-2*gammabb*t41*t60*t88+1.6
     @         803388148443793d-2*gammabb*t42*t55*t88-1.5033443968152754
     1         d-3*t41*t70*t71*t87-3.4631141060506576d-4*t42*t55*t70*t87
     2         +7.718887347725925d-6*t41*t84*t85*t86+4.855337331063556d-
     3         7*t42*t55*t84*t86-6.666666666666666d-1*t75/t6-2.688925052
     4         9669123d-2*gammabb*t58*t60*t73-1.5123049333599414d-2*gamm
     5         abb*t42*t59*t73+6.442904557779751d-4*t58*t70*t71*t72+1.48
     6         4191759735996d-4*t42*t59*t70*t72-3.7221029453964005d+0*t4
     7         3*t62*t69+1.5123049333599414d-2*gammabb*t42*t61*t69-3.722
     8         1029453964005d+0*t3*t62*t68+2.6889250529669106d-2*gammabb
     9         *t60*t61*t68)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*(-2.8945827553972214d-6*t41*
     1         t70*t85*t90-1.8207514991488338d-7*t42*t55*t70*t90-1.61072
     2         6139444938d-4*gammabb*t58*t71*t76-3.71047939933999d-5*gam
     3         mabb*t42*t59*t76+(-1.4938472516482837d-3*t1*t41*t60-8.401
     4         694074221898d-4*t1*t42*t55)*t74-8.963083509889707d-3*t41*
     5         t60*t73-5.041016444533138d-3*t42*t55*t73+5.10063277490897
     6         1d-4*gammabb*t41*t71*t72+1.1749851431243302d-4*gammabb*t4
     7         2*t55*t72-1.890381166699927d-3*t42*t63*t69-3.361156316208
     8         638d-3*t60*t63*t68+8.963083509889702d-3*t58*t60*t61+5.041
     9         016444533138d-3*t42*t59*t61)*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*(1.0854685332739583d-6*gamm
     1         abb*t41*t85*t91+6.827818121808127d-8*gammabb*t42*t55*t91+
     2         3.020111511459258d-5*t58*t71*t77+6.957148873762482d-6*t42
     3         *t59*t77-1.2080446045837034d-4*t41*t71*t76-2.782859549504
     4         9924d-5*t42*t55*t76)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*(-4.070506999777343d-7*t41
     1         *t85*t92-2.560431795678048d-8*t42*t55*t92)*wght+Cmat3(iq,
     2         D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-7.921643129916147d+5*t4*t5*t83*t9+2.6739092584427493d+3
     2         *t5*t66*t67*t9+4.0513776643071964d+1*t35*t39*t67*t8-1.215
     3         4132992921589d+2*t33*t35*t67*t8-2.769805290180471d+3*t32*
     4         t39*t4*t8+5.539610580360942d+3*t32*t36*t4*t8+8.3094158705
     5         41416d+3*t32*t33*t4*t8-1.1079221160721883d+4*t30*t32*t4*t
     6         8+2.2282577153689576d+3*t12*t13*t57*t67-2.228257715368958
     7         d+3*t11*t16*t5*t67-4.0513776643071964d+1*t36*t38*t67+1.21
     8         54132992921589d+2*t32*t36*t37*t67-2.4308265985843178d+2*t
     9         30*t32*t37*t67+2.4308265985843178d+2*t29*t33*t34*t67-4.05
     :         1377664307196d+2*t27*t29*t34*t67+4.0513776643071964d+2*t2
     ;         6*t30*t31*t67-6.077066496460795d+2*t24*t26*t31*t67+6.0770
     <         66496460793d+2*t23*t27*t28*t67-8.507893095045111d+2*t21*t
     =         23*t28*t67+8.507893095045113d+2*t20*t24*t25*t67-1.1343857
     >         460060149d+3*t18*t20*t25*t67+1.1343857460060149d+3*t17*t2
     ?         1*t22*t67-1.4584959591505905d+3*t15*t17*t22*t67+1.4584959
     @         591505908d+3*t14*t18*t19*t67-1.8231199489382383d+3*t12*t1
     1         4*t19*t67+1.8231199489382383d+3*t11*t15*t16*t67+6.7029288
     2         02236738d+5*t13*t4*t5*t66-6.093571638397035d+5*t12*t13*t4
     3         *t66+5.585774001863949d+5*t16*t4*t5*t57-4.570178728797776
     4         3d+5*t15*t16*t4*t57+5.077976365330863d+5*t12*t16*t4*t57-4
     5         .5701787287977763d+5*t11*t19*t4*t5+9.232684300601569d+2*t
     6         35*t39*t4-1.1079221160721883d+4*t29*t36*t37*t4+1.66188317
     7         41082832d+4*t29*t33*t37*t4+2.2158442321443766d+4*t29*t30*
     8         t37*t4-2.7698052901804704d+4*t27*t29*t37*t4+1.84653686012
     9         0314d+3*t35*t36*t4-2.769805290180471d+3*t33*t35*t4-2.7698
     :         05290180471d+4*t26*t33*t34*t4+3.693073720240629d+4*t26*t3
     ;         0*t34*t4+4.616342150300784d+4*t26*t27*t34*t4-5.5396105803
     <         60942d+4*t24*t26*t34*t4-5.539610580360941d+4*t23*t30*t31*
     =         t4+6.924513225451174d+4*t23*t27*t31*t4+8.309415870541416d
     >         +4*t23*t24*t31*t4-9.694318515631648d+4*t21*t23*t31*t4-9.6
     ?         94318515631648d+4*t20*t27*t28*t4+1.1633182218757979d+5*t2
     @         0*t24*t28*t4+1.3572045921884307d+5*t20*t21*t28*t4-1.55109
     1         09625010635d+5*t18*t20*t28*t4-1.5510909625010638d+5*t17*t
     2         24*t25*t4+1.809606122917908d+5*t17*t21*t25*t4+2.068121283
     3         3347515d+5*t17*t18*t25*t4-2.3266364437515952d+5*t15*t17*t
     4         25*t4-2.3266364437515955d+5*t14*t21*t22*t4+2.659013078573
     5         252d+5*t14*t18*t22*t4+2.9913897133949086d+5*t14*t15*t22*t
     6         4-3.3237663482165647d+5*t12*t14*t22*t4-3.323766348216565d
     7         +5*t11*t18*t19*t4+3.7392371417436354d+5*t11*t15*t19*t4+4.
     8         1547079352707056d+5*t11*t12*t19*t4)-9.305257363491002d-1*
     9         t4*t43*(-7.921643129916147d+5*t4*t44*t83*t9+2.67390925844
     :         27493d+3*t44*t66*t67*t9+4.0513776643071964d+1*t35*t54*t67
     ;         *t8-1.2154132992921589d+2*t35*t52*t67*t8-2.76980529018047
     <         1d+3*t32*t4*t54*t8+5.539610580360942d+3*t32*t4*t53*t8+8.3
     =         09415870541416d+3*t32*t4*t52*t8-1.1079221160721883d+4*t32
     >         *t4*t51*t8+2.2282577153689576d+3*t13*t45*t57*t67-4.051377
     ?         6643071964d+1*t38*t53*t67+1.2154132992921589d+2*t32*t37*t
     @         53*t67+2.4308265985843178d+2*t29*t34*t52*t67-2.4308265985
     1         843178d+2*t32*t37*t51*t67+4.0513776643071964d+2*t26*t31*t
     2         51*t67-4.051377664307196d+2*t29*t34*t50*t67+6.07706649646
     3         0793d+2*t23*t28*t50*t67-6.077066496460795d+2*t26*t31*t49*
     4         t67+8.507893095045113d+2*t20*t25*t49*t67-8.50789309504511
     5         1d+2*t23*t28*t48*t67+1.1343857460060149d+3*t17*t22*t48*t6
     6         7-1.1343857460060149d+3*t20*t25*t47*t67+1.458495959150590
     7         8d+3*t14*t19*t47*t67-1.4584959591505905d+3*t17*t22*t46*t6
     8         7+1.8231199489382383d+3*t11*t16*t46*t67-1.823119948938238
     9         3d+3*t14*t19*t45*t67-2.228257715368958d+3*t11*t16*t44*t67
     :         -6.093571638397035d+5*t13*t4*t45*t66+6.702928802236738d+5
     ;         *t13*t4*t44*t66-4.5701787287977763d+5*t16*t4*t46*t57+5.07
     <         7976365330863d+5*t16*t4*t45*t57+5.585774001863949d+5*t16*
     =         t4*t44*t57+9.232684300601569d+2*t35*t4*t54-1.107922116072
     >         1883d+4*t29*t37*t4*t53+1.846536860120314d+3*t35*t4*t53+1.
     ?         6618831741082832d+4*t29*t37*t4*t52-2.769805290180471d+3*t
     @         35*t4*t52-2.769805290180471d+4*t26*t34*t4*t52+2.215844232
     1         1443766d+4*t29*t37*t4*t51+3.693073720240629d+4*t26*t34*t4
     2         *t51-5.539610580360941d+4*t23*t31*t4*t51-2.76980529018047
     3         04d+4*t29*t37*t4*t50+4.616342150300784d+4*t26*t34*t4*t50+
     4         6.924513225451174d+4*t23*t31*t4*t50-9.694318515631648d+4*
     5         t20*t28*t4*t50-5.539610580360942d+4*t26*t34*t4*t49+8.3094
     6         15870541416d+4*t23*t31*t4*t49+1.1633182218757979d+5*t20*t
     7         28*t4*t49-1.5510909625010638d+5*t17*t25*t4*t49-9.69431851
     8         5631648d+4*t23*t31*t4*t48+1.3572045921884307d+5*t20*t28*t
     9         4*t48+1.809606122917908d+5*t17*t25*t4*t48-2.3266364437515
     :         955d+5*t14*t22*t4*t48-1.5510909625010635d+5*t20*t28*t4*t4
     ;         7+2.0681212833347515d+5*t17*t25*t4*t47+2.659013078573252d
     <         +5*t14*t22*t4*t47-3.323766348216565d+5*t11*t19*t4*t47-2.3
     =         266364437515952d+5*t17*t25*t4*t46+2.9913897133949086d+5*t
     >         14*t22*t4*t46+3.7392371417436354d+5*t11*t19*t4*t46-3.3237
     ?         663482165647d+5*t14*t22*t4*t45+4.1547079352707056d+5*t11*
     @         t19*t4*t45-4.5701787287977763d+5*t11*t19*t4*t44)-2.481401
     1         9635976003d+0*t43*t62*t79+1.0082032889066277d-2*gammabb*t
     2         42*t61*t79-2.4814019635976003d+0*t3*t62*t78+1.79261670197
     3         79404d-2*gammabb*t60*t61*t78+(-4.135669939329334d-1*t43*t
     4         65-4.135669939329334d-1*t3*t64)*t74-5.041016444533138d-3*
     5         gammabb*t42*t65*t73-8.963083509889707d-3*gammabb*t60*t64*
     6         t73+2.1476348525932504d-4*t64*t70*t71*t72+4.9473058657866
     7         53d-5*t42*t65*t70*t72)*wght+Mmat3(iq,D3_RB_RB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = 1.0d+0*(-1.890381166699927d-3*t42*t
     1         63*t79-3.361156316208638d-3*t60*t63*t78-8.05363069722469d
     2         -5*gammabb*t64*t71*t76-1.855239699669995d-5*gammabb*t42*t
     3         65*t76+2.520508222266569d-3*t42*t61*t65+4.481541754944851
     4         d-3*t60*t61*t64)*wght+Mmat3(iq,D3_RB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = 1.0d+0*(3.020111511459258d-5*t64*t
     1         71*t77+6.957148873762482d-6*t42*t65*t77)*wght+Mmat3(iq,D3
     2         _GBB_GBB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-1.0428246107926724d+5*t5*t56*t83*t9-3.646239897876477d+
     2         2*t32*t39*t56*t8-7.292479795752954d+2*t32*t36*t56*t8+1.09
     3         38719693629433d+3*t32*t33*t56*t8+1.4584959591505908d+3*t3
     4         0*t32*t56*t8-8.823900552861074d+4*t13*t5*t56*t66-8.021727
     5         775328248d+4*t12*t13*t56*t66+7.353250460717561d+4*t16*t5*
     6         t56*t57-6.016295831496187d+4*t15*t16*t56*t57-6.6847731461
     7         06873d+4*t12*t16*t56*t57+6.016295831496187d+4*t11*t19*t5*
     8         t56-1.2154132992921589d+2*t35*t39*t56-1.4584959591505908d
     9         +3*t29*t36*t37*t56-2.1877439387258865d+3*t29*t33*t37*t56+
     :         2.9169919183011817d+3*t29*t30*t37*t56+3.646239897876477d+
     ;         3*t27*t29*t37*t56+2.4308265985843178d+2*t35*t36*t56+3.646
     <         239897876477d+2*t33*t35*t56-3.646239897876477d+3*t26*t33*
     =         t34*t56-4.8616531971686355d+3*t26*t30*t34*t56+6.077066496
     >         460795d+3*t26*t27*t34*t56+7.292479795752954d+3*t24*t26*t3
     ?         4*t56-7.292479795752954d+3*t23*t30*t31*t56-9.115599744691
     @         192d+3*t23*t27*t31*t56+1.0938719693629431d+4*t23*t24*t31*
     1         t56+1.2761839642567668d+4*t21*t23*t31*t56-1.2761839642567
     2         668d+4*t20*t27*t28*t56-1.5314207571081204d+4*t20*t24*t28*
     3         t56+1.786657549959474d+4*t20*t21*t28*t56+2.04189434281082
     4         72d+4*t18*t20*t28*t56-2.0418943428108272d+4*t17*t24*t25*t
     5         56-2.3822100666126317d+4*t17*t21*t25*t56+2.72252579041443
     6         6d+4*t17*t18*t25*t56+3.062841514216241d+4*t15*t17*t25*t56
     7         -3.062841514216241d+4*t14*t21*t22*t56-3.5003903019614174d
     8         +4*t14*t18*t22*t56+3.9379390897065947d+4*t14*t15*t22*t56+
     9         4.375487877451772d+4*t12*t14*t22*t56-4.375487877451772d+4
     :         *t11*t18*t19*t56-4.9224238621332433d+4*t11*t15*t19*t56+5.
     ;         469359846814714d+4*t11*t12*t19*t56)-9.305257363491002d-1*
     <         t4*t43*(-1.0428246107926724d+5*t44*t56*t83*t9-3.646239897
     =         876477d+2*t32*t54*t56*t8-7.292479795752954d+2*t32*t53*t56
     >         *t8+1.0938719693629433d+3*t32*t52*t56*t8+1.45849595915059
     ?         08d+3*t32*t51*t56*t8-8.021727775328248d+4*t13*t45*t56*t66
     @         -8.823900552861074d+4*t13*t44*t56*t66-6.016295831496187d+
     1         4*t16*t46*t56*t57-6.684773146106873d+4*t16*t45*t56*t57+7.
     2         353250460717561d+4*t16*t44*t56*t57-1.2154132992921589d+2*
     3         t35*t54*t56-1.4584959591505908d+3*t29*t37*t53*t56+2.43082
     4         65985843178d+2*t35*t53*t56-2.1877439387258865d+3*t29*t37*
     5         t52*t56+3.646239897876477d+2*t35*t52*t56-3.64623989787647
     6         7d+3*t26*t34*t52*t56+2.9169919183011817d+3*t29*t37*t51*t5
     7         6-4.8616531971686355d+3*t26*t34*t51*t56-7.292479795752954
     8         d+3*t23*t31*t51*t56+3.646239897876477d+3*t29*t37*t50*t56+
     9         6.077066496460795d+3*t26*t34*t50*t56-9.115599744691192d+3
     :         *t23*t31*t50*t56-1.2761839642567668d+4*t20*t28*t50*t56+7.
     ;         292479795752954d+3*t26*t34*t49*t56+1.0938719693629431d+4*
     <         t23*t31*t49*t56-1.5314207571081204d+4*t20*t28*t49*t56-2.0
     =         418943428108272d+4*t17*t25*t49*t56+1.2761839642567668d+4*
     >         t23*t31*t48*t56+1.786657549959474d+4*t20*t28*t48*t56-2.38
     ?         22100666126317d+4*t17*t25*t48*t56-3.062841514216241d+4*t1
     @         4*t22*t48*t56+2.0418943428108272d+4*t20*t28*t47*t56+2.722
     1         525790414436d+4*t17*t25*t47*t56-3.5003903019614174d+4*t14
     2         *t22*t47*t56-4.375487877451772d+4*t11*t19*t47*t56+3.06284
     3         1514216241d+4*t17*t25*t46*t56+3.9379390897065947d+4*t14*t
     4         22*t46*t56-4.9224238621332433d+4*t11*t19*t46*t56+4.375487
     5         877451772d+4*t14*t22*t45*t56+5.469359846814714d+4*t11*t19
     6         *t45*t56+6.016295831496187d+4*t11*t19*t44*t56)-1.24070098
     7         17988002d+0*t43*t62*t81+5.041016444533138d-3*gammabb*t42*
     8         t61*t81-1.2407009817988002d+0*t3*t62*t80+8.96308350988970
     9         2d-3*gammabb*t60*t61*t80)*wght+Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
            Mmat3(iq,D3_GBB_TB_TB) = 1.0d+0*(-1.890381166699927d-3*t42*t
     1         63*t81-3.361156316208638d-3*t60*t63*t80)*wght+Mmat3(iq,D3
     2         _GBB_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t3*t4*
     1         (-1.3728d+4*t5*t83*t9-4.8d+1*t32*t39*t8-2.88d+2*t32*t36*t
     2         8-4.32d+2*t32*t33*t8-1.92d+2*t30*t32*t8-3.4848d+4*t13*t5*
     3         t66-1.056d+4*t12*t13*t66-2.904d+4*t16*t5*t57-7.92d+3*t15*
     4         t16*t57-2.64d+4*t12*t16*t57-7.92d+3*t11*t19*t5-4.8d+1*t35
     5         *t39-1.92d+2*t29*t36*t37-8.64d+2*t29*t33*t37-1.152d+3*t29
     6         *t30*t37-4.8d+2*t27*t29*t37-9.6d+1*t35*t36-4.8d+1*t33*t35
     7         -4.8d+2*t26*t33*t34-1.92d+3*t26*t30*t34-2.4d+3*t26*t27*t3
     8         4-9.6d+2*t24*t26*t34-9.6d+2*t23*t30*t31-3.6d+3*t23*t27*t3
     9         1-4.32d+3*t23*t24*t31-1.68d+3*t21*t23*t31-1.68d+3*t20*t27
     :         *t28-6.048d+3*t20*t24*t28-7.056d+3*t20*t21*t28-2.688d+3*t
     ;         18*t20*t28-2.688d+3*t17*t24*t25-9.408d+3*t17*t21*t25-1.07
     <         52d+4*t17*t18*t25-4.032d+3*t15*t17*t25-4.032d+3*t14*t21*t
     =         22-1.3824d+4*t14*t18*t22-1.5552d+4*t14*t15*t22-5.76d+3*t1
     >         2*t14*t22-5.76d+3*t11*t18*t19-1.944d+4*t11*t15*t19-2.16d+
     ?         4*t11*t12*t19)-9.305257363491002d-1*t4*t43*(-1.3728d+4*t4
     @         4*t83*t9-4.8d+1*t32*t54*t8-2.88d+2*t32*t53*t8-4.32d+2*t32
     1         *t52*t8-1.92d+2*t32*t51*t8-1.056d+4*t13*t45*t66-3.4848d+4
     2         *t13*t44*t66-7.92d+3*t16*t46*t57-2.64d+4*t16*t45*t57-2.90
     3         4d+4*t16*t44*t57-4.8d+1*t35*t54-1.92d+2*t29*t37*t53-9.6d+
     4         1*t35*t53-8.64d+2*t29*t37*t52-4.8d+1*t35*t52-4.8d+2*t26*t
     5         34*t52-1.152d+3*t29*t37*t51-1.92d+3*t26*t34*t51-9.6d+2*t2
     6         3*t31*t51-4.8d+2*t29*t37*t50-2.4d+3*t26*t34*t50-3.6d+3*t2
     7         3*t31*t50-1.68d+3*t20*t28*t50-9.6d+2*t26*t34*t49-4.32d+3*
     8         t23*t31*t49-6.048d+3*t20*t28*t49-2.688d+3*t17*t25*t49-1.6
     9         8d+3*t23*t31*t48-7.056d+3*t20*t28*t48-9.408d+3*t17*t25*t4
     :         8-4.032d+3*t14*t22*t48-2.688d+3*t20*t28*t47-1.0752d+4*t17
     ;         *t25*t47-1.3824d+4*t14*t22*t47-5.76d+3*t11*t19*t47-4.032d
     <         +3*t17*t25*t46-1.5552d+4*t14*t22*t46-1.944d+4*t11*t19*t46
     =         -5.76d+3*t14*t22*t45-2.16d+4*t11*t19*t45-7.92d+3*t11*t19*
     >         t44))*wght+Mmat3(iq,D3_TB_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
