/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;
import org.chefproject.core.Edit;
import org.chefproject.core.Filter;
import org.chefproject.core.Resource;
import org.chefproject.core.StorageUser;
import org.chefproject.util.Sql;
import org.chefproject.util.SqlReader;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseDbSingleStorage {
    protected String m_resourceTableName = null;
    protected String m_resourceTableIdField = null;
    protected String[] m_resourceTableOtherFields = null;
    protected String m_resourceEntryTagName = null;
    protected boolean m_locksAreInDb = true;
    protected StorageUser m_user = null;
    protected Hashtable m_locks = null;

    public BaseDbSingleStorage(String resourceTableName, String resourceTableIdField, String[] resourceTableOtherFields, boolean locksInDb, String resourceEntryName, StorageUser user) {
        this.m_resourceTableName = resourceTableName;
        this.m_resourceTableIdField = resourceTableIdField;
        this.m_resourceTableOtherFields = resourceTableOtherFields;
        this.m_locksAreInDb = locksInDb;
        this.m_resourceEntryTagName = resourceEntryName;
        this.m_user = user;
    }

    public void open() {
        this.m_locks = new Hashtable();
    }

    public void close() {
        if (!this.m_locks.isEmpty()) {
            Log.warn("chef", this + ".close(): locks remain!");
        }
        this.m_locks.clear();
        this.m_locks = null;
    }

    protected Resource readResource(String xml) {
        try {
            Document doc = Xml.readDocumentFromString(xml);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals(this.m_resourceEntryTagName)) {
                Log.warn("chef", this + ".readResource(): not = " + this.m_resourceEntryTagName + " : " + root.getTagName());
                return null;
            }
            Resource entry = this.m_user.newResource(null, root);
            return entry;
        }
        catch (Exception e) {
            Log.debug("chef", this + ".readResource(): ", (Throwable)e);
            return null;
        }
    }

    public boolean checkResource(String id) {
        String sql = "select " + this.m_resourceTableIdField + " from " + this.m_resourceTableName + " where ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(id) + "' )";
        List ids = Sql.dbRead(sql);
        return !ids.isEmpty();
    }

    public Resource getResource(String id) {
        Resource entry = null;
        String sql = "select XML from " + this.m_resourceTableName + " where ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(id) + "' )";
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            entry = this.readResource((String)xml.get(0));
        }
        return entry;
    }

    public List getAllResources() {
        Vector<Resource> all = new Vector<Resource>();
        String sql = "select XML from " + this.m_resourceTableName;
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            int i = 0;
            while (i < xml.size()) {
                Resource entry = this.readResource((String)xml.get(i));
                if (entry != null) {
                    all.add(entry);
                }
                ++i;
            }
        }
        return all;
    }

    public List getSelectedResources(final Filter filter) {
        Vector<Resource> all = new Vector<Resource>();
        String sql = "select " + this.m_resourceTableIdField + ", XML from " + this.m_resourceTableName;
        List xml = Sql.dbRead(sql, null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    String id = result.getString(1);
                    String xml = result.getString(2);
                    if (!filter.accept(id)) {
                        return null;
                    }
                    return xml;
                }
                catch (SQLException ignore) {
                    return null;
                }
            }
        });
        if (!xml.isEmpty()) {
            int i = 0;
            while (i < xml.size()) {
                Resource entry = this.readResource((String)xml.get(i));
                if (entry != null) {
                    all.add(entry);
                }
                ++i;
            }
        }
        return all;
    }

    public List getSelectedResourcesWhere(String sqlWhere) {
        Vector<Resource> all = new Vector<Resource>();
        String sql = "select XML from " + this.m_resourceTableName + " " + sqlWhere;
        List xml = Sql.dbRead(sql);
        if (!xml.isEmpty()) {
            int i = 0;
            while (i < xml.size()) {
                Resource entry = this.readResource((String)xml.get(i));
                if (entry != null) {
                    all.add(entry);
                }
                ++i;
            }
        }
        return all;
    }

    public Edit putResource(String id, Object[] others) {
        Resource entry = this.m_user.newResource(null, id, others);
        Object[] fields = this.m_user.storageFields(entry);
        Document doc = Xml.createDocument();
        entry.toXml(doc, new Stack());
        String xml = Xml.writeDocumentToString(doc);
        String statement = "insert into " + this.m_resourceTableName + this.insertFields(this.m_resourceTableIdField, this.m_resourceTableOtherFields, "XML") + " values ( " + "'" + Validator.escapeSql(entry.getId()) + "'," + this.valuesParams(this.m_resourceTableOtherFields) + " ? )";
        boolean ok = Sql.dbWrite(statement, fields, xml);
        if (!ok) {
            return null;
        }
        Edit edit = this.editResource(id);
        if (edit == null) {
            Log.warn("chef", this + ".putResource(): didn't get a lock!");
            return null;
        }
        return edit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edit editResource(String id) {
        Edit edit = null;
        if (this.m_locksAreInDb) {
            StringBuffer result;
            String statement = "select XML from " + this.m_resourceTableName + " where ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(id) + "' )" + " for update nowait";
            DBConnection lock = Sql.dbReadLock(statement, result = new StringBuffer());
            if (lock == null || result.length() == 0) {
                return null;
            }
            Resource entry = this.readResource(result.toString());
            edit = this.m_user.newResourceEdit(null, entry);
            this.m_locks.put(entry.getReference(), lock);
        } else {
            Resource entry = this.getResource(id);
            if (entry == null) {
                return null;
            }
            Hashtable hashtable = this.m_locks;
            synchronized (hashtable) {
                block8: {
                    if (!this.m_locks.containsKey(entry.getReference())) break block8;
                    Edit edit2 = null;
                    return edit2;
                }
                edit = this.m_user.newResourceEdit(null, entry);
                this.m_locks.put(entry.getReference(), edit);
            }
        }
        return edit;
    }

    public void commitResource(Edit edit) {
        Object[] fields = this.m_user.storageFields(edit);
        Document doc = Xml.createDocument();
        edit.toXml(doc, new Stack());
        String xml = Xml.writeDocumentToString(doc);
        String statement = "update " + this.m_resourceTableName + " set " + this.updateSet(this.m_resourceTableOtherFields) + " XML = ?" + " where ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(edit.getId()) + "' )";
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".commitResource(): edit not in locks");
                return;
            }
            Sql.dbUpdateCommit(statement, fields, xml, lock);
        } else {
            Sql.dbWrite(statement, fields, xml);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void cancelResource(Edit edit) {
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".cancelResource(): edit not in locks");
                return;
            }
            Sql.dbCancel(lock);
        }
        this.m_locks.remove(edit.getReference());
    }

    public void removeResource(Edit edit) {
        String statement = "delete from " + this.m_resourceTableName + " where ( " + this.m_resourceTableIdField + " = '" + Validator.escapeSql(edit.getId()) + "' )";
        if (this.m_locksAreInDb) {
            DBConnection lock = (DBConnection)this.m_locks.get(edit.getReference());
            if (lock == null) {
                Log.warn("chef", this + ".removeResource(): edit not in locks");
                return;
            }
            Sql.dbUpdateCommit(statement, null, null, lock);
        } else {
            Sql.dbWrite(statement);
        }
        this.m_locks.remove(edit.getReference());
    }

    protected String valuesParams(String[] fields) {
        if (fields == null || fields.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < fields.length) {
            buf.append(" ?,");
            ++i;
        }
        return buf.toString();
    }

    protected String updateSet(String[] fields) {
        if (fields == null || fields.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < fields.length) {
            buf.append(fields[i] + " = ?,");
            ++i;
        }
        return buf.toString();
    }

    protected String insertFields(String before, String[] fields, String after) {
        StringBuffer buf = new StringBuffer();
        buf.append(" (");
        buf.append(before);
        buf.append(",");
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                buf.append(fields[i] + ",");
                ++i;
            }
        }
        buf.append(after);
        buf.append(")");
        return buf.toString();
    }
}

