# This file is automatically generated - do not edit
# Generated by pod2help.pl from nxtvepg.pod at Sun Jul 18 15:03:12 2004

set {helpIndex(Description)} 0
set helpTexts(0) {{Description} title1 {
} {} {nxtvepg} bold { is an X11 and Win32API application to decode, analyze and browse TV programme schedules transmitted on analog TV channels as defined in ETS 300 707: "Protocol for a TV Guide using electronic data transmission" by the European Telecommunications Standards Institute.
} {} {The Nextview standard was developed for use in TV sets, but the data can be received and used in a PC, too - provided you have a Teletext capable TV tuner card and are lucky enough to have a Nextview content provider in your country.
} {} {nxtvepg} bold { enables you to obtain free TV programme listings for all of the major networks in Germany, Austria, France, Belgium and Switzerland. Currently Nextview EPG is transmitted by the following TV networks (note that each of these EPGs cover not only the provider's programme but also that of many other networks):
} {} {In Germany and Austria: Kabel1, RTL-II (coverage: apx. 32 networks)
} indent {In Switzerland: SF1, TSR1, TSI1, EuroNews (coverage: apx. 37 networks)
} indent {In France: Canal+, M6, TV5, EuroNews (coverage: 8 networks)
} indent {In Belgium: VT4 (coverage: 32 networks)
} indent {In Turkey: TRT (coverage: apx. 17 networks)
} indent {For up-to-date information check the nxtvepg homepage in the Internet (see the About popup in the Help menu). If you don't receive any of the channels listed above, you can only use the demo mode as described with the } {} {-demo} bold { command line option.
} {} }
set {helpIndex(Options)} 1
set helpTexts(1) {{Options} title1 {
} {} {Summary of command line options:
} {} {-display} bold { } {} {display} underlined {
} {} {UNIX only: The display on which the user interface will be placed, for example } indent {localhost:0.0} {bold indent} {. Default: taken from environment variable } indent {DISPLAY} {underlined indent} {. For more info see the } indent {X} {underlined indent} { manual page section } indent {Display Names} {bold indent} {
} indent {-tvdisplay} bold { } {} {display} underlined {
} {} {UNIX only: The display on which the TV application window is searched, e.g. on a remote host or different screen on a station with multiple monitors.  Default: same as the main window's display.
} indent {-geometry} bold { } {} {geometry} underlined {
} {} {Specifies the position of the main window, e.g.  } indent {-geometry -0+0} {bold indent} { to put the main window in the upper right corner of the visible screen. The size of the window cannot be changed.
} indent {-iconic} bold {
} {} {Start with the main window iconified (i.e. minimized).
} indent {For M$ Windows users this option may be esp. helpful when nxtvepg is started from inside the } indent {Auto start} {underlined indent} { group and } indent {Hide on minimize} {underlined indent} { is enabled: nxtvepg then will start almost invisibly in the background, only with an icon in the system tray of the task bar (see also } indent {Configuration: Show/Hide} {href indent} {).
} indent {-rcfile} bold { } {} {path} underlined {
} {} {Specify an alternate configuration file. Default: on UNIX $HOME/.nxtvepgrc, on Windows nxtvepg.ini in the current directory.
} indent {-dbdir} bold { } {} {directory} underlined {
} {} {Specify an alternate directory for the databases. Default: On UNIX } indent {/usr/tmp/nxtvdb} {underlined indent} {, on Windows the current directory. Note that the database management is not equipped for concurrent writing, so if you have more than one TV tuner card in your system or network, relocate the directory into the users' homes.
} indent {If you're using an acquisition daemon, the browser must be configured to use the same directory as the daemon.  If the daemon is running on a different host, you need to mount the remote directory, e.g. via NFS.
} indent {-card} bold { } {} {index} underlined {
} {} {Specify which TV card hardware to use, if you have more than card. Default: index 0. On Linux the given index is appended to the device names, i.e. } indent {/dev/vbi} {underlined indent} { and } indent {/dev/video} {underlined indent} { (see also } indent {Files} {href indent} {). On Windows index "n" means the n-th card found while scanning the PCI bus for cards with a supported capture chip (e.g. Brooktree Bt878, Bt878A, Bt848, Bt849, Philips SAA7134, Conexant 23881).  If you have more than one TV card with the same chip, the order between those is undefined, but still constant (i.e. the order is determined by the driver, not nxtvepg)
} indent {-provider} bold { } {} {CNI} underlined {
} {} {Select a provider by its hexadecimal CNI (Country and Network Identifier), e.g. } indent {-provider d92} {underlined indent} { for } indent {Kabel1} {bold indent} {. You can find out the provider's CNI during a provider scan or from the database file names. Use keyword } indent {merged} {underlined indent} { to dump a merged database (or use code } indent {FF} {underlined indent} { as required by earlier versions of nxtvepg.)  Note before you can use a merged database you have to configure it, see } indent {Merged databases} {href indent} {. Default if this option is omitted: the last provider selected during the previous session.
} indent {-noacq} bold {
} {} {Start with acquisition disabled. The acquisition can still be started later from the Control menu (see } indent {Control: Enable acquisition} {href indent} {).
} indent {-daemon} bold {
} {} {Start without the graphical user interface. The process will detach from the terminal (i.e. create an invisible window on M$ Windows) and perform background acquisition. If no other options are given the same provider and acquisition mode as configured with the GUI will be used. If the -provider option is given acquisition will work for this provider only (note the difference to non-daemon mode, where that option selects the browser database). The -daemon option cannot be combined with the -noacq or -demo options.
} indent {The daemon always creates a named socket in the } indent {/tmp} {underlined indent} { directory (UNIX only) plus optionally a TCP/IP socket to allow connects by browser processes. While connected, the browser receives updates for opened Nextview databases and reports about the acquisition progress; if left unconnected, the browser listing might be incomplete or outdated.
} indent {It's important to note that the browser } indent {must use} {bold indent} { the same } indent {-dbdir} {underlined indent} { directory, because the daemon forwards only deltas to the database files stored in that directory. For more details see } indent {Configuration: Client/Server} {href indent} {.
} indent {UNIX Warning: for security reasons it's depreciated to run the daemon with root privileges, because nxtvepg has not been reviewed yet for possible exploits. If you want to start the daemon already during system startup, you should use su(1). Also note that you'll probably need to specify -rcfile because the $HOME environment variable  might not be (correctly) defined.  Example:
} indent {   su nobody -c "/usr/local/bin/nxtvepg -daemon \ 
                 -rcfile /usr/local/etc/nxtvepgrc"

} {pfixed indent} {For terminating the daemon process, see the -daemonstop option below.
} indent {-daemonstop} bold {
} {} {With this option, a background acquisition process is searched and terminated if found; then the program exits. Note you need permission to send signals to the daemon process to be able to stop it (i.e. it must run with the same user ID).  This option is meant to allow controlling acquisition by scripts which start and stop acquisition automatically after a given time.
} indent {Note if the daemon is running on the same host and uid, it can also be stopped by deselecting } indent {Enable acquisition} {underlined indent} { in the } indent {Control} {underlined indent} { menu while being connected to the daemon. For more details see } indent {Control} {href indent} { and } indent {Files} {href indent} {.
} indent {-nodetach} bold {
} {} {UNIX only: In daemon mode this option prevents the process actually making itself a daemon, i.e. it doesn't fork and stays connected to the terminal. Also all log messages starting with level } indent {warning} {underlined indent} { are sent to standard error out (e.g. configuration errors that lead to an immediate exit).  This mode is intended for debugging purposes only.
} indent {-acqpassive} bold {
} {} {In daemon mode this option overrides the acquisition mode setting in the configuration file and forces acquisition into passive mode (see } indent {Acquisition modes} {href indent} {).  The configuration file is not changed, so that you can use different acquisition strategies for daemon and GUI.
} indent {-acqonce} bold { } {} {phase} underlined {
} {} {In daemon mode this option will automatically stop acquisition and terminate the daemon after the given phase has been completed for all providers.  Phases are the same as defined in } indent {Acquisition modes} {href indent} {, i.e. } indent {now} {underlined indent} {, } indent {near} {underlined indent} { and } indent {full} {underlined indent} {.  Note it's not useful to use this option in acquisition mode } indent {follow-ui} {underlined indent} {, i.e. it's only useful with a fixed list of providers.
} indent {-dump} bold { } {} {mode} underlined {
} {} {With this argument, nxtvepg will only export the database in XML format (see } indent {Control: Export as XMLTV} {href indent} {) or in a fixed text format (see also } indent {Control: Export as text} {href indent} {), then exit.  This argument must be combined with } indent {-provider} {underlined indent} { to specify which database is to be exported.
} indent {To export the database in XML format, use keyword } indent {xml} {underlined indent} { as mode.
} indent {For text export three mode keywords are understood: } indent {pi} {underlined indent} { to dump programmes (i.e. the complete TV schedules), } indent {ai} {underlined indent} { to dump the provider's network table, } indent {pdc} {underlined indent} { to dump the PDC theme table.
} indent {The output is written to } indent {stdout} {underlined indent} { unless you redirect it into a file or pipe it into another program.  Note to Windows users: since nxtvepg is not a console application, no } indent {stdout} {underlined indent} { is available, i.e. it's output will be discarded by the operating system unless you redirect it. For example you could enter the following command in the shell (or "MS-DOS prompt"):
} indent {  nxtvepg -dump ai -prov d92 > networks.txt

} {pfixed indent} {to write the network table of provider } indent {Kabel1} {underlined indent} { (CNI } indent {0xd92} {underlined indent} {) into a file called } indent {networks.txt} {underlined indent} {.
} indent {-remctrl} bold { } {} {command} underlined {
} {} {Windows only: This option can be used to remote control an other, previously started GUI instance of nxtvepg, i.e. to send the given command to the other process and then exit.
} indent {The following commands are available: } indent {quit} {underlined indent} { to terminate the other nxtvepg process; } indent {iconify} {underlined indent} { to minimize the window; } indent {deiconify} {underlined indent} { to undo a previous minimization; } indent {raise} {underlined indent} { to deiconify the other window and to bring it to the top (in case it's obscured by other windows); } indent {acqon} {underlined indent} { to start acquisition; } indent {acqoff} {underlined indent} { to stop acquisition.
} indent {-demo} bold { } {} {path} underlined {
} {} {Load database given by } indent {path} {underlined indent} { and enter demo mode. In this mode all entries of the database are shifted into the presence, i.e. just far enough so that none are expired. Hence the entries' dates and times are not for real and acquisition or database reselection is not possible.
} indent {-help} bold {
} {} {List all available command line options.
} indent {After the options you can add a database filename. This is equivalent to specifying } {} {-dbdir} bold { and } {} {-provider} bold {. The provider CNI is taken from the file name. If the file name does not have the format as defined in } {} {Files} href {, it's assumed to be a demo database and loaded just as with the } {} {-demo} bold { option. The database filename argument silently overrides any previously given options.
} {} {This is particularily useful for users of graphical file managers (like the Windows Explorer) who can just drag and drop a database file onto the executable. When used on Windows systems the working directory is set to the one that contains the executable, because the Explorer seems to set it to the user's desktop root, so that none of the DLLs and drivers are found.
} {} {Note to Windows users: all these options - unless otherwise noted - are available in the Win32 version too. You can supply the options either from a "MS-DOS" command prompt or batch file, or by appending them to the executable in a shortcut definition.
} {} }
set {helpIndex(Getting started)} 2
set helpTexts(2) {{Getting started} title1 {
} {} {Before you can start reading in TV programme schedules (called } {} {acquisition} underlined { from here on), you have to do just a few configurations. Which ones depends on your setup and will be described in this chapter. As long as your browser window contains no data, there's also a recommondation how to get to data in the browser window, highlighted by a yellow background.
} {} {This manual describes all features of nxtvepg in detail. You do not have to read all of it at once to operate the software. However it's recommended to skim at least through } {} {Basic browsing} href {, } {} {Data acquisition} href { and } {} {Filtering} href {.
} {} {TV card Setup on M$ Windows} title2 {
} {} {Windows users first have to configure the driver for their TV card in the 'TV card input' dialog from the Configure menu (for additional information see also } {} {Configuration: TV card input} href {). UNIX users can skip this section.
} {} {To start card configuration, press the } {} {Configure card} underlined { button in the middle of the dialog window, which will open another dialog.  If no supported TV capture chips were found in your system, the button will be disabled.  In case you see a message claiming } {} {PCI scan failed} underlined {, this means the TV card driver could not be loaded.  In this case close all other video applications and try again or look up a detailed description of driver error messages in the README file.
} {} {First press the } {} {Autodetect} underlined { button to the right of the dialog window; this will read certain parameter values from non-volatile memory on your card (EEPROM) to determine the manufacturer and model.  Optimally this will allow to derive all required parameters automatically.  If this succeeds, all your card's parameters will be set and you're done and can close the configuration dialog with Ok.  If you wish you can still override automatically derived values (e.g. tuner type) with the options described below.
} {} {If you get a message that says the card, but not the tuner, could be determined you can skip the next paragraphs and continue with the manual tuner selection.
} {} {If your card type could not be automatically determined, search and select your card type in the listbox at the left and then press the } {} {Pick from list} underlined { button or double click on the listbox entry. Note: The card list is identical to the } {} {DScaler} bold { TV application (also very similar to } {} {K!TV} bold {); the same is true for the tuner list. Hence if you're unsure, the easiest way is to look up your configuration in DScaler and just copy it here.
} {} {For certain card types, the card is queried for the tuner type after manual card selection.  If this fails, you'll get a message and have to select the tuner manually.
} {} {To configure a tuner type, open the tuner selection popup menu by clicking on the } {} {Configure} underlined { button and select one of the entries.  For many cards the tuner type is printed on the outside of the retail packaging. Yet a better way is to read the tuner type from the metal shielding box on the card itself.
} {} {Some hints for figuring out your settings:  For many cards the selected card type is not relevant to nxtvepg (i.e. only tuner and for Bt878 cards the PLL).  Hence if you don't find your card in the list don't worry, just use any PAL or SECAM card entry in the list and set the other parameters manually.  To check your configuration start an EPG scan.  Before you do so you must leave the configuration sub-menu with OK so that the changes are applied.  For your convenience, you can open the card configuration dialog with a button in the EPG scan dialog window.
} {} {Hints for tuner selection: If you live in Germany, Austria or Switzerland you probably have a PAL tuner, in France it's one of the SECAM types. If you select the wrong tuner, you can have either no reception at all (the EPG scan will just run through and suggest to check your antenna) all or no reception just on a few channels.
} {} {For cards built around a Brooktree chip (Bt878 et.al.) the type of PLL initialization also needs to be set.  This setting is directly tied to your card selection, hence usually you will not need to set it manually. Usually the correct value for } {} {PLL initialization} underlined { with PAL and SECAM cards is either } {} {No init} underlined { or } {} {28 MHz} underlined {. (If you select the wrong value you have no reception at all.)
} {} {Video input configuration} title2 {
} {} {Before nxtvepg can start acquiring EPG data, it must be told if the video feed is provided by your TV card's internal TV tuner (if you're connected to your city's TV cable network or a terrestrial antenna) or an external source (usually satellite receivers connected via Composite or S-Video cable).  This can be configured in the } {} {TV card input} underlined { dialog in the Configure menu (for more in-depth information see also } {} {Configuration: TV card input} href {).
} {} {By default nxtvepg assumes input via TV tuner.  This is the preferred mode of operation, since nxtvepg can change channels between multiple Nextview providers, while with an external source you have to switch channels manually (see also } {} {Data acquisition} href {).  If you're living in France you should tell nxtvepg to use the French channel table (which implies using the Secam TV norm instead of PAL B/G/I); this information is required for the next step: the EPG scan.
} {} {If you cannot use the TV tuner but have instead connected a satellite receiver through the Composite or S-Video input, select the respective setting in the } {} {video input} underlined { drop-down menu.  Then close the dialog with Ok and open the aquisition mode configuration dialog from the same menu. There you should change to the } {} {external} underlined { mode: in this mode nxtvepg will switch to the configured video input channel during startup of acquisition, but afterwards expect you to tune in a Nextview provider's channel at the external video source. To load all provider's inventories in the way the EPG scan does, you have to tune in all provider channels (for a list see the intro of this manual or the Internet homepage) and wait until the status line changes from "starting up" to "working on".
} {} {Note that you can also connect your satellite receiver via antenna cable. However this  variant is highly depreciated, because the signal is often degraded so much that nxtvepg is not able to decode the EPG data stream any more.  But if you still want to go that route, you'd keep the tuner as input source and start an EPG scan to find the channel your receiver is transmitting its signal on.  Make sure to disable the } {} {Use .xawtv} underlined { option in the provider scan dialog, unless your satellite receiver's channel (i.e. the frequency onto which the satellite signal is modulated) is defined as an input channel in xawtv.  Before you start the EPG scan you need to tune in a Nextview provider's channel.  The scan will only find that one provider. If you want to load all providers you have to continue manually as described above.  For an acquisition mode it's recommended to stay with } {} {Follow browser database} underlined {. Although nxtvepg will not be able to actually "follow" your provider selection with the acquisition since it can't switch the TV channel at your external input, this mode will tell nxtvepg to set the TV tuner onto your receiver's channel (see also } {} {Acquisition modes} href { for more details.)
} {} {EPG scan: Search for Nextview providers} title2 {
} {} {This section only applies if you chose to use your TV card's internal tuner.  In this case the next step to get started is to run a provider scan from the Configure menu.  During the scan all TV channels are checked for Nextview transmissions and a list of Nextview providers is built from the result.
} {} {You can speed up the scan by using a TV application's channel table; in this case the scan is limited to TV frequencies defined in the TV app's channel table. This mode is enabled with the } {} {Use TV app freq. table} underlined { checkbutton.  This button will be disabled until you've selected a TV application in the } {} {TV app. interaction} underlined { dialog described in the next chapter.  You can open this dialog by pressing the button at the bottom of the EPG scan dialog window.
} {} {At the end of the scan there's a short summary which tells you how many providers have been found.  If there were any, you can close the dialog window and open the provider selection dialog from the Configure menu and select you favorite one.  Then wait a little while the provider's TV channel is tuned and data being loaded.
} {} {If the provider scan does not find any or not all Nextview provider channels (possibly due to weak reception - this is a very simple scan that does not attempt any fine-tuning) enable the } {} {Slow} underlined { button and try again. If this does not help, you can still add the missing providers manually. set the acquisition mode to } {} {external} underlined { or } {} {passive} underlined { (UNIX only). Then use an external application to tune the channel (Windows users have to stop acquisition first; then start the TV application; then tune the channel; then quit the other application; finally start acquisition again).
} {} {In external mode nxtvepg will not touch the tuner and wait infinitly for Nextview reception on the current channel.  On Windows (and Linux with bttv drivers version 0.7.50 and earlier) this method has the disadvantage that no channel number or frequency will be known for this provider so you have to tune the provider's channel manually whenever you start acquisition.
} {} {Acquisition of a complete database takes about 20 minutes. However programmes that are nearer in the future are available much faster, since they are transmitted more often. The currently running and directly following programmes of all networks are usually available after about 2-3 minutes max.
} {} {Configuring a TV application} title2 {
} {} {nxtvepg can cooperate in the following ways with TV applications:
} {} {Loading the TV application's channel table: use of the TV tuner frequencies can significantly speed up the EPG scan (already mentioned above.) The TV app's channel names are used by the  } indent {Network name} {underlined indent} { dialog in the Configure menu (see } indent {Configuration: Network names} {href indent} {) to synchronize network names between nxtvepg and the TV application.
} indent {Interaction between nxtvepg and the TV application, to provide you with convenience features like an on-screen display of the current programme title after channel changes, changing the channel from inside nxtvepg with the } indent {TuneTV} {underlined indent} { button, and background Nextview data acquisition while you're watching TV.
} indent {The first one is a passive feature, i.e. only nxtvepg needs to be adapted to the respective TV applications.  The secind one however requires cooperation of both sides.  For this reason the number of TV applications for which the passive features are supported will always be much larger.  On Windows the interaction features are currently only supported by K!TV.
} {} {On UNIX only } {} {xawtv} underlined { and } {} {xawdecode} underlined { are supported currently. With both all the features listed above do work.
} {} {On Windows several freeware TV applications are supported for the passive features; you must select which one you're using. If you've loaded TV card settings from a TV app in the } {} {TV card input} underlined { dialog, then the TV app type and path is already configured.  Else, or if you want to use a different app as source for the channel table, open the } {} {TV app. interaction} underlined { dialog (see also } {} {Configuration: TV application interaction} href {).
} {} {Regarding the second feature, i.e. the "active" one: You can check if nxtvepg is able to interact with a specific TV application by starting both, and then opening the TV application interaction dialog in  the Configure menu.  The connection status is indicated in the middle of the dialog window.  Usually nxtvepg will already display an error message when it's started while an unsupported TV application is running, complaining "Capturing is already enabled in the TV card" or another driver error message.  Only with cooperating TV apps nxtvepg is able to automatically free the card when the TV app is started (TV viewing is always given priority over EPG data acquisition.)
} {} {Important} bold {: On Windows you must not run nxtvepg with acquisition enabled at the same time as a TV application.  If you ever accidentially do that, immediately terminate both applications.  When two applications access the TV card hardware at the same time, the resulting conflicts can crash your system.
} {} {After setting up the TV app type and path, you should open the } {} {Network name} underlined { configuration dialog to synchronize network names between nxtvepg and the TV app.  Even if interaction is not possible, it may still be a good idea to have the same network names in both applications.  See } {} {Configuration: Network names} href { for details.
} {} }
set {helpIndex(Basic browsing)} 3
set helpTexts(3) {{Basic browsing} title1 {
} {} {The browser mainly consists of two windows: the upper one contains a list of programme titles, sorted by start time. All currently running programmes (or rather: all programmes that should be running according to their start time) are marked by a light blue background color. One line in the list is selected by a cursor; the lower window contains the attributes and description for this selected title. The amount of information available here depends entirely on the content provider.
} {} {The basic browsing of programme information works very straight-forward. You can either use the mouse or the keyboard cursor keys:
} {} {With the mouse, you can click on any title to select it and display its description in the lower window.  Use the scrollbar to the left to scroll the listing forward to programmes farer in the future, or the weekday scale on the right to jump to a specific time and date.
} {} {With the keyboard, use the Cursor up/down keys to select any title. For fast scrolling use the page up/down keys. With the Home key you always get back to the first title. With TAB and SHIFT-TAB you can move the keyboard input focus to other input elements, e.g. to the network and shortcut lists; to apply a selected theme or shortcut as filter press the } {} {Space} bold { key. The first 10 shortcuts can also be enabled directly from the main window with the digit keys 1-9 and 0. Control-C in the main window opens the context menu; Control-F opens the text search dialog; the Escape key is equivalent to the Reset button.  The menus can be accessed by pressing the ALT key together with the underlined character in the respective menu button.
} {} {You can restrict the programme selection in many ways to make it easier to find what interests you.  For example, you can restrict the list to programmes of a certain network; or you can restrict the list to movies only.  This process is called } {} {filtering} underlined { and explained in detail below, see } {} {Filtering} href {.  For the most common filter options there's a list of } {} {Shortcuts} underlined { at the left of the main window.  Note you can freely modify this list, see } {} {Filter shortcuts} href {.
} {} {Since version 2.5.0 nxtvepg offers two different layouts for the TV schedules: By default programmes of all channels are combined in a single list sorted by start time, i.e. one big table.  Alternatively programmes can be separated so that each network has it's own column. This format is very similar to most paper-based TV magazines.  In this layout you can scroll both vertically by start-time and horizontally by networks.
} {} {When you resize the main window vertically the difference in height will be added to the info text window at the bottom.  You can adjust the proportions between program listbox and the info text with the "panning" button inbetween, i.e. by dragging the button you can resize the programme list.
} {} {nxtvepg can interact with TV applications (e.g. } {} {xawtv} underlined { on UNIX; requires initial setup, see } {} {Getting started} href {) to provide a connection in both directions: Firstly you'll find a } {} {Tune-TV} underlined { button in the main window below the clock. When you press it, the network of the currently selected programme will be tuned in the TV application.  This also works with a double-click on the programme or pressing the } {} {Return} underlined { key.  By clicking the right mouse button above the Tune-TV button you can also pop up a small menu which offers basic TV controls.  Secondly, when you change the channel in the TV application, the cursor in the nxtvepg main window will automatically jump onto the programme currently running on that network. You can manually trigger this reaction by pressing "i" on your keyboard. For more details see } {} {Configuration: TV application interaction} href {
} {} {At the bottom of the window there is a status line which informs you about the state of the browser database and background acquisition. It's basically a very dense summary of the } {} {Statistics} bold { popups from the } {} {Control} bold { menu and is especially useful to warn you about the database age or stalled acquisition.
} {} {Note:} underlined { For most providers it holds true that programme content descriptions (i.e. the texts in the lower nxtvepg window) are available only for currently running programmes and those whose start time is very close. This time span for full coverage can be as short as 2 hours, or 3 titles per network. As a consequence you should enable data acquisition as often as possible; consider running the acquisition daemon permanently in the background. For details on the acquisition process see the following chapter.
} {} }
set {helpIndex(Data acquisition)} 4
set helpTexts(4) {{Data acquisition} title1 {
} {} {As long as acquisition is enabled, programme titles are constantly being acquired or updated in the background. You will notice that all incoming programme information is instantly inserted to the programme listing. Every effort is taken to not alter the cursor position or title selection, except if the cursor is on the very first item - then the cursor stays on top.
} {} {By default, the acquisition always works for the provider whose database you have loaded into the browser. Therefore, upon program start or whenever you switch providers, the TV tuner is set onto the frequency of the provider's TV channel.  Please note that this mode is only possible after a provider scan, because that's the only way to find out the frequencies. Check out } {} {Acquisition modes} href { for more sophisticated acquisition strategies.
} {} {If you do not choose the TV tuner as input (e.g. if you choose an external source via the Composite or S-Video input sockets), or if the TV tuner is kept busy by another application (UNIX only, e.g. if you watch TV) data is still being acquired, but it's no longer possible to automatically change the TV channel. Hence you are resposible for selecting the channel of the provider who's database you want to load or refresh. If a transmission belonging to a different provider than the one selected in the browser is detected, a second database is automatically opened in the background to store the incoming data.
} {} {The transmitted database is constantly in change: Elapsed titles are removed, new titles appended, and the titles closest to the current time updated with an increased amount of description. (The reason that the complete description is not transmitted for all titles is simply that the size of the database has to be reduced - it shall be transmitted in 20 minutes maximum.)  So you should start the acquisition as often as possible, about every 2-3 hours, at least a couple of minutes before you browse.
} {} {You can monitor the progress of acquisition with the timescale and database statistics windows from the Control menu. See } {} {Statistics} href { for details.
} {} }
set {helpIndex(Acquisition modes)} 5
set helpTexts(5) {{Acquisition modes} title1 {
} {} {The acquisition mode configuration dialog enables you to control for which providers data is collected, and in which order. It's mainly intended for users who use more than one provider's database, i.e. in a merged database, or want to optimize startup time. If you're happy with a single provider or don't want to browse immediately after program start, you should keep the default, which is loading data always for the provider selected in the browser.
} {} {Passive} bold {
} {} {UNIX only: In this mode the software never accesses the video device and never changes the input channel or tuner frequency.  It's useful if you want to set up the source with command line tools like } indent {v4lctl} {underlined indent} {. If you're using applications which keep the video device busy (e.g. a TV application) you don't need this mode, because when nxtvepg detects an unsolicited channel change, it automatically switches to the passive mode for as long as the video device remains busy.
} indent {Please note: when nxtvepg does not control the input channel, it can not automatically take care of updating your databases. Even if the browser database should be completely empty, no data will appear until you tune in the provider's channel manually with an external application. Because of this, passive mode is depreciated.
} indent {External} bold {
} {} {This is the recommended mode for Composite or S-Video input sources. Only the input source will be set; the tuner is not touched. Hence the provider channel has to be selected either externally (e.g. in a satellite receiver connected to the Composite or S-Video input sockets) or by a different application (e.g. TV application, UNIX only), just like in passive mode.
} indent {On Windows systems this mode can be used if your tuner is not known to nxtvepg, i.e. if the EPG scan does not find any channels with all of the available tuner types. In this case tune in the provider channel with a TV application; then quit this application and start nxtvepg. When you view the acquisition statistics from the Control menu, the VPS/PDC code of the tuned channel should appear in the lower half of the window.
} indent {Follow-UI} bold {
} {} {This is the default mode: the acquisition always works for the provider you have selected for the browser (i.e. user interface). If you change the provider in the browser window, acquisition follows by tuning the new channel. Of course this requires to have performed an EPG scan at least once, so that the tuner frequencies of all providers are known. When you use a merged database in the browser, acquisition works on each of the merged providers, one after another, just like in the mode described next.
} indent {Manually selected} bold {
} {} {This mode enables you to manually select for which providers the acquisition should work. If you select more than one provider, they are loaded one after another, in your specified order. Warning: if you choose a provider for the browser that's not on the list, no data will be loaded into the browser, even if it's completely empty.
} indent {Since transmission errors have to be considered, it's not attempted to load every single block of a provider before acquisitions switches to the next. Instead a statistical criterium was defined, that regards the variance in coverage of all networks contained in the database, and the slope of that variance.
} indent {Cyclic: Now - Near - All} bold {
} {} {Like the previous mode, this one enables you to specify a list of providers to load data for. However they are not just loaded completely one after another. Instead, a 3-staged round-robin is implemented. In the first stage, only } indent {Now} {underlined indent} { data is loaded, i.e. the currently running and next 2-3 programmes. When this has been completed for all providers, the next stage begins, which loads } indent {Near} {underlined indent} { data, i.e. all programmes running in the next 12-24 hours. When that was completed, the final stage loads the outstanding blocks for all providers. See below for an explanation what this mode is good for.
} indent {Cyclic: Now - All} bold {
} {} {This is the same as the previous mode, except that the } indent {Near} {underlined indent} { stage is skipped.
} indent {Cyclic: Near - All} bold {
} {} {This is the same as the mode before the previous one, except that the } indent {Now} {underlined indent} { stage is skipped.
} indent {Which mode is best for you depends on how you use the browser. As said above, if you're mainly using a single provider, stick with the Follow-UI mode. If you use a merged database, data is automatically loaded for all contained providers. However if you switch manually between multiple providers, you should choose one of the manual acquisition modes.
} {} {The Cyclic modes enables you to optimize startup time. While in standard manual mode, the first database is loaded completely before the next one is started, in Cyclic modes you can specify to load only Now data of all providers first. Hence already after a couple minutes you'll have updated Now information for all providers. If you require more look-ahead than the next 2-3 programmes, e.g. the complete evening, use a Cyclic mode that starts with the Near stage.
} {} {If you use manual acquisition together with a merged browser database, make sure to put the same provider at top in both lists, i.e. acquisition should always start for the "master database" of the merge.
} {} {Please note that the time until all databases are complete is longer in the cyclic modes than in standard manual mode. In general, the time used for the Now and Next stages just adds to the time to complete the database.
} {} {Also note that the cyclic modes depend on the transmission cycles of the providers. Firstly this means that the time ranges covered by the cycle stages may differ between providers. Secondly, the cycle times may vary. In the worst case the Near cycle runs as long as the cycle for the complete database (e.g. the German provider RTL2). In this case you don't win anything by selecting a mode that contains a Near stage.
} {} }
set {helpIndex(Statistics)} 6
set helpTexts(6) {{Statistics} title1 {
} {} {There are currently three ways to obtain information about the state of the databases and the acquisition process: the first and most obvious is the status line at the bottom of the main window (only if enabled, see } {} {Configuration} href {). The second one are the timescale popup windows, which visualize for each TV network the time ranges which are covered with TV programme data. The third one are the database statistics popup windows which offer technical details about the database, e.g. which percentage of entries is already loaded etc., both in textual form and as charts.
} {} {The latter two windows are available separately for the browser and acquisition databases. (By default both are the same databases, but you can configure background acquisition on multiple databases, see } {} {Acquisition modes} href {).  All types of statistics are regularily updated while acquisition is running.  While connected to an acquisition daemon, all statistics output refers to the acquisition running in the daemon (see } {} {Control: Connect to acq. daemon} href {)
} {} {Status line} title2 {
} {} {The status line separately summarizes the state of the browser database (unless it's a merged database) and the acquisition process. Since there's not much room only the most relevant information is included there, i.e. the kind of information presented depends on the current state.
} {} {For the browser database you'll normally just see the name of the content provider network and a percentage that describes how many of the blocks (i.e. TV programmes) in the provider database already have been received.
} {} {If more than 10% of the blocks in the database lie in the past, you'll additionally see a note about this percentage of expired blocks. Note that a 100% loaded database may appear completely empty when all blocks are expired.  As soon as you start acquisition the fill percentage will drop to 0 because a new inventory will have been loaded which no longer contains the expired blocks.
} {} {When acquisition for the browser database stopped more than 60 minutes ago, a note is added to the status line. In this case it may be advisable to start acquisition for this database to load descriptions for programmes that are now included in the "Near" time range (see } {} {Data acquisition} href {).
} {} {If acquisition is currently not active you'll see a note about that, often together with a reason, e.g. "no reception" when you've manually tuned a station that doesn't transmit Nextview.
} {} {Else you'll see the name of the content provider network and a percentage that describes the progress of acquisition. Note that this percentage may be different from the overall fill percentage given with the browser database, as it also reflects blocks that have to be reloaded due to version changes.
} {} {Additionally there may be a note about the current mode of acquisition, like the current phase for cyclic acquisition modes or "forced passive" when nxtvepg is not able to change the channel, maybe due to a TV application running in parallel. See } {} {Acquisition modes} href { for details.
} {} {Timescale popup windows} title2 {
} {} {You can monitor the progress of acquisition with the timescale windows which can be opened from the Control menu. There's one window for the browser database, and one for the acquisition database. The acquisition window is updated whenenever new EPG blocks are received.
} {} {The timescale windows have one scale for each network covered by the selected provider. The left end of the scales refers to the start time of the oldest TV programme in the database.  Depending on how long ago the database was updated and the current expiry removal delay (see } {} {Filtering: Expired Programmes Display} href {), some or all TV programmes may lie in the past. The exact dates are printed in the date scale at the top of the window, the current time is additionally marked with a small arrow labeled "now".
} {} {Ranges that are covered by programmes of the respective network in the database are marked in shades of red or blue, uncovered ranges are left black. The different colors reflect the } {} {stream} underlined { in which the data was received, or an error status; the shades age and version. Stream numbers are directly connected with the cycle phases mentioned in } {} {Acquisition modes} href {; besides this the difference is not relevant during normal operation.
} {} {red:} underlined {
} {} {PI blocks received in stream 1, i.e. cycle phase 'Near'.
} indent {blue:} underlined {
} {} {PI blocks received in stream 2, i.e. cycle phase 'All'.
} indent {dark red or blue:} underlined {
} {} {PI blocks from an earlier database version.
} indent {orange:} underlined {
} {} {expired PI blocks from stream 1.
} indent {cyan:} underlined {
} {} {expired PI blocks from stream 2.
} indent {yellow:} underlined {
} {} {invalid PI blocks (overlapping or zero run-time, block number not in the range given in inventory, etc.)
} indent {gray:} underlined {
} {} {missing PI blocks. Note that the range can only be roughly estimated, as the time range a block covers is not known until the actual block is available.
} indent {black:} underlined {
} {} {time range which is not covered by the provider.
} indent {Programmes for which description texts are currently available are additionally marked by an increased height of the scale in the covered time range.  For short-info the area is extended towards the top, for long-info towards the bottom (the distinction between short and long info is only related to the Nextview transmission specification and does not neccessarily relate to the length of the description texts; also note that for the merged database there's no distinction between short and long info because all texts are concatenated into one.)
} {} {In front of the scales there are 5 separate boxes, which refer to the first 5 programmes (PI blocks) in the inventory (AI block).  They have two purposes: firstly, during acquisition you can see when the 'Now' cycle phase is complete; secondly you can check if the data from the Now cycle is expired (marked orange).  If all 5 are orange, it's time to update the database.
} {} {Database statistics} title2 {
} {} {There are two popup windows available from the Control menu which contain statistical information about the browser database and the acquisition database and progress. The window is horizontally divided in two parts: the upper part lists static information; the lower part lists dynamic info and is available only while acquisition is active.
} {} {The acquisition statistics are updated every time a new AI block (inventory which lists all covered networks and block counts per network; usually transmitted every 10 seconds) is received.
} {} {Last AI update:} underlined {
} {} {The (local) time when the last inventory block was received. Since this block has to be transmitted on a regular basis it tells you when acquisition was active for this database.
} indent {Database version:} underlined {
} {} {The version number is incremented by the provider every day or after content changes.  A version change forces a complete reload of the database.
} indent {Blocks in AI:} underlined {
} {} {How many blocks are transmitted in total. This number is taken from the provider's AI block, i.e. the inventory.  Additionally listed separately for stream 1 and 2 (swo).
} indent {Block count db:} underlined {
} {} {How many blocks are in the local database. At maximum this can be the number of blocks given in the AI block.
} indent {Current version:} underlined {
} {} {How many blocks are in the local database and have the latest version.
} indent {Filled:} underlined {
} {} {Percentage of blocks in the database in respect to the total given in the AI block, i.e. "Block count db" divided by "Blocks in AI". The second percentage in the line only reflects blocks of the current version and hence the degree of completeness of acquisition.
} indent {Expired stream:} underlined {
} {} {Number of programme blocks which have a stop time that's in the past but are still registered in the provider's inventory (AI).  When acquisition is stopped, this number can be large.  During acquisition expired programmes are usually stripped by the provider with the start of every cycle, i.e. usually every 20-25 minutes.  The percentage given here is in respect to the actual number of blocks in the local database (all versions), not the AI.
} indent {Expired total:} underlined {
} {} {Total number and percentage of expired blocks in the database.  This value depends on the expire "cut-off time" configured by the user, i.e. on how long expired blocks are kept until they are removed from the database. Normally such blocks disappear from the programme list, but this can be changed with the expire time filter in the Filter menu (see also } indent {Filtering} {href indent} {).
} indent {Defective blocks:} underlined {
} {} {Number of blocks with invalid or overlapping start time. These blocks do not show up in the browser (as it would be impossible to handle if there is more than one "now" entry for a network).  The percentage given here is in respect to the actual number of blocks in the local database (all versions), not the AI.
} indent {The pie chart on the left on the window visualizes these numbers. The circle represents 100% of the blocks listed in AI.  It's divided in stream 1 (red) and stream 2 (blue). The shaded segments represent the blocks that are still missing in the local database. The yellow segments the percentage of expired and/or defective blocks.
} {} {When you interpret those values, please remember that blocks may be appended to the transmission cycle when programmes have expired (in a slight violation of the Nextview standard this is done even without changing the database version). So you might see from time to time that the fill percentages take a step back down during acquisition. Also note that expired PI are not accessible from the user interface, however they are included in the database dump from the } {} {Control} underlined { menu.
} {} {Acquisition statistics} title2 {
} {} {Acq. runtime:} underlined {
} {} {How long the acquisition has been continuously running for this database. This timer is reset upon provider or database version changes or when an external channel change is detected.
} indent {Channel VPS/PDC:} underlined {
} {} {The VPS/PDC code that has last been received on the currently tuned channel. Usually this will be the same as the provider CNI given in the database statistics, but you might see different values here when you manually tune in a different channel with an external application.
} indent {If a valid VPS/PDC code (Programme Identification Label, PIL) was received together with the CNI it is appended after the CNI in decoded format (i.e. DD.MM HH:MM with day, month, hour and minute).  Note: the VPS/PDC codes are used to uniquely identify the current programme on a given network.  You can display the codes for all programmes in the database (if you enable them in } indent {Configuration: Select attributes} {href indent} {) or pass them to external applications (see } indent {Configuration: Context menu configuration} {href indent} {)
} indent {TTX data rate:} underlined {
} {} {The rate at which teletext data lines are received on the current channel in baud, i.e. bits per second.  Each teletext line counts as 45 bytes.
} indent {EPG data rate:} underlined {
} {} {Same as TTX data rate, however only teletext lines that belong to the page which transmits Nextview are counted.
} indent {EPG page rate:} underlined {
} {} {The per second average of received teletext pages with carry Nextview data. Many provider transmit one page per second during the day and up to 1.5 or 2 pages per second during the night.
} indent {AI recv. count:} underlined {
} {} {The number of AI blocks received since acquisition start.  As long as this counter remains at zero, no data is added to the database (because the AI block is mandatory to identify the provider.)
} indent {AI min/avg/max:} underlined {
} {} {The minimum, average and maximum distance between reception of AI blocks. The average should usually be 10 seconds.  The maximum should not be much higher or else an EPG scan might have a hard time finding this provider; also the acquisition start-up time would be higher because at first an AI block must be awaited.
} indent {PI rx repetition:} underlined {
} {} {The average of the number of times each block in the AI was received since start of the acquisition.  Divided in Now, stream 1 and stream 2. This value is used by acquisition control in the termination criterium for acquisition phases, if the acquisition mode is cyclic.
} indent {Decoder quality:} underlined {
} {} {Reception and loss statistics: Count of received EPG teletext pages and count of complete EPG pages missing in the sequence.  Count of received teletext packets (usually 23 per page) and missing packets.  Note: page and packet loss is usually caused by decoding errors in packet and page headers (which carry a 50% redundancy so this is a strong indication of weak signal quality) or when a TV application running in parallel interferes with capture configuration (i.e. when not all required lines in VBI can be received)
} indent {Next is the number of received and dropped blocks.  Blocks are usually assembled from data received in several teletext packets and have to be dropped if packets or pages inbetween are missing. Blocks may also be dropped due to decoding or check-sum errors (above note regarding these errors applies here too)
} indent {The final line lists the number of decoded text characters (e.g. programme titles and descriptions) and how many decoding errors were detected. Forward error protection used for text is pretty weak, so you may see errors here even with relatively good signal quality.  With bad signal quality the actual error rate might be higher then displayed, since the protection cannot detect double-bit errors.
} indent {Acq mode:} underlined {
} {} {The current acquisition mode as configured by the user, or forced passive if nxtvepg failed to switch the channel.
} indent {Network variance:} underlined {
} {} {The variance of block coverage across all networks. This value is used by acquisition control in the termination criterium for acquisition phases, if the acquisition mode is cyclic. It's calculated by separately counting the number of blocks in the database for each network; then for each network calculating the percentage of available blocks in regard to expected blocks; then calculating the average and finally variance of these percentages.
} indent {The diagram at the left displays a history of fill percentages for stream 1 and 2; the meaning of the colors is the same as in the timescale windows.
} {} }
set {helpIndex(Merged databases)} 7
set helpTexts(7) {{Merged databases} title1 {
} {} {If you compare databases of different Nextview providers, you will often find that each has one or more nice features, or covers networks, that the others lack. Instead of changing back and forth between several providers all the time, database merging allows to select and combine features or networks from several original databases into one newly created database.
} {} {When you select the } {} {Merge providers} bold { entry from the } {} {Configure} bold { menu, you will get a dialog with two listboxes: the left one contains a list of all currently available databases. The right one is the list of databases you want to merge. You can add, delete or reorder the entries is this list. When you're done with your selection, press } {} {Ok} bold { to start the merge and switch the browser to the new database.
} {} {By ordering providers in your selection, you assign priorities which are important for conflict resolution. A conflict occurs when programme start and stop times differ between providers. The likelyhood of such conflicts depends on the quality of your providers; theoretically they should never happen except if there are late program changes. In reality, conflicts are not that unlikely, particularily for programmes early in the morning. You should put the most reliable provider in the first position, because conflicting programmes from providers further down will be rejected, i.e. not added to the merged database.
} {} {The } {} {Configure} bold { button in the dialog gives you fine-control over the priority of providers during the merge of all distinct programme attributes. You can even completely remove a provider for an attribute, e.g. if they transmit false data (e.g. the Sound attribute was at some time handled wrong by the former German provider 3Sat: they did swap stereo and surround).  An exception is the title, where you must not delete any providers.
} {} {Attributes that cannot be merged, e.g. editorial rating, are fetched from the first database in the list that contains the attribute for a given programme.  An exception are sorting criteria and series, where only the first provider in the list is queried (i.e. even if the first provider does not have a sorting criterion for a given programme, the further databases are not searched) because these types of attributes cannot be mixed between providers (see also } {} {Filtering} href {).
} {} {Note: If you use a manual or cyclic acquisition mode, you should take care to include all providers of your merged database in the same order. Else, program changes will not appear in your database until the provider with highest priority is loaded. If you stay with the default } {} {Follow-UI} bold {, acquisition control will automatically cycle across all merged providers in the correct order.
} {} }
set {helpIndex(Navigate)} 8
set helpTexts(8) {{Navigate} title1 {
} {} {The Navigate menu contains a tree of filtering options, that's transmitted by the selected provider together with the programme data. Filtering enables to restrict the listing of programme information to those titles matching the selected menu entry.
} {} {The extent and content of this menu depends entirely on the provider. Unfortunately most providers supply only a very limited menu, so you'll probably want to define your own filters, as described in the next two chapters.
} {} {Any filter selection can always be undone by the } {} {Reset} underlined { menu entry or the reset button in the main window.
} {} {On Windows this menu is en entry inside of the } {} {Filter} underlined { menu for technical reasons (the concept of danamically created menu hierarchies seems to be foreign to Windows, so a popup menu has to be used for the Navigate menu).
} {} }
set {helpIndex(Filtering)} 9
set helpTexts(9) {{Filtering} title1 {
} {} {Similar to } {} {Navigate} underlined {, this menu allows to control which of the programmes in the database are presented in the listing.  However here, you are not limited to a preselection of filter options.  There's a filter for every kind of attributes that can be attached to a program, e.g. it's network, start time, theme descriptors, and so on.
} {} {Filters can be undone either singularily by selecting the same filter menu entry again, or globally by clicking on the } {} {Reset} underlined { button.
} {} {You can combine as many filters as you want to build a complex filter. If you combine two filters of different types, only programmes that match both attributes will be listed (logical AND). If you choose more than one filter of the same type, all programmes that match either attribute will be listed (logical OR).  Note some filter types also support multiple "classes" which allow logical AND within a category; this is explained in more detail in the filter types list below.
} {} {Examples:} underlined { If you want to get all programmes listed for either network A } {} {OR} bold { B, simply select both networks in the filter list. If you want to see all movies scheduled on A, i.e. all programmes which run on network A } {} {AND} bold { are flagged as movies, select network A and theme "movie - general".
} {} {Filter Types} title2 {
} {} {The following filter types are available:
} {} {Theme categories} bold {
} {} {Restrict the listing to programmes that have any of the given theme categories attached to them (logical OR). The Nextview standard contains a list of 76 predefined themes, which are structured into 11 main categories and subcategories. A programme can have up to 7 theme descriptors attached.
} indent {If you want to restrict the listing to programmes that have more than one of the given themes (logical AND) you need to specify them in different theme classes. For example: to get a listing of all programmes which are both Sci-Fi and Comedy, select theme category Sci-Fi, then switch to a different theme class, and select theme category Comedy. The actual class numbers do not matter, you just need to use two different ones (i.e. you can use either #1 and #2 or #5 and #6 etc.)
} indent {Series} bold {
} {} {Restrict the listing to programmes that belong to any of the selected series. A series code always implies a network specification (even if the same programme is transmitted on different networks).
} indent {Note: This filter type is only available for providers that assign series codes; also not all series may have a code assigned.  For other ones you can use text search among programme titles.
} indent {When series and theme or likewise series and text searches are combined, programmes which match either of both filter types are listed.  This is an exception from the general rule of combining different filters with a logical AND.
} indent {Networks} bold {
} {} {Restrict the listing to programmes of one or more given networks. The filter is disabled when all checkbuttons are deactivated.
} indent {You can also add a network filter listbox to the main window by enabling one of the } indent {Show networks} {underlined indent} { checkbuttons in the } indent {Show/Hide} {underlined indent} { sub-menu of the Configuration menu (see } indent {Configuration: Show/Hide} {href indent} {). Also note that selection, order and names of networks are all configurable, in particular you can permanently suppress uninteresting networks from the list.
} indent {Text search} bold {
} {} {Restrict the listing to programmes who's title or description (or either if both options are enabled) contain one of the given character sequences. If you enable the } indent {match complete text} {underlined indent} { option, an exact match will be required, i.e. a search for "heute" will not match on "heute journal" (intended for title-only searches, as started from the context menu). If you enable option } indent {match case} {underlined indent} {, character case is relevant, i.e. a search for "heute" will not match on "Heute Abend".
} indent {You can search for more than one text at the same time; you'll get all programmes that contain any of the given texts (logical OR).  The listbox above the text entry field lists all currently active texts.  You can double click on the options in the list to toggle them between "yes" and "no" (i.e. option enabled or disabled).  The entries also have small context menus which allow to remove single texts or toggle options.
} indent {Press } indent {Click here to open...} {underlined indent} { to open a small dialog which allows to swiftly add a large list of texts (e.g. a list of your favorite movie titles.)  You can paste text for example from a text editor into the dialog or load them directly from a file.  Each line in the text fields will be added as a separate search when you press OK and all new entries will have the same options.  Blanks at the beginning or end of lines are automatically removed and lines starting with # are skipped when loading from a file.
} indent {A history of the last 50 searches (manually entered ones only) including options, are stored and available in the drop-down menu below the search text entry field (opened with the arrow button at the left or one of the up/down cursor keys) and the last 10 searches are also available in the } indent {Title} {underlined indent} { column header menu in the programme list (the latter in "single list" layout only).
} indent {Note: use of this search filter type is depreciated for permanent series searches saved in shortcuts if your provider supports series identifiers (see above).  In this case should use those instead because the numerical identifiers have a better protection against transmission errors.  A text search can fail due to a single erronous character.
} indent {Features} bold {
} {} {Restrict the listing to programmes that match all given attributes (logical AND), i.e. sound format, picture format, analog/digital, encrypted yes/no, live/new/repeat and subtitles yes/no.
} indent {If you want to allow more than one value of the same attribute (e.g. picture format wide OR Pal+) you have to put them into different feature classes (e.g. first select format wide, then set filter class to 2, then select format PAL+)
} indent {Parental Rating} bold {
} {} {Restrict the listing to programmes that are suitable for children of the given age or elder, e.g. when you select 14, you get all programmes that are rated general or between 4 and 14.
} indent {Editorial Rating} bold {
} {} {Restrict the listing to programmes that are rated (by the content provider) to have at least the given quality. The range of rating values is 1 to 7. Note that some providers do not use all values, e.g. only 1, 3, 5 (thumb down, middle, thumb up)
} indent {Start time} bold {
} {} {Restrict the listing to programmes who's start time lies in the interval specified by start, stop time and relative date.
} indent {Following options are available: If you enable } indent {Start at current time} {underlined indent} { the interval start is fixed to the actual time when the filter is set and the value given as stop time is interpreted as duration, i.e. it's added to the interval start. If you enable } indent {Stop at end of day} {underlined indent} { the interval end is fixed to 23:59 of the same day.
} indent {For the date you can chose between the following modes: } indent {Ignore date} {underlined indent} {: the filter allows programmes that start on any day (in the time window given above). } indent {Relative date} {underlined indent} {: allow only programmes that start N days from today, i.e. for zero: today, for 1: tomorrow etc. } indent {Weekday} {underlined indent} {: allow programmes starting at the given day of the week (the scale runs from Saturday until Friday.) } indent {Day of month} {underlined indent} {: allow only programmes starting the Nth day of any month (the scale runs from 1 to 31.)
} indent {Note that the main intention of this filter is to support time restrictions in the provider's navigation menus (see } indent {Navigate} {href indent} {) or shortcuts. For manual navigation there are more practical alternatives, e.g. the weekday scale and drop-down menus in the main browser window above the time and date columns (not available in grid layout.)
} indent {Program index} bold {
} {} {Restrict the listing to programmes who's index is in the given range. The currently running programme of each network is given index zero, the following programme of each network index one etc. The three most important combinations are available as radio buttons: } indent {now} {underlined indent} { (range 0-0), } indent {next} {underlined indent} { (range 1-1) and } indent {now or next} {underlined indent} { (range 0-1).
} indent {For merged databases only indices 0 and 1 are supported.
} indent {Duration} bold {
} {} {Restrict the listing to programmes whose duration (i.e. difference between start and stop time) lies in the given range.  When the maxium is set to zero, the filter is switched off.
} indent {You can specify the time values either by use of the scales or by entering a value in the format MM:HH into the text fields and pressing the Return key.
} indent {Expired Programmes Display} bold {
} {} {Unlike all other filter options this one is used to } indent {enlarge} {underlined indent} { the set of matching programmes.  It allows to include expired programmes (i.e. those with a stop time in the past) into the list; they will be marked with a yellow background (you can change that color, see } indent {.Xdefaults} {fixed indent} { and } indent {nxtvepg.ad} {fixed indent} { in } indent {Files} {href indent} {.)  With the sliders you can set how many days plus hours to shift the expire time threshold. By default the threshold is zero so that expired programmes immediately disappear from the list.
} indent {Note you cannot add more programmes than are stored in the database; usually programmes are removed after 4 hours.  There's a second tab called } indent {Configure} {underlined indent} { in the dialog which allows to change the delay after which expired programmes are automatically removed.  Press the } indent {Update} {underlined indent} { button to set the new value.  If it's lower than before, programmes will immediately be removed from the database; this operation cannot be undone (unless the progammes are still registered in the provider inventory, which may be the case if you haven't updated the database in a long time.  In this case you may get a confusing warning that programmes are about to be removed although they won't.)
} indent {Sorting Criteria} bold {
} {} {Restrict the listing to programmes that have any of the given sorting criteria attached to them; every programme can have 0..7 sorting criteria attached to it.  They work very much like theme descriptors however their meaning is not predefined by the Nextview standard. The content provider can use arbitrary numbers to represent an attribute. Attributes usually are themes that are not in the predefined catalog, e.g. current events like the Olympic Games, but could also be not content related at all.  The meaning of these numbers is usually defined by the provider's navigation menus (see } indent {Navigate} {href indent} {).
} indent {Equivalently to themes, you can assign sorting criteria in different } indent {classes} {underlined indent} { to implement a logical AND, i.e. only programmes that have at least one of the sorting criteria specified in every used class will match. Example: to get all programmes that have 0x01 attached plus either 0x10 or 0x11, specify sorting criterion 0x01 in class #1 and 0x10 and 0x11 in class #2.  Note that the dialog displays all values in hexadecimal format, i.e. with digits 0-9 followed by a-f.
} indent {The } indent {Load all used} {underlined indent} { button in the sorting criteria filter dialog fills the selection listbox with a list of all codes that are actually used in the current database.  This allows a quick overview which filter criteria will produce any matches.
} indent {VPS/PDC} bold {
} {} {Restrict the listing to programmes that have a valid VPS/PDC start time label attached (VPS/PDC allow to start a video recording at the exact time a programme starts even when delayed; the labels are broadcasted currently in Germany, Austria, Switzerland and England). Additionally you can filter for programmes with a label which differs from the actual start time; these are usually programmes whose start time changed or which were scheduled later (usually the VPS/PDC label then is the actual start time minus one minute)
} indent {Note that the interpretation of two filter types depends on the provider: sorting criterion and series. That's because those are just arbitrary numbers which only have a meaning in the context of the provider's navigation menu.
} {} {Hint:} underlined { the filter menu can also be used to examine the filter options that are invoked by the entries in the Navigate menu.
} {} {Inverting filters} title2 {
} {} {Near the end of the filter menu there's the } {} {Invert} underlined { sub-menu which allows to invert the outcome of filtering.  There are two levels of inversion: global and individual.
} {} {When you select global inversion, you'll get exactly the programmes that otherwise would have been filtered out (except for programmes which are permanently filtered out by your network and air-time selection). In other words, all programmes which match your current filter setting are removed from the list.  Note: due to the way filter shortcuts are merged when more than one is selected at the same time, it's in most cases not recommended to use global invert for filter shortcuts unless you change the combination rule (see } {} {Filter shortcuts: Shortcut combination modes} href {.)
} {} {The invert menu also allows to individually negate certain filter types (there are also invert buttons in some filter sub-menus which have the same function).  The logic of combining flters is the same as without inverting, i.e. there's a logical OR between filters of the same type (e.g. network A OR network B) and a logical AND between different filter types (e.g. network A AND theme category movie).
} {} {Example 1:} bold { If you want all programmes which are neither categorized as sports nor as children's programmes, select theme filters sport and children's and then invert the current theme filter (usually class #1; you can equivalently use the global invert if themes are the only filter).
} {} {For the theme and sorting criterion filters it's possible to invert only parts of the selection, so that you can require that a programme has a certain attribute and at the same time require that it doesn't have another attribute.
} {} {Example 2:} bold { If you want all programmes which are movies but NOT adult movies, select theme category Movie, switch the theme class to 2, select theme adult and then invert theme class 2.
} {} {Note: although the Feature filter offers the use of different classes so support a logical OR, the inversion is not based on classes. This is due to the fact that there's a logical OR between feature classes (in contrast to the logical AND between theme classes).
} {} }
set {helpIndex(Filter shortcuts)} 10
set helpTexts(10) {{Filter shortcuts} title1 {
} {} {There's a number of predefined filter options in the main window below the clock. These shortcuts enable you to invoke filters by a single click of the mouse. You can freely add, change or remove entries in this list.
} {} {When you want to add a shortcut, first set the filters up in the way you want to save them, i.e. either choose existing shortcuts or select an entry from the Navigate menu and/or add filters from the main or context menus.  When you have found an interesting selection, invoke } {} {Add filter shortcut} underlined { from the shortcuts menu.
} {} {This will open the shortcut edit dialog (which will be described in detail below) with your new shortcut at the start of the list at the left. You should change the shortcut label in the field at the top right; by default it's just "new shortcut".  The label will be displayed in the shortcut list in the main window. When you're done press } {} {Save} underlined {, or } {} {Abort} underlined { if you've changed your mind and don't want to add this shortcut after all.  If you want to define multiple shortcuts you can leave the Edit dialog open and save just once when you're done with all changes.
} {} {You can invoke several shortcuts in parallel by moving the mouse with the left button pressed or by pressing the } {} {CTRL} underlined { or } {} {SHIFT} underlined { keys when selecting in the main winddow's shortcut listbox.  See the chapter below for possible side-effects when combining shortcuts.
} {} {The shortcut list has a small context menu which shows when you click with the right mouse button into the  shortcut list.  If offers faster access to the same commands which are available in the main menu plus a } {} {Delete} underlined { command; the shortcut above which you press the mouse button is pre-selected for the chosen operation.
} {} {When you } {} {Update} underlined { a shortcut and your current filter setting contains different filters than the previously stored setting, you'll be asked if the filter mask should be automatically adapted (e.g. if your filter previously searched for theme category 'movie' but your current filter consists of a text search).  See below for more details on filter masks; unless you have manually edited this shortcut's mask before, you can safely press "Yes".
} {} {Editing Filter Shortcuts} title2 {
} {} {To change names and/or organisation of your shortcuts, open the edit dialog (e.g. via the main menu.)  On the left of the dialog window there's a list of all your shortcuts. In the middle there's a row of command buttons which operate on the shortcut selected at the left (explained below).  At the right there's an editable field with shortcut name, a read-only display of the filter settings currently assigned to the shortcut, and popup menus to change the filter's mask and combination rules (also explained in detail below.)
} {} {The buttons with up/down arrows will move the selected shortcut up or down.  The buttons with arrows pointing to the upper left and lower right are used to move a shortcut entry out of or into a sub-folder respectively.
} {} {The } {} {Delete} underlined { button removes the selected shortcut from the list (the deletion won't affect the main window until you press } {} {Save} underlined {, so you can leave the dialog with } {} {Abort} underlined { to undo the operation.)
} {} {The } {} {Invoke} underlined { button will apply the shortcut's filter setting to the main window just as selecting the shortcut in the main window's list. You can then change the filter settings via the filter menus.  Use the } {} {Update} underlined { button to assign the main window's filter settings to the edited shortcut.
} {} {You should be careful with the update button since it's easy to overwrite the wrong shortcut.  If you notice such a mistake, you can undo the change either by leaving the edit dialog with the } {} {Abort} underlined { button or selecting the respecting shortcut in the main window and assigning the original settings via } {} {Update} underlined {.
} {} {Filter Masks} title2 {
} {} {When you deselect a shortcut, either by selecting another shortcut or clicking on it a second time with } {} {CTRL} underlined { held down, all it's filters will automatically be undone. Hence when you have two themes shortcuts, e.g. "Movies" and "Sports", and select first Movies, then Sports, you'll see only sports programmes afterwards.  However if you had selected theme movies manually, e.g. by the context menu explained in the next chapter, the movies filter might remain set, so that you'd get all programmes of theme movies OR sports.  Since that is usually not what one expects, a filter mask has been introduced to the shortcut setting.
} {} {The filter mask is defined in the shortcuts dialog with a checkbutton for each filter category. By default, the mask is enabled for every filter category you've included in the shortcut filter setting.  When you invoke the shortcut from the main window later, all filters of the given categories will be cleared (masked out) before the shortcut filters are added. To return to the above example: if the "Sports" shortcut is defined with a themes mask, the manually set movies filter would be cleared before the theme filter is set to sports.
} {} {The masking can also be enabled when no filter of that category has been chosen. This can be used to define } {} {undo} underlined { shortcuts. E.g. choose the mask 'Themes' if you want a shortcut that allows to clear all theme-related filters at once. Or enabled all masks for a } {} {Reset} underlined { button (the only difference to the pre-defined Reset button would be that the cursor does not jump to the first Now programme.)
} {} {Shortcut combination modes} title2 {
} {} {By default when combining multiple shortcuts, all filters of all selected shortcuts are simply thrown together (i.e. "merged") and then processed as if they belonged all to one shortcut.  The same combination rules apply as described in } {} {Filtering} href {.
} {} {For example, if one shortcut searches for movies, another one subtitles, the combination will search for programmes which are movies } {} {AND} bold { have subtitles.  Also, if you have one shortcut which filters for movies and one that filters for your favorite series, the combination will filter for all programmes which are either movies } {} {OR} bold { among your favorite series.
} {} {For such simple shortcuts which consist of a single filter type this behavior is usually intuitive.  When combining complex filters the result of merging however might not match your expecations.  For example, if you have a shortcut "movies on network A" and one "series on network B" merging would result in "either movies or series on either network A or B", i.e. the list would also include movies on network B.
} {} {Hence the shortcut edit dialog has a } {} {Combination rule} underlined { option where you can change the mode into } {} {OR} underlined { or } {} {AND} underlined {.  If you put a shortcut into this mode, it's filters will be handled separately from all others.
} {} {The only drawback is that the shortcut's filters will not be editable via the filter menus.  If you ever want to change the filter settings without creating them from scratch, use the } {} {Invoke} underlined { and } {} {Update} underlined { buttons in the edit dialog (see } {} {Filter shortcuts: Editing Filter Shortcuts} href {.)
} {} {Shortcut update dialog} title2 {
} {} {When you select the } {} {Shortcut Update} underlined { command in the main menu, there will be a small dialog with a list of all shortcuts.  The filter settings of the shortcut you select in this list will be overwritten with the currently active filter setting once you press the } {} {Update} underlined { button. You can also use the } {} {Update & Edit} underlined { button to jump directly into the filter edit dialog (see further above in this chapter)
} {} {Note that while the shortcut edit dialog window is open, updates (as well as deletions or additions) will only affect the temporary list in the edit dialog window until you press the it's } {} {Save} underlined { button.  Also the list offered for shortcut updates consists of the shortcuts as they are defined in the temporary list.
} {} {Note that a faster way to change a single shortcut is to use the context menu, since it allows to skip this intermediate dialog.
} {} }
set {helpIndex(Composite attributes)} 11
set helpTexts(11) {{Composite attributes} title1 {
} {} {By default the TV schedule contains for each programme "basic" attributes like its date, starting time, title, TV network in a pre-defined textual format. By using composite attributes you can customize the TV schedule according to your personal preferences.  For example you could (1) alter the display format of pre-defined attributes (e.g. use colors for highlighting), (2) add new attributes, for example with images as markers for favorite programmes and/or (3) compact display by combining several attributes into one.
} {} {Composite attributes replace single attributes in the display (e.g. only the theme category column.)  Newly created composite attributes will be appended to the list of pre-defined attributes.  You can then configure your programme list as a mixture of pre-defined and composite attributes (see } {} {Configuration: Select attributes} href {)
} {} {Composite attributes are created and edited via the } {} {Attribute composition} underlined { dialog in the } {} {Configure} underlined { menu (see } {} {Configuration: Attribute composition} href {)
} {} {The "heart" of attribute composition is a list of filter shortcuts and reminder groups, which you build as a subset of your personal filter shortcuts and/or reminder groups (see also } {} {Filter shortcuts} href { and } {} {Reminders} href {.)
} {} {Whenever nxtvepg displays a composite attribute in the browser, it matches the programme's actual attributes (e.g. theme categories or assigned reminders) against the shortcuts and reminder groups associated which the respective composite attribute, in the given order (top to bottom in the dialog's list - so order is important). If a match is found, the text, image or attribute which was assigned to that specific shortcut match is displayed in the column with the format specified for this match.  If none match (and there's no } {} {*no match*} underlined { entry, see below), nothing is displayed in place of the composite attribute.
} {} {Note in this context } {} {matching} underlined { means that a shortcut's filters are tried against the TV programme, i.e. a programme "matches" a filter when it would remain displayed when you enable that filter shortcut in the main window.  A reminder group is considered matching when the respective TV show is programmed as a reminder in that group (or matches a shortcut which is assigned to the given reminder group - but let's ignore that for now to avoid confusion.)
} {} {Example: to create a personalized version of the } {} {Editorial rating} underlined { (ER) column, you could create three shortcuts: one with the ER filter set to ">=6", one with ">=4" and one with ">=2"; then you'd create a new user-defined column and insert the three shortcuts in this order; to the first shortcut match you'd assign the text "great", to the second "ok" and to the third "bad".  As a result you'd have a column where the numerical ratings are replaced with your texts.
} {} {There is also a special entry at the end of the dialog's shortcut list called } {} {*no match*} underlined {. It acts as a catch-all (i.e. wildcard) if none of the shortcuts in the column matches the current programme entry.  In the above example this would be all programmes with an ER below 2 or without a rating.
} {} {The catch-all is particularily useful to overlay standard columns with alternate  texts for selected programmes. To stay with the ER example, you could define a column with two shortcut entries: ">=6" and "*no-match*".  To the ">=6" shortcut match you could assign an image marker; to all other the "ER" attribute.  Hence programmes with an ER >=6 (i.e. all "great" programmes) would have an image displayed and hence clearly stand out from all other programmes, which get the regular content of the ER column (i.e. the numerical rating or an empty column for unrated programmes).
} {} {You can also use this machanism to combine several columns into one, to keep the listing compact.  For example you can combine the ER column with the theme column, so that for movies with ER >= 6 the text "great movie" is displayed, for all others the regular theme description.
} {} }
set {helpIndex(Reminders)} 12
set helpTexts(12) {{Reminders} title1 {
} {} {Reminders allow to mark TV shows which interest you and have nxtvepg mark them in the programme list and display a message or execute an external command when they start.  You can select either individual programmes in the programme list or complete filter shortcuts, e.g. for TV series.
} {} {To set a new reminder simply select it with the cursor in the programme list and choose } {} {Add reminder for selected title} underlined { from the } {} {Reminder} underlined { menu.  The same command is also available in the context menu, i.e. by clicking on the selected title with the right mouse button.  To remove the reminder, simply select the title again and choose } {} {Remove reminder for selected title} underlined {.
} {} {By default nxtvepg will display a message popup for every reminded programmme 5 minutes before and directly at the start time.  You can change this in the } {} {Configure reminder groups...} underlined { dialog described in a separate chapter below.
} {} {If you want to set a reminder for an entire series, you need to create a filter shortcut first which matches the series (either by searching by series ID or by title).  To reduce the overhead you can create a shortcut which matches all your favorite series and set a reminder for this collection.  To assign a reminder to the shortcut use the } {} {Edit reminder list} underlined { described in the next chapter.
} {} {Note you can add a single reminder for entries which already match a shortcut reminders.  This allows to assign an additional, specific action for that TV show (if you use different groups.)  Additionally you can suppress handling of reminders for individual shows; this option if offered in the Reminder and context menus when applicable. This option may help to get around excessively complex or restrictive shortcut filters.
} {} {By default nxtvepg has (in the single list layout) a column titled } {} {Mark} underlined { which contains a red dot for all programmes which have a reminder registered, i.e. both single programmes and those which match shortcuts with associated reminders.  You can also set a filter which will display only programmes with reminders in the proramme list by selecting } {} {Show reminder matches} underlined { from the Reminder menu.
} {} {Edit reminder list} title2 {
} {} {Opens a list of all reminders.  Single programmes and shortcuts are listed in separate "tabs"; switch between them by clicking on the buttons at the top.
} {} {The } {} {single programmes} bold { list is sorted by start time and network.  When you double-click on a reminder, the respective network will be filtered for in the programme list and the cursor jumps onto the programme (if it's present in the current database.)  To delete a reminder click on the } {} {Delete} underlined { button or press the delete key on your keyboard. You can also select the reminder's "group" (see below) either by selecting a group in the popup menu from the } {} {Set group} underlined { menubutton or by clicking with the right mousebutton into the group column.
} {} {The list will normally not contain reminders for programmes which are already expired.  You can use the } {} {Display} underlined { popup menu at the right to change that.  You can also include "suppressed" reminders, i.e. entries which where created via the respective entry in the main menu to supress shortcut matches; those will appear with the virtual } {} {suppress} underlined { group in the list.
} {} {When you switch to the } {} {Shortcuts} bold { tab, you'll see a list of all shortcuts for which you have added reminders. The first time you open the dialog it will be empty.  You can add shortcuts by selecting them from the popup menu at the right.  Equivalently to single programmes you can change the group or delete the reminders again.  All changes to the lists are immediately saved and the markers in the programme list updated.
} {} {All changes you make in this dialog take effect immediately.
} {} {Reminder group configuration} title2 {
} {} {Opens a configuration dialog for reminder groups.  Every reminder is assigned to exactly one group which determines which actions are executed at the programmes' start time.  Having groups allows to change actions (and especially: disable them if you're not in the mood to watch TV) easily without having to edit every single reminder.  When you create a new reminder with the simple "add reminder" menu command it will be assigned to group zero.
} {} {By default nxtvepg has only one group which pops up a message 5 minutes before and directly at the start time.  You can change this by selecting the group in the list at the left and then modifying the parameters at the right.  Or create a new reminder by clicking } {} {New} underlined {.  You can also change ordering of groups (only available for your convenience; except for group zero ordering is not relevant.)  The } {} {Show} underlined { buttons sets a filter for the programme list so that only programmes matching reminders in the same group as the currently selected shortcut are displayed.
} {} {At the top of the parameter input section is the } {} {Label} underlined { entry field. It allows to give the group a name, which is then used in the reminder lists and in reminder confirmation messages.  Below is a checkbutton called } {} {Disable all group events} underlined {.  When enabled all actions for that group are suppressed, i.e. you'll get no popup messages and scripts are not executed.  The programmes are still marked in the listbox though.
} {} {Further below is an entry field where you can give a list of comma separated values which define at which offsets reminder messages are displayed; offsets are substracted from the start time, i.e. when you enter "5" a message will appear 5 minutes before the programme's nominal start time. You can use negative values (e.g. "-5") if you want reminders to appear later than the start time.  In addition you can set start times for commands.  Commands are silently executed in the background, unless you enable } {} {Ask before executing script} underlined {.
} {} {Note configuration changes (including group additions or deletions) are not applied before you leave the dialog with OK.
} {} {Reminder Messages} title2 {
} {} {Once the nominal start time of a "reminded" programme (minus the configured time offset) is reached, a message window will appear.  If there's more than one message triggered at the same time, or if you leave the window open and reminders for additional programmes are triggered, they will all be collected in this window; in this case there's a cursor which determines to which reminders the controls explained below apply. When you press } {} {Ok} underlined { all messages are marked as "done" and will not appear again.  With a double-click or the } {} {Tune-TV} underlined { button you can switch the channel of a connected TV application to the selected programme, just as in the main programme list.
} {} {For message windows there's several buttons which allow to control further reminder processing.  } {} {Suppress} underlined { will prevent any subsequent messages for the programme.  (Note that this is not the same as suppressing reminders in the main menu, since here you supress only messages but the programme remains marked as reminder).  } {} {Repeat} underlined { allows to schedule additional reminder messages at arbitrary time offsets.  Note that messages configured for the group are suppressed until the manual repetition but will re-appear afterwards.
} {} }
set {helpIndex(Context menu)} 13
set helpTexts(13) {{Context menu} title1 {
} {} {Another quick way to select and deselect filters is by using the context menu, which is opened by clicking with the right mouse button onto a programme entry in the main browser window.
} {} {This menu consists of several parts, separated by horizontal lines, which depend on the currently selected programme and hence are not always present.
} {} {Undo currently selected filters} bold {
} {} {The first section holds entries which allow disable currently selected filters either one by one or globally (reset). See also } indent {Filtering: Filter Types} {href indent} {
} indent {Add new filters} bold {
} {} {The second section offers a number of possible new filter options, which depend on the currently selected title and the already selected filters. The offered filter types include: themes and network of the selected programme title, it's series code, repeat or original transmission suppression (only in cunjunction with series or title text filters) and last but not least the title text.
} indent {The title text and series filters allow to check very quickly for repeats of a programme. These filter options are included only if there is a match, i.e. if there's another programme with the same title or series code respectively.
} indent {Add reminder} bold {
} {} {This menu entry will add a reminder for the currently selected programme.  The reminder will have the default reminder group. To create reminders in different groups use } indent {Add reminder into group} {underlined indent} { in the reminder main menu (see also } indent {Reminders} {href indent} {)
} indent {User-defined entries} bold {
} {} {The optional fourth section is empty by default, but can be used to invoke user-defined external commands on the selected programme. More precisely, you can execute any command with properties of the selected programme (like title or start time) on its command line. The user commands can be added via the Configure menu (see } indent {Configuration: Context menu configuration} {href indent} {).
} indent }
set {helpIndex(Control)} 14
set helpTexts(14) {{Control} title1 {
} {} {Summary of commands available from the Control menu:
} {} {Enable acquisition} title2 {
} {} {Toggles acquisition on or off.  When you start the browser, acquisition is automatically enabled (although failure to do so is silently ignored). You can suppress automatic start with the } {} {-noacq} bold { command line switch. Switching off acquisition allows other applications (e.g. a teletext decoder) to use the TV card while you browse the database, if you have only one TV card.
} {} {You will get an error message if the device is already busy by a different application (there are some applications which cooperate well with nxtvepg, but if in doubt you should quit all other video related applications before starting acquisition) or if you don't have permission to access the device (UNIX, see also } {} {Files} href {) or to start the driver (Windows).  If you're experiencing problems that might be hardware or Operating System related, test with a TV application or teletext decoder first, because these usually allow for easier debugging (e.g. due to the visible TV image). See also } {} {Getting started} href {.
} {} {UNIX: When acquisition is switched off, the } {} {/dev/vbi} underlined { device is freed. Acquisition can also been switched on and off automatically (i.e. from a shell script) by sending signal HUP (e.g. with the kill(1) command) to any of the nxtvepg processes or threads.  If you're using a daemon for acquisition (see the next command) you have to send the signal to one of the daemon processes/threads.  To simplify this, the pid of the process which needs to be signalled is stored in } {} {/tmp/.vbi.pid} underlined { while the device is in use.
} {} {Connect to acq. daemon} title2 {
} {} {Connect to or disconnect from an acquisition daemon, running in the background on the same host, or somewhere else in the network.  The address of the daemon and other parameters are configured in the } {} {Client/Server} underlined { menu (see } {} {Configuration: Client/Server} href {). By default the daemon is started on the local host.  The main advantage of using the daemon is that you can keep running acquisition permanently in the background, even if you terminate the browser, or on UNIX even the X11 server (i.e. the windowing system). On M$ Windows the daemon is terminated when you log off.
} {} {If you attempt to connect, but no daemon is running, you'll be offered the option to automatically start the daemon and retry the connect, provided you have configured server hostname } {} {localhost} underlined {. The daemon will be started with the same database directory and rcfile as the browser.
} {} {Note that disconnecting from the daemon or terminating the browser does not stop the acquisition and hence does not free the device.  If that's what you want, choose the } {} {Enable acquisition} underlined { command instead, which terminates the daemon.  Of course this option only is available if your daemon is running on the same host and with the same user id as the browser process.
} {} {Dump stream} title2 {
} {} {UNIX only: All incoming Nextview blocks are dumped to } {} {stdout} underlined { in an ASCII format. This is mainly intended for developers, but it may also help to debug reception problems, because in the dump you'll find any block that could be decoded without hamming errors, even before an inventory block (AI) has been received. This may help if you have very bad reception, because it may take a long time until a error-free copy of the usually large AI block is received.
} {} {When connected to a acquisition daemon, blocks are only dumped if they are new to the database or their content changed (because only those are forwarded by the daemon to the client.)
} {} {Dump raw database} title2 {
} {} {Open a dialog that allows to dump all blocks in the database to } {} {stdout} underlined { (UNIX only) or into the named file in a raw text format, which is actually the same as with the } {} {Dump stream} underlined { command. This feature is mainly intended for developers. To understand all the infos in the text dump, you'll have to look at the source in } {} {epgui/epgtxtdump.c} underlined { in the nxtvepg source package.
} {} {The array of checkbuttons allows to control which kind of blocks will be written. The programme information blocks (PI) do contain the actual programme descriptions; } {} {Defective PI} underlined { contains those PI which were not accepted into the database because of inconsistencies like a zero or overlapping running time. For an explanation of the other block types please see the ETSI specification 707.
} {} {Export as text} title2 {
} {} {Open a dialog that allows to export the complete database into a text file.  Each line in the file will represent one item in the database. The item's different fields are separated by TAB characters; the line is terminated by a single new-line character (no line feed character, even on Windows).  In some cases missing values are represented by } {} {\N} fixed { which is the MySQL } {} {NULL} underlined { identifier (currently only used for the VPS/PDC field).
} {} {The generated text file can be loaded directly into a relational database.  It's not formatted for viewing in a regular text editor. Networks and themes are represented as numerical indices into the network and themes table respectively.  Hence these tables are required in addition to the programme table.  To load them into a database, you need to export them into different files.
} {} {For } {} {MySQL} underlined { you could create the following tables:
} {} {   CREATE TABLE PI (
      netwop smallint(2) unsigned NOT NULL,
      Dstart date NOT NULL,
      Hstart time NOT NULL,
      Hstop time NOT NULL,
      vpspdc_pil datetime,
      prat tinyint(2) unsigned,
      erat tinyint(2) unsigned,
      sound enum("mono","2-chan","stereo","surround"),
      is_wide BOOL,
      is_palplus BOOL,
      is_digital BOOL,
      is_encrypted BOOL,
      is_live BOOL,
      is_repeat BOOL,
      is_subtitled BOOL,
      theme_0 tinyint(3) unsigned,
      theme_1 tinyint(3) unsigned,
      theme_2 tinyint(3) unsigned,
      theme_3 tinyint(3) unsigned,
      theme_4 tinyint(3) unsigned,
      theme_5 tinyint(3) unsigned,
      theme_6 tinyint(3) unsigned,
      title varchar(40) NOT NULL,
      descr text,
      PRIMARY KEY (netwop, Dstart, Hstart)
   );

} pfixed {   CREATE TABLE AI (
      netwop_idx smallint(2) unsigned NOT NULL,
      cni smallint(5) unsigned,
      lto_mins smallint(5),
      daycount smallint(5) unsigned,
      alphabet smallint(5) unsigned,
      addinfo smallint(5) unsigned,
      name text,
      UNIQUE netwop_idx (netwop_idx)
   );

} pfixed {   CREATE TABLE pdc_themes (
      theme_idx smallint(3) unsigned NOT NULL,
      cat_idx smallint(3) unsigned,
      name_eng text,
      name_ger text,
      name_fra text,
      UNIQUE theme_idx (theme_idx)
   );

} pfixed {Export as XMLTV} title2 {
} {} {Open a dialog that allows to export the complete database in XML format, as defined by the } {} {xmltv.dtd} bold { version 0.5 (see } {} {xmltv} underlined { project on http://sourceforge.net/) The generated file contains both the channel table and the complete TV schedule, including any networks you might have suppressed from the listing inside nxtvepg.
} {} {Hint:} bold { If you want to restrict the amount of exported data, configure a merged database.  This is possible even for a single provider. This way you can exclude certain networks or attributes, e.g. to omit theme categories from the output (see the "Configure" sub-menu in the merge configuration dialog.)
} {} {Some TV applcations are known to not parse XMLTV timestamps correctly. As a work-around for such buggy applications, there's an option which allows to export dates and times in local time instead of UTC (also known as } {} {Greenwhich Mean Time} underlined { or GMT.)  If all programme data appears shifted by one or two hours in your TV app's schedule, try this option.
} {} {Note that the database can also be exported directly from the command line by using the } {} {-dump xml} bold { switch (see } {} {Options} href {).
} {} {Export as HTML} title2 {
} {} {Opens a dialog that allows to export the complete database or selected programmes into a file in HTML format (Hypertext Markup Language) which can then be loaded into a WWW browser, e.g. } {} {Netscape} underlined { or } {} {Opera} underlined {. This is particularily useful if you want to print out TV descriptions.
} {} {At the top of the dialog window you have to enter the output file name; if you don't include an extension, } {} {.html} underlined { is automatically appended. Click on the little folder button to the right for a file selection dialog. Press the } {} {Export} underlined { button to create the HTML document and } {} {Dismiss} underlined { to close the dialog window.
} {} {By default the checkbutton } {} {All matching programmes, but max ...} underlined { is enabled.  In this mode all programmes that match current filter setting will be exported, but only up the given number of programmes. It's recommended to limit the number of programmes because else very large HTML documents are created which may take a long time to load into your Web browser.
} {} {Use mode } {} {Selected programme only} underlined { to export only the programme which is currently selected in the main window. In combination with the } {} {Append to file} underlined { mode this allows to incrementally build a document with exactly your programmes of interest.
} {} {In the box below there are three radio buttons with which you can select the output format. If you choose } {} {Write titles} underlined { you'll get a table in the same configuration as in the programme title list in the main window. If you want to have different column types, you can build a separate column configuration by selection } {} {Different columns than main window} underlined { and then pressing the } {} {Configure} underlined { button to select which column types to display.
} {} {If you select } {} {Write descriptions} underlined { you'll get for each exported programme a feature summary and description, similiar to the info in the lower part of the main window.
} {} {If you select } {} {Write titles and descriptions} underlined { you'll get the title table on top and all descriptions separately below.  In this mode you can select } {} {Add hyperlinks to titles} underlined { to add hyperlinks from titles in the table to the descriptions.
} {} {The look of the generated document is almost entirely determined by use of an internal CSS stylesheet. If you don't like the look you can override it with your own stylesheet. Save it to a file named } {} {nxtvhtml.css} underlined { and put it in the same directory as the generated HTML file. For more information on HTML and style sheets see } {} {http://www.w3.org/} underlined {.  If your column configuration contains images (see } {} {Composite attributes} href {), you have to put them into a subdirectory called } {} {images} underlined {; also your browser has to support the } {} {PNG} bold { image format.
} {} {View statistics/timescales} title2 {
} {} {The following four commands are used to open windows with statistics about the databases and acquisition progress. See } {} {Statistics} href { for details.
} {} {View timescales} bold {
} {} {Toggles the timescale window for the browser database. The window reflects for each network included in the selected database, which time ranges are covered by programme information. If acquisition is working on the database, you can watch how more and more of the scales get covered. See also } indent {Statistics: Status line} {href indent} {
} indent {View statistics} bold {
} {} {Toggles the browser database statistics window, which informs you about number of program entries in the database, fill percentage, expiration percentage, date of last update etc.  If the acquisition is working on the same database, it also contains information about state and progress of acquisition. See also } indent {Statistics: Timescale popup windows} {href indent} {.
} indent {View acq timescales} bold {
} {} {Toggles the timescale window for the acquisition database. This entry is only available if the acquisition uses a different database than the browser (e.g. when using a manual or cyclic acquisition mode, see } indent {Data acquisition} {href indent} {)
} indent {View acq statistics} bold {
} {} {Toggles the acquisition statistics window, which informs you about state and progress of acquisition. If the acquisition control mechanism switches to a different database, the acq statistics window will automatically follow.
} indent {Quit} title2 {
} {} {Close all windows and terminate the application. If you have started acquisition as a daemon, it will not be terminated (see } {} {Control: Connect to acq. daemon} href {).
} {} }
set {helpIndex(Configuration)} 15
set helpTexts(15) {{Configuration} title1 {
} {} {Summary of commands available from the Configure menu:
} {} {Select provider} title2 {
} {} {Open the provider selection dialog.  This dialog lists all TV channels from which Nextview data can be received.  When you select a channel name on the list, you'll see the name of the Nextview service that's transmitted there and a list of all networks covered by it on the right.
} {} {If you leave the dialog with Ok, the selected provider's database will be loaded into the browser.  If the database hasn't been updated for a long time, the programme list might initially be empty, but if you have selected "Follow-UI" acquisition mode, the provider's TV channel will be tuned to update the database content (see } {} {Acquisition modes} href { for more details.)
} {} {To remove obsolete providers (i.e. such which have ceased to provide Nextview service or which you can no longer receive), you should start a provider scan in } {} {refresh} underlined { mode (see } {} {Configuration: Provider scan} href {) You cannot remove active providers even if you're not interested in their EPG information, because nxtvepg would add them back automatically in the next scan or when their TV channel is tuned externally.
} {} {Merge providers} title2 {
} {} {Open a dialog that allows to merge several databases into one. See } {} {Merged databases} href { for details.
} {} {Acquisition mode} title2 {
} {} {Open a dialog that allows to control the background acquisition process. See } {} {Acquisition modes} href { for more details.
} {} {Provider scan} title2 {
} {} {Open a dialog that allows to start a scan across all TV channels for Nextview transmissions.  You should perform this search at least once, firstly to find out which providers are available in your area, and secondly to determine the frequencies of all provider's TV channels. Those are required for most acquisition modes, and due to driver limitations often not available without a scan (e.g. on Windows or Linux with bttv driver <= 0.7.50). See also } {} {Getting started} href { and the subsequent chapter on TV card configuration.
} {} {If you live in France or Belgium, select the French frequency table (which implies the } {} {Secam L} underlined { TV norm) to be used for the EPG scan; else use the default frequency table which covers common cable network frequencies in Western Europe with the PAL TV norm. Other countries are not supported, since there currently are no Nextview providers.  If you live in an area where you receive both PAL and SECAM stations, you should perform the EPG scan twice with different channel tables.
} {} {The } {} {Use TV app.} underlined { button is automatically checked if an } {} {xawtv} underlined { configuration file is found in your home directory (on UNIX) or a TV application was set up in the } {} {TV app. interaction} underlined { dialog (or initially in the } {} {TV card input} underlined { dialog).  Instead of searching all possible TV channels or frequencies in all bands, nxtvepg then just checks the TV channels defined there, which usually saves a lot of time.
} {} {Check the } {} {Slow} underlined { button if you have bad reception on some channels. In slow mode the scanner will not skip channels with "unstable" video signal (i.e. no PLL H-lock within 0.150 seconds) and wait twice as long as normal for everything, i.e. up to 4 seconds for a VPS/PDC channel identification and up to 90 seconds for EPG for known providers or if potential EPG data packets were found.  Note that you can change this setting while the scan is running.
} {} {Use the } {} {Refresh only} underlined { mode if you deleted your database files (or if you upgrade from an incompatible software version) or if you want to identify or remove obsolete providers. In this mode only the channels on which Nextview data was received before are checked (the frequencies are kept both in the databases and your rc/ini file). This allows to regain your complete provider selection very quickly. If no data transmission is found on a provider's channel, a } {} {Remove this provider} underlined { button will be added to the output window, which you can use after the scan has finished to remove the database and any information recorded about the provider.  Note that removal will fail if the database is currently in use, so you may have to stop acquisition and select a different provider.
} {} {Technical background information on how the EPG scan works: The scan will visit every physical TV frequency (or subsets thereof if you use one of the options described above) and check for a TV signal. If one is detected within 150 ms or if at least one teletext packet was received, the scan waits up to two seconds for a valid VPS/PDC channel identification.  At the same time it receives packets from all potential EPG teletext page addresses.  If a VPS/PDC code is read that belongs to one of the known EPG providers or valid data packets have been received (which does not necessarily mean it's EPG, because other services could use the same encoding) the scan waits up to 45 seconds for EPG inventory messages (BI and AI blocks). You can watch these proceedings in the message output window.
} {} {Even though the scan tries very hard, it can not warrent that every EPG provider is found every time. For example some providers do have pauses of more than 45 seconds in their EPG transmission; or they might have technical problems.  So the safest way is to check the nxtvepg web site (see } {} {About} underlined { in the Help menu) for a list of known Nextview EPG providers. If you receive TV channels for which a provider is listed, repeat the scan until they are found, e.g. at different times of the day.  If you find new providers not listed on the web site, please let me know.
} {} {TV card input} title2 {
} {} {Open a dialog where the TV card hardware parameters can be configured.
} {} {This dialog contains more options on Windows than on UNIX platforms because on UNIX the driver is part of the operating system, whereas on Windows it's part of the application and has to be configured separately for every application.  Hence, before you can use nxtvepg you must configure your card in the } {} {Configure card} underlined { sub-dialog. Please refer to } {} {Getting started} href { for a description of this dialog.
} {} {Video source} underlined { allows to choose which video input source to use, i.e. where you have connected an video input cable to the TV card: } {} {Tuner} underlined { or } {} {Television} underlined { refer to input via antenna cable (also known as RF cable, i.e. terrestrial reception or cable TV); } {} {Composite} underlined { refers to a cinch video cable as used by satellite receivers or cheap video records; } {} {S-Video} underlined { is an variant of Composite with improved image quality (often wrongly called S-VHS cable since it's mostly used by S-VHS video recorders) and easily recognized by the Sub-D connectors (called "Hosidenstecker" in German). Depending o your hardware you may only see a sub-set of these input types, or additional ones (e.g. } {} {Radio} underlined {, which will obviously not work as input for nxtvepg.)
} {} {Note if you don't choose a TV tuner as input nxtvepg will not be able to automatically switch to your EPG provider's channel. See also } {} {Data acquisition} href {.
} {} {If you have more than one TV tuner card, you can also choose which one to use, just like with the } {} {-card} bold { command line option (see } {} {Options} href {) The popup menu will list all card types as configured in the driver. Note that changing the card may also affect the input selection, in particular if the cards use a different ordering for input types.
} {} {The slicer quality option selects between different algorithms by which teletext is extracted from the analog video signal.  The } {} {simple} underlined { algorithm works only for excellent TV reception, but has the advantage of using very little CPU resources.  The } {} {elaborate} underlined { algorithm (copied from zapping's libzvbi and originally developed for the Linux teletext viewer } {} {alevt} underlined {) is much more error tolerant.  When you select } {} {automatic} underlined { acquisition will always start with the simple algorithmm but switch to the elaborate one when the transmission error rate is above recommended limits (see also } {} {Statistics: Acquisition statistics} href {).
} {} {Windows only:} bold { at the bottom of the dialog window there are additional options, which you only need to try if acquisition does not work correctly.
} {} {If you experience data loss due to heavy system load, you can raise the acquisition thread priority (may require special privileges on certain Windows versions.)  Default is } {} {normal} underlined {, i.e. the same as for all user applications.
} {} {The second checkbutton allows to enable logging during driver startup and shutdown. The output is appended to a file named } {} {dsdrv.log} underlined { in the nxtvepg working directory.  Enable this option if you're not able to start the driver and cannot find out why.  But first see the explanation of driver error messages in the README file.  Note that the logging option is not remembered across program starts, i.e. to make use of it you have to enable the acquisition via the Control menu and not by restarting nxtvepg.
} {} {The third option currently only applies to CX23881 based cards: it allows to disable a vendor's WDM driver for the same card.  This is a work-around for the fact that CX23881 WDM drivers are known to access the TV card even while no application is using them.  You should only use it as a last resort, i.e. when you can't get the card to work at all.  It's still an experimental feature, some users have reported that their card configuration was lost or WDM drivers remained disabled even after nxtvepg was stopped (in both cases other applications will probably not work properly anymore.) You can verify if the WDM drivers are cause of acquisition problems by de-installing them, rebooting and then trying nxtvepg again (note nxtvepg doesn't require any vendor supplied drivers.)
} {} {Client/Server} title2 {
} {} {Opens a dialog that allows to configure the connection between browser and an acquisition daemon (i.e. a separate instance of nxtvepg which is running in server mode, see } {} {-daemon} underlined { command line switch in } {} {Options} href {) The daemon allows to forward all newly acquired EPG data to one or more connected browsers and to monitor the it's acquisition progress.
} {} {The dialog contains settings of which some refer to the server-side only, some to the client-side only and some to both server and client.  To avoid confusion, there are three radio buttons at the top of the dialog which allow to grey out items that do not refer to the client or server respectively.  Note: for server configuration changes to take effect, the daemon must be restarted.  If it's running locally, you can do this via the Control menu (see } {} {Control: Connect to acq. daemon} href {)
} {} {Enable remote control} underlined {
} {} {Note: this feature is not yet implemented. By enabling remote-control you can stop acquisition, change acquisition mode, TV card parameters or any parameters configured by this dialog in a running daemon via the network connection.
} indent {Enable TCP/IP} underlined {
} {} {By enabling connections via the TCP/IP network protocol, you allow connections from remote hosts.  Since there's currently no access control in nxtvepg, these hosts can be anywhere in your network, or anywhere in the world if you're connected to the Internet. If you don't have a firewall which prevents incoming connections of untrusted hosts, this mode is highly depreciated, because nxtvepg is not in any way secured against malicious client connections.
} indent {Note: on Windows currently only TCP/IP is supported, i.e. you have to enable this option if you want to start the daemon.
} indent {Server hostname} underlined {
} {} {Client-side only: this setting identifies the host on which the daemon is running. You can enter either a hostname in "dot.com" format or an IP address in "127.0.0.1" format.  If you set it to } indent {localhost} {underlined indent} { the connection is automatically established via UNIX domain sockets (i.e. pipes), which is more efficient than TCP/IP.  You can still use TCP/IP locally if you set it to the name of your local host, as returned by hostname(1).
} indent {Server TCP port} underlined {
} {} {If TCP/IP is enabled, this setting tells server and client which port to use. You can enter an arbitrary number between 1024 and 65535 here, but you have to make sure no other server is using the same port. Make sure you configure the same port number for client and server. The default is 7658.
} indent {Bind IP address} underlined {
} {} {If TCP/IP is enabled and your server host has more than one IP address, you can select here on which one to listen for incoming connections. Make sure you use the same IP address as server hostname on client-side, or a hostname that resolves to that IP address.  This setting is optional; if you leave the field blank (default) the server will bind to all IP addresses.
} indent {Note: on systems that support it, TCP/IP sockets are created in the IPv6 domain (} indent {PF_INET6} {underlined indent} {) by default.  On some systems (e.g. NetBSD) you cannot connect via IPv4 to an IPv6 server and vice versa, i.e. you need to use the same domain on both ends.  If your client only supports IPv4, you can force your server to create an IPv4 socket by binding to an IPv4 address.  If you fail to connect to a local IPv6 server via the IPv4 loopback address 127.0.0.1, use the IPv6 equivalent "::1".
} indent {Max. connections} underlined {
} {} {This setting limits the number of client connections the server will allow.  Once the limit is reached the server will stop listening for new connections.
} indent {Log filename} underlined {
} {} {If you enable log generation by the following option, you can choose here where the log will go. Make sure the file is writable to the uid under which the daemon process is running.  The file opened and closed for each appended log line (usually there's very low traffic into that file) so you can operate on it (e.g. truncate it) without restarting the daemon.
} indent {File min. log level} underlined {
} {} {Here you can choose if log information should be written to a file. If you run nxtvepg with TCP/IP disabled, you don't need to use logging; but if you allow remote connections you should keep log files at "info" level to be able to check which hosts connect to your server.
} indent {The following settings are available: "no logging" disables logging; "error" enables logging of internal errors that lead to an immediate exit of the daemon; "warning" additionally enables logging of unexpected events, i.e. internal errors which do not lead to exit; "notice" additionally enables logging of server status changes, i.e. startup and shutdown; "info" additionally enables logging of connection establishment or shutdown.
} indent {Syslog min. level} underlined {
} {} {Here you can enable or disable logging to UNIX syslog and Windows application event logging (application name is } indent {nxtvepg daemon} {underlined indent} {; this feature is not supported by Windows 95). See UNIX man pages } indent {syslogd(8)} {underlined indent} { and } indent {syslog.conf(5)} {underlined indent} { or the Windows event log help for details about the syslog facility. The log levels you can choose here are the same as described in the previous paragraph for logging to files.
} indent {Note that while network mode is enabled configuration of acquisition mode and TV card input has no effect and no EPG scan is possible. If you use the same rc/ini file for daemon and GUI the changed settings will however be used by the daemon upon the next start.
} {} {TV application interaction} title2 {
} {} {Opens a dialog that allows to configure the interaction between a TV application and nxtvepg.  On UNIX this menu entry is available only when a } {} {.xawtv} underlined { configuration file is found in your home. On Windows you should at least configure your TV application type and path here if you're using one of the supported applications; this is a recommended step during the initial installation to speed up the EPG provider search, as described in } {} {Getting started} href {.
} {} {The first four (only three on UNIX) options allow to  switch interaction features on or off. If you want to improve startup time on UNIX, turn them all off; in this case nxtvepg does not need to search for the } {} {xawtv} underlined { toplevel window (which can take up to several seconds if you have many applications running or a slow connection to your X server.) By default all interaction features are enabled.
} {} {General enable} underlined {
} {} {Windows only: the option allows to disable or re-enable the allocation of communication resources, and implicitly to switch off or on all interaction features. While disabled, nxtvepg will be invisible for the TV application.  The use of this option is depreciated, as nxtvepg won't automatically free the driver when the TV application is started, and nxtvepg will fail to start acquisition when a TV appliaction is running.  Use this option only if you suspect compatibility problems between the TV app and nxtvepg, e.g.  if one application hangs or crashes during startup if the other is already running. (Not that such behavior is to be expected, but it's better to be prepared for anything.)
} indent {Tune TV button} underlined {
} {} {This option allos to hide or show the equally named button and it's little popup menu (accessed with right mouse button) below the clock in the nxtvepg main window.  If you're not interested in remote-controlling the TV application, switch it off.
} indent {Cursor follows channel changes} underlined {
} {} {While this option is enabled, nxtvepg will monitor TV channel changes. Whenever such a change is detected, the cursor in the programme listbox will be set onto the title currently running on that network. During EPG acquisition VPS/PDC is used to exactly determine the current programme (only on networks which support VPS/PDC); however if the nominal running time is in the past it's currently not possible to display the programme in the listbox. This info may however be sent to the TV app (see next option). If you have just a network filter enabled, it will be switched to the new network so that you'll get a complete listing of that network's programmes, starting with the currently running one. This works even when you have excluded this network in the network selection configuration. If there are more or other filters than network enabled, then they will remain unchanged. If the current programme on the new network does not match this filter setting, then neither cursor nor listbox content will be changed.
} indent {Display EPG info in TV app} underlined {
} {} {While this option is enabled, nxtvepg will monitor TV channel changes. During EPG acquisition VPS/PDC are also monitored to determine newly starting programmes. VPS/PDC also allows to detect channel changes on an external input source, e.g. a satellite receiver connected via the Composite socket. After a change of channel or current programme title, the info about the currently running title will be displayed in the TV application. On Windows it's entirely up to the TV application how this information is displayed.
} indent {On UNIX the display format can be selected by the following radio buttons:
} indent {With } indent {Separate popup} {underlined indent} { nxtvepg will generate a small popup window and put it right beneath the xawtv window. The blue area in the small bar on top represents how much of the (nominal) running time lies in the past. With } indent {Video overlay} {underlined indent} { nxtvepg will generate a similar popup, however it's placed on top of the video image (please note that this option only works properly with XFree86 version 4 and the XVideo extension; use the } indent {xvinfo} {bold indent} { command to check if your server supports this feature).  You can change fonts and colors in this popup via X resources (see } indent {Files} {href indent} { for details.) } indent {Video overlay, 2 lines} {underlined indent} { is the same except that it writes running time and title in separate lines and additionally contains the percentage of expired running time. With } indent {Xawtv window title} {underlined indent} { the info will be sent to xawtv and displayed in the window title. Except for this last option, you can configure the desired display duration with the slider at the bottom of the dialog. A duration of zero means the display will never be removed.
} indent {Windows only: in the middle of the dialog there's one line that indicates the current TV application connection status.  It contains the name of the connected application, or } {} {not connected} underlined { wither if no TV application is running or if it doesn't support interaction with nxtvepg (see also } {} {Getting started: Configuring a TV application} href {.) You can connect to different applications than configured below, but if the network names are not synchronized with nxtvepg, the interaction will not work optimally (i.e. nxtvepg might not be able to identify all networks, and hence not be able to provide programme titles).
} {} {In the lower part of the dialog window you can configure type and path of your preferred TV application.  This information is used to access the TV app's channel table (i.e. TV tuner frequencies and station names) during an EPG provider scan (see } {} {Configuration: Provider scan} href {) and in the network name configuration dialog (see } {} {Configuration: Network names} href {). After you've changed the setting, you can press the } {} {Test} underlined { button to check if nxtvepg can parse the channel table correctly. It will complain if it fails to open the file or registry key and if no channels are found. After the test was successful, you shoud open the network names configuration dialog and synchronize network names with nxtvepg.
} {} {If your TV application is not supported, choose } {} {none} underlined {.  (If it's a freeware application feel free to mail me a download URL and I will consider supporting it.  However I will not support proprietary closed-source software, unless on request by the author.)
} {} {Note that not all of the TV applications listed in the popup menu can currently interact with nxtvepg.  The interaction requires modifications in the TV applications; it's up to the respective authors if they want to implement these. (If you are an author of a TV app, feel free to mail me if you want to add EPG support to your application; a demo application and reference implementation source code are available on the nxtvepg home page.)
} {} {Select attributes} title2 {
} {} {Open the programme attribute display configuration dialog, which allows to select which attributes are displayed for the listed TV programmes. In the listbox on the left of the dialog window there's a list of all available attribute categories, e.g. title, running time, weekday, TV network name, ratings, ... i.e. mostly the same which are available for filtering.  You can create your own attributes to extend this list with the dialog described in the next chapter.
} {} {The listbox on the right contains the types currently selected for display.  The topmost entry appears on the left side of the listbox. Press } {} {Apply} underlined { to refresh the browser listbox with the new column selection and save the new configuration to the config file.
} {} {In the "single list" layout (see } {} {Configuration: List layout} href {) each attribute has it's own column in the TV schedule and and associated filter menu in the button on top of the column (provided column headers have not been disabled, see } {} {Configuration: Show/Hide} href {.)  You can change the width of each column by moving the mouse pointer to the very right of the menu button and then dragging the border to a new position while keeping the left mouse button pressed down.
} {} {In the "spearate network columns" layout attributes are printed beneath each other in separate lines in the TV schedule's network columns, unless you select } {} {No new line after element} underlined { while the respective attribute is selected in the right listbox. Empty rows are automatically suppressed, e.g. in contrary to the "single list" layout the number of attributes actually displayed may vary.  This is particularily useful for user-defined attributes, e.g. you could specify that theme categories are only printed for movies to keep the listing more compact.
} {} {Attribute composition} title2 {
} {} {Open the configuration dialog for } {} {composite attributes} underlined {, which allows to create new column types for the "single list" TV schedule layout (see } {} {Configuration: List layout} href {) or new rows respectively in the "spearate network columns" layout, which can afterwards be selected in addition to the predefined attribute types (e.g. "Title" and "Theme") as described in the previous chapter.
} {} {For a general description of composite attributes see } {} {Composite attributes} href {.  This chapter only describes usage of the configuration dialog.  This chapter also assumes you're familiar with the concept of filter shortcuts (see } {} {Filter shortcuts} href {) and reminders (see } {} {Reminders} href {)
} {} {The dialog consists of three sections: at the top to the right there is a drop-down menu which lists all currently defined composite attributes. Here you select which attribute definition you want to edit.  Below to the left is a list of shortcuts and reminder groups and 4 buttons to edit the list.  On the right side of the shortcut list there are various controls for defining how programmes matching shortcuts or reminder groups should be displayed.
} {} {Note that there are dependencies between those sections: when you change to a different attribute definition with the drop-down menu at the top, the rest of the dialog is immediately updated to display the current definition of the composite attribute (you'll get a warning if there any unsaved changes in the previous assignments).  Also, when you select a shortcut in the listbox, the display attributes at the right are updated.
} {} {To create a new composite attribute, you will start by selecting the } {} {Create new definition} underlined { command in the menu at the top right of the dialog window. You should give the label right away, so that you can keep your definitions apart, see } {} {Configuration: Select attributes} href {. You should also assign a column header text (only used in the "single list" layout), which will appear above the programme list in the main windiw; you'll probably use a shorter text here than in the label.
} {} {Then you add one or more filters to the list by use of the } {} {Add shortcut} underlined { or } {} {Add reminder} underlined { drop-down menus to the left of the listbox. New entries are always appended at the end of the list, but you can change the ordering by use of the up/down arrow buttons.  To remove a shortcut or reminder group from the list, first select it then click the } {} {Delete} underlined { button or key.  Note: ordering is important when a programme is matched by more than one shortcut, or if you mix shortcuts with reminder groups, because the display format will be determined by the first matching entry in the list, strting at the top (see also } {} {Composite attributes} href {.)
} {} {At the right of the shortcut list there are controls which defines what's displayed in the programme list depending on a shortcut or reminder match (for programmes which don't match any of the given shortcuts nothing will be displayed, unless you have a } {} {*no match*} underlined { entry.) By default a match is displayed as the name of the matching shortcut or reminder group, but you can easily change that with the controls to the right of the listbox.  The choices are: freely defined but static text, one of the pre-defined images or one of the programme's attributes (i.e. if you select } {} {Time} underlined { the programme's start time will be displayed).
} {} {In case you chose to use text (including attributes), you can select bold, underlined or overstrike font and the text color.  For all types you can also select a background color, either only for the single column in which the element is displayed, or the complete programme element.  The resulting appearance is shown in a } {} {Text sample} bold { above the controls.  These display options can be configured separately for every shortcut match.  An exception is the entire-column background color; if such a format is found in multiple attributes, the last one counts.
} {} {When you want to try out your attribute definition, press the } {} {Apply} underlined { button at the bottom.  The definition is saved and the browser content is updated.  If the attribute is not currently used in the browser, you're offered in a popup message to automatically append the attribute to the TV schedule.  You can later change it's position by using the } {} {Select attributes} underlined { configuration dialog.
} {} {There's also a } {} {Delete} underlined { button at the bottom which allows to remove obsolete definitions.  If the composite attribute is still displayed in the browser, it's automatically removed.  Note that a deletion cannot be undone, i.e. the information is lost irrecoverably.
} {} {Select networks} title2 {
} {} {Open the network selection dialog. It allows to permanently suppress TV networks in a provider's listing, e.g. if you can not receive the channel. You can also change the order of the networks, e.g. to put your favorite networks at the top of the filter menus.
} {} {This window has two lists: on the left you'll find all networks that are covered by the provider in their original order, on the right those that are selected for the programme listing in your preferred order. By default, both lists will have exactly the same content. If you want to exclude networks, select them in the right list and press } {} {Delete} underlined {. You can always include them again by selecting them in the left list and pressing } {} {Add} underlined {. You can change the order in the right list by selecting one or more networks and pressing the } {} {up} underlined { or } {} {down} underlined { arrows.
} {} {If you want the same selection and order for all providers, you can simply copy your order and selection with the } {} {copy} underlined { popup menu;  this menu contains a list of all known providers.  Note that if you copy from a provider with less (or different) networks, those networks that are missing in the other provider's database appear at the end of the network selection in the right listbox.
} {} {At the bottom of the dialog window there's an entry field named } {} {Air times} bold { that allows to limit the program listing for a network to a given time frame. For example if you receive } {} {Arte} underlined { only from 19:00 until 07:00 o'clock, select "Arte" either in the left or right list, then enter "19:00" and "07:00" in the fields (make sure to always use 4 digits and the separating colon).  Programmes that fall completely outside that window will not appear in the browser window.  If you want to undo the limitation, enter 00:00 until 00:00 or any other equal time values.
} {} {Note: you can also operate this dialog (and all other dialogs with similar listbox selections) with he keyboard: use the TAB key or the mouse to move the keyboard input focus to the left or right listbox. Use the cursor up/down keys to select an item; hold down SHIFT to select multiple items. In the left list, press Return to add a network to the right list. In the right list, press the Delete key to remove a network, or press CONTROL and the up/down cursor keys to change the selected items' position in the list.
} {} {Network names} title2 {
} {} {Open the network names configuration dialog. It's main purpose is to synchronize the network names between nxtvepg and your TV application. This is required because the network name is used in communication when you use the } {} {Tune TV} underlined { remote controls, and as well for channel change notifications by the TV applications.  For many networks there will be no need to change anything, but for some there exist different variants, e.g. in Germany "Super RTL" vs. "S-RTL" or "MDR3" vs. "MDR".
} {} {If you're not using UNIX, you first need to select which TV application you want to synchronize with and where the configuration files are located.  This is done in the } {} {TV app. interaction} underlined { dialog in the Configure menu (see } {} {Configuration: TV application interaction} href {).
} {} {Another use of this dialog is to make network naming consistent across all Nextview providers. The names you specify here will be used in the programme listbox and all filter menus, independently of the provider.
} {} {On the left side of the dialog you find a list of all networks of all known Nextview providers. The names used here are the ones you configured before, or if you haven't done so yet, the names that match the station names of your TV application best. Unmatched names are marked red.  If no TV application is configured, each network's name is taken from the first Nextview database which covers this network, in order of your provider selection history.
} {} {On the right side, you're offered four ways to change the name: topmost is a simple entry field where you can type in an arbitrary name. Below is a popup menu which contains all network names defined in your TV app.'s channel table.  Below is a button which contains the one name in your TV app.'s channel table which resembles the current string in the entry field most, or } {} {none} underlined {. It's marked red until it's identical to the entry field. You can copy the name to the entry field by clicking the button. Below is a listbox with the original names used in the various provider databases. When you select a name from the menu or the listbox, it will be copied into the entry field and the network name list on the left. If you want to save the changed list, leave the dialog with } {} {Save} underlined {, else use } {} {Abort} underlined {.
} {} {Note: if you receive channels that carry multiple networks, e.g. in Germany "Arte / Kinderkanal", it's recommended to include all networks' names in the network name on side of the TV application, separated by a slash.  The slash is recognized as separator by nxtvepg and all resulting segments can be used as network names.
} {} {Context menu configuration} title2 {
} {} {Open the context menu configuration dialog which allows to change the order of automatically generated menu entries or to extend the popup menu with user-defined external commands (for a general description of the context menu see } {} {Context menu} href {).
} {} {The dialog window there is a list of all currently defined command titles.  When you open the dialog for the first time, you'll see only pre-defined "pseudo commands."  They don't show up like that in the context menu, they just represent commands which are automatically inserted in their place at run-time, depending on the currently selected programme entries and current filter settings.
} {} {As usual, you can change the ordering by selecting an entry and then clicking the buttons with up/down arrows. To remove an entry, select it and press } {} {Delete} underlined {.  If you make an error you can leave the dialog with } {} {Abort} underlined {; changes aren't applied and saved until you leave the dialog with } {} {Ok} underlined {.
} {} {The } {} {Add new} underlined { menu button allows to insert a new menu item:
} {} {External command} bold {
} {} {Start an external application with the given command line parameters. This is equivalent to typing a command into a UNIX shell or using } indent {Run command} {underlined indent} { in the Windows Start menu.  Command line parameters may use variable substitution as described below.  To allow sharing the same nxtvepg configuration file on UNIX and Windows, there are different types, i.e. UNIX or Windows.  Commands are only included in the context menu if the platform matches the command type.
} indent {The dialog's entry field labeled } indent {Title} {bold indent} { defines the text which will be included to the popup menu.  The field labeled } indent {Command} {bold indent} { defines the command line
} indent {TV application remote command} bold {
} {} {Send the given command line to an attached TV application, e.g. to switch TV channels.  Variable substitution can be used here, too. How the command is sent depends on the TV application; when no TV app. is connected, such entries are automatically disabled (see also } indent {Configuration: TV application interaction} {href indent} {) For example
} indent {  setstation ${network}

} {pfixed indent} {would create a command that switches the TV app's channel to that of the currently selected programme (i.e. the same what the } indent {Tune TV} {underlined indent} { button does).  You should refer to the documentation of your TV app to see which commands it supports.  When no TV application is connected, such entries are automatically disabled.
} indent {Menu title} bold { and } {} {Menu separator} bold {
} {} {These can be used to organize the menu contents into groups. In case of menu titles, the dialog's entry field labeled } indent {Title} {bold indent} { defines the text which will be included to the popup menu.
} indent {Add/Undo programme filters} bold {
} {} {This menu entry will be replaced by automatically generated commands to manipulate filter settings. See } indent {Context menu} {href indent} { for details.
} indent {Add/remove reminder} bold {
} {} {This menu entry will be replaced by automatically generated commands to manipulate the reminder list. There are two versions of the entry: if you select the extended version, an additional entry will be included which allows to select reminder groups (only useful if you're using multiple groups, see also } indent {Reminders} {href indent} {.)
} indent {When you press the menu button } {} {Add Example} underlined { a list pops up which contains a few example commands which can be copied into the title and command entry fields.
} {} {As mentioned above, external commands and TV app. remote commands allow to include placeholders enclosed in ${} which are replaced by attributes of the programme selected in the browser listbox at the time the context menu command is invoked.  The following is a list of such formal variables The meaning of the variables should be self-explanatory, except possibly for CNI: this is a hexadecimal network code, and e/p_rating: these are editorial and parental ratings respectively.
} {} {  ${title}
  ${network}
  ${start}
  ${stop}
  ${relstart}
  ${duration}
  ${CNI}
  ${description}
  ${themes}
  ${VPS}  or  ${PDC}
  ${e_rating}
  ${p_rating}
  ${sound}
  ${format}
  ${digital}
  ${encrypted}
  ${live}
  ${repeat}
  ${subtitle}

} pfixed {Start and stop time related keywords can optionally be followed by either a plus or minus sign and a time offset.  The offset value is assumed to be given as minutes.  For relstart and duration the precision can be changed by means of the format (see below.)  Example: to print the start time minus 5 minutes (e.g. to start a recording 5 minutes earlier) use } {} {${start-5:%H:%M}} fixed {
} {} {The keywords can optionally be followed by a colon and an output format specification.  Options depend on the type of variable substitution:
} {} {Start, stop and VPS/PDC times} underlined {
} {} {All options defined in the } indent {strftime(3)} {bold indent} { manpage are available; default is %H:%M-%d.%m.%Y (hour, minute, day, month, year).
} indent {Relative start time and duration} underlined {
} {} {You can choose between minutes (default) and seconds by appending "m" or "s".
} indent {Themes} underlined {
} {} {You can choose between numerical and textual output by appending "n" or "t".
} indent {For all other variables modifiers are currently ignored.
} {} {On UNIX the resulting substrings which replace the formal variables are always enclosed in single quotes, because the command line is passed to a system shell for execution (/bin/sh, i.e. the } {} {Bourne Shell} underlined { by means of the } {} {system} underlined { function; see also system man pages } {} {sh} bold { or } {} {bash} bold {) and there are many characters with special meaning.  Single quotes inside he substituted string are correctly escaped.
} {} {Example: The command line
} {} {  plan ${start:%d.%m.%Y %H:%M} ${title}

} pfixed {could for example on UNIX systems result in
} {} {  plan '22.08.2001 13:05' 'Kpt'\''n Blaubrs Seemannsgarn'

} pfixed {On Windows only single- and double quotes and spaces characters are escaped with a backslash. Hence the above example would result in:
} {} {  plan 22.08.2001\ 13:05 Kpt\'n\ Blaubrs\ Seemannsgarn

} pfixed {Note if you want to prevent the backslash inbetween date and time (if the called program doesn't understand it), you can simply use two separate substitutions for date and time. Example:
} {} {  plan ${start:%d.%m.%Y} ${start:%H:%M} ${title}

} pfixed {Themes language} title2 {
} {} {Select the language for programme themes (i.e. content category, see } {} {Filtering} href {) in the main window and the filter menu.  By default it's set to default, in which case the language is derived from the selected provider's database.  Please note that the language of the menus, help etc. currently can not be changed from English.
} {} {Show/Hide} title2 {
} {} {Toggle visibility of various components in the main window:
} {} {Show shortcuts} underlined {
} {} {Toggle visibility of the shortcut listbox at the left of the programme list. When you unmap both the shortcuts list and the network list below, the clock and reset buttons are also unmapped so that you get only the programme list.
} indent {Show networks (left)} underlined {
} {} {Maps or unmaps the network filter listbox below the shortcuts list, or below the clock if you've unmapped the shortcuts list.
} indent {Show networks (middle)} underlined {
} {} {Maps or unmaps the network filter listbox between shortcuts listbox and programme list.
} indent {Show layout button} underlined {
} {} {Maps or unmaps the } indent {Grid layout} {underlined indent} { checkbutton below the shortcuts or network list in the main window (see also } indent {Configuration: List layout} {href indent} {). If you're permanently using one or the other layout, you will probably want to unmap this button.  (It's mainly present to make users who upgrade from older versions aware of this new option.)
} indent {Show status line} underlined {
} {} {Maps or unmaps the database and acquisition status line at the bottom of the browser window.
} indent {Show column headers} underlined {
} {} {Maps or unmaps the browser listbox column header menubar, i.e. the row of menu buttons above the programme list in single list layout.
} indent {Show weekday scale} underlined {
} {} {Maps or unmaps the weekday scale to the right of the programme list. (Note you can configure the looks, i.e. font, colors, width and date format via the resource file } indent {nxtvepg.ad} {fixed indent} { or } indent {.Xdefaults} {fixed indent} { on UNIX, see } indent {Files} {href indent} {)
} indent {Hide on minimize} underlined {
} {} {Windows only: When this option is enabled, the main window's entry in the task bar is removed when it's minimized or when the program is started with the } indent {-iconic} {underlined indent} { command line switch.  Instead an icon is added to the system tray in the task bar.  A double-click on the tray icon deiconifies the main window.  A click with the right mouse button opens a little popup menu.  The entries in this menu have the same meaning as the equally named ones in the control menu (see } indent {Control} {href indent} {).
} indent {List layout} title2 {
} {} {Select layout of the programme list in the main window:
} {} {Single list for all networks} underlined {
} {} {This is the original layout (the only layout until nxtvepg version 2.4) in which all programmes of all networks are presented in a single list, sorted by start time.
} indent {Separate columns for each network} underlined {
} {} {In this layout programmes are still sorted by start time, but presented in separate columns for each network.  Schedules of different networks are aligned, so that programmes which run at the same time are approximately at the same height.
} indent {You can join several columns in a single column via the } indent {Control} {underlined indent} { menu (meant for networks which share the same channel; use this in conjunction with } indent {air times restriction} {underlined indent} { as described in } indent {Configuration: Select networks} {href indent} {.)  The control menu is part of the drop-down menu below the button at the top of the column.  This menu also holds commands to increase or decrease the number of visible columns.
} indent {In both layouts you can select which types of attributes are printed for each programme by clicking on the icon in the button row at the top of the list (unless column header buttons are hidden.)
} {} }
set {helpIndex(Files)} 16
set helpTexts(16) {{Files} title1 {
} {} {Files used on UNIX systems} title2 {
} {} {$HOME/.nxtvepgrc} bold {
} {} {Configuration file where all personal settings are stored. Per default this is created in your home directory, but a different path and file name can be specified with the } indent {-rcfile} {bold indent} { option (see } indent {Options} {href indent} {).
} indent {/usr/tmp/nxtvdb/nxtvdb-} bold {
} {} {Directory containing one file for each provider's database.  The path can be changed with the } indent {-dbdir} {bold indent} { command line option (see } indent {Options} {href indent} {). Note that the path can also be configured during compilation of the software, so if you downloaded a binary version of this package the path may be different.  The current default setting can be queried with the } indent {-help} {bold indent} { command line switch.
} indent {The last 4 digits of the file names are the hexadecimal CNI (Country and Network Identifier) of the provider.
} indent {/dev/vbi0} bold {, } {} {/dev/vbi1} bold {, etc.
} {} {Device files from which Nextview data is being read during acquisition. The index postfix can be specified with the } indent {-card} {bold indent} { command line option (see } indent {Options} {href indent} {). You must have read/write access to these files; by default this is not the case for many Linux distributions for security reasons (since you might have connected a WebCam and mike and someone could spy on you from remote).  However on a single-user system it's safe to make them world-readable and writable, i.e. in a root shell enter:
} indent {  chmod 666 /dev/vbi

} {pfixed indent} {Alternatively you can make yourself a member of a group in } indent {/etc/groups} {underlined indent} { which has access to the devices or create such a group.
} indent {/dev/video0} bold {, } {} {/dev/video1} bold {, etc.
} {} {On Linux kernel series 2.4 and earlier (i.e. before revision #2 of the video4linux API) these device files are used to select the input source (e.g. TV tuner or one of the composite or S-Video sockets) and tuner frequency for VBI reception, unless you choose the passive acquisition mode. The index postfix can be specified with the } indent {-card} {bold indent} { command line option. This device must be readable and writable.
} indent {The device is only kept open during a provider search (see } indent {Configuration: Provider scan} {href indent} {).  Else, it's just opened shortly to set the input source and tuner frequency. If the device is busy (e.g. while you watch TV), acquisition starts on the currently selected channel and automatically follows any externally controlled changes (this will be reported, e.g. in the status line at the bottom of the browser window, as } indent {forced passive} {underlined indent} { acquisition mode, see } indent {Statistics: Status line} {href indent} {).
} indent {Note: it's mandatory that the video device has the same index as the VBI device.  If you have a video device at index 0 which does not support teletext (a webcam, for example) the VBI device belonging to video device #1 may appear at index 0.  You should force the driver to assign device index #1 to the VBI index.  On Linux this is possible by using } indent {insmod} {underlined indent} { parameters in } indent {/etc/modules.conf} {underlined indent} {, e.g. for bttv:
} indent {   options bttv video_nr=1 vbi_nr=1

} {pfixed indent} {/dev/v4l/vbi0} bold {, } {} {/dev/v4l/video0} bold {
} {} {If you have enabled } indent {devfs} {underlined indent} { in your Linux kernel, the VBI and video devices will appear in a subdirectory.  nxtvepg automatically detects the existance of this directory and will search the devices there instead of the regular paths.
} indent {/tmp/.vbi0.pid} bold {, } {} {/tmp/.vbi1.pid} bold {, etc.
} {} {This file contains the process id of the Nextview decoder (or the acquisition slave process unless threading is used) whenever a vbi device is kept open. The process can be forced to free the device by sending it signal SIGHUP, e.g. from a wrapper script around a teletext decoder. An example which works with sh, bash or tcsh:
} indent {   kill -HUP `cat /tmp/.vbi0.pid`

} {pfixed indent} {Note that the daemon is not kept alive when acquisition is disabled, so that sending HUP equals sending TERM.  You can restart acquisition by starting a new daemon.  The browser attempts to reconnect every 10 seconds when the connection was broken, but you can also trigger an immediate reconnect be signalling it a HUP.
} indent {To restart acquisition in non-daemon mode, signal again with HUP, either to the acquisition slave process or the browser process.
} indent {/tmp/nxtvepg.0} bold {
} {} {This non-regular file (socket) is created by the daemon to allow local client connections via UNIX domain sockets.  The same socket can be used for more than one client connection.  It's deleted when the daemon terminates (unless the daemon crashes or receives an uncatchable signal like the infamous signal 9 aka KILL). See also } indent {Control: Connect to acq. daemon} {href indent} {.
} indent {$HOME/.xawtv} bold {
} {} {This file belongs to the TV viewer } indent {xawtv} {underlined indent} {. It's not required or created by nxtvepg. But if it exists, it will be used in the EPG scan (for a fast scan mode where only the channels defined in this file will be checked) and in the network name configuration dialog.  See also } indent {Configuration: TV application interaction} {href indent} {.
} indent {$HOME/.Xdefaults} bold {
} {} {This file is usually loaded into the X server at startup (or during login) by use of the } indent {xrdb} {underlined indent} { command.  It contains a series of parameter assignments called } indent {X resource definitions} {underlined indent} { for any number of applications. Note: depending on your X11 startup scripts this file may have a different name, e.g. } indent {.Xresources} {underlined indent} {.  The file could be used to change the "look" of almost every element in every dialog window (within limits, because some options are hard-coded) or the look of entire widget classes, like menus or buttons. However that's highly implementation dependent and generally not very useful, hence depreciated.
} indent {Defaults for all officially supported options are listed in the so-called "app-defaults" file } indent {Nxtvepg.ad} {underlined indent} { which is usually installed in } indent {/usr/X11/lib/X11/app-defaults} {underlined indent} { (the .ad extension is omitted during installation.)  You should not change values there however, because they would be overwritten when you install new versions.  Instead copy changed lines into your .Xdefaults file (without the leading comment ! sign.) Note you have to restart nxtvepg for changes to take effect.  When X11 is already running you can override individual settings with xrdb like this:
} indent {   echo "nxtvepg*text_bg: #E9E9EC" | xrdb -merge

} {pfixed indent} {Color values can specified either symbolically (e.g. "red") or as hexadecimal RGB values in #RRGGBB format.  A special case are the 7 colors for weekday background colors in the main window's date scale: it's resource value consists of a comma separated list of 7 colors.
} indent {Fonts must be specified as triplets of family, size (use negative values to specify the size in pixels and positive values for sizes given in points) and appearance (only "normal" or "bold" are recommended).  Lines starting with a ! sign are treated as comment and hence ignored.  Entries that do not adhere to this syntax are silently discarded.
} indent {Files used on Windows systems} title2 {
} {} {nxtvepg.ini} bold {
} {} {Configuration file where all configuration and personal preference settings are stored. By default this is created in the working directory, but a different path and file name can be specified with the } indent {-rcfile} {bold indent} { option (see } indent {Options} {href indent} {).
} indent {Nxtvepg.ad} bold {
} {} {Allows to change the application's appearance, i.e. colors and text fonts. The format and content of the file is identical to the } indent {.Xdefaults} {underlined indent} { file described in the UNIX section.
} indent {nxtv____.epg} bold {
} {} {One file for each provider's database is created in the working directory or the one given with the } indent {-dbdir} {bold indent} { command line option (see } indent {Options} {href indent} {). The last 4 digits of the file base names are the hexadecimal CNI (Country and Network Identifier) of the provider.  You must not change the name of this file, or nxtvepg will refuse to load the database.
} indent {vbi_map.dat} bold {
} {} {This hidden file is used to set up shared memory to allow information exchange between nxtvepg and an attached TV application.  It's automatically removed when nxtvepg terminates and should never be accessed (i.e. being written to or removed) by external applications. The file is not created when TV app. interaction is disabled (see } indent {Configuration: TV application interaction} {href indent} {).
} indent }
