/**************************************************************************/
/*                                                                        */
/*                                 OCaml                                  */
/*                                                                        */
/*   Xavier Leroy and Pascal Cuoq, projet Cristal, INRIA Rocquencourt     */
/*                                                                        */
/*   Copyright 1996 Institut National de Recherche en Informatique et     */
/*     en Automatique.                                                    */
/*                                                                        */
/*   All rights reserved.  This file is distributed under the terms of    */
/*   the GNU Lesser General Public License version 2.1, with the          */
/*   special exception on linking described in the file LICENSE.          */
/*                                                                        */
/**************************************************************************/

#define CAML_INTERNALS

#include <caml/mlvalues.h>
#include <caml/osdeps.h>
#include <caml/memory.h>
#include "unixsupport.h"

CAMLprim value unix_mkdir(path, perm)
     value path, perm;
{
  int err;
  wchar_t * wpath;
  caml_unix_check_path(path, "mkdir");
  wpath = caml_stat_strdup_to_utf16(String_val(path));
  err = _wmkdir(wpath);
  caml_stat_free(wpath);
  if (err == -1) uerror("mkdir", path);
  return Val_unit;
}
