(* Perl DBD database interface for mod_caml programs.
 * Copyright (C) 2003 Merjis Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: dbi_perl.mli,v 1.2 2004/03/02 16:02:05 rwmj Exp $
 *)

(** Use Perl DBD (database drivers) with Dbi.
  *
  * This module lets you use any Perl DBD (database driver) with the
  * [Dbi]. You can use this as a stopgap until native OCaml support
  * is available.
  *
  * Please see {!Dbi} for main documentation.
  *)

class connection :
  ?host:string ->
  ?port:string ->
  ?user:string ->
  ?password:string ->
  string ->
object
  method close : unit -> unit
  method closed : bool
  method commit : unit -> unit
  method database : string
  method database_type : string
  method debug : bool
  method ex : string -> Dbi.sql_t list -> Dbi.statement
  method host : string option
  method id : int
  method password : string option
  method ping : unit -> bool
  method port : string option
  method prepare : string -> Dbi.statement
  method prepare_cached : string -> Dbi.statement
  method register_postrollback : (unit -> unit) -> Dbi.postrollback_handle
  method register_precommit : (unit -> unit) -> Dbi.precommit_handle
  method rollback : unit -> unit
  method set_debug : bool -> unit
  method unregister_postrollback : Dbi.postrollback_handle -> unit
  method unregister_precommit : Dbi.precommit_handle -> unit
  method user : string option
end
