(*
 * Graph: generic graph library
 * Copyright (C) 2004
 * Sylvain Conchon, Jean-Christophe Filliatre and Julien Signoles
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2, as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the GNU Library General Public License version 2 for more details
 * (enclosed in the file LGPL).
 *)

(* $Id: util.mli,v 1.10 2004/02/05 10:04:02 signoles Exp $ *)

open Sig

module OTProduct(X: ORDERED_TYPE)(Y: ORDERED_TYPE) : 
  ORDERED_TYPE with type t = X.t * Y.t

module HTProduct(X: HASHABLE)(Y: HASHABLE) :
  HASHABLE with type t = X.t * Y.t

module CMPProduct(X: COMPARABLE)(Y: COMPARABLE) : 
  COMPARABLE with type t = X.t * Y.t
