(* $Id: netsendmail.mli,v 1.1 2002/02/02 23:52:43 stolpmann Exp $
 * ----------------------------------------------------------------------
 *
 *)

val compose :
      ?in_charset:Netconversion.encoding ->
      ?out_charset:Netconversion.encoding ->
      ?from_addr:(string * string) ->
      ?cc_addrs:(string * string) list ->
      ?bcc_addrs:(string * string) list ->
      ?attachments:Netmime.complex_mime_message list ->
      to_addrs:(string * string) list ->
      subject:string ->
      (* text:*) string ->
	Netmime.complex_mime_message

  (* Composes a mail message with a main "text/plain" message, and optionally
   * a number of attachments.
   *
   * The addresses are passed as pairs (human_readable, formal) where
   * [human_readable] is an arbitrary printable string identifying the
   * sender/receiver, and where [formal] is the RFC-822 mailbox specification.
   * An example would be ("Stolpmann, Gerd", "gerd@gerd-stolpmann.de").
   * 
   * All passed texts (except the formal addresses) are encoded in [in_charset].
   * [in_charset] defaults to ISO-8859-1. All texts are recoded to 
   * [out_charset]. The formal addresses must be ASCII strings, and are not
   * recoded.
   *
   * The resulting message is always in MIME format.
   *
   * NOTE: The ~out_charset must be ASCII-compatible, otherwise the routine
   * will make some wrong decisions. UTF-8, and all the ISO-8859 character
   * sets are ASCII-compatible.
   *)

val sendmail : ?mailer:string -> Netmime.complex_mime_message -> unit
  (* Sends the passed message. The mailer program must be sendmail-compatible.
   * The mailer program is the command passed as ~mailer, which is by
   * default a reasonable compiletime setting.
   *)


(**********************************************************************
 * EXAMPLES:
 *
 * (1) To send a simple notification:
 *
 * sendmail (compose ~to_addrs:["Your Name", "your.name@domain"] 
 *                   ~subject:"about..."
 *                   "The batch job has successfully finished!")
 *
 * (2) To send a message with an attachment:
 *
 * let a = ( new Netmime.basic_mime_header
 *                 [ "content-transfer-encoding", "base64";
 *                   "content-type", "application/octet-stream";
 *                   "content-disposition", "attachment"
 *                 ],
 *           `Body (new Netmime.file_mime_body "/your/file")
 *         )
 * in
 * sendmail (compose ~to_addrs:["Your Name", "your.name@domain"] 
 *                   ~attachments:[a]
 *                   ~subject:"about..."
 *                   "An error has occurred (log file attached)")
 *
 * (3) To see the composed message, just use
 *
 * sendmail ~mailer:"cat #" ...
 *
 * which prints the message to stdout.
 *)

(* ======================================================================
 * History:
 * 
 * $Log: netsendmail.mli,v $
 * Revision 1.1  2002/02/02 23:52:43  stolpmann
 * 	Initial revision.
 *
 * 
 *)
