// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOP_CompositeClassifier_HeaderFile
#define _BOP_CompositeClassifier_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _BOP_LoopClassifier_HeaderFile
#include <BOP_LoopClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Handle_BOP_Loop_HeaderFile
#include <Handle_BOP_Loop.hxx>
#endif
class BOP_BlockBuilder;
class BOP_Loop;
class TopoDS_Shape;



//!  The Root class for algorithms <br>
//!  to   classify composite Loops, i.e, Loops that <br>
//!  can be either a Shape, or a block of Elements. <br>
//! <br>
class BOP_CompositeClassifier  : public BOP_LoopClassifier {
public:

  DEFINE_STANDARD_ALLOC

  
//! Classify loop <L1> with  <L2> <br>
  Standard_EXPORT   virtual  TopAbs_State Compare(const Handle(BOP_Loop)& L1,const Handle(BOP_Loop)& L2) ;
  
//! Classify shape <B1> with shape <B2> <br>
  Standard_EXPORT   virtual  TopAbs_State CompareShapes(const TopoDS_Shape& B1,const TopoDS_Shape& B2)  = 0;
  
//! Classify element <E> with shape <B> <br>
  Standard_EXPORT   virtual  TopAbs_State CompareElementToShape(const TopoDS_Shape& E,const TopoDS_Shape& B)  = 0;
  
//! Prepare classification involving shape <B> <br>
//! Calls ResetElement on first element of <B> <br>
  Standard_EXPORT   virtual  void ResetShape(const TopoDS_Shape& B)  = 0;
  
//! Prepare classification involving element <E>. <br>
  Standard_EXPORT   virtual  void ResetElement(const TopoDS_Shape& E)  = 0;
  
//! Add element <E> in the set of elements used in classification. <br>
  Standard_EXPORT   virtual  void CompareElement(const TopoDS_Shape& E)  = 0;
  
//! Returns state of classification of 2D point, defined by <br>
//! ResetElement, with the current set of elements, <br>
//! defined by Compare. <br>
  Standard_EXPORT   virtual  TopAbs_State State()  = 0;





protected:

  
//! Initializing the object with BlockBuilder; <br>
  Standard_EXPORT   BOP_CompositeClassifier(const BOP_BlockBuilder& BB);


Standard_Address myBlockBuilder;


private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
