// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESData_ParamReader_HeaderFile
#define _IGESData_ParamReader_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Interface_ParamList_HeaderFile
#include <Handle_Interface_ParamList.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IGESData_ReadStage_HeaderFile
#include <IGESData_ReadStage.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Interface_ParamType_HeaderFile
#include <Interface_ParamType.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_IGESData_IGESReaderData_HeaderFile
#include <Handle_IGESData_IGESReaderData.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _IGESData_Status_HeaderFile
#include <IGESData_Status.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_Interface_HArray1OfHAsciiString_HeaderFile
#include <Handle_Interface_HArray1OfHAsciiString.hxx>
#endif
#ifndef _Handle_IGESData_HArray1OfIGESEntity_HeaderFile
#include <Handle_IGESData_HArray1OfIGESEntity.hxx>
#endif
class Interface_ParamList;
class Interface_Check;
class Interface_InterfaceError;
class IGESData_IGESEntity;
class IGESData_IGESReaderData;
class IGESData_ParamCursor;
class Message_Msg;
class gp_XY;
class gp_XYZ;
class TCollection_HAsciiString;
class Standard_Type;
class TColStd_HArray1OfInteger;
class TColStd_HArray1OfReal;
class Interface_HArray1OfHAsciiString;
class IGESData_HArray1OfIGESEntity;
class Interface_EntityList;


//! access to a list of parameters, with management of read stage <br>
//!           (owned parameters, properties, associativities) and current <br>
//!           parameter number, read errors (which feed a Check), plus <br>
//!           convenient facilities to read parameters, in particular : <br>
//!           - first parameter is ignored (it repeats entity type), hence <br>
//!             number 1 gives 2nd parameter, etc... <br>
//!           - lists are not explicit, list-reading methods are provided <br>
//!             which manage a current param. number <br>
//!           - interpretation is made as possible (texts, reals, entities ...) <br>
//!             (in particular, Reading a Real accepts an Integer) <br>
class IGESData_ParamReader  {
public:

  DEFINE_STANDARD_ALLOC

  //! Prepares a ParamReader, stage "Own", current param = 1 <br>
//!           It considers a part of the list, from <base> (excluded) for <br>
//!           <nbpar> parameters; <nbpar> = 0 commands to take list length. <br>
//!           Default is (1 to skip type) <br>
  Standard_EXPORT   IGESData_ParamReader(const Handle(Interface_ParamList)& list,const Handle(Interface_Check)& ach,const Standard_Integer base = 1,const Standard_Integer nbpar = 0,const Standard_Integer num = 0);
  //! Returns the entity number in the file <br>
  Standard_EXPORT     Standard_Integer EntityNumber() const;
  //! resets state (stage, current param number, check with no fail) <br>
  Standard_EXPORT     void Clear() ;
  //! returns the current parameter number <br>
//!           This notion is involved by the organisation of an IGES list of <br>
//!           parameter : it can be ended by two lists (Associativities and <br>
//!           Properties), which can be empty, or even absent. Hence, it is <br>
//!           necessary to know, at the end of specific reading, how many <br>
//!           parameters have been read : the optionnal lists follow <br>
  Standard_EXPORT     Standard_Integer CurrentNumber() const;
  //! sets current parameter number to a new value <br>
//!           must be done at end of each step : set on first parameter <br>
//!           following last read one; is done by some Read... methods <br>
//!           (must be done directly if these method are not used) <br>
//!           num greater than NbParams means that following lists are empty <br>
//!           If current num is not managed, it remains at 1, which probably <br>
//!           will cause error when successive steps of reading are made <br>
  Standard_EXPORT     void SetCurrentNumber(const Standard_Integer num) ;
  //! gives current stage (Own-Props-Assocs-End, begins at Own) <br>
  Standard_EXPORT     IGESData_ReadStage Stage() const;
  //! passes to next stage (must be linked with setting Current) <br>
  Standard_EXPORT     void NextStage() ;
  //! passes directly to the end of reading process <br>
  Standard_EXPORT     void EndAll() ;
  //! returns number of parameters (minus the first one) <br>
//!           following method skip the first parameter (1 gives the 2nd) <br>
  Standard_EXPORT     Standard_Integer NbParams() const;
  //! returns type of parameter; note that "Ident" or "Sub" cannot <br>
//!           be encountered, they correspond to "Integer", see also below <br>
  Standard_EXPORT     Interface_ParamType ParamType(const Standard_Integer num) const;
  //! returns litteral value of a parameter, as it was in file <br>
  Standard_EXPORT    const Standard_CString ParamValue(const Standard_Integer num) const;
  //! says if a parameter is defined (not void) <br>
//!           See also DefinedElseSkip <br>
  Standard_EXPORT     Standard_Boolean IsParamDefined(const Standard_Integer num) const;
  //! says if a parameter can be regarded as an entity reference <br>
//!           (see Prepare from IGESReaderData for more explanation) <br>
//!           Note that such a parameter can seen as be a plain Integer too <br>
  Standard_EXPORT     Standard_Boolean IsParamEntity(const Standard_Integer num) const;
  //! returns entity number corresponding to a parameter if there is <br>
//!           otherwise zero (according criterium IsParamEntity) <br>
  Standard_EXPORT     Standard_Integer ParamNumber(const Standard_Integer num) const;
  //! directly returns entity referenced by a parameter <br>
  Standard_EXPORT     Handle_IGESData_IGESEntity ParamEntity(const Handle(IGESData_IGESReaderData)& IR,const Standard_Integer num) ;
  //! Creates a ParamCursor from the Current Number, to read one <br>
//!           parameter, and to advance Current Number after reading <br>
  Standard_EXPORT     IGESData_ParamCursor Current() const;
  //! Creates a ParamCursor from the Current Number, to read a list <br>
//!           of "nb" items, and to advance Current Number after reading <br>
//!           By default, each item is made of one parameter <br>
//!           If size is given, it precises the number of params per item <br>
  Standard_EXPORT     IGESData_ParamCursor CurrentList(const Standard_Integer nb,const Standard_Integer size = 1) const;
  //! Allows to simply process a parameter which can be defaulted. <br>
//!           Waits on the Current Number a defined parameter or skips it : <br>
//!           If the parameter <num> is defined, changes nothing and returns True <br>
//!           Hence, the next reading with current cursor will concern <num> <br>
//!           If it is void, advances Current Position by one, and returns False <br>
//!           The next reading will concern <num+1> (except if <num> = NbParams) <br>
//! <br>
//!           This allows to process Default values as follows (C++) : <br>
//!           if (PR.DefinedElseSkip()) { <br>
//!             .. PR.Read... (current parameter); <br>
//!           } else { <br>
//!             <current parameter> = default value <br>
//!             .. nothing else to do with ParamReader <br>
//!           } <br>
//! For Message <br>
  Standard_EXPORT     Standard_Boolean DefinedElseSkip() ;
  
  Standard_EXPORT     Standard_Boolean ReadInteger(const IGESData_ParamCursor& PC,Standard_Integer& val) ;
  //! Reads an Integer value designated by PC <br>
//!           The method Current designates the current parameter and <br>
//!           advances the Current Number by one after reading <br>
//!           Note that if a count (not 1) is given, it is ignored <br>
//!           If it is not an Integer, fills Check with a Fail (using mess) <br>
//!           and returns False <br>
  Standard_EXPORT     Standard_Boolean ReadInteger(const IGESData_ParamCursor& PC,const Standard_CString mess,Standard_Integer& val) ;
  
  Standard_EXPORT     Standard_Boolean ReadBoolean(const IGESData_ParamCursor& PC,const Message_Msg& amsg,Standard_Boolean& val,const Standard_Boolean exact = Standard_True) ;
  //! Reads a Boolean value from parameter "num" <br>
//!           A Boolean is given as an Integer value 0 (False) or 1 (True) <br>
//!           Anyway, an Integer is demanded (else, Check is filled) <br>
//!           If exact is given True, those precise values are demanded <br>
//!           Else, Correction is done, as False for 0 or <0, True for >0 <br>
//!           (with a Warning error message, and return is True) <br>
//!           In case of error (not an Integer, or not 0/1 and exact True), <br>
//!           Check is filled with a Fail (using mess) and return is False <br>
  Standard_EXPORT     Standard_Boolean ReadBoolean(const IGESData_ParamCursor& PC,const Standard_CString mess,Standard_Boolean& val,const Standard_Boolean exact = Standard_True) ;
  
  Standard_EXPORT     Standard_Boolean ReadReal(const IGESData_ParamCursor& PC,Standard_Real& val) ;
  //! Reads a Real value from parameter "num" <br>
//!           An Integer is accepted (Check is filled with a Warning <br>
//!           message) and causes return to be True (as normal case) <br>
//!           In other cases, Check is filled with a Fail and return is False <br>
  Standard_EXPORT     Standard_Boolean ReadReal(const IGESData_ParamCursor& PC,const Standard_CString mess,Standard_Real& val) ;
  
  Standard_EXPORT     Standard_Boolean ReadXY(const IGESData_ParamCursor& PC,Message_Msg& amsg,gp_XY& val) ;
  //! Reads a couple of Real values (X,Y) from parameter "num" <br>
//!           Integers are accepted (Check is filled with a Warning <br>
//!           message) and cause return to be True (as normal case) <br>
//!           In other cases, Check is filled with a Fail and return is False <br>
  Standard_EXPORT     Standard_Boolean ReadXY(const IGESData_ParamCursor& PC,const Standard_CString mess,gp_XY& val) ;
  
  Standard_EXPORT     Standard_Boolean ReadXYZ(const IGESData_ParamCursor& PC,Message_Msg& amsg,gp_XYZ& val) ;
  //! Reads a triplet of Real values (X,Y,Z) from parameter "num" <br>
//!           Integers are accepted (Check is filled with a Warning <br>
//!           message) and cause return to be True (as normal case) <br>
//!           In other cases, Check is filled with a Fail and return is False <br>
//! For Message <br>
  Standard_EXPORT     Standard_Boolean ReadXYZ(const IGESData_ParamCursor& PC,const Standard_CString mess,gp_XYZ& val) ;
  
  Standard_EXPORT     Standard_Boolean ReadText(const IGESData_ParamCursor& PC,const Message_Msg& amsg,Handle(TCollection_HAsciiString)& val) ;
  //! Reads a Text value from parameter "num", as a String from <br>
//!           Collection, that is, Hollerith text without leading "nnnH" <br>
//!           If it is not a String, fills Check with a Fail (using mess) <br>
//!           and returns False <br>
  Standard_EXPORT     Standard_Boolean ReadText(const IGESData_ParamCursor& PC,const Standard_CString mess,Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     Standard_Boolean ReadEntity(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,IGESData_Status& aStatus,Handle(IGESData_IGESEntity)& val,const Standard_Boolean canbenul = Standard_False) ;
  //! Reads an IGES entity from parameter "num" <br>
//!           An Entity is known by its reference, which has the form of an <br>
//!           odd Integer Value (a number in the Directory) <br>
//!           If <canbenul> is given True, a Reference can also be Null : <br>
//!           in this case, the result is a Null Handle with no Error <br>
//!           If <canbenul> is False, a Null Reference causes an Error <br>
//!           If the parameter cannot refer to an entity (or null), fills <br>
//!           Check with a Fail (using mess) and returns False <br>
  Standard_EXPORT     Standard_Boolean ReadEntity(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,const Standard_CString mess,Handle(IGESData_IGESEntity)& val,const Standard_Boolean canbenul = Standard_False) ;
  
  Standard_EXPORT     Standard_Boolean ReadEntity(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,IGESData_Status& aStatus,const Handle(Standard_Type)& type,Handle(IGESData_IGESEntity)& val,const Standard_Boolean canbenul = Standard_False) ;
  //! Works as ReadEntity without Type, but in addition checks the <br>
//!           Type of the Entity, which must be "kind of" a given <type> <br>
//!           Then, gives the same fail cases as ReadEntity without Type, <br>
//!           plus the case "Incorrect Type" <br>
//!           (in such a case, returns False and givel <val> = Null) <br>
  Standard_EXPORT     Standard_Boolean ReadEntity(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,const Standard_CString mess,const Handle(Standard_Type)& type,Handle(IGESData_IGESEntity)& val,const Standard_Boolean canbenul = Standard_False) ;
  
  Standard_EXPORT     Standard_Boolean ReadInts(const IGESData_ParamCursor& PC,const Message_Msg& amsg,Handle(TColStd_HArray1OfInteger)& val,const Standard_Integer index = 1) ;
  //! Reads a list of Integer values, defined by PC (with a count of <br>
//!           parameters). PC can start from Current Number and command it <br>
//!           to advance after reading (use method CurrentList to do this) <br>
//!           The list is given as a HArray1, numered from "index" <br>
//!           If all params are not Integer, Check is filled (using mess) <br>
//!           and return value is False <br>
  Standard_EXPORT     Standard_Boolean ReadInts(const IGESData_ParamCursor& PC,const Standard_CString mess,Handle(TColStd_HArray1OfInteger)& val,const Standard_Integer index = 1) ;
  
  Standard_EXPORT     Standard_Boolean ReadReals(const IGESData_ParamCursor& PC,Message_Msg& amsg,Handle(TColStd_HArray1OfReal)& val,const Standard_Integer index = 1) ;
  //! Reads a list of Real values defined by PC <br>
//!           Same conditions as for ReadInts, for PC and index <br>
//!           An Integer parameter is accepted, if at least one parameter is <br>
//!           Integer, Check is filled with a "Warning" message <br>
//!           If all params are neither Real nor Integer, Check is filled <br>
//!           (using mess) and return value is False <br>
  Standard_EXPORT     Standard_Boolean ReadReals(const IGESData_ParamCursor& PC,const Standard_CString mess,Handle(TColStd_HArray1OfReal)& val,const Standard_Integer index = 1) ;
  
  Standard_EXPORT     Standard_Boolean ReadTexts(const IGESData_ParamCursor& PC,const Message_Msg& amsg,Handle(Interface_HArray1OfHAsciiString)& val,const Standard_Integer index = 1) ;
  //! Reads a list of Hollerith Texts, defined by PC <br>
//!           Texts are read as Hollerith texts without leading "nnnH" <br>
//!           Same conditions as for ReadInts, for PC and index <br>
//!           If all params are not Text, Check is filled (using mess) <br>
//!           and return value is False <br>
  Standard_EXPORT     Standard_Boolean ReadTexts(const IGESData_ParamCursor& PC,const Standard_CString mess,Handle(Interface_HArray1OfHAsciiString)& val,const Standard_Integer index = 1) ;
  
  Standard_EXPORT     Standard_Boolean ReadEnts(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,const Message_Msg& amsg,Handle(IGESData_HArray1OfIGESEntity)& val,const Standard_Integer index = 1) ;
  //! Reads a list of Entities defined by PC <br>
//!           Same conditions as for ReadInts, for PC and index <br>
//!           The list is given as a HArray1, numered from "index" <br>
//!           If all params cannot be read as Entities, Check is filled <br>
//!           (using mess) and return value is False <br>
//!           Remark : Null references are accepted, they are ignored <br>
//!             (negative pointers too : they provoke a Warning message) <br>
//!           If the caller wants to check them, a loop on ReadEntity should <br>
//!           be used <br>
  Standard_EXPORT     Standard_Boolean ReadEnts(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,const Standard_CString mess,Handle(IGESData_HArray1OfIGESEntity)& val,const Standard_Integer index = 1) ;
  
  Standard_EXPORT     Standard_Boolean ReadEntList(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,Message_Msg& amsg,Interface_EntityList& val,const Standard_Boolean ord = Standard_True) ;
  //! Reads a list of Entities defined by PC <br>
//!           Same conditions as for ReadEnts, for PC <br>
//!           The list is given as an EntityList <br>
//!            (index has no meaning; the EntityList starts from clear) <br>
//!           If "ord" is given True (default), entities will be added to <br>
//!           the list in their original order <br>
//!           Remark : Negative or Null Pointers are ignored <br>
//!           Else ("ord" False), order is not garanteed (faster mode) <br>
//!           If all params cannot be read as Entities, same as above <br>
//!  Warning  Give "ord" to False ONLY if order is not significant <br>
  Standard_EXPORT     Standard_Boolean ReadEntList(const Handle(IGESData_IGESReaderData)& IR,const IGESData_ParamCursor& PC,const Standard_CString mess,Interface_EntityList& val,const Standard_Boolean ord = Standard_True) ;
  
  Standard_EXPORT     Standard_Boolean ReadingReal(const Standard_Integer num,Standard_Real& val) ;
  //! Routine which reads a Real parameter, given its number <br>
//!           Same conditions as ReadReal for mess, val, and return value <br>
  Standard_EXPORT     Standard_Boolean ReadingReal(const Standard_Integer num,const Standard_CString mess,Standard_Real& val) ;
  
  Standard_EXPORT     Standard_Boolean ReadingEntityNumber(const Standard_Integer num,Standard_Integer& val) ;
  //! Routine which reads an Entity Number (which allows to read the <br>
//!           Entity in the IGESReaderData by BoundEntity), given its number <br>
//!           in the list of Parameters <br>
//!           Same conditions as ReadEntity for mess, val, and return value <br>
//!           In particular, returns True and val to zero means Null Entity, <br>
//!           and val not zero means Entity read by BoundEntity <br>
  Standard_EXPORT     Standard_Boolean ReadingEntityNumber(const Standard_Integer num,const Standard_CString mess,Standard_Integer& val) ;
  
  Standard_EXPORT     void SendFail(const Message_Msg& amsg) ;
  
  Standard_EXPORT     void SendWarning(const Message_Msg& amsg) ;
  
  Standard_EXPORT     void AddFail(const Standard_CString afail,const Standard_CString bfail = "") ;
  //! feeds the Check with a new fail (as a String or as a CString) <br>
  Standard_EXPORT     void AddFail(const Handle(TCollection_HAsciiString)& af,const Handle(TCollection_HAsciiString)& bf) ;
  
  Standard_EXPORT     void AddWarning(const Standard_CString awarn,const Standard_CString bwarn = "") ;
  //! feeds the Check with a new Warning message <br>
  Standard_EXPORT     void AddWarning(const Handle(TCollection_HAsciiString)& aw,const Handle(TCollection_HAsciiString)& bw) ;
  
  Standard_EXPORT     void Mend(const Standard_CString pref = "") ;
  //! says if fails have been recorded into the Check <br>
  Standard_EXPORT     Standard_Boolean HasFailed() const;
  //! returns the Check <br>
//!           Note that any error signaled above is also recorded into it <br>
  Standard_EXPORT    const Handle_Interface_Check& Check() const;
  //! returns the check in a way which allows to work on it directly <br>
//!         (i.e. messages added to the Check are added to ParamReader too) <br>
  Standard_EXPORT     Handle_Interface_Check& CCheck() ;
  //! Returns True if the Check is Empty <br>
//!           Else, it has to be recorded with the Read Entity <br>
  Standard_EXPORT     Standard_Boolean IsCheckEmpty() const;





protected:





private:

  
  Standard_EXPORT     Standard_Boolean PrepareRead(const IGESData_ParamCursor& PC,const Standard_Boolean several,const Standard_Integer size = 1) ;
  //! Prepares work for Read... methods which call it to begin <br>
//!           The required count of parameters must not overpass NbParams. <br>
//!           If several is given False, PC count must be one. <br>
//!           If size is given, the TermSize from ParmCursor must be a <br>
//!           multiple count of this size. <br>
//!           If one of above condition is not satisfied, a Fail Message is <br>
//!           recorded into Check, using the root "mess" and return is False <br>
  Standard_EXPORT     Standard_Boolean PrepareRead(const IGESData_ParamCursor& PC,const Standard_CString mess,const Standard_Boolean several,const Standard_Integer size = 1) ;
  //! Gets the first parameter number to be read, determined from <br>
//!           ParamCursor data read by PrepareRead (Start + Offset) <br>
//!           Then commands to skip 1 parameter (default) or nb if given <br>
  Standard_EXPORT     Standard_Integer FirstRead(const Standard_Integer nb = 1) ;
  //! Gets the next parameter number to be read. Skips to next Item <br>
//!           if TermSize has been read. <br>
//!           Then commands to skip 1 parameter (default) or nb if given <br>
  Standard_EXPORT     Standard_Integer NextRead(const Standard_Integer nb = 1) ;
  //! internal method which builds a Fail message from an <br>
//!           identification "idm" and a diagnostic ("afail") <br>
//!           Also feeds LastReadStatus <br>
//!           <af> for final message, bf (can be different) for original <br>
  Standard_EXPORT     void AddFail(const Standard_CString idm,const Handle(TCollection_HAsciiString)& af,const Handle(TCollection_HAsciiString)& bf) ;
  //! Same as above but with CString <br>
//!           <bf> empty means = <af> <br>
  Standard_EXPORT     void AddFail(const Standard_CString idm,const Standard_CString afail,const Standard_CString bfail) ;
  //! internal method which builds a Warning message from an <br>
//!           identification "idm" and a diagnostic <br>
//!           <aw> is final message, bw is original (can be different) <br>
//!           Also feeds LastReadStatus <br>
  Standard_EXPORT     void AddWarning(const Standard_CString idm,const Handle(TCollection_HAsciiString)& aw,const Handle(TCollection_HAsciiString)& bw) ;
  //! Same as above but with CString <br>
//!           <bw> empty means = <aw> <br>
  Standard_EXPORT     void AddWarning(const Standard_CString idm,const Standard_CString aw,const Standard_CString bw) ;


Handle_Interface_ParamList theparams;
Handle_Interface_Check thecheck;
Standard_Integer thebase;
Standard_Integer thenbpar;
Standard_Integer thecurr;
IGESData_ReadStage thestage;
Standard_Boolean thelast;
Standard_Integer theindex;
Standard_Integer thenbitem;
Standard_Integer theitemsz;
Standard_Integer theoffset;
Standard_Integer thetermsz;
Standard_Integer themaxind;
Standard_Integer thenbterm;
Standard_Integer pbrealint;
Standard_Integer pbrealform;
Standard_Integer thenum;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
