// Copyright (c) 1999-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.


#include <RWStepGeom_RWPolyline.ixx>
#include <StepGeom_HArray1OfCartesianPoint.hxx>
#include <StepGeom_CartesianPoint.hxx>


#include <Interface_EntityIterator.hxx>


#include <StepGeom_Polyline.hxx>


RWStepGeom_RWPolyline::RWStepGeom_RWPolyline () {}

void RWStepGeom_RWPolyline::ReadStep
	(const Handle(StepData_StepReaderData)& data,
	 const Standard_Integer num,
	 Handle(Interface_Check)& ach,
	 const Handle(StepGeom_Polyline)& ent) const
{


	// --- Number of Parameter Control ---

	if (!data->CheckNbParams(num,2,ach,"polyline")) return;

	// --- inherited field : name ---

	Handle(TCollection_HAsciiString) aName;
	//szv#4:S4163:12Mar99 `Standard_Boolean stat1 =` not needed
	data->ReadString (num,1,"name",ach,aName);

	// --- own field : points ---

	Handle(StepGeom_HArray1OfCartesianPoint) aPoints;
	Handle(StepGeom_CartesianPoint) anent2;
	Standard_Integer nsub2;
	if (data->ReadSubList (num,2,"points",ach,nsub2)) {
	  Standard_Integer nb2 = data->NbParams(nsub2);
	  aPoints = new StepGeom_HArray1OfCartesianPoint (1, nb2);
	  for (Standard_Integer i2 = 1; i2 <= nb2; i2 ++) {
	    //szv#4:S4163:12Mar99 `Standard_Boolean stat2 =` not needed
	    if (data->ReadEntity (nsub2, i2,"cartesian_point", ach,
				  STANDARD_TYPE(StepGeom_CartesianPoint), anent2))
	      aPoints->SetValue(i2, anent2);
	  }
	}

	//--- Initialisation of the read entity ---


	ent->Init(aName, aPoints);
}


void RWStepGeom_RWPolyline::WriteStep
	(StepData_StepWriter& SW,
	 const Handle(StepGeom_Polyline)& ent) const
{

	// --- inherited field name ---

	SW.Send(ent->Name());

	// --- own field : points ---

	SW.OpenSub();
	for (Standard_Integer i2 = 1;  i2 <= ent->NbPoints();  i2 ++) {
	  SW.Send(ent->PointsValue(i2));
	}
	SW.CloseSub();
}


void RWStepGeom_RWPolyline::Share(const Handle(StepGeom_Polyline)& ent, Interface_EntityIterator& iter) const
{

	Standard_Integer nbElem1 = ent->NbPoints();
	for (Standard_Integer is1=1; is1<=nbElem1; is1 ++) {
	  iter.GetOneItem(ent->PointsValue(is1));
	}

}

