// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2dGcc_Circ2dTanCen_HeaderFile
#define _Geom2dGcc_Circ2dTanCen_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColgp_Array1OfCirc2d_HeaderFile
#include <TColgp_Array1OfCirc2d.hxx>
#endif
#ifndef _GccEnt_Array1OfPosition_HeaderFile
#include <GccEnt_Array1OfPosition.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Handle_Geom2d_Point_HeaderFile
#include <Handle_Geom2d_Point.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
class Standard_OutOfRange;
class GccEnt_BadQualifier;
class StdFail_NotDone;
class Geom2dGcc_QualifiedCurve;
class Geom2d_Point;
class gp_Circ2d;
class gp_Pnt2d;


//! This class implements the algorithms used to <br>
//!          create 2d circles tangent to a curve and <br>
//!          centered on a point. <br>
//!          The arguments of all construction methods are : <br>
//!             - The qualified element for the tangency constrains <br>
//!             (QualifiedCurv). <br>
//!             -The center point Pcenter. <br>
//!             - A real Tolerance. <br>
//!          Tolerance is only used in the limits cases. <br>
//!          For example : <br>
//!          We want to create a circle tangent to an EnclosedCurv C1 <br>
//!          with a tolerance Tolerance. <br>
//!          If we did not used Tolerance it is impossible to <br>
//!          find a solution in the the following case : Pcenter is <br>
//!          outside C1. <br>
//!          With Tolerance we will give a solution if the distance <br>
//!          between C1 and Pcenter is lower than or equal Tolerance/2. <br>
class Geom2dGcc_Circ2dTanCen  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Constructs one or more 2D circles tangential to the <br>
//! curve Qualified1 and centered on the point Pcenter. <br>
//! Tolerance is a tolerance criterion used by the algorithm <br>
//! to find a solution when, mathematically, the problem <br>
//! posed does not have a solution, but where there is <br>
//! numeric uncertainty attached to the arguments. <br>
//! Tolerance is only used in these algorithms in very <br>
//! specific cases where the center of the solution is very <br>
//! close to the circle to which it is tangential, and where the <br>
//! solution is thus a very small circle. <br>
//! Exceptions <br>
//! GccEnt_BadQualifier if a qualifier is inconsistent with <br>
//! the argument it qualifies (for example, enclosing for a line). <br>
  Standard_EXPORT   Geom2dGcc_Circ2dTanCen(const Geom2dGcc_QualifiedCurve& Qualified1,const Handle(Geom2d_Point)& Pcenter,const Standard_Real Tolerance);
  //! Returns true if the construction algorithm does not fail <br>
//! (even if it finds no solution). <br>
//! Note: IsDone protects against a failure arising from a <br>
//! more internal intersection algorithm, which has reached <br>
//! its numeric limits. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! Returns the number of circles, representing solutions <br>
//! computed by this algorithm. <br>
//! Exceptions <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     Standard_Integer NbSolutions() const;
  //! Returns a circle, representing the solution of index <br>
//! Index computed by this algorithm. <br>
//! Warning <br>
//! This indexing simply provides a means of consulting the <br>
//! solutions. The index values are not associated with <br>
//! these solutions outside the context of the algorithm object. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails <br>
  Standard_EXPORT     gp_Circ2d ThisSolution(const Standard_Integer Index) const;
  //! Returns the qualifier Qualif1 of the tangency argument <br>
//! for the solution of index Index computed by this algorithm. <br>
//! The returned qualifier is: <br>
//! -   that specified at the start of construction when the <br>
//!   solutions are defined as enclosed, enclosing or <br>
//!   outside with respect to the argument, or <br>
//! -   that computed during construction (i.e. enclosed, <br>
//!   enclosing or outside) when the solutions are defined <br>
//!   as unqualified with respect to the argument. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     void WhichQualifier(const Standard_Integer Index,GccEnt_Position& Qualif1) const;
  //!  Returns informations about the tangency point between the <br>
//! result number Index and the first argument. <br>
//! ParSol is the intrinsic parameter of the point PntSol on the solution curv. <br>
//! ParArg is the intrinsic parameter of the point PntSol on the argument curv. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     void Tangency1(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns true if the solution of index Index and the first <br>
//! argument of this algorithm are the same (i.e. there are 2 <br>
//! identical circles). <br>
//! If Rarg is the radius of the first argument, Rsol is the <br>
//! radius of the solution and dist is the distance between <br>
//! the two centers, we consider the two circles to be <br>
//! identical if |Rarg - Rsol| and dist are less than <br>
//! or equal to the tolerance criterion given at the time of <br>
//! construction of this algorithm. <br>
//!          NotDone is raised if the construction algorithm didn't succeed. <br>
//!          OutOfRange is raised if Index is greater than the <br>
//!          number of solutions. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame1(const Standard_Integer Index) const;





protected:





private:



Standard_Boolean WellDone;
Standard_Integer NbrSol;
TColgp_Array1OfCirc2d cirsol;
GccEnt_Array1OfPosition qualifier1;
TColStd_Array1OfInteger TheSame1;
TColgp_Array1OfPnt2d pnttg1sol;
TColStd_Array1OfReal par1sol;
TColStd_Array1OfReal pararg1;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
