// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Graphic2d_HidingGraphicObject_HeaderFile
#define _Graphic2d_HidingGraphicObject_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Graphic2d_HidingGraphicObject_HeaderFile
#include <Handle_Graphic2d_HidingGraphicObject.hxx>
#endif

#ifndef _Handle_Graphic2d_HArray1OfVertex_HeaderFile
#include <Handle_Graphic2d_HArray1OfVertex.hxx>
#endif
#ifndef _Graphic2d_TypeOfFrame_HeaderFile
#include <Graphic2d_TypeOfFrame.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Graphic2d_GraphicObject_HeaderFile
#include <Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Handle_Graphic2d_View_HeaderFile
#include <Handle_Graphic2d_View.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Handle_Graphic2d_Primitive_HeaderFile
#include <Handle_Graphic2d_Primitive.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Graphic2d_HArray1OfVertex;
class Standard_OutOfRange;
class Graphic2d_View;
class Graphic2d_Array1OfVertex;
class Graphic2d_Drawer;
class Graphic2d_Primitive;
class gp_GTrsf2d;


//! Creates a 2D hiding graphic object in a view. <br>
//!	    A graphic object is a primitives manager <br>
//!	    which hide the others graphic objects <br>
class Graphic2d_HidingGraphicObject : public Graphic2d_GraphicObject {

public:

  //! Creates an hiding polygon object in the view <aView> <br>
//!	    This graphic object manages a sequence of primitives. <br>
//!  <aFrame> describes the hiding polygon geometry <br>
//!  The frame is created with the default attributes : <br>
//!  * the hiding color index : 0 (the same as the view) <br>
//!  * the frame color index : 1 <br>
//!  * the frame line type index : 0 <br>
//!  * the frame line thickness index : 0 <br>
//!  * the graphic object is : <br>
//!	    - empty. <br>
//!	    - plottable. <br>
//!	    - drawable. <br>
//!	    - pickable. <br>
//!	    - not displayed. <br>
//!	    - not highlighted. <br>
//!	    - has a relative drawing priority of 0 <br>
  Standard_EXPORT   Graphic2d_HidingGraphicObject(const Handle(Graphic2d_View)& aView,const Graphic2d_Array1OfVertex& aFrame);
  //! Creates an hiding predefined object in the view <aView>. <br>
//!	    the predefined TypeOfFrame must be one of : <br>
//!	    TOF_RECTANGULAR,TOF_CIRCULAR. <br>
//!	    the frame position and geometry is computed <br>
//!	    automaticaly according to the contents of the <br>
//!	    graphic object and the <aMargin1>,<aMargin2> parameter. <br>
//!	    A graphic object manages a sequence of primitives. <br>
//!  Warning: The type of frame can be UNKNOWN,in this case the frame is <br>
//!	   not drawn. <br>
  Standard_EXPORT   Graphic2d_HidingGraphicObject(const Handle(Graphic2d_View)& aView,const Graphic2d_TypeOfFrame aType = Graphic2d_TOF_RECTANGULAR,const Quantity_Length aMargin1 = 0.0,const Quantity_Length aMargin2 = 0.0);
  //! Updates the frame geometry. <br>
  Standard_EXPORT     void SetFrame(const Graphic2d_Array1OfVertex& aFrame) ;
  //! Updates & computes the frame geometry <br>
//!	    automaticaly according to the contents of the <br>
//!	    graphic object and the <aMargin> parameter. <br>
//!  Warning: The type of frame can be UNKNOWN,in this case the frame is <br>
//!	   not drawn. <br>
  Standard_EXPORT     void SetFrame(const Graphic2d_TypeOfFrame aFrameType,const Quantity_Length aMargin1 = 0.0,const Quantity_Length aMargin2 = 0.0) ;
  //! Updates the hiding color index of the background polygon. <br>
  Standard_EXPORT     void SetHidingColorIndex(const Standard_Integer anIndex = 0) ;
  //! Updates the frame color index of the polygon. <br>
  Standard_EXPORT     void SetFrameColorIndex(const Standard_Integer anIndex = 1) ;
  //! Updates the frame line type index of the polygon. <br>
  Standard_EXPORT     void SetFrameTypeIndex(const Standard_Integer anIndex = 0) ;
  //! Updates the frame line thickness index of the polygon. <br>
  Standard_EXPORT     void SetFrameWidthIndex(const Standard_Integer anIndex = 0) ;
  //! Returns the max usable relative priority of the <br>
//!         "hiding" graphic object. <br>
  Standard_EXPORT   virtual  Standard_Integer MaxPriority() const;
  //! Returns the min max values of the frame of <me>. <br>
//!  Warning: If <me> is empty <br>
//!	    returns FALSE <br>
//!          and Minx = Miny = RealFirst () <br>
//!              Maxx = Maxy = RealLast () <br>
  Standard_EXPORT     Standard_Boolean FrameMinMax(Quantity_Length& Minx,Quantity_Length& Maxx,Quantity_Length& Miny,Quantity_Length& Maxy) const;
  //! Returns the min max values of <me> including <br>
//!	the frame and primitives inside. <br>
//!  Warning: If <me> is empty or not displayed <br>
//!	    returns FALSE <br>
//!          and     Minx = Miny = RealFirst () <br>
//!                  Maxx = Maxy = RealLast () <br>
  Standard_EXPORT   virtual  Standard_Boolean MinMax(Quantity_Length& Minx,Quantity_Length& Maxx,Quantity_Length& Miny,Quantity_Length& Maxy) const;
  //! Returns the frame geometry and type of <br>
//!   the hiding graphic object. <br>
//!  Warning: the frame can be NULL. <br>
  Standard_EXPORT     Graphic2d_TypeOfFrame Frame(Graphic2d_Array1OfVertex& aFrame) const;
  //! Returns the hiding color index. <br>
  Standard_EXPORT     Standard_Integer HidingColorIndex() const;
  //! Returns the frame color index. <br>
  Standard_EXPORT     Standard_Integer FrameColorIndex() const;
  //! Returns the frame line type index. <br>
  Standard_EXPORT     Standard_Integer FrameTypeIndex() const;
  //! Returns the frame line thickness index. <br>
  Standard_EXPORT     Standard_Integer FrameWidthIndex() const;


friend class Graphic2d_View;


  DEFINE_STANDARD_RTTI(Graphic2d_HidingGraphicObject)

protected:




private: 

  //! Drawn the last Undrawn primitives managed by the <br>
//!          graphic object <me> in the drawer <aDrawer>. <br>
  Standard_EXPORT   virtual  void Draw(const Handle(Graphic2d_Drawer)& aDrawer,const Standard_Boolean Reset) ;
  //! Drawn a primitive managed by the <br>
//!	    graphic object <me> in the drawer <aDrawer>. <br>
//!	    Called by the method Graphic2d_View::Update (aPrimitive) <br>
  Standard_EXPORT   virtual  void Draw(const Handle(Graphic2d_Drawer)& aDrawer,const Handle(Graphic2d_Primitive)& aPrimitive) ;
  //! Returns Standard_True if the graphic object <me> <br>
//!          is picked, Standard_False if not. <br>
//!          Called by the method Graphic2d_View::Pick <br>
  Standard_EXPORT   virtual  Standard_Boolean Pick(const Standard_Real X,const Standard_Real Y,const Standard_Real aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;
  //! Returns the min usable absolute priority of the <br>
//!         "hiding" graphic object. <br>
  Standard_EXPORT   virtual  Standard_Integer BasePriority() const;
  //! Returns the transformed min max values of the frame <me>. <br>
  Standard_EXPORT     void TransformMinMax(const gp_GTrsf2d& aTrsf,Standard_Real& Minx,Standard_Real& Maxx,Standard_Real& Miny,Standard_Real& Maxy) const;

Handle_Graphic2d_HArray1OfVertex myFrame;
Graphic2d_TypeOfFrame myTypeOfFrame;
Standard_Integer myHidingColorIndex;
Standard_Integer myFrameColorIndex;
Standard_Integer myFrameTypeIndex;
Standard_Integer myFrameWidthIndex;
Quantity_Length myFrameMargin1;
Quantity_Length myFrameMargin2;
Quantity_Length myXmin;
Quantity_Length myYmin;
Quantity_Length myXmax;
Quantity_Length myYmax;
Standard_Boolean myIsComputed;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
