// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Standard_ErrorHandler_HeaderFile
#define _Standard_ErrorHandler_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_PErrorHandler_HeaderFile
#include <Standard_PErrorHandler.hxx>
#endif
#ifndef _Handle_Standard_Failure_HeaderFile
#include <Handle_Standard_Failure.hxx>
#endif
#ifndef _Standard_JmpBuf_HeaderFile
#include <Standard_JmpBuf.hxx>
#endif
#ifndef _Standard_HandlerStatus_HeaderFile
#include <Standard_HandlerStatus.hxx>
#endif
#ifndef _Standard_ThreadId_HeaderFile
#include <Standard_ThreadId.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
class Standard_Failure;
class Standard_ErrorHandlerCallback;
class Standard_Type;



class Standard_ErrorHandler  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Create a ErrorHandler (to be used with try{}catch(){}). <br>
//!           It uses the "setjmp" and "longjmp" routines. <br>
  Standard_EXPORT   Standard_ErrorHandler();
  //! Unlinks and checks if there is a raised exception. <br>
  Standard_EXPORT     void Destroy() ;
~Standard_ErrorHandler()
{
  Destroy();
}
  //! Removes handler from the handlers list <br>
  Standard_EXPORT     void Unlink() ;
  //! Returns "True" if the caught exception has the same type <br>
//!          or inherits from "aType" <br>
  Standard_EXPORT     Standard_Boolean Catches(const Handle(Standard_Type)& aType) ;
  //! Returns label for jump <br>
        Standard_JmpBuf& Label() ;
  //! Returns the current Error. <br>
  Standard_EXPORT     Handle_Standard_Failure Error() const;
  //! Returns the caught exception. <br>
//! <br>
  Standard_EXPORT   static  Handle_Standard_Failure LastCaughtError() ;
  //! Test if the code is currently running in a try block <br>
  Standard_EXPORT   static  Standard_Boolean IsInTryBlock() ;


friend class Standard_Failure;
friend class Standard_ErrorHandlerCallback;



protected:





private:

  //! A exception is raised but it is not yet caught. <br>
//!          So Abort the current function and transmit the exception <br>
//!          to "calling routines". <br>
//! Warning: If no catch is prepared for this exception, it displays the <br>
//!          exception name and calls "exit(1)". <br>
  Standard_EXPORT   static  void Abort() ;
  //! Set the Error which will be transmitted to "calling routines". <br>
  Standard_EXPORT   static  void Error(const Handle(Standard_Failure)& aError) ;
  //! Returns the current handler (Top in former implemntations) <br>
  Standard_EXPORT   static  Standard_PErrorHandler FindHandler(const Standard_HandlerStatus theStatus,const Standard_Boolean theUnlink) ;


Standard_PErrorHandler myPrevious;
Handle_Standard_Failure myCaughtError;
Standard_JmpBuf myLabel;
Standard_HandlerStatus myStatus;
Standard_ThreadId myThread;
Standard_Address myCallbackPtr;


};


#include <Standard_ErrorHandler.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
