/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Variables that are needed globally, and even by the very basic libs.
 *
 * revision history: (please note changes here)
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#include "config.h"
#include "types.h"
#include "console.h"

void (*_vga13)(void);
void (*_plSetTextMode)(unsigned char size)=0;
void (*_plSetBarFont)(void);

void (*_displaystr)(unsigned short y, unsigned short x, unsigned char attr, const char *str, unsigned short len);
void (*_displaystrattr)(unsigned short y, unsigned short x, const unsigned short *buf, unsigned short len);
void (*_displaystrattrdi)(unsigned short y, unsigned short x, const char *txt, const char *attr, unsigned short len);
void (*_displayvoid)(unsigned short y, unsigned short x, unsigned short len);

int (*_plSetGraphMode)(int); /* -1 reset, 0 640x480 1 1024x768 */
int  (*_plSetGraphPage)(unsigned char x);
void (*_gdrawchar)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b);
void (*_gdrawchart)(unsigned short x, unsigned short y, unsigned char c, unsigned char f);
void (*_gdrawcharp)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp);
void (*_gdrawchar8)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b);
void (*_gdrawchar8t)(unsigned short x, unsigned short y, unsigned char c, unsigned char f);
void (*_gdrawchar8p)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp);
void (*_gdrawstr)(unsigned short y, unsigned short x, const char *s, unsigned short len, unsigned char f, unsigned char b);
void (*_gupdatestr)(unsigned short y, unsigned short x, const uint16_t *str, unsigned short len, uint16_t *old);
void (*_gupdatepal)(unsigned char color, unsigned char red, unsigned char green, unsigned char blue);
void (*_gflushpal)(void);

int (*_ekbhit)(void);
int (*_egetch)(void);

void (*_drawbar)(unsigned short x, unsigned short yb, unsigned short yh, unsigned long hgt, unsigned long c);
void (*_idrawbar)(unsigned short x, unsigned short yb, unsigned short yh, unsigned long hgt, unsigned long c);


void (*_Screenshot)(void);
void (*_TextScreenshot)(int scrType);

void (*_setcur)(unsigned char y, unsigned char x) ;
void (*_setcurshape)(unsigned short shape);

int (*_conRestore)(void);
void (*_conSave)(void);

void (*_plDosShell)(void);

int plScreenChanged;
short plScrHeight;
short plScrWidth;
char plVidType;
unsigned char plScrType;
unsigned short plScrRowBytes;
int plScrMode;
int plActualMode;
char *plVidMem;                  /* usually 0xA0000 on banked modes */
int plLFB;                       /* 0 or !0 */

