/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * WAVPlay - wave file player
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb980717   Tammo Hinrichs <kb@nwn.de>
 *    -added a few lines in idle routine to make win95 background
 *     playing possible
 */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include "types.h"
#include "dev/player.h"
#include "dev/plrasm.h"
#include "wave.h"
#include "dev/deviplay.h"
#include "dev/mixclip.h"
#include "stuff/imsrtns.h"
#include "stuff/poll.h"

static unsigned char stereo;
static unsigned char bit16;
static unsigned char signedout;
static unsigned long samprate;
static unsigned char reversestereo;

static unsigned short *buf16;
static unsigned long bufpos;
static uint32_t buflen;
static void *plrbuf;

static unsigned short *cliptabl;
static unsigned short *cliptabr;
static unsigned long amplify;
static unsigned long voll,volr;
static int pan;
static char convtostereo;

/*
static binfile *wavefile;
static abinfile rawwave;
*/
static FILE *wavefile;
#define rawwave wavefile


static char wavestereo;
static char wave16bit;
static unsigned long waverate;
static unsigned long wavepos;
static unsigned long wavelen;
static unsigned long waveoffs;
static unsigned char *wavebuf;
static unsigned long wavebuflen;
static unsigned long wavebufpos;
static unsigned long wavebuffpos;
static unsigned long wavebufread;
static unsigned long wavebufrate;
static char active;
static char looped;
static char donotloop;
static unsigned long bufloopat;

static char pause;

static int clipbusy=0;

static void calccliptab(signed long ampl, signed long ampr)
{
	int i;

	clipbusy++;

	if (!stereo)
	{
		ampl=(abs(ampl)+abs(ampr))>>1;
		ampr=0;
	}

	mixCalcClipTab(cliptabl, abs(ampl));
	mixCalcClipTab(cliptabr, abs(ampr));

	if (signedout)
		for (i=0; i<256; i++)
		{
			cliptabl[i+512]^=0x8000;
			cliptabr[i+512]^=0x8000;
		}

	clipbusy--;
}

#define PANPROC \
do { \
	if(pan==-64 || reversestereo) \
	{ \
		signed long t=ls; \
		ls=rs; \
		rs=t; \
	} else if(pan==64) \
		; /*do nothing */ \
	else if(pan==0) \
		rs=ls=(rs+ls)/2; \
	else if(pan<0) \
	{ \
		float l=(float)ls / (-pan/-64.0+2.0) + (float)rs*(64.0+pan)/128.0; \
		float r=(float)rs / (-pan/-64.0+2.0) + (float)ls*(64.0+pan)/128.0; \
		ls=r; \
		rs=l; \
	} else if(pan<64) \
	{ \
		float l=(float)ls / (pan/-64.0+2.0) + (float)rs*(64.0-pan)/128.0; \
		float r=(float)rs / (pan/-64.0+2.0) + (float)ls*(64.0-pan)/128.0; \
		ls=l; \
		rs=r; \
	} \
} while(0)


static void timerproc(void)
{
	unsigned long bufplayed;
	unsigned long bufdelta;
	unsigned long pass2;
	int quietlen;
	int toloop;

	if (clipbusy++)
	{
		clipbusy--;
		return;
	}
	
	bufplayed=plrGetBufPos()>>(stereo+bit16);
	if (bufplayed==bufpos)
	{
		clipbusy--;
		if (plrIdle)
			plrIdle();
		return;
	}
	wpIdle();
	
	quietlen=0;
	bufdelta=(buflen+bufplayed-bufpos)%buflen;
	if (wavebuflen!=wavelen)
	{
		int towrap=imuldiv((((wavebuflen+wavebufread-wavebufpos-1)%wavebuflen)>>(wavestereo+wave16bit)), 65536, wavebufrate);
		if (bufdelta>towrap)
			quietlen=bufdelta-towrap;
	}

	if (pause)
		quietlen=bufdelta;

	toloop=imuldiv(((bufloopat-wavebufpos)>>(wave16bit+wavestereo)), 65536, wavebufrate);
	if (looped)
		toloop=0;

	bufdelta-=quietlen;

	if (bufdelta>=toloop)
	{
		looped=1;
		if (donotloop)
		{
			quietlen+=bufdelta-toloop;
			bufdelta=toloop;
		}
	}

	if (bufdelta)
	{
		int i;
		if ((bufpos+bufdelta)>buflen)
			pass2=bufpos+bufdelta-buflen;
		else
			pass2=0;
		plrClearBuf(buf16, bufdelta*2, 1);

		if (wave16bit)
		{
			if (wavestereo)
			{
				signed long wpm1, wp1, wp2, c0, c1, c2, c3, ls, rs, vm1,v1,v2;
				for (i=0; i<bufdelta; i++)
				{

					wpm1=wavebufpos-4; if (wpm1<0) wpm1+=wavebuflen;
					wp1=wavebufpos+4; if (wp1>=wavebuflen) wp1-=wavebuflen;
					wp2=wavebufpos+8; if (wp2>=wavebuflen) wp2-=wavebuflen;

					/* interpolation ? */
					c0 = *(unsigned short*)(wavebuf+wavebufpos)^0x8000;
					vm1= *(unsigned short*)(wavebuf+wpm1)^0x8000;
					v1 = *(unsigned short*)(wavebuf+wp1)^0x8000;
					v2 = *(unsigned short*)(wavebuf+wp2)^0x8000;
					c1 = v1-vm1;
					c2 = 2*vm1-2*c0+v1-v2;
					c3 = c0-vm1-v1+v2;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c2;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c1;
					c3 =  imulshr16(c3,wavebuffpos);
					ls = c3+c0;

					c0 = *(unsigned short*)(wavebuf+wavebufpos+2)^0x8000;
					vm1= *(unsigned short*)(wavebuf+wpm1+2)^0x8000;
					v1 = *(unsigned short*)(wavebuf+wp1+2)^0x8000;
					v2 = *(unsigned short*)(wavebuf+wp2+2)^0x8000;
					c1 = v1-vm1;
					c2 = 2*vm1-2*c0+v1-v2;
					c3 = c0-vm1-v1+v2;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c2;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c1;
					c3 =  imulshr16(c3,wavebuffpos);
					rs = c3+c0;

					PANPROC;
					buf16[2*i]=(unsigned short)ls;
					buf16[2*i+1]=(unsigned short)rs;

					wavebuffpos+=wavebufrate;
					wavebufpos+=(wavebuffpos>>16)*4;
					wavebuffpos&=0xFFFF;
					if (wavebufpos>=wavebuflen)
						wavebufpos-=wavebuflen;
				}
			} else { /* wavestereo */
				signed long wpm1, wp1, wp2, c0, c1, c2, c3, vm1,v1,v2;
				for (i=0; i<bufdelta; i++)
				{

					wpm1=wavebufpos-2; if (wpm1<0) wpm1+=wavebuflen;
					wp1=wavebufpos+2; if (wp1>=wavebuflen) wp1-=wavebuflen;
					wp2=wavebufpos+4; if (wp2>=wavebuflen) wp2-=wavebuflen;

					c0 = *(unsigned short*)(wavebuf+wavebufpos)^0x8000;
					vm1= *(unsigned short*)(wavebuf+wpm1)^0x8000;
					v1 = *(unsigned short*)(wavebuf+wp1)^0x8000;
					v2 = *(unsigned short*)(wavebuf+wp2)^0x8000;
					c1 = v1-vm1;
					c2 = 2*vm1-2*c0+v1-v2;
					c3 = c0-vm1-v1+v2;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c2;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c1;
					c3 =  imulshr16(c3,wavebuffpos);
					c3 += c0;

					buf16[2*i]=buf16[2*i+1]=(unsigned short)c3;

					wavebuffpos+=wavebufrate;
					wavebufpos+=(wavebuffpos>>16)*2;
					wavebuffpos&=0xFFFF;
					if (wavebufpos>=wavebuflen)
						wavebufpos-=wavebuflen;
				}
			}
		} else { /* wave16bit */
			if (wavestereo)
				for (i=0; i<bufdelta; i++)
				{
					signed long ls=wavebuf[wavebufpos]<<8;
					signed long rs=wavebuf[wavebufpos+1]<<8;

					PANPROC;
					buf16[2*i]=(unsigned short)ls;
					buf16[2*i+1]=(unsigned short)rs;

					wavebuffpos+=wavebufrate;
					wavebufpos+=(wavebuffpos>>16)*2;
					wavebuffpos&=0xFFFF;
					if (wavebufpos>=wavebuflen)
						wavebufpos-=wavebuflen;
				} else /* wavestereo */
					for (i=0; i<bufdelta; i++)
					{
						buf16[2*i+1]=buf16[2*i]=wavebuf[wavebufpos]<<8;
						wavebuffpos+=wavebufrate;
						wavebufpos+=wavebuffpos>>16;
						wavebuffpos&=0xFFFF;
						if (wavebufpos>=wavebuflen)
							wavebufpos-=wavebuflen;
					}
		}

		if (!stereo)
		{
			for (i=0; i<bufdelta; i++)
				buf16[i]=(buf16[2*i]+buf16[2*i+1])>>1;
		}

		if (bit16)
		{
			if (stereo)
			{
				mixClipAlt2((unsigned short*)plrbuf+bufpos*2, buf16, bufdelta-pass2, cliptabl);
				mixClipAlt2((unsigned short*)plrbuf+bufpos*2+1, buf16+1, bufdelta-pass2, cliptabr);
				if (pass2)
				{
					mixClipAlt2((unsigned short*)plrbuf, buf16+2*(bufdelta-pass2), pass2, cliptabl);
					mixClipAlt2((unsigned short*)plrbuf+1, buf16+2*(bufdelta-pass2)+1, pass2, cliptabr);
				}
			} else {
				mixClipAlt((unsigned short*)plrbuf+bufpos, buf16, bufdelta-pass2, cliptabl);
				if (pass2)
					mixClipAlt((unsigned short*)plrbuf, buf16+bufdelta-pass2, pass2, cliptabl);
			}
		} else {
			if (stereo)
			{
				mixClipAlt2(buf16, buf16, bufdelta, cliptabl);
				mixClipAlt2(buf16+1, buf16+1, bufdelta, cliptabr);
			} else
				mixClipAlt(buf16, buf16, bufdelta, cliptabl);
			plr16to8((unsigned char*)plrbuf+(bufpos<<stereo), buf16, (bufdelta-pass2)<<stereo);
			if (pass2)
				plr16to8((unsigned char*)plrbuf, buf16+((bufdelta-pass2)<<stereo), pass2<<stereo);
		}
		bufpos+=bufdelta;
		if (bufpos>=buflen)
			bufpos-=buflen;
	}

	bufdelta=quietlen;
	if (bufdelta)
	{
		if ((bufpos+bufdelta)>buflen)
			pass2=bufpos+bufdelta-buflen;
		else
			pass2=0;
		if (bit16)
		{
			plrClearBuf((unsigned short*)plrbuf+(bufpos<<stereo), (bufdelta-pass2)<<stereo, !signedout);
			if (pass2)
				plrClearBuf((unsigned short*)plrbuf, pass2<<stereo, !signedout);
		} else {
			plrClearBuf(buf16, bufdelta<<stereo, !signedout);
			plr16to8((unsigned char*)plrbuf+(bufpos<<stereo), buf16, (bufdelta-pass2)<<stereo);
			if (pass2)
				plr16to8((unsigned char*)plrbuf, buf16+((bufdelta-pass2)<<stereo), pass2<<stereo);
		}
		bufpos+=bufdelta;
		if (bufpos>=buflen)
			bufpos-=buflen;
	}
	
	plrAdvanceTo(bufpos<<(stereo+bit16));
	
	if (plrIdle)
		plrIdle();

	clipbusy--;
}

void wpIdle(void)
{
	unsigned long bufplayed=plrGetBufPos()>>(stereo+bit16);
	unsigned long bufdelta=(buflen+bufplayed-bufpos)%buflen;
	unsigned long clean;
	if (bufdelta>(buflen>>3))
		timerproc();

	if ((wavelen==wavebuflen)||!active)
		return;

	clean=(wavebufpos+wavebuflen-wavebufread)%wavebuflen;
	if (clean*8>wavebuflen)
	{
		while (clean)
		{
			int read=clean;
			int result;

			fseek(rawwave, wavepos+waveoffs, SEEK_SET);
			if ((wavebufread+read)>wavebuflen)
				read=wavebuflen-wavebufread;
			if ((wavepos+read)>=wavelen)
			{
				read=wavelen-wavepos;
				bufloopat=wavebufread+read;
			}
			if (read>0x10000)
				read=0x10000;
			result=fread(wavebuf+wavebufread, 1, read, rawwave);
			if (result<=0)
				break;
			wavebufread=(wavebufread+result)%wavebuflen;
			wavepos=(wavepos+result)%wavelen;
			clean-=result;
		}
	}
}

unsigned char wpOpenPlayer(FILE *wav, int tostereo, int tolerance)
{
	unsigned int temp;
	int fmtlen;
	unsigned short sh;

	int res;
	
	if (!plrPlay)
		return 0;

	convtostereo=tostereo;

	if (!(cliptabl=malloc(sizeof(unsigned short)*1793)))
	{
		return 0;
	}
	if (!(cliptabr=malloc(sizeof(unsigned short)*1793)))
	{
		free(cliptabl);
		cliptabl=NULL;
		return 0;
	}

	wavefile=wav;
	fseek(wavefile, 0, SEEK_SET);

	fread(&temp, sizeof(temp), 1, wavefile);
	if (temp!=0x46464952)
		return 0;

	fread(&temp, sizeof(temp), 1, wavefile);

	fread(&temp, sizeof(temp), 1, wavefile);
	if (temp!=0x45564157)
		return 0;

	while (1)
	{
		fread(&temp, sizeof(temp), 1, wavefile);
		if (temp==0x20746D66)
			break;
		if(feof(wavefile))
			return 0;
		fread(&temp, sizeof(temp), 1, wavefile);
		fseek(wavefile, temp, SEEK_CUR);
	}
	res=fread(&fmtlen, sizeof(fmtlen), 1, wavefile);
	if (fmtlen<16)
		return 0;
	res=fread(&sh, sizeof(sh), 1, wavefile);
	if ((sh!=1))
		return 0;

	fread(&sh, sizeof(sh), 1, wavefile);
	wavestereo=(sh==2);

	fread(&waverate, sizeof(waverate), 1, wavefile);
	fread(&temp, sizeof(temp), 1, wavefile);
	fread(&sh, sizeof(sh), 1, wavefile);
	
	fread(&sh, sizeof(sh), 1, wavefile);
	wave16bit=(sh==16);
	fseek(wavefile, fmtlen-16, SEEK_CUR);

	while (1)
	{
		fread(&temp, sizeof(temp), 1, wavefile);
		if (temp==0x61746164)
			break;
		if(feof(wavefile))
			return 0;

		fread(&temp, sizeof(temp), 1, wavefile);
		fseek(wavefile, temp, SEEK_CUR);
	}

	fread(&wavelen, sizeof(wavelen), 1, wavefile);
	waveoffs=ftell(wavefile);
	/*rawwave.open(*wavefile, waveoffs, wavelen);*/
	fseek(wavefile, waveoffs, SEEK_CUR);

	if (!wavelen)
		return 0;
	wavebuflen=1024*1024;
	if (wavebuflen>wavelen)
	{
		wavebuflen=wavelen;
		bufloopat=wavebuflen;
	} else
		bufloopat=0x40000000;
	wavebuf=malloc(wavebuflen);
	if (!wavebuf)
	{
		wavebuflen=256*1024;
		wavebuf=malloc(wavebuflen);
		if (!wavebuf)
			return 0;
	}
	wavelen=wavelen&~((1<<(wavestereo+wave16bit))-1);
	wavebufpos=0;
	wavebuffpos=0;
	wavebufread=0;

	fread(wavebuf, 1, wavebuflen, rawwave);
	wavepos=wavebuflen;

	plrSetOptions(waverate, (convtostereo||wavestereo)?(PLR_STEREO|PLR_16BIT):PLR_16BIT);

	if (!plrOpenPlayer(&plrbuf, &buflen, plrBufSize))
		return 0;

	stereo=!!(plrOpt&PLR_STEREO);
	bit16=!!(plrOpt&PLR_16BIT);
	signedout=!!(plrOpt&PLR_SIGNEDOUT);
	reversestereo=!!(plrOpt&PLR_REVERSESTEREO);
	samprate=plrRate;
	if (abs(samprate-waverate)<((waverate*tolerance)>>16))
		waverate=samprate;

	wavebufrate=imuldiv(65536, waverate, samprate);

	pause=0;
	looped=0;
	amplify=65536;
	voll=256;
	volr=256;
	pan=64;
	calccliptab((amplify*voll)>>8, (amplify*volr)>>8);

	buf16=malloc(sizeof(unsigned short)*(buflen*2));
	if (!buf16)
	{
		plrClosePlayer();
			return 0;
	}

	bufpos=0;

#ifdef DOS32
	if (!tmInit(timerproc, 15582, 8192))
	{
		plrClosePlayer();
		return 0;
	}
#else
	if (!pollInit(timerproc))
	{
		plrClosePlayer();
		return 0;
	}
#endif

	active=1;

	return 1;
}

void wpClosePlayer(void)
{
	active=0;

	pollClose();

	plrClosePlayer();
	free(wavebuf);
	free(buf16);
	free(cliptabl);
	free(cliptabr);
/*	fclose(rawwave);*/
}

char wpLooped(void)
{
	return looped;
}

void wpSetLoop(unsigned char s)
{
	donotloop=!s;
}

void wpPause(unsigned char p)
{
	pause=p;
}

void wpSetAmplify(unsigned long amp)
{
	amplify=amp;
	calccliptab((amplify*voll)>>8, (amplify*volr)>>8);
}

void wpSetSpeed(unsigned short sp)
{
	if (sp<32)
		sp=32;
	wavebufrate=imuldiv(256*sp, waverate, samprate);
}

void wpSetVolume(unsigned char vol_, signed char bal_, signed char pan_, unsigned char opt_)
{
	pan=pan_;
	volr=voll=vol_*4;
	if (bal_<0)
		volr=(volr*(64+bal_))>>6;
	else
		voll=(voll*(64-bal_))>>6;
	wpSetAmplify(amplify);
}

unsigned long wpGetPos(void)
{
	if (wavelen==wavebuflen)
		return wavebufpos>>(wavestereo+wave16bit);
	else
		return ((wavepos+wavelen-wavebuflen+((wavebufpos-wavebufread+wavebuflen)%wavebuflen))%wavelen)>>(wavestereo+wave16bit);
}

void wpGetInfo(struct waveinfo *i)
{
	i->pos=wpGetPos();
	i->len=wavelen>>(wavestereo+wave16bit);
	i->rate=waverate;
	i->stereo=wavestereo;
	i->bit16=wave16bit;
}

void wpSetPos(signed long pos)
{
	pos=((pos<<(wave16bit+wavestereo))+wavelen)%wavelen;
	if (wavelen==wavebuflen)
		wavebufpos=pos;
	else {
		if (((pos+wavebuflen)>wavepos)&&(pos<wavepos))
			wavebufpos=(wavebufread-(wavepos-pos)+wavebuflen)%wavebuflen;
		else {
			wavepos=pos;
			wavebufpos=0;
			wavebufread=1<<(wave16bit+wavestereo);
		}
	}
}
