/* This file is based on
 * 
 * Adplug - Replayer for many OPL2/OPL3 audio file formats.
 * Copyright (C) 1999 - 2004 Simon Peter, <dn.tlp@gmx.net>, et al.
 * emuopl.h - Emulated OPL, by Simon Peter <dn.tlp@gmx.net>
 *
 *
 * File is changed in letting FM_OPL be public
 */

#ifndef H_ADPLUG_OCPOPL
#define H_ADPLUG_OCPOPL

#include <adplug/opl.h>
extern "C" {
#include <adplug/fmopl.h>
}

class Cocpopl: public Copl
{
public:
	Cocpopl(int rate);	// rate = sample rate
	virtual ~Cocpopl();

	void update(short *buf, int samples);	// fill buffer

	// template methods
	void write(int reg, int val);
	void init();

	unsigned char wavesel[18];

        char hardvols[18][2];     // volume cache
	
	FM_OPL	*opl;                      // holds emulator data
	
	void setmute(int chan, int val);
	int vol(int cell);

private:
	char mute[18];

};

#endif
