/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Fileselector file type detection routines (covers play lists and internal
 * cache files)
 *
 * revision history: (please note changes here)
 *  -kb980717   Tammo Hinrichs <opencp@gmx.net>
 *    -first release
 */

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "types.h"
#include "mdb.h"

static int fsReadMemInfo(struct moduleinfostruct *m, const char *buf, size_t len)
{
  /* check for PLS play list */

	char *b=(char *)buf;
	int pos=10;
	int num=0;

	if (!memcmp(buf,"[playlist]", 10))
	{
		while (pos<len)
		{
			if (b[pos]!=0x0a && b[pos]!=0x0d)
				pos++;
			else {
				while (isspace(b[pos]) && pos<len)
					pos++;
				if (len-pos>18 && !memcmp(b+pos,"NumberOfEntries=",16))
				{
					pos+=16;
					num=strtol(b+pos,0,10);
					pos=len;
				}
			}
		}
		if (num)
		{
			sprintf(m->modname, "PLS style playlist (%d entries)", num);
			m->modtype=mtPLS;
			m->flags1|=MDB_PLAYLIST;
			return 1;
		} else {
			strcpy(m->modname,"PLS style playlist ?");
			m->modtype=mtPLS;
			m->flags1|=MDB_PLAYLIST;
			return 1;
		}
	}

 /* check for M3U-style play list */
	if (!memcmp(buf,"#EXTM3U", 7))
	{
		strcpy(m->modname,"M3U playlist");
		m->modtype=mtM3U;
		m->flags1|=MDB_PLAYLIST;
		return 1;
	}

	if (!strncasecmp(m->name+8, ".M3U", 4))
	{
		strcpy(m->modname, "Non-standard M3U playlist");
		m->modtype=mtM3U;
		m->flags1|=MDB_PLAYLIST;
		return 1;
	}
	
	if (!strncasecmp(m->name+8, ".PLS", 4))
	{
		strcpy(m->modname, "Non-standard PLS playlist");
		m->modtype=mtPLS;
		m->flags1|=MDB_PLAYLIST;
		return 1;
	}

	if (!memcmp(buf, "CPArchiveCache\x1B\x00", 16))
		strcpy(m->modname,"openCP archive data base (old)");
	if (!memcmp(buf, "CPArchiveCache\x1B\x01", 16))
		strcpy(m->modname,"openCP archive data base");
	if (!memcmp(buf, "Cubic Player Module Information Data Base\x1B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 60))
		strcpy(m->modname,"openCP module info data base");
	if (!memcmp(buf, "Cubic Player MediaLib Information Data Base\x1B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 56))
		strcpy(m->modname,"openCP medialib: data base");
	if (!memcmp(buf, "MDZTagList\x1A\x00", 12))
		strcpy(m->modname,"openCP MDZ file cache");

	return 0;
}

static int fsReadInfo(struct moduleinfostruct *m, FILE *fp, const char *buf, size_t len)
{
	return 0;
}

struct mdbreadnforegstruct fsReadInfoReg = {fsReadMemInfo, fsReadInfo};
