/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * X11 common stuff
 *
 * revision history: (please note changes here)
 *  -ss050429   Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#define _CONSOLE_DRIVER
#include "config.h"
#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include "types.h"
#include "poutput.h"
#include "x11-common.h"

static uint16_t red[256]=  {0x0000, 0x0000, 0x0000, 0x0000, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0x5555, 0x5555, 0x5555, 0x5555, 0xffff, 0xffff, 0xffff, 0xffff};
static uint16_t green[256]={0x0000, 0x0000, 0xaaaa, 0xaaaa, 0x0000, 0x0000, 0x5555, 0xaaaa, 0x5555, 0x5555, 0xffff, 0xffff, 0x5555, 0x5555, 0xffff, 0xffff};
static uint16_t blue[256]= {0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff};

uint32_t palette32[256];
uint16_t palette16[256];
uint16_t palette15[256];

Display *mDisplay = NULL;
int mScreen;
int plDepth=8;
int plScrLines;

void x11_gupdatepal(unsigned char color, unsigned char _red, unsigned char _green, unsigned char _blue)
{
	red[color]=_red<<10;
	green[color]=_green<<10;
	blue[color]=_blue<<10;
}

void x11_gflushpal(void)
{
	int i, r, g, b;
	if (plDepth==8)
	{
		Colormap cmap=0;

		cmap=XCreateColormap(mDisplay, mScreen, XDefaultVisual(mDisplay, mScreen), AllocAll);
		for (i = 0; i < 256; i++)
		{
			XColor xcol;
			     
			xcol.pixel = i;
			xcol.red = red[i];
			xcol.green = green[i];
			xcol.blue = blue[i];
			xcol.flags = DoBlue | DoGreen | DoRed;
			XStoreColor(mDisplay, cmap, &xcol);
		}
		XInstallColormap(mDisplay, cmap); 
		XFreeColormap(mDisplay, cmap);
		return;
	}
	for (i=0;i<256;i++)
	{
		r=red[i]>>8;
		g=green[i]>>8;
		b=blue[i]>>8;
		palette32[i]=(r<<16)+(g<<8)+b;
		r>>=3;
		g>>=2;
		b>>=3;
		palette16[i]=(r<<11)+(g<<5)+b;
		g>>=1;
		palette15[i]=(r<<10)+(g<<5)+b;
	}
}

static int inited=0;

int x11_connect(void)
{
	if (inited++)
		return !mDisplay;

	if ( (mDisplay = XOpenDisplay(NULL)) == NULL )
	{
		fprintf(stderr, "[x11] can't connect to X server %s\n", XDisplayName(NULL));
		return -1;
	}
	fprintf(stderr, "[x11] X is online\n");

	mScreen=DefaultScreen(mDisplay);

	return 0;
}

void x11_disconnect(void)
{
	if (!inited)
		return;
	if (!(--inited))
	{
		XCloseDisplay(mDisplay);
		mDisplay=NULL;
	}
}
