/* OpenCP Module Player
 * copyright (c) '94-'10 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * VGA fonts for graphic mode screen output
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    -patched in the analyser characters, so wo don't need to track fonts all
 *     the time.
 */

#include "config.h"
#include "pfonts.h"

#if 0
Hextable:
.... 0
...X 1
..X. 2
..XX 3
.X.. 4
.X.X 5
.XX. 6
.XXX 7
X... 8
X..X 9 
X.X. a
X.XX b 
XX.. c
XX.X d
XXX. e
XXXX f

6x6 font, each line will be a byte
HHLLLL  0xHL
.....X  0x01
.X....  0x10
XX....  0x30
X.XX.X  0x2d

I have done the very first characters

unsigned char plFont66[256][4]=
{
  {0x00, 0x00, 0x00, 0x00},
  /*
  ......
  ......
  ......
  ......
  ......
  ......

  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x1e, 0x21, 0x33, 0x21, 0x2d, 0x1e},
  /*
  .XXXX.
  X....X
  XX..XX
  X....X
  X.XX.X
  .XXXX.
  .XXXXXX.
  X......X
  X.X..X.X
  X......X
  X.XXXX.X
  X..XX..X
  X......X
  .XXXXXX.
  */
  {0x21, 0x1e, 0x0c, 0x1e, 0x12, 0x21},
  /*
  X....X
  .XXXX.
  ..XX..
  .XXXX.
  .X..X.
  X.....X

  .XXXXXX.
  XXXXXXXX
  XX.XX.XX
  XXXXXXXX
  XX....XX
  XXX..XXX
  XXXXXXXX
  .XXXXXX.
  */
  {0x00, 0x14, 0x3e, 0x1c, 0x08, 0x00},
  /*
  ......
  .X.X..
  XXXXX.
  .XXX..
  ..X...
  ......
  .XX.XX..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ..XXX...
  .XXXXX..
  ..XXX...
  XXXXXXX.
  .XXXXX..
  ..XXX...
  .XXXXX..
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...X....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  ..XXX...
  .XXXXX..
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ...XX...
  ..XXXX..
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0xf9, 0x9f},
  /*
  XXXX
  X..X
  X..X
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXX..XXX
  XX....XX
  XX....XX
  XXX..XXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ..XXXX..
  .XX..XX.
  .X....X.
  .X....X.
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XXXXXXXX
  XX....XX
  X..XX..X
  X.XXXX.X
  X.XXXX.X
  X..XX..X
  XX....XX
  XXXXXXXX
  */
  {0x3e, 0xae},
  /*
  ..XX
  XXX.
  X.X.
  XXX.
  ....XXXX
  .....XXX
  ....XXXX
  .XXXXX.X
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xea, 0x4e},
  /*
  XXX.
  X.X.
  .X..
  XXX.
  ..XXXX..
  .XX..XX.
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  .XXXXXX.
  ...XX...
  */
  {0x3c, 0xc0},
  /*
  ..XX
  XX..
  XX..
  ....
  ..XXXXXX
  ..XX..XX
  ..XXXXXX
  ..XX....
  ..XX....
  .XXX....
  XXXX....
  XXX.....
  */
  {0x75, 0xd0},
  /*
  .XXX
  .X.X
  XX.X
  ....
  .XXXXXXX
  .XX...XX
  .XXXXXXX
  .XX...XX
  .XX...XX
  .XX..XXX
  XXX..XX.
  XX......
  */
  {0x96, 0x90},
  /*
  X..X
  .XX.
  X..X
  ....
  X..XX..X
  .X.XX.X.
  ..XXXX..
  XXX..XXX
  ..XXXX..
  .X.XX.X.
  X..XX..X
  */
  {0x8e, 0x80},
  /*
  X...
  XXX.
  X...
  ....
  X.......
  XXX.....
  XXXXX...
  XXXXXXX.
  XXXXX...
  XXX.....
  X.......
  ........
  */
  {0x2e, 0x20},
  /*
  ..X.
  XXX.
  ..X.
  ....
  ......X.
  ....XXX.
  ..XXXXX.
  XXXXXXX.
  ..XXXXX.
  ....XXX.
  ......X.
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  */
  {0xaa, 0x0a},
  /*
  X.X.
  X.X.
  ....
  X.X.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  ........
  .xx..xx.
  ........
  */
  {0x6a, 0x62},
  /*
  .XX.
  X.X.
  .XX.
  ..X.
  .XXXXXXX
  XX.XX.XX
  XX.XX.XX
  .XXXXX.X
  ...XXX.X
  ...XXX.X
  ...XXX.X
  ........
  */
  {0x6c, 0x36},
  /*
  .XX.
  XX..
  ..XX
  .XX.
  ..XXXXX.
  .X.X..XX
  ..XXX...
  .X.XXX..
  .X.XXX..
  ..XXX...
  XX..XX..
  .XXXX...
  */
  {0x00, 0x60},
  /*
  ....
  ....
  .XX.
  ....
  ........
  ........
  ........
  ........
  .XXXXXX.
  .XXXXXX.
  .XXXXXX.
  ........
  */
  {0x4e, 0x4e},
  /*
  .X..
  XXX.
  .X..
  XXX.
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  */
  {0x4e, 0x44},
  /*
  .X..
  XXX.
  .X..
  .X..
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x44, 0xe4},
  /*
  .X..
  .X..
  XXX.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  */
  {0x2f, 0x20},
  /*
  ..X.
  XXXX
  ..X.
  ....
  ........
  ...XX...
  ....XX..
  XXXXXXX.
  ....XX..
  ...XX...
  ........
  ........
  */
  {0x4f, 0x40},
  /*
  .X..
  XXXX
  .X..
  ....
  ........
  ..XX....
  .XX.....
  XXXXXXX.
  .XX.....
  ..XX....
  ........
  ........
  */
  {0x04, 0x60},
  /*
  ....
  .X..
  .XX.
  ....
  ........
  ........
  XX......
  XX......
  XX......
  XXXXXXX.
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  ........
  ..X..X..
  .XX..XX.
  XXXXXXXX
  .XX.XX.
  ..X..X..
  ........
  ........
  */
  {0x4e, 0x00},
  /*
  .X..
  XXX.
  ....
  ....
  ........
  ...XX...
  ..XXXX..
  .XXXXXX.
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  ........
  XXXXXXXX
  XXXXXXXX
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {044, 0x04},
  /*
  .X..
  .X..
  ....
  .X..
  ..XX....
  .XXXX...
  .XXXX...
  ..XX....
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x60, 0x00},
  /*
  .XX.
  ....
  ....
  ....
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0x6c, 0x6e},
  /*
  .XX.
  XX..
  .XX.
  XXX.
  ..XX....
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ..XX....
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  ........
  XX...XX.
  XX..XX..
  ...XX...
  ..XX....
  .XX..XX.
  XX...XX.
  ........
  */
  {0x6d, 0xa5},
  /*
  .XX.
  XX.X
  X.X.
  .X.X
  ..XXX...
  .XX.XX..
  ..XXX...
  .XXX.XX.
  XX.XXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  .XX.....
  .XX.....
  XX......
  ........
  ........
  ........
  ........
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  .XX.....
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ...XX...
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  .XX..XX.
  ..XXXX..
  XXXXXXXX
  ..XXXX..
  .XX..XX.
  ........
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  ........
  */
  {0x00, 0x24},
  /*
  ....
  ....
  ..X.
  .X..
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x0e, 0x00},
  /*
  ....
  XXX.
  ....
  ....
  ........
  ........
  ........
  XXXXXX..
  ........
  ........
  ........
  ........
  */
  {0x00, 0x66},
  /*
  ....
  ....
  .XX.
  .XX.
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x12, 0x48},
  /*
  ...X
  ..X.
  .X..
  X...
  .....XX.
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  XX......
  X.......
  ........
  */
  {0x69, 0x96},
  /*
  .XX.
  X..X
  X..X
  .XX.
  .XXXXX..
  XX...XX.
  XX..XXX.
  XX.XXXX.
  XXXX.XX.
  XXX..XX.
  .XXXXX..
  ........
  */
  {0xc4, 0x4e}, 
  /*
  XX..
  .X..
  .X..
  XXX.
  ..XX....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  XXXXXX..
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.

  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0xe6, 0x2e},
  /*
  XXX.
  .XX.
  ..X.
  XXX.
  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x6a, 0xe2},
  /*
  .XX.
  X.X.
  XXX.
  ..X.
  ...XXX..
  ..XXXX..
  .XX.XX..
  XX..XX..
  XXXXXXX.
  ....XX..
  ...XXXX.
  ........
  */
  {0xec, 0x2e},
  /*
  XXX.
  XX..
  ..X.
  XXX.
  XXXXXX..
  XX......
  XXXXX...
  ....XX..
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x24, 0xae},
  /*
  ..X.
  .X..
  X.X.
  XXX.
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xf2, 0x44},
  /*
  XXXX
  ..X.
  .X..
  .X..
  XXXXXX..
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ..XX....
  ..XX....
  ........
  */
  {0x66, 0x96},
  /*
  .XX.
  .XX.
  X..X
  .XX.
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xea, 0x6c},
  /*
  XXX.
  X.X.
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XX...
  .XXX....
  ........
  */
  {0x40, 0x40},
  /*
  .X..
  ....
  .X..
  ....
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x40, 0x48},
  /*
  .X..
  ....
  .X..
  X...
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x28, 0x20},
  /*
  ..X.
  X...
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  XX......
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  ........
  XXXXXX..
  ........
  ........
  XXXXXX..
  ........
  ........
  */
  {0x82, 0x80},
  /*
  X...
  ..X.
  X...
  ....
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xe2, 0x04},
  /*
  XXX.
  ..X.
  ....
  .X..
  .XXXX...
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x7b, 0x86},
  /*
  .XXX
  X.XX
  X...
  .XX.
  .XXXXX..
  XX...XX.
  XX.XXXX.
  XX.XXXX.
  XX.XXXX.
  XX......
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XXXXXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX......
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  XXXXX...
  .XX.XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX.XX..
  XXXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX...X.
  XXXXXXX.
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX..XXX.
  .XX..XX.
  ..XXXXX.
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXX...
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XXXX.
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX..XX.
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  XXXX....
  .XX.....
  .XX.....
  .XX.....
  .XX...X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  XX...XX.
  XXX.XXX.
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XX...XX.
  XXX..XX.
  XXXX.XX.
  XX.XXXX.
  XX..XXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX.XXX..
  .XXXX...
  ...XXX..
  ........
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  .XXXX...
  XX..XX..
  XXX.....
  .XXX
  ...XXX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  XXXXXX..
  X.XX.X..
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  XX...XX.
  XX...XX.
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXX.XXX.
  XX...XX.
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XX...XX.
  XX...XX.
  .XX.XX.
  ..XXX...
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  XXXXXXX.
  XX...XX.
  X...XX..
  ...XX...
  ..XX..X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0x64, 0x60},
  /*
  .XX.
  .X..
  .XX.
  ....
  .XXXX...
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XXXX...
  ........
  */
  {0x84, 0x21},
  /*
  X...
  .X..
  ..X.
  ...X
  XX......
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  .....XX.
  ......X.
  ........
  */
  {0x62, 0x60},
  /*
  .XX.
  ..X.
  .XX.
  ....
  .XXXX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXX...
  ........
  */
  {0x4a, 0x00},
  /*
  .X..
  X.X.
  ....
  ....
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  ........
  ........
  ........
  */
  {0x00, 0x0f},
  /*
  ....
  ....
  ....
  XXXX
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXXX
  */
  {0x84, 0x00},
  /*
  X...
  .X..
  ....
  ....
  ..XX....
  ..XX....
  ...XX...
  ........
  ........
  ........
  ........
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ........
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXX.....
  .XX.....
  .XX.....
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XX.XXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  ...XXX..
  ....XX..
  ....XX..
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  ..XXX...
  .XX.XX..
  .XX.....
  XXXX....
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XXX.....
  .XX.....
  .XX.XX..
  .XXX.XX.
  .XX..XX.
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XX....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ....XX..
  ........
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX.....
  .XX.....
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  ........
  ........
  XX..XX..
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  ........
  ........
  XX.XXX..
  .XX..XX.
  .XXXXX..
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XXXX.
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  ........
  ........
  XX.XXX..
  .XXX.XX.
  .XX..XX.
  .XX.....
  XXXX....
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  ........
  ........
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  ...X....
  ..XX....
  .XXXXX..
  ..XX....
  ..XX....
  ..XX.X..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........  
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  ........
  ........
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  ........
  XX...XX.
  .XX.XX..
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  ........
  ........
  XXXXXX..
  X..XX...
  ..XX....
  .XX..X..
  XXXXXX..
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX.
  .XX.
  ....
  ...XXX...
  ..XX....
  ..XX....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ........
  */
  {0x22, 0x20},
  /*
  ..X.
  ..X.
  ..X.
  ....
  ...XX....
  ...XX....
  ...XX....
  .........
  ...XX....
  ...XX....
  ...XX....
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ..XX....
  ..XX....
  XXX.....
  ........
  */
  {0x5a, 0x00},
  /*
  .X.X
  X.X.
  ....
  ....
  .XXX.XX.
  XX.XXX..
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x4a, 0xe0},
  /*
  .X..
  X.X.
  XXX.
  ....
  ........
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XXXXXXX.
  ........
  */
  {0x68, 0x6c},
  /*
  .XX.
  X...
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ...XX...
  ....XX..
  .XXXX...
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXXX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .....XX.
  ..XXXXX.
  .XX..XX.
  ..XXXXXX
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX..XX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XXX.....
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x68, 0x64},
  /*
  .XX.
  X...
  .XX.
  .X..
  ........
  ........
  .XXXX...
  XX......
  XX......
  .XXXX...
  ....XX..
  ..XXX...
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .XX..XX.
  .XXXXXX.
  .XX.....
  ..XXXX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XX..XX..
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXXX..
  XX...XX.
  ..XXX...
  ...XX...
  ...XX...
  ...XX...
  ..XXXX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XXX.....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX...XX.
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX..XX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  XXXXXX..
  .XX.....
  .XXXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0x2e, 0xe0},
  /*
  ..X.
  XXX.
  XXX.
  ....
  ........
  ........
  .XXXXXXX
  ....XX..
  .XXXXXXX
  XX..XX..
  .XXXXXXX
  ........
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XXXXX.
  .XX.XX..
  XX..XX..
  XXXXXXX.
  XX..XX..
  XX..XX..
  XX..XXX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  .XXXX...
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  .XXXX...
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XXX.....
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  XX....XX
  ...XX...
  ..XXXX..
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x68, 0x66},
  /*
  .XX.
  X...
  .XX.
  .XX.
  ...XX...
  ...XX...
  .XXXXXX.
  XX......
  XX......
  .XXXXXX.
  ...XX...
  ...XX...
  */
  {0xc8, 0xe0},
  /*
  XX..
  X...
  XXX.
  ....
  ..XXX...
  .XX.XX..
  .XX..X..
  XXXX....
  .XX.....
  XXX..XX.
  XXXXXX..
  ........
  */
  {0xa4, 0xe4},
  /*
  X.X.
  .X..
  XXX.
  .X..
  XX..XX..
  XX..XX..
  .XXXX...
  XXXXXX..
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  */
  {0xea, 0xea},
  /*
  XXX.
  X.X.
  XXX.
  X.X.
  XXXXX...
  XX..XX..
  XX..XX..
  XXXXX.X.
  XX...XX.
  XX..XXXX
  XX...XX.
  XX...XXX
  */
  {0x64, 0x4c},
  /*
  .XX.
  .X..
  .X..
  XX..
  ....XXX.
  ...XX.XX
  ...XX...
  ..XXXX..
  ...XX...
  ...XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...XXX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XXX...
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ...XXX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  XXXXX...
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XXXXXX..
  ........
  XX..XX..
  XXX.XX..
  XXXXXX..
  XX.XXX..
  XX..XX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XXXX..
  .XX.XX..
  .XX.XX..
  ..XXXXX.
  ........
  .XXXXXX.
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  .XXXXX..
  ........
  ........
  */
  {0x40, 0x8e},
  /*
  .X..
  ....
  X...
  XXX.
  ..XX....
  ........
  ..XX....
  .XX.....
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0x0c, 0x80},
  /*
  ....
  XX..
  X...
  ....
  ........
  ........
  ........
  XXXXXX..
  XX......
  XX......
  ........
  ........
  */
  {0x0c, 0x40},
  /*
  ....
  XX..
  .X..
  ....
  ........
  ........
  ........
  XXXXXX..
  ....XX..
  ....XX..
  ........
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/2
  XX...XX.
  XX..XX..
  XX.XXXX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ....XXXX
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/4
  XX...XX.
  XX..XX..
  XX.XX.XX
  ..XX.XXX
  .XX.XXXX
  XX..XXXX
  ......XX
  */
  {0x20, 0x22},
  /*
  ..X.
  ....
  ..X.
  ..X.
  ...XX...
  ...XX...
  ........
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ..XX..XX.
  .XX..XX.
  XX..XX..
  .XX..XX.
  ..XX..XX.
  .........
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  ........
  XX..XX..
  .XX..XX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ........
  ........
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  */
  {0x44, 0x44},
  /*
  .X..
  .X..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x44},
  /*
  .X..
  XX..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
*/
#ifdef PFONT_IDRAWBAR
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  ........
  ........
  XXXXXXX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
#else
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  */
#endif
  {0x6e, 0xe6},
  /*
  .XX.
  XXX.
  XXX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x66, 0x66},
  /*
  .XX.
  .XX.
  .XX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0e, 0xe6},
  /*
  ....
  XXX.
  XXX.
  .XX.
  ........
  ........
  XXXXXXX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXXXXX.
  ........
  ........
  ........
  */
#ifdef PFONT_IDRAWBAR
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXX.
  ........
  ........
  ........
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
#else 
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  */
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  */
#endif
  {0x0c, 0x44},
  /*
  ....
  XX..
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x00},
  /*
  .X..
  .XXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x00},
  /*
  .X..
  XXXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0x44},
  /*
  ....
  XXXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x44},
  /*
  .X..
  .XXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x0f, 0x00},
  /*
  ....
  XXXX
  ....
  ....
  ........
  ........
  ........
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x44},
  /*
  .X..
  XXXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
#ifdef PFONT_IDRAWBAR
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
#else
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
#endif
  {0x67, 0x70},
  /*
  .XX.
  .XXX
  .XXX
  ....
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XXXXXX
  ........
  ........
  ........
  */
  {0x07, 0x76},
  /*
  ....
  .XXX
  .XXX
  .XX.
  ........
  ........
  ..XXXXXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6f, 0xf0},
  /*
  .XX.
  XXXX
  XXXX
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0xf6},
  /*
  ....
  XXXX
  XXXX
  .XX.
  ........
  ........
  XXXXXXXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x67, 0x76},
  /*
  .XX.
  .XXX
  .XXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0f, 0xf0},
  /*
  ....
  XXXX
  XXXX
  ....
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
#ifdef PFONT_IDRAWBAR
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  XXXXXXXX.
  .........
  .........
  .........
  .........
  .........
  .........
  .........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ........
  ........
  */
  {0xe0, 0x00},
  /*
  XXX.
  ....
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  ........
  ........
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0x00},
  /*
  XXX.
  XXX.
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XXXXXX
  ........
  ........
  ........
  */
  {0xee, 0x40},
  /*
  XXX.
  XXX.
  .X..
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  org
  ........
  ........
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xee, 0xe4},
  /*
  XXX.
  XXX.
  XXX.
  .X..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  org
  ........
  ........
  ........
  ........
  ..XXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0xee},
  /*
  XXX.
  XXX.
  XXX.
  XXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
#else
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0xee, 0xee},
  /*
  XXX.
  XXX.
  XXX.
  XXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
#endif
  {0x4f, 0xf4},
  /*
  .X..
  XXXX
  XXXX
  .X..
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x00},
  /*
  .X..
  XX..
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
  {0x07, 0x44},
  /*
  ....
  .XXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xff, 0xff},
  /*
  XXXX
  XXXX
  XXXX
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x00, 0xff},
  /*
  ....
  ....
  XXXX
  XXXX
  ........
  ........
  ........
  ........
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0xcc, 0xcc},
  /*
  XX..
  XX..
  XX..
  XX..
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  */
  {0x33, 0x33},
  /*
  ..XX
  ..XX
  ..XX
  ..XX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  */
  {0xff, 0x00},
  /*
  XXXX
  XXXX
  ....
  ....
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  ........
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX.XXX..
  XX..X...
  XX.XXX..
  .XXX.XX.
  ........
  */
  {0xee, 0xa0},
  /*
  XXX.
  XXX.
  X.X.
  ....
  .XXXX... German double S
  XX..XX..
  XX..XX..
  XX.XX...
  XX..XX..
  XX...XX.
  XX...XX.
  ........
  */
  {0xea, 0x80},
  /*
  XXX.
  X.X.
  X...
  ....
  XXXXXX..
  XX..XX..
  XX......
  XX......
  XX......
  XX......
  XX......
  ........
  */
  {0xec, 0xc0},
  /*
  XXX.
  XX..
  XX..
  ....
  ........ PI
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  */
  {0xe8, 0xe0},
  /*
  XXX.
  X...
  XXX.
  ....
  XXXXXX..
  XX..XX..
  .XX.....
  ..XX....
  .XX.....
  XX..XX..
  XXXXXX...
  .........
  */
  {0x6a, 0x40},
  /*
  .XX.
  X.X.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX...
  XX.XX...
  XX.XX...
  .XXX....
  ........
  */
  {0xaa, 0xe8},
  /*
  X.X.
  X.X.
  XXX.
  X...
  ........
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  XX......
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ........I + tilda
  .XXX.XX.
  XX.XXX..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0xe4, 0x4e},
  /*
  XXX.
  .X..
  .X..
  XXX.
  XXXXXX..
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  XXXXXX...
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0x4a, 0xa0},
  /*
  .X..
  X.X.
  X.X.
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  .XX.XX..
  .XX.XX..
  XXX.XXX.
  ........
  */
  {0x64, 0xa4},
  /*
  .XX.
  .X..
  X.X.
  .X..
  ...XXX..
  ..XX....
  ...XX...
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  ........
  ........
  */
  {0x6e, 0xc0},
  /*
  .XX.
  XXX.
  XX..
  ....
  .....XX.
  ....XX..
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  .XX.....
  XX......
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX......
  .XX.....
  ..XXX...
  .........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  ........
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  ....
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ..XX....
  .XX.....
  ........
  XXXXXX..
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  ..XX....
  ...XX...
  ........
  XXXXXX..
  ........
  */
  {0x2a, 0x44},
  /*
  ..X.
  .X.X.
  .X...
  .X...
  ....XXX.
  ...XX.XX
  ...XX.XX
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XX.XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  ..XX....
  ..XX....
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  .XXX.XX.
  XX.XXX..
  ........
  .XXX.XX.
  XX.XXX..
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ...XX...
  ...XX...
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ........
  ...XX...
  ........
  ........
  ........
  */
  {0x32, 0xa6},
  /*
  ..XX
  ..X.
  X.X.
  .XX.
  ....XXXX
  ....XX..
  ....XX..
  ....XX..
  XXX.XX..
  .XX.XX..
  ..XXXX..
  ...XXX..
  */
  {0xea, 0x00},
  /*
  XXX.
  X.X.
  ....
  ....
  .XXXX...
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.
  .XXX....
  ...XX...
  ..XX....
  .XX.....
  .XXXX...
  ........
  ........
  ........
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ........
  ........
  */
  {0x00, 0x00}
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
};

#endif

































































































unsigned char plFont44[256][2]=
{
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  .XXXXXX.
  X......X
  X.X..X.X
  X......X
  X.XXXX.X
  X..XX..X
  X......X
  .XXXXXX.
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  .XXXXXX.
  XXXXXXXX
  XX.XX.XX
  XXXXXXXX
  XX....XX
  XXX..XXX
  XXXXXXXX
  .XXXXXX.
  */
  {0xae, 0x40},
  /*
  X.X.
  XXX.
  .X..
  ....
  .XX.XX..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  .XXXXX..
  ..XXX...
  ...X....
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ..XXX...
  .XXXXX..
  ..XXX...
  XXXXXXX.
  .XXXXX..
  ..XXX...
  .XXXXX..
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...X....
  ...X....
  ..XXX...
  .XXXXX..
  XXXXXXX.
  ..XXX...
  .XXXXX..
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ...XX...
  ..XXXX..
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0xf9, 0x9f},
  /*
  XXXX
  X..X
  X..X
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXX..XXX
  XX....XX
  XX....XX
  XXX..XXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ..XXXX..
  .XX..XX.
  .X....X.
  .X....X.
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XXXXXXXX
  XX....XX
  X..XX..X
  X.XXXX.X
  X.XXXX.X
  X..XX..X
  XX....XX
  XXXXXXXX
  */
  {0x3e, 0xae},
  /*
  ..XX
  XXX.
  X.X.
  XXX.
  ....XXXX
  .....XXX
  ....XXXX
  .XXXXX.X
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xea, 0x4e},
  /*
  XXX.
  X.X.
  .X..
  XXX.
  ..XXXX..
  .XX..XX.
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  .XXXXXX.
  ...XX...
  */
  {0x3c, 0xc0},
  /*
  ..XX
  XX..
  XX..
  ....
  ..XXXXXX
  ..XX..XX
  ..XXXXXX
  ..XX....
  ..XX....
  .XXX....
  XXXX....
  XXX.....
  */
  {0x75, 0xd0},
  /*
  .XXX
  .X.X
  XX.X
  ....
  .XXXXXXX
  .XX...XX
  .XXXXXXX
  .XX...XX
  .XX...XX
  .XX..XXX
  XXX..XX.
  XX......
  */
  {0x96, 0x90},
  /*
  X..X
  .XX.
  X..X
  ....
  X..XX..X
  .X.XX.X.
  ..XXXX..
  XXX..XXX
  ..XXXX..
  .X.XX.X.
  X..XX..X
  */
  {0x8e, 0x80},
  /*
  X...
  XXX.
  X...
  ....
  X.......
  XXX.....
  XXXXX...
  XXXXXXX.
  XXXXX...
  XXX.....
  X.......
  ........
  */
  {0x2e, 0x20},
  /*
  ..X.
  XXX.
  ..X.
  ....
  ......X.
  ....XXX.
  ..XXXXX.
  XXXXXXX.
  ..XXXXX.
  ....XXX.
  ......X.
  ........
  */
  {0xe4, 0xe0},
  /*
  XXX.
  .X..
  XXX.
  ....
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  */
  {0xaa, 0x0a},
  /*
  X.X.
  X.X.
  ....
  X.X.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  .xx..xx.
  ........
  .xx..xx.
  ........
  */
  {0x6a, 0x62},
  /*
  .XX.
  X.X.
  .XX.
  ..X.
  .XXXXXXX
  XX.XX.XX
  XX.XX.XX
  .XXXXX.X
  ...XXX.X
  ...XXX.X
  ...XXX.X
  ........
  */
  {0x6c, 0x36},
  /*
  .XX.
  XX..
  ..XX
  .XX.
  ..XXXXX.
  .X.X..XX
  ..XXX...
  .X.XXX..
  .X.XXX..
  ..XXX...
  XX..XX..
  .XXXX...
  */
  {0x00, 0x60},
  /*
  ....
  ....
  .XX.
  ....
  ........
  ........
  ........
  ........
  .XXXXXX.
  .XXXXXX.
  .XXXXXX.
  ........
  */
  {0x4e, 0x4e},
  /*
  .X..
  XXX.
  .X..
  XXX.
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  */
  {0x4e, 0x44},
  /*
  .X..
  XXX.
  .X..
  .X..
  ...XX...
  ..XXXX..
  .XXXXXX.
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x44, 0xe4},
  /*
  .X..
  .X..
  XXX.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  */
  {0x2f, 0x20},
  /*
  ..X.
  XXXX
  ..X.
  ....
  ........
  ...XX...
  ....XX..
  XXXXXXX.
  ....XX..
  ...XX...
  ........
  ........
  */
  {0x4f, 0x40},
  /*
  .X..
  XXXX
  .X..
  ....
  ........
  ..XX....
  .XX.....
  XXXXXXX.
  .XX.....
  ..XX....
  ........
  ........
  */
  {0x04, 0x60},
  /*
  ....
  .X..
  .XX.
  ....
  ........
  ........
  XX......
  XX......
  XX......
  XXXXXXX.
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  ........
  ..X..X..
  .XX..XX.
  XXXXXXXX
  .XX.XX.
  ..X..X..
  ........
  ........
  */
  {0x4e, 0x00},
  /*
  .X..
  XXX.
  ....
  ....
  ........
  ...XX...
  ..XXXX..
  .XXXXXX.
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  ........
  XXXXXXXX
  XXXXXXXX
  .XXXXXX.
  ..XXXX..
  ...XX...
  ........
  ........
  */
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {044, 0x04},
  /*
  .X..
  .X..
  ....
  .X..
  ..XX....
  .XXXX...
  .XXXX...
  ..XX....
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x60, 0x00},
  /*
  .XX.
  ....
  ....
  ....
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  ........
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0x6c, 0x6e},
  /*
  .XX.
  XX..
  .XX.
  XXX.
  ..XX....
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ..XX....
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  ........
  XX...XX.
  XX..XX..
  ...XX...
  ..XX....
  .XX..XX.
  XX...XX.
  ........
  */
  {0x6d, 0xa5},
  /*
  .XX.
  XX.X
  X.X.
  .X.X
  ..XXX...
  .XX.XX..
  ..XXX...
  .XXX.XX.
  XX.XXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  .XX.....
  .XX.....
  XX......
  ........
  ........
  ........
  ........
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  .XX.....
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ...XX...
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  .XX..XX.
  ..XXXX..
  XXXXXXXX
  ..XXXX..
  .XX..XX.
  ........
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  ........
  */
  {0x00, 0x24},
  /*
  ....
  ....
  ..X.
  .X..
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x0e, 0x00},
  /*
  ....
  XXX.
  ....
  ....
  ........
  ........
  ........
  XXXXXX..
  ........
  ........
  ........
  ........
  */
  {0x00, 0x66},
  /*
  ....
  ....
  .XX.
  .XX.
  ........
  ........
  ........
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x12, 0x48},
  /*
  ...X
  ..X.
  .X..
  X...
  .....XX.
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  XX......
  X.......
  ........
  */
  {0x69, 0x96},
  /*
  .XX.
  X..X
  X..X
  .XX.
  .XXXXX..
  XX...XX.
  XX..XXX.
  XX.XXXX.
  XXXX.XX.
  XXX..XX.
  .XXXXX..
  ........
  */
  {0xc4, 0x4e}, 
  /*
  XX..
  .X..
  .X..
  XXX.
  ..XX....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  XXXXXX..
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.

  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0xe6, 0x2e},
  /*
  XXX.
  .XX.
  ..X.
  XXX.
  .XXXX...
  XX..XX..
  ....XX..
  ..XXX...
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x6a, 0xe2},
  /*
  .XX.
  X.X.
  XXX.
  ..X.
  ...XXX..
  ..XXXX..
  .XX.XX..
  XX..XX..
  XXXXXXX.
  ....XX..
  ...XXXX.
  ........
  */
  {0xec, 0x2e},
  /*
  XXX.
  XX..
  ..X.
  XXX.
  XXXXXX..
  XX......
  XXXXX...
  ....XX..
  ....XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x24, 0xae},
  /*
  ..X.
  .X..
  X.X.
  XXX.
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xf2, 0x44},
  /*
  XXXX
  ..X.
  .X..
  .X..
  XXXXXX..
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ..XX....
  ..XX....
  ........
  */
  {0x66, 0x96},
  /*
  .XX.
  .XX.
  X..X
  .XX.
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xea, 0x6c},
  /*
  XXX.
  X.X.
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XX...
  .XXX....
  ........
  */
  {0x40, 0x40},
  /*
  .X..
  ....
  .X..
  ....
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  ........
  */
  {0x40, 0x48},
  /*
  .X..
  ....
  .X..
  X...
  ........
  ..XX....
  ..XX....
  ........
  ........
  ..XX....
  ..XX....
  .XX.....
  */
  {0x28, 0x20},
  /*
  ..X.
  X...
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  XX......
  .XX.....
  ..XX....
  ...XX...
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  ........
  XXXXXX..
  ........
  ........
  XXXXXX..
  ........
  ........
  */
  {0x82, 0x80},
  /*
  X...
  ..X.
  X...
  ....
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  ...XX...
  ..XX....
  .XX.....
  ........
  */
  {0xe2, 0x04},
  /*
  XXX.
  ..X.
  ....
  .X..
  .XXXX...
  XX..XX..
  ....XX..
  ...XX...
  ..XX....
  ........
  ..XX....
  ........
  */
  {0x7b, 0x86},
  /*
  .XXX
  X.XX
  X...
  .XX.
  .XXXXX..
  XX...XX.
  XX.XXXX.
  XX.XXXX.
  XX.XXXX.
  XX......
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XXXXXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX......
  .XX..XX.
  ..XXXX..
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  XXXXX...
  .XX.XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX.XX..
  XXXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX...X.
  XXXXXXX.
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  XXXXXXX.
  .XX...X.
  .XX.X...
  .XXXX...
  .XX.X...
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ..XXXX..
  .XX..XX.
  XX......
  XX......
  XX..XXX.
  .XX..XX.
  ..XXXXX.
  ........
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXX...
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XXXX.
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX..XX.
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  XXXX....
  .XX.....
  .XX.....
  .XX.....
  .XX...X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  XX...XX.
  XXX.XXX.
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XX...XX.
  XXX..XX.
  XXXX.XX.
  XX.XXXX.
  XX..XXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX.XXX..
  .XXXX...
  ...XXX..
  ........
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  XXXXXX..
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.XX..
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  .XXXX...
  XX..XX..
  XXX.....
  .XXX
  ...XXX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  XXXXXX..
  X.XX.X..
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XXXXXX..
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  XX...XX.
  XX...XX.
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXX.XXX.
  XX...XX.
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  XX...XX.
  XX...XX.
  .XX.XX.
  ..XXX...
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  XXXXXXX.
  XX...XX.
  X...XX..
  ...XX...
  ..XX..X.
  .XX..XX.
  XXXXXXX.
  ........
  */
  {0x64, 0x60},
  /*
  .XX.
  .X..
  .XX.
  ....
  .XXXX...
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XX.....
  .XXXX...
  ........
  */
  {0x84, 0x21},
  /*
  X...
  .X..
  ..X.
  ...X
  XX......
  .XX.....
  ..XX....
  ...XX...
  ....XX..
  .....XX.
  ......X.
  ........
  */
  {0x62, 0x60},
  /*
  .XX.
  ..X.
  .XX.
  ....
  .XXXX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  .XXXX...
  ........
  */
  {0x4a, 0x00},
  /*
  .X..
  X.X.
  ....
  ....
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  ........
  ........
  ........
  */
  {0x00, 0x0f},
  /*
  ....
  ....
  ....
  XXXX
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXXX
  */
  {0x84, 0x00},
  /*
  X...
  .X..
  ....
  ....
  ..XX....
  ..XX....
  ...XX...
  ........
  ........
  ........
  ........
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ........
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0x8e, 0xe0},
  /*
  X...
  XXX.
  XXX.
  ....
  XXX.....
  .XX.....
  .XX.....
  .XXXXX..
  .XX..XX.
  .XX..XX.
  XX.XXX..
  ........
  */
  {0x68, 0x60},
  /*
  .XX.
  X...
  .XX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xc0},
  /*
  XX..
  X.X.
  XX..
  ....
  ...XXX..
  ....XX..
  ....XX..
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0x80},
  /*
  XXX.
  XX..
  X...
  ....
  ..XXX...
  .XX.XX..
  .XX.....
  XXXX....
  .XX.....
  .XX.....
  XXXX....
  ........
  */
  {0x68, 0xa5},
  /*
  .XX.
  X...
  X.X.
  .XX.
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xae, 0xa0},
  /*
  X.X.
  XXX.
  X.X.
  ....
  XXX.....
  .XX.....
  .XX.XX..
  .XXX.XX.
  .XX..XX.
  .XX..XX.
  XXX..XX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XX....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ....XX..
  ........
  ....XX..
  ....XX..
  ....XX..
  XX..XX..
  XX..XX..
  .XXXX...
  */
  {0xac, 0xa0},
  /*
  X.X.
  XX..
  X.X.
  ....
  XXX.....
  .XX.....
  .XX..XX.
  .XX.XX..
  .XXXX...
  .XX.XX..
  XXX..XX.
  ........
  */
  {0x88, 0xe0},
  /*
  X...
  X...
  XXX.
  ....
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  ........
  ........
  XX..XX..
  XXXXXXX.
  XXXXXXX.
  XX.X.XX.
  XX...XX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xca, 0xa8},
  /*
  XX..
  X.X.
  XX..
  X...
  ........
  ........
  XX.XXX..
  .XX..XX.
  .XXXXX..
  .XX.....
  XXXX....
  ........
  */
  {0x4a, 0x60},
  /*
  .X..
  X.X.
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  ...XXXX.
  */
  {0xca, 0xca},
  /*
  XX..
  X...
  X...
  ....
  ........
  ........
  XX.XXX..
  .XXX.XX.
  .XX..XX.
  .XX.....
  XXXX....
  ........
  */
  {0x64, 0xc0},
  /*
  .XX.
  .X..
  XX..
  ....
  ........
  ........
  .XXXXX..
  XX......
  .XXXX...
  ....XX..
  XXXXX...
  ........
  */
  {0xe4, 0x40},
  /*
  XXX.
  .X..
  .X..
  ....
  ...X....
  ..XX....
  .XXXXX..
  ..XX....
  ..XX....
  ..XX.X..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXX.XX.
  ........
  */
  {0xaa, 0x40},
  /*
  X.X.
  X.X.
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  ........  
  */
  {0x9f, 0x60},
  /*
  X..X
  XXXX
  .XX.
  ....
  ........
  ........
  XX...XX.
  XX.X.XX.
  XXXXXXX.
  XXXXXXX.
  .XX.XX..
  ........
  */
  {0xa4, 0xa0},
  /*
  X.X.
  .X..
  X.X.
  ....
  ........
  ........
  XX...XX.
  .XX.XX..
  ..XXX...
  .XX.XX..
  XX...XX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0xc4, 0x60},
  /*
  XX..
  .X..
  .XX.
  ....
  ........
  ........
  XXXXXX..
  X..XX...
  ..XX....
  .XX..X..
  XXXXXX..
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX.
  .XX.
  ....
  ...XXX...
  ..XX....
  ..XX....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ........
  */
  {0x22, 0x20},
  /*
  ..X.
  ..X.
  ..X.
  ....
  ...XX....
  ...XX....
  ...XX....
  .........
  ...XX....
  ...XX....
  ...XX....
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  XXX.....
  ..XX....
  ..XX....
  ...XXX..
  ..XX....
  ..XX....
  XXX.....
  ........
  */
  {0x5a, 0x00},
  /*
  .X.X
  X.X.
  ....
  ....
  .XXX.XX.
  XX.XXX..
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x4a, 0xe0},
  /*
  .X..
  X.X.
  XXX.
  ....
  ........
  ...X....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  XXXXXXX.
  ........
  */
  {0x68, 0x6c},
  /*
  .XX.
  X...
  .XX.
  XX..
  .XXXX...
  XX..XX..
  XX......
  XX..XX..
  .XXXX...
  ...XX...
  ....XX..
  .XXXX...
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXXX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .....XX.
  ..XXXXX.
  .XX..XX.
  ..XXXXXX
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX..XX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XXX.....
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x68, 0x64},
  /*
  .XX.
  X...
  .XX.
  .X..
  ........
  ........
  .XXXX...
  XX......
  XX......
  .XXXX...
  ....XX..
  ..XXX...
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  .XXXXXX.
  XX....XX
  ..XXXX..
  .XX..XX.
  .XXXXXX.
  .XX.....
  ..XXXX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX......
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XX..XX..
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  .XXXXX..
  XX...XX.
  ..XXX...
  ...XX...
  ...XX...
  ...XX...
  ..XXXX..
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  XXX.....
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  XX...XX.
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  XX...XX.
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XX....
  ..XX....
  ........
  .XXXX...
  XX..XX..
  XXXXXX..
  XX..XX..
  ........
  */
  {0xec, 0xe0},
  /*
  XXX.
  XX..
  XXX.
  ....
  ...XXX..
  ........
  XXXXXX..
  .XX.....
  .XXXX...
  .XX.....
  XXXXXX..
  ........
  */
  {0x2e, 0xe0},
  /*
  ..X.
  XXX.
  XXX.
  ....
  ........
  ........
  .XXXXXXX
  ....XX..
  .XXXXXXX
  XX..XX..
  .XXXXXXX
  ........
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XXXXX.
  .XX.XX..
  XX..XX..
  XXXXXXX.
  XX..XX..
  XX..XX..
  XX..XXX.
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  .XXXX...
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XX..XX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  XXX.....
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  .XXXX...
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  XXX.....
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0xa4, 0x40},
  /*
  X.X.
  .X..
  .X..
  ....
  ........
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  .XXXXX..
  ....XX..
  XXXXX...
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  XX....XX
  ...XX...
  ..XXXX..
  .XX..XX.
  .XX..XX.
  ..XXXX..
  ...XX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  XX..XX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x68, 0x66},
  /*
  .XX.
  X...
  .XX.
  .XX.
  ...XX...
  ...XX...
  .XXXXXX.
  XX......
  XX......
  .XXXXXX.
  ...XX...
  ...XX...
  */
  {0xc8, 0xe0},
  /*
  XX..
  X...
  XXX.
  ....
  ..XXX...
  .XX.XX..
  .XX..X..
  XXXX....
  .XX.....
  XXX..XX.
  XXXXXX..
  ........
  */
  {0xa4, 0xe4},
  /*
  X.X.
  .X..
  XXX.
  .X..
  XX..XX..
  XX..XX..
  .XXXX...
  XXXXXX..
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  */
  {0xea, 0xea},
  /*
  XXX.
  X.X.
  XXX.
  X.X.
  XXXXX...
  XX..XX..
  XX..XX..
  XXXXX.X.
  XX...XX.
  XX..XXXX
  XX...XX.
  XX...XXX
  */
  {0x64, 0x4c},
  /*
  .XX.
  .X..
  .X..
  XX..
  ....XXX.
  ...XX.XX
  ...XX...
  ..XXXX..
  ...XX...
  ...XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ...XXX..
  ........
  .XXXX...
  ....XX..
  .XXXXX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ..XXX...
  ........
  .XXX....
  ..XX....
  ..XX....
  ..XX....
  .XXXX...
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ........
  ...XXX..
  ........
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0xaa, 0xe0},
  /*
  X.X.
  X.X.
  XXX.
  ....
  ........
  ...XXX..
  ........
  XX..XX..
  XX..XX..
  XX..XX..
  .XXXXXX.
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  ........
  XXXXX...
  ........
  XXXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0x8e, 0x20},
  /*
  X...
  XXX.
  ..X.
  ....
  XXXXXX..
  ........
  XX..XX..
  XXX.XX..
  XXXXXX..
  XX.XXX..
  XX..XX..
  ........
  */
  {0x4e, 0xa0},
  /*
  .X..
  XXX.
  X.X.
  ....
  ..XXXX..
  .XX.XX..
  .XX.XX..
  ..XXXXX.
  ........
  .XXXXXX.
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  .XXXXX..
  ........
  ........
  */
  {0x40, 0x8e},
  /*
  .X..
  ....
  X...
  XXX.
  ..XX....
  ........
  ..XX....
  .XX.....
  XX......
  XX..XX..
  .XXXX...
  ........
  */
  {0x0c, 0x80},
  /*
  ....
  XX..
  X...
  ....
  ........
  ........
  ........
  XXXXXX..
  XX......
  XX......
  ........
  ........
  */
  {0x0c, 0x40},
  /*
  ....
  XX..
  .X..
  ....
  ........
  ........
  ........
  XXXXXX..
  ....XX..
  ....XX..
  ........
  ........
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/2
  XX...XX.
  XX..XX..
  XX.XXXX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ....XXXX
  */
  {0x92, 0x49},
  /*
  X..X
  ..X.
  .X..
  X..X
  XX....XX 1/4
  XX...XX.
  XX..XX..
  XX.XX.XX
  ..XX.XXX
  .XX.XXXX
  XX..XXXX
  ......XX
  */
  {0x20, 0x22},
  /*
  ..X.
  ....
  ..X.
  ..X.
  ...XX...
  ...XX...
  ........
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ..XX..XX.
  .XX..XX.
  XX..XX..
  .XX..XX.
  ..XX..XX.
  .........
  .........
  */
  {0xc6, 0xc0},
  /*
  XX..
  .XX.
  XX..
  ....
  ........
  XX..XX..
  .XX..XX.
  ..XX..XX
  .XX..XX.
  XX..XX..
  ........
  ........
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  ..X...X.
  X...X...
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  .X.X.X.X
  X.X.X.X.
  */
  {0x5a, 0x5a},
  /*
  .X.X
  X.X.
  .X.X
  X.X.
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  XX.XX.XX
  .XXX.XXX
  */
  {0x44, 0x44},
  /*
  .X..
  .X..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x44},
  /*
  .X..
  XX..
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
*/
#ifdef PFONT_IDRAWBAR
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  ........
  ........
  XXXXXXX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ........
  ........
  XXXXX...
  ...XX...
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
#else
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x00, 0x00},
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  */
  {0x00, 0x04},
  /*
  ....
  ....
  ....
  .X..
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  */
#endif
  {0x6e, 0xe6},
  /*
  .XX.
  XXX.
  XXX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x66, 0x66},
  /*
  .XX.
  .XX.
  .XX.
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0e, 0xe6},
  /*
  ....
  XXX.
  XXX.
  .XX.
  ........
  ........
  XXXXXXX.
  .....XX.
  XXXX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6e, 0xe0},
  /*
  .XX.
  XXX.
  XXX.
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XX.
  .....XX.
  XXXXXXX.
  ........
  ........
  ........
  */
#ifdef PFONT_IDRAWBAR
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXX.
  ........
  ........
  ........
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
#else 
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  */
  {0x00, 0x0e},
  /*
  ....
  ....
  ....
  XXX.
  ........
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  */
#endif
  {0x0c, 0x44},
  /*
  ....
  XX..
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x00},
  /*
  .X..
  .XXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x00},
  /*
  .X..
  XXXX
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0x44},
  /*
  ....
  XXXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x47, 0x44},
  /*
  .X..
  .XXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x0f, 0x00},
  /*
  ....
  XXXX
  ....
  ....
  ........
  ........
  ........
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x4f, 0x44},
  /*
  .X..
  XXXX
  .X..
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
#ifdef PFONT_IDRAWBAR
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
#else
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x00, 0x4e},
  /*
  ....
  ....
  .X..
  XXX.
  ........
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
#endif
  {0x67, 0x70},
  /*
  .XX.
  .XXX
  .XXX
  ....
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XXXXXX
  ........
  ........
  ........
  */
  {0x07, 0x76},
  /*
  ....
  .XXX
  .XXX
  .XX.
  ........
  ........
  ..XXXXXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x6f, 0xf0},
  /*
  .XX.
  XXXX
  XXXX
  ....
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x0f, 0xf6},
  /*
  ....
  XXXX
  XXXX
  .XX.
  ........
  ........
  XXXXXXXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x67, 0x76},
  /*
  .XX.
  .XXX
  .XXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XXX
  ..XX....
  ..XX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0x0f, 0xf0},
  /*
  ....
  XXXX
  XXXX
  ....
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x6f, 0xf6},
  /*
  .XX.
  XXXX
  XXXX
  .XX.
  ..XX.XX.
  ..XX.XX.
  XXXX.XXX
  ........
  XXXX.XXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
#ifdef PFONT_IDRAWBAR
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ...XX...
  ...XX...
  XXXXXXXX
  ........
  XXXXXXXX
  ........
  ........
  ........
  */
  {0x40, 0x00},
  /*
  .X..
  ....
  ....
  ....
  XXXXXXXX.
  .........
  .........
  .........
  .........
  .........
  .........
  .........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ........
  ........
  */
  {0xe0, 0x00},
  /*
  XXX.
  ....
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  XXXXXXXX
  ........
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xe4, 0x00},
  /*
  XXX.
  .X..
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  ........
  org
  ........
  ........
  ........
  ........
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0x00},
  /*
  XXX.
  XXX.
  ....
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  ........
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XXXXXX
  ........
  ........
  ........
  */
  {0xee, 0x40},
  /*
  XXX.
  XXX.
  .X..
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  ........
  org
  ...XX...
  ...XX...
  ...XXXXX
  ...XX...
  ...XXXXX
  ........
  ........
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  ........
  org
  ........
  ........
  ...XXXXX
  ...XX...
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xee, 0xe4},
  /*
  XXX.
  XXX.
  XXX.
  .X..
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  ........
  org
  ........
  ........
  ........
  ........
  ..XXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
  {0xee, 0xee},
  /*
  XXX.
  XXX.
  XXX.
  XXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  org
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  XXXXXXXX
  ..XX.XX.
  ..XX.XX.
  ..XX.XX.
  */
#else
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x00, 0xee},
  /*
  ....
  ....
  XXX.
  XXX.
  ........
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x04, 0xee},
  /*
  ....
  .X..
  XXX.
  XXX.
  ........
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x0e, 0xee},
  /*
  ....
  XXX.
  XXX.
  XXX.
  ........
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  XXX.
  ........
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
  {0xee, 0xee},
  /*
  XXX.
  XXX.
  XXX.
  XXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  XXXXXXX.
  */
#endif
  {0x4f, 0xf4},
  /*
  .X..
  XXXX
  XXXX
  .X..
  ...XX...
  ...XX...
  XXXXXXXX
  ...XX...
  XXXXXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0x4c, 0x00},
  /*
  .X..
  XX..
  ....
  ....
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XXXXX...
  ........
  ........
  ........
  */
  {0x07, 0x44},
  /*
  ....
  .XXX
  .X..
  .X..
  ........
  ........
  ........
  ........
  ...XXXXX
  ...XX...
  ...XX...
  ...XX...
  */
  {0xff, 0xff},
  /*
  XXXX
  XXXX
  XXXX
  XXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0x00, 0xff},
  /*
  ....
  ....
  XXXX
  XXXX
  ........
  ........
  ........
  ........
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  */
  {0xcc, 0xcc},
  /*
  XX..
  XX..
  XX..
  XX..
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  XXXX....
  */
  {0x33, 0x33},
  /*
  ..XX
  ..XX
  ..XX
  ..XX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  ....XXXX
  */
  {0xff, 0x00},
  /*
  XXXX
  XXXX
  ....
  ....
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  XXXXXXXX
  ........
  ........
  ........
  ........
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ........
  ........
  .XXX.XX.
  XX.XXX..
  XX..X...
  XX.XXX..
  .XXX.XX.
  ........
  */
  {0xee, 0xa0},
  /*
  XXX.
  XXX.
  X.X.
  ....
  .XXXX... German double S
  XX..XX..
  XX..XX..
  XX.XX...
  XX..XX..
  XX...XX.
  XX...XX.
  ........
  */
  {0xea, 0x80},
  /*
  XXX.
  X.X.
  X...
  ....
  XXXXXX..
  XX..XX..
  XX......
  XX......
  XX......
  XX......
  XX......
  ........
  */
  {0xec, 0xc0},
  /*
  XXX.
  XX..
  XX..
  ....
  ........ PI
  XXXXXXX.
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  */
  {0xe8, 0xe0},
  /*
  XXX.
  X...
  XXX.
  ....
  XXXXXX..
  XX..XX..
  .XX.....
  ..XX....
  .XX.....
  XX..XX..
  XXXXXX...
  .........
  */
  {0x6a, 0x40},
  /*
  .XX.
  X.X.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX...
  XX.XX...
  XX.XX...
  .XXX....
  ........
  */
  {0xaa, 0xe8},
  /*
  X.X.
  X.X.
  XXX.
  X...
  ........
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XX..XX.
  .XXXXX..
  .XX.....
  XX......
  */
  {0x44, 0x40},
  /*
  .X..
  .X..
  .X..
  ....
  ........I + tilda
  .XXX.XX.
  XX.XXX..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ........
  */
  {0xe4, 0x4e},
  /*
  XXX.
  .X..
  .X..
  XXX.
  XXXXXX..
  ..XX....
  .XXXX...
  XX..XX..
  XX..XX..
  .XXXX...
  ..XX....
  XXXXXX...
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XXXXXXX.
  XX...XX.
  .XX.XX..
  ..XXX...
  ........
  */
  {0x4a, 0xa0},
  /*
  .X..
  X.X.
  X.X.
  ....
  ..XXX...
  .XX.XX..
  XX...XX.
  XX...XX.
  .XX.XX..
  .XX.XX..
  XXX.XXX.
  ........
  */
  {0x64, 0xa4},
  /*
  .XX.
  .X..
  X.X.
  .X..
  ...XXX..
  ..XX....
  ...XX...
  .XXXXX..
  XX..XX..
  XX..XX..
  .XXXX...
  ........
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ........
  ........
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  ........
  ........
  */
  {0x6e, 0xc0},
  /*
  .XX.
  XXX.
  XX..
  ....
  .....XX.
  ....XX..
  .XXXXXX.
  XX.XX.XX
  XX.XX.XX
  .XXXXXX.
  .XX.....
  XX......
  */
  {0x6c, 0x60},
  /*
  .XX.
  XX..
  .XX.
  ....
  ..XXX...
  .XX.....
  XX......
  XXXXX...
  XX......
  .XX.....
  ..XXX...
  .........
  */
  {0xea, 0xa0},
  /*
  XXX.
  X.X.
  X.X.
  ....
  .XXXX...
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  XX..XX..
  ........
  */
  {0xee, 0xe0},
  /*
  XXX.
  XXX.
  XXX.
  ....
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  XXXXXX..
  ........
  ........
  */
  {0x4e, 0xee},
  /*
  .X..
  XXX.
  XXX.
  ....
  ..XX....
  ..XX....
  XXXXXX..
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  */
  {0x42, 0x40},
  /*
  .X..
  ..X.
  .X..
  ....
  .XX.....
  ..XX....
  ...XX...
  ..XX....
  .XX.....
  ........
  XXXXXX..
  ........
  */
  {0x24, 0x20},
  /*
  ..X.
  .X..
  ..X.
  ....
  ...XX...
  ..XX....
  .XX.....
  ..XX....
  ...XX...
  ........
  XXXXXX..
  ........
  */
  {0x2a, 0x44},
  /*
  ..X.
  .X.X.
  .X...
  .X...
  ....XXX.
  ...XX.XX
  ...XX.XX
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  */
  {0x22, 0xa4},
  /*
  ..X.
  ..X.
  X.X.
  .X..
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  ...XX...
  XX.XX...
  XX.XX...
  .XXX....
  */
  {0x4e, 0x40},
  /*
  .X..
  XXX.
  .X..
  ....
  ..XX....
  ..XX....
  ........
  XXXXXX..
  ........
  ..XX....
  ..XX....
  ........
  */
  {0xe0, 0xe0},
  /*
  XXX.
  ....
  XXX.
  ....
  ........
  .XXX.XX.
  XX.XXX..
  ........
  .XXX.XX.
  XX.XXX..
  ........
  ........
  */
  {0x4a, 0x40},
  /*
  .X..
  X.X.
  .X..
  ....
  ..XXX...
  .XX.XX..
  .XX.XX..
  ..XXX...
  ........
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ...XX...
  ...XX...
  ........
  ........
  ........
  */
  {0x04, 0x00},
  /*
  ....
  .X..
  ....
  ....
  ........
  ........
  ........
  ........
  ...XX...
  ........
  ........
  ........
  */
  {0x32, 0xa6},
  /*
  ..XX
  ..X.
  X.X.
  .XX.
  ....XXXX
  ....XX..
  ....XX..
  ....XX..
  XXX.XX..
  .XX.XX..
  ..XXXX..
  ...XXX..
  */
  {0xea, 0x00},
  /*
  XXX.
  X.X.
  ....
  ....
  .XXXX...
  .XX.XX..
  .XX.XX..
  .XX.XX..
  .XX.XX..
  ........
  ........
  ........
  */
  {0x62, 0x4e},
  /*
  .XX.
  ..X.
  .X..
  XXX.
  .XXX....
  ...XX...
  ..XX....
  .XX.....
  .XXXX...
  ........
  ........
  ........
  */
  {0x06, 0x60},
  /*
  ....
  .XX.
  .XX.
  ....
  ........
  ........
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ..XXXX..
  ........
  ........
  */
  {0x00, 0x00}
  /*
  ....
  ....
  ....
  ....
  ........
  ........
  ........
  ........
  ........
  ........
  ........
  */
};























unsigned char plFont88[256][8]=
{
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E},
  {0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E},
  {0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00},
  {0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00},
  {0x38,0x7C,0x38,0xFE,0xFE,0x7C,0x38,0x7C},
  {0x10,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x7C},
  {0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00},
  {0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF},
  {0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00},
  {0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF},
  {0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78},
  {0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18},
  {0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0},
  {0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0},
  {0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99},
  {0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00},
  {0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00},
  {0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18},
  {0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00},
  {0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00},
  {0x3E,0x63,0x38,0x6C,0x6C,0x38,0xCC,0x78},
  {0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00},
  {0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF},
  {0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00},
  {0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00},
  {0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00},
  {0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00},
  {0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00},
  {0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00},
  {0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00},
  {0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00},
  {0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00},
  {0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00},
  {0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00},
  {0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00},
  {0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00},
  {0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00},
  {0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00},
  {0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00},
  {0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00},
  {0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60},
  {0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00},
  {0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00},
  {0x7C,0xC6,0xCE,0xDE,0xF6,0xE6,0x7C,0x00},
  {0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00},
  {0x78,0xCC,0x0C,0x38,0x60,0xCC,0xFC,0x00},
  {0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00},
  {0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00},
  {0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00},
  {0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00},
  {0xFC,0xCC,0x0C,0x18,0x30,0x30,0x30,0x00},
  {0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00},
  {0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00},
  {0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00},
  {0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60},
  {0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00},
  {0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00},
  {0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00},
  {0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00},
  {0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00},
  {0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00},
  {0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00},
  {0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00},
  {0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00},
  {0xFE,0x62,0x68,0x78,0x68,0x62,0xFE,0x00},
  {0xFE,0x62,0x68,0x78,0x68,0x60,0xF0,0x00},
  {0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00},
  {0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00},
  {0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
  {0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00},
  {0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00},
  {0xF0,0x60,0x60,0x60,0x62,0x66,0xFE,0x00},
  {0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0x00},
  {0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00},
  {0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00},
  {0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00},
  {0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00},
  {0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE6,0x00},
  {0x78,0xCC,0xE0,0x70,0x1C,0xCC,0x78,0x00},
  {0xFC,0xB4,0x30,0x30,0x30,0x30,0x78,0x00},
  {0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00},
  {0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00},
  {0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00},
  {0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00},
  {0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00},
  {0xFE,0xC6,0x8C,0x18,0x32,0x66,0xFE,0x00},
  {0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00},
  {0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00},
  {0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00},
  {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},
  {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00},
  {0xE0,0x60,0x60,0x7C,0x66,0x66,0xDC,0x00},
  {0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00},
  {0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00},
  {0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00},
  {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00},
  {0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x0C,0x00,0x0C,0x0C,0x0C,0xCC,0xCC,0x78},
  {0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00},
  {0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
  {0x00,0x00,0xCC,0xFE,0xFE,0xD6,0xC6,0x00},
  {0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00},
  {0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00},
  {0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0},
  {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E},
  {0x00,0x00,0xDC,0x76,0x66,0x60,0xF0,0x00},
  {0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00},
  {0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00},
  {0x00,0x00,0xC6,0xD6,0xFE,0xFE,0x6C,0x00},
  {0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00},
  {0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00},
  {0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00},
  {0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00},
  {0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00},
  {0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00},
  {0x78,0xCC,0xC0,0xCC,0x78,0x18,0x0C,0x78},
  {0x00,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x1C,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0x7E,0xC3,0x3C,0x06,0x3E,0x66,0x3F,0x00},
  {0xCC,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0xE0,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x30,0x30,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x00,0x00,0x78,0xC0,0xC0,0x78,0x0C,0x38},
  {0x7E,0xC3,0x3C,0x66,0x7E,0x60,0x3C,0x00},
  {0xCC,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0xE0,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},
  {0xCC,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x7C,0xC6,0x38,0x18,0x18,0x18,0x3C,0x00},
  {0xE0,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0xC6,0x38,0x6C,0xC6,0xFE,0xC6,0xC6,0x00},
  {0x30,0x30,0x00,0x78,0xCC,0xFC,0xCC,0x00},
  {0x1C,0x00,0xFC,0x60,0x78,0x60,0xFC,0x00},
  {0x00,0x00,0x7F,0x0C,0x7F,0xCC,0x7F,0x00},
  {0x3E,0x6C,0xCC,0xFE,0xCC,0xCC,0xCE,0x00},
  {0x78,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0xE0,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x78,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xE0,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xCC,0x00,0xCC,0xCC,0x7C,0x0C,0xF8},
  {0xC3,0x18,0x3C,0x66,0x66,0x3C,0x18,0x00},
  {0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00},
  {0x18,0x18,0x7E,0xC0,0xC0,0x7E,0x18,0x18},
  {0x38,0x6C,0x64,0xF0,0x60,0xE6,0xFC,0x00},
  {0xCC,0xCC,0x78,0xFC,0x30,0xFC,0x30,0x30},
  {0xF8,0xCC,0xCC,0xFA,0xC6,0xCF,0xC6,0xC7},
  {0x0E,0x1B,0x18,0x3C,0x18,0x18,0xD8,0x70},
  {0x1C,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00},
  {0x38,0x00,0x70,0x30,0x30,0x30,0x78,0x00},
  {0x00,0x1C,0x00,0x78,0xCC,0xCC,0x78,0x00},
  {0x00,0x1C,0x00,0xCC,0xCC,0xCC,0x7E,0x00},
  {0x00,0xF8,0x00,0xF8,0xCC,0xCC,0xCC,0x00},
  {0xFC,0x00,0xCC,0xEC,0xFC,0xDC,0xCC,0x00},
  {0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00},
  {0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00},
  {0x30,0x00,0x30,0x60,0xC0,0xCC,0x78,0x00},
  {0x00,0x00,0x00,0xFC,0xC0,0xC0,0x00,0x00},
  {0x00,0x00,0x00,0xFC,0x0C,0x0C,0x00,0x00},
  {0xC3,0xC6,0xCC,0xDE,0x33,0x66,0xCC,0x0F},
  {0xC3,0xC6,0xCC,0xDB,0x37,0x6F,0xCF,0x03},
  {0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00},
  {0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00},
  {0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00},
  {0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88},
  {0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA},
  {0xDB,0x77,0xDB,0xEE,0xDB,0x77,0xDB,0xEE},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18},
#ifdef PFONT_IDRAWBAR
  /*{0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe},
  /*{0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
  /*{0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe},
#else
  /*{0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe},
  /*{0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe},
#endif
  {0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36},
  {0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00},
#ifdef PFONT_IDRAWBAR
  /*{0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe},
#else 
  /*{0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
  /*{0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
#endif
  {0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00},
  {0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18},
  {0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00},
  {0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18},
#ifdef PFONT_IDRAWBAR
  /*{0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#else
  /*{0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe},
#endif
  {0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00},
  {0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36},
  {0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36},
  {0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36},
  {0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00},
  {0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36},
#ifdef PFONT_IDRAWBAR
  /*{0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00},*/{0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18},*/{0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00},
  /*{0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00},
  /*{0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00},
  /*{0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#else
  /*{0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#endif
  {0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF},
  {0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0},
  {0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F},
  {0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x76,0xDC,0xC8,0xDC,0x76,0x00},
  {0x78,0xCC,0xCC,0xD8,0xC6,0xC6,0xCC,0x00},
  {0xFC,0xCC,0xC0,0xC0,0xC0,0xC0,0xC0,0x00},
  {0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x00},
  {0xFC,0xCC,0x60,0x30,0x60,0xCC,0xFC,0x00},
  {0x00,0x00,0x7E,0xD8,0xD8,0xD8,0x70,0x00},
  {0x00,0x66,0x66,0x66,0x66,0x7C,0x60,0xC0},
  {0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x00},
  {0xFC,0x30,0x78,0xCC,0xCC,0x78,0x30,0xFC},
  {0x38,0x6C,0xC6,0xFE,0xC6,0x6C,0x38,0x00},
  {0x38,0x6C,0xC6,0xC6,0x6C,0x6C,0xEE,0x00},
  {0x1C,0x30,0x18,0x7C,0xCC,0xCC,0x78,0x00},
  {0x00,0x00,0x7E,0xDB,0xDB,0x7E,0x00,0x00},
  {0x06,0x0C,0x7E,0xDB,0xDB,0x7E,0x60,0xC0},
  {0x38,0x60,0xC0,0xF8,0xC0,0x60,0x38,0x00},
  {0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x00},
  {0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0x00},
  {0x30,0x30,0xFC,0x30,0x30,0x00,0xFC,0x00},
  {0x60,0x30,0x18,0x30,0x60,0x00,0xFC,0x00},
  {0x18,0x30,0x60,0x30,0x18,0x00,0xFC,0x00},
  {0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x70},
  {0x30,0x30,0x00,0xFC,0x00,0x30,0x30,0x00},
  {0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00},
  {0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00},
  {0x0F,0x0C,0x0C,0x0C,0xEC,0x6C,0x3C,0x1C},
  {0x78,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00},
  {0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

unsigned char plFont816[256][16]=
{
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7E,0x81,0xA5,0x81,0x81,0xBD,0x99,0x81,0x81,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7E,0xFF,0xDB,0xFF,0xFF,0xC3,0xE7,0xFF,0xFF,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x6C,0xFE,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x18,0x3C,0x3C,0xE7,0xE7,0xE7,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x7E,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,0x00,0x00,0x00,0x00},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0x00,0x00,0x1E,0x0E,0x1A,0x32,0x78,0xCC,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x66,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3F,0x33,0x3F,0x30,0x30,0x30,0x30,0x70,0xF0,0xE0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7F,0x63,0x7F,0x63,0x63,0x63,0x63,0x67,0xE7,0xE6,0xC0,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x18,0x18,0xDB,0x3C,0xE7,0x3C,0xDB,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xFE,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00},
  {0x00,0x02,0x06,0x0E,0x1E,0x3E,0xFE,0x3E,0x1E,0x0E,0x06,0x02,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x66,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7F,0xDB,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,0x00,0x00,0x00},
  {0x00,0x7C,0xC6,0x60,0x38,0x6C,0xC6,0xC6,0x6C,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x28,0x6C,0xFE,0x6C,0x28,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x10,0x38,0x38,0x7C,0x7C,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xFE,0xFE,0x7C,0x7C,0x38,0x38,0x10,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x3C,0x3C,0x3C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x00,0x00,0x00,0x00},
  {0x18,0x18,0x7C,0xC6,0xC2,0xC0,0x7C,0x06,0x06,0x86,0xC6,0x7C,0x18,0x18,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xC2,0xC6,0x0C,0x18,0x30,0x60,0xC6,0x86,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x38,0x6C,0x6C,0x38,0x76,0xDC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x02,0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0xCE,0xDE,0xF6,0xE6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0x06,0x0C,0x18,0x30,0x60,0xC0,0xC6,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xFC,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x38,0x60,0xC0,0xC0,0xFC,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFE,0xC6,0x06,0x06,0x0C,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x0C,0x78,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xDE,0xDE,0xDE,0xDC,0xC0,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xF8,0x6C,0x66,0x66,0x66,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xDE,0xC6,0xC6,0x66,0x3A,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xE6,0x66,0x66,0x6C,0x78,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xDE,0x7C,0x0C,0x0E,0x00,0x00},
  {0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7C,0xC6,0xC6,0x60,0x38,0x0C,0x06,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x10,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0xEE,0x6C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0xC6,0x6C,0x7C,0x38,0x38,0x7C,0x6C,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFE,0xC6,0x86,0x0C,0x18,0x30,0x60,0xC2,0xC6,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x06,0x02,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,0x00},
  {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00},
  {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xE0,0x60,0x60,0x78,0x6C,0x66,0x66,0x66,0x66,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC0,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x1C,0x0C,0x0C,0x3C,0x6C,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0xCC,0x78,0x00},
  {0x00,0x00,0xE0,0x60,0x60,0x6C,0x76,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x06,0x06,0x00,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3C,0x00},
  {0x00,0x00,0xE0,0x60,0x60,0x66,0x6C,0x78,0x78,0x6C,0x66,0xE6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xEC,0xFE,0xD6,0xD6,0xD6,0xD6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0x0C,0x1E,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0x60,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x10,0x30,0x30,0xFC,0x30,0x30,0x30,0x30,0x36,0x1C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0x6C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xFE,0xCC,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x0E,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x70,0x18,0x18,0x18,0x0E,0x18,0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x0C,0x06,0x7C,0x00,0x00},
  {0x00,0x00,0xCC,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x0C,0x18,0x30,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xCC,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x60,0x30,0x18,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x38,0x6C,0x38,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x3C,0x66,0x60,0x60,0x66,0x3C,0x0C,0x06,0x3C,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x66,0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x18,0x3C,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x60,0x30,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0xC6,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x38,0x6C,0x38,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x18,0x30,0x60,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x6C,0xFE,0xB2,0x32,0x7E,0xD8,0xD8,0x6E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x3E,0x6C,0xCC,0xCC,0xFE,0xCC,0xCC,0xCC,0xCC,0xCE,0x00,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x30,0x78,0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x60,0x30,0x18,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xC6,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0x78,0x00},
  {0x00,0xC6,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0xC6,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x18,0x18,0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xE6,0xFC,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x66,0x66,0x3C,0x18,0x7E,0x18,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0xF8,0xCC,0xCC,0xF8,0xC4,0xCC,0xDE,0xCC,0xCC,0xCC,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x0E,0x1B,0x18,0x18,0x18,0x7E,0x18,0x18,0x18,0x18,0x18,0xD8,0x70,0x00,0x00},
  {0x00,0x18,0x30,0x60,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x0C,0x18,0x30,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x18,0x30,0x60,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x18,0x30,0x60,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x76,0xDC,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00},
  {0x76,0xDC,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00},
  {0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x60,0xDC,0x86,0x0C,0x18,0x3E,0x00,0x00},
  {0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x66,0xCE,0x9E,0x3E,0x06,0x06,0x00,0x00},
  {0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x18,0x3C,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x36,0x6C,0xD8,0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xD8,0x6C,0x36,0x6C,0xD8,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44},
  {0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA},
  {0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
#ifdef PFONT_IDRAWBAR
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#else
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe},
#endif
  {0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
#ifdef PFONT_IDRAWBAR
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#else
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe},
#endif
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
#ifdef PFONT_IDRAWBAR
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#else
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#endif
  {0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
  {0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},
#ifdef PFONT_IDRAWBAR
  /*{0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00},
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00,0x00},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#else
  /*{0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},*/{0x00,0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},*/{0x00,0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0x00,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
  /*{0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36},*/{0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
#endif
  {0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
  {0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0},
  {0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F},
  {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0xD8,0xD8,0xD8,0xDC,0x76,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x78,0xCC,0xCC,0xCC,0xD8,0xCC,0xC6,0xC6,0xC6,0xCC,0x00,0x00,0x00,0x00},
  {0x00,0x00,0xFE,0xC6,0xC6,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0xFE,0xC6,0x60,0x30,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7E,0xD8,0xD8,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xC0,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x7E,0x18,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0x6C,0x38,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x6C,0x6C,0x6C,0xEE,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x1E,0x30,0x18,0x0C,0x3E,0x66,0x66,0x66,0x66,0x3C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x7E,0xDB,0xDB,0xDB,0x7E,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x03,0x06,0x7E,0xDB,0xDB,0xF3,0x7E,0x60,0xC0,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x1C,0x30,0x60,0x60,0x7C,0x60,0x60,0x60,0x30,0x1C,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0xFF,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00,0x7E,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x0E,0x1B,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
  {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0xEC,0x6C,0x6C,0x3C,0x1C,0x00,0x00,0x00,0x00},
  {0x00,0xD8,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x70,0xD8,0x30,0x60,0xC8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};
