/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * pak binfile (handles files in opencp's CP.PAK file)
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -fd981207   Felix Domke <tmbinc@gmx.net>
 *    -edited for new binfile
 *  -ss040601   Stian Skjelstad <stian@nixia.no>
 *    -rewritten to use FILE * instead of binfile
 */

#define NO_CPDLL_IMPORT
#include "config.h"
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <unistd.h>
#include "types.h"
#include "binfpak.h"
#include "stuff/err.h"
#include "boot/psetting.h"

struct __attribute__((packed)) packdirentry
{
  char name[0x38];
  long off;
  long len;
};

static int nfiles;
static struct packdirentry *dir;
static FILE *packfile=NULL;

FILE *pakfOpen(char *name)
{
	int i;
	FILE *retval;
	char *tmpname;
	if (!packfile)
		return NULL;
	for (i=0;i<nfiles;i++)
		if (!strcasecmp(name, dir[i].name))
			break;
	if (i==nfiles)
		return NULL;
	fseek(packfile, dir[i].off, SEEK_SET);
	retval=fopen(tmpname=tmpnam(NULL), "w+");
	if (!retval)
		return NULL;
	unlink(tmpname);
	tmpname=malloc(dir[i].len);
	fread(tmpname, dir[i].len, 1, packfile);
	fwrite(tmpname, dir[i].len, 1, retval);
	free(tmpname);
	fseek(retval, 0, SEEK_SET);
	return retval;
}

int pakfInit(void)
{
	char path[PATH_MAX+1];
	int tmp;
	int o;
	int i,j;

	strcpy(path, cfDataDir);
	strcat(path, "cp.pak");
	nfiles=0;
	dir=0;
	if (!(packfile=fopen(path, "r")))
	{
		perror("fopen()");
		fprintf(stderr, "cp.pak: failed to open: %s\n", path);
		return errOk;
	}
	fread(&tmp, sizeof(tmp), 1, packfile);
	if (tmp!=0x4B434150)
		goto error_out;
	if (!fread(&o, sizeof(o), 1, packfile))
		goto error_out;
	if (!fread(&nfiles, sizeof(nfiles), 1, packfile))
		goto error_out;
	nfiles/=0x40;
	if (!nfiles)
		goto error_out;
	dir=calloc(sizeof(dir[0]), nfiles);
	fseek(packfile, o, SEEK_SET);
	fread(dir, sizeof(dir[0]), nfiles, packfile);
	for (i=0; i<nfiles; i++)
	{
		for (j=0; j<0x38; j++)
			if (dir[i].name[j]=='\\')   /* we are hardcore unix folks */
				dir[i].name[j]='/';
	}
	if (fcntl(fileno(packfile), F_SETFD, FD_CLOEXEC))
		perror("fcntl(fileno, F_SETFD, FD_CLOEXEC)");

	return errOk;
error_out:
	fprintf(stderr, "cp.pak invalid\n");
	fclose(packfile);
	packfile=NULL;
	return errOk;
}

void pakfClose(void)
{
	if (packfile)
	{
		free(dir);
		fclose(packfile);
	}
	packfile=NULL;
}
