/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * CPIface main interface code
 *
 * revision history: (please note changes here)
 *  -cp1.7   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb_in_between   Tammo Hinrichs <opencp@gmx.net>
 *    -reintegrated it into OpenCP, 'coz it r00ls ;)
 *  -fd980717  Felix Domke <tmbinc@gmx.net>
 *    -added Wuerfel Mode ][ (320x200)
 */

#include "config.h"
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "types.h"
#include "stuff/poutput.h"
#include "boot/pmain.h"
#include "cpiface.h"
#include "stuff/timer.h"
#include "boot/psetting.h"
#include <curses.h>

static unsigned char (*plWuerfel)=NULL;
char plWuerfelDirect;
static char wuerfelpal[720];
static short wuerfelpos;
unsigned long wuerfeltnext;
static unsigned long wuerfelscroll;
static unsigned short wuerfelstframes;
static unsigned short wuerfelframes;
static unsigned short wuerfelrle;
static unsigned short wuerfeldlt;
static unsigned char wuerfellowmem;
static unsigned char *wuerfelloadedframes;
static unsigned short *wuerfelframelens;
static unsigned long *wuerfelframepos;
static unsigned short *wuerfelcodelens;
static unsigned long wuerfelframe0pos;
static unsigned long wuerfelframesize;
static unsigned long wuerfelscanlines, wuerfellinelength, wuerfelversion;
static short wuerfelfile;
static unsigned char *wuerfelframebuf;
static unsigned long cfUseAnis=0xFFFFFFFF;

static void memcpyintr(char *d, const char *s, unsigned long l)
{
	do {
		*d=*s;
		d++;
		*d=*s;
		d+=3;
		s++;
		*d=*s;
		d++;
		*d=*s;
		d+=3;
		s+=3;
		l-=2;
	} while(l);
}

static int plCloseWuerfel(void)
{
	if (plWuerfel)
	{
		free(plWuerfel);
		plWuerfel=NULL;
		free(wuerfelcodelens);
		free(wuerfelframelens);
		free(wuerfelframepos);
		free(wuerfelframebuf);
		free(wuerfelloadedframes);
		wuerfelframelens=NULL;
		wuerfelframepos=NULL;
		wuerfelframebuf=NULL;
		wuerfelloadedframes=0;
		if (wuerfelfile)
		{
			close(wuerfelfile);
			wuerfelfile=0;
		}
		return 1;
	}
	return 0;
}

static char plLoadWuerfel(void)
{
	int ifile;
	unsigned char sig[8];
	unsigned short opt, pallen, codelenslen;
	short i;
	unsigned short maxframe;
	unsigned long framemem;

	if (plWuerfel)
		plCloseWuerfel();

	ifile=-1;

	while (cfUseAnis)
	{
		unsigned char use=rand()&31;
		char path[PATH_MAX+1];

		if (!(cfUseAnis&(1<<use)))
			continue;
		snprintf(path, sizeof(path), "%sCPANI0%c%c.DAT", cfDataDir, '0'+use/10, '0'+use%10);
		ifile=open(path, O_RDONLY);
		if (ifile<0)
		{
			snprintf(path, sizeof(path), "%sCPANI0%c%c.DAT", cfConfigDir, '0'+use/10, '0'+use%10);
			ifile=open(path, O_RDONLY);
			if (ifile<0)
				cfUseAnis&=~(1<<use);
			else
				break;
		} else
			break;
	}
	if (ifile<0)
		return 0;

	wuerfelfile=ifile;

	if (read(ifile, sig, 8)!=8)
	{
		plCloseWuerfel();
		return 0;
	}
	if (memcmp(sig, "CPANI\x1A\x00\x00", 8))
	{
		plCloseWuerfel();
		return 0;
	}
	lseek(ifile, 32, SEEK_CUR);

	read(ifile, &wuerfelframes, 2);
	read(ifile, &wuerfelstframes, 2);

	read(ifile, &opt, 2);
	wuerfelrle=opt&1;
	wuerfeldlt=!!(opt&2);
	wuerfelframesize=(opt&4)?64000:16000;
	wuerfelscanlines=(opt&4)?200:100;
	wuerfellinelength=(opt&4)?320:160;
	wuerfelversion=!!(opt&4);

	wuerfelframelens=calloc(sizeof(unsigned short), wuerfelframes+wuerfelstframes);
	wuerfelframepos=calloc(sizeof(unsigned long), wuerfelframes+wuerfelstframes);
	wuerfelframebuf=calloc(sizeof(unsigned char), wuerfelframesize);
	wuerfelloadedframes=calloc(sizeof(unsigned char), wuerfelframes+wuerfelstframes);

	if (!wuerfelframelens||!wuerfelframepos||!wuerfelframebuf||!wuerfelloadedframes)
	{
		plCloseWuerfel();
		return 0;
	}

	lseek(ifile, 2, SEEK_CUR);
	read(ifile, &codelenslen, 2);
	wuerfelcodelens=calloc(sizeof(unsigned short), codelenslen);
	if (!wuerfelcodelens)
	{
		plCloseWuerfel();
		return 0;
	}
	read(ifile, &pallen, 2);
	read(ifile, wuerfelframelens, 2*(wuerfelframes+wuerfelstframes));

	if(wuerfelversion)
		read(ifile, wuerfelcodelens, codelenslen);
	else
		lseek(ifile, codelenslen, SEEK_CUR);

	read(ifile, wuerfelpal, pallen);

	memset(wuerfelloadedframes, 0, wuerfelframes+wuerfelstframes);
	wuerfelframepos[0]=0;
	maxframe=0;
	for (i=1; i<(wuerfelframes+wuerfelstframes); i++)
	{
		if (maxframe<wuerfelframelens[i-1])
			maxframe=wuerfelframelens[i-1];
		wuerfelframepos[i]=wuerfelframepos[i-1]+wuerfelframelens[i-1];
	}

	if (maxframe<wuerfelframelens[i-1])
		maxframe=wuerfelframelens[i-1];

	framemem=wuerfelframepos[i-1]+wuerfelframelens[i-1];

	plWuerfel=calloc(sizeof(unsigned char),  framemem);

	wuerfelframe0pos=lseek(ifile, 0, SEEK_CUR);

	if (plWuerfel)
	{
		wuerfellowmem=0;
		/* do preload, if desired! */
	} else {
		for (i=0; i<wuerfelstframes; i++)
			framemem-=wuerfelframelens[i];
		plWuerfel=calloc(sizeof(unsigned char), framemem);
		if (plWuerfel)
			wuerfellowmem=1;
		else {
			free(wuerfelloadedframes);
			wuerfelloadedframes=0;
			wuerfellowmem=2;
			plWuerfel=calloc(sizeof(unsigned char), maxframe);
			if (!plWuerfel)
			{
				plCloseWuerfel();
				return 0;
			}
		}
	}

	return 1;
}




static void plPrepareWuerfel()
{
	vga13();
/*	if(!wuerfelversion)
	{
		outp(0x3c4, 4);
		outp(0x3c5, (inp(0x3c5)&~8)|4);
		outp(0x3d4, 0x14);
		outp(0x3d5, inp(0x3d5)&~0x40);
		outp(0x3d4, 0x17);
		outp(0x3d5, inp(0x3d5)|0x40);
		outp(0x3d4, 0x09);
		outp(0x3d5, inp(0x3d5)|2);
		 outpw(0x3c4, 0x0F02);
	}
	memset((char*)0xA0000, 0, 65536);
	*/
	int i;
	for (i=16; i<256; i++)
		gupdatepal(i, wuerfelpal[i*3-48], wuerfelpal[i*3+1-48], wuerfelpal[i*3+2-48]);
	gflushpal();
	wuerfelpos=0;
	wuerfeltnext=0;
	wuerfelscroll=0;
/* This was commented out
    outpw(0x3c4, 0x0302);
    memcpyintr((void*)(0xA0000+80*24), plWuerfel[wuerfelpos], 160*76/2);
    outpw(0x3c4, 0x0C02);
    memcpyintr((void*)(0xA0000+80*24), plWuerfel[wuerfelpos]+1, 160*76/2);
*/
}

static void decodrle(unsigned char *rp, unsigned short rbuflen)
{
	unsigned char *op=wuerfelframebuf;
	unsigned char *re=rp+rbuflen;
	while (rp<re)
	{
		unsigned char c=*rp++;
		if (c<=0x0F)
		{
			memset(op, *rp++, c+3);
			op+=c+3;
		}  else
			*op++=c;
	}
}

static void decodrledlt(unsigned char *rp, unsigned short rbuflen)
{
	unsigned char *op=wuerfelframebuf;
	unsigned char *re=rp+rbuflen;
	while (rp<re)
	{
		unsigned char c=*rp++;
		if (c<=0x0E)
		{
			unsigned char c2=*rp++;
			if (c2!=0x0F)
				memset(op, c2, c+3);
			op+=c+3;
		} else {
			if (c!=0x0F)
				*op=c;
			op++;
		}
	}
}

static void wuerfelDraw(void)
{
	short i;
	unsigned char *curframe;
	unsigned short framelen;

	if (tmGetTimer()<(wuerfeltnext+(wuerfelversion?wuerfelcodelens[wuerfelpos]:3072)))
		return;

	wuerfeltnext=tmGetTimer();

	if(!wuerfelversion)
	{
		/* TODO-vga-mode-stuff
		outp(0x3c4, 4);
		outp(0x3c5, inp(0x3c5)&~8);  */
	}

	if (wuerfeldlt)
		plWuerfelDirect=0;

	if (wuerfelpos<wuerfelstframes)
	{
		plWuerfelDirect=0;
		wuerfelscroll=wuerfelscanlines;
	}

	framelen=wuerfelframelens[wuerfelpos];
	if (wuerfellowmem==2)
	{
		lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
		read(wuerfelfile, plWuerfel, framelen);
		curframe=plWuerfel;
	} else if (wuerfellowmem==1)
	{
		if (wuerfelpos<wuerfelstframes)
		{
			lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
			read(wuerfelfile, plWuerfel, framelen);
			curframe=plWuerfel;
		} else {
			curframe=plWuerfel+wuerfelframepos[wuerfelpos];
			if (!wuerfelloadedframes[wuerfelpos])
			{
				lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
			        read(wuerfelfile, curframe, framelen);
			        wuerfelloadedframes[wuerfelpos]=1;
			}
		}
	} else {
		curframe=plWuerfel+wuerfelframepos[wuerfelpos];
		if (!wuerfelloadedframes[wuerfelpos])
		{
			lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
			read(wuerfelfile, curframe, framelen);
			wuerfelloadedframes[wuerfelpos]=1;
		}
	}

	if (wuerfeldlt)
		decodrledlt(curframe, framelen);
	else if (wuerfelrle)
		decodrle(curframe, framelen);
	else
		memcpy(wuerfelframebuf, curframe, framelen);

	for (i=0; i<wuerfelscroll; i++)
	{
		if(!wuerfelversion)
		{
			memcpyintr(plVidMem+320*(100+i-wuerfelscroll)*2, (char *)wuerfelframebuf+i*160, 80);
			memcpyintr(plVidMem+320*((100+i-wuerfelscroll)*2+1), (char *)wuerfelframebuf+i*160, 80);
			memcpyintr(plVidMem+320*(100+i-wuerfelscroll)*2+2, (char *)wuerfelframebuf+i*160+1, 80);
			memcpyintr(plVidMem+320*((100+i-wuerfelscroll)*2+1)+2, (char *)wuerfelframebuf+i*160+1, 80);
		} else {
			memcpy(plVidMem+320*(wuerfelscanlines+i-wuerfelscroll),(char *)wuerfelframebuf+i*320, 320);
		}
	}

	if (wuerfelscroll<wuerfelscanlines)
		wuerfelscroll+=(wuerfelversion?2:1);
	if (wuerfelpos<wuerfelstframes)
		wuerfelpos++;
	else
		wuerfelpos=wuerfelstframes+(wuerfelpos-wuerfelstframes+(plWuerfelDirect?(wuerfelframes-1):1))%wuerfelframes;

	plSetGraphPage(0);
}

static int wuerfelKey(unsigned short key)
{
	switch (key)
	{
#if 0
  case 0x9700: /*alt-home*/
  case 0x4700: /*home */
    break;
#endif
		case 9: /* tab */
		/*case 0x0F00:  shift-tab 
		case 0xA500:*/
			plWuerfelDirect=!plWuerfelDirect;
			return 1;
		case 'w': case 'W':
			plLoadWuerfel();
			plPrepareWuerfel();
			return 1;
	}
	return 0;
}

static void wuerfelSetMode(void)
{
	plPrepareWuerfel();
	plScreenChanged=1;
}

static int wuerfelEvent(int ev)
{
	switch (ev)
	{
		case cpievInitAll:
			return 1;
		case cpievInit:
			return plLoadWuerfel();
		case cpievDoneAll:
			plCloseWuerfel();
	}
	return 1;
}

static int wuerfelIProcessKey(unsigned short key)
{
	switch (key)
	{
		case 'w': case 'W':
			if (_vga13)
				cpiSetMode("wuerfel2");
		return 1;
	}
	return 0;
}

struct cpimoderegstruct cpiModeWuerfel = {"wuerfel2", wuerfelSetMode, wuerfelDraw, wuerfelIProcessKey, wuerfelKey, wuerfelEvent};
