/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * sampler system variables / auxiliary routines
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040907   Stian Skjelstad <stian@nixia.no>
 *    -minor buffer cleanups.. Let drivers allocate their own memory
 */

#define NO_SMPBASE_IMPORT

#include "config.h"



#include <stdio.h>

#include <string.h>
#include <stdlib.h>
#include "types.h"
#include "sampler.h"
#include "stuff/imsrtns.h"

#include "mchasm.h"

int smpRate;
int smpOpt;
int smpBufSize;
int (*smpSample)(unsigned char **buf, int *len);
void (*smpStop)();
void (*smpSetOptions)(int rate, int opt);
void (*smpSetSource)(int src);
int (*smpGetBufPos)(void);

static unsigned char stereo;
static unsigned char bit16;
static unsigned char reversestereo;
static unsigned char signedout;
static unsigned long samprate;

/*static __segment dmabufsel;*/
static unsigned char *smpbuf;
static unsigned long buflen;

void smpGetRealMasterVolume(int *l, int *r)
{
	unsigned short len=samprate/20;
	unsigned short p;
	signed long pass2;
/*	unsigned long (*fn)(const void *ch, unsigned long len);*/
	mixAddAbsfn fn;
	unsigned long v;
	
	if (len>buflen)
		len=buflen;
	p=((smpGetBufPos()>>(stereo+bit16))+buflen-len)%buflen;
	pass2=len-buflen+p;

	if (stereo)
	{
		fn=bit16?(signedout?mixAddAbs16SS:mixAddAbs16S):(signedout?mixAddAbs8SS:mixAddAbs8S);

		if (pass2>0)
			v=fn(smpbuf+(p<<(1+bit16)), len-pass2)+fn(smpbuf, pass2);
		else
			v=fn(smpbuf+(p<<(1+bit16)), len);
		v=v*128/(len*16384);
		*l=(v>255)?255:v;

	if (pass2>0)
		v=fn(smpbuf+(p<<(1+bit16))+(1<<bit16), len-pass2)+fn(smpbuf+(1<<bit16), pass2);
	else
		v=fn(smpbuf+(p<<(1+bit16))+(1<<bit16), len);
	v=v*128/(len*16384);
	*r=(v>255)?255:v;
	} else {
		fn=bit16?(signedout?mixAddAbs16MS:mixAddAbs16M):(signedout?mixAddAbs8MS:mixAddAbs8M);

		if (pass2>0)
			v=fn(smpbuf+(p<<bit16), len-pass2)+fn(smpbuf, pass2);
		else
			v=fn(smpbuf+(p<<bit16), len);
		v=v*128/(len*16384);
		*r=*l=(v>255)?255:v;
	}
	if (reversestereo)
	{
		int t=*r;
		*r=*l;
		*l=t;
	}
}

void smpGetMasterSample(short *buf, int len, int rate, int opt)
{
	signed long step=imuldiv(samprate, 0x10000, rate);
	unsigned short maxlen;
	int stereoout;
	unsigned long bp;
	signed long pass2;
/*	void (*fn)(short *buf2, const void *buf, int len, long step);*/
	mixGetMasterSamplefn fn;
	
	if (step<0x1000)
		step=0x1000;
	if (step>0x800000)
		step=0x800000;
	
	maxlen=imuldiv(buflen, 0x10000, step);
	stereoout=(opt&smpGetSampleStereo)?1:0;
	if (len>maxlen)
	{
		memset((short*)buf+(maxlen<<stereoout), 0, (len-maxlen)<<(1+stereoout));
		len=maxlen;
	}

	bp=((smpGetBufPos()>>(stereo+bit16))+buflen-imuldiv(len,step,0x10000))%buflen;
	pass2=len-imuldiv(buflen-bp,0x10000,step);
	if (bit16)
		if (stereo)
			if (!stereoout)
				fn=signedout?mixGetMasterSampleSS16M:mixGetMasterSampleSU16M;
			else if (reversestereo)
				fn=signedout?mixGetMasterSampleSS16SR:mixGetMasterSampleSU16SR;
		else
			fn=signedout?mixGetMasterSampleSS16S:mixGetMasterSampleSU16S;
		else if (!stereoout)
			fn=signedout?mixGetMasterSampleMS16M:mixGetMasterSampleMU16M;
		else
			fn=signedout?mixGetMasterSampleMS16S:mixGetMasterSampleMU16S;
	else if (stereo)
		if (!stereoout)
			fn=signedout?mixGetMasterSampleSS8M:mixGetMasterSampleSU8M;
		else if (reversestereo)
			fn=signedout?mixGetMasterSampleSS8SR:mixGetMasterSampleSU8SR;
		else
			fn=signedout?mixGetMasterSampleSS8S:mixGetMasterSampleSU8S;
	else if (!stereoout)
		fn=signedout?mixGetMasterSampleMS8M:mixGetMasterSampleMU8M;
	else
		fn=signedout?mixGetMasterSampleMS8S:mixGetMasterSampleMU8S;

	if (pass2>0)
	{
		fn(buf, smpbuf+(bp<<(stereo+bit16)), len-pass2, step);
		fn(buf+((len-pass2)<<stereoout), smpbuf, pass2, step);
	} else
		fn(buf, smpbuf+(bp<<(stereo+bit16)), len, step);
}


int smpOpenSampler(void **buf, int *len, int bufl)
{
	int dmalen;

	if (!smpSample)
		return 0;

	dmalen=umuldiv(smpRate<<(!!(smpOpt&SMP_STEREO)+!!(smpOpt&SMP_16BIT)), bufl, 65536)&~15;

	smpbuf=0;
	if (!smpSample(&smpbuf, &dmalen))
		return 0;

	stereo=!!(smpOpt&SMP_STEREO);
	bit16=!!(smpOpt&SMP_16BIT);
	reversestereo=!!(smpOpt&SMP_REVERSESTEREO);
	signedout=!!(smpOpt&SMP_SIGNEDOUT);
	samprate=smpRate;

	buflen=dmalen>>(stereo+bit16);

	*buf=smpbuf;
	*len=buflen;

	return 1;
}

void smpCloseSampler(void)
{
	smpStop();
/*	dmaFree(dmabufsel);*/
}
