/* OpenCP Module Player
 * copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Interface routines for Audio CD player
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040907   Stian Skjelstad <stian@nixia.no>
 *    -removed cdReadDir
 *    -Linux related changes
 */

#include <linux/cdrom.h>
#include "config.h"
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "cdaudio.h"
#include "boot/plinkman.h"
#include "boot/psetting.h"
#include "cpiface/cpiface.h"
#include "filesel/pfilesel.h"
#include "dev/devisamp.h"
#include "dev/sampler.h"
#include "filesel/mdb.h"
#include "stuff/poutput.h"

#include <curses.h>

void _splitpath(const char *src, char *drive, char *path, char *file, char *ext); /* defined in stuff/compat.h but this header clashed with linux/cdrom.h */

static int nodevice; /* do we have a devs */
static char cfCDAtLineIn;
static unsigned long cdpTrackStarts[CDROM_LEADOUT+1];
static unsigned char cdpFirstTrack;
static unsigned char cdpPlayMode; /* 1 = disk, 0 = track */
static unsigned char cdpTrackNum; /* current track, calculated in GStrings */
static unsigned char cdpViewSectors; /* ??? view-option */
static FILE *cdpDrive; /* nasty */
static unsigned long basesec; /* current start... usually a cdpTrack[n] value */
static unsigned long length; /* and the length of it */
static signed long newpos; /* skip to */
static unsigned char setnewpos; /* and the fact we should skip */
static unsigned long curpos; /* current sector */
static char vdev[8];

uint16_t status;

static char *gettimestr(unsigned long s, char *time)
{
	unsigned char csec, sec, min;
	csec=(s%75)*4/3;
	time[8]=0;
	time[7]='0'+csec%10;
	time[6]='0'+csec/10;
	sec=(s/75)%60;
	time[5]=':';
	time[4]='0'+sec%10;
	time[3]='0'+sec/10;
	min=s/(75*60);
	time[2]=':';
	time[1]='0'+min%10;
	time[0]='0'+min/10;
	return time;
}

static void cdaDrawGStrings(uint16_t (*buf)[CONSOLE_MAX_X])
{
	memset(buf[0]+80, 0, (plScrWidth-80)*sizeof(uint16_t));
	memset(buf[1]+80, 0, (plScrWidth-80)*sizeof(uint16_t));
	memset(buf[2]+80, 0, (plScrWidth-80)*sizeof(uint16_t));

	writestring(buf[0], 0, 0x09, "  mode: ..........  ", 20);
      	writestring(buf[0], 8, 0x0F, "cd-audio", 10);
	int i;

	char timestr[9];
	for (i=1; i<=cdpTrackNum; i++)
		if (curpos<cdpTrackStarts[i])
			break;

	writestring(buf[0], 20, 0x09, "playmode: .....  status: .......", plScrWidth-20);
	writestring(buf[0], 30, 0x0F, cdpPlayMode?"disk ":"track", 5);
	writestring(buf[0], 45, 0x0F, (status&STATUS_ERROR)?"  error":(status&STATUS_PLAY)?"playing":" paused", 7);

	writestring(buf[1], 0, 0x09, "drive: ....... start:   :..:..  pos:   :..:..  length:   :..:..  size: ...... kb", plScrWidth);
	writestring(buf[1], 7, 0x0F, vdev, 7); /* VERY TODO.. can we fit more data on this line??? */
	if (cdpViewSectors)
	{
		writenum(buf[1], 22, 0x0F, cdpTrackStarts[0], 10, 8, 0);
		writenum(buf[1], 37, 0x0F, curpos-cdpTrackStarts[0], 10, 8, 0);
		writenum(buf[1], 55, 0x0F, cdpTrackStarts[cdpTrackNum]-cdpTrackStarts[0], 10, 8, 0);
	} else {
		writestring(buf[1], 22, 0x0F, gettimestr(cdpTrackStarts[0]+150, timestr), 8);
		writestring(buf[1], 37, 0x0F, gettimestr(curpos-cdpTrackStarts[0], timestr), 8);
		writestring(buf[1], 55, 0x0F, gettimestr(cdpTrackStarts[cdpTrackNum]-cdpTrackStarts[0], timestr), 8);
	}
	_writenum(buf[1], 71, 0x0F, (cdpTrackStarts[cdpTrackNum]-cdpTrackStarts[0])*147/64, 10, 6);

	writestring(buf[2], 0, 0x09, "track: ..      start:   :..:..  pos:   :..:..  length:   :..:..  size: ...... kb", plScrWidth);
	_writenum(buf[2], 7, 0x0F, i-1+cdpFirstTrack, 10, 2);
	if (cdpViewSectors)
	{
		writenum(buf[2], 22, 0x0F, cdpTrackStarts[i-1]+150, 10, 8, 0);
		writenum(buf[2], 37, 0x0F, curpos-cdpTrackStarts[i-1], 10, 8, 0);
		writenum(buf[2], 55, 0x0F, cdpTrackStarts[i]-cdpTrackStarts[i-1], 10, 8, 0);
	} else {
		writestring(buf[2], 22, 0x0F, gettimestr(cdpTrackStarts[i-1]+150, timestr), 8);
		writestring(buf[2], 37, 0x0F, gettimestr(curpos-cdpTrackStarts[i-1], timestr), 8);
		writestring(buf[2], 55, 0x0F, gettimestr(cdpTrackStarts[i]-cdpTrackStarts[i-1], timestr), 8);
	}
	_writenum(buf[2], 71, 0x0F, (cdpTrackStarts[i]-cdpTrackStarts[i-1])*147/64, 10, 6);
}

static int cdaProcessKey(uint16_t key)
{
	int i;
	switch (key)
	{
		case 'p': case 'P': case KEY_CTRL_P:
			plPause=!plPause;
			if (plPause)
				cdStop(fileno(cdpDrive));
			else
				cdRestart(fileno(cdpDrive));
			break;
/*		case 0x2000:
			cdpPlayMode=1;
			setnewpos=0;
			basesec=cdpTrackStarts[0];
			length=cdpTrackStarts[cdpTrackNum]-basesec;
			//    strcpy(name, "DISK");
			break;*/
		case KEY_UP:
			newpos-=75;
			setnewpos=1;
			break;
		case KEY_DOWN:
		    	newpos+=75;
			setnewpos=1;
			break;
		case KEY_LEFT:
			newpos-=75*10;
			setnewpos=1;
			break;
		case KEY_RIGHT:
			newpos+=75*10;
			setnewpos=1;
			break;
		case KEY_HOME: //home
			if (!cdpPlayMode)
			{
				newpos=0;
				setnewpos=1;
				break;
			}
			for (i=1; i<=cdpTrackNum; i++)
				if (newpos<(cdpTrackStarts[i]-basesec))
					break;
			newpos=cdpTrackStarts[i-1]-basesec;
			setnewpos=1;
			break;
/* TODO-keys	case 0x8D00: //ctrl-up
			newpos-=60*75;
			setnewpos=1;
			break;
		case 0x9100: //ctrl-down
			newpos+=60*75;
			setnewpos=1;
			break;*/
		case '<' /* CTRL_LEFT TODO-keys */:
			if (!cdpPlayMode)
				break;
			for (i=2; i<=cdpTrackNum; i++)
				if (newpos<(cdpTrackStarts[i]-basesec))
					break;
			newpos=cdpTrackStarts[i-2]-basesec;
			setnewpos=1;
			break;
		case '>' /* CTRL_RIGH TODO-keys */:
			if (!cdpPlayMode)
				break;
			for (i=1; i<=cdpTrackNum; i++)
				if (newpos<(cdpTrackStarts[i]-basesec))
					break;
			newpos=cdpTrackStarts[i]-basesec;
			setnewpos=1;
			break;
/* TODO-keys	case 0x7700: //ctrl-home
			newpos=0;
			setnewpos=1;
			break;*/
		default:
			if (smpProcessKey)
			{
				int ret=smpProcessKey(key);
				if (ret==2)
					cpiResetScreen();
				if (ret)
					return 1;
			}
			return 0;
	}
	return 1;
}

static unsigned char cdCheck(void)
{
	curpos=cdGetHeadLocation(fileno(cdpDrive), &status);
      	if (status&STATUS_ERROR)
	    	return 1;
	if (!(status&STATUS_PLAY)&&!plPause&&!setnewpos)
	{
		setnewpos=1;
		newpos=length;
	}

	if (setnewpos)
	{
		if (newpos<0)
			newpos=0;
		if (newpos>=length)
		{
			if (fsLoopMods)
				newpos=0;
			else
				return 1;
		}
		cdStop(fileno(cdpDrive));
		cdPlay(fileno(cdpDrive), basesec+newpos, length-newpos);
		if (plPause)
			cdStop(fileno(cdpDrive));
		setnewpos=0;
	} else
		newpos=curpos-basesec;
	return 0;
}

static int cdaLooped(void)
{
	static char counter=0;
	if (!counter||setnewpos||plPause)
	{
		if (cdCheck())
			return 1;
		counter=8;
	} else
		counter--;

	return 0;
}

static void cdaCloseFile(void)
{
	if (!nodevice)
		smpCloseSampler();
	cdStop(fileno(cdpDrive));
	/*  cdLockTray(cdpDrive, 0); */
}

static int cdaOpenFile(const char *path, struct moduleinfostruct *info, FILE *file)
{
	char name[NAME_MAX+1];
	char ext[NAME_MAX+1];
	unsigned char tnum;

      	cfCDAtLineIn=cfGetProfileBool2(cfSoundSec, "sound", "cdsamplelinein", 0, 0); /* moved from global initclose */

	nodevice=!smpSample;
	cdpDrive=file;

	_splitpath(path, 0, 0, name, ext);

	if (!strcmp(name, "DISK"))
		tnum=0xFF;
	else
		if (!memcmp(name, "TRACK", 5)&&isdigit(name[5])&&isdigit(name[6])&&(strlen(name)==7))
			tnum=(name[5]-'0')*10+(name[6]-'0');
		else
			return -1;

	if (!cdIsCDDrive(fileno(cdpDrive)))
		return -1;

	cdpTrackNum=cdGetTracks(fileno(cdpDrive), cdpTrackStarts, &cdpFirstTrack, CDROM_LEADOUT);

	if (tnum!=0xFF)
	{
		if ((tnum<cdpFirstTrack)||(tnum>=(cdpFirstTrack+cdpTrackNum)))
			return -1;
		cdpPlayMode=0;
		basesec=cdpTrackStarts[tnum-cdpFirstTrack];
		length=cdpTrackStarts[tnum-cdpFirstTrack+1]-basesec;
	} else {
		if (!cdpTrackNum)
			return -1;
		cdpPlayMode=1;
		basesec=cdpTrackStarts[0];
		length=cdpTrackStarts[cdpTrackNum]-basesec;
	}

	newpos=0;
	setnewpos=1;
	plPause=0;

	plIsEnd=cdaLooped;
	plProcessKey=cdaProcessKey;
	plDrawGStrings=cdaDrawGStrings;
	if (!nodevice)
	{
		void *buf;
		int len;

		plGetMasterSample=smpGetMasterSample;
		plGetRealMasterVolume=smpGetRealMasterVolume;
		smpSetSource(cfCDAtLineIn?SMP_LINEIN:SMP_CD);
		smpSetOptions(plsmpRate, plsmpOpt);
		if (!smpOpenSampler(&buf, &len, smpBufSize))
			return -1;
	}

	/*  cdLockTray(cdpDrive, 1); */

	strncpy(vdev, info->comment, 8);
	vdev[7]=0;

	cdPlay(fileno(cdpDrive), basesec, length);

  return 0;
}

struct cpifaceplayerstruct cdaPlayer = {cdaOpenFile, cdaCloseFile};
char *dllinfo = "player cdaPlayer";
struct linkinfostruct dllextinfo = {"playcda", "OpenCP CDA Player (c) 1995-04 Niklas Beisert, Tammo Hinrichs, Stian Skjelstad", DLLVERSION, 0};
