/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004, 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class Blockmap;

class Block : public Rectangle
  {
  const Blockmap * _blockmap;	// Blockmap to which this block belongs
  int _id;			// block identification number
				// positive for block of black dots
				// negative for block of white dots
  std::vector< Block > _block_vector; // vector of blocks nested into this one

public:
  Block( const Rectangle & r, const Blockmap & b, int id ) throw()
    : Rectangle( r ), _blockmap( &b ), _id( id ) {}

  int   area() const throw();			// 'area' means filled area
  int   area_octagon() const throw();
  int   size_octagon() const throw();
  const Block & block( int i ) const throw();
  int   blocks() const throw() { return _block_vector.size(); }
  const Blockmap * blockmap() const throw() { return _blockmap; }
  int   id() const throw() { return _id; }
  bool  compare_id( int id, bool recursive ) const throw();

  bool escape_left  ( int row, int col ) const throw();
  bool escape_top   ( int row, int col ) const throw();
  bool escape_right ( int row, int col ) const throw();
  bool escape_bottom( int row, int col ) const throw();
  int  follow_top   ( int row, int col ) const throw();
  int  follow_bottom( int row, int col ) const throw();
  int  seek_left  ( int row, int col, bool black = true ) const throw();
  int  seek_top   ( int row, int col, bool black = true ) const throw();
  int  seek_right ( int row, int col, bool black = true ) const throw();
  int  seek_bottom( int row, int col, bool black = true ) const throw();
  bool top_hook   ( int *hdiff ) const throw();
  bool bottom_hook( int *hdiff ) const throw();

  void print( FILE * outfile, int sp ) const throw();

  bool adjust_height() throw();
  void delete_block( int i ) throw();
  void shift_block( const Block & b ) throw();
  static void hierarchize_blocks( std::vector< Block > & block_vector ) throw();
  };
