#!/bin/sh
################################################################################
#
# OCS Inventory NG Linux Agent Setup
#
# Copyleft 2006 Didier LIROULET
# Web: http://ocsinventory.sourceforge.net
#
# This code is open source and may be copied and modified as long as the source
# code is always made freely available.
# Please refer to the General Public Licence http://www.gnu.org/ or Licence.txt
################################################################################
#
# By default, run installer in user interactive mode
# In silent mode
#      param 1 must be 1 to enable setup of missing dependancies (dmidecode, perl modules), 0 to disable
#      param 2 must be ocs server address (local for local inventory method)
#      param 3 can be ocs server port (optional, default to 80)
#      param 4 can be TAG value between quotes (optional)
# Example: sh setup.sh 1 communication_server_address communication_server_port "my site"
#          sh setup.sh 1 communication_server_address communication_server_port 
#          sh setup.sh 1 local
#
# Installer exit with 0 if no errors, 1 if errors while installing
# dependancies, 2 if errors while installing agent
#

# which method is OCS Inventory NG agent using (http/local)
OCS_AGENT_METHOD="http"

# Which host run OCS Inventory NG Communication Server
# Valid values are 
#     - "local" for local inventory generated to file
#     - hostname or ip address to connect to a valid Communicataion Server
OCS_SERVER_HOST=""

# On which port run OCS Inventory NG Communication Server
OCS_SERVER_PORT="80"

# What is the value of TAG administrative information
OCS_AGENT_TAG_VALUE=""


###################### DO NOT MODIFY BELOW #######################

# Where are located OCS Inventory NG agent configuration files
OCS_AGENT_CONFIG_DIR="/etc/ocsinventory-client"

# OCS Inventory NG agent configuration file name
OCS_AGENT_CONFIG_FILE="ocsinv.conf"

# OCS Inventory NG agent administrative information file
OCS_AGENT_ADMININFO_FILE="ocsinv.adm"

# Where are located OCS Inventory NG agent log files
OCS_AGENT_LOG_DIR="/var/log/ocsinventory-client"

# Where is located OCS Inventory NG Agent cron configuration file
OCS_AGENT_CRON_FILE="/etc/cron.d/ocsinventory-client"

# Where is logrotate configuration directory
LOGROTATE_CONF_DIR="/etc/logrotate.d"

# Local computer Device ID
OCS_LOCAL_HOST=`hostname`
OCS_LOCAL_DATE=`date +%Y-%m-%d-%H-%M-%S`
OCS_AGENT_DEVICE_ID="$OCS_LOCAL_HOST-$OCS_LOCAL_DATE"

# Local computer dmidecode version
OCS_AGENT_DMIDECODE_BIN=`which dmidecode`
OCS_AGENT_DMIDECODE_VERSION=""
PROVIDED_DMIDECODE_VERSION="2.8"

# Local computer ipdiscover version
OCS_AGENT_IPDISCOVER_VERSION="0"
OCS_AGENT_IPDISCOVER_NEW_VERSION="3"

# Activate (1) or not (0) OCS Inventory NG Agent Auto Update feature
# No more used
OCS_AGENT_AUTO_UPDATE=0

# Provided PERL module Compress::Zlib version
PROVIDED_PERL_COMPRESS_ZLIB_VERSION="1.34"

# Provided PERL module XML::Simple version
PROVIDED_PERL_XML_SIMPLE_VERSION="2.14"

# Provided PERL module Net::IP version
PROVIDED_PERL_NET_IP_VERSION="1.24"

# Provided PERL module LWP (libwww-perl) version
PROVIDED_PERL_LWP_VERSION="5.805"

# Provided PERL module Digest::MD5 version
PROVIDED_PERL_DIGEST_MD5_VERSION="2.36"

# Provided PERL module Net::SSLeay version
PROVIDED_PERL_NET_SSLEAY_VERSION="1.25"

# By default, run installer in user interactive mode
# In silent mode
#      param 1 must be 1 to enable setup of missing dependancies (dmidecode, perl modules), 0 to disable
#      param 2 must be ocs server address (local for local inventory method)
#      param 3 can be ocs server port (optional, default to 80)
#      param 4 can be TAG value between quotes (optional)
# Example: sh setup.sh 1 communication_server_address communication_server_port "my site"
#          sh setup.sh 1 communication_server_address communication_server_port 
#          sh setup.sh 1 local
INSTALLER_INTERACTIVE=1

# Enable (1) or not (0) auto install of missing dependancies (dmidecode, perl modules)
INSTALLER_SETUP_DEPENDANCIES=0

# Where is located perl interpreter
PERL_BIN=`which perl`

# Where is located C compiler
CC=`which cc`

# Where is located make utility
MAKE=`which make`

# Where is located ed simple editor (not used, because now using perl to replace string in file)
# ED_BIN=`which ed`

# Where to store setup log
SETUP_LOG=`pwd`/ocs_agent_setup.log

echo
echo "+----------------------------------------------------------+"
echo "|                                                          |"
echo "| Welcome to OCS Inventory NG Agent setup !                |"
echo "|                                                          |"
echo "+----------------------------------------------------------+"
echo "Writing log to file $SETUP_LOG"
echo

echo > $SETUP_LOG
echo "Starting OCS Inventory NG Agent setup on $OCS_LOCAL_DATE" >> $SETUP_LOG
echo "Writing log to file $SETUP_LOG" >> $SETUP_LOG
echo >> $SETUP_LOG

echo
echo "+----------------------------------------------------------+"
echo "| Checking for previous installation...                    |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for previous installation" >> $SETUP_LOG
if test -d $OCS_AGENT_CONFIG_DIR
then
	# Previous installation found
	echo "Previous installation of OCS Inventory NG agent was found."
	echo "Previous installation of OCS Inventory NG agent was found." >> $SETUP_LOG
	# Retreiving OCS Communication server host
	OCS_SERVER_HOST=`eval cat $OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE | grep OCSFSERVER | cut -d'>' -f2 | cut -d'<' -f1 | cut -d':' -f1` 
	OCS_SERVER_PORT=`eval cat $OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE | grep OCSFSERVER | cut -d'>' -f2 | cut -d'<' -f1 | cut -d':' -f2`
	OCS_AGENT_DEVICE_ID=`eval cat $OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE | grep DEVICEID | cut -d'>' -f2 | cut -d'<' -f1 | cut -d':' -f2`
	OCS_AGENT_DMIDECODE_VERSION=`eval cat $OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE | grep DMIVERSION  | cut -d'>' -f2 | cut -d'<' -f1 | cut -d':' -f2`
	OCS_AGENT_IPDISCOVER_VERSION=`eval cat $OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE | grep IPDISCOVER_VERSION | cut -d'>' -f2 | cut -d'<' -f1 | cut -d':' -f2`
# No more used
#	OCS_AGENT_AUTO_UPDATE=`eval cat $OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE | grep UPDATE | cut -d'>' -f2 | cut -d'<' -f1 | cut -d':' -f2`
	if (test -z $OCS_SERVER_PORT) || (test $OCS_SERVER_PORT = $OCS_SERVER_HOST)
	then
		OCS_SERVER_PORT="80"
	fi
	echo "Found OCS Inventory NG Communication Server host <$OCS_SERVER_HOST>" >> $SETUP_LOG
	echo "Found OCS Inventory NG Communication Server port <$OCS_SERVER_PORT>" >> $SETUP_LOG
	echo "Found OCS Inventory Agent Device ID <$OCS_AGENT_DEVICE_ID>" >> $SETUP_LOG
	echo "Found OCS Inventory NG Agent DMI version <$OCS_AGENT_DMIDECODE_VERSION>" >> $SETUP_LOG
	echo "Found OCS Inventory NG Agent IPDISCOVER version <$OCS_AGENT_IPDISCOVER_VERSION>" >> $SETUP_LOG
# No more used
#	echo "Found OCS Inventory NG Agent AutoUpdate value <$OCS_AGENT_AUTO_UPDATE>" >> $SETUP_LOG
	OCS_AGENT_PREVIOUS=1
else
	echo "Previous installation of OCS Inventory NG agent not found"
	echo "Previous installation of OCS Inventory NG agent not found" >> $SETUP_LOG
	OCS_AGENT_PREVIOUS=0
fi

echo
echo "+----------------------------------------------------------+"
echo "| Checking for supplied parameters...                      |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for supplied parameters" >> $SETUP_LOG
# Checking if parameters supplied
if test -z $1
then
	# No parameters, user intercative installer
	echo "No parameter found"
	echo "OCS Inventory NG Agent setup running in user interactive mode"
	echo "No parameter found" >> $SETUP_LOG
	echo "OCS Inventory NG Agent setup running in user interactive mode" >> $SETUP_LOG
	INSTALLER_INTERACTIVE=1
else
	# Parameters provided, assume silent installer
	echo "Parameters <$1 $2 $3 $4>"
	echo "OCS Inventory NG Agent setup running in silent mode"
	echo "Parameters <$1 $2 $3 $4>" >> $SETUP_LOG
	echo "OCS Inventory NG Agent setup running in silent mode" >> $SETUP_LOG
	INSTALLER_INTERACTIVE=0
	# Enable (1) or not (0) auto install of missing dependancies (dmidecode, perl modules)
	if (test "$1" = "0") || (test "$1" = "1")
	then
	   INSTALLER_SETUP_DEPENDANCIES=$1
	else
		echo "Wrong parameter 1 Setup of dependancies !"
		echo "Usage: <sh setup.sh> to run installer in interactive mode"
		echo "       <sh setup.sh Param1 Param2 [Param3 Param4]> to run installer in silent mode"
		echo "    Parameter 1 must be 1 to enable setup of missing dependancies (dmidecode, perl modules), 0 to disable"
		echo "    Parameter 2 must be ocs server address (local for local inventory method)"
		echo "    Parameter 3 can be ocs server port (optional, default to 80)"
		echo "    Parameter 4 can be TAG value between quotes (optional)"
		echo "Installation aborted !"
		echo "Wrong parameter 1 Setup of dependancies, installation aborted !" >> $SETUP_LOG
		exit 1
	fi
	# Which host run OCS Inventory NG Communication Server
	if test -z $2
	then
		echo "Missing parameter 2 Communication Server address"
		echo "Usage: <sh setup.sh> to run installer in interactive mode"
		echo "       <sh setup.sh Param1 Param2 [Param3 Param4]> to run installer in silent mode"
		echo "    Parameter 1 must be 1 to enable setup of missing dependancies (dmidecode, perl modules), 0 to disable"
		echo "    Parameter 2 must be ocs server address (local for local inventory method)"
		echo "    Parameter 3 can be ocs server port (optional, default to 80)"
		echo "    Parameter 4 can be TAG value between quotes (optional)"
		echo "Installation aborted !"
		echo "Missing parameter 2 Communication Server address, installation aborted !" >> $SETUP_LOG
		exit 1
	else
		if test "$2" = "local"
		then
			OCS_AGENT_METHOD="__local__"
			OCS_SERVER_HOST=$2
		else
			OCS_AGENT_METHOD="http"
			OCS_SERVER_HOST=$2
		fi
	fi
	# On which port run OCS Inventory NG Communication Server
	if test -z $3
	then
		OCS_SERVER_PORT="80"
	else
		OCS_SERVER_PORT=$3
	fi
	# What is the value of TAG administrative information
	if test -z $4
	then
		OCS_AGENT_TAG_VALUE=""
	else
		OCS_AGENT_TAG_VALUE=$4
	fi
fi
echo

if (test $OCS_AGENT_PREVIOUS -eq 1) && (test $INSTALLER_INTERACTIVE -eq 1)
then
	# Ask user what to do
	echo "Previous installation of OCS Inventory NG agent was found."
	if test "$OCS_SERVER_HOST" = "local"
	then
		echo "This installation was generating inventory in local mode to a file."
		OCS_AGENT_METHOD="local"
	else
		echo "This installation was using OCS Inventory NG Communication Server on host"
		echo "$OCS_SERVER_HOST and port $OCS_SERVER_PORT."
		OCS_AGENT_METHOD="http"
	fi
	echo -n "Do you wish to re-install/upgrade existing installation ([y]/n) ?"
	read ligne
	if (test "$ligne" = "y") || (test -z $ligne)
	then
		echo "User asked to re-install/upgrade OCS Inventory NG Agent" >> $SETUP_LOG
	else
		echo "Installation aborted !"
		echo "Installation aborted by user !" >> $SETUP_LOG
		exit 1
	fi
fi


echo
echo "+----------------------------------------------------------+"
echo "| Checking for OCS Inventory NG Agent running method...    |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for OCS Inventory NG Agent running method" >> $SETUP_LOG
if test $INSTALLER_INTERACTIVE -eq 1
then
	# Ask user for inventory mode (http/local)
	echo "OCS Inventory NG Agent can be run through 2 methods:"
	echo "- local: inventory will be generated locally to a file, without"
	echo "         interacting with Communication Server. Inventory results"
	echo "         must then be imported manually into the server through"
	echo "         Administration Console."
	echo "- http: Agent can connect to Communication Server and will interact"
	echo "        with it to know what is has to do (inventory, ipdiscover,"
	echo "        deployment...)"
	res=0
	while test $res -eq 0
	do
		if test $OCS_AGENT_METHOD = "local"
		then
			# Previous install using local inventory mode
			echo -n "Which method will you use to generate the inventory (http/[local]) ?"
			read ligne
			if (test -z $ligne) || (test "$ligne" = "local")
			then
				OCS_AGENT_METHOD="local"
				OCS_SERVER_HOST="local"
# No more used
#				OCS_AGENT_AUTO_UPDATE=0
				res=1
			else
				if test "$ligne" = "http"
				then
					OCS_AGENT_METHOD="http"
					res=1
				else
					res=0
				fi
			fi
		else
			# Previous install using http inventory mode
			echo -n "Which method will you use to generate the inventory ([http]/local) ?"
			read ligne
			if (test -z $ligne) || (test "$ligne" = "http")
			then
				OCS_AGENT_METHOD="http"
				res=1
				else
				if test "$ligne" = "local"
				then
					OCS_AGENT_METHOD="local"
					OCS_SERVER_HOST="local"
# No more used
#					OCS_AGENT_AUTO_UPDATE=0
					res=1
				else
					res=0
				fi
			fi
		fi
	done
fi
echo "OK, OCS Inventory NG agent will be running in <$OCS_AGENT_METHOD> mode ;-)"
echo "OCS Inventory NG agent will be running in <$OCS_AGENT_METHOD> mode" >> $SETUP_LOG
echo

if test $OCS_AGENT_METHOD = "http"
then
	echo
	echo "+----------------------------------------------------------+"
	echo "| Checking for OCS Inventory NG Communication Server...    |"
	echo "+----------------------------------------------------------+"
	echo
	echo "Checking for OCS Inventory NG Communication Server" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user for OCS Inventory NG Communication Server host
		res=0
		while test $res -eq 0
		do
			echo -n "Which host is running OCS Inventory NG Communication Server [$OCS_SERVER_HOST] ?"
			read ligne
			if test -z $ligne
			then
				res=1
			else
				OCS_SERVER_HOST="$ligne"
				res=1
			fi
		done

		# Ask user for OCS Inventory NG Communication Server port
		res=0
		while test $res -eq 0
		do
			echo -n "On which port is running OCS Inventory NG Communication Server [$OCS_SERVER_PORT] ?"
			read ligne
			if test -z $ligne
			then
				res=1
			else
				OCS_SERVER_PORT="$ligne"
				res=1
			fi
		done
	fi
	echo "OK, OCS Inventory NG Communication Server is running on host"
	echo "<$OCS_SERVER_HOST> and port <$OCS_SERVER_PORT> ;-)"
	echo "Using OCS Inventory NG Communication Server running on host <$OCS_SERVER_HOST>, port <$OCS_SERVER_PORT>" >> $SETUP_LOG
	echo
fi


echo
echo "+----------------------------------------------------------+"
echo "| Checking for TAG administrative information value...     |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for TAG administrative information value" >> $SETUP_LOG
if test -r "$OCS_AGENT_CONFIG_DIR/label"
then
	LABEL=`cat $OCS_AGENT_CONFIG_DIR/label`
else
	LABEL="TAG"
fi
if test $INSTALLER_INTERACTIVE -eq 1
then
	if test -r "$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE"
	then
		# TAG value already inserted => skip
		echo "<$LABEL> already exist, skipping (use Administration console to update)"
		echo "<$LABEL> already exist, skipping" >> $SETUP_LOG
	else
		# Ask user for TAG value
		res=0
		while test $res -eq 0
		do
			echo -n "What is the value of $LABEL ([$OCS_AGENT_TAG_VALUE]) ?"
			read ligne
			if (test -z $ligne)
			then
				res=1
			else
				res=1
				OCS_AGENT_TAG_VALUE=$ligne
			fi
		done
		echo "OK, OCS Inventory NG agent will use <$OCS_AGENT_TAG_VALUE> as <$LABEL> ;-)"
		echo "OCS Inventory NG agent will use <$OCS_AGENT_TAG_VALUE> as <$LABEL>" >> $SETUP_LOG
	fi
else
	echo "OK, OCS Inventory NG agent will use <$OCS_AGENT_TAG_VALUE> as <$LABEL> ;-)"
	echo "OCS Inventory NG agent will use <$OCS_AGENT_TAG_VALUE> as <$LABEL>" >> $SETUP_LOG
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for PERL Interpreter...                         |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for PERL Interpreter" >> $SETUP_LOG
if test -z $PERL_BIN
then
	echo "PERL Interpreter not found !"
	echo "PERL Interpreter not found" >> $SETUP_LOG
	echo "OCS Inventory NG is not able to work without PERL Interpreter."
	echo "Setup manually PERL first."
	echo "Installation aborted !"
	echo "installation aborted" >> $SETUP_LOG
	exit 1
else
	echo "OK, PERL Intrepreter found at <$PERL_BIN> ;-)"
	echo "PERL Intrepreter found at <$PERL_BIN>" >> $SETUP_LOG
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for C/C++ Compiler...                           |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for C/C++ Compiler" >> $SETUP_LOG
if test -z $CC
then
	echo "C/C++ Compiler not found !"
	echo "C/C++ Compiler not found" >> $SETUP_LOG
	echo "Setup is not able to build IPDISCOVER module."
	echo "Some functionnalities of OCS Inventory NG may lack !!"
	echo "Unable to build IPDISCOVER module !" >> $SETUP_LOG
	INSTALLER_SETUP_IPDISCOVER=0
else
	echo "OK, C/C++ Compiler found at <$CC> ;-)"
	echo "C/C++ Compiler found at <$CC>" >> $SETUP_LOG
	INSTALLER_SETUP_IPDISCOVER=1
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for Make utility...                             |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for Make utility" >> $SETUP_LOG
if test -z $MAKE
then
	echo "Make utility not found !"
	echo "Make utility not found" >> $SETUP_LOG
	echo "Setup is not able to build Perl module."
	echo "Unable to build Perl module !" >> $SETUP_LOG
	exit 2
else
	echo "OK, Make utility found at <$MAKE> ;-)"
	echo "Make utility found at <$MAKE>" >> $SETUP_LOG
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for dmidecode binaries...                       |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for dmidecode binaries" >> $SETUP_LOG
if test -z $OCS_AGENT_DMIDECODE_BIN
then
	echo "dmidecode binaries not found !"
	echo "dmidecode binaries not found" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup dmidecode
		echo "Setup is able to install dmidecode version $PROVIDED_DMIDECODE_VERSION."
		echo -n "Do you wish setup to install dmidecode ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without dmidecode."
			echo "Setup manually dmidecode first."
			echo "Installation aborted !"
			echo "User refused to setup dmideocde, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_DMIDECODE=1
			echo "OK, dmidecode version $PROVIDED_DMIDECODE_VERSION will be automatically setup ;-)"
			echo "User ask to automatically setup dmidecode version $PROVIDED_DMIDECODE_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		if test $INSTALLER_SETUP_DEPENDANCIES = "1"
		then
			INSTALLER_SETUP_DMIDECODE=1
			echo "OK, dmidecode version $PROVIDED_DMIDECODE_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup dmidecode version $PROVIDED_DMIDECODE_VERSION" >> $SETUP_LOG
		else
			echo "OCS Inventory NG is not able to work without dmidecode."
			echo "Setup manually dmidecode first."
			echo "Installation aborted !"
			echo "Automatic setup of dmideocde refused, installation aborted" >> $SETUP_LOG
			exit 1
		fi
	fi
else
	# Get installed dmidecode version
	INSTALLED_DMIDECODE_VERSION=` $OCS_AGENT_DMIDECODE_BIN | grep "# dmidecode" | cut -d' ' -f3`
	echo "Found dmidecode binaries version <$INSTALLED_DMIDECODE_VERSION> at <$OCS_AGENT_DMIDECODE_BIN> ;-)"
	echo "Found dmidecode binaries version <$INSTALLED_DMIDECODE_VERSION> at <$OCS_AGENT_DMIDECODE_BIN>" >> $SETUP_LOG
	# Never upgrade dmidecode (in case using rpm ou dpkg)
	INSTALLER_SETUP_DMIDECODE=0
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for Compress::Zlib PERL module...               |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for Compress::Zlib PERL module" >> $SETUP_LOG
$PERL_BIN -mCompress::Zlib -e 'print "PERL module Compress::Zlib is available\n"' >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "PERL module Compress::Zlib is not installed !"
    echo "PERL module Compress::Zlib is not installed" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup module
		echo "Setup is able to install PERL module Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION."
		echo -n "Do you wish setup to install this module ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without PERL module Compress::Zlib."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "User refused to setup PERL module Compress::Zlib, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_COMPRESS_ZLIB=1
			echo "OK, PERL module Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		if test $INSTALLER_SETUP_DEPENDANCIES = "1"
		then
			INSTALLER_SETUP_COMPRESS_ZLIB=1
			echo "OK, PERL module Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG
		else
			echo "OCS Inventory NG is not able to work without PERL module Compress::Zlib."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "Automatic setup of PERL module Compress::Zlib refused, installation aborted" >> $SETUP_LOG
			exit 1
		fi
	fi
else
	echo "OK, PERL module Compress::Zlib is available ;-)"
	INSTALLER_SETUP_COMPRESS_ZLIB=0
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for XML::Simple PERL module...                  |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for XML::Simple PERL module" >> $SETUP_LOG
$PERL_BIN -mXML::Simple -e 'print "PERL module XML::Simple is available\n"' >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "PERL module XML::Simple is not installed !"
    echo "PERL module XML::Simple is not installed" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup module
		echo "Setup is able to install PERL module XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION."
		echo -n "Do you wish setup to install this module ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without PERL module XML::Simple."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "User refused to setup PERL module XML::Simple, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_XML_SIMPLE=1
			echo "OK, PERL module XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		if test $INSTALLER_SETUP_DEPENDANCIES = "1"
		then
			INSTALLER_SETUP_XML_SIMPLE=1
			echo "OK, PERL module XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG
		else
			echo "OCS Inventory NG is not able to work without PERL module XML::Simple."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "Automatic setup of PERL module XML::Simple refused, installation aborted" >> $SETUP_LOG
			exit 1
		fi
	fi
else
	echo "OK, PERL module XML::Simple is available ;-)"
	INSTALLER_SETUP_XML_SIMPLE=0
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for Net::IP PERL module...                      |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for Net::IP PERL module" >> $SETUP_LOG
$PERL_BIN -mNet::IP -e 'print "PERL module Net::IP is available\n"' >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "PERL module Net::IP is not installed !"
    echo "PERL module Net::IP is not installed" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup module
		echo "Setup is able to install PERL module Net::IP version $PROVIDED_PERL_NET_IP_VERSION."
		echo -n "Do you wish setup to install this module ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without PERL module Net::IP."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "User refused to setup PERL module Net::IP, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_NET_IP=1
			echo "OK, PERL module Net::IP version $PROVIDED_PERL_NET_IP_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Net::IP version $PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		if test $INSTALLER_SETUP_DEPENDANCIES = "1"
		then
			INSTALLER_SETUP_NET_IP=1
			echo "OK, PERL module Net::IP version $PROVIDED_PERL_NET_IP_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Net::IP version $PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG
		else
			echo "OCS Inventory NG is not able to work without PERL module Net::IP."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "Automatic setup of PERL module Net::IP refused, installation aborted" >> $SETUP_LOG
			exit 1
		fi
	fi
else
	echo "OK, PERL module Net::IP is available ;-)"
	INSTALLER_SETUP_NET_IP=0
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for LWP::UserAgent PERL module...               |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for LWP::UserAgent PERL module" >> $SETUP_LOG
$PERL_BIN -mLWP::UserAgent -e 'print "PERL module LWP::UserAgent is available\n"' >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "PERL module LWP::UserAgent is not installed !"
    echo "PERL module LWP::UserAgent is not installed" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup module
		echo "Setup is able to install PERL module LWP version $PROVIDED_PERL_LWP_VERSION."
		echo -n "Do you wish setup to install this module ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without PERL module LWP::UserAgent."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "User refused to setup PERL module LWP, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_LWP=1
			echo "OK, PERL module LWP version $PROVIDED_PERL_NET_IP_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module LWP version $PROVIDED_PERL_LWP_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		echo "OCS Inventory NG is not able to work without PERL module LWP::UserAgent."
		echo "Install it manually first."
		echo "Installation aborted !"
		echo "Automatic setup of PERL module LWP impossible, because need user answers, installation aborted" >> $SETUP_LOG
		exit 1
	fi
else
	echo "OK, PERL module LWP::UserAgent is available ;-)"
	INSTALLER_SETUP_LWP=0
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for Digest::MD5 PERL module...                  |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for Digest::MD5 PERL module" >> $SETUP_LOG
$PERL_BIN -mDigest::MD5 -e 'print "PERL module Digest::MD5 is available\n"' >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "PERL module Digest::MD5 is not installed !"
    echo "PERL module Digest::MD5 is not installed" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup module
		echo "Setup is able to install PERL module Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION."
		echo -n "Do you wish setup to install this module ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without PERL module Digest::MD5."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "User refused to setup PERL module Digest::MD5, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_DIGEST_MD5=1
			echo "OK, PERL module Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		if test $INSTALLER_SETUP_DEPENDANCIES = "1"
		then
			INSTALLER_SETUP_DIGEST_MD5=1
			echo "OK, PERL module Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG
		else
			echo "OCS Inventory NG is not able to work without PERL module Digest::MD5."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "Automatic setup of PERL module Digest::MD5 refused, installation aborted" >> $SETUP_LOG
			exit 1
		fi
	fi
else
	echo "OK, PERL module Digest::MD5 is available ;-)"
	INSTALLER_SETUP_DIGEST_MD5=0
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Checking for Net::SSLeay PERL module...                  |"
echo "+----------------------------------------------------------+"
echo
echo "Checking for Net::SSLeay PERL module" >> $SETUP_LOG
$PERL_BIN -mNet::SSLeay -e 'print "PERL module Net::SSLeay is available\n"' >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "PERL module Net::SSLeay is not installed !"
    echo "PERL module Net::SSLeay is not installed" >> $SETUP_LOG
	if test $INSTALLER_INTERACTIVE -eq 1
	then
		# Ask user to setup module
		echo "Setup is able to install PERL module Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION."
		echo -n "Do you wish setup to install this module ([y]/n) ?"
		read ligne
		if test "$ligne" = "n"
		then
			echo "OCS Inventory NG is not able to work without PERL module Net::SSLeay."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "User refused to setup PERL module Net::SSLeay, installation aborted" >> $SETUP_LOG
			exit 1
		else
			INSTALLER_SETUP_NET_SSLEAY=1
			echo "OK, PERL module Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG
		fi
	else
		# Silent setup
		if test $INSTALLER_SETUP_DEPENDANCIES = "1"
		then
			INSTALLER_SETUP_NET_SSLEAY=1
			echo "OK, PERL module Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION will automatically be setup ;-)"
			echo "User ask to automatically setup PERL module Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG
		else
			echo "OCS Inventory NG is not able to work without PERL module Net::SSLeay."
			echo "Install it manually first."
			echo "Installation aborted !"
			echo "Automatic setup of PERL module Net::SSLeay refused, installation aborted" >> $SETUP_LOG
			exit 1
		fi
	fi
else
	echo "OK, PERL module Net::SSLeay is available ;-)"
	INSTALLER_SETUP_NET_SSLEAY=0
fi
echo


if test $INSTALLER_SETUP_DMIDECODE -eq 1
then
    # Setup dmidecode
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing dmidecode...                                  |"
	echo "+----------------------------------------------------------+"
	echo
    echo "Unpacking dmidecode version $PROVIDED_DMIDECODE_VERSION..."
    echo "Unpacking dmidecode version $PROVIDED_DMIDECODE_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi 
    tar -xzf "dmidecode-$PROVIDED_DMIDECODE_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack dmidecode !"
        echo "*** ERROR: Unable to unpack dmidecode" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    cd "dmidecode-$PROVIDED_DMIDECODE_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter dmidecode subfolder !"
        echo "*** ERROR: Unable to enter dmidecode subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Building dmidecode version $PROVIDED_DMIDECODE_VERSION..."
    echo "Building dmidecode version $PROVIDED_DMIDECODE_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build dmidecode !"
        echo "*** ERROR: Unable to build dmidecode" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing dmidecode version $PROVIDED_DMIDECODE_VERSION..."
    echo "Installing dmidecode version $PROVIDED_DMIDECODE_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install dmidecode binaries !"
        echo "*** ERROR: Unable to install dmidecode binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../.. >> $SETUP_LOG 2>&1
    echo "OK, dmidecode setup successfully ;-)"
    echo "dmidecode setup successfully" >> $SETUP_LOG
    if test "$OCS_AGENT_DMIDECODE_VERSION" = "1"
    then
        # Upgrading from 1.0 RC2 or previous
        echo "Upgrading from OCS 1.0 RC2 or previuous" >> $SETUP_LOG
        # Remove previous dmidecode
        echo "Removing old /usr/sbin/dmidecode" >> $SETUP_LOG
        rm -f /usr/sbin/dmidecode >> $SETUP_LOG 2>&1
        # Link new dmidecode /usr/local/sbin/dmidecode to /usr/sbin/dmidecode
        # to ensure it is in the path for root
        echo "Linking new /usr/local/sbin/dmidecode to /usr/sbin/dmidecode" >> $SETUP_LOG
        ln -s /usr/local/sbin/dmidecode /usr/sbin/dmidecode >> $SETUP_LOG 2>&1
    fi
    OCS_AGENT_DMIDECODE_VERSION=$PROVIDED_DMIDECODE_VERSION
	echo
else
	OCS_AGENT_DMIDECODE_VERSION=$INSTALLED_DMIDECODE_VERSION
fi


if test $INSTALLER_SETUP_COMPRESS_ZLIB -eq 1
then
    # Setup Compress-Zlib
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing Compress::Zlib PERL module...                 |"
	echo "+----------------------------------------------------------+"
	echo
    echo "Unpacking Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION..."
    echo "Unpacking Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi
    tar -xzf "Compress-Zlib-$PROVIDED_PERL_COMPRESS_ZLIB_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack Compress::Zlib !"
        echo "*** ERROR: Unable to unpack Compress::Zlib" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi
    cd "Compress-Zlib-$PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter Compress::Zlib subfolder !"
        echo "*** ERROR: Unable to enter Compress::Zlib subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Configuring Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION..."
    echo "Configuring Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG
    $PERL_BIN Makefile.PL >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to configure Compress::Zlib !"
        echo "*** ERROR: Unable to configure Compress::Zlib" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Building Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION..."
    echo "Building Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build Compress::Zlib !"
        echo "*** ERROR: Unable to build Compress::Zlib" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION..."
    echo "Installing Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install Compress::Zlib binaries !"
        echo "*** ERROR: Unable to install Compress::Zlib binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../..
    echo "OK, Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION setup successfully ;-)"
    echo "Compress::Zlib version $PROVIDED_PERL_COMPRESS_ZLIB_VERSION setup successfully" >> $SETUP_LOG
    echo
fi


if test $INSTALLER_SETUP_XML_SIMPLE -eq 1
then
    # Setup XML::Simple
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing XML::Simple PERL module...                    |"
	echo "+----------------------------------------------------------+"
	echo
    echo "Unpacking XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION..."
    echo "Unpacking XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi
    tar -xzf "XML-Simple-$PROVIDED_PERL_XML_SIMPLE_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack XML::Simple !"
        echo "*** ERROR: Unable to unpack XML::Simple" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi
    cd "XML-Simple-$PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter XML::Simple subfolder !"
        echo "*** ERROR: Unable to enter XML::Simple subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Configuring XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION..."
    echo "Configuring XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG
    $PERL_BIN Makefile.PL >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to configure XML::Simple !"
        echo "*** ERROR: Unable to configure XML::Simple" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Building XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION..."
    echo "Building XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build XML::Simple !"
        echo "*** ERROR: Unable to build XML::Simple" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION..."
    echo "Installing XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install XML::Simple binaries !"
        echo "*** ERROR: Unable to install XML::Simple binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../..
    echo "OK, XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION setup successfully ;-)"
    echo "XML::Simple version $PROVIDED_PERL_XML_SIMPLE_VERSION setup successfully" >> $SETUP_LOG
    echo
fi


if test $INSTALLER_SETUP_NET_IP -eq 1
then
    # Setup Net::IP
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing Net::IP PERL module...                        |"
	echo "+----------------------------------------------------------+"
    echo
    echo "Unpacking Net::IP version $PROVIDED_PERL_NET_IP_VERSION..."
    echo "Unpacking Net::IP version $PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi
    tar -xzf "Net-IP-$PROVIDED_PERL_NET_IP_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack Net::IP !"
        echo "*** ERROR: Unable to unpack Net::IP" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi
    cd "Net-IP-$PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter Net::IP subfolder !"
        echo "*** ERROR: Unable to enter Net::IP subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Configuring Net::IP version $PROVIDED_PERL_NET_IP_VERSION..."
    echo "Configuring Net::IP version $PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG
    $PERL_BIN Makefile.PL >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to configure Net::IP !"
        echo "*** ERROR: Unable to configure Net::IP" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Building Net::IP version $PROVIDED_PERL_NET_IP_VERSION..."
    echo "Building Net::IP version $PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build Net::IP !"
        echo "*** ERROR: Unable to build Net::IP" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing Net::IP version $PROVIDED_PERL_NET_IP_VERSION..."
    echo "Installing Net::IP version $PROVIDED_PERL_NET_IP_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install Net::IP binaries !"
        echo "*** ERROR: Unable to install Net::IP binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../..
    echo "OK, Net::IP version $PROVIDED_PERL_NET_IP_VERSION setup successfully ;-)"
    echo "Net::IP version $PROVIDED_PERL_NET_IP_VERSION setup successfully" >> $SETUP_LOG
    echo
fi


if test $INSTALLER_SETUP_LWP -eq 1
then
    # Setup LWP (libwww-perl)
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing LWP (libwww-perl) PERL module...              |"
	echo "+----------------------------------------------------------+"
    echo
    echo "Unpacking LWP version $PROVIDED_PERL_LWP_VERSION..."
    echo "Unpacking LWP version $PROVIDED_PERL_LWP_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi
    tar -xzf "libwww-perl-$PROVIDED_PERL_LWP_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack LWP (libwww-perl) !"
        echo "*** ERROR: Unable to unpack LWP (libwww-perl)" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi
    cd "libwww-perl-$PROVIDED_PERL_LWP_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter LWP (libwww-perl) subfolder !"
        echo "*** ERROR: Unable to enter LWP (libwww-perl) subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Configuring LWP version $PROVIDED_PERL_LWP_VERSION..."
    echo "Configuring LWP version $PROVIDED_PERL_LWP_VERSION" >> $SETUP_LOG
    $PERL_BIN Makefile.PL
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to configure LWP !"
        echo "*** ERROR: Unable to configure LWP" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Building LWP version $PROVIDED_PERL_LWP_VERSION..."
    echo "Building LWP version $PROVIDED_PERL_LWP_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build LWP !"
        echo "*** ERROR: Unable to build LWP" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing LWP version $PROVIDED_PERL_LWP_VERSION..."
    echo "Installing LWP version $PROVIDED_PERL_LWP_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install LWP binaries !"
        echo "*** ERROR: Unable to install LWP binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../..
    echo "OK, LWP version $PROVIDED_PERL_LWP_VERSION setup successfully ;-)"
    echo "LWP version $PROVIDED_PERL_LWP_VERSION setup successfully" >> $SETUP_LOG
    echo
fi


if test $INSTALLER_SETUP_DIGEST_MD5 -eq 1
then
    # Setup Digest::MD5
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing Digest::MD5 PERL module...                    |"
	echo "+----------------------------------------------------------+"
    echo
    echo "Unpacking Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION..."
    echo "Unpacking Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi
    tar -xzf "Digest-MD5-$PROVIDED_PERL_DIGEST_MD5_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack Digest::MD5!"
        echo "*** ERROR: Unable to unpack Digest::MD5" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi
    cd "Digest-MD5-$PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter Digest::MD5 subfolder !"
        echo "*** ERROR: Unable to enter Digest::MD5 subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Configuring Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION..."
    echo "Configuring Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG
    $PERL_BIN Makefile.PL >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to configure Digest::MD5 !"
        echo "*** ERROR: Unable to configure Digest::MD5" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Building Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION..."
    echo "Building Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build Digest::MD5 !"
        echo "*** ERROR: Unable to build Digest::MD5" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION..."
    echo "Installing Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install Digest::MD5 binaries !"
        echo "*** ERROR: Unable to install Digest::MD5 binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../..
    echo "OK, Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION setup successfully ;-)"
    echo "Digest::MD5 version $PROVIDED_PERL_DIGEST_MD5_VERSION setup successfully" >> $SETUP_LOG
    echo
fi


if test $INSTALLER_SETUP_NET_SSLEAY -eq 1
then
    # Setup Net::SSLeay
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing Net::SSLeay PERL module...                    |"
	echo "+----------------------------------------------------------+"
    echo
    echo "Unpacking Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION..."
    echo "Unpacking Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG
    cd require >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter require subfolder !"
        echo "*** ERROR: Unable to enter require subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        exit 1
    fi
    tar -xzf "Net_SSLeay.pm-$PROVIDED_PERL_NET_SSLEAY_VERSION.tar.gz" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to unpack Digest::MD5!"
        echo "*** ERROR: Unable to unpack Digest::MD5" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi
    cd "Net_SSLeay.pm-$PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to enter Digest::MD5 subfolder !"
        echo "*** ERROR: Unable to enter Digest::MD5 subfolder" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ..
        exit 1
    fi 
    echo "Configuring Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION..."
    echo "Configuring Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG
    $PERL_BIN Makefile.PL >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to configure Digest::MD5 !"
        echo "*** ERROR: Unable to configure Digest::MD5" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Building Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION..."
    echo "Building Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG
    $MAKE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to build Digest::MD5 !"
        echo "*** ERROR: Unable to build Digest::MD5" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    echo "Installing Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION..."
    echo "Installing Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION" >> $SETUP_LOG
    $MAKE install >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
        echo "*** ERROR: Unable to install Net::SSLeay binaries !"
        echo "*** ERROR: Unable to install Net::SSLeay binaries" >> $SETUP_LOG
        echo "Look at file $SETUP_LOG for detailled error and fix it manually"
        echo "before running another time OCS Inventory NG Agent setup."
        echo "Installation aborted !"
        cd ../..
        exit 1
    fi 
    cd ../..
    echo "OK, Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION setup successfully ;-)"
    echo "Net::SSLeay version $PROVIDED_PERL_NET_SSLEAY_VERSION setup successfully" >> $SETUP_LOG
    echo
fi


if test $INSTALLER_SETUP_IPDISCOVER -eq 1
then
	echo
	echo "+----------------------------------------------------------+"
	echo "| Installing IPDISCOVER binary...                          |"
	echo "+----------------------------------------------------------+"
	echo
	echo "Building IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION"
	echo "Building IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION" >> $SETUP_LOG
	$CC ipdiscover.c -o ipdiscover >> $SETUP_LOG 2>&1
	if [ $? != 0 ]
	then
		echo "*** ERROR: Unable to build IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION !"
		echo "*** ERROR: Unable to build IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION" >> $SETUP_LOG
		echo "Look at file $SETUP_LOG for detailled error and fix it manually"
		echo "before running another time OCS Inventory NG Agent setup."
		echo "Installation aborted !"
		exit 1
	fi 
	echo "Installing IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION into /usr/sbin"
	echo "Installing IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION into /usr/sbin" >> $SETUP_LOG
	cp -f ipdiscover /usr/sbin/ipdiscover >> $SETUP_LOG 2>&1
	if [ $? != 0 ]
	then
		echo "*** ERROR: Unable to install IPDISCOVER into /usr/sbin !"
		echo "*** ERROR: Unable to build IPDISCOVER into /usr/sbin" >> $SETUP_LOG
		echo "Look at file $SETUP_LOG for detailled error and fix it manually"
		echo "before running another time OCS Inventory NG Agent setup."
		echo "Installation aborted !"
		exit 1
	fi 
	OCS_AGENT_IPDISCOVER_VERSION=$OCS_AGENT_IPDISCOVER_NEW_VERSION
	echo "OK, IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION setup successfully ;-)"
	echo "IPDISCOVER version $OCS_AGENT_IPDISCOVER_NEW_VERSION setup successfully" >> $SETUP_LOG
	echo
fi


echo
echo "+----------------------------------------------------------+"
echo "| Installing OCS Inventory NG Agent...                     |"
echo "+----------------------------------------------------------+"
echo
echo "Configuring OCS Inventory NG Agent"
echo "Configuring OCS Inventory NG Agent" >> $SETUP_LOG
cd Ocsinventory >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
    echo "*** ERROR: Unable to enter Ocsinventory subfolder !"
    echo "*** ERROR: Unable to enter Ocsinventory subfolder" >> $SETUP_LOG
    echo "Look at file $SETUP_LOG for detailled error and fix it manually"
    echo "before running another time OCS Inventory NG Agent setup."
    echo "Installation aborted !"
    exit 2
fi
$PERL_BIN Makefile.PL >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to configure OCS Inventory NG Agent !"
	echo "*** ERROR: Unable to configure OCS Inventory NG Agent" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	cd ..
	exit 2
fi 
echo "Building OCS Inventory NG Agent"
echo "Building OCS Inventory NG Agent" >> $SETUP_LOG
$MAKE >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to build OCS Inventory NG Agent !"
	echo "*** ERROR: Unable to build OCS Inventory NG Agent" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	cd ..
	exit 2
fi 
echo "Installing OCS Inventory NG Agent"
echo "Installing OCS Inventory NG Agent" >> $SETUP_LOG
$MAKE install >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to install OCS Inventory NG Agent !"
	echo "*** ERROR: Unable to install OCS Inventory NG Agent" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	cd ..
	exit 2
fi 
echo "Creating </bin/ocsinv> OCS Inventory NG Agent symbolic link"
echo "Creating </bin/ocsinv> OCS Inventory NG Agent symbolic link" >> $SETUP_LOG
rm -f /bin/ocsinv
ln -s /usr/sbin/ocsinventory-client.pl /bin/ocsinv
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to create </bin/ocsinv> OCS Inventory NG Agent symbolic link !"
	echo "*** ERROR: Unable to install </bin/ocsinv> OCS Inventory NG Agent symbolic link" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	cd ..
	exit 2
fi 
cd ..
echo "OK, OCS Inventory NG Agent setup successfully ;-)"
echo "OCS Inventory NG Agent setup successfully" >> $SETUP_LOG
echo


echo
echo "+----------------------------------------------------------+"
echo "| Creating OCS Inventory NG Agent log directory...         |"
echo "+----------------------------------------------------------+"
echo
echo "Creating OCS Inventory NG Agent log directory <$OCS_AGENT_LOG_DIR>."
echo "Creating OCS Inventory NG Agent log directory <$OCS_AGENT_LOG_DIR>" >> $SETUP_LOG
mkdir -p $OCS_AGENT_LOG_DIR >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to create <$OCS_AGENT_LOG_DIR> OCS Inventory NG Agent log directory !"
	echo "*** ERROR: Unable to install <$OCS_AGENT_LOG_DIR> OCS Inventory NG Agent log directory" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	exit 2
fi
echo "Configuring logrotate for OCS Inventory NG Agent."
echo "Configuring logrotate (ed logrotate.ocsinventory-client)" >> $SETUP_LOG
#
# Now using perl to replace string in file instead of ed, not available by default in Mandriva Linux
#
#cp logrotate.ocsinventory-client logrotate.ocsinventory-client.local
#$ED_BIN logrotate.ocsinventory-client.local << EOF >> $SETUP_LOG 2>&1
#    1,$ g/^ *PATH_TO_LOG_DIRECTORY*/s#PATH_TO_LOG_DIRECTORY#$OCS_AGENT_LOG_DIR#
#    w
#    q
#EOF
cp logrotate.ocsinventory-client logrotate.ocsinventory-client.local
$PERL_BIN -pi -e "s#PATH_TO_LOG_DIRECTORY#$OCS_AGENT_LOG_DIR#g" logrotate.ocsinventory-client.local
echo "******** Begin updated logrotate.ocsinventory-client ***********" >> $SETUP_LOG
cat logrotate.ocsinventory-client.local >> $SETUP_LOG
echo "******** End updated logrotate.ocsinventory-client ***********" >> $SETUP_LOG
echo "Writing OCS Inventory NG Agent logrotate to file <$LOGROTATE_CONF_DIR/ocsinventory-client>"
echo "Writing OCS Inventory NG Agent logrotate to file <$LOGROTATE_CONF_DIR/ocsinventory-client>" >> $SETUP_LOG
cp -f logrotate.ocsinventory-client.local $LOGROTATE_CONF_DIR/ocsinventory-client >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to configure logrotate for OCS Inventory NG Agent !"
	echo "*** ERROR: Unable to configure logrotate for OCS Inventory NG Agent" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
 	exit 2
fi
echo


echo
echo "+----------------------------------------------------------+"
echo "| Installing OCS Inventory NG Agent configuration files... |"
echo "+----------------------------------------------------------+"
echo
echo "Creating OCS Inventory NG Agent <$OCS_AGENT_CONFIG_FILE> configuration file"
echo "Creating OCS Inventory NG Agent <$OCS_AGENT_CONFIG_FILE> configuration file" >> $SETUP_LOG
echo "<CONF>" > "$OCS_AGENT_CONFIG_FILE.local"
echo "  <DEVICEID>$OCS_AGENT_DEVICE_ID</DEVICEID>" >> "$OCS_AGENT_CONFIG_FILE.local"
echo "  <DMIVERSION>$OCS_AGENT_DMIDECODE_VERSION</DMIVERSION>" >> "$OCS_AGENT_CONFIG_FILE.local"
echo "  <IPDISCOVER_VERSION>$OCS_AGENT_IPDISCOVER_VERSION</IPDISCOVER_VERSION>" >> "$OCS_AGENT_CONFIG_FILE.local"
if test $OCS_AGENT_METHOD = "local"
then
	# Local mode
	echo "  <OCSFSERVER>local</OCSFSERVER>" >> "$OCS_AGENT_CONFIG_FILE.local"
else
	# HTTP mode
	echo "  <OCSFSERVER>$OCS_SERVER_HOST:$OCS_SERVER_PORT</OCSFSERVER>" >> "$OCS_AGENT_CONFIG_FILE.local"
fi
# No more used
#echo "  <UPDATE>$OCS_AGENT_AUTO_UPDATE</UPDATE>" >> "$OCS_AGENT_CONFIG_FILE.local"
echo "</CONF>" >> "$OCS_AGENT_CONFIG_FILE.local"
echo "******** Begin updated $OCS_AGENT_CONFIG_FILE ***********" >> $SETUP_LOG
cat $OCS_AGENT_CONFIG_FILE.local >> $SETUP_LOG
echo "******** End updated $OCS_AGENT_CONFIG_FILE ***********" >> $SETUP_LOG
echo "Creating OCS Inventory NG Agent <$OCS_AGENT_CONFIG_DIR> configuration directory"
echo "Creating OCS Inventory NG Agent <$OCS_AGENT_CONFIG_DIR> configuration directory" >> $SETUP_LOG
mkdir -p "$OCS_AGENT_CONFIG_DIR" >> $SETUP_LOG 2>&1
echo "Writing OCS Inventory NG Agent <$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE> configuration file"
echo "Writing OCS Inventory NG Agent <$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE> configuration file" >> $SETUP_LOG
cp -f "$OCS_AGENT_CONFIG_FILE.local" "$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_CONFIG_FILE" >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to write OCS Inventory NG Agent <$OCS_AGENT_CONFIG_FILE> configuration file !"
	echo "*** ERROR: Unable to write OCS Inventory NG Agent <$OCS_AGENT_CONFIG_FILE> configuration file" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	exit 2
fi 
echo "Creating OCS Inventory NG Agent <$OCS_AGENT_ADMININFO_FILE> configuration file"
echo "Creating OCS Inventory NG Agent <$OCS_AGENT_ADMININFO_FILE> configuration file" >> $SETUP_LOG
if test -r "$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE"
then
	echo "File <$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE> already exist. Skipping <$OCS_AGENT_ADMININFO_FILE> file creation"
	echo "File <$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE> already exist. Skipping <$OCS_AGENT_ADMININFO_FILE> file creation" >> $SETUP_LOG
else
	echo "<ADM>" > "$OCS_AGENT_ADMININFO_FILE.local"
	echo "  <ACCOUNTINFO>" >> "$OCS_AGENT_ADMININFO_FILE.local"
	echo "    <KEYNAME>TAG</KEYNAME>" >> "$OCS_AGENT_ADMININFO_FILE.local"
	echo "    <KEYVALUE>$OCS_AGENT_TAG_VALUE</KEYVALUE>" >> "$OCS_AGENT_ADMININFO_FILE.local"
	echo "  </ACCOUNTINFO>" >> "$OCS_AGENT_ADMININFO_FILE.local"
	echo "</ADM>" >> "$OCS_AGENT_ADMININFO_FILE.local"
	echo "******** Begin updated $OCS_AGENT_ADMININFO_FILE ***********" >> $SETUP_LOG
	cat $OCS_AGENT_ADMININFO_FILE.local >> $SETUP_LOG
	echo "******** End updated $OCS_AGENT_ADMININFO_FILE ***********" >> $SETUP_LOG
	echo "Writing OCS Inventory NG Agent <$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE> configuration file"
	echo "Writing OCS Inventory NG Agent <$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE> configuration file" >> $SETUP_LOG
	cp -f "$OCS_AGENT_ADMININFO_FILE.local" "$OCS_AGENT_CONFIG_DIR/$OCS_AGENT_ADMININFO_FILE" >> $SETUP_LOG 2>&1
	if [ $? != 0 ]
	then
		echo "*** ERROR: Unable to write OCS Inventory NG Agent <$OCS_AGENT_ADMININFO_FILE> configuration file !"
		echo "*** ERROR: Unable to write OCS Inventory NG Agent <$OCS_AGENT_ADMININFO_FILE> configuration file" >> $SETUP_LOG
		echo "Look at file $SETUP_LOG for detailled error and fix it manually"
		echo "before running another time OCS Inventory NG Agent setup."
		echo "Installation aborted !"
		exit 2
	fi 
fi
echo "OK, OCS Inventory NG Agent configuration files setup successfully ;-)"
echo "OCS Inventory NG Agent configuration files setup successfully" >> $SETUP_LOG
echo


echo
echo "+----------------------------------------------------------+"
echo "| Installing OCS Inventory NG Agent cron configuration...  |"
echo "+----------------------------------------------------------+"
echo
if test -r $OCS_AGENT_CRON_FILE
then
    echo "OCS Inventory NG Agent cron configuration file already exist, skipping"
    echo "OCS Inventory NG Agent cron configuration file already exist, skipping" >> $SETUP_LOG
else
    echo "Creating OCS Inventory NG Agent cron configuration file"
    echo "Creating OCS Inventory NG Agent cron configuration file" >> $SETUP_LOG
    OCS_AGENT_CRON_HOUR=`date +%H`
    OCS_AGENT_CRON_MIN=`date +%M`
    echo "#" > cron.local
    echo "# Generated by OCS Inventory NG Agent setup" >> cron.local
    echo "#" >> cron.local
    echo "################################################################################" >> cron.local
    echo "#" >> cron.local
    echo "# OCS Inventory NG Agent" >> cron.local
    echo "#" >> cron.local
    echo "# Copyleft 2006 Didier LIROULET" >> cron.local
    echo "# Web: http://ocsinventory.sourceforge.net" >> cron.local
    echo "#" >> cron.local
    echo "# This code is open source and may be copied and modified as long as the source" >> cron.local
    echo "# code is always made freely available." >> cron.local
    echo "# Please refer to the General Public Licence http://www.gnu.org/ or Licence.txt" >> cron.local
    echo "################################################################################" >> cron.local
    echo "#" >> cron.local
    echo "# Launch OCS Inventory NG Agent once a day under root account" >> cron.local
    echo "$OCS_AGENT_CRON_MIN $OCS_AGENT_CRON_HOUR * * * root cd /usr/sbin && perl ocsinventory-client.pl > /dev/null 2>&1" >> cron.local
    echo "******** Begin updated $OCS_AGENT_CRON_FILE ***********" >> $SETUP_LOG
    cat  cron.local >> $SETUP_LOG
    echo "******** End updated $OCS_AGENT_CRON_FILE ***********" >> $SETUP_LOG
    echo "Writing OCS Inventory NG Agent <$OCS_AGENT_CRON_FILE> cron configuration file"
    echo "Writing OCS Inventory NG Agent <$OCS_AGENT_CRON_FILE> cron configuration file" >> $SETUP_LOG
    cp -f  cron.local $OCS_AGENT_CRON_FILE >> $SETUP_LOG 2>&1
    if [ $? != 0 ]
    then
	    echo "*** ERROR: Unable to write OCS Inventory NG Agent <$OCS_AGENT_CRON_FILE> cron configuration file !"
	    echo "*** ERROR: Unable to write OCS Inventory NG Agent <$OCS_AGENT_CRON_FILE> cron configuration file" >> $SETUP_LOG
	    echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	    echo "before running another time OCS Inventory NG Agent setup."
	    echo "Installation aborted !"
	    exit 2
    fi
    echo "OK, OCS Inventory NG Agent cron configuration file setup successfully ;-)"
    echo "OCS Inventory NG Agent cron configuration file setup successfully" >> $SETUP_LOG
fi
echo

echo
echo "+----------------------------------------------------------+"
echo "| Lauching OCS Inventory NG Agent...                       |"
echo "+----------------------------------------------------------+"
echo
echo "Lauching OCS Inventory NG Agent" >> $SETUP_LOG
/bin/ocsinv -debug >> $SETUP_LOG 2>&1
if [ $? != 0 ]
then
	echo "*** ERROR: Unable to launch OCS Inventory NG Agent !"
	echo "*** ERROR: Unable to launch OCS Inventory NG Agent" >> $SETUP_LOG
	echo "Look at file $SETUP_LOG for detailled error and fix it manually"
	echo "before running another time OCS Inventory NG Agent setup."
	echo "Installation aborted !"
	exit 2
fi 
echo "OK, OCS Inventory NG Agent runs successfully ;-)"
echo "OCS Inventory NG Agent runs successfully" >> $SETUP_LOG
echo

echo
echo "Setup has created a log file $SETUP_LOG. Please, save this file."
echo "If you encounter error while running OCS Inventory NG Agent,"
echo "we can ask you to show us his content !"
echo
echo "Enjoy OCS Inventory NG ;-)"
echo
exit 0
