eopen('demo9.eps')                      % open eps-file and write eps-head
eglobpar;

titleFile='demo_title.ppm';
backgrFile='demo_backgr.ppm';
logoFile='demo_logo.ppm';
contentFile='demo_content.txt';

%make title image 
[titleImg titleCM]=eppmread([ePath 'default.ppm']); % read image
swCM=titleCM(:,1)+titleCM(:,2)+titleCM(:,3);
swCM=swCM/max(swCM);
titleCM=[swCM swCM swCM]; % color -> gray
eppmwrit(titleFile,titleImg,titleCM); % save image

%make background image
[backImg backCM]=eshadoi; % get default shadow image
backCM(:,2:3)=0; % red colormap
eppmwrit(backgrFile,backImg,backCM); % save image

%make logo image
[logoImg logoCM]=eshadois; % get default shadow image
eppmwrit(logoFile,logoImg,logoCM); % save image

%content
lf=setstr(10); %linefeed
contenttext=[
  'New features:' lf ...
  '#log scaled axes###'  lf ...
  '#return long tic positions of axes###'  lf ...
  '#new image functions e.g. ebright,econtra,eimgrot###' lf ...
  '#text functions etxtbox, etxtread, etxtlpos###' lf ...
  '#pie plot and error bars###' lf ...
  '#linear interpolation with elineip and efillmat###' lf  ...
  '#frames, circles, ellipses###' lf ...
  '#ASCII85 bitmap code, generates small EPS-files###' lf ...
  '#JPEG-file integration###' lf ...
  '#bugs removed in eopen, ehead, egridcl ...###' lf ...
  ];
etxtwrit(contenttext,contentFile);

% make cover

ecdcover('The EpsTk',...
         'Graphic for Octave & MATLAB(R)',...
         'St.Mueller',...
         'Version 2.0',...
         '2003',...
         [1 1 0],...
         titleFile,backgrFile,...
         logoFile,contentFile);
         

eclose
eview
