/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __HISTORY_TREE_VIEW_H__
#define __HISTORY_TREE_VIEW_H__

#include "server.h"

#include <gtkmm/treeview.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/liststore.h>
#include <gtkmm/menu.h>
#include "sigc++/sigc++.h"
using namespace sigc;
using namespace Gtk;


#include <string>
#include <vector>
using std::string;
using std::vector;

class string_vector;

/**
 * Class used to represent the tree-view widget for command history.
 */ 
class HistoryTreeView : public Gtk::TreeView
{
public:
  /**
   * Inner class used to represent each row in the tree-view.
   */
  class HistoryColumns : public Gtk::TreeModelColumnRecord 
  {
  public:                                       
    HistoryColumns()                      
    {                                     
      add(m_col_command);           
    }                                     

    Gtk::TreeModelColumn<Glib::ustring> m_col_command;  
  };

private:
   
  HistoryColumns* mHistory;
  Glib::RefPtr<Gtk::ListStore> mHistoryTreeModel;
  Glib::RefPtr<Gtk::TreeSelection> mHistoryTreeSelection;

  /**
   * Pointer to the pop-up menu used to cut, paste, and execute commands.
   */
  Gtk::Menu* mPopupMenu;

  /**
   * Method used to execute the current selection.
   */
  void executeSelection( void );

  /**
   * Method used to retrieve the current selection.
   */
  string getSelectionText( void );

public:

  /**
   * Default constructor.
   */
  HistoryTreeView(); 

  /**
   * Destructor.
   */
  ~HistoryTreeView(); 

  /**
   * Signal emitted when the execution menu option is selected in the pop-up menu.
   */
  sigc::signal<void, vector<string> > onCommandExecute;

  /**
   * Signal emitted when the copy menu option is selected in the pop-up menu.
   */
  sigc::signal<void> onCommandCopy;

  /**
   * Event handler for when a mouse button is clicked.
   */
  virtual bool on_button_press_event( GdkEventButton* evt );

  /** 
   * Event handler for when a keyboard key is pressed.
   */
  bool on_key_press_event( GdkEventKey* evt );

  /**
   * Event handler for a copy action.
   */
  void on_popup_menu_copy();

  /**
   * Event handler for an execute action.
   */
  void on_popup_menu_execute();

  /**
   * Event handler for a clear action.
   */
  void on_popup_menu_clear();

  /**
   * Method used to clear the tree-view.
   */
  void clearRows();

  /**
   * Method used to add a single command to the tree-view.
   */
  void addRow( string command );

  /**
   * Method used to add a vector of commands to the tree-view.
   */
  void addRows( vector<string> commands );

  /**
   * Method used to add an octave string_vector of commands to the tree-view.
   * (Redundant, but had problems with octave returning anything other than internal var type.)
   */
  void addRows( string_vector commands );

};

#endif // __HISTORY_TREE_VIEW_H__
