/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __VARIABLES_TREE_VIEW_H__
#define __VARIABLES_TREE_VIEW_H__

#include "server.h"

#include <gtkmm/treeview.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/liststore.h>
#include "sigc++/sigc++.h"
using namespace sigc;
using namespace Gtk;

#include <vector>
#include <string>
#include <sstream>
using std::vector;
using std::string;
using std::ostringstream;


class VariablesTreeView : public Gtk::TreeView
{
public:
  class VariablesColumns : public Gtk::TreeModelColumnRecord          
  {
  public:                                       
    VariablesColumns()                    
    {                                     
      add(m_col_name);              
      add(m_col_size);              
      add(m_col_bytes);             
      add(m_col_class);             

    }                                     

    Gtk::TreeModelColumn<Glib::ustring> m_col_name;     
    Gtk::TreeModelColumn<Glib::ustring> m_col_size;     
    Gtk::TreeModelColumn<Glib::ustring> m_col_bytes;    
    Gtk::TreeModelColumn<Glib::ustring> m_col_class;    
  };



private:
  VariablesColumns* mVariables;
  Glib::RefPtr<Gtk::ListStore> mVariablesTreeModel;

public:
  VariablesTreeView(); 

  ~VariablesTreeView(); 

  void clearRows(); 

  void addRow( vector<string> tokens );

  void addVariables( vector<variable_info_t>& variables );

  void on_row_activated( const TreeModel::Path& path, 
                         TreeViewColumn* column);

};

#endif // __VARIABLES_TREE_VIEW_H__
