## Copyright (C) 2005 Shai Ayal
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## OctPlot is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with OctPlot; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} @var{h}= __bar ([@var{x}],@var{y},[@var{width}],[@var{'color'}],@var{'callerFunc'})
##
## @end deftypefn
## @seealso{bar,barh,patch,area}

## Author: shaia


function h =__bar(varargin)

  # check number of input parameters
  error(nargchk(2,5,nargin));
  # last input argument must be the caller function, bar or barh
  strCallerFunc = varargin{end};

  ca = gca();
  if (isempty(ca))
    cla();
  elseif (strcmp(get(ca,"nextplot"),"replace")),
    cla();
  endif

  # default values
  width = 0.8;
  definedColor = 'r';
  
  # check input arguments
  if(nargin==2),
    y=varargin{1};
    if any(size(y)==1),
      x=1:length(y);
    else
      x=1:size(y,1);
    endif

  elseif(nargin==3)
    x=varargin{1};
    y=varargin{2};

  elseif(nargin==4)
    x=varargin{1};
    y=varargin{2};
    if (isnumeric(varargin{3}) & isscalar(varargin{3}))
      width=varargin{3};
    else
      # in this case, it must be a color definition
      definedColor = varargin{3};
      # check if a valid color is defined
      if ~iscolorspec(definedColor)
        disp('WARNING: Unknown color specification, will change color to "r".');
        definedColor = 'r';
      endif
    endif
  elseif(nargin==5)
    x=varargin{1};
    y=varargin{2};
    width=varargin{3};
    definedColor=varargin{4};
    # check if a valid color is defined
    if ~iscolorspec(definedColor)
       disp('WARNING: Unknown color specification, will change color to "r".');
       definedColor = 'r';
    endif
  endif

  dx = diff(x(:)');
  dx = [dx(1),dx,dx(end)];

  if(min(y)<0 & max(y)>0)
    draw_ax = 1;
  else
    draw_ax = 0;
  endif

  hh = [];
  if  strcmp(strCallerFunc,'barh')
  # horizontal bars
    for i=1:length(x),
      hh = [ hh , patch(\
	    [0,1,1,0]*y(i),
       [-dx(i) , -dx(i) , dx(i+1) , dx(i+1)]*width/2 + x(i)\
	    ,'FaceColor',definedColor) ];
    endfor
    if( draw_ax )
      line( [0,0],\
            [-dx(1)*width/2+x(1),dx(end)*width/2+x(end)],\
            "Color","k");
    endif
  else
  # vertical bars
    for i=1:length(x),
      hh = [ hh , patch(\
	    [-dx(i) , -dx(i) , dx(i+1) , dx(i+1)]*width/2 + x(i),\
	    [0,1,1,0]*y(i),'FaceColor',definedColor) ];
    endfor
    if( draw_ax )
      line( [-dx(1)*width/2+x(1),dx(end)*width/2+x(end)],\
            [0,0],\
            "Color","k");
    endif
  endif

  if nargout,
    h = hh;
  endif

endfunction
