// Copyright (C) 2001-3 Henry Maddocks
// 2005 Modified by Shai Ayal
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  


#include    <map>
#include    <string>

#include "FTGL/FTGLBitmapFont.h"
#include "FTGL/FTGLExtrdFont.h"
#include "FTGL/FTGLOutlineFont.h"
#include "FTGL/FTGLPixmapFont.h"
#include "FTGL/FTGLPolygonFont.h"
#include "FTGL/FTGLTextureFont.h"

//#define FontType FTGLPolygonFont
#define FontType FTGLTextureFont

//! this class makes sure that when we switch OpenGL context
//! the fonts will reload
class FontAndContext {
public:
  FontAndContext(FontType* fnt);
  ~FontAndContext() {delete _Font;}
  
  FontType* Font() {return _Font;}
  void* Context() {return _Context;}
private:
  FontType* _Font;
  void*     _Context;
};

typedef std::map< std::string, FontAndContext*> FontList;
typedef FontList::iterator FontIter;

class FTGLFontManager
{
public:
  static FTGLFontManager& Instance();
  ~FTGLFontManager()
  {
    FontIter font;
    for( font = fonts.begin(); font != fonts.end(); font++)
    {
      delete (*font).second;;
    }
    
    fonts.clear();
  }

  FontType* GetFont( const char *filename, int size);
        
private:
  // Hide these 'cause this is a singleton.
  FTGLFontManager(){}
  FTGLFontManager( const FTGLFontManager&){};
  FTGLFontManager& operator = ( const FTGLFontManager&){ return *this;};
        
  // container for fonts
  FontList fonts;
    
};
