// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  


#ifndef LINE_PLOTTER_H
#define LINE_PLOTTER_H

#include <stdio.h>
#include <math.h>
#include <FL/gl.h>
#include "globals.h"
#include "object.h"
#include "axes.h"

typedef std::map< std::string, GLuint> MarkerList;
typedef MarkerList::iterator MarkerIter;

class line_plotter {

public:
  typedef enum {face,edge} marker_part;
  static line_plotter& Instance();
  void plot(Matrix& xdata,
	    Matrix& ydata,
	    Radio&  linestyle,
	    Color*  color,
	    double  linewidth,
	    Color&  markerfacecolor,
	    Color&  markeredgecolor,
	    Radio&  marker,
	    double  markersize,
	    Axes*   axes,
	    bool    printing,
	    bool    loop=false,
	    bool    legend=false);
  GLuint make_marker(Radio& marker, marker_part prt);

private:
  MarkerList Markers;
  line_plotter() {};
  ~line_plotter() {};

  class plot_helper {
  public:
    plot_helper(double x,double y,double z,bool _loop) 
      : last_point(begin) , loop(_loop){add_point(x,y,z);}
      ~plot_helper() {
	if(loop) glVertex3dv(fp);
	glEnd();
      };
      void add_point(double x,double y,double z) {
        if(isnan(x) || isnan(y) || isnan(z)) {
          if(last_point==ok) {
            glEnd();
            last_point=nan;
          }
        }
        else {
          if(last_point==nan | last_point==begin)
	    glBegin(GL_LINE_STRIP);

	  if(last_point==begin) {
	    fp[0] = x;
	    fp[1] = y;
	    fp[2] = z;
	  }

          last_point = ok;
          glVertex3d(x,y,z);
        }
      };
  private:
    enum {ok,nan,begin} last_point;
    double fp[3];
    bool loop;
  };
};

#endif
