// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include <FL/gl.h>
#include "patch.h"
#include "axes.h"
#include "line_plotter.h"
#include "mathutils.h"

#define OBJ_NAME "Patch"

Patch::Patch(ocpl::Handle Parent, Matrix& XData, Matrix& YData) : Object(Parent)
{
  Properties["XData"]     = new Matrix(XData,1);
  Properties["YData"]     = new Matrix(YData,1);

  SET_TYPE;
  COPY_DEFAULT(FaceColor,ColorNone);
  COPY_DEFAULT(EdgeColor,ColorNone);
  COPY_DEFAULT(LineWidth,Scalar);
  COPY_DEFAULT(Clipping,Radio);
  COPY_DEFAULT(LineStyle,Radio);
  COPY_DEFAULT(Marker,Radio);
  COPY_DEFAULT(MarkerFaceColor,Color);
  COPY_DEFAULT(MarkerEdgeColor,Color);
  COPY_DEFAULT(MarkerSize,Scalar);
 
  //! 2D for now
  min[2] = ocpl::nan;
  max[2] = ocpl::nan;
  lmin[2] = ocpl::nan;
  lmax[2] = ocpl::nan;

  FindMinMax(XData,min[0],max[0],lmin[0],lmax[0],YData.len());
  FindMinMax(YData,min[1],max[1],lmin[1],lmax[1]);
  
}  

void Patch::draw()
{
  IS_VISIBLE;

  MAKE_REF(xdata,Matrix);
  MAKE_REF(ydata,Matrix);
  MAKE_REF(clipping,Radio);
  MAKE_REF(linestyle,Radio);
  MAKE_REF(edgecolor,ColorNone);
  MAKE_REF(facecolor,ColorNone);
  MAKE_REF(linewidth,Scalar);
  MAKE_REF(markerfacecolor,Color);
  MAKE_REF(markeredgecolor,Color);
  MAKE_REF(marker,Radio);
  MAKE_REF(markersize,Scalar);
  
  Axes* axes = dynamic_cast<Axes*>(FindParentOfType("axes"));
  Radio& xscale = ::Get<Radio>(axes,"xscale");
  Radio& yscale = ::Get<Radio>(axes,"yscale");

  SET_CLIPPING;

  line_plotter::Instance().plot(xdata,
				ydata,
				linestyle,
				&edgecolor,
				linewidth(),
				markerfacecolor,
				markeredgecolor,
				marker,
				markersize(),
				axes,
				printing,
				true);
 
  glBegin(GL_POLYGON);
  
  if(facecolor.SetColor()) {
    for(int i=0;i<ydata.nr()*ydata.nc();i++)
      glVertex3d(LOGIT(xdata(i),xscale()=="log"),
		 LOGIT(ydata(i),yscale()=="log"),
		 patch_z);
  }
  glEnd();
  
  UNSET_CLIPPING;
}

