// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "prop_handle.h"
#include "octplotapp.h"

void HandleVectNoOwn::AllDraw()
{
  for ( First() ; !IsDone() ; Next() )
    (OctPlotApp::GetObjectD(CurrentHandle()))->draw();
}

void HandleVectNoOwn::SetPrinting(bool set)
{
  for(First() ; !IsDone() ; Next() ) {
    (OctPlotApp::GetObjectD( CurrentHandle()))->SetPrinting(set);
  }
}

void HandleVect::Clear()
{
  for ( First() ; !IsDone() ; Next() )
    delete OctPlotApp::GetObjectD(CurrentHandle());

  HandleVectNoOwn::Clear();
}

void HandleVect::Delete(ocpl::Handle handle)
{
  Value.erase(handle);
  delete OctPlotApp::GetObjectD(handle);
}

void HandleVectNoOwn::Get(ocpl::command& com)
{
  ocpl::Real *val = new ocpl::Real[Value.size()];
  int i=0;
  for (First() ; !IsDone() ; Next() )
    val[i++] = CurrentHandle();
 
  com.argout(0,ocpl::real,Value.size(),1,reinterpret_cast<char*>(val),true);
}
void HandleVectNoOwn::Set(ocpl::command& com) 
{
   if(com.argin(2)->id != ocpl::real) {
    ret_error(com,"Value of property must be numerical");
    return;
  }

  Clear();

  for(int i=0;i<com.argin(2)->nc*com.argin(2)->nr;i++) {
    ocpl::Handle hnd = static_cast<ocpl::Handle>(
      (reinterpret_cast<double*>(com.argin(2)->data))[i]);
    if(GetObjectD(hnd)) 
      Add(hnd);
    else 
      ocpl::ret_error(com,"Handle Vector: no such handle");
  }
  com.init_argout(0);
}

