#!/bin/bash
#
# This script can be used to compile all the Samples using the currently
# installed (as reported by pkg-config) Ogre files. This is especially
# usefull to test the Debian packages, that do not include any Sample due
# to licensing problems.
#
# Just unpack Ogre sources (a "ogrenew" directory will be created), copy
# this script to the top-level directory (i.e., ogrenew) and then execute
# it in a bash shell. It is possible to specify exactly which samples to
# build on the command line. If no samples are specified this script will
# try to build them all.

compile() {
    pushd >/dev/null $1/src
    out=Common/bin/$(basename $1)
    fin="$(ls *.cpp)"
    echo -n "Compiling $fin to Samples/$out ... "
    gcc -o ../../$out *.cpp -I../../Common/include -I../include \
        $(pkg-config --cflags --libs $2) $3
    echo "done"
    popd >/dev/null
}

if [ -z "$1" ] ; then
    SAMPLES="$(find Samples -maxdepth 1 -type d)"
else
    for name in $* ; do
        SAMPLES="$SAMPLES Samples/$name"
    done
fi

for sample in $SAMPLES ; do
    case $(basename $sample) in
    
      CVS|Samples|Common|Media)
        # nothing to do
      ;;
      
      GTKDemo|HDRDemo)
        # simply don't build
      ;;
	
      Gui)
        #compile $sample "OGRE CEGUI" -lCEGUIBase
      ;;
      
      *)
        compile $sample OGRE
      ;;
    
    esac
done
