#include "config.h"

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif

#include "sniffer.h"

#include <stdlib.h>
#include <kapplication.h>
#include <kwin.h>

extern "C" {
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <ogle/dvdcontrol.h>
#include <ogle/msgevents.h>
}

Sniffer::Sniffer(OkleWin* ow,int m)
{
 w = ow;
 msgqid = m;

 DVDResult_t res;
 res = DVDOpenNav(&nav2,msgqid);
 if(res != DVD_E_Ok) 
  {
   DVDPerror("Sniffer::Sniffer(): DVDOpenNav",res);
   KApplication::exit(1);
  }

 res = DVDRequestInput(nav2,static_cast<InputMask_t>(INPUT_MASK_KeyPress | INPUT_MASK_ButtonPress | INPUT_MASK_PointerMotion));
 if(res != DVD_E_Ok)
  {
   DVDPerror("Sniffer::Sniffer(): DVDRequestInput",res);
   KApplication::exit(1);
  }
}

Sniffer::~Sniffer()
{}

void Sniffer::run()
{
 MsgEvent_t mev;
 DVDResult_t res;

 while(1) 
  {
   // FreeBSD needs this
   #if (defined(BSD) && (BSD >= 199306))
   if((res = DVDNextEventNonBlocking(nav2, &mev)) != DVD_E_Ok)
    {
     DVDPerror("Sniffer::run(): DVDNextEventNonBlocking", res);
     KApplication::exit(1);
    }
   #else
   if((res = DVDNextEvent(nav2, &mev)) != DVD_E_Ok)
    {
     DVDPerror("Sniffer::run(): DVDNextEvent", res);
     KApplication::exit(1);
    }
   #endif
   switch(mev.type) 
    {
     case MsgEventQInputPointerMotion:
      int x, y;
      x = mev.input.x;
      y = mev.input.y;
      DVDMouseSelect(nav2, x, y);
      break;
     case MsgEventQInputButtonPress:
      {
       switch(mev.input.input) 
        {
         case 0x1:
	  // left button
          int x, y;
          x = mev.input.x;
          y = mev.input.y;
          DVDMouseActivate(nav2, x, y);
	  if(w->isFullScreen())
	   w->setToTop(false);
	  break;
         case 0x2:
	  // middle button
          break;
         case 0x3:
	  // right button
	  if(w->isFullScreen())
	   if(w->isSetToTop())
	    w->setToTop(false);
	   else
	    w->setToTop(true);
          break;
        }
      }
     break;
     case MsgEventQInputKeyPress:
      {
       KeySym keysym;
       keysym = mev.input.input;
       // pass on keypresses to OkleWin
       if(w)
	w->keyPressed(static_cast<int>(keysym));
       default: break;
      }
    }
  }
}
